% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/GurobiOpts.R, R/ManualOpts.R,
%   R/RapData.R, R/RapReliableOpts.R, R/RapUnreliableOpts.R, R/RapSolved.R
\name{update}
\alias{update}
\alias{update.GurobiOpts}
\alias{update.ManualOpts}
\alias{update.RapData}
\alias{update.RapReliableOpts}
\alias{update.RapUnreliableOpts}
\alias{update.RapUnsolOrSol}
\title{Update object}
\usage{
\method{update}{GurobiOpts}(
  object,
  Threads = NULL,
  MIPGap = NULL,
  Method = NULL,
  Presolve = NULL,
  TimeLimit = NULL,
  NumberSolutions = NULL,
  MultipleSolutionsMethod = NULL,
  ...
)

\method{update}{ManualOpts}(object, NumberSolutions = NULL, ...)

\method{update}{RapData}(
  object,
  species = NULL,
  space = NULL,
  name = NULL,
  amount.target = NULL,
  space.target = NULL,
  pu = NULL,
  cost = NULL,
  status = NULL,
  ...
)

\method{update}{RapReliableOpts}(object, BLM = NULL, failure.multiplier = NULL, max.r.level = NULL, ...)

\method{update}{RapUnreliableOpts}(object, BLM = NULL, ...)

\method{update}{RapUnsolOrSol}(object, ..., formulation = NULL, solve = TRUE)
}
\arguments{
\item{object}{\code{\link[=GurobiOpts]{GurobiOpts()}}, \code{\link[=RapUnreliableOpts]{RapUnreliableOpts()}},
\code{\link[=RapReliableOpts]{RapReliableOpts()}}, \code{\link[=RapData]{RapData()}},
\code{\link[=RapUnsolved]{RapUnsolved()}}, or \code{\link[=RapSolved]{RapSolved()}} object.}

\item{Threads}{\code{integer} number of cores to use for processing.}

\item{MIPGap}{\code{numeric} MIP gap specifying minimum solution quality.}

\item{Method}{\code{integer} Algorithm to use for solving model.}

\item{Presolve}{\code{integer} code for level of computation in presolve.}

\item{TimeLimit}{\code{integer} number of seconds to allow for solving.}

\item{NumberSolutions}{\code{integer} number of solutions to generate.}

\item{MultipleSolutionsMethod}{\code{integer} name of method to obtain
multiple solutions (used when \code{NumberSolutions} is greater than one).
Available options are \code{"benders.cuts"}, \code{"solution.pool.0"},
\code{"solution.pool.1"}, and \code{"solution.pool.2"}. The
\code{"benders.cuts"} method produces a set of distinct solutions that
are all within the optimality gap. The \code{"solution.pool.0"}
method returns all solutions identified whilst trying to find
a solution that is within the specified optimality gap. The
\code{"solution.pool.1"} method finds one solution within the optimality
gap and a number of additional solutions that are of any level of quality
(such that the total number of solutions is equal to
\code{number_solutions}). The \code{"solution.pool.2"} finds a
specified number of solutions that are nearest to optimality. The
search pool methods correspond to the parameters used by the Gurobi
software suite (see \url{http://www.gurobi.com/documentation/8.0/refman/poolsearchmode.html#parameter:PoolSearchMode}).
Defaults to \code{"benders.cuts"}.}

\item{...}{parameters passed to \code{\link[=update.RapReliableOpts]{update.RapReliableOpts()}},
\code{\link[=update.RapUnreliableOpts]{update.RapUnreliableOpts()}}, or \code{\link[=update.RapData]{update.RapData()}}.}

\item{species}{\code{integer} or \code{character} denoting species for which
targets or name should be updated.}

\item{space}{\code{integer} denoting space for which targets should be
updated.}

\item{name}{\code{character} to rename species.}

\item{amount.target}{\code{numeric} vector for new area targets (\%) for the
specified species.}

\item{space.target}{\code{numeric} vector for new attribute space targets
(\%) for the specified species and attribute spaces.}

\item{pu}{\code{integer} planning unit indices that need to be updated.}

\item{cost}{\code{numeric} new costs for specified planning units.}

\item{status}{\code{integer} new statuses for specified planning units.}

\item{BLM}{\code{numeric} boundary length modifier.}

\item{failure.multiplier}{\code{numeric} multiplier for failure planning
unit.}

\item{max.r.level}{\code{numeric} maximum R failure level for approximation.}

\item{formulation}{\code{character} indicating new problem formulation to
use. This can be either "unreliable" or "reliable". The default is
\code{NULL} so that formulation in \code{object} is used.}

\item{solve}{\code{logical} should the problem be solved? This argument is
only valid for \code{\link[=RapUnsolved]{RapUnsolved()}} and \code{\link[=RapSolved]{RapSolved()}}
objects. Defaults to \code{TRUE}.}
}
\value{
\linkS4class{GurobiOpts},
\linkS4class{RapUnreliableOpts},
\linkS4class{RapReliableOpts}, \linkS4class{RapData},
\linkS4class{RapUnsolved}, or \linkS4class{RapSolved} object
depending on argument to \code{x}.
}
\description{
This function updates parameters or data stored in an existing
\code{\link[=GurobiOpts]{GurobiOpts()}}, \code{\link[=RapUnreliableOpts]{RapUnreliableOpts()}},
\code{\link[=RapReliableOpts]{RapReliableOpts()}}, \code{\link[=RapData]{RapData()}},
\code{\link[=RapUnsolved]{RapUnsolved()}}, or \code{\link[=RapSolved]{RapSolved()}} object.
}
\examples{
# load data
data(sim_ru, sim_rs)

# GurobiOpts
x <- GurobiOpts(MIPGap = 0.7)
y <- update(x, MIPGap = 0.1)
print(x)
print(y)

# RapUnreliableOpts
x <- RapUnreliableOpts(BLM = 10)
y <- update(x, BLM = 2)
print(x)
print(y)

# RapReliableOpts
x <- RapReliableOpts(failure.multiplier = 2)
y <- update(x, failure.multiplier = 4)
print(x)
print(y)

# RapData
x <- sim_ru@data
y <- update(x, space.target = c(0.4, 0.7, 0.1))
print(space.target(x))
print(space.target(y))

## RapUnsolved
x <- sim_ru
y <- update(x, amount.target = c(0.1, 0.2, 0.3), BLM = 3, solve = FALSE)
print(x@opts@BLM); print(amount.target(x))
print(y@opts@BLM); print(space.target(y))

## RapSolved
x <- sim_rs
y <- update(x, space.target = c(0.4, 0.6, 0.9), BLM = 100, Presolve = 1L,
            solve = FALSE)
print(x@opts@BLM); print(amount.target(x))
print(y@opts@BLM); print(space.target(y))
}
\seealso{
\linkS4class{GurobiOpts},
\linkS4class{RapUnreliableOpts},
\linkS4class{RapReliableOpts}, \linkS4class{RapData},
\linkS4class{RapUnsolved}, \linkS4class{RapSolved}.
}
