% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratifiedAnalysis.R
\name{analyse}
\alias{analyse}
\title{Creates stratified sequences
Compares stratified sequences to their respective non-stratified version under the influence of bias.}
\arguments{
\item{endp}{object of class \code{endpoint}.}

\item{pr}{at least one object of class \code{randPar} or just a list of objects of class \code{randPar}}
}
\value{
The function returns a matrix that summarizes the performance of the randomization procedures. The values for each randomization procedure represent the percentage of sequences that kept the 5% level under the influence of bias.
}
\description{
Creates stratified sequences
Compares stratified sequences to their respective non-stratified version under the influence of bias.
}
\details{
Stratified and Non-stratified versions of a randomization sequence behave differently with respect to issues like selection bias, chronological bias or combined bias.
The \code{analyse} function creates both versions of a sequence for each of the specified randomization procedures and analyses them in relation to the bias created according to the \code{theta} and \code{eta} values.
The first argument should specify the total sample size of patients. The second argument should be one of class \code{normEndp} describing a normally distributed endpoint.
The third argument should be the allocation ratio for the different strata. The fourth argument should be the number of strata in the clinical trial. The fifth and sixth arguments should be the selection bias effect eta and the time trend theta.
The seventh argument should be a vector of strings representing different randomization procedures. The strings should be given as described by the \code{getDesign} function. Any additional parameters should be given after the design name of the procedure encapsulated in parenthesis.
}
