% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpbrPar.R
\name{rpbrPar}
\alias{rpbrPar}
\title{Representing Randomized Permuted Block Randomization}
\usage{
rpbrPar(N, rb, K = 2, ratio = rep(1, K), groups = LETTERS[1:K],
  filledBlock = FALSE)
}
\arguments{
\item{N}{integer for the total sample size of the trial.}

\item{rb}{block lengths of the blocks that can be selected equiprobable at random.}

\item{K}{number of treatment groups (e.g. K=2 if we compare one experimental
against one control treatment).}

\item{ratio}{vector of length \code{K}. The total sample number \code{N} and
all used block lengths (\code{bc}) have to be divisible by \code{sum(ratio)}.}

\item{groups}{character vector of labels for the different treatments.}

\item{filledBlock}{\code{logical} whether the last block should be filled or not.}
}
\value{
\code{S4} object of the class \code{rpbrPar}.
}
\description{
Represents the randomization procedure Randomized Permuted Block Randomization.
}
\details{
Fix the possible random block lengths \code{rb}, the number of treatment groups \code{K},
the sample size \code{N} and the vector of the \code{ratio}. Afterwards, one block length is
randomly selected of the random block lengths. The patients are assigned
according to the ratio to the corresponding treatment groups. This procedure is repeated
until \code{N} patients are assigned. Within each block all possbible
randomization sequences are equiprobable.
}
\references{
W. F. Rosenberger and J. M. Lachin (2002) \emph{Randomization in Clinical Trials}.
Wiley.
}
\seealso{
Other randomization procedures: \code{\link{abcdPar}},
  \code{\link{bbcdPar}}, \code{\link{bsdPar}},
  \code{\link{chenPar}}, \code{\link{crPar}},
  \code{\link{createParam}}, \code{\link{ebcPar}},
  \code{\link{gbcdPar}}, \code{\link{hadaPar}},
  \code{\link{mpPar}}, \code{\link{pbrPar}},
  \code{\link{rarPar}}, \code{\link{rtbdPar}},
  \code{\link{tbdPar}}, \code{\link{udPar}}
}
