% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain_forest.R
\name{explain_forest}
\alias{explain_forest}
\title{Explain a random forest}
\usage{
explain_forest(forest, interactions = FALSE, data = NULL,
  vars = NULL, no_of_pred_plots = 3, pred_grid = 100,
  measures = NULL)
}
\arguments{
\item{forest}{A randomForest object created with the option localImp = TRUE}

\item{interactions}{Logical value: should variable interactions be considered (this may be time-consuming)}

\item{data}{The data frame on which forest was trained - necessary if interactions = TRUE}

\item{vars}{A character vector with variables with respect to which interactions will be considered if NULL then they will be selected using the important_variables() function}

\item{no_of_pred_plots}{The number of most frequent interactions of numeric variables to plot predictions for}

\item{pred_grid}{The number of points on the grid of plot_predict_interaction (decrease in case memory problems)}

\item{measures}{A character vector specifying the importance measures to be used for plotting ggpairs}
}
\value{
A html document in your working directory
}
\description{
Explains a random forest in a html document using plots created by randomForestExplainer
}
\examples{
\dontrun{
forest <- randomForest::randomForest(Species ~ ., data = iris, localImp = TRUE)
explain_forest(forest, interactions = TRUE)
}

}
