/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.variables.distributionTypes;

import eu.amidst.core.distribution.ConditionalDistribution;
import eu.amidst.core.distribution.UnivariateDistribution;
import eu.amidst.core.exponentialfamily.EF_BaseDistribution_MultinomialParents;
import eu.amidst.core.exponentialfamily.EF_ConditionalDistribution;
import eu.amidst.core.exponentialfamily.EF_SparseMultinomial;
import eu.amidst.core.utils.MultinomialIndex;
import eu.amidst.core.variables.DistributionType;
import eu.amidst.core.variables.DistributionTypeEnum;
import eu.amidst.core.variables.Variable;
import java.util.ArrayList;
import java.util.List;

public class SparseMultinomialType
extends DistributionType {
    public SparseMultinomialType(Variable var_) {
        super(var_);
    }

    @Override
    public boolean isParentCompatible(Variable parent) {
        return parent.getDistributionTypeEnum() == DistributionTypeEnum.MULTINOMIAL;
    }

    public UnivariateDistribution newUnivariateDistribution() {
        throw new UnsupportedOperationException("SparseMultinomial Parameter Type does not allow standard distributions");
    }

    public EF_SparseMultinomial newEFUnivariateDistribution() {
        return new EF_SparseMultinomial(this.variable);
    }

    @Override
    public <E extends ConditionalDistribution> E newConditionalDistribution(List<Variable> parents) {
        throw new UnsupportedOperationException("Sparse Multinomial Parameter Type does not allow conditional distributions");
    }

    @Override
    public <E extends EF_ConditionalDistribution> E newEFConditionalDistribution(List<Variable> parents) {
        if (!this.areParentsCompatible(parents)) {
            throw new IllegalArgumentException("Parents are not compatible");
        }
        if (parents.isEmpty()) {
            return (E)new EF_SparseMultinomial(this.variable);
        }
        ArrayList base_ef_dists = new ArrayList();
        int size = MultinomialIndex.getNumberOfPossibleAssignments(parents);
        for (int i = 0; i < size; ++i) {
            base_ef_dists.add(((DistributionType)this.variable.getDistributionType()).newEFUnivariateDistribution());
        }
        return (E)new EF_BaseDistribution_MultinomialParents(parents, base_ef_dists);
    }
}

