/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.utils;

import eu.amidst.core.exponentialfamily.MomentParameters;
import eu.amidst.core.exponentialfamily.NaturalParameters;
import eu.amidst.core.exponentialfamily.SufficientStatistics;
import eu.amidst.core.utils.CompoundVector;
import eu.amidst.core.utils.Vector;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class KeyCompoundVector<E>
implements MomentParameters,
NaturalParameters,
SufficientStatistics,
Serializable {
    private static final long serialVersionUID = -3436599636425587512L;
    int size = 0;
    Map<E, IndexedVector<E>> baseVectors = new HashMap<E, IndexedVector<E>>();

    public void addVector(E key, Vector vector) {
        this.baseVectors.put(key, new IndexedVector<E>(key, vector));
        this.size += vector.size();
    }

    public void setVectorByPosition(E key, Vector vec) {
        this.baseVectors.get(key).setVector(vec);
    }

    public Vector getVectorByPosition(E key) {
        return this.baseVectors.get(key).getVector();
    }

    @Override
    public double get(int i) {
        int total = 0;
        for (int j = 0; j < this.baseVectors.size(); ++j) {
            if (i < total + this.baseVectors.get(j).getVector().size()) {
                return this.baseVectors.get(j).getVector().get(i - total);
            }
            total += this.baseVectors.get(j).getVector().size();
        }
        return Double.NaN;
    }

    @Override
    public void set(int i, double val) {
        int total = 0;
        for (int j = 0; j < this.baseVectors.size(); ++j) {
            if (i < total + this.baseVectors.get(j).getVector().size()) {
                this.baseVectors.get(j).getVector().set(i - total, val);
                continue;
            }
            total += this.baseVectors.get(j).getVector().size();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void sum(Vector vector) {
        this.sum((CompoundVector)vector);
    }

    @Override
    public void copy(Vector vector) {
        this.copy((CompoundVector)vector);
    }

    @Override
    public void divideBy(double val) {
        this.baseVectors.values().stream().forEach(w -> w.getVector().divideBy(val));
    }

    @Override
    public double dotProduct(Vector vec) {
        return this.dotProduct((CompoundVector)vec);
    }

    public double dotProduct(KeyCompoundVector vec) {
        return this.baseVectors.values().stream().mapToDouble(w -> w.getVector().dotProduct(vec.getVectorByPosition(w.getIndex()))).sum();
    }

    public void copy(KeyCompoundVector vector) {
        if (vector.size() != this.size()) {
            throw new IllegalArgumentException("Error in variable Vector. Method copy. The parameter vec has a different size. ");
        }
        this.baseVectors.values().stream().forEach(w -> w.getVector().copy(vector.getVectorByPosition(w.getIndex())));
    }

    public void sum(KeyCompoundVector vector) {
        this.baseVectors.values().stream().forEach(w -> w.getVector().sum(vector.getVectorByPosition(w.getIndex())));
    }

    static class IndexedVector<E> {
        Vector vector;
        E index;

        IndexedVector(E index1, Vector vec1) {
            this.vector = vec1;
            this.index = index1;
        }

        public Vector getVector() {
            return this.vector;
        }

        public E getIndex() {
            return this.index;
        }

        public void setVector(Vector vector) {
            this.vector = vector;
        }
    }
}

