/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.utils;

import eu.amidst.core.exponentialfamily.MomentParameters;
import eu.amidst.core.exponentialfamily.NaturalParameters;
import eu.amidst.core.exponentialfamily.SufficientStatistics;
import eu.amidst.core.utils.Vector;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class CompoundVector
implements MomentParameters,
NaturalParameters,
SufficientStatistics,
Serializable {
    private static final long serialVersionUID = -3436599636425587512L;
    int size;
    List<IndexedVector> baseVectors;

    public CompoundVector(int nVectors, int size1) {
        this.baseVectors = new ArrayList<IndexedVector>(nVectors);
        this.size = size1;
        for (int i = 0; i < nVectors; ++i) {
            this.baseVectors.add(i, new IndexedVector(i, null));
        }
    }

    public CompoundVector(List<Vector> vectors) {
        this.baseVectors = new ArrayList<IndexedVector>(vectors.size());
        for (int i = 0; i < vectors.size(); ++i) {
            this.baseVectors.add(i, new IndexedVector(i, vectors.get(i)));
            this.size += vectors.get(i).size();
        }
    }

    public int getNumberOfBaseVectors() {
        return this.baseVectors.size();
    }

    public void setVectorByPosition(int position, Vector vec) {
        this.baseVectors.get(position).setVector(vec);
    }

    public Vector getVectorByPosition(int position) {
        return this.baseVectors.get(position).getVector();
    }

    public List<Vector> getVectors() {
        ArrayList<Vector> vectors = new ArrayList<Vector>();
        for (int i = 0; i < this.baseVectors.size(); ++i) {
            vectors.add(this.getVectorByPosition(i));
        }
        return vectors;
    }

    @Override
    public double get(int i) {
        int total = 0;
        for (int j = 0; j < this.baseVectors.size(); ++j) {
            if (i < total + this.baseVectors.get(j).getVector().size()) {
                return this.baseVectors.get(j).getVector().get(i - total);
            }
            total += this.baseVectors.get(j).getVector().size();
        }
        return Double.NaN;
    }

    @Override
    public void set(int i, double val) {
        int total = 0;
        for (int j = 0; j < this.baseVectors.size(); ++j) {
            if (i < total + this.baseVectors.get(j).getVector().size()) {
                this.baseVectors.get(j).getVector().set(i - total, val);
                return;
            }
            total += this.baseVectors.get(j).getVector().size();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void sum(Vector vector) {
        this.sum((CompoundVector)vector);
    }

    @Override
    public void substract(Vector vector) {
        this.substract((CompoundVector)vector);
    }

    @Override
    public void copy(Vector vector) {
        this.copy((CompoundVector)vector);
    }

    @Override
    public void divideBy(double val) {
        this.baseVectors.stream().forEach(w -> w.getVector().divideBy(val));
    }

    @Override
    public void multiplyBy(double val) {
        this.baseVectors.stream().forEach(w -> w.getVector().multiplyBy(val));
    }

    @Override
    public double dotProduct(Vector vec) {
        return this.dotProduct((CompoundVector)vec);
    }

    public double dotProduct(CompoundVector vec) {
        return this.baseVectors.stream().mapToDouble(w -> w.getVector().dotProduct(vec.getVectorByPosition(w.getIndex()))).sum();
    }

    public void copy(CompoundVector vector) {
        if (vector.size() != this.size()) {
            throw new IllegalArgumentException("Error in variable Vector. Method copy. The input parameter vector has a different size.");
        }
        this.baseVectors.stream().forEach(w -> w.getVector().copy(vector.getVectorByPosition(w.getIndex())));
    }

    public void sum(CompoundVector vector) {
        this.baseVectors.stream().forEach(w -> w.getVector().sum(vector.getVectorByPosition(w.getIndex())));
    }

    public void substract(CompoundVector vector) {
        this.baseVectors.stream().forEach(w -> w.getVector().substract(vector.getVectorByPosition(w.getIndex())));
    }

    static class IndexedVector
    implements Serializable {
        private static final long serialVersionUID = -3436599636425587512L;
        Vector vector;
        int index;

        IndexedVector(int index1, Vector vec1) {
            this.vector = vec1;
            this.index = index1;
        }

        public Vector getVector() {
            return this.vector;
        }

        public int getIndex() {
            return this.index;
        }

        public void setVector(Vector vector) {
            this.vector = vector;
        }
    }
}

