/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.learning.parametric.bayesian;

import eu.amidst.core.datastream.DataInstance;
import eu.amidst.core.datastream.DataOnMemory;
import eu.amidst.core.exponentialfamily.EF_TruncatedExponential;
import eu.amidst.core.exponentialfamily.MomentParameters;
import eu.amidst.core.inference.messagepassing.VMP;
import eu.amidst.core.io.BayesianNetworkLoader;
import eu.amidst.core.learning.parametric.bayesian.SVB;
import eu.amidst.core.models.BayesianNetwork;
import eu.amidst.core.utils.BayesianNetworkSampler;
import eu.amidst.core.utils.CompoundVector;
import eu.amidst.core.utils.Serialization;
import eu.amidst.core.variables.DistributionType;
import eu.amidst.core.variables.Variable;
import eu.amidst.core.variables.Variables;
import java.io.IOException;
import java.util.Map;
import java.util.Random;

public class DriftSVB
extends SVB {
    EF_TruncatedExponential ef_TExpP;
    EF_TruncatedExponential ef_TExpQ;
    Variable truncatedExpVar;
    boolean firstBatch = true;
    CompoundVector posteriorT_1 = null;
    CompoundVector prior = null;
    double delta = 0.1;

    public double getDelta() {
        return this.delta;
    }

    public void setDelta(double delta) {
        this.delta = delta;
    }

    @Override
    public void initLearning() {
        super.initLearning();
        this.truncatedExpVar = new Variables().newTruncatedExponential("TruncatedExponentialVar");
        this.ef_TExpP = (EF_TruncatedExponential)((DistributionType)this.truncatedExpVar.getDistributionType()).newEFUnivariateDistribution(this.getDelta());
        this.ef_TExpQ = (EF_TruncatedExponential)((DistributionType)this.truncatedExpVar.getDistributionType()).newEFUnivariateDistribution(this.getDelta());
        this.firstBatch = true;
        this.prior = this.plateuStructure.getPlateauNaturalParameterPrior();
    }

    @Override
    public BayesianNetwork getLearntBayesianNetwork() {
        CompoundVector prior = this.plateuStructure.getPlateauNaturalParameterPrior();
        this.updateNaturalParameterPrior(this.plateuStructure.getPlateauNaturalParameterPosterior());
        BayesianNetwork learntBN = new BayesianNetwork(this.dag, this.ef_extendedBN.toConditionalDistribution());
        this.updateNaturalParameterPrior(prior);
        return learntBN;
    }

    public double updateModelWithConceptDrift(DataOnMemory<DataInstance> batch) {
        System.out.println("SAMPLE:" + this.plateuStructure.getPosteriorSampleSize());
        this.plateuStructure.setEvidence(batch.getList());
        if (this.firstBatch) {
            this.firstBatch = false;
            this.plateuStructure.runInference();
            this.posteriorT_1 = this.plateuStructure.getPlateauNaturalParameterPosterior();
            this.plateuStructure.updateNaturalParameterPrior(this.posteriorT_1);
            return this.plateuStructure.getLogProbabilityOfEvidence();
        }
        double delta = -1.0;
        this.ef_TExpP.getNaturalParameters().set(0, delta);
        this.ef_TExpP.updateMomentFromNaturalParameters();
        this.ef_TExpQ.getNaturalParameters().set(0, delta);
        this.ef_TExpQ.updateMomentFromNaturalParameters();
        this.plateuStructure.getVMP().setMaxIter(1);
        boolean convergence = false;
        double elbo = Double.NaN;
        for (double niter = 0.0; !convergence && niter < 10.0; niter += 1.0) {
            double lambda = this.ef_TExpQ.getMomentParameters().get(0);
            CompoundVector newPrior = Serialization.deepCopy(this.prior);
            newPrior.multiplyBy(1.0 - lambda);
            CompoundVector newPosterior = Serialization.deepCopy(this.posteriorT_1);
            newPosterior.multiplyBy(lambda);
            newPrior.sum(newPosterior);
            this.plateuStructure.updateNaturalParameterPrior(newPrior);
            this.plateuStructure.runInference();
            CompoundVector updatedPosterior = this.plateuStructure.getPlateauNaturalParameterPosterior();
            double newELBO = this.plateuStructure.getLogProbabilityOfEvidence();
            this.plateuStructure.updateNaturalParameterPrior(this.prior);
            double kl_q_p0 = this.plateuStructure.getNonReplictedNodes().mapToDouble(node -> {
                Map<Variable, MomentParameters> momentParents = node.getMomentParents();
                return node.getQDist().kl(node.getPDist().getExpectedNaturalFromParents(momentParents), node.getPDist().getExpectedLogNormalizer(momentParents));
            }).sum();
            this.plateuStructure.updateNaturalParameterPrior(this.posteriorT_1);
            double kl_q_pt_1 = this.plateuStructure.getNonReplictedNodes().mapToDouble(node -> {
                Map<Variable, MomentParameters> momentParents = node.getMomentParents();
                return node.getQDist().kl(node.getPDist().getExpectedNaturalFromParents(momentParents), node.getPDist().getExpectedLogNormalizer(momentParents));
            }).sum();
            this.ef_TExpQ.getNaturalParameters().set(0, -kl_q_pt_1 + kl_q_p0 + this.ef_TExpP.getNaturalParameters().get(0));
            this.ef_TExpQ.fixNumericalInstability();
            this.ef_TExpQ.updateMomentFromNaturalParameters();
            newELBO -= this.ef_TExpQ.kl(this.ef_TExpP.getNaturalParameters(), this.ef_TExpP.computeLogNormalizer());
            if (!Double.isNaN(elbo) && newELBO < elbo) {
                new IllegalStateException("Non increasing lower bound: " + newELBO + " < " + elbo);
            }
            double percentageIncrease = 100.0 * Math.abs((newELBO - elbo) / elbo);
            if (!Double.isNaN(elbo) && percentageIncrease < 1.0E-4) {
                convergence = true;
            }
            elbo = newELBO;
        }
        this.posteriorT_1 = this.plateuStructure.getPlateauNaturalParameterPosterior();
        this.plateuStructure.updateNaturalParameterPrior(this.posteriorT_1);
        return elbo;
    }

    public double getLambdaValue() {
        return this.ef_TExpQ.getMomentParameters().get(0);
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        BayesianNetwork oneNormalVarBN = BayesianNetworkLoader.loadFromFile("./networks/simulated/Normal.bn");
        System.out.println(oneNormalVarBN);
        int batchSize = 1000;
        DriftSVB svb = new DriftSVB();
        svb.setWindowsSize(batchSize);
        svb.setSeed(0);
        VMP vmp = svb.getPlateuStructure().getVMP();
        vmp.setOutput(false);
        vmp.setTestELBO(true);
        vmp.setMaxIter(1000);
        vmp.setThreshold(1.0E-4);
        svb.setDAG(oneNormalVarBN.getDAG());
        svb.initLearning();
        double pred = 0.0;
        for (int i = 0; i < 10; ++i) {
            if (i % 3 == 0) {
                oneNormalVarBN.randomInitialization(new Random(i));
                System.out.println(oneNormalVarBN);
            }
            BayesianNetworkSampler sampler = new BayesianNetworkSampler(oneNormalVarBN);
            sampler.setSeed(i);
            DataOnMemory<DataInstance> batch = sampler.sampleToDataStream(batchSize).toDataOnMemory();
            if (i > 0) {
                pred += svb.predictedLogLikelihood(batch);
            }
            svb.updateModelWithConceptDrift(batch);
            System.out.println(svb.getLogMarginalProbability());
            System.out.println(svb.getLearntBayesianNetwork());
        }
        System.out.println(pred);
    }
}

