/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.exponentialfamily;

import eu.amidst.core.distribution.ConditionalDistribution;
import eu.amidst.core.distribution.ConditionalLinearGaussian;
import eu.amidst.core.exponentialfamily.EF_ConditionalDistribution;
import eu.amidst.core.exponentialfamily.EF_Normal;
import eu.amidst.core.exponentialfamily.EF_NormalParameter;
import eu.amidst.core.exponentialfamily.MomentParameters;
import eu.amidst.core.exponentialfamily.NaturalParameters;
import eu.amidst.core.exponentialfamily.SufficientStatistics;
import eu.amidst.core.utils.ArrayVector;
import eu.amidst.core.utils.Vector;
import eu.amidst.core.variables.Assignment;
import eu.amidst.core.variables.Variable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EF_Normal_Normal_Gamma
extends EF_ConditionalDistribution {
    int nOfParents;
    List<Variable> realYVariables;
    List<Variable> betasVariables;
    Variable beta0Variable;
    Variable gammaVariable;

    public EF_Normal_Normal_Gamma(Variable var_, List<Variable> parents_, Variable beta0, List<Variable> betas_, Variable gamma) {
        this.var = var_;
        this.realYVariables = parents_;
        this.betasVariables = betas_;
        this.beta0Variable = beta0;
        this.gammaVariable = gamma;
        this.parents = new ArrayList();
        this.parents.addAll(parents_);
        this.parents.addAll(betas_);
        this.parents.add(beta0);
        this.parents.add(this.gammaVariable);
        if (!var_.isNormal()) {
            throw new UnsupportedOperationException("Creating a Normal_Normal-Gamma EF distribution for a non-gaussian child variable.");
        }
        for (Variable v : this.realYVariables) {
            if (v.isNormal()) continue;
            throw new UnsupportedOperationException("Creating a Normal_Normal-Gamma EF distribution for a non-gaussian parent variable.");
        }
        for (Variable v : this.betasVariables) {
            if (v.isNormalParameter()) continue;
            throw new UnsupportedOperationException("Creating a Normal_Normal-Gamma EF distribution for a non-gaussian parent variable.");
        }
        if (!this.beta0Variable.isNormalParameter()) {
            throw new UnsupportedOperationException("Creating a Normal_Normal-Gamma EF distribution for a non-gaussian parent variable.");
        }
        if (!this.gammaVariable.isGammaParameter()) {
            throw new UnsupportedOperationException("Creating a Normal_Normal-Gamma EF distribution for a non-gamma parent variable.");
        }
        this.nOfParents = this.parents.size();
    }

    @Override
    public double getExpectedLogNormalizer(Map<Variable, MomentParameters> momentParents) {
        int nOfBetas = this.betasVariables.size();
        double dotProductBetaY = 0.0;
        double sumSquaredMoments = 0.0;
        double sumSquaredMeanMoments = 0.0;
        for (int i = 0; i < nOfBetas; ++i) {
            dotProductBetaY += momentParents.get(this.realYVariables.get(i)).get(0) * momentParents.get(this.betasVariables.get(i)).get(0);
            sumSquaredMoments += momentParents.get(this.betasVariables.get(i)).get(1) * momentParents.get(this.realYVariables.get(i)).get(1);
            sumSquaredMeanMoments += Math.pow(momentParents.get(this.betasVariables.get(i)).get(0) * momentParents.get(this.realYVariables.get(i)).get(0), 2.0);
        }
        double beta0 = momentParents.get(this.beta0Variable).get(0);
        double beta0Squared = momentParents.get(this.beta0Variable).get(1);
        double invVariance = momentParents.get(this.gammaVariable).get(1);
        double logVar = momentParents.get(this.gammaVariable).get(0);
        return -0.5 * logVar + 0.5 * invVariance * (beta0Squared + dotProductBetaY * dotProductBetaY - sumSquaredMeanMoments + sumSquaredMoments + 2.0 * beta0 * dotProductBetaY);
    }

    @Override
    public NaturalParameters getExpectedNaturalFromParents(Map<Variable, MomentParameters> momentParents) {
        int nOfBetas = this.betasVariables.size();
        double dotProductBetaY = 0.0;
        for (int i = 0; i < nOfBetas; ++i) {
            dotProductBetaY += momentParents.get(this.realYVariables.get(i)).get(0) * momentParents.get(this.betasVariables.get(i)).get(0);
        }
        double beta0 = momentParents.get(this.beta0Variable).get(0);
        double invVariance = momentParents.get(this.gammaVariable).get(1);
        EF_Normal.ArrayVectorParameter naturalParameters = new EF_Normal.ArrayVectorParameter(2);
        naturalParameters.set(0, beta0 + dotProductBetaY);
        naturalParameters.set(1, invVariance);
        return naturalParameters;
    }

    @Override
    public NaturalParameters getExpectedNaturalToParent(Variable parent, Map<Variable, MomentParameters> momentChildCoParents) {
        SufficientStatistics naturalParameters = new ArrayVector(2);
        int nOfBetas = this.betasVariables.size();
        double dotProductBetaY = 0.0;
        for (int i = 0; i < nOfBetas; ++i) {
            dotProductBetaY += momentChildCoParents.get(this.realYVariables.get(i)).get(0) * momentChildCoParents.get(this.betasVariables.get(i)).get(0);
        }
        double beta0 = momentChildCoParents.get(this.beta0Variable).get(0);
        double invVariance = momentChildCoParents.get(this.gammaVariable).get(1);
        double X = momentChildCoParents.get(this.var).get(0);
        if (this.realYVariables.contains(parent)) {
            int parentID = this.realYVariables.indexOf(parent);
            double beta_iSquared = momentChildCoParents.get(this.betasVariables.get(parentID)).get(1);
            double beta_i = momentChildCoParents.get(this.betasVariables.get(parentID)).get(0);
            double Y_i = momentChildCoParents.get(this.realYVariables.get(parentID)).get(0);
            double factor = beta_i / beta_iSquared;
            double mean = factor * (-beta0 + X - (dotProductBetaY - beta_i * Y_i));
            double precision = beta_iSquared * invVariance;
            naturalParameters = new EF_Normal.ArrayVectorParameter(2);
            naturalParameters.set(0, mean);
            naturalParameters.set(1, precision);
        } else if (this.betasVariables.contains(parent)) {
            int parentID = this.betasVariables.indexOf(parent);
            double Y_iSquared = momentChildCoParents.get(this.realYVariables.get(parentID)).get(1);
            double beta_i = momentChildCoParents.get(this.betasVariables.get(parentID)).get(0);
            double Y_i = momentChildCoParents.get(this.realYVariables.get(parentID)).get(0);
            if (Y_iSquared != 0.0) {
                double factor = Y_i / Y_iSquared;
                double mean = factor * (-beta0 + X - (dotProductBetaY - beta_i * Y_i));
                double precision = Y_iSquared * invVariance;
                naturalParameters = new EF_NormalParameter.ArrayVectorParameter(2);
                naturalParameters.set(0, mean);
                naturalParameters.set(1, precision);
            } else {
                naturalParameters = new EF_NormalParameter.ArrayVectorParameter(2);
                naturalParameters.set(0, -beta0 + X - (dotProductBetaY - beta_i * Y_i));
                naturalParameters.set(1, 0.0);
            }
        } else if (this.beta0Variable == parent) {
            naturalParameters = new EF_NormalParameter.ArrayVectorParameter(2);
            naturalParameters.set(0, X - dotProductBetaY);
            naturalParameters.set(1, invVariance);
        } else if (this.gammaVariable == parent) {
            double Xsquared = momentChildCoParents.get(this.var).get(1);
            double beta0Squared = momentChildCoParents.get(this.beta0Variable).get(1);
            double sumSquaredMoments = 0.0;
            double sumSquaredMeanMoments = 0.0;
            for (int i = 0; i < nOfBetas; ++i) {
                sumSquaredMoments += momentChildCoParents.get(this.betasVariables.get(i)).get(1) * momentChildCoParents.get(this.realYVariables.get(i)).get(1);
                sumSquaredMeanMoments += Math.pow(momentChildCoParents.get(this.betasVariables.get(i)).get(0) * momentChildCoParents.get(this.realYVariables.get(i)).get(0), 2.0);
            }
            naturalParameters.set(0, 0.5);
            naturalParameters.set(1, -0.5 * (Xsquared + beta0Squared + dotProductBetaY * dotProductBetaY - sumSquaredMeanMoments + sumSquaredMoments - 2.0 * X * dotProductBetaY - 2.0 * X * beta0 + 2.0 * beta0 * dotProductBetaY));
            if (naturalParameters.get(1) > 0.0) {
                throw new IllegalStateException("Numerical Instability: Positive Number");
            }
        } else {
            throw new IllegalArgumentException("Error");
        }
        return naturalParameters;
    }

    @Override
    public double getExpectedLogNormalizer(Variable parent, Map<Variable, MomentParameters> momentChildCoParents) {
        throw new UnsupportedOperationException("No Implemented. This method is no really needed");
    }

    @Override
    public <E extends ConditionalDistribution> E toConditionalDistribution() {
        return null;
    }

    @Override
    public void updateNaturalFromMomentParameters() {
        throw new UnsupportedOperationException("No Implemented. NormalInverseGamma distribution should only be used for learning, use EF_Normal_NormalParents for inference.");
    }

    @Override
    public void updateMomentFromNaturalParameters() {
        throw new UnsupportedOperationException("No Implemented. NormalInverseGamma distribution should only be used for learning, use EF_Normal_NormalParents for inference.");
    }

    @Override
    public SufficientStatistics getSufficientStatistics(Assignment data) {
        throw new UnsupportedOperationException("No Implemented. NormalInverseGamma distribution should only be used for learning, use EF_Normal_NormalParents for inference.");
    }

    @Override
    public int sizeOfSufficientStatistics() {
        return 0;
    }

    @Override
    public double computeLogBaseMeasure(Assignment dataInstance) {
        return -0.5 * Math.log(Math.PI * 2);
    }

    @Override
    public double computeLogNormalizer() {
        throw new UnsupportedOperationException("No Implemented. NormalInverseGamma distribution should only be used for learning, use EF_Normal_NormalParents for inference.");
    }

    @Override
    public Vector createZeroVector() {
        throw new UnsupportedOperationException("No Implemented. NormalInverseGamma distribution should only be used for learning, use EF_Normal_NormalParents for inference.");
    }

    @Override
    public SufficientStatistics createInitSufficientStatistics() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConditionalDistribution toConditionalDistribution(Map<Variable, Vector> expectedValueParameterVariables) {
        ConditionalLinearGaussian dist = new ConditionalLinearGaussian(this.var, this.realYVariables);
        double[] coeffParameters = new double[this.realYVariables.size()];
        for (int i = 0; i < this.realYVariables.size(); ++i) {
            coeffParameters[i] = expectedValueParameterVariables.get(this.betasVariables.get(i)).get(0);
        }
        dist.setCoeffParents(coeffParameters);
        dist.setIntercept(expectedValueParameterVariables.get(this.beta0Variable).get(0));
        dist.setVariance(1.0 / expectedValueParameterVariables.get(this.gammaVariable).get(0));
        return dist;
    }
}

