% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/authenticate.R
\name{td_auth_loginURL}
\alias{td_auth_loginURL}
\title{Auth Step 1: Generate LogIn URL}
\usage{
td_auth_loginURL(consumerKey, callbackURL)
}
\arguments{
\item{consumerKey}{TD generated Consumer key for the registered TD app.
Essentially an API key.}

\item{callbackURL}{User generated Callback URL for the registered TD app}
}
\value{
login url to grant app permission to TD Brokerage account
}
\description{
Create URL to grant App access to a TD Brokerage account
}
\details{
To use the TD Ameritrade API, both a TD Brokerage account and a registered
developer app are required. The developer app functions as a middle layer
between the brokerage account and the API. A developer app should be
registered on the \href{https://developer.tdameritrade.com/}{TD Ameritrade
Developer} site. Once logged in to the developer site, use My Apps to
register an application. An App will have a Consumer Key provided by TD that
functions as an API key. The Consumer Key is auto generated and can be found
under My Apps > Keys. The user must also create a Callback URL. The Callback
URL can be anything. The example below assumes the Callback URL is
https://myTDapp.

This function will use these two inputs to generate a URL where the user can
log in to their standard TD Ameritrade Brokerage Account and grant the
application access to the brokerage account, enabling the API. The
Authorization Code generated at the end of the log in process will feed into
\code{\link{td_auth_refreshToken}}. For questions, please reference the
\href{https://developer.tdameritrade.com/content/authentication-faq}{TD
Ameritrade Authentication FAQ} or see the examples in the rameritrade readme.
If the callback URL uses punctuation, numbers, or an IP (e.g. 127.0.0.0.1),
the output of this function may not work. Please reference the TD
documentation to create the appropriate URL.
}
\examples{
\dontrun{

# Visit the URL generated from the function below to log in to a TD Brokerage account
# Once a successful log in is completed the landing page will be a blank page
# The full URL of the landing page is the Authorization Code for td_auth_refreshToken

loginURL = td_auth_loginURL('https://myTDapp','consumerKey')

}
}
\seealso{
\code{\link{td_auth_loginURL}} to generate a login url which leads
  to an authorization code, \code{\link{td_auth_refreshToken}} to generate a
  Refresh Token using an existing Refresh Token or an authorization code with
  a callback URL when loggin in manually,  \code{\link{td_auth_accessToken}}
  to generate a new Access Token
}
