% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdm_as_asc.R
\name{sdm_as_asc}
\alias{sdm_as_asc}
\title{Raster conversion functions}
\usage{
sdm_as_asc(x, xll = 1, yll = 1, cellsize = 1)
}
\arguments{
\item{x}{is an object of class 'matrix'}

\item{xll}{is the lat center (not corner!) of lower-left grid}

\item{yll}{is the lon center (not corner!) of lower-left grid}

\item{cellsize}{is the resolution of the raster in decimal degrees}
}
\value{
Returns an object of class 'asc'.
}
\description{
Raster conversion functions
}
\details{
\code{sdm_as_asc} is an adaptation of \code{as.asc} from
SDMTools; extracts data from objects of class 'RasterLayer' (raster package)
into an object of class 'asc'.
}
\examples{
\dontrun{
#create a simple object of class 'asc'
tasc = sdm_as_asc(matrix(rep(x=1:10, times=1000),nr=100)); print(tasc)
str(tasc)
}
}
\author{
Gopi Goteti
}
