# Radiant - Business analytics using R and Shiny


## Introduction to Radiant

<iframe width="640" height="375" src="https://www.youtube.com/embed/7L3hDpLw53I" frameborder="0" allowfullscreen></iframe>

## Installing Radiant

The first step is to install R. For mac go to <a href="https://cran.r-project.org/bin/macosx/" target="_blank">https://cran.r-project.org/bin/macosx/</a>. For windows get the latest release from <a href="https://cran.r-project.org/bin/windows/base/release.htm" target="_blank">https://cran.r-project.org/bin/windows/base/release.htm</a>

> **Important:** Windows users **must** install R in directory C:\\R\\R-3.3.4

To automate the remaining steps in the install process open R and copy-and-paste the command below, press return, and accept all default settings during the install process:

```r
source("https://raw.githubusercontent.com/radiant-rstats/minicran/gh-pages/install.R")
```

For a step-by-step tutorial see the `Install Radiant on Windows` or `Install Radiant on Mac` video:

**Install Radiant on Windows**

<iframe width="640" height="375" src="https://www.youtube.com/embed/efQM6WqrHG0" frameborder="0" allowfullscreen></iframe>

**Install Radiant on Mac**

<iframe width="640" height="375" src="https://www.youtube.com/embed/WheqHpobMZg" frameborder="0" allowfullscreen></iframe>

## Starting and stopping

<iframe width="640" height="375" src="https://www.youtube.com/embed/rNPnnqJhmD4" frameborder="0" allowfullscreen></iframe>

## Getting help

<iframe width="640" height="375" src="https://www.youtube.com/embed/9qAQio9Hb7k" frameborder="0" allowfullscreen></iframe>

## Getting data in and out

<iframe width="640" height="375" src="https://www.youtube.com/embed/PuoMc1x4MD8" frameborder="0" allowfullscreen></iframe>

## Fast and efficient analysis

<iframe width="640" height="375" src="https://www.youtube.com/embed/wtHIz-umoME" frameborder="0" allowfullscreen></iframe>

## Reproducible analysis

<iframe width="640" height="375" src="https://www.youtube.com/embed/o32VNc7EZUM" frameborder="0" allowfullscreen></iframe>

## Using Radiant for Model Evaluation

The state file used in the demo is available for download from [GitHub](https://radiant-rstats.github.io/docs/examples/demo-state2-dvd-rnd.rda) 

<iframe width="640" height="375" src="https://www.youtube.com/embed/9fugq5dXNhk" frameborder="0" allowfullscreen></iframe>

<!--
## Visualizing data

<iframe width="640" height="375" src="" frameborder="0" allowfullscreen></iframe>

-->

## License


Radiant is licensed under the <a href="https://tldrlegal.com/license/gnu-affero-general-public-license-v3-(agpl-3.0)" target="\_blank">AGPLv3</a>. The documentation and videos on this site as well as the Radiant help files are licensed under the creative commons attribution, non-commercial, share-alike license <a href="https://creativecommons.org/licenses/by-nc-sa/4.0/" target="_blank">CC-NC-SA</a>.

As a summary, the AGPLv3 license requires, attribution, including copyright and license information in copies of the software, stating changes if the code is modified, and disclosure of all source code. Details are in the COPYING file.

If you are interested in using Radiant please email me at radiant@rady.ucsd.edu

&copy; Vincent Nijs (2017) <a rel="license" href="https://creativecommons.org/licenses/by-nc-sa/4.0/" target="_blank"><img alt="Creative Commons License" style="border-width:0" src="imgs/80x15.png" /></a>
