/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.python.core.ArgParser;
import org.python.core.MergeState;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyFastSequenceIter;
import org.python.core.PyList$PyExposer;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PySequenceList;
import org.python.core.PySlice;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.ThreadState;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExposedType(name="list", base=PyObject.class)
public class PyList
extends PySequenceList {
    public static final PyType TYPE;

    public PyList() {
        this(TYPE, Py.EmptyObjects);
    }

    public PyList(PyType type) {
        super(type);
    }

    public PyList(PyType type, PyObject[] elements) {
        super(type, elements);
    }

    public PyList(PyType type, Collection c) {
        super(type, c);
    }

    public PyList(PyObject[] elements) {
        this(TYPE, elements);
    }

    public PyList(Collection c) {
        super(TYPE, c);
    }

    public PyList(PyObject o) {
        this(TYPE);
        for (PyObject item : o.asIterable()) {
            this.append(item);
        }
    }

    private static List<PyObject> listify(Iterator<PyObject> iter) {
        LinkedList<PyObject> list = new LinkedList<PyObject>();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public PyList(Iterator<PyObject> iter) {
        this(TYPE, PyList.listify(iter));
    }

    @ExposedNew
    final void list___init__(PyObject[] args, String[] kwds) {
        ArgParser ap = new ArgParser("list", args, kwds, new String[]{"sequence"}, 0);
        PyObject seq = ap.getPyObject(0, null);
        this.clear();
        if (seq == null) {
            return;
        }
        if (seq instanceof PySequenceList) {
            PySequenceList p = (PySequenceList)seq.__getslice__(Py.None, Py.None, Py.One);
            this.list = p.list;
        } else {
            for (PyObject item : seq.asIterable()) {
                this.append(item);
            }
        }
    }

    @Override
    public int __len__() {
        return this.list___len__();
    }

    final int list___len__() {
        return this.size();
    }

    @Override
    protected PyObject getslice(int start, int stop, int step) {
        if (step > 0 && stop < start) {
            stop = start;
        }
        int n = PyList.sliceLength(start, stop, step);
        PyObject[] newList = new PyObject[n];
        PyObject[] array = this.getArray();
        if (step == 1) {
            System.arraycopy(array, start, newList, 0, stop - start);
            return new PyList(newList);
        }
        int j = 0;
        int i = start;
        while (j < n) {
            newList[j] = array[i];
            ++j;
            i += step;
        }
        return new PyList(newList);
    }

    @Override
    protected void del(int i) {
        this.remove(i);
    }

    @Override
    protected void delRange(int start, int stop) {
        this.remove(start, stop);
    }

    @Override
    protected void setslice(int start, int stop, int step, PyObject value) {
        if (stop < start) {
            stop = start;
        }
        if (value instanceof PySequence) {
            PySequence sequence = (PySequence)value;
            this.setslicePySequence(start, stop, step, sequence);
        } else if (value instanceof List) {
            List list = (List)value.__tojava__(List.class);
            if (list != null && list != Py.NoConversion) {
                this.setsliceList(start, stop, step, list);
            }
        } else {
            this.setsliceIterable(start, stop, step, value);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void setslicePySequence(int start, int stop, int step, PySequence value) {
        if (step == 1) {
            void otherArray;
            PyObject[] pyObjectArray = this.getArray();
            int array = value.__len__();
            PyObject[] n = value instanceof PySequenceList ? ((PySequenceList)value).getArray() : Py.unpackSequence(value, value.__len__());
            if (n == otherArray) {
                n = (PyObject[])n.clone();
            }
            this.list.replaceSubArray(start, stop, n, 0, array);
        } else if (step != 0) {
            void j;
            if (value == this) {
                void item;
                PyList n = new PyList();
                PyObject newseq = value.__iter__();
                PyObject iter = null;
                while ((iter = newseq.__iternext__()) != null) {
                    item.append(iter);
                }
                value = item;
            }
            int item = value.__len__();
            int n = 0;
            int i = start;
            while (n < j) {
                this.list.pyset(i, value.pyget(n));
                ++n;
                i += step;
            }
        }
    }

    protected void setsliceList(int start, int stop, int step, List value) {
        if (step != 1) {
            throw Py.TypeError("setslice with java.util.List and step != 1 not supported yet");
        }
        int n = value.size();
        this.list.ensureCapacity(start + n);
        for (int i = 0; i < n; ++i) {
            this.list.add(i + start, value.get(i));
        }
    }

    protected void setsliceIterable(int start, int stop, int step, PyObject value) {
        PyObject[] seq;
        try {
            seq = Py.make_array(value);
        }
        catch (PyException pye) {
            if (Py.matchException(pye, Py.TypeError)) {
                throw Py.TypeError("can only assign an iterable");
            }
            throw pye;
        }
        this.setslicePySequence(start, stop, step, new PyList(seq));
    }

    @Override
    protected PyObject repeat(int count) {
        if (count < 0) {
            count = 0;
        }
        int size = this.size();
        int newSize = size * count;
        if (count != 0 && newSize / count != size) {
            throw Py.MemoryError("");
        }
        PyObject[] array = this.getArray();
        PyObject[] newArray = new PyObject[newSize];
        for (int i = 0; i < count; ++i) {
            System.arraycopy(array, 0, newArray, i * size, size);
        }
        return new PyList(newArray);
    }

    final PyObject list___ne__(PyObject o) {
        return this.seq___ne__(o);
    }

    final PyObject list___eq__(PyObject o) {
        return this.seq___eq__(o);
    }

    final PyObject list___lt__(PyObject o) {
        return this.seq___lt__(o);
    }

    final PyObject list___le__(PyObject o) {
        return this.seq___le__(o);
    }

    final PyObject list___gt__(PyObject o) {
        return this.seq___gt__(o);
    }

    final PyObject list___ge__(PyObject o) {
        return this.seq___ge__(o);
    }

    @Override
    public PyObject __imul__(PyObject o) {
        return this.list___imul__(o);
    }

    final PyObject list___imul__(PyObject o) {
        if (!o.isIndex()) {
            return null;
        }
        int count = o.asIndex(Py.OverflowError);
        int size = this.size();
        if (size == 0 || count == 1) {
            return this;
        }
        if (count < 1) {
            this.clear();
            return this;
        }
        if (size > Integer.MAX_VALUE / count) {
            throw Py.MemoryError("");
        }
        int newSize = size * count;
        this.list.setSize(newSize);
        PyObject[] array = this.getArray();
        for (int i = 1; i < count; ++i) {
            System.arraycopy(array, 0, array, i * size, size);
        }
        this.gListAllocatedStatus = this.__len__();
        return this;
    }

    @Override
    public PyObject __mul__(PyObject o) {
        return this.list___mul__(o);
    }

    final PyObject list___mul__(PyObject o) {
        if (!o.isIndex()) {
            return null;
        }
        return this.repeat(o.asIndex(Py.OverflowError));
    }

    @Override
    public PyObject __rmul__(PyObject o) {
        return this.list___rmul__(o);
    }

    final PyObject list___rmul__(PyObject o) {
        if (!o.isIndex()) {
            return null;
        }
        return this.repeat(o.asIndex(Py.OverflowError));
    }

    @Override
    public PyObject __add__(PyObject o) {
        return this.list___add__(o);
    }

    final PyObject list___add__(PyObject o) {
        Object oList;
        PyList sum = null;
        if (o instanceof PyList) {
            PyList other = (PyList)o;
            int thisLen = this.size();
            int otherLen = other.size();
            PyObject[] newList = new PyObject[thisLen + otherLen];
            System.arraycopy(this.getArray(), 0, newList, 0, thisLen);
            System.arraycopy(other.getArray(), 0, newList, thisLen, otherLen);
            sum = new PyList(newList);
        } else if (!(o instanceof PySequenceList) && (oList = o.__tojava__(List.class)) != Py.NoConversion && oList != null) {
            List otherList = (List)oList;
            sum = new PyList();
            sum.list_extend(this);
            Iterator i = otherList.iterator();
            while (i.hasNext()) {
                sum.add(i.next());
            }
        }
        return sum;
    }

    @Override
    public PyObject __radd__(PyObject o) {
        return this.list___radd__(o);
    }

    final PyObject list___radd__(PyObject o) {
        PyList sum = null;
        if (o instanceof PySequence) {
            return null;
        }
        Object oList = o.__tojava__(List.class);
        if (oList != Py.NoConversion && oList != null) {
            sum = new PyList();
            sum.addAll((Collection)((List)oList));
            sum.extend(this);
        }
        return sum;
    }

    final boolean list___contains__(PyObject o) {
        return this.object___contains__(o);
    }

    final void list___delitem__(PyObject index) {
        this.seq___delitem__(index);
    }

    final void list___setitem__(PyObject o, PyObject def) {
        this.seq___setitem__(o, def);
    }

    final PyObject list___getitem__(PyObject o) {
        PyObject ret = this.seq___finditem__(o);
        if (ret == null) {
            throw Py.IndexError("index out of range: " + o);
        }
        return ret;
    }

    @Override
    public PyObject __iter__() {
        return this.list___iter__();
    }

    public PyObject list___iter__() {
        return new PyFastSequenceIter(this);
    }

    final PyObject list___getslice__(PyObject start, PyObject stop, PyObject step) {
        return this.seq___getslice__(start, stop, step);
    }

    final void list___setslice__(PyObject start, PyObject stop, PyObject step, PyObject value) {
        this.seq___setslice__(start, stop, step, value);
    }

    final void list___delslice__(PyObject start, PyObject stop, PyObject step) {
        this.seq___delslice__(start, stop, step);
    }

    @Override
    protected String unsupportedopMessage(String op, PyObject o2) {
        if (op.equals("+")) {
            return "can only concatenate list (not \"{2}\") to list";
        }
        return super.unsupportedopMessage(op, o2);
    }

    @Override
    public String toString() {
        return this.list_toString();
    }

    final String list_toString() {
        ThreadState ts = Py.getThreadState();
        if (!ts.enterRepr(this)) {
            return "[...]";
        }
        StringBuilder buf = new StringBuilder("[");
        int length = this.size();
        PyObject[] array = this.getArray();
        for (int i = 0; i < length - 1; ++i) {
            buf.append(array[i].__repr__().toString());
            buf.append(", ");
        }
        if (length > 0) {
            buf.append(array[length - 1].__repr__().toString());
        }
        buf.append("]");
        ts.exitRepr(this);
        return buf.toString();
    }

    public void append(PyObject o) {
        this.list_append(o);
    }

    final void list_append(PyObject o) {
        this.pyadd(o);
        this.gListAllocatedStatus = this.__len__();
    }

    public int count(PyObject o) {
        return this.list_count(o);
    }

    final int list_count(PyObject o) {
        int count = 0;
        PyObject[] array = this.getArray();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!array[i].equals(o)) continue;
            ++count;
        }
        return count;
    }

    public int index(PyObject o) {
        return this.index(o, 0);
    }

    public int index(PyObject o, int start) {
        return this.list_index(o, start, this.size());
    }

    public int index(PyObject o, int start, int stop) {
        return this.list_index(o, start, stop);
    }

    final int list_index(PyObject o, PyObject start, PyObject stop) {
        int startInt = start == null ? 0 : PySlice.calculateSliceIndex(start);
        int stopInt = stop == null ? this.size() : PySlice.calculateSliceIndex(stop);
        return this.list_index(o, startInt, stopInt);
    }

    final int list_index(PyObject o, int start, int stop) {
        return this._index(o, "list.index(x): x not in list", start, stop);
    }

    final int list_index(PyObject o, int start) {
        return this._index(o, "list.index(x): x not in list", start, this.size());
    }

    final int list_index(PyObject o) {
        return this._index(o, "list.index(x): x not in list", 0, this.size());
    }

    private int _index(PyObject o, String message, int start, int stop) {
        int validStop = this.boundToSequence(stop);
        int validStart = this.boundToSequence(start);
        PyObject[] array = this.getArray();
        for (int i = validStart; i < validStop && i < this.size(); ++i) {
            if (!array[i].equals(o)) continue;
            return i;
        }
        throw Py.ValueError(message);
    }

    public void insert(int index, PyObject o) {
        this.list_insert(index, o);
    }

    final void list_insert(int index, PyObject o) {
        if (index < 0) {
            index = Math.max(0, this.size() + index);
        }
        if (index > this.size()) {
            index = this.size();
        }
        this.list.pyadd(index, o);
        this.gListAllocatedStatus = this.__len__();
    }

    public void remove(PyObject o) {
        this.list_remove(o);
    }

    final void list_remove(PyObject o) {
        this.del(this._index(o, "list.remove(x): x not in list", 0, this.size()));
        this.gListAllocatedStatus = this.__len__();
    }

    public void reverse() {
        this.list_reverse();
    }

    final void list_reverse() {
        int n = this.size();
        PyObject[] n2 = this.getArray();
        int array = n - 1;
        int j = 0;
        while (j < n / 2) {
            PyObject i = n2[j];
            n2[j] = n2[array];
            n2[array] = i;
            ++j;
            --array;
        }
        this.gListAllocatedStatus = this.__len__();
    }

    public PyObject pop() {
        return this.pop(-1);
    }

    public PyObject pop(int n) {
        return this.list_pop(n);
    }

    final PyObject list_pop(int n) {
        int length = this.size();
        if (length == 0) {
            throw Py.IndexError("pop from empty list");
        }
        if (n < 0) {
            n += length;
        }
        if (n < 0 || n >= length) {
            throw Py.IndexError("pop index out of range");
        }
        PyObject v = this.pyget(n);
        this.setslice(n, n + 1, 1, Py.EmptyTuple);
        return v;
    }

    public void extend(PyObject o) {
        this.list_extend(o);
    }

    final void list_extend(PyObject o) {
        int length = this.size();
        this.setslice(length, length, 1, o);
        this.gListAllocatedStatus = this.__len__();
    }

    @Override
    public PyObject __iadd__(PyObject o) {
        return this.list___iadd__(o);
    }

    final PyObject list___iadd__(PyObject o) {
        PyObject it;
        PyType oType = o.getType();
        if (oType == TYPE || oType == PyTuple.TYPE || this == o) {
            this.extend(PyList.fastSequence(o, "argument must be iterable"));
            return this;
        }
        try {
            it = o.__iter__();
        }
        catch (PyException pye) {
            if (!Py.matchException(pye, Py.TypeError)) {
                throw pye;
            }
            return null;
        }
        this.extend(it);
        return this;
    }

    final void list_sort(PyObject[] args, String[] kwds) {
        ArgParser ap = new ArgParser("list", args, kwds, new String[]{"cmp", "key", "reverse"}, 0);
        PyObject cmp = ap.getPyObject(0, Py.None);
        PyObject key = ap.getPyObject(1, Py.None);
        PyObject reverse = ap.getPyObject(2, Py.False);
        this.sort(cmp, key, reverse);
    }

    public void sort(PyObject compare) {
        this.sort(compare, Py.None, Py.False);
    }

    public void sort() {
        this.sort(Py.None, Py.None, Py.False);
    }

    public void sort(PyObject cmp, PyObject key, PyObject reverse) {
        MergeState ms = new MergeState(this, cmp, key, reverse.__nonzero__());
        ms.sort();
    }

    @Override
    public int hashCode() {
        return this.list___hash__();
    }

    final int list___hash__() {
        throw Py.TypeError(String.format("unhashable type: '%.200s'", this.getType().fastGetName()));
    }

    @Override
    public PyTuple __getnewargs__() {
        return new PyTuple(new PyTuple(this.list.getArray()));
    }

    static {
        PyType.addBuilder(PyList.class, new PyList$PyExposer());
        TYPE = PyType.fromClass(PyList.class);
    }
}

