/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyDescriptor;
import org.python.core.PyException;
import org.python.core.PyMethodDescr$PyExposer;
import org.python.core.PyObject;
import org.python.core.PyType;

public class PyMethodDescr
extends PyDescriptor
implements PyBuiltinCallable.Info {
    protected int minargs;
    protected int maxargs;
    protected PyBuiltinCallable meth;

    public PyMethodDescr(PyType t, PyBuiltinCallable func) {
        this.name = func.info.getName();
        this.dtype = t;
        this.minargs = func.info.getMinargs();
        this.maxargs = func.info.getMaxargs();
        this.meth = func;
        this.meth.setInfo(this);
    }

    public int getMaxargs() {
        return this.maxargs;
    }

    public int getMinargs() {
        return this.minargs;
    }

    public String toString() {
        return String.format("<method '%s' of '%s' objects>", this.name, this.dtype.fastGetName());
    }

    public PyObject __call__(PyObject[] args, String[] kwargs) {
        return this.method_descriptor___call__(args, kwargs);
    }

    final PyObject method_descriptor___call__(PyObject[] args, String[] kwargs) {
        if (args.length == kwargs.length) {
            throw Py.TypeError(this.name + " requires at least one argument");
        }
        this.checkCallerType(args[0].getType());
        PyObject[] actualArgs = new PyObject[args.length - 1];
        System.arraycopy(args, 1, actualArgs, 0, actualArgs.length);
        return this.meth.bind(args[0]).__call__(actualArgs, kwargs);
    }

    public PyException unexpectedCall(int nargs, boolean keywords) {
        return PyBuiltinCallable.DefaultInfo.unexpectedCall(nargs, keywords, this.name, this.minargs, this.maxargs);
    }

    public PyObject __get__(PyObject obj, PyObject type) {
        return this.method_descriptor___get__(obj, type);
    }

    final PyObject method_descriptor___get__(PyObject obj, PyObject type) {
        if (obj != null) {
            this.checkGetterType(obj.getType());
            return this.meth.bind(obj);
        }
        return this;
    }

    public String getName() {
        return this.name;
    }

    public PyObject getObjClass() {
        return this.dtype;
    }

    static {
        PyType.addBuilder(PyMethodDescr.class, new PyMethodDescr$PyExposer());
    }
}

