% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spacetime.R
\name{spacetime.operators}
\alias{spacetime.operators}
\title{Space-time random fields}
\usage{
spacetime.operators(
  mesh_space = NULL,
  mesh_time = NULL,
  space_loc = NULL,
  time_loc = NULL,
  graph = NULL,
  kappa = NULL,
  sigma = NULL,
  gamma = NULL,
  rho = NULL,
  alpha = NULL,
  beta = NULL,
  bounded_rho = TRUE
)
}
\arguments{
\item{mesh_space}{Spatial mesh for FEM approximation}

\item{mesh_time}{Temporal mesh for FEM approximation}

\item{space_loc}{Locations of mesh nodes for spatial mesh for 1d models.}

\item{time_loc}{Locations of temporal mesh nodes.}

\item{graph}{An optional \code{metric_graph} object. Replaces \code{mesh} for models on
metric graphs.}

\item{kappa}{Positive spatial range parameter}

\item{sigma}{Positive variance parameter}

\item{gamma}{Temporal range parameter.}

\item{rho}{Drift parameter. Real number on metric graphs and
one-dimensional spatial domains, a vector with two number on 2d domains.}

\item{alpha}{Integer smoothness parameter alpha.}

\item{beta}{Integer smoothness parameter beta.}

\item{bounded_rho}{Logical. Specifies whether \code{rho} should be bounded to ensure the existence, uniqueness, and well-posedness of the solution. Defaults to \code{TRUE}.
Note that this bounding is not a strict condition; there may exist values of rho beyond the upper bound that still satisfy these properties.
When \code{bounded_rho = TRUE}, the \code{rspde_lme} models enforce bounded \code{rho} for consistency.
If the estimated value of \code{rho} approaches the upper bound too closely, we recommend refitting the model with \code{bounded_rho = FALSE}. However, this should be done with caution, as it may lead to instability in some cases, though it can also result in a better model fit.
The actual bound used for \code{rho} can be accessed from the \code{bound_rho} element of the returned object.}
}
\value{
An object of type spacetimeobj.
}
\description{
\code{spacetime.operators} is used for computing a FEM approximation of a Gaussian
random field defined as a solution to the SPDE
\deqn{d u + \gamma(\kappa^2 + \kappa^{d/2}\rho \cdot\nabla - \Delta)^\alpha u = \sigma dW_C.}
where C is a Whittle-Matern covariance operator with smoothness parameter
\eqn{\beta} and range parameter \eqn{\kappa}
}
\examples{
s <- seq(from = 0, to = 20, length.out = 101)
t <- seq(from = 0, to = 20, length.out = 31)

op_cov <- spacetime.operators(space_loc = s, time_loc = t,
                             kappa = 5, sigma = 10, alpha = 1,
                             beta = 2, rho = 1, gamma = 0.05)
Q <- op_cov$Q
v <- rep(0,dim(Q)[1])
v[1565] <- 1
Sigma <- solve(Q,v)

image(matrix(Sigma, nrow=length(s), ncol = length(t)))
}
