% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inlabru_rspde.R
\name{group_predict}
\alias{group_predict}
\title{Perform prediction on a testing set based on a training set}
\usage{
group_predict(
  models,
  model_names = NULL,
  formula = NULL,
  train_indices,
  test_indices,
  n_samples = 1000,
  pseudo_predict = TRUE,
  return_samples = FALSE,
  return_hyper_samples = FALSE,
  n_hyper_samples = 1,
  compute_posterior_means = TRUE,
  print = TRUE,
  fit_verbose = FALSE
)
}
\arguments{
\item{models}{A fitted model obtained from calling the \code{bru()} function or a list of models fitted with the \code{bru()} function.}

\item{model_names}{A vector containing the names of the models to appear in the returned \code{data.frame}. If \code{NULL}, the names will be of the form \verb{Model 1}, \verb{Model 2}, and so on. By default, it will try to obtain the name from the models list.}

\item{formula}{A formula where the right hand side defines an R expression to evaluate for each generated sample. If \verb{NULL``, the latent and hyperparameter states are returned as named list elements. See the manual for the }predict\verb{method in the}inlabru` package.}

\item{train_indices}{A list containing the indices of the observations for the model to be trained, or a numerical vector containing the indices.}

\item{test_indices}{A list containing the indices of the test data, where the prediction will be done, or a numerical vector containing the indices.}

\item{n_samples}{Number of samples to compute the posterior statistics to be used to compute the scores.}

\item{pseudo_predict}{If \code{TRUE}, the models will NOT be refitted on the training data, and the parameters obtained on the entire dataset will be used. If \code{FALSE}, the models will be refitted on the training data.}

\item{return_samples}{Should the posterior samples be returned?}

\item{return_hyper_samples}{Should samples for the hyperparameters be obtained?}

\item{n_hyper_samples}{Number of independent samples of the hyper parameters of size \code{n_samples}.}

\item{compute_posterior_means}{Should the posterior means be computed from the posterior samples?}

\item{print}{Should partial results be printed throughout the computation?}

\item{fit_verbose}{Should INLA's run during the prediction be verbose?}
}
\value{
A data.frame with the fitted models and the corresponding scores.
}
\description{
Compute prediction of a formula-based expression on a testing set based on a training set.
}
