% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{folded.matern.covariance}
\alias{folded.matern.covariance}
\title{The folded Matern covariance function}
\usage{
folded.matern.covariance(h, m, kappa, nu, sigma, L = 1, N = 10)
}
\arguments{
\item{h, m}{Arguments of the covariance function.}

\item{kappa}{Range parameter.}

\item{nu}{Shape parameter.}

\item{sigma}{Standard deviation.}

\item{L}{The upper bound of the interval [0,L]. By default, \code{L=1}.}

\item{N}{The truncation parameter.}
}
\value{
A vector with the values C(h).
}
\description{
\code{matern.covariance} evaluates the folded Matern covariance function
over an interval \eqn{[0,L]}.
}
\details{
\code{matern.covariance} evaluates the folded Matern covariance function
over an interval \eqn{[0,L]}:
\deqn{C(h,m) = \sum_{k=-\infty}^{\infty} (C(h-m+2kL)+C(h+m-2kL)),}

where \eqn{C(\cdot)} is the Matern covariance function:
\deqn{C(h) = \frac{\sigma^2}{2^{\nu-1}\Gamma(\nu)}(\kappa h)^\nu K_\nu(\kappa h).}

We consider the truncation:
\deqn{C(h,m) = \sum_{k=-N}^{N} (C(h-m+2kL)+C(h+m-2kL)).}
}
\examples{
x = seq(from = 0, to = 1, length.out = 101)
plot(x, folded.matern.covariance(rep(0.5,length(x)),x, kappa = 10, nu = 1/5, sigma = 1),
     type = "l", ylab = "C(h)", xlab = "h")
}
