\name{borderPoint}
\alias{borderPoint}
\title{
Border in the experimental units
}
\description{
Generates the spectral information of the edge of the UEs for analysis of the border effect, it requires the spectral image, the distance of the border and the segmentation of the UEs generated by imageField. 
}
\usage{
borderPoint(r,Rbook,distance,plotting=TRUE,...)
}
\arguments{
  \item{r}{spectral image}
  \item{Rbook}{Object generated by imageField}
  \item{distance}{distance defining the border of the exterior to the experimental plot}
  \item{plotting}{Logic value to display the image of the border effect around the UEs}
  \item{...}{plot parameter to document the image as main, axis, etc}
}
\details{
Set the border in terms of distance in units measured in the field
}
\value{
\item{Qborder}{Border bounds matrix} 
\item{border}{dataframe spectral border and that is expressed in the image.}
}

\author{
Felipe de Mendiburu
}
\seealso{\code{\link{cassava}}, \code{\link{fourPoint}}, \code{\link{imageField}} 
}

\examples{
# use cassava crop information
library(rPAex)
data(cassava)
r <- raster::rasterFromXYZ(cassava)
# cassava area
P<-list(x=c(287689.4, 287702.8, 287706.2),y=c(8664210, 8664214, 8664179))
Q<-fourPoint(P)
op<-par(mfrow=c(1,2))
raster::image(r,useRaster=FALSE)
Rbook<-imageField(r,Q,3,2,11,6,plotting=TRUE)
out<-borderPoint(r,Rbook,distance=1, main="Image crop")
par(op)
# NDVI in border
ndvi<-with(out$Border, (L1-L2)/(L1+L2))
plt<-out$Border[ndvi>0.5,1:2]
op<-par(mfrow=c(1,1))
w<-raster::rasterFromXYZ(out$Border)
raster::image(w,useRaster=FALSE,main="Border plants")
points(plt,cex=0.8,col=colors()[51],pch=20)
par(op)
}
\keyword{ design }
\keyword{ dplot }

