% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MVP.r
\name{MVP}
\alias{MVP}
\title{MVP, Memory-efficient, Visualization-enhanced, Parallel-accelerated}
\usage{
MVP(
  phe,
  geno,
  map,
  K = NULL,
  nPC.GLM = NULL,
  nPC.MLM = NULL,
  nPC.FarmCPU = NULL,
  CV.GLM = NULL,
  CV.MLM = NULL,
  CV.FarmCPU = NULL,
  REML = NULL,
  priority = "speed",
  ncpus = detectCores(logical = FALSE),
  vc.method = c("BRENT", "EMMA", "HE"),
  method = c("GLM", "MLM", "FarmCPU"),
  p.threshold = NA,
  QTN.threshold = 0.01,
  method.bin = "static",
  bin.size = c(5e+05, 5e+06, 5e+07),
  bin.selection = seq(10, 100, 10),
  maxLoop = 10,
  permutation.threshold = FALSE,
  permutation.rep = 100,
  memo = NULL,
  outpath = getwd(),
  col = c("#4197d8", "#f8c120", "#413496", "#495226", "#d60b6f", "#e66519", "#d581b7",
    "#83d3ad", "#7c162c", "#26755d"),
  file.output = TRUE,
  file.type = "jpg",
  dpi = 300,
  threshold = 0.05,
  verbose = TRUE
)
}
\arguments{
\item{phe}{phenotype, n * 2 matrix, n is sample size}

\item{geno}{Genotype in bigmatrix format; m * n, m is marker size, n is sample size}

\item{map}{SNP map information, SNP name, Chr, Pos}

\item{K}{Kinship, Covariance matrix(n * n) for random effects, must be positive semi-definite}

\item{nPC.GLM}{number of PCs added as fixed effects in GLM}

\item{nPC.MLM}{number of PCs added as fixed effects in MLM}

\item{nPC.FarmCPU}{number of PCs added as fixed effects in FarmCPU}

\item{CV.GLM}{covariates added in GLM}

\item{CV.MLM}{covariates added in MLM}

\item{CV.FarmCPU}{covariates added in FarmCPU}

\item{REML}{a list contains ve and vg}

\item{priority}{speed or memory}

\item{ncpus}{number of cpus used for parallel}

\item{vc.method}{methods for estimating variance component("EMMA" or "HE" or "BRENT")}

\item{method}{the GWAS model, "GLM", "MLM", and "FarmCPU", models can be selected simutaneously, i.e. c("GLM", "MLM", "FarmCPU")}

\item{p.threshold}{if all p values generated in the first iteration are bigger than p.threshold, FarmCPU stops}

\item{QTN.threshold}{in second and later iterations, only SNPs with lower p-values than QTN.threshold have chances to be selected as pseudo QTNs}

\item{method.bin}{'static' or 'FaST-LMM'}

\item{bin.size}{window size in genome}

\item{bin.selection}{a vector, how many windows selected}

\item{maxLoop}{maximum number of iterations}

\item{permutation.threshold}{if use a permutation cutoff or not (bonferroni cutoff)}

\item{permutation.rep}{number of permutation replicates}

\item{memo}{Character. A text marker on output files}

\item{outpath}{Effective only when file.output = TRUE, determines the path of the output file}

\item{col}{for color of points in each chromosome on manhattan plot}

\item{file.output}{whether to output files or not}

\item{file.type}{figure formats, "jpg", "tiff"}

\item{dpi}{resolution for output figures}

\item{threshold}{a cutoff line on manhattan plot, 0.05/marker size}

\item{verbose}{whether to print detail.}
}
\value{
a m * 2 matrix, the first column is the SNP effect, the second column is the P values
Output: MVP.return$map - SNP map information, SNP name, Chr, Pos
Output: MVP.return$glm.results - p-values obtained by GLM method
Output: MVP.return$mlm.results - p-values obtained by MLM method
Output: MVP.return$farmcpu.results - p-values obtained by FarmCPU method
}
\description{
Object 1: To perform GWAS using General Linear Model (GLM), Mixed Linear Model (MLM), and FarmCPU model
Object 2: To calculate kinship among individuals using Varaden method
Object 3: Estimate variance components using EMMA, FaST-LMM, and HE regression
Object 4: Generate high-quality figures
}
\details{
Build date: Aug 30, 2017
Last update: Dec 14, 2018
}
\examples{
\donttest{
phePath <- system.file("extdata", "07_other", "mvp.phe", package = "rMVP")
phenotype <- read.table(phePath, header=TRUE)
print(dim(phenotype))
genoPath <- system.file("extdata", "06_mvp-impute", "mvp.imp.geno.desc", package = "rMVP")
genotype <- attach.big.matrix(genoPath)
print(dim(genotype))
mapPath <- system.file("extdata", "06_mvp-impute", "mvp.imp.geno.map", package = "rMVP")
map <- read.table(mapPath , head = TRUE)

opts <- options(rMVP.OutputLog2File = FALSE)

mvp <- MVP(phe=phenotype, geno=genotype, map=map, maxLoop=3,
  method=c("GLM", "MLM", "FarmCPU"), file.output=FALSE, ncpus=1)
str(mvp)

options(opts)
}
}
\author{
Lilin Yin, Haohao Zhang, and Xiaolei Liu
}
