% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcLittoral.R
\name{calcLittoral}
\alias{calcLittoral}
\title{Calculate Littoral Area}
\usage{
calcLittoral(
  DEM,
  photic = NULL,
  secchi = NULL,
  DEMunits = "m",
  depthUnits = "ft",
  by = 1,
  stop = NULL
)
}
\arguments{
\item{DEM}{SpatRaster object of a given waterbody, rasters can be transformed to SpatRaster via the rast() function in 'terra'}

\item{photic}{number giving the average photic depth, overwrites Secchi depth}

\item{secchi}{number giving the average secchi depth, photic zone estimated as 2.6m * secchi.}

\item{DEMunits}{character describing units of raster coordinate system. Can be meters, kilometers, or hectares ("m", "km", "ha"), default = "m"}

\item{depthUnits}{character describing units of depth measurement (secchi and DEM). Can be either feet or meters ("ft", "m"), default = "ft"}

\item{by}{numeric increment per unit depth by which areas are calculated. Higher values will result in lower resolution. Default = 1}

\item{stop}{optional numeric value specifying depth at which to stop calculations, default = NULL}
}
\value{
data frame of areas in specified units for each depth, as well as the littoral percentage of total surface area
}
\description{
Calculates littoral surface area (2D) of a given waterbody across water levels based on an average photic depth value.
}
\examples{
#load raster
DEM <- terra::rast(system.file("extdata", "example_raster.tif", package = 'rLakeHabitat'))
#run function
calcLittoral(DEM, secchi = 1, depthUnits = "m", DEMunits = "m")
}
\author{
Tristan Blechinger, Department of Zoology & Physiology, University of Wyoming
}
