% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/java_install.R
\name{java_install}
\alias{java_install}
\title{Install Java from a distribution file}
\usage{
java_install(
  java_distrib_path,
  project_path = NULL,
  autoset_java_env = TRUE,
  quiet = FALSE
)
}
\arguments{
\item{java_distrib_path}{A \code{character} vector of length 1 containing the path to the Java distribution file.}

\item{project_path}{A \code{character} vector of length 1 containing the project directory where Java should be installed. If not specified or \code{NULL}, defaults to the current working directory.}

\item{autoset_java_env}{A \code{logical} indicating whether to set the \code{JAVA_HOME} and \code{PATH} environment variables to the installed Java directory. Defaults to \code{TRUE}.}

\item{quiet}{A \code{logical} value indicating whether to suppress messages. Can be \code{TRUE} or \code{FALSE}.}
}
\value{
The path to the installed Java directory.
}
\description{
Unpack Java distribution file into cache directory and link the installation into a project directory, optionally setting the \code{JAVA_HOME} and \code{PATH} environment variables to the Java version that was just installed.
}
\examples{
\dontrun{

# set cache dir to temporary directory
options(rJavaEnv.cache_path = tempdir())
# download, install and autoset environmnet variables for Java 17
java_17_distrib <- java_download(version = "17")
java_install(java_distrib_path = java_17_distrib, project_path = tempdir())
}
}
