% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDiameter.R
\name{getDiameter}
\alias{getDiameter}
\alias{getDiameter.data.frame}
\alias{getDiameter.list}
\alias{getDiameter.datBDAT}
\title{Get diameter in given height inside tree taper}
\usage{
getDiameter(tree, ...)

\method{getDiameter}{data.frame}(tree, Hx = NULL, bark = TRUE, mapping = NULL, ...)

\method{getDiameter}{list}(tree, Hx = NULL, bark = TRUE, mapping = NULL, ...)

\method{getDiameter}{datBDAT}(tree, Hx = NULL, bark = TRUE, mapping = NULL, ...)
}
\arguments{
\item{tree}{either a data.frame, a list or an object of class \code{datBDAT}
containing the variables needed to decribe a tree, i.e. spp, D1, H, and
optionally H1, D2, H2. See \code{\link{buildTree}} for details and parameter
\code{mapping} for mapping of variable names}

\item{...}{passing arguments to methods.}

\item{Hx}{height in tree for which diameter over or under bark is required;
defaults to NULL}

\item{bark}{logical, if TRUE returned diameter \code{Dx} is over bark,
if FALSE returned diameter is under bark. Coerced to logical by
\code{\link{as.logical}(bark[1])}.}

\item{mapping}{mapping of variable names in case a data.frame is given into
parameter \code{tree} between colnames(\code{tree}) and required parameter
names. See details.}
}
\value{
a matrix with one row for each tree and one column for each \code{Hx}
given, holding the diameter over or under bark of provided height \code{Hx}
inside stem taper. The matrix is simplified by \code{[,,drop=TRUE]},
especially if \code{Hx=NULL}.
}
\description{
this function calculates the diameter inside or outside bark of
in given height for a given tree
}
\details{
if tree does not includes variable Hx, a full outer join is
generated between both
}
\section{Methods (by class)}{
\itemize{
\item \code{data.frame}: transforming \code{data.frame} before calling
\code{getDiameter} using \code{buildTree}

\item \code{list}: transforming \code{list} before calling
\code{getDiameter} using \code{buildTree}

\item \code{datBDAT}: class method for class \code{datBDAT}
}}

\examples{
tree <- data.frame(spp = c(1, 1), D1 = c(30, 30), H = c(25, 25), Hx = c(1.3, 22.248))
getDiameter(tree, bark = TRUE)
getDiameter(tree, bark = FALSE)

tree <- data.frame(BDATCode = c(1, 1), dbh = c(30, 30), h = c(25, 25), Hx = c(1.3, 22.248))
getDiameter(tree, bark = TRUE, mapping = c("BDATCode" = "spp", "dbh" = "D1", "h" = "H"))

tree <- data.frame(BDATCode = c(1, 1), dbh = c(30, 30), h = c(25, 25))
Hx <- c(1.3, 22.248)
getDiameter(tree, Hx = Hx, bark = TRUE, mapping = c("BDATCode" = "spp", "dbh" = "D1", "h" = "H"))
}
