/******/ (function(modules) { // webpackBootstrap
/******/ 	// install a JSONP callback for chunk loading
/******/ 	function webpackJsonpCallback(data) {
/******/ 		var chunkIds = data[0];
/******/ 		var moreModules = data[1];
/******/
/******/
/******/ 		// add "moreModules" to the modules object,
/******/ 		// then flag all "chunkIds" as loaded and fire callback
/******/ 		var moduleId, chunkId, i = 0, resolves = [];
/******/ 		for(;i < chunkIds.length; i++) {
/******/ 			chunkId = chunkIds[i];
/******/ 			if(Object.prototype.hasOwnProperty.call(installedChunks, chunkId) && installedChunks[chunkId]) {
/******/ 				resolves.push(installedChunks[chunkId][0]);
/******/ 			}
/******/ 			installedChunks[chunkId] = 0;
/******/ 		}
/******/ 		for(moduleId in moreModules) {
/******/ 			if(Object.prototype.hasOwnProperty.call(moreModules, moduleId)) {
/******/ 				modules[moduleId] = moreModules[moduleId];
/******/ 			}
/******/ 		}
/******/ 		if(parentJsonpFunction) parentJsonpFunction(data);
/******/
/******/ 		while(resolves.length) {
/******/ 			resolves.shift()();
/******/ 		}
/******/
/******/ 	};
/******/
/******/
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// object to store loaded and loading chunks
/******/ 	// undefined = chunk not loaded, null = chunk preloaded/prefetched
/******/ 	// Promise = chunk loading, 0 = chunk loaded
/******/ 	var installedChunks = {
/******/ 		"main": 0
/******/ 	};
/******/
/******/
/******/
/******/ 	// script path function
/******/ 	function jsonpScriptSrc(chunkId) {
/******/ 		return __webpack_require__.p + "" + chunkId + ".amChart4.js"
/******/ 	}
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// on error function for async loading
/******/ 	__webpack_require__.oe = function(err) { console.error(err); throw err; };
/******/
/******/ 	var jsonpArray = window["webpackJsonp"] = window["webpackJsonp"] || [];
/******/ 	var oldJsonpFunction = jsonpArray.push.bind(jsonpArray);
/******/ 	jsonpArray.push = webpackJsonpCallback;
/******/ 	jsonpArray = jsonpArray.slice();
/******/ 	for(var i = 0; i < jsonpArray.length; i++) webpackJsonpCallback(jsonpArray[i]);
/******/ 	var parentJsonpFunction = oldJsonpFunction;
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./srcjs/amChart4.jsx");
/******/ })
/************************************************************************/
/******/ ({

/***/ "../../canvg/index.js":
/*!***************************************!*\
  !*** external "../../canvg/index.js" ***!
  \***************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("../../canvg/index.js");

/***/ }),

/***/ "../../pdfmake/vfs_fonts":
/*!******************************************!*\
  !*** external "../../pdfmake/vfs_fonts" ***!
  \******************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("../../pdfmake/vfs_fonts");

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/Chart.js":
/*!********************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/Chart.js ***!
  \********************************************************************/
/*! exports provided: ChartDataItem, Chart */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ChartDataItem", function() { return ChartDataItem; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Chart", function() { return Chart; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_Component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core/Component */ "./node_modules/@amcharts/amcharts4/.internal/core/Component.js");
/* harmony import */ var _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../core/utils/Disposer */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Disposer.js");
/* harmony import */ var _core_utils_List__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../core/utils/List */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/List.js");
/* harmony import */ var _core_Container__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../core/Container */ "./node_modules/@amcharts/amcharts4/.internal/core/Container.js");
/* harmony import */ var _core_elements_Label__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../core/elements/Label */ "./node_modules/@amcharts/amcharts4/.internal/core/elements/Label.js");
/* harmony import */ var _core_elements_Grip__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../core/elements/Grip */ "./node_modules/@amcharts/amcharts4/.internal/core/elements/Grip.js");
/* harmony import */ var _core_DataItem__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../core/DataItem */ "./node_modules/@amcharts/amcharts4/.internal/core/DataItem.js");
/* harmony import */ var _core_utils_Percent__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../core/utils/Percent */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Percent.js");
/* harmony import */ var _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../core/utils/Iterator */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Iterator.js");
/* harmony import */ var _core_utils_Type__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../core/utils/Type */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Type.js");
/* harmony import */ var _core_utils_Responsive__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../core/utils/Responsive */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Responsive.js");
/**
 * [[Chart]] class provides base functionality for all chart types to inherit.
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */













/**
 * ============================================================================
 * DATA ITEM
 * ============================================================================
 * @hidden
 */

/**
 * Defines a [[DataItem]] for [[Chart]].
 *
 * @see {@link DataItem}
 */

var ChartDataItem =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(ChartDataItem, _super);
  /**
   * Constructor
   */


  function ChartDataItem() {
    var _this = _super.call(this) || this;

    _this.className = "ChartDataItem";

    _this.applyTheme();

    return _this;
  }

  return ChartDataItem;
}(_core_DataItem__WEBPACK_IMPORTED_MODULE_8__["DataItem"]);


/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * A base class for all Charts.
 *
 * @see {@link IChartEvents} for a list of available Events
 * @see {@link IChartAdapters} for a list of available Adapters
 */

var Chart =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(Chart, _super);
  /**
   * Constructor
   */


  function Chart() {
    var _this = // Init
    _super.call(this) || this;
    /**
     * A reference to chart's [[Legend]].
     * @ignore
     */


    _this._legend = new _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_3__["MutableValueDisposer"]();

    if (_this.constructor === Chart) {
      throw new Error("'Chart' cannot be instantiated directly. Please use a specific chart type.");
    }

    _this.className = "Chart"; // Create a list of titles

    var template = new _core_elements_Label__WEBPACK_IMPORTED_MODULE_6__["Label"]();
    _this.titles = new _core_utils_List__WEBPACK_IMPORTED_MODULE_4__["ListTemplate"](template);

    _this._disposers.push(new _core_utils_List__WEBPACK_IMPORTED_MODULE_4__["ListDisposer"](_this.titles));

    _this._disposers.push(template); // Chart component is also a container. it holds _chartAndLegendCont and titles


    _this.width = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_9__["percent"])(100);
    _this.height = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_9__["percent"])(100);
    _this.layout = "vertical"; // Chart and legend

    var chartAndLegendContainer = _this.createChild(_core_Container__WEBPACK_IMPORTED_MODULE_5__["Container"]);

    chartAndLegendContainer.shouldClone = false;
    chartAndLegendContainer.layout = "vertical";
    chartAndLegendContainer.width = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_9__["percent"])(100);
    chartAndLegendContainer.height = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_9__["percent"])(100);
    _this.chartAndLegendContainer = chartAndLegendContainer; // Chart container holds all the elements of a chart, extept titles and legend

    var chartContainer = chartAndLegendContainer.createChild(_core_Container__WEBPACK_IMPORTED_MODULE_5__["Container"]);
    chartContainer.shouldClone = false;
    chartContainer.width = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_9__["percent"])(100);
    chartContainer.height = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_9__["percent"])(100);
    _this.chartContainer = chartContainer;
    _this.showOnInit = true;

    _this._disposers.push(_this._legend); // Add title list events to apply certain formatting options and to make
    // the chart reference them as accessible screen reader labels


    _this.titles.events.on("inserted", function (label) {
      _this.processTitle(label);

      _this.updateReaderTitleReferences();
    }, _this, false);

    _this.titles.events.on("removed", function (label) {
      _this.updateReaderTitleReferences();
    }, _this, false); // Accessibility
    // It seems we can't set focusable on the whole chart because it seems to
    // mess up the whole focus event system - getting a focus on an inside
    // object also trigger focus on parent
    //this.focusable = true;


    _this.role = "region";
    _this.defaultState.transitionDuration = 1; // Apply theme

    _this.applyTheme();

    return _this;
  }
  /**
   * Sets defaults that instantiate some objects that rely on parent, so they
   * cannot be set in constructor.
   */


  Chart.prototype.applyInternalDefaults = function () {
    _super.prototype.applyInternalDefaults.call(this);

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_11__["hasValue"](this.readerTitle)) {
      this.readerTitle = this.language.translate("Chart");
    }
  };
  /**
   * Initiates drawing of the chart.
   *
   * @ignore Exclude from docs
   */


  Chart.prototype.draw = function () {
    this.fixLayout();

    _super.prototype.draw.call(this);
  };
  /**
   * Updates legend's hierarchy based on the position.
   */


  Chart.prototype.fixLayout = function () {
    var legend = this.legend;

    if (legend) {
      var chartAndLegendContainer = this.chartAndLegendContainer;
      var chartContainer = this.chartContainer;
      chartContainer.x = undefined;
      chartContainer.y = undefined;
      legend.x = undefined;
      legend.y = undefined;

      switch (legend.position) {
        case "left":
          chartAndLegendContainer.layout = "horizontal";
          legend.toBack();
          break;

        case "right":
          chartAndLegendContainer.layout = "horizontal";
          legend.toFront();
          break;

        case "top":
          chartAndLegendContainer.layout = "vertical";
          legend.toBack();
          break;

        case "bottom":
          chartAndLegendContainer.layout = "vertical";
          legend.toFront();
      }
    }
  };
  /**
   * Setups the legend to use the chart's data.
   */


  Chart.prototype.feedLegend = function () {// Nothing here. This method is provided only as a "placeholder" for
    // extending classes to override
  };
  /**
   * Adds a new title to the chart when it is inserted into chart's titles
   * list.
   * @param event  An event object which is triggered when inserting into titles list
   * @return Label object
   */


  Chart.prototype.processTitle = function (event) {
    var title = event.newValue;
    title.parent = this;
    title.toBack();
    title.shouldClone = false;
    title.align = "center"; // Need to explicitly apply the `id` attribute so it can be referenced by
    // `aria-labelledby`

    title.uidAttr();
    return title;
  };
  /**
   * Checks if chart has any title elements. If it does, we will use them in an
   * `aria-labelledby` attribute so that screen readers can use them to properly
   * describe the chart when it is focused or hovered.
   *
   * @ignore Exclude from docs
   */


  Chart.prototype.updateReaderTitleReferences = function () {
    if (this.titles.length) {
      var titleIds_1 = [];
      _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_10__["each"](this.titles.iterator(), function (title) {
        titleIds_1.push(title.uid);
      });
      this.setSVGAttribute({
        "aria-labelledby": titleIds_1.join(" ")
      });
    } else {
      this.removeSVGAttribute("aria-labelledby");
    }
  };

  Object.defineProperty(Chart.prototype, "legend", {
    /**
     * @return Legend
     */
    get: function get() {
      return this._legend.get();
    },

    /**
     * Holds the instance of chart's [[Leged]].
     *
     * @see {@link https://www.amcharts.com/docs/v4/concepts/legend/} for more information about legends
     * @param Legend
     */
    set: function set(legend) {
      this.setLegend(legend);
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Prepares the legend instance for use in this chart.
   *
   * @param legend  Legend
   */

  Chart.prototype.setLegend = function (legend) {
    var _this = this;

    if (this._legend.get() !== legend) {
      if (legend) {
        // Set legend options
        legend.parent = this.chartAndLegendContainer;

        this._legend.set(legend, legend.events.on("propertychanged", function (event) {
          if (event.property == "position") {
            _this.fixLayout();
          }
        }, undefined, false));

        legend.addDisposer(new _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_3__["Disposer"](function () {
          _this.legend = undefined;
        }));
      } else {
        this._legend.reset();
      }

      this.feedLegend();
    }
  };
  /**
   * Destroys this object and all related data.
   */


  Chart.prototype.dispose = function () {
    // otherwise there might be some errors when disposing chart which was just inited
    if (this.legend) {
      this.legend.dispose();
    }

    _super.prototype.dispose.call(this);
  };
  /**
   * Processes JSON-based config before it is applied to the object.
   *
   * @ignore Exclude from docs
   * @param config  Config
   */


  Chart.prototype.processConfig = function (config) {
    if (config) {
      // Set up legend
      if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_11__["hasValue"](config.legend) && !_core_utils_Type__WEBPACK_IMPORTED_MODULE_11__["hasValue"](config.legend.type)) {
        config.legend.type = "Legend";
      }
    }

    _super.prototype.processConfig.call(this, config);
  };
  /**
   * Copies all properties from another instance of [[Series]].
   *
   * @param source  Source series
   */


  Chart.prototype.copyFrom = function (source) {
    this.titles.copyFrom(source.titles);
    this.chartContainer.copyFrom(source.chartContainer);

    if (source.legend) {
      this.legend = source.legend.clone();
      this.legend.removeChildren();
    }

    _super.prototype.copyFrom.call(this, source);
  };

  Object.defineProperty(Chart.prototype, "dragGrip", {
    /**
     * @return Grip
     */
    get: function get() {
      var _this = this;

      if (!this._dragGrip) {
        var grip_1 = this.tooltipContainer.createChild(_core_elements_Grip__WEBPACK_IMPORTED_MODULE_7__["Grip"]);
        grip_1.align = "right";
        grip_1.valign = "middle";
        grip_1.hide(0);
        grip_1.events.on("down", function (ev) {
          if (ev.touch) {
            _this.interactionsEnabled = false;
          }
        });
        grip_1.events.on("up", function (ev) {
          _this.interactionsEnabled = true;
        });
        this.events.on("down", function (ev) {
          if (ev.touch) {
            grip_1.show();
          }
        });
        this._dragGrip = grip_1;
      }

      return this._dragGrip;
    },

    /**
     * An instance of [[Grip]] which serves as a grip point which appears on
     * touch and allows scrolling whole page even if chart is occupying the
     * whole of the screen and would otherwise prevent scrolling.
     *
     * @since 4.4.0
     * @see {@link https://www.amcharts.com/docs/v4/concepts/touch/} For more information.
     * @param  value  Grip
     */
    set: function set(value) {
      this._dragGrip = value;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(Chart.prototype, "focusable", {
    get: function get() {
      return this.parent.focusable;
    },
    set: function set(value) {
      this.parent.focusable = value;
    },
    enumerable: true,
    configurable: true
  });
  return Chart;
}(_core_Component__WEBPACK_IMPORTED_MODULE_2__["Component"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_1__["registry"].registeredClasses["Chart"] = Chart;
/**
 * Add default responsive rules
 */

/**
 * Reduce horizontal margins
 */

_core_utils_Responsive__WEBPACK_IMPORTED_MODULE_12__["defaultRules"].push({
  relevant: _core_utils_Responsive__WEBPACK_IMPORTED_MODULE_12__["ResponsiveBreakpoints"].widthXS,
  state: function state(target, stateId) {
    if (target instanceof Chart) {
      var state = target.states.create(stateId);

      if (target.pixelPaddingLeft > 10) {
        state.properties.paddingLeft = 10;
      }

      if (target.pixelPaddingRight > 10) {
        state.properties.paddingRight = 10;
      }

      return state;
    }

    return null;
  }
});
/**
 * Reduce vertical margins
 */

_core_utils_Responsive__WEBPACK_IMPORTED_MODULE_12__["defaultRules"].push({
  relevant: _core_utils_Responsive__WEBPACK_IMPORTED_MODULE_12__["ResponsiveBreakpoints"].heightXS,
  state: function state(target, stateId) {
    if (target instanceof Chart) {
      var state = target.states.create(stateId);

      if (target.pixelPaddingTop > 10) {
        state.properties.paddingTop = 10;
      }

      if (target.pixelPaddingBottom > 10) {
        state.properties.paddingBottom = 10;
      }

      return state;
    }

    return null;
  }
});
/**
 * Remove horizontal padding
 */

_core_utils_Responsive__WEBPACK_IMPORTED_MODULE_12__["defaultRules"].push({
  relevant: _core_utils_Responsive__WEBPACK_IMPORTED_MODULE_12__["ResponsiveBreakpoints"].widthXXS,
  state: function state(target, stateId) {
    if (target instanceof Chart) {
      var state = target.states.create(stateId);
      state.properties.paddingLeft = 0;
      state.properties.paddingRight = 0;
      return state;
    }

    return null;
  }
});
/**
 * Remove vertical padding
 */

_core_utils_Responsive__WEBPACK_IMPORTED_MODULE_12__["defaultRules"].push({
  relevant: _core_utils_Responsive__WEBPACK_IMPORTED_MODULE_12__["ResponsiveBreakpoints"].heightXXS,
  state: function state(target, stateId) {
    if (target instanceof Chart) {
      var state = target.states.create(stateId);
      state.properties.paddingTop = 0;
      state.properties.paddingBottom = 0;
      return state;
    }

    return null;
  }
});

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/Legend.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/Legend.js ***!
  \*********************************************************************/
/*! exports provided: LegendDataItem, LegendSettings, Legend */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LegendDataItem", function() { return LegendDataItem; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LegendSettings", function() { return LegendSettings; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Legend", function() { return Legend; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _core_Component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../core/Component */ "./node_modules/@amcharts/amcharts4/.internal/core/Component.js");
/* harmony import */ var _core_DataItem__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core/DataItem */ "./node_modules/@amcharts/amcharts4/.internal/core/DataItem.js");
/* harmony import */ var _core_utils_List__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../core/utils/List */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/List.js");
/* harmony import */ var _core_elements_RoundedRectangle__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../core/elements/RoundedRectangle */ "./node_modules/@amcharts/amcharts4/.internal/core/elements/RoundedRectangle.js");
/* harmony import */ var _core_Container__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../core/Container */ "./node_modules/@amcharts/amcharts4/.internal/core/Container.js");
/* harmony import */ var _core_elements_Label__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../core/elements/Label */ "./node_modules/@amcharts/amcharts4/.internal/core/elements/Label.js");
/* harmony import */ var _core_utils_Keyboard__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../core/utils/Keyboard */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Keyboard.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_interaction_Interaction__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../core/interaction/Interaction */ "./node_modules/@amcharts/amcharts4/.internal/core/interaction/Interaction.js");
/* harmony import */ var _core_utils_Percent__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../core/utils/Percent */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Percent.js");
/* harmony import */ var _core_utils_InterfaceColorSet__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../core/utils/InterfaceColorSet */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/InterfaceColorSet.js");
/* harmony import */ var _core_utils_Utils__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../core/utils/Utils */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Utils.js");
/* harmony import */ var _core_utils_Type__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../core/utils/Type */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Type.js");
/* harmony import */ var _core_utils_Math__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../core/utils/Math */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Math.js");
/* harmony import */ var _core_Sprite__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../core/Sprite */ "./node_modules/@amcharts/amcharts4/.internal/core/Sprite.js");
/* harmony import */ var _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../core/utils/Disposer */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Disposer.js");
/* harmony import */ var _core_interaction_Mouse__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../core/interaction/Mouse */ "./node_modules/@amcharts/amcharts4/.internal/core/interaction/Mouse.js");
/* harmony import */ var _core_utils_Responsive__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../core/utils/Responsive */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Responsive.js");
/* harmony import */ var _core_elements_Scrollbar__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../core/elements/Scrollbar */ "./node_modules/@amcharts/amcharts4/.internal/core/elements/Scrollbar.js");
/**
 * Legend-related functionality.
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */




















/**
 * ============================================================================
 * DATA ITEM
 * ============================================================================
 * @hidden
 */

/**
 * Defines a [[DataItem]] for [[Legend]].
 *
 * @see {@link DataItem}
 */

var LegendDataItem =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(LegendDataItem, _super);
  /**
   * Constructor
   */


  function LegendDataItem() {
    var _this = _super.call(this) || this;
    /**
     * @ignore
     */


    _this.childrenCreated = false;
    _this.className = "LegendDataItem";

    _this.applyTheme();

    return _this;
  }

  Object.defineProperty(LegendDataItem.prototype, "label", {
    /**
     * A legend item's [[Label]] element.
     *
     * @return Label
     */
    get: function get() {
      var _this = this;

      if (!this._label) {
        var label_1 = this.component.labels.create();
        this._label = label_1;
        this.addSprite(label_1);

        this._disposers.push(label_1);

        label_1.parent = this.itemContainer;

        this._disposers.push(new _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_16__["Disposer"](function () {
          if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_13__["hasValue"](_this.component)) {
            _this.component.labels.removeValue(label_1);
          }
        }));
      }

      return this._label;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(LegendDataItem.prototype, "color", {
    /**
     * @return Main color
     */
    get: function get() {
      return this.properties.color;
    },

    /**
     * Main color of legend data item.
     *
     * This is set by the target element this legend item represents, like
     * a Series or a Slice.
     *
     * It can be used to derive a color in legend's sub-items, like label:
     *
     * ```TypeScript
     * chart.legend.labels.template.text = "[{color}]{name}[/]";
     * ```
     * ```JavaScript
     * chart.legend.labels.template.text = "[{color}]{name}[/]";
     * ```
     * ```JSON
     * {
     *   // ...
     *   "legend": {
     *     // ...
     *     "labels": {
     *       "text": "[{color}]{name}[/]"
     *     }
     *   }
     * }
     * ```
     *
     * @see {@link https://www.amcharts.com/docs/v4/concepts/legend/#Legend_labels} For more information about configuring legend labels.
     * @param value  Main color
     */
    set: function set(value) {
      this.setProperty("color", value);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(LegendDataItem.prototype, "valueLabel", {
    /**
     * A legend item's [[Label]] element for "value label".
     *
     * @return Label
     */
    get: function get() {
      var _this = this;

      if (!this._valueLabel) {
        var valueLabel_1 = this.component.valueLabels.create();
        this._valueLabel = valueLabel_1;
        this.addSprite(valueLabel_1);

        this._disposers.push(valueLabel_1);

        valueLabel_1.parent = this.itemContainer;

        this._disposers.push(new _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_16__["Disposer"](function () {
          if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_13__["hasValue"](_this.component)) {
            _this.component.valueLabels.removeValue(valueLabel_1);
          }
        }));
      }

      return this._valueLabel;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(LegendDataItem.prototype, "itemContainer", {
    /**
     * A reference to the main [[Container]] that holds legend item's elements:
     * marker and labels.
     *
     * @return Item container
     */
    get: function get() {
      var _this = this;

      if (!this._itemContainer) {
        var component_1 = this.component;
        var itemContainer_1 = component_1.itemContainers.create();
        itemContainer_1.parent = component_1;
        this._itemContainer = itemContainer_1;
        this.addSprite(itemContainer_1);

        this._disposers.push(itemContainer_1); // Add click/tap event to toggle item


        if (itemContainer_1.togglable) {
          itemContainer_1.events.on("toggled", function (ev) {
            component_1.toggleDataItem(ev.target.dataItem);
          }, undefined, false);
        } // Add focus event so that we can track which object is currently in focus
        // for keyboard toggling


        if (itemContainer_1.focusable) {
          itemContainer_1.events.on("hit", function (ev) {
            // We need this here in order to reset focused item when it is clicked
            // normally so that it is not toggled by ENTER afterwards
            component_1.focusedItem = undefined;
          }, undefined, false);
          itemContainer_1.events.on("focus", function (ev) {
            component_1.focusedItem = ev.target.dataItem;
          }, undefined, false);
          itemContainer_1.events.on("blur", function (ev) {
            component_1.focusedItem = undefined;
          }, undefined, false);
        }

        this._disposers.push(new _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_16__["Disposer"](function () {
          if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_13__["hasValue"](_this.component)) {
            _this.component.itemContainers.removeValue(itemContainer_1);
          }
        }));

        if (this.dataContext.uidAttr) {
          itemContainer_1.readerControls = this.dataContext.uidAttr();
          itemContainer_1.readerLabelledBy = this.dataContext.uidAttr();
        }

        var sprite = this.dataContext;

        if ((sprite instanceof _core_DataItem__WEBPACK_IMPORTED_MODULE_2__["DataItem"] || sprite instanceof _core_Sprite__WEBPACK_IMPORTED_MODULE_15__["Sprite"]) && !sprite.isDisposed()) {
          var visibilitychanged = function visibilitychanged(ev) {
            itemContainer_1.readerChecked = ev.visible;
            itemContainer_1.events.disableType("toggled");
            itemContainer_1.isActive = !ev.visible;
            itemContainer_1.events.enableType("toggled");
          };

          sprite.addDisposer(new _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_16__["Disposer"](function () {
            if (_this.component) {
              _this.component.dataItems.remove(_this);
            }
          }));

          if (sprite instanceof _core_Sprite__WEBPACK_IMPORTED_MODULE_15__["Sprite"]) {
            itemContainer_1.addDisposer(sprite.events.on("visibilitychanged", visibilitychanged, undefined, false));
            itemContainer_1.addDisposer(sprite.events.on("hidden", function (ev) {
              itemContainer_1.readerChecked = false;
              itemContainer_1.events.disableType("toggled");
              itemContainer_1.isActive = true;
              itemContainer_1.events.enableType("toggled");
            }, undefined, false));
            itemContainer_1.addDisposer(sprite.events.on("shown", function (ev) {
              itemContainer_1.readerChecked = true;
              itemContainer_1.events.disableType("toggled");
              itemContainer_1.isActive = false;
              itemContainer_1.events.enableType("toggled");
            }, undefined, false));
          } else {
            itemContainer_1.addDisposer(sprite.events.on("visibilitychanged", visibilitychanged, undefined, false));
          }
        }
      }

      return this._itemContainer;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(LegendDataItem.prototype, "marker", {
    /**
     * A [[Container]] that holds legend item's marker element.
     *
     * @return Marker
     */
    get: function get() {
      var _this = this;

      if (!this._marker) {
        var marker_1 = this.component.markers.create();
        this._marker = marker_1;
        marker_1.parent = this.itemContainer;
        this.addSprite(marker_1);

        this._disposers.push(marker_1);

        this._disposers.push(new _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_16__["Disposer"](function () {
          if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_13__["hasValue"](_this.component)) {
            _this.component.markers.removeValue(marker_1);
          }
        }));
      }

      return this._marker;
    },
    enumerable: true,
    configurable: true
  });
  return LegendDataItem;
}(_core_DataItem__WEBPACK_IMPORTED_MODULE_2__["DataItem"]);


/**
 * ============================================================================
 * REQUISITES
 * ============================================================================
 * @hidden
 */

/**
 * Defines a class that carries legend settings.
 *
 * A legend might change its settings dynamically. Legend can also be shared
 * by several elements, requiring different settings.
 *
 * Having legend's settings in a separate object is a good way to "hot swap"
 * a set of settings for the legend.
 */

var LegendSettings =
/** @class */
function () {
  function LegendSettings() {
    /**
     * Should marker be created for each legend item.
     */
    this.createMarker = true;
  }

  return LegendSettings;
}();


/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * [[Legend]] class is used to create legend for the chart.
 *
 * @see {@link https://www.amcharts.com/docs/v4/concepts/legend/} for Legend documentation
 * @see {@link ILegendEvents} for a list of available events
 * @see {@link ILegendAdapters} for a list of available Adapters
 */

var Legend =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(Legend, _super);
  /**
   * Constructor
   */


  function Legend() {
    var _this = _super.call(this) || this;

    _this.className = "Legend"; // Set defaults

    _this.layout = "grid";

    _this.setPropertyValue("useDefaultMarker", false);

    _this.setPropertyValue("scrollable", false);

    _this.setPropertyValue("contentAlign", "center"); // Create a template container and list for legend items


    var itemContainer = new _core_Container__WEBPACK_IMPORTED_MODULE_5__["Container"]();
    itemContainer.applyOnClones = true;
    itemContainer.padding(8, 0, 8, 0);
    itemContainer.margin(0, 10, 0, 10);
    itemContainer.layout = "horizontal";
    itemContainer.clickable = true;
    itemContainer.focusable = true;
    itemContainer.role = "switch";
    itemContainer.togglable = true;
    itemContainer.cursorOverStyle = _core_interaction_Mouse__WEBPACK_IMPORTED_MODULE_17__["MouseCursorStyle"].pointer;
    itemContainer.background.fillOpacity = 0; // creates hit area
    // Create container list using item template we just created

    _this.itemContainers = new _core_utils_List__WEBPACK_IMPORTED_MODULE_3__["ListTemplate"](itemContainer);

    _this._disposers.push(new _core_utils_List__WEBPACK_IMPORTED_MODULE_3__["ListDisposer"](_this.itemContainers));

    _this._disposers.push(_this.itemContainers.template); // Set up global keyboard events for toggling elements


    _this._disposers.push(Object(_core_interaction_Interaction__WEBPACK_IMPORTED_MODULE_9__["getInteraction"])().body.events.on("keyup", function (ev) {
      if (_core_utils_Keyboard__WEBPACK_IMPORTED_MODULE_7__["keyboard"].isKey(ev.event, "enter") && _this.focusedItem) {
        var focusedItem = _this.focusedItem;
        var target = focusedItem.itemContainer;

        if (target.togglable) {
          _this.toggleDataItem(focusedItem);
        } else if (target.clickable && target.events.isEnabled("hit")) {
          target.dispatchImmediately("hit", {
            event: ev
          }); // We need this here because "hit" event resets `this.focusedItem`
          // And we need it here

          _this.focusedItem = focusedItem;
        }
      }
    }, _this));

    var interfaceColors = new _core_utils_InterfaceColorSet__WEBPACK_IMPORTED_MODULE_11__["InterfaceColorSet"](); // Create a template container and list for the a marker

    var marker = new _core_Container__WEBPACK_IMPORTED_MODULE_5__["Container"]();
    marker.width = 23;
    marker.height = 23;
    marker.interactionsEnabled = false;
    marker.applyOnClones = true;
    marker.setStateOnChildren = true;
    marker.background.fillOpacity = 0;
    marker.background.strokeOpacity = 0;
    marker.propertyFields.fill = "fill";
    marker.valign = "middle";
    var disabledColor = interfaceColors.getFor("disabledBackground");
    marker.events.on("childadded", function (event) {
      var child = event.newValue;
      var activeState = child.states.create("active");
      activeState.properties.stroke = disabledColor;
      activeState.properties.fill = disabledColor;
    });
    _this.markers = new _core_utils_List__WEBPACK_IMPORTED_MODULE_3__["ListTemplate"](marker);

    _this._disposers.push(new _core_utils_List__WEBPACK_IMPORTED_MODULE_3__["ListDisposer"](_this.markers));

    _this._disposers.push(_this.markers.template); // Create a legend background element


    var rectangle = marker.createChild(_core_elements_RoundedRectangle__WEBPACK_IMPORTED_MODULE_4__["RoundedRectangle"]);
    rectangle.width = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_10__["percent"])(100);
    rectangle.height = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_10__["percent"])(100);
    rectangle.applyOnClones = true;
    rectangle.propertyFields.fill = "fill"; //othrwise old edge doesn't like as the same pattern is set both on parent and child https://codepen.io/team/amcharts/pen/72d7a98f3fb811d3118795220ff63182

    rectangle.strokeOpacity = 0; // Create a template container and list for item labels

    var label = new _core_elements_Label__WEBPACK_IMPORTED_MODULE_6__["Label"]();
    label.text = "{name}";
    label.margin(0, 5, 0, 5);
    label.valign = "middle";
    label.applyOnClones = true;
    label.states.create("active").properties.fill = interfaceColors.getFor("disabledBackground");
    _this.labels = new _core_utils_List__WEBPACK_IMPORTED_MODULE_3__["ListTemplate"](label);

    _this._disposers.push(new _core_utils_List__WEBPACK_IMPORTED_MODULE_3__["ListDisposer"](_this.labels));

    _this._disposers.push(_this.labels.template);

    label.interactionsEnabled = false;
    label.truncate = true;
    label.fullWords = false; // Create a template container and list for item value labels

    var valueLabel = new _core_elements_Label__WEBPACK_IMPORTED_MODULE_6__["Label"]();
    valueLabel.margin(0, 5, 0, 0);
    valueLabel.valign = "middle";
    valueLabel.width = 50; // to avoid rearranging legend entries when value changes.

    valueLabel.align = "right";
    valueLabel.textAlign = "end";
    valueLabel.applyOnClones = true;
    valueLabel.states.create("active").properties.fill = interfaceColors.getFor("disabledBackground");
    valueLabel.interactionsEnabled = false;
    _this.valueLabels = new _core_utils_List__WEBPACK_IMPORTED_MODULE_3__["ListTemplate"](valueLabel);

    _this._disposers.push(new _core_utils_List__WEBPACK_IMPORTED_MODULE_3__["ListDisposer"](_this.valueLabels));

    _this._disposers.push(_this.valueLabels.template);

    _this.position = "bottom"; // don't use setPropertyValue here!
    // Create a state for disabled legend items

    itemContainer.states.create("active");
    itemContainer.setStateOnChildren = true; // Apply accessibility settings

    _this.role = "group";

    _this.events.on("layoutvalidated", _this.handleScrollbar, _this, false);

    _this.applyTheme();

    return _this;
  }
  /**
   * Sets defaults that instantiate some objects that rely on parent, so they
   * cannot be set in constructor.
   */


  Legend.prototype.applyInternalDefaults = function () {
    _super.prototype.applyInternalDefaults.call(this);

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_13__["hasValue"](this.readerTitle)) {
      this.readerTitle = this.language.translate("Legend");
    }
  };
  /**
   * Returns a new/empty DataItem of the type appropriate for this object.
   *
   * @see {@link DataItem}
   * @return Data Item
   */


  Legend.prototype.createDataItem = function () {
    return new LegendDataItem();
  };
  /**
   * [validateDataElements description]
   *
   * @ignore Exclude from docs
   * @todo Description
   */


  Legend.prototype.validateDataElements = function () {
    if (this.scrollbar) {
      this.scrollbar.start = 0;
      this.scrollbar.end = 1;
    }

    _super.prototype.validateDataElements.call(this);
  };
  /**
   * [validateDataElement description]
   *
   * @ignore Exclude from docs
   * @param dataItem Data item
   * @todo Description
   * @todo Figure out how to update appearance of legend item without losing focus
   * @todo Update legend marker appearance as apperance of related series changes
   */


  Legend.prototype.validateDataElement = function (dataItem) {
    _super.prototype.validateDataElement.call(this, dataItem); // Get data item (legend item's) container


    var container = dataItem.itemContainer;
    var marker = dataItem.marker;
    _core_utils_Utils__WEBPACK_IMPORTED_MODULE_12__["used"](dataItem.label);
    var valueLabel = dataItem.valueLabel; // Set parent and update current state

    container.readerChecked = dataItem.dataContext.visible; // Tell series its legend data item

    dataItem.dataContext.legendDataItem = dataItem;
    var tempMaxWidth = dataItem.label.maxWidth;

    if (!(dataItem.label.width instanceof _core_utils_Percent__WEBPACK_IMPORTED_MODULE_10__["Percent"])) {
      dataItem.label.width = undefined;
    }

    if (tempMaxWidth > 0) {
      dataItem.label.maxWidth = tempMaxWidth;
    }

    if (valueLabel.align == "right") {
      valueLabel.width = undefined;
    }

    var legendSettings = dataItem.dataContext.legendSettings; // If we are not using default markers, create a unique legend marker based
    // on the data item type

    var dataContext = dataItem.dataContext;

    if (dataContext.createLegendMarker && (!this.useDefaultMarker || !(dataContext instanceof _core_Sprite__WEBPACK_IMPORTED_MODULE_15__["Sprite"]))) {
      if (!dataItem.childrenCreated) {
        dataContext.createLegendMarker(marker);
        dataItem.childrenCreated = true;
      }
    } else {
      this.markers.template.propertyFields.fill = undefined;
    }

    if (dataContext.updateLegendValue) {
      dataContext.updateLegendValue(); // this solves issue with external legend, as legend is created after chart updates legend values
    }

    if (dataContext.component && dataContext.component.updateLegendValue) {
      dataContext.component.updateLegendValue(dataContext);
    }

    if (valueLabel.invalid) {
      valueLabel.validate();
    }

    if (valueLabel.text == "" || valueLabel.text == undefined) {
      valueLabel.__disabled = true;
    } else {
      valueLabel.__disabled = false;
    }

    if (legendSettings && (legendSettings.itemValueText != undefined || legendSettings.valueText != undefined)) {
      valueLabel.__disabled = false;
    }

    var visible = dataItem.dataContext.visible;

    if (visible === undefined) {
      visible = true;
    }

    visible = _core_utils_Type__WEBPACK_IMPORTED_MODULE_13__["toBoolean"](visible);
    dataItem.dataContext.visible = visible;
    container.events.disableType("toggled");
    container.isActive = !visible;

    if (container.isActive) {
      container.setState("active", 0);
    } else {
      container.setState("default", 0);
    }

    container.events.enableType("toggled");
  };

  Legend.prototype.afterDraw = function () {
    var _this = this;

    var maxWidth = this.getPropertyValue("maxWidth");
    var maxLabelWidth = 0;
    this.labels.each(function (label) {
      if (label.invalid) {
        label.maxWidth = undefined;
        label.validate();
      }

      if (label.measuredWidth + label.pixelMarginLeft + label.pixelMarginRight > maxLabelWidth) {
        maxLabelWidth = label.measuredWidth + label.pixelMarginLeft + label.pixelMarginRight;
      }
    });
    var maxValueLabelWidth = 0;
    this.valueLabels.each(function (label) {
      if (label.invalid) {
        label.validate();
      }

      if (label.measuredWidth + label.pixelMarginLeft + label.pixelMarginRight > maxValueLabelWidth) {
        maxValueLabelWidth = label.measuredWidth + label.pixelMarginLeft + label.pixelMarginRight;
      }
    });
    var maxMarkerWidth = 0;
    this.markers.each(function (marker) {
      if (marker.invalid) {
        marker.validate();
      }

      if (marker.measuredWidth + marker.pixelMarginLeft + marker.pixelMarginRight > maxMarkerWidth) {
        maxMarkerWidth = marker.measuredWidth + marker.pixelMarginLeft + marker.pixelMarginRight;
      }
    });
    var itemContainer = this.itemContainers.template;
    var margin = itemContainer.pixelMarginRight + itemContainer.pixelMarginLeft;
    var maxAdjustedLabelWidth;
    var trueMaxWidth = maxLabelWidth + maxValueLabelWidth + maxMarkerWidth;

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_13__["isNumber"](maxWidth)) {
      maxAdjustedLabelWidth = maxLabelWidth;
    } else {
      maxWidth = maxWidth - margin;

      if (maxWidth > trueMaxWidth) {
        maxWidth = trueMaxWidth;
      }

      maxAdjustedLabelWidth = maxWidth - maxMarkerWidth - maxValueLabelWidth;
    }

    this.labels.each(function (label) {
      if (_this.valueLabels.template.align == "right" || label.measuredWidth > maxAdjustedLabelWidth) {
        if (!(label.width instanceof _core_utils_Percent__WEBPACK_IMPORTED_MODULE_10__["Percent"])) {
          label.width = Math.min(label.maxWidth, maxAdjustedLabelWidth - label.pixelMarginLeft - label.pixelMarginRight);
          label.maxWidth = label.width;
        }
      }
    });

    if (this.valueLabels.template.align == "right") {
      this.valueLabels.each(function (valueLabel) {
        valueLabel.width = maxValueLabelWidth - valueLabel.pixelMarginRight - valueLabel.pixelMarginLeft;
      });
    }

    _super.prototype.afterDraw.call(this);
  };

  Legend.prototype.handleScrollbar = function () {
    var scrollbar = this.scrollbar;

    if (this.scrollable && scrollbar) {
      scrollbar.height = this.measuredHeight;
      scrollbar.x = this.measuredWidth - scrollbar.pixelWidth - scrollbar.pixelMarginLeft;

      if (this.contentHeight > this.measuredHeight) {
        scrollbar.visible = true;
        scrollbar.thumb.height = scrollbar.height * this.measuredHeight / this.contentHeight;
        this.paddingRight = scrollbar.pixelWidth + scrollbar.pixelMarginLeft + +scrollbar.pixelMarginRight;
      } else {
        scrollbar.visible = false;
      }

      this.updateMasks();
    }
  };

  Object.defineProperty(Legend.prototype, "position", {
    /**
     * @return Position
     */
    get: function get() {
      return this.getPropertyValue("position");
    },

    /**
     * Position of the legend.
     *
     * Options: "left", "right", "top", "bottom" (default), or "absolute".
     *
     * IMPORTANT: [[MapChart]] will ignore this setting, as it is using different
     * layout structure than other charts.
     *
     * To position legend in [[MapChart]] set legend's `align` (`"left"` or
     * `"right"`) and `valign` (`"top"` or `"bottom"`) properties instead.
     *
     * @default "bottom"
     * @param value  Position
     */
    set: function set(value) {
      if (this.setPropertyValue("position", value)) {
        if (value == "left" || value == "right") {
          this.margin(10, 5, 10, 10);
          this.valign = "middle";
          this.contentAlign = "none";
          this.valueLabels.template.align = "right";

          if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_13__["isNumber"](this.maxColumns)) {
            this.maxColumns = 1;
          }

          this.width = undefined;
          this.maxWidth = 220;
        } else {
          this.maxColumns = undefined;
          this.width = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_10__["percent"])(100);
          this.valueLabels.template.align = "left";
        }

        this.invalidate();
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(Legend.prototype, "useDefaultMarker", {
    /**
     * @return Use default marker?
     */
    get: function get() {
      return this.getPropertyValue("useDefaultMarker");
    },

    /**
     * Should legend try to mirror the look of the related item when building
     * the marker for legend item?
     *
     * If set to `false` it will try to make the marker look like its related
     * item.
     *
     * E.g. if an item is for a Line Series, it will display a line of the
     * same thickness, color, and will use the same bullets if series have them.
     *
     * If set to `true`, all markers will be shown as squares, regardless of te
     * series type.
     *
     * @default false
     * @param value Use default marker?
     */
    set: function set(value) {
      this.setPropertyValue("useDefaultMarker", value, true);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(Legend.prototype, "scrollable", {
    /**
     * @return Legend Scrollable?
     */
    get: function get() {
      return this.getPropertyValue("scrollable");
    },

    /**
     * If set to `true` the Legend will display a scrollbar if its contents do
     * not fit into its `maxHeight`.
     *
     * Please note that `maxHeight` is automatically set for Legend when its
     * `position` is set to `"left"` or `"right"`.
     *
     * @default false
     * @since 4.8.0
     * @param  value  Legend Scrollable?
     */
    set: function set(value) {
      if (this.setPropertyValue("scrollable", value, true)) {
        if (value) {
          var scrollbar = this.createChild(_core_elements_Scrollbar__WEBPACK_IMPORTED_MODULE_19__["Scrollbar"]);
          this.scrollbar = scrollbar;
          scrollbar.isMeasured = false;
          scrollbar.orientation = "vertical";
          scrollbar.endGrip.__disabled = true;
          scrollbar.startGrip.__disabled = true;
          scrollbar.visible = false;
          scrollbar.marginLeft = 5;
          this._mouseWheelDisposer = this.events.on("wheel", this.handleWheel, this, false);

          this._disposers.push(this._mouseWheelDisposer);

          this._disposers.push(scrollbar.events.on("rangechanged", this.updateMasks, this, false));
        } else {
          if (this._mouseWheelDisposer) {
            this._mouseWheelDisposer.dispose();

            if (this.scrollbar) {
              this.scrollbar.dispose();
              this.scrollbar = undefined;
            }
          }
        }
      }
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Handles mouse wheel scrolling of legend.
   *
   * @param  event  Event
   */

  Legend.prototype.handleWheel = function (event) {
    var shift = event.shift.y;
    var scrollbar = this.scrollbar;

    if (scrollbar) {
      var ds = shift / 1000 * this.measuredHeight / this.contentHeight;
      var delta = scrollbar.end - scrollbar.start;

      if (shift > 0) {
        scrollbar.start = _core_utils_Math__WEBPACK_IMPORTED_MODULE_14__["max"](0, scrollbar.start - ds);
        scrollbar.end = scrollbar.start + delta;
      } else {
        scrollbar.end = _core_utils_Math__WEBPACK_IMPORTED_MODULE_14__["min"](1, scrollbar.end - ds);
        scrollbar.start = scrollbar.end - delta;
      }
    }
  };
  /**
   * @ignore
   */


  Legend.prototype.updateMasks = function () {
    var _this = this;

    if (this.scrollbar) {
      this.itemContainers.each(function (itemContainer) {
        itemContainer.dy = -_this.scrollbar.thumb.pixelY * _this.contentHeight / _this.measuredHeight;
        itemContainer.maskRectangle = {
          x: 0,
          y: -itemContainer.dy,
          width: _this.measuredWidth,
          height: _this.measuredHeight
        };
      });
    }
  };
  /**
   * Toggles a legend item.
   *
   * @ignore Exclude from docs
   * @param item Legend item
   * @todo Maybe do it with togglable instead
   */


  Legend.prototype.toggleDataItem = function (item) {
    var dataContext = item.dataContext;

    if (!dataContext.visible || dataContext.isHiding || dataContext instanceof _core_Sprite__WEBPACK_IMPORTED_MODULE_15__["Sprite"] && dataContext.isHidden) {
      item.color = item.colorOrig;
      item.itemContainer.isActive = false;

      if (dataContext.hidden === true) {
        dataContext.hidden = false;
      }

      if (dataContext.show) {
        dataContext.show();
      } else {
        dataContext.visible = true;
      }

      this.svgContainer.readerAlert(this.language.translate("%1 shown", this.language.locale, item.label.readerTitle));
    } else {
      item.itemContainer.isActive = true;

      if (dataContext.hide) {
        dataContext.hide();
      } else {
        dataContext.visible = false;
      }

      this.svgContainer.readerAlert(this.language.translate("%1 hidden", this.language.locale, item.label.readerTitle));
      item.color = new _core_utils_InterfaceColorSet__WEBPACK_IMPORTED_MODULE_11__["InterfaceColorSet"]().getFor("disabledBackground");
    }
  };

  Object.defineProperty(Legend.prototype, "preloader", {
    /**
     * Override preloader method so that legend does not accidentally show its
     * own preloader.
     *
     * @ignore Exclude from docs
     * @return Always `undefined`
     */
    get: function get() {
      return;
    },
    enumerable: true,
    configurable: true
  });
  /**
   * [handleDataItemPropertyChange description]
   *
   * @ignore Exclude from docs
   */

  Legend.prototype.handleDataItemPropertyChange = function (dataItem, name) {
    dataItem.valueLabel.invalidate();
    dataItem.label.invalidate();
  };

  return Legend;
}(_core_Component__WEBPACK_IMPORTED_MODULE_1__["Component"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_8__["registry"].registeredClasses["Legend"] = Legend;
/**
 * Add default responsive rules
 */

/**
 * Move legend to below the chart if chart is narrow
 */

_core_utils_Responsive__WEBPACK_IMPORTED_MODULE_18__["defaultRules"].push({
  relevant: _core_utils_Responsive__WEBPACK_IMPORTED_MODULE_18__["ResponsiveBreakpoints"].widthXS,
  state: function state(target, stateId) {
    if (target instanceof Legend && (target.position == "left" || target.position == "right")) {
      var state = target.states.create(stateId);
      state.properties.position = "bottom";
      return state;
    }

    return null;
  }
});
/**
 * Move legend to the right if chart is very short
 */

_core_utils_Responsive__WEBPACK_IMPORTED_MODULE_18__["defaultRules"].push({
  relevant: _core_utils_Responsive__WEBPACK_IMPORTED_MODULE_18__["ResponsiveBreakpoints"].heightXS,
  state: function state(target, stateId) {
    if (target instanceof Legend && (target.position == "top" || target.position == "bottom")) {
      var state = target.states.create(stateId);
      state.properties.position = "right";
      return state;
    }

    return null;
  }
});
/**
 * Disable legend altogether on small charts
 */

_core_utils_Responsive__WEBPACK_IMPORTED_MODULE_18__["defaultRules"].push({
  relevant: _core_utils_Responsive__WEBPACK_IMPORTED_MODULE_18__["ResponsiveBreakpoints"].isXS,
  state: function state(target, stateId) {
    if (target instanceof Legend) {
      var state = target.states.create(stateId);
      state.properties.disabled = true;
      return state;
    }

    return null;
  }
});

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/Axis.js":
/*!************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/axes/Axis.js ***!
  \************************************************************************/
/*! exports provided: AxisDataItem, AxisItemLocation, Axis */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AxisDataItem", function() { return AxisDataItem; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AxisItemLocation", function() { return AxisItemLocation; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Axis", function() { return Axis; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _core_Component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core/Component */ "./node_modules/@amcharts/amcharts4/.internal/core/Component.js");
/* harmony import */ var _core_Container__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/Container */ "./node_modules/@amcharts/amcharts4/.internal/core/Container.js");
/* harmony import */ var _core_DataItem__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/DataItem */ "./node_modules/@amcharts/amcharts4/.internal/core/DataItem.js");
/* harmony import */ var _AxisBreak__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./AxisBreak */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisBreak.js");
/* harmony import */ var _core_elements_Label__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core/elements/Label */ "./node_modules/@amcharts/amcharts4/.internal/core/elements/Label.js");
/* harmony import */ var _core_elements_Tooltip__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core/elements/Tooltip */ "./node_modules/@amcharts/amcharts4/.internal/core/elements/Tooltip.js");
/* harmony import */ var _core_utils_SortedList__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../core/utils/SortedList */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/SortedList.js");
/* harmony import */ var _core_utils_List__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../core/utils/List */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/List.js");
/* harmony import */ var _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../core/utils/Disposer */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Disposer.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_utils_InterfaceColorSet__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../core/utils/InterfaceColorSet */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/InterfaceColorSet.js");
/* harmony import */ var _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../core/utils/Iterator */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Iterator.js");
/* harmony import */ var _core_utils_Math__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../core/utils/Math */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Math.js");
/* harmony import */ var _core_utils_Utils__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../core/utils/Utils */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Utils.js");
/* harmony import */ var _core_utils_Number__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../core/utils/Number */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Number.js");
/* harmony import */ var _core_utils_Array__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../core/utils/Array */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Array.js");
/* harmony import */ var _core_utils_Type__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../core/utils/Type */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Type.js");
/* harmony import */ var _core_utils_Responsive__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../core/utils/Responsive */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Responsive.js");
/**
 * Base class for all Axis
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */



















/**
 * ============================================================================
 * DATA ITEM
 * ============================================================================
 * @hidden
 */

/**
 * Defines a [[DataItem]] for [[Axis]].
 *
 * @see {@link DataItem}
 */

var AxisDataItem =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(AxisDataItem, _super);
  /**
   * Constructor
   */


  function AxisDataItem() {
    var _this = _super.call(this) || this;

    _this.className = "AxisDataItem";

    _this.applyTheme();

    return _this;
  }

  Object.defineProperty(AxisDataItem.prototype, "grid", {
    /**
     * @return Grid element
     */
    get: function get() {
      if (!this._grid) {
        var component_1 = this.component;

        if (component_1) {
          var template = void 0;
          var grid_1;

          if (this.isRange) {
            template = component_1.axisRanges.template.grid;

            if (template.disabled) {
              return;
            } else {
              grid_1 = template.clone();
            }
          } else {
            template = component_1.renderer.grid.template;

            if (template.disabled) {
              return;
            } else {
              grid_1 = component_1.renderer.grid.create();

              this._disposers.push(new _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_9__["Disposer"](function () {
                component_1.renderer.grid.removeValue(grid_1);
              }));
            }
          }

          this.grid = grid_1;
          grid_1.shouldClone = false;

          this._disposers.push(grid_1);

          grid_1.axis = this.component;
        }
      }

      return this._grid;
    },

    /**
     * A [[Grid]] element associated with this data item.
     *
     * If there is no grid element associated with data item, a new one is
     * created and returned.
     *
     * @param grid  Grid element
     */
    set: function set(grid) {
      if (this._grid && this._grid != grid) {
        _core_utils_Array__WEBPACK_IMPORTED_MODULE_16__["remove"](this.sprites, this._grid);
        this._grid.dataItem = undefined;
      }

      if (grid) {
        if (grid.dataItem && grid.dataItem != this) {
          _core_utils_Array__WEBPACK_IMPORTED_MODULE_16__["remove"](grid.dataItem.sprites, grid);
          grid.dataItem.grid = undefined;
        }

        this.addSprite(grid);
      }

      this._grid = grid;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisDataItem.prototype, "tick", {
    /**
     * @return Tick element
     */
    get: function get() {
      if (!this._tick) {
        var component_2 = this.component;

        if (component_2) {
          var template = void 0;
          var tick_1;

          if (this.isRange) {
            template = component_2.axisRanges.template.tick;

            if (template.disabled) {
              return;
            } else {
              tick_1 = template.clone();
            }
          } else {
            template = component_2.renderer.ticks.template;

            if (template.disabled) {
              return;
            } else {
              tick_1 = component_2.renderer.ticks.create();

              this._disposers.push(new _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_9__["Disposer"](function () {
                component_2.renderer.ticks.removeValue(tick_1);
              }));
            }
          }

          this.tick = tick_1;
          tick_1.axis = this.component;
          tick_1.shouldClone = false;

          this._disposers.push(tick_1);
        }
      }

      return this._tick;
    },

    /**
     * An [[AxisTick]] element associated with this data item.
     *
     * If there is no tick element associated with data item, a new one is
     * created and returned.
     *
     * @param tick  Tick element
     */
    set: function set(tick) {
      if (this._tick && this._tick != tick) {
        _core_utils_Array__WEBPACK_IMPORTED_MODULE_16__["remove"](this.sprites, this._tick);
        this._tick.dataItem = undefined;
      }

      if (tick) {
        if (tick.dataItem && tick.dataItem != this) {
          _core_utils_Array__WEBPACK_IMPORTED_MODULE_16__["remove"](tick.dataItem.sprites, tick);
          tick.dataItem.tick = undefined;
        }

        this.addSprite(tick);
      }

      this._tick = tick;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisDataItem.prototype, "label", {
    /**
     * @return Label element
     */
    get: function get() {
      if (!this._label) {
        var component_3 = this.component;

        if (component_3) {
          var template = void 0;
          var label_1;

          if (this.isRange) {
            template = component_3.axisRanges.template.label;

            if (template.disabled) {
              return;
            } else {
              label_1 = template.clone();
            }
          } else {
            template = component_3.renderer.labels.template;

            if (template.disabled) {
              return;
            } else {
              label_1 = component_3.renderer.labels.create();

              this._disposers.push(new _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_9__["Disposer"](function () {
                component_3.renderer.labels.removeValue(label_1);
              }));
            }
          }

          this._disposers.push(label_1);

          this.label = label_1;
          label_1.shouldClone = false;
          label_1.axis = this.component;
          label_1.virtualParent = component_3;
        }
      }

      return this._label;
    },

    /**
     * An [[AxisLabel]] element associated with this data item.
     *
     * If there is no label element associated with data item, a new one is
     * created and returned.
     *
     * @param label Label element
     */
    set: function set(label) {
      if (this._label && this._label != label) {
        _core_utils_Array__WEBPACK_IMPORTED_MODULE_16__["remove"](this.sprites, this._label);
        this._label.dataItem = undefined;
      }

      if (label) {
        if (label.dataItem && label.dataItem != this) {
          _core_utils_Array__WEBPACK_IMPORTED_MODULE_16__["remove"](label.dataItem.sprites, label);
          label.dataItem.label = undefined;
        }

        this.addSprite(label);
      }

      this._label = label;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisDataItem.prototype, "axisFill", {
    /**
     * @return Label element
     */
    get: function get() {
      if (!this._axisFill) {
        var component_4 = this.component;

        if (component_4) {
          var template = void 0;
          var axisFill_1;

          if (this.isRange) {
            template = component_4.axisRanges.template.axisFill;

            if (!this.isTemplate && template.disabled) {
              return;
            } else {
              axisFill_1 = template.clone();
            }
          } else {
            template = component_4.renderer.axisFills.template;

            if (template.disabled) {
              return;
            } else {
              axisFill_1 = component_4.renderer.axisFills.create();

              this._disposers.push(new _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_9__["Disposer"](function () {
                component_4.renderer.axisFills.removeValue(axisFill_1);
              }));
            }
          }

          this.axisFill = axisFill_1;
          axisFill_1.shouldClone = false;

          this._disposers.push(axisFill_1);
        }
      }

      return this._axisFill;
    },

    /**
     * An [[AxisFill]] associated element with this data item.
     *
     * If there is no fill element associated with data item, a new one is
     * created and returned.
     *
     * @param label Label element
     */
    set: function set(axisFill) {
      if (this._axisFill && this._axisFill != axisFill) {
        _core_utils_Array__WEBPACK_IMPORTED_MODULE_16__["remove"](this.sprites, this._axisFill);
        this._axisFill.dataItem = undefined;
      }

      if (axisFill) {
        if (axisFill.dataItem && axisFill.dataItem != this) {
          _core_utils_Array__WEBPACK_IMPORTED_MODULE_16__["remove"](axisFill.dataItem.sprites, axisFill);
          axisFill.dataItem.axisFill = undefined;
        }

        axisFill.axis = this.component;
        this.addSprite(axisFill);
      }

      this._axisFill = axisFill;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisDataItem.prototype, "text", {
    /**
     * @return Text label
     */
    get: function get() {
      return this._text;
    },

    /**
     * Text to be used as data item's label.
     *
     * @param text Text label
     */
    set: function set(text) {
      this._text = text;

      if (this._label) {
        // do not use getter, it will create unwanted instances!
        this._label.text = text;
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisDataItem.prototype, "mask", {
    /**
     * Data item's mask.
     *
     * @return Mask
     */
    get: function get() {
      return this._mask;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisDataItem.prototype, "contents", {
    /**
     * Returns a [[Container]] to place all visual elements, related to data item
     * in.
     *
     * If there is no Container, a new one is created.
     *
     * @return Contents container
     */
    get: function get() {
      if (!this._contents) {
        var contents = new _core_Container__WEBPACK_IMPORTED_MODULE_2__["Container"]();
        this.addSprite(contents);
        contents.isMeasured = false;
        this._contents = contents;
        var component = this.component;

        if (component) {
          var mask = component.renderer.createFill(this.component);
          mask.disabled = false;
          mask.axis = component;
          this.addSprite(mask);
          this._mask = mask;
          contents.mask = mask;
        }
      }

      return this._contents;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisDataItem.prototype, "axisBreak", {
    /**
     * @return Axis break
     */
    get: function get() {
      return this._axisBreak;
    },

    /**
     * An [[AxisBreak]] this data item falls within.
     *
     * @param axisBreak Axis break
     */
    set: function set(axisBreak) {
      if (this._axisBreak) {
        this._axisBreak.dataItems.removeValue(this);
      }

      if (axisBreak) {
        axisBreak.dataItems.push(this);
      }

      this._axisBreak = axisBreak;
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Re-draws the element.
   *
   * @ignore Exclude from docs
   */

  AxisDataItem.prototype.validate = function () {
    if (this.component) {
      this.component.validateDataElement(this);
    }
  };
  /**
   * Appends data item's elements to the parent [[Container]].
   *
   * @ignore Exclude from docs
   */


  AxisDataItem.prototype.appendChildren = function () {
    if (this.component) {
      this.component.appendDataItem(this);
    }
  };
  /**
   * Checks if data item has particular property set.
   *
   * @param prop  Property name
   * @return Property set?
   */


  AxisDataItem.prototype.hasProperty = function (prop) {
    return prop == "component" ? true : _super.prototype.hasProperty.call(this, prop);
  };
  /**
   * Copies all parameters from another [[AxisDataItem]].
   *
   * @param source Source AxisDataItem
   */


  AxisDataItem.prototype.copyFrom = function (source) {
    _super.prototype.copyFrom.call(this, source);

    this.text = source.text;

    if (source.bullet) {
      this.bullet = source.bullet.clone();
    }

    this.minPosition = source.minPosition;
    this.maxPosition = source.maxPosition;
  };
  /**
   * Sets visibility of the Data Item.
   *
   * @param value Data Item
   */


  AxisDataItem.prototype.setVisibility = function (value, noChangeValues) {
    _super.prototype.setVisibility.call(this, value, noChangeValues);

    if (this._contents) {
      this._contents.visible = value;
    }
  };

  Object.defineProperty(AxisDataItem.prototype, "bullet", {
    /**
     * @return Bullet
     */
    get: function get() {
      return this._bullet;
    },

    /**
     * Set it to an instance of any [[Sprite]]. It will be displayed as an axis
     * bullet in the middle of the cell, or specific value.
     *
     * If you need position bullet relatively to the cell, use [[AxisBullet]]
     * instead. It has a `location` property which can be used to indicate
     * precise relative location within cell/range.
     *
     * Also, [[AxisBullet]] is a [[Container]] so you can push any other element
     * into it.
     *
     * NOTE: `location` is relative to the parent axis range's scope, i.e.
     * between its `date` and `endDate` for [[DateAxis]], or `value`/`endValue`
     * ([[ValueAxis]]), or `category`/`endCategory` ([[categoryAxis]]).
     *
     * ```TypeScript
     * let range = dateAxis.axisRanges.create();
     * range.date = new Date(2018, 0, 5);
     *
     * let flag = new am4plugins_bullets.FlagBullet();
     * flag.label.text = "Hello";
     *
     * range.bullet = flag;
     * ```
     * ```JavaScript
     * var range = dateAxis.axisRanges.create();
     * range.date = new Date(2018, 0, 5);
     *
     * var flag = new am4plugins_bullets.FlagBullet();
     * flag.label.text = "Hello";
     *
     * range.bullet = flag;
     * ```
     * ```JSON
     * {
     *   // ...
     *   "xAxes": [{
     *     "type": "DateAxis",
     *     // ...
     *     "axisRanges": [{
     *       "date": new Date(2018, 0, 5),
     *       "bullet: {
     *         "type": "FlagBullet",
     *         "label": {
     *           "text": "Hello"
     *         }
     *       }
     *     }]
     *   }]
     * }
     * ```
     *
     * @since 4.5.9
     * @param  value  Bullet
     */
    set: function set(value) {
      if (this._bullet && this._bullet != value) {
        _core_utils_Array__WEBPACK_IMPORTED_MODULE_16__["remove"](this.sprites, this._bullet);
        this._bullet.dataItem = undefined;
      }

      this._bullet = value;

      if (value) {
        this.addSprite(value);
      }
    },
    enumerable: true,
    configurable: true
  });
  return AxisDataItem;
}(_core_DataItem__WEBPACK_IMPORTED_MODULE_3__["DataItem"]);


/**
 * ============================================================================
 * REQUISITES
 * ============================================================================
 * @hidden
 */

/**
 * Defines named positions for data item's location within [[Axis]].
 */

var AxisItemLocation;

(function (AxisItemLocation) {
  AxisItemLocation[AxisItemLocation["Start"] = 0] = "Start";
  AxisItemLocation[AxisItemLocation["Middle"] = 0.5] = "Middle";
  AxisItemLocation[AxisItemLocation["End"] = 1] = "End";
})(AxisItemLocation || (AxisItemLocation = {}));
/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * A base class for all Axis elements.
 *
 * @see {@link IAxisEvents} for a list of available Events
 * @see {@link IAxisAdapters} for a list of available Adapters
 */


var Axis =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(Axis, _super);
  /**
   * Constructor
   */


  function Axis() {
    var _this = // Init
    _super.call(this) || this;
    /**
     * Number of Grid elements on the axis.
     */


    _this._gridCount = 10;
    /**
     * A list of [[XYSeries]] that are using this Axis.
     */

    _this._series = new _core_utils_List__WEBPACK_IMPORTED_MODULE_8__["List"]();
    /**
     * Specifies if axis should be automatically disposed when removing from
     * chart's axis list.
     *
     * @default true
     */

    _this.autoDispose = true;
    /**
     * @ignore
     */

    _this._axisItemCount = 0;

    if (_this.constructor === Axis) {
      throw new Error("'Axis' cannot be instantiated directly. Please use a specific axis type.");
    }

    _this.hideTooltipWhileZooming = true;
    _this.minWidth = 0.0001;
    _this.minHeight = 0.0001;
    _this.className = "Axis";
    _this.shouldClone = false;

    _this.setPropertyValue("cursorTooltipEnabled", true);

    _this.toggleZoomOutButton = true;
    _this.zoomable = true;
    var interfaceColors = new _core_utils_InterfaceColorSet__WEBPACK_IMPORTED_MODULE_11__["InterfaceColorSet"](); // Create title

    _this.title = new _core_elements_Label__WEBPACK_IMPORTED_MODULE_5__["Label"]();
    _this.title.shouldClone = false;

    _this._disposers.push(_this.title);

    _this.setPropertyValue("startLocation", 0);

    _this.setPropertyValue("endLocation", 1); // Data item iterator


    _this._dataItemsIterator = new _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_12__["ListIterator"](_this.dataItems, function () {
      return _this.dataItems.create();
    });
    _this._dataItemsIterator.createNewItems = true; // Create tooltip

    var tooltip = new _core_elements_Tooltip__WEBPACK_IMPORTED_MODULE_6__["Tooltip"]();

    _this._disposers.push(tooltip);

    tooltip.label.padding(5, 10, 5, 10);
    tooltip.background.pointerLength = 5;
    tooltip.fitPointerToBounds = true;
    tooltip.background.filters.clear(); // Set virtual parentfor the tooltip so that it can properly inheirt
    // formatters from the axis.

    tooltip.virtualParent = _this; // Create background element for the tooltip

    var background = tooltip.background;
    background.cornerRadius = 0;
    background.fill = interfaceColors.getFor("alternativeBackground");
    background.stroke = background.fill;
    background.strokeWidth = 1;
    background.fillOpacity = 1;
    tooltip.label.fill = interfaceColors.getFor("alternativeText");
    _this.tooltip = tooltip; // Accessibility

    _this.readerHidden = true;

    _this.events.on("rangechangestarted", function () {
      _this.series.each(function (series) {
        if (series.hideTooltipWhileZooming) {
          series.tooltip.hide();
          series.tooltip.preventShow = true;
        }
      });

      if (_this.hideTooltipWhileZooming) {
        _this.tooltip.hide();

        _this.tooltip.preventShow = true;
      }
    }, undefined, false);

    _this.events.on("rangechangeended", function () {
      _this.series.each(function (series) {
        if (series.hideTooltipWhileZooming) {
          series.tooltip.hide();
          series.tooltip.preventShow = false;
        }
      });

      if (_this.hideTooltipWhileZooming) {
        _this.tooltip.hide();

        _this.tooltip.preventShow = false;
      }
    }, undefined, false);

    _this.applyTheme();

    return _this;
  }
  /**
   * Holds reference to a function that accepts a DataItem and its index as
   * parameters.
   *
   * It can either return a fill opacity for a fill, or manipulate data item
   * directly, to create various highlighting scenarios.
   *
   * For example, you can set it up to highlight only weekends on a
   * [[DateAxis]].
   */


  Axis.prototype.fillRule = function (dataItem, index) {
    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_17__["isNumber"](index)) {
      index = dataItem.index;
    }

    if (index / 2 == Math.round(index / 2)) {
      dataItem.axisFill.__disabled = true;
      dataItem.axisFill.opacity = 0;
    } else {
      dataItem.axisFill.opacity = 1;
      dataItem.axisFill.__disabled = false;
    }
  };
  /**
   * Returns a new/empty DataItem of the type appropriate for this object.
   *
   * @see {@link DataItem}
   * @return Data Item
   */


  Axis.prototype.createDataItem = function () {
    return new AxisDataItem();
  };
  /**
   * Invalidates layout.
   *
   * @ignore Exclude from docs
   */


  Axis.prototype.invalidateLayout = function () {
    _super.prototype.invalidateLayout.call(this); // this puts series after axis in invalidation order also makes series update it's data items in case widht/height of a series is not 100%


    _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_12__["each"](this.series.iterator(), function (series) {
      series.invalidateLayout();
    });
  };
  /**
   * Invalidates series of this axis.
   */


  Axis.prototype.invalidateSeries = function () {
    // this puts series after axis in invalidation order also makes series update it's data items in case widht/height of a series is not 100%
    _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_12__["each"](this.series.iterator(), function (series) {
      series.invalidate();
    });
  };
  /**
   * Override to cancel super call for data element validation.
   * @ignore
   */


  Axis.prototype.validateDataElements = function () {
    this._axisItemCount = 0;

    if (this.ghostLabel) {
      this.renderer.updateLabelElement(this.ghostLabel, this.start, this.end);
      this.ghostLabel.validate();
    }
  };
  /**
   * Recalculates the number of grid items on the axis.
   */


  Axis.prototype.updateGridCount = function () {
    if (this.renderer) {
      var gridCount = this.axisLength / this.renderer.minGridDistance;

      if (gridCount != this._gridCount) {
        this._gridCount = gridCount;
        this.clearCache();
      }
    }
  };
  /**
   * Redraws the element.
   *
   * @ignore Exclude from docs
   */


  Axis.prototype.validateLayout = function () {
    this.axisFullLength = this.axisLength / (this.end - this.start);

    _super.prototype.validateLayout.call(this);

    this.updateGridCount();
    var renderer = this.renderer;

    if (renderer) {
      renderer.updateAxisLine();
      renderer.updateTooltip();
      renderer.updateBaseGridElement();
    }

    if (this._prevLength != this.axisLength) {
      this.dispatchImmediately("lengthchanged");
      this._prevLength = this.axisLength;
    }
  };
  /**
   * Initializes Axis' renderer.
   *
   * @ignore Exclude from docs
   */


  Axis.prototype.initRenderer = function () {};
  /**
   * Adds a data item to the Axis.
   *
   * @param dataItem Data item
   */


  Axis.prototype.appendDataItem = function (dataItem) {
    var renderer = this.renderer;
    var tick = dataItem.tick;

    if (tick) {
      if (tick.above) {
        tick.parent = renderer.bulletsContainer;
      } else {
        tick.parent = renderer.gridContainer;
      }
    }

    if (dataItem.label) {
      dataItem.label.parent = renderer;
    }

    var axisFill = dataItem.axisFill;

    if (axisFill) {
      if (axisFill.above) {
        axisFill.parent = renderer.bulletsContainer;
      } else {
        axisFill.parent = renderer.gridContainer;
      }
    }

    var grid = dataItem.grid;

    if (grid) {
      if (grid.above) {
        grid.parent = renderer.bulletsContainer;
      } else {
        grid.parent = renderer.gridContainer;
      }
    }

    if (dataItem.bullet) {
      dataItem.bullet.parent = renderer.bulletsContainer;
    }
  };
  /**
   * Redraws Axis' related items.
   *
   * @ignore Exclude from docs
   */


  Axis.prototype.validate = function () {
    _super.prototype.validate.call(this);

    this.validateLayout();
    this.renderer.updateGridContainer();
  };
  /**
   * Redars Axis ranges.
   *
   * @ignore Exclude from docs
   */


  Axis.prototype.validateAxisRanges = function () {
    var _this = this;

    _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_12__["each"](this.axisRanges.iterator(), function (axisRange) {
      _this.appendDataItem(axisRange);

      _this.validateDataElement(axisRange);

      if (axisRange.grid) {
        axisRange.grid.validate();
      }

      if (axisRange.tick) {
        axisRange.tick.validate();
      }

      if (axisRange.axisFill) {
        axisRange.axisFill.validate();
      }

      if (axisRange.label) {
        axisRange.label.validate();
      }
    });
  };
  /**
   * Invalidates all axis breaks, so they are redrawn.
   *
   * @ignore Exclude from docs
   */


  Axis.prototype.validateBreaks = function () {
    if (this._axisBreaks) {
      _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_12__["each"](this._axisBreaks.iterator(), function (axisBreak) {
        axisBreak.invalidate();
      });
    }
  };
  /**
   * Associates an Axis break with this Axis, after it is inserted into
   * `axisBreaks`.
   *
   * @ignore Exclude from docs
   * @param event Event
   */


  Axis.prototype.processBreak = function (event) {
    var axisBreak = event.newValue;
    axisBreak.parent = this.renderer.breakContainer;
    axisBreak.axis = this;
  };
  /**
   * Registers a [[XYSeries]] element with this Axis.
   *
   * Returns a [[Disposer]] for all events, added to Series for watching
   * changes in Axis, and vice versa.
   * @ignore
   * @param series  Series
   * @return Event disposer
   */


  Axis.prototype.registerSeries = function (series) {
    var _this = this;

    this.series.moveValue(series);
    return new _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_9__["MultiDisposer"]([new _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_9__["Disposer"](function () {
      _this.series.removeValue(series);
    }), this.events.on("lengthchanged", series.invalidate, series, false), this.events.on("lengthchanged", series.createMask, series, false), this.events.on("startchanged", series.invalidate, series, false), this.events.on("endchanged", series.invalidate, series, false)]);
  };

  Object.defineProperty(Axis.prototype, "renderer", {
    /**
     * @return Renderer
     */
    get: function get() {
      return this._renderer;
    },

    /**
     * An [[AxisRenderer]] to be used to render this Axis.
     *
     * Please note that most of the settings, related to Axis' appearance are set
     * via its renderer. Not directly on the Axis.
     *
     * E.g.:
     *
     * ```TypeScript
     * axis.renderer.inside = true;
     * axis.renderer.minLabelPosition = 0.1;
     * axis.renderer.maxLabelPosition = 0.9;
     * ```
     * ```JavaScript
     * axis.renderer.inside = true;
     * axis.renderer.minLabelPosition = 0.1;
     * axis.renderer.maxLabelPosition = 0.9;
     * ```
     *
     * @see {@link https://www.amcharts.com/docs/v4/concepts/axes/} for more info
     * @param renderer  Renderer
     */
    set: function set(renderer) {
      if (renderer != this._renderer) {
        this._renderer = renderer;
        renderer.chart = this.chart;
        renderer.axis = this;
        renderer.parent = this;
        this.title.parent = this; // we add title to axis and set layout in renderer to avoid one extra container, as otherwise axis container would be used for holding renderer only

        this.initRenderer();

        this._disposers.push(renderer.gridContainer.events.on("maxsizechanged", this.invalidate, this, false));

        var ghostLabel_1 = this.renderer.labels.create();

        this._disposers.push(ghostLabel_1);

        ghostLabel_1.dataItem = this.dataItems.template.clone(); // just for the adapters not to fail

        ghostLabel_1.text = "L";
        ghostLabel_1.parent = this.renderer;
        ghostLabel_1.shouldClone = false;
        ghostLabel_1.fillOpacity = 0;
        ghostLabel_1.opacity = 0;
        ghostLabel_1.strokeOpacity = 0;
        ghostLabel_1.interactionsEnabled = false;
        ghostLabel_1.validate();
        this.ghostLabel = ghostLabel_1;
        this.events.on("beforedatavalidated", function () {
          ghostLabel_1.text = "L";
        }, undefined, false);
      }
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Converts a relative position to angle. (for circular axes)
   *
   * @param position Position (0-1)
   * @return Angle
   */

  Axis.prototype.positionToAngle = function (position) {
    return this.renderer.positionToAngle(position);
  };
  /**
   * Converts pixel coordinates to a relative position. (0-1)
   *
   * @param point  Coorinates (px)
   * @return Position (0-1)
   */


  Axis.prototype.pointToPosition = function (point) {
    return this.renderer.pointToPosition(point);
  };
  /**
   * Converts relative position to coordinate.
   *
   * @since 4.7.15
   * @param position (0-1)
   * @return coordinate (px)
   */


  Axis.prototype.positionToCoordinate = function (position) {
    return this.renderer.positionToCoordinate(position);
  };
  /**
   * [getAnyRangePath description]
   *
   * @ignore Exclude from docs
   * @todo Description
   * @param start  [description]
   * @param end    [description]
   * @return [description]
   */


  Axis.prototype.getAnyRangePath = function (start, end) {
    return this.renderer.getPositionRangePath(start, end);
  };
  /**
   * Converts any positional parameter to a relative position on axis.
   *
   * @todo Description (review)
   * @param value  Pisition
   * @return Position (0-1)
   */


  Axis.prototype.anyToPosition = function (value) {
    return 0;
  };
  /**
   * Converts any positional parameter to a relative position on axis.
   *
   * @todo Description (review)
   * @param value  Pisition
   * @return Orientation point
   */


  Axis.prototype.anyToPoint = function (value) {
    return {
      x: 0,
      y: 0,
      angle: 0
    };
  };
  /**
   * [getPositionRangePath description]
   *
   * @ignore Exclude from docs
   * @todo Description
   * @param startPosition [description]
   * @param endPosition   [description]
   * @return [description]
   */


  Axis.prototype.getPositionRangePath = function (startPosition, endPosition) {
    if (this.renderer) {
      return this.renderer.getPositionRangePath(startPosition, endPosition);
    }

    return "";
  };

  Object.defineProperty(Axis.prototype, "axisLength", {
    /**
     * Actual axis length in pixels.
     *
     * @return Axis length (px)
     */
    get: function get() {
      if (this.renderer) {
        return this.renderer.axisLength;
      }

      return 0;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(Axis.prototype, "cursorTooltipEnabled", {
    /**
     * @return Display tooltip?
     */
    get: function get() {
      return this.getPropertyValue("cursorTooltipEnabled");
    },

    /**
     * Indicates if axis should display a tooltip for chart's cursor.
     *
     * @param value Display tooltip?
     */
    set: function set(value) {
      if (this.setPropertyValue("cursorTooltipEnabled", value)) {
        if (value && this.renderer) {
          this.renderer.updateTooltip();
        } else if (this.tooltip) {
          this.tooltip.hide(0);
        }
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(Axis.prototype, "toggleZoomOutButton", {
    /**
     * @return Toggle zoom out button?
     */
    get: function get() {
      return this.getPropertyValue("toggleZoomOutButton");
    },

    /**
     * Normally, when axis is zoomed in, a zoom out button is shown by a chart,
     * and vice versa: when axis is zoomed out completely, zoom out button is
     * hidden.
     *
     * Setting this to `false` will disable this behavior. Zooming in our out
     * this axis will not reveal or hide zoom out button.
     *
     * @default true
     * @since 4.6.2
     * @param  value  Toggle zoom out button?
     */
    set: function set(value) {
      this.setPropertyValue("toggleZoomOutButton", value);
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Hides element's [[Tooltip]].
   *
   * @see {@link Tooltip}
   */

  Axis.prototype.hideTooltip = function (duration) {
    _super.prototype.hideTooltip.call(this, duration);

    this._tooltipPosition = undefined;
  };
  /**
   * Shows Axis tooltip at specific relative position within Axis. (0-1)
   *
   * @param position Position (0-1)
   * @param local or global position
   */


  Axis.prototype.showTooltipAtPosition = function (position, local) {
    var tooltip = this._tooltip;

    if (!tooltip || this.dataItems.length <= 0) {
      this._tooltipPosition = undefined;
    } else {
      if (!local) {
        position = this.toAxisPosition(position);
      }

      if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_17__["isNumber"](position) || position < this.start || position > this.end) {
        tooltip.hide(0);
        this._tooltipPosition = undefined;
        return;
      }

      var renderer = this.renderer; //@todo: think of how to solve this better

      if (!tooltip.parent) {
        tooltip.parent = this.tooltipContainer;
      }

      var tooltipLocation = renderer.tooltipLocation;
      var startPosition = this.getCellStartPosition(position);
      var endPosition = this.getCellEndPosition(position);

      if (this.tooltipPosition == "fixed") {
        position = startPosition + (endPosition - startPosition) * tooltipLocation;
      }

      position = _core_utils_Math__WEBPACK_IMPORTED_MODULE_13__["fitToRange"](position, this.start, this.end);

      if (this._tooltipPosition != position) {
        this._tooltipPosition = position;
        var tooltipLocation2 = renderer.tooltipLocation2;
        var startPoint = renderer.positionToPoint(startPosition, tooltipLocation2);
        var endPoint = renderer.positionToPoint(endPosition, tooltipLocation2); // save values so cursor could use them

        this.currentItemStartPoint = startPoint;
        this.currentItemEndPoint = endPoint;

        if (renderer.fullWidthTooltip) {
          tooltip.width = endPoint.x - startPoint.x;
          tooltip.height = endPoint.y - startPoint.y;
        }

        var point = renderer.positionToPoint(position, tooltipLocation2);
        var globalPoint = _core_utils_Utils__WEBPACK_IMPORTED_MODULE_14__["spritePointToSvg"](point, this.renderer.line);
        tooltip.text = this.getTooltipText(position);

        if (tooltip.text) {
          tooltip.delayedPointTo(globalPoint);
          tooltip.show();
        }
      }

      if (!this.cursorTooltipEnabled || this.tooltip.disabled) {
        tooltip.hide(0);
      }
    }
  };
  /**
   * Converts relative position (0-1) to Axis position with zoom level and
   * inversed taken into account.
   *
   * @param position Global position (0-1)
   * @return Position within Axis (0-1)
   */


  Axis.prototype.toAxisPosition = function (position) {
    position = this.renderer.toAxisPosition(position);

    if (position == undefined) {
      return;
    }

    position = position * (this.end - this.start);

    if (this.renderer.inversed) {
      position = this.end - position;
    } else {
      position = this.start + position;
    }

    return position;
  };
  /**
   * Converts position on the axis with zoom level and
   * inversed taken into account to global position.
   *
   * @param position Axis position (0-1)
   * @return Global position (0-1)
   */


  Axis.prototype.toGlobalPosition = function (position) {
    if (this.renderer.inversed) {
      position = this.end - position;
    } else {
      position = position - this.start;
    }

    return position / (this.end - this.start);
  };
  /**
   * Returns text to be used for cursor's Axis tooltip.
   *
   * This is a placeholder to override for extending classes.
   *
   * @ignore Exclude from docs
   * @param position  Position coordinate (px)
   * @return Label text
   */


  Axis.prototype.getTooltipText = function (position) {
    return;
  };
  /**
   * Updates Axis' tooltip's position and possibly size, and pointer (stem)
   * place.
   *
   * @ignore Exclude from docs
   * @param pointerOrientation  Pointer (stem) orientation
   * @param boundingRectangle   A rectangle for tooltip to fit within
   */


  Axis.prototype.updateTooltip = function (pointerOrientation, boundingRectangle) {
    var tooltip = this._tooltip;

    if (tooltip) {
      tooltip.fixDoc = false;
      tooltip.pointerOrientation = pointerOrientation;
      tooltip.setBounds(_core_utils_Utils__WEBPACK_IMPORTED_MODULE_14__["spriteRectToSvg"](boundingRectangle, this.renderer.line));
    }
  };
  /**
   * [roundPosition description]
   *
   * @ignore Exclude from docs
   * @todo Description
   * @param position  Relative position
   * @param location  Location on axis
   * @return Rounded position
   */


  Axis.prototype.roundPosition = function (position, location, axisLocation) {
    return position;
  };
  /**
   * [getCellStartPosition description]
   *
   * @ignore Exclude from docs
   * @todo Description
   * @param position [description]
   * @return [description]
   */


  Axis.prototype.getCellStartPosition = function (position) {
    return position;
  };
  /**
   * [getCellEndPosition description]
   *
   * @ignore Exclude from docs
   * @todo Description
   * @param position [description]
   * @return [description]
   */


  Axis.prototype.getCellEndPosition = function (position) {
    return position;
  };

  Object.defineProperty(Axis.prototype, "axisRanges", {
    /**
     * A list of axis ranges for this Axis.
     *
     * @return Axis ranges
     */
    get: function get() {
      if (!this._axisRanges) {
        var dataItem = this.createDataItem();
        dataItem.isRange = true;
        dataItem.axisFill = this.renderer.axisFills.template.clone();
        dataItem.grid = this.renderer.grid.template.clone();
        dataItem.tick = this.renderer.ticks.template.clone();
        dataItem.label = this.renderer.labels.template.clone();
        dataItem.isTemplate = true;
        dataItem.component = this;
        dataItem.axisFill.disabled = false;
        dataItem.tick.disabled = false;
        dataItem.grid.disabled = false;
        dataItem.label.disabled = false;
        this._axisRanges = new _core_utils_List__WEBPACK_IMPORTED_MODULE_8__["ListTemplate"](dataItem);

        this._axisRanges.events.on("inserted", this.processAxisRange, this, false);

        this._disposers.push(new _core_utils_List__WEBPACK_IMPORTED_MODULE_8__["ListDisposer"](this._axisRanges));

        this._disposers.push(this._axisRanges.template);
      }

      return this._axisRanges;
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Decorates an axis range after it has been added to the axis range list.
   *
   * @param event Event
   */

  Axis.prototype.processAxisRange = function (event) {
    var axisRange = event.newValue;
    axisRange.component = this;
    axisRange.isRange = true;
  };

  Object.defineProperty(Axis.prototype, "axisBreaks", {
    /**
     * A list of axis breaks on this Axis.
     *
     * @return Axis breaks.
     */
    get: function get() {
      if (!this._axisBreaks) {
        this._axisBreaks = new _core_utils_SortedList__WEBPACK_IMPORTED_MODULE_7__["SortedListTemplate"](this.createAxisBreak(), function (a, b) {
          return _core_utils_Number__WEBPACK_IMPORTED_MODULE_15__["order"](a.adjustedStartValue, b.adjustedStartValue);
        });

        this._axisBreaks.events.on("inserted", this.processBreak, this, false);

        this._disposers.push(new _core_utils_List__WEBPACK_IMPORTED_MODULE_8__["ListDisposer"](this._axisBreaks));

        this._disposers.push(this._axisBreaks.template);
      }

      return this._axisBreaks;
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Creates a new axis break.
   *
   * @return Axis break
   */

  Axis.prototype.createAxisBreak = function () {
    return new _AxisBreak__WEBPACK_IMPORTED_MODULE_4__["AxisBreak"]();
  };

  Object.defineProperty(Axis.prototype, "series", {
    /**
     * A list of Series currently associated with this Axis.
     *
     * @return Series
     */
    get: function get() {
      if (!this._series) {
        this._series = new _core_utils_List__WEBPACK_IMPORTED_MODULE_8__["List"]();
      }

      return this._series;
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Processes Series' data items.
   *
   * This is a placeholder to override for extending classes.
   *
   * @ignore Exclude from docs
   */

  Axis.prototype.processSeriesDataItems = function () {};
  /**
   * Processes Series' single data item.
   *
   * This is a placeholder to override for extending classes.
   *
   * @ignore Exclude from docs
   * @param dataItem Data item
   */


  Axis.prototype.processSeriesDataItem = function (dataItem, axisLetter) {};
  /**
   * Post-processes Serie's data items.
   *
   * This is a placeholder to override for extending classes.
   *
   * @ignore Exclude from docs
   */


  Axis.prototype.postProcessSeriesDataItems = function (series) {};
  /**
   * Post-processes Serie's single data item.
   *
   * This is a placeholder to override for extending classes.
   *
   * @ignore Exclude from docs
   * @param dataItem Data item
   */


  Axis.prototype.postProcessSeriesDataItem = function (dataItem) {}; //

  /**
   * Updates Axis based on all Series that might influence it.
   *
   * Called by Series after Series data is validated.
   *
   * This is a placeholder to override for extending classes.
   *
   * @ignore Exclude from docs
   */


  Axis.prototype.updateAxisBySeries = function () {};
  /**
   * Hides unused data items.
   *
   * @ignore Exclude from docs
   */


  Axis.prototype.hideUnusedDataItems = function () {
    var _this = this; // hide all unused


    var dataItemsIterator = this._dataItemsIterator;
    dataItemsIterator.createNewItems = false;
    _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_12__["each"](dataItemsIterator.iterator(), function (dataItem) {
      _this.validateDataElement(dataItem); // solves shrinking


      dataItem.__disabled = true;
    });
    dataItemsIterator.clear();
    dataItemsIterator.createNewItems = true;
  };
  /**
   * Returns a Series' data item that corresponds to specific position on Axis.
   *
   * This is a placeholder to override for extending classes.
   *
   * @ignore Exclude from docs
   * @param series    Series
   * @param position  Position (0-1)
   * @param findNearest  Should axis try to find nearest tooltip if there is no data item at exact position
   * @return Data item
   */


  Axis.prototype.getSeriesDataItem = function (series, position, findNearest) {
    return;
  };
  /**
   * Returns an angle that corresponds to specific position on axis.
   *
   * This is a placeholder to override for extending classes.
   *
   * @ignore Exclude from docs
   * @todo Description (review)
   * @param dataItem  Data item
   * @param key       ???
   * @param location  Location
   * @param stackKey  ???
   * @return Angle
   */


  Axis.prototype.getAngle = function (dataItem, key, location, stackKey, range) {
    return;
  };
  /**
   * [getX description]
   *
   * This is a placeholder to override for extending classes.
   *
   * @ignore Exclude from docs
   * @todo Description (review)
   * @param dataItem [description]
   * @param key      [description]
   * @param location [description]
   * @param stackKey [description]
   * @return [description]
   */


  Axis.prototype.getX = function (dataItem, key, location, stackKey, range) {
    return;
  };
  /**
   * [getX description]
   *
   * This is a placeholder to override for extending classes.
   *
   * @ignore Exclude from docs
   * @todo Description (review)
   * @param dataItem [description]
   * @param key      [description]
   * @param location [description]
   * @param stackKey [description]
   * @return [description]
   */


  Axis.prototype.getPositionX = function (dataItem, key, location, stackKey, range) {
    return;
  };
  /**
   * [getY description]
   *
   * This is a placeholder to override for extending classes.
   *
   * @ignore Exclude from docs
   * @todo Description (review)
   * @param dataItem [description]
   * @param key      [description]
   * @param location [description]
   * @param stackKey [description]
   * @return [description]
   */


  Axis.prototype.getY = function (dataItem, key, location, stackKey, range) {
    return;
  };
  /**
   * [getY description]
   *
   * This is a placeholder to override for extending classes.
   *
   * @ignore Exclude from docs
   * @todo Description (review)
   * @param dataItem [description]
   * @param key      [description]
   * @param location [description]
   * @param stackKey [description]
   * @return [description]
   */


  Axis.prototype.getPositionY = function (dataItem, key, location, stackKey, range) {
    return;
  };

  Object.defineProperty(Axis.prototype, "basePoint", {
    /**
     * Coordinates of the actual axis start.
     *
     * @ignore Exclude from docs
     * @return Base point coordinates
     */
    get: function get() {
      return {
        x: 0,
        y: 0
      };
    },
    enumerable: true,
    configurable: true
  });
  /**
   * [dataChangeUpdate description]
   *
   * This is a placeholder to override for extending classes.
   *
   * @ignore Exclude from docs
   * @todo Description
   */

  Axis.prototype.dataChangeUpdate = function () {};
  /**
   * [dataChangeUpdate description]
   *
   *
   * @ignore Exclude from docs
   * @todo Description
   */


  Axis.prototype.seriesDataChangeUpdate = function (series) {};
  /**
   * Removes axis breaks that fall between `min` and `max` (???)
   *
   * @ignore Exclude from docs
   * @todo Description (review)
   * @param min  Start value
   * @param max  End value
   * @return Spread o
   */


  Axis.prototype.adjustDifference = function (min, max) {
    var difference = max - min;

    if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_17__["isNumber"](difference)) {
      if (this._axisBreaks) {
        _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_12__["eachContinue"](this._axisBreaks.iterator(), function (axisBreak) {
          var startValue = axisBreak.adjustedStartValue;
          var endValue = axisBreak.adjustedEndValue;

          if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_17__["isNumber"](startValue) && _core_utils_Type__WEBPACK_IMPORTED_MODULE_17__["isNumber"](endValue)) {
            // breaks are sorted, we don't need go further anymore
            if (startValue > max) {
              return false;
            }

            if (endValue >= min) {
              if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_17__["isNumber"](startValue) && _core_utils_Type__WEBPACK_IMPORTED_MODULE_17__["isNumber"](endValue)) {
                var breakSize = axisBreak.breakSize;
                var intersection = _core_utils_Math__WEBPACK_IMPORTED_MODULE_13__["intersection"]({
                  start: startValue,
                  end: endValue
                }, {
                  start: min,
                  end: max
                });

                if (intersection) {
                  difference -= (intersection.end - intersection.start) * (1 - breakSize);
                }
              }
            }

            return true;
          }
        });
      }

      return difference;
    }
  };
  /**
   * Checks if specific value falls within a break.
   *
   * Returns [[AxisBreak]] the value falls into.
   *
   * @param value  Value to check
   * @return Axis break
   */


  Axis.prototype.isInBreak = function (value) {
    if (this._axisBreaks) {
      return _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_12__["find"](this._axisBreaks.iterator(), function (axisBreak) {
        return value >= axisBreak.adjustedStartValue && value <= axisBreak.adjustedEndValue;
      });
    }
  };
  /**
   * [fixAxisBreaks description]
   *
   * @ignore Exclude from docs
   * @todo Description
   */


  Axis.prototype.fixAxisBreaks = function () {
    var _this = this;

    if (this._axisBreaks) {
      var axisBreaks = this._axisBreaks;

      if (axisBreaks.length > 0) {
        // first make sure that startValue is <= end value
        // This needs to make a copy of axisBreaks because it mutates the list while traversing
        // TODO very inefficient
        _core_utils_Array__WEBPACK_IMPORTED_MODULE_16__["each"](_core_utils_Iterator__WEBPACK_IMPORTED_MODULE_12__["toArray"](axisBreaks.iterator()), function (axisBreak) {
          var startValue = _core_utils_Math__WEBPACK_IMPORTED_MODULE_13__["min"](axisBreak.startValue, axisBreak.endValue);
          var endValue = _core_utils_Math__WEBPACK_IMPORTED_MODULE_13__["max"](axisBreak.startValue, axisBreak.endValue);
          axisBreak.adjustedStartValue = startValue;
          axisBreak.adjustedEndValue = endValue;

          _this._axisBreaks.update(axisBreak);
        });
        var firstAxisBreak = axisBreaks.first;
        var previousEndValue_1 = Math.min(firstAxisBreak.startValue, firstAxisBreak.endValue); // process breaks
        // TODO does this need to call axisBreaks.update ?

        _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_12__["each"](axisBreaks.iterator(), function (axisBreak) {
          var startValue = axisBreak.adjustedStartValue;
          var endValue = axisBreak.adjustedEndValue; // breaks can't overlap
          // if break starts before previous break ends

          if (startValue < previousEndValue_1) {
            startValue = previousEndValue_1;

            if (endValue < previousEndValue_1) {
              endValue = previousEndValue_1;
            }
          }

          axisBreak.adjustedStartValue = startValue;
          axisBreak.adjustedEndValue = endValue;
        });
      }
    }
  };

  Object.defineProperty(Axis.prototype, "startIndex", {
    /**
     * @ignore Exclude from docs
     * @return [description]
     */
    get: function get() {
      return 0;
    },

    /**
     * We need start/end indexes of axes to be 0 - `dataItems.length`.
     *
     * Yes, also for category axis, this helps to avoid jumping of categories
     * while scrolling and does not do a lot of extra work as we use
     * protected `_startIndex` and `_endIndex` when working with items.
     *
     * @hidden
     */

    /**
     * [startIndex description]
     *
     * @ignore Exclude from docs
     * @todo Description
     * @param value [description]
     */
    set: function set(value) {},
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(Axis.prototype, "endIndex", {
    /**
     * @ignore Exclude from docs
     * @return [description]
     */
    get: function get() {
      return this.dataItems.length;
    },

    /**
     * [endIndex description]
     *
     * @ignore Exclude from docs
     * @todo Description
     * @param value [description]
     */
    set: function set(value) {},
    enumerable: true,
    configurable: true
  });
  /**
   * Returns a formatted label based on position.
   *
   * Individual axis types should override this method to generate a label
   * that is relevant to axis type.
   *
   * Please note that `position` represents position within axis which may be
   * zoomed and not correspond to Cursor's `position`.
   *
   * To convert Cursor's `position` to Axis' `position` use `toAxisPosition()` method.
   *
   * @see {@link https://www.amcharts.com/docs/v4/tutorials/tracking-cursors-position-via-api/#Tracking_Cursor_s_position} For more information about cursor tracking.
   * @param position  Relative position on axis (0-1)
   * @return Position label
   */

  Axis.prototype.getPositionLabel = function (position) {
    return Math.round(position * 100) + "%x";
  };

  Object.defineProperty(Axis.prototype, "chart", {
    /**
     * @return Chart
     */
    get: function get() {
      return this._chart;
    },

    /**
     * A Chart this Axis belongs to.
     *
     * @param value  Chart
     */
    set: function set(value) {
      this._chart = value;
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Creates a data item for a Series range.
   *
   * @param series  Target Series
   * @return Range data item
   */

  Axis.prototype.createSeriesRange = function (series) {
    var range = this.axisRanges.create();
    range.component = this;
    range.axisFill = this.renderer.axisFills.template.clone();
    range.axisFill.disabled = false;
    range.axisFill.fillOpacity = 0;
    range.grid = this.renderer.grid.template.clone();
    range.grid.disabled = true;
    range.tick = this.renderer.ticks.template.clone();
    range.tick.disabled = true;
    range.label = this.renderer.labels.template.clone();
    range.label.disabled = true;
    range.addDisposer(new _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_9__["Disposer"](function () {
      series.axisRanges.removeValue(range);
    }));
    series.axisRanges.push(range);
    return range;
  };
  /**
   * Copies all properties and related data from a different instance of Axis.
   *
   * @param source Source Axis
   */


  Axis.prototype.copyFrom = function (source) {
    _super.prototype.copyFrom.call(this, source);

    if (this.renderer) {
      this.renderer.copyFrom(source.renderer);
    } else {
      if (source.renderer) {
        this.renderer = source.renderer.clone();

        this._disposers.push(this.renderer);
      }
    }

    if (source.title) {
      if (!this.title) {
        this.title = source.title.clone();
        this.title.parent = this;
      } else {
        this.title.copyFrom(source.title);
      }

      this._disposers.push(this.title);
    }
  };
  /**
   * Resets internal iterator.
   */


  Axis.prototype.resetIterators = function () {
    this._dataItemsIterator.reset();
  };
  /**
   * Processes JSON-based config before it is applied to the object.
   *
   * @ignore Exclude from docs
   * @param config  Config
   */


  Axis.prototype.processConfig = function (config) {
    if (config) {
      // Set up axis ranges
      if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_17__["hasValue"](config.axisRanges) && _core_utils_Type__WEBPACK_IMPORTED_MODULE_17__["isArray"](config.axisRanges)) {
        for (var i = 0, len = config.axisRanges.length; i < len; i++) {
          var range = config.axisRanges[i]; // If `series` is set, we know it's a series range

          if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_17__["hasValue"](range["series"])) {
            if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_17__["isString"](range["series"])) {
              if (this.map.hasKey(range["series"])) {
                //range["series"] = this.map.getKey(range["series"]);
                config.axisRanges[i] = this.createSeriesRange(this.map.getKey(range["series"]));
                delete range["series"];
                config.axisRanges[i].config = range;
              }
            }
          }
        }
      }
    }

    _super.prototype.processConfig.call(this, config);
  };
  /**
   * Ordering function used in JSON setup.
   *
   * @param a  Item A
   * @param b  Item B
   * @return Order
   */


  Axis.prototype.configOrder = function (a, b) {
    if (a == b) {
      return 0;
    } // last
    else if (a == "title") {
        return 1;
      } else if (b == "title") {
        return -1;
      } // first
      else if (a == "component") {
          return -1;
        } else if (b == "component") {
          return 1;
        } else {
          return _super.prototype.configOrder.call(this, a, b);
        }
  };

  Object.defineProperty(Axis.prototype, "startLocation", {
    /**
     * @return Location (0-1)
     */
    get: function get() {
      return this.getPropertyValue("startLocation");
    },

    /**
     * Axis start location. Works on Date/Category axis, doesn't work on Value axis.
     *
     * * 0 - Full first cell is shown.
     * * 0.5 - Half of first cell is shown.
     * * 1 - None of the first cell is visible. (you probably don't want that)
     *
     * @param value Location (0-1)
     */
    set: function set(value) {
      this.setPropertyValue("startLocation", value, true);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(Axis.prototype, "endLocation", {
    /**
     * @return Location (0-1)
     */
    get: function get() {
      return this.getPropertyValue("endLocation");
    },

    /**
     * Axis end location. Works on Date/Category axis, doesn't work on Value axis.
     *
     * * 0 - None of the last cell is shown. (don't do that)
     * * 0.5 - Half of the last cell is shown.
     * * 1 - Full last cell is shown.
     *
     * @param value Location (0-1)
     */
    set: function set(value) {
      this.setPropertyValue("endLocation", value, true);
    },
    enumerable: true,
    configurable: true
  });

  Axis.prototype.setDisabled = function (value) {
    var changed = _super.prototype.setDisabled.call(this, value);

    if (this.renderer) {
      this.renderer.gridContainer.disabled = value;
    }

    return changed;
  };

  Object.defineProperty(Axis.prototype, "title", {
    /**
     * @return Title label
     */
    get: function get() {
      return this._title;
    },

    /**
     * A reference to a [[Label]] element which serves as a title to the axis.
     *
     * When axis is created it aleready has an element, so you can just modify
     * it.
     *
     * Or you can replace it with your own instance of `Label`.
     *
     * @param  value  Title label
     */
    set: function set(value) {
      if (this._title && this._title != value) {
        this._title.dispose();
      }

      if (value) {
        this._title = value;
        value.parent = this;
        value.shouldClone = false;
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(Axis.prototype, "hideTooltipWhileZooming", {
    /**
     * @return Hide tooltip while zooming?
     */
    get: function get() {
      return this.getPropertyValue("hideTooltipWhileZooming");
    },

    /**
     * Indicates if axis' tooltip should be hidden while axis range is animating
     * (zooming)
     *
     * @default true
     * @since 4.7.16
     * @param  value  Hide tooltip while zooming?
     */
    set: function set(value) {
      this.setPropertyValue("hideTooltipWhileZooming", value);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(Axis.prototype, "zoomable", {
    /**
     * @return Zoomable?
     */
    get: function get() {
      return this.getPropertyValue("zoomable");
    },

    /**
     * Should the axis be zoomed with scrollbar/cursor?
     *
     * @default true
     * @since 4.9.28
     * @param  value  Zoomable?
     */
    set: function set(value) {
      this.setPropertyValue("zoomable", value);
    },
    enumerable: true,
    configurable: true
  });
  return Axis;
}(_core_Component__WEBPACK_IMPORTED_MODULE_1__["Component"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_10__["registry"].registeredClasses["Axis"] = Axis;
_core_Registry__WEBPACK_IMPORTED_MODULE_10__["registry"].registeredClasses["AxisDataItem"] = AxisDataItem;
/**
 * Add default responsive rules
 */

/**
 * Disable axis tooltips.
 */

_core_utils_Responsive__WEBPACK_IMPORTED_MODULE_18__["defaultRules"].push({
  relevant: _core_utils_Responsive__WEBPACK_IMPORTED_MODULE_18__["ResponsiveBreakpoints"].maybeXS,
  state: function state(target, stateId) {
    if (target instanceof Axis && target.tooltip) {
      var state = target.states.create(stateId);
      state.properties.cursorTooltipEnabled = false;
      return state;
    }

    return null;
  }
});

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisBreak.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisBreak.js ***!
  \*****************************************************************************/
/*! exports provided: AxisBreak */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AxisBreak", function() { return AxisBreak; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _core_Container__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core/Container */ "./node_modules/@amcharts/amcharts4/.internal/core/Container.js");
/* harmony import */ var _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/utils/Disposer */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Disposer.js");
/* harmony import */ var _core_elements_WavedLine__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/elements/WavedLine */ "./node_modules/@amcharts/amcharts4/.internal/core/elements/WavedLine.js");
/* harmony import */ var _core_utils_List__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/utils/List */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/List.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_utils_Color__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core/utils/Color */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Color.js");
/* harmony import */ var _core_utils_InterfaceColorSet__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../core/utils/InterfaceColorSet */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/InterfaceColorSet.js");
/**
 * Axis break module
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */








/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Base class to define "breaks" on axes.
 *
 * @see {@link IAxisBreakEvents} for a list of available events
 * @see {@link IAxisBreakAdapters} for a list of available Adapters
 * @important
 */

var AxisBreak =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(AxisBreak, _super);
  /**
   * Constructor
   */


  function AxisBreak() {
    var _this = // Init
    _super.call(this) || this;
    /**
     * Reference to parent Axis.
     */


    _this._axis = new _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_2__["MutableValueDisposer"]();
    /**
     * A list of axis data items which fall within this break.
     */

    _this.dataItems = new _core_utils_List__WEBPACK_IMPORTED_MODULE_4__["List"]();
    _this.className = "AxisBreak"; // Set defaults

    _this.breakSize = 0.01;
    _this.marginLeft = -5;
    _this.marginRight = -5;
    _this.marginTop = -5;
    _this.marginBottom = -5;
    var interfaceColors = new _core_utils_InterfaceColorSet__WEBPACK_IMPORTED_MODULE_7__["InterfaceColorSet"](); // Create elements
    // (these won't be used actually, just for setting properties)

    var fillShape = new _core_elements_WavedLine__WEBPACK_IMPORTED_MODULE_3__["WavedLine"]();
    fillShape.fill = interfaceColors.getFor("background");
    fillShape.stroke = Object(_core_utils_Color__WEBPACK_IMPORTED_MODULE_6__["color"])();
    fillShape.fillOpacity = 0.9;
    fillShape.zIndex = 0;
    _this._fillShape = fillShape;
    var startLine = new _core_elements_WavedLine__WEBPACK_IMPORTED_MODULE_3__["WavedLine"]();
    startLine.fill = Object(_core_utils_Color__WEBPACK_IMPORTED_MODULE_6__["color"])();
    startLine.stroke = interfaceColors.getFor("grid");
    startLine.strokeOpacity = 0.3;
    startLine.zIndex = 1;
    _this._startLine = startLine;
    var endLine = new _core_elements_WavedLine__WEBPACK_IMPORTED_MODULE_3__["WavedLine"]();
    endLine.fill = Object(_core_utils_Color__WEBPACK_IMPORTED_MODULE_6__["color"])();
    endLine.stroke = Object(_core_utils_Color__WEBPACK_IMPORTED_MODULE_6__["color"])("#000000"); // interfaceColors.getFor("grid");

    endLine.strokeOpacity = 0.3;
    endLine.zIndex = 2;
    _this._endLine = endLine;

    _this._disposers.push(_this._axis); // Apply theme


    _this.applyTheme();

    return _this;
  }

  AxisBreak.prototype.dispose = function () {
    _super.prototype.dispose.call(this);

    if (this._fillShape) {
      this._fillShape.dispose();
    }

    if (this._startLine) {
      this._startLine.dispose();
    }

    if (this._endLine) {
      this._endLine.dispose();
    }
  };

  Object.defineProperty(AxisBreak.prototype, "startLine", {
    /**
     * @return Element
     */
    get: function get() {
      return this._startLine;
    },

    /**
     * An element used for the starting line of the break.
     *
     * @param sprite  Element
     */
    set: function set(sprite) {
      if (this._startLine) {
        this._startLine.dispose();
      }

      this._startLine = sprite;
      this.addBreakSprite(sprite);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisBreak.prototype, "endLine", {
    /**
     * @return Element
     */
    get: function get() {
      return this._endLine;
    },

    /**
     * An element used for the end line of the break.
     *
     * @param sprite Element
     */
    set: function set(sprite) {
      if (this._endLine) {
        this._endLine.dispose();
      }

      this._endLine = sprite;
      this.addBreakSprite(sprite);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisBreak.prototype, "fillShape", {
    /**
     * @return Element
     */
    get: function get() {
      return this._fillShape;
    },

    /**
     * An element used for fill of the break.
     *
     * @param sprite Element
     */
    set: function set(sprite) {
      if (this._fillShape) {
        this._fillShape.dispose();
      }

      this._fillShape = sprite;
      this.addBreakSprite(sprite);
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Adds a break element (e.g. lines, fill) to the break, which is
   * [[Container]].
   *
   * @ignore Exclude from docs
   * @param sprite Element to add
   */

  AxisBreak.prototype.addBreakSprite = function (sprite) {
    sprite.parent = this;
    sprite.isMeasured = false;

    this._disposers.push(sprite);
  };

  Object.defineProperty(AxisBreak.prototype, "axis", {
    /**
     * @return Axis
     */
    get: function get() {
      return this._axis.get();
    },

    /**
     * An Axis this Break is associated with.
     *
     * @param axis  Axis
     */
    set: function set(axis) {
      if (this._axis.get() !== axis) {
        this._axis.set(axis, axis.renderer.gridContainer.events.on("transformed", this.invalidate, this, false));

        axis.renderer.createBreakSprites(this); // this can't go to copyFrom, as axis is set later

        var breakTemplate = axis.axisBreaks.template;
        this.startLine.copyFrom(breakTemplate.startLine);
        this.endLine.copyFrom(breakTemplate.endLine);
        this.fillShape.copyFrom(breakTemplate.fillShape);
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisBreak.prototype, "breakSize", {
    /**
     * @return Relative axis break
     */
    get: function get() {
      return this.getPropertyValue("breakSize");
    },

    /**
     * A size of the break relative to the actual size of the scope break spans.
     *
     * For example, if `breakSize = 0.1` and unbroken scope of values it spans
     * would be 100 pixels, the break would be 10 pixels wide.
     *
     * 0 means the break will completely collapse and hide the values.
     * 1 means break would be not collapse at all, which would make it
     * effectively useless.
     *
     * @default 0.01
     * @param value  Relative axis break
     */
    set: function set(value) {
      if (this.setPropertyValue("breakSize", value)) {
        if (this.axis) {
          this.axis.invalidate();
          this.axis.invalidateSeries();
        }
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisBreak.prototype, "startPoint", {
    /**
     * Returns pixel coordinates of axis break's start.
     *
     * @return Start point
     */
    get: function get() {
      var renderer = this.axis.renderer;

      if (renderer) {
        return renderer.positionToPoint(this.startPosition);
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisBreak.prototype, "endPoint", {
    /**
     * Returns pixel coordinates of axis break's end.
     *
     * @return End point
     */
    get: function get() {
      var renderer = this.axis.renderer;

      if (renderer) {
        return renderer.positionToPoint(this.endPosition);
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisBreak.prototype, "startPosition", {
    /**
     * Returns a relative position at which axis break starts.
     *
     * This is a calculated position, meaning it shows relative position of the
     * break after break is applied.
     *
     * @return Start position
     */
    get: function get() {
      return;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisBreak.prototype, "endPosition", {
    /**
     * Returns a relative position at which axis break ends.
     *
     * This is a calculated position, meaning it shows relative position of the
     * break after break is applied.
     *
     * @return End position
     */
    get: function get() {
      return;
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Draws the axis break.
   *
   * @ignore Exclude from docs
   */

  AxisBreak.prototype.draw = function () {
    _super.prototype.draw.call(this);

    if (this.axis) {
      var renderer = this.axis.renderer;
      renderer.updateBreakElement(this);
    }
  };

  Object.defineProperty(AxisBreak.prototype, "startValue", {
    /**
     * @return Starting value
     */
    get: function get() {
      return this.getPropertyValue("startValue");
    },

    /**
     * A starting value for the break.
     *
     * @param value  Starting value
     */
    set: function set(value) {
      if (this.setPropertyValue("startValue", value)) {
        if (this.axis) {
          this.axis.invalidate();
          this.axis.invalidateSeries();
        }
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisBreak.prototype, "endValue", {
    /**
     * @return End value
     */
    get: function get() {
      return this.getPropertyValue("endValue");
    },

    /**
     * An end value for the break.
     *
     * @param value  End value
     */
    set: function set(value) {
      if (this.setPropertyValue("endValue", value)) {
        if (this.axis) {
          this.axis.invalidate();
          this.axis.invalidateSeries();
        }
      }
    },
    enumerable: true,
    configurable: true
  });
  return AxisBreak;
}(_core_Container__WEBPACK_IMPORTED_MODULE_1__["Container"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_5__["registry"].registeredClasses["AxisBreak"] = AxisBreak;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisBullet.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisBullet.js ***!
  \******************************************************************************/
/*! exports provided: AxisBullet */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AxisBullet", function() { return AxisBullet; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _core_Container__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core/Container */ "./node_modules/@amcharts/amcharts4/.internal/core/Container.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/**
 * Axis Bullet module.
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */



/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Used to draw a positioned bullet (element) on an Axis.
 *
 * ```TypeScript
 * let range = dateAxis.axisRanges.create();
 * range.date = new Date(2018, 0, 5);
 *
 * let flag = new am4plugins_bullets.FlagBullet();
 * flag.label.text = "Hello";
 *
 * range.bullet = flag;
 * ```
 * ```JavaScript
 * var range = dateAxis.axisRanges.create();
 * range.date = new Date(2018, 0, 5);
 *
 * var flag = new am4plugins_bullets.FlagBullet();
 * flag.label.text = "Hello";
 *
 * range.bullet = flag;
 * ```
 * ```JSON
 * {
 *   // ...
 *   "xAxes": [{
 *     "type": "DateAxis",
 *     // ...
 *     "axisRanges": [{
 *       "date": new Date(2018, 0, 5),
 *       "bullet: {
 *         "type": "FlagBullet",
 *         "label": {
 *           "text": "Hello"
 *         }
 *       }
 *     }]
 *   }]
 * }
 * ```
 *
 * @since 4.5.9
 * @see {@link IAxisBulletEvents} for a list of available events
 * @see {@link IAxisBulletAdapters} for a list of available Adapters
 * @important
 */

var AxisBullet =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(AxisBullet, _super);

  function AxisBullet() {
    var _this = _super.call(this) || this;

    _this.className = "AxisBullet";
    _this.location = 0.5;
    _this.isMeasured = false;

    _this.applyTheme();

    return _this;
  }

  Object.defineProperty(AxisBullet.prototype, "location", {
    /**
     * @return Location (0-1)
     */
    get: function get() {
      return this.getPropertyValue("location");
    },

    /**
     * Relative position within cell/range.
     *
     * Value range is from from `0` (beginning) to `1` (end).
     *
     * NOTE: `location` is relative to the parent axis range's scope, i.e.
     * between its `date` and `endDate` for [[DateAxis]], or `value`/`endValue`
     * ([[ValueAxis]]), or `category`/`endCategory` ([[categoryAxis]]).
     *
     * ```TypeScript
     * let range = dateAxis.axisRanges.create();
     * range.date = new Date(2018, 0, 5);
     * range.endDate = new Date(2018, 0, 6);
     *
     * let bullet = new am4charts.AxisBullet();
     * bullet.location = 1;
     *
     * let flag = bullet.createChild(am4plugins_bullets.FlagBullet);
     * flag.label.text = "Hello";
     * ```
     * ```JavaScript
     * var range = dateAxis.axisRanges.create();
     * range.date = new Date(2018, 0, 5);
     * range.endDate = new Date(2018, 0, 6);
     *
     * var bullet = new am4charts.AxisBullet();
     * bullet.location = 1;
     *
     * var flag = bullet.createChild(am4plugins_bullets.FlagBullet);
     * flag.label.text = "Hello";
     * ```
     * ```JSON
     * {
     *   // ...
     *   "xAxes": [{
     *     "type": "DateAxis",
     *     // ...
     *     "axisRanges": [{
     *       "date": new Date(2018, 0, 5),
     *       "endDate": new Date(2018, 0, 6),
     *       "bullet: {
     *         "type": "AxisBullet",
     *         "location": 1,
     *         "children": [{
     *           "type": "FlagBullet",
     *           "label": {
     *             "text": "Hello"
     *           }
     *         }]
     *       }
     *     }]
     *   }]
     * }
     * ```
     *
     * @default 0.5
     * @param  value  Location (0-1)
     */
    set: function set(value) {
      this.setPropertyValue("location", value, true);
    },
    enumerable: true,
    configurable: true
  });
  /**
   * @ignore
   */

  AxisBullet.prototype.setDisabled = function (value) {
    var changed = _super.prototype.setDisabled.call(this, value);

    if (this.axis) {
      this.axis.invalidateDataItems();
    }

    return changed;
  };

  return AxisBullet;
}(_core_Container__WEBPACK_IMPORTED_MODULE_1__["Container"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_2__["registry"].registeredClasses["AxisBullet"] = AxisBullet;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisFill.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisFill.js ***!
  \****************************************************************************/
/*! exports provided: AxisFill */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AxisFill", function() { return AxisFill; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _core_Sprite__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core/Sprite */ "./node_modules/@amcharts/amcharts4/.internal/core/Sprite.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_utils_InterfaceColorSet__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/utils/InterfaceColorSet */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/InterfaceColorSet.js");
/* harmony import */ var _core_utils_Type__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/utils/Type */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Type.js");

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */





/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * AxisFill is a base class used to defines fill shapes for various
 * type-specific Axes.
 *
 * Axis fills are used to add fills to specific ranges of those axes.
 *
 * @see {@link IAxisFillEvents} for a list of available events
 * @see {@link IAxisFillAdapters} for a list of available Adapters
 * @important
 */

var AxisFill =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(AxisFill, _super);
  /**
   * Constructor.
   *
   * @param axis Axis
   */


  function AxisFill(axis) {
    var _this = _super.call(this) || this;

    _this.axis = axis;
    _this.element = _this.paper.add("path");
    _this.className = "AxisFill";
    _this.isMeasured = false;
    _this.location = 0;
    _this.above = false;
    var interfaceColors = new _core_utils_InterfaceColorSet__WEBPACK_IMPORTED_MODULE_3__["InterfaceColorSet"]();
    _this.fill = interfaceColors.getFor("alternativeBackground");
    _this.fillOpacity = 0;

    _this.applyTheme();

    return _this;
  }
  /**
   * @ignore
   */


  AxisFill.prototype.setDisabled = function (value) {
    var changed = _super.prototype.setDisabled.call(this, value);

    if (this.axis) {
      this.axis.invalidateDataItems();
    }

    return changed;
  };
  /**
   * Draws the fill element.
   *
   * @ignore Exclude from docs
   */


  AxisFill.prototype.draw = function () {
    _super.prototype.draw.call(this);

    if (this.__disabled || this.disabled) {
      return;
    }

    if (this.axis && _core_utils_Type__WEBPACK_IMPORTED_MODULE_4__["isNumber"](this.startPosition) && _core_utils_Type__WEBPACK_IMPORTED_MODULE_4__["isNumber"](this.endPosition)) {
      this.fillPath = this.axis.getPositionRangePath(this.startPosition, this.endPosition);
      this.path = this.fillPath;

      if (this.isMeasured) {
        this.measure();
      }
    }
  };

  Object.defineProperty(AxisFill.prototype, "startPosition", {
    /**
     * @return Start position
     */
    get: function get() {
      return this.getPropertyValue("startPosition");
    },

    /**
     * An actual starting position of the fill.
     *
     * @param value  Starting position
     */
    set: function set(value) {
      this.setPropertyValue("startPosition", value);
      this.invalidate(); // this is needed as relative position might not change when zooming
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisFill.prototype, "endPosition", {
    /**
     * @return End position
     */
    get: function get() {
      return this.getPropertyValue("endPosition");
    },

    /**
     * An actual end position of the fill.
     *
     * @param value End position
     */
    set: function set(value) {
      this.setPropertyValue("endPosition", value);
      this.invalidate(); // this is needed as relative position might not change when zooming
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisFill.prototype, "location", {
    /**
     * @return Location (0-1)
     */
    get: function get() {
      return this.getPropertyValue("location");
    },

    /**
     * Relative location of the fill. (0-1)
     *
     * @param value Location (0-1)
     */
    set: function set(value) {
      this.setPropertyValue("location", value, true);
    },
    enumerable: true,
    configurable: true
  });
  /**
   * @ignore
   */

  AxisFill.prototype.setPath = function (value) {
    if (this.setPropertyValue("path", value)) {
      this.element.attr({
        "d": value
      });
      return true;
    }

    return false;
  };

  Object.defineProperty(AxisFill.prototype, "above", {
    /**
     * @return Draw above series?
     */
    get: function get() {
      return this.getPropertyValue("above");
    },

    /**
     * Normally fill goes below series. Set this to `true` to go above.
     *
     * @default false
     * @since 4.5.9
     * @param  value  Draw above series?
     */
    set: function set(value) {
      this.setPropertyValue("above", value, true);
    },
    enumerable: true,
    configurable: true
  });
  return AxisFill;
}(_core_Sprite__WEBPACK_IMPORTED_MODULE_1__["Sprite"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_2__["registry"].registeredClasses["AxisFill"] = AxisFill;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisFillCircular.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisFillCircular.js ***!
  \************************************************************************************/
/*! exports provided: AxisFillCircular */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AxisFillCircular", function() { return AxisFillCircular; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _AxisFill__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AxisFill */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisFill.js");
/* harmony import */ var _core_utils_Percent__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/utils/Percent */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Percent.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_utils_Type__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/utils/Type */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Type.js");

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */





/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Provides fill element functionality for circular Axes.
 *
 * @see {@link IAxisFillCircularEvents} for a list of available events
 * @see {@link IAxisFillCircularAdapters} for a list of available Adapters
 * @todo Needs description
 */

var AxisFillCircular =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(AxisFillCircular, _super);
  /**
   * Constructor.
   *
   * @param axis Axis
   */


  function AxisFillCircular(axis) {
    var _this = _super.call(this, axis) || this;

    _this.className = "AxisFillCircular";
    _this.element = _this.paper.add("path");
    _this.radius = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_2__["percent"])(100);

    _this.applyTheme();

    return _this;
  }
  /**
   * Draws the fill element.
   *
   * @ignore Exclude from docs
   */


  AxisFillCircular.prototype.draw = function () {
    _super.prototype.draw.call(this);

    if (this.__disabled || this.disabled) {
      return;
    }

    if (this.axis) {
      var renderer = this.axis.renderer;
      this.fillPath = renderer.getPositionRangePath(this.startPosition, this.endPosition, this.radius, _core_utils_Type__WEBPACK_IMPORTED_MODULE_4__["hasValue"](this.innerRadius) ? this.innerRadius : renderer.innerRadius, this.cornerRadius);
      this.path = this.fillPath;
    }
  };

  Object.defineProperty(AxisFillCircular.prototype, "innerRadius", {
    /**
     * @return Inner radius
     */
    get: function get() {
      return this.getPropertyValue("innerRadius");
    },

    /**
     * Inner radius of the fill. Relative ([[Percent]]) or absolute (pixels).
     *
     * @param value  Inner radius
     */
    set: function set(value) {
      this.setPercentProperty("innerRadius", value, true, false, 10, false);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisFillCircular.prototype, "radius", {
    /**
     * @return Outer radius
     */
    get: function get() {
      return this.getPropertyValue("radius");
    },

    /**
     * Outer radius of the fill. Relative ([[Percent]]) or absolute (pixels).
     *
     * @param value  Outer radius
     */
    set: function set(value) {
      this.setPercentProperty("radius", value, true, false, 10, false);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisFillCircular.prototype, "cornerRadius", {
    /**
     * @return Corner radius (px)
     */
    get: function get() {
      return this.getPropertyValue("cornerRadius");
    },

    /**
     * Corner radius for the fill. In pixels.
     *
     * @param value  Corner radius (px)
     */
    set: function set(value) {
      this.setPropertyValue("cornerRadius", value, true);
    },
    enumerable: true,
    configurable: true
  });
  return AxisFillCircular;
}(_AxisFill__WEBPACK_IMPORTED_MODULE_1__["AxisFill"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_3__["registry"].registeredClasses["AxisFillCircular"] = AxisFillCircular;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisLabel.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisLabel.js ***!
  \*****************************************************************************/
/*! exports provided: AxisLabel */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AxisLabel", function() { return AxisLabel; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _core_elements_Label__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core/elements/Label */ "./node_modules/@amcharts/amcharts4/.internal/core/elements/Label.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/**
 * Axis Label module
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */



/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Use to create labels on Axis.
 *
 * @see {@link IAxisLabelEvents} for a list of available events
 * @see {@link IAxisLabelAdapters} for a list of available Adapters
 * @important
 */

var AxisLabel =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(AxisLabel, _super);
  /**
   * Constructor
   */


  function AxisLabel() {
    var _this = _super.call(this) || this;

    _this.className = "AxisLabel";
    _this.isMeasured = false;

    _this.padding(10, 10, 10, 10);

    _this.location = 0.5; //this.nonScaling = true; // not good for perf

    _this.applyTheme();

    return _this;
  }

  Object.defineProperty(AxisLabel.prototype, "location", {
    /**
     * @return Location (0-1)
     */
    get: function get() {
      return this.getPropertyValue("location");
    },

    /**
     * Relative location of the label. (0-1)
     *
     * @param value  Location (0-1)
     */
    set: function set(value) {
      this.setPropertyValue("location", value, true);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisLabel.prototype, "inside", {
    /**
     * Returns if label is set to be drawn inside axis.
     *
     * @return Inside?
     */
    get: function get() {
      return this.getPropertyValue("inside");
    },

    /**
     * Sets if label should be drawn inside axis.
     *
     * @param value  Inside?
     */
    set: function set(value) {
      this.setPropertyValue("inside", value, true);
    },
    enumerable: true,
    configurable: true
  });
  /**
   * @ignore
   */

  AxisLabel.prototype.setDisabled = function (value) {
    var changed = _super.prototype.setDisabled.call(this, value);

    if (this.axis) {
      this.axis.invalidateDataItems();
    }

    return changed;
  };

  return AxisLabel;
}(_core_elements_Label__WEBPACK_IMPORTED_MODULE_1__["Label"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_2__["registry"].registeredClasses["AxisLabel"] = AxisLabel;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisLabelCircular.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisLabelCircular.js ***!
  \*************************************************************************************/
/*! exports provided: AxisLabelCircular */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AxisLabelCircular", function() { return AxisLabelCircular; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _AxisLabel__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AxisLabel */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisLabel.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_utils_Math__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/utils/Math */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Math.js");
/* harmony import */ var _core_utils_Type__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/utils/Type */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Type.js");
/* harmony import */ var _core_rendering_Path__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core/rendering/Path */ "./node_modules/@amcharts/amcharts4/.internal/core/rendering/Path.js");
/* harmony import */ var _core_utils_Utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core/utils/Utils */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Utils.js");
/* harmony import */ var _core_utils_Percent__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../core/utils/Percent */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Percent.js");
/**
 * Axis Label module
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */








/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Use to create labels on circular axis.
 *
 * @see {@link IAxisLabelCircularEvents} for a list of available events
 * @see {@link IAxisLabelCircularAdapters} for a list of available Adapters
 */

var AxisLabelCircular =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(AxisLabelCircular, _super);
  /**
   * Constructor
   */


  function AxisLabelCircular() {
    var _this = _super.call(this) || this;
    /**
     *
     * @ignore
     */


    _this.fdx = 0;
    /**
     *
     * @ignore
     */

    _this.fdy = 0;
    _this.className = "AxisLabelCircular";

    _this.padding(0, 0, 0, 0);

    _this.location = 0.5;
    _this.locationOnPath = 0.5;
    _this.radius = 0;
    _this.isMeasured = false;

    _this.applyTheme();

    return _this;
  }

  Object.defineProperty(AxisLabelCircular.prototype, "relativeRotation", {
    /**
     * @return Rotation angle
     */
    get: function get() {
      return this.getPropertyValue("relativeRotation");
    },

    /**
     * Relative rotation of the label.
     *
     * It is an angle to circle. In case 90, labels will be positioned like rays
     * of light, if 0 - positioned along the circle.
     *
     * @param value Rotation angle
     */
    set: function set(value) {
      this.setPropertyValue("relativeRotation", value, true);

      if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_4__["hasValue"](value)) {
        this.rotation = undefined;
        var dataItem = this.dataItem;

        if (dataItem && dataItem.component) {
          dataItem.component.invalidateDataItems();
        }
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisLabelCircular.prototype, "radius", {
    /**
     * @return Distance (px)
     */
    get: function get() {
      return this.getPropertyValue("radius");
    },

    /**
     * Distance from axis circle to label in pixels or percent.
     *
     * @param value Distance (px or percent)
     */
    set: function set(value) {
      this.setPercentProperty("radius", value, true, false, 10, false);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisLabelCircular.prototype, "bent", {
    /**
     * @return Bent?
     */
    get: function get() {
      return this.getPropertyValue("bent");
    },

    /**
     * Specifies if label should be bent along the circle.
     *
     * IMPORTANT: Use this with caution, since it is quite CPU-greedy.
     *
     * @since 4.1.2
     * @default false
     * @param  value  Bent?
     */
    set: function set(value) {
      this.setPropertyValue("bent", value, true);
      this.setPropertyValue("wrap", false);
      this.setPropertyValue("horizontalCenter", "none");
      this.setPropertyValue("verticalCenter", "none");

      if (value) {
        this.setPropertyValue("dx", 0);
        this.setPropertyValue("dy", 0);
        this.setPropertyValue("x", 0);
        this.setPropertyValue("y", 0);
        this.setPropertyValue("rotation", 0); //this.setPropertyValue("relativeRotation", undefined);

        this.fdx = 0;
        this.fdy = 0;
        this.textAlign = "middle";
      } else {
        if (this.textPathElement) {
          this.textPathElement.dispose();
          this.textPathElement = undefined;
        }
      }
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Returns label radius in pixels.
   *
   * @param   axisRadius  Radius
   * @return              Pixel radius
   */

  AxisLabelCircular.prototype.pixelRadius = function (axisRadius) {
    var sign = 1;

    if (this.inside) {
      sign = -1;
    }

    return _core_utils_Utils__WEBPACK_IMPORTED_MODULE_6__["relativeToValue"](this.radius, axisRadius) * sign;
  };
  /**
   * Returns label horizontal radius in pixels.
   *
   * @param   axisRadius   Radius
   * @param   axisRadiusY  Vertical radius
   * @return               Radius
   */


  AxisLabelCircular.prototype.pixelRadiusY = function (axisRadius, axisRadiusY) {
    var sign = 1;

    if (this.inside) {
      sign = -1;
    }

    var radius = this.radius;

    if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_4__["isNumber"](radius)) {
      radius *= axisRadiusY / axisRadius;
      return _core_utils_Utils__WEBPACK_IMPORTED_MODULE_6__["relativeToValue"](radius, axisRadius) * sign;
    } else {
      return _core_utils_Utils__WEBPACK_IMPORTED_MODULE_6__["relativeToValue"](radius, axisRadiusY) * sign;
    }
  };
  /**
   * [fixPosition description]
   *
   * @ignore Exclude from docs
   * @todo Description
   * @param point       Label affixation point
   * @param axisRadius  Distance from point (px)
   */


  AxisLabelCircular.prototype.fixPosition = function (angle, axisRadius, axisRadiusY, dx, dy) {
    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_4__["isNumber"](axisRadiusY)) {
      axisRadiusY = axisRadius;
    }

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_4__["isNumber"](dx)) {
      dx = 0;
    }

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_4__["isNumber"](dy)) {
      dy = 0;
    }

    var point = {
      x: axisRadius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_3__["cos"](angle),
      y: axisRadiusY * _core_utils_Math__WEBPACK_IMPORTED_MODULE_3__["sin"](angle)
    };

    if (this.invalid) {
      this.validate(); //@todo" check if we need this
    }

    var isNegative = false;
    var realRadius = this.radius;

    if (realRadius instanceof _core_utils_Percent__WEBPACK_IMPORTED_MODULE_7__["Percent"] && realRadius.value < 0) {
      isNegative = true;
    } else if (realRadius < 0) {
      isNegative = true;
    }

    var relativeRotation = this.relativeRotation;
    var labelRadius = this.pixelRadius(axisRadius);

    if (this.bent) {
      var point_1 = {
        x: (axisRadius + labelRadius) * _core_utils_Math__WEBPACK_IMPORTED_MODULE_3__["cos"](angle + 180),
        y: (axisRadiusY + labelRadius * axisRadiusY / axisRadius) * _core_utils_Math__WEBPACK_IMPORTED_MODULE_3__["sin"](angle + 180)
      };
      this.path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_5__["moveTo"](point_1) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_5__["arcTo"](angle + 180, 360, axisRadius + labelRadius, axisRadiusY + labelRadius * axisRadiusY / axisRadius);

      if (this.textPathElement) {
        this.textPathElement.attr({
          "startOffset": this.locationOnPath * 100 + "%"
        });
      }

      return;
    } // WHEN ROTATED


    if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_4__["isNumber"](relativeRotation)) {
      this.horizontalCenter = "none";
      this.verticalCenter = "none";
      angle = _core_utils_Math__WEBPACK_IMPORTED_MODULE_3__["fitAngleToRange"](angle, -180, 180);
      var pixelWidth = this.bbox.width;
      var pixelHeight = this.bbox.height;
      var pixelPaddingBottom = this.pixelPaddingBottom;
      var pixelPaddingTop = this.pixelPaddingTop;
      var pixelPaddingLeft = this.pixelPaddingLeft;
      var pixelPaddingRight = this.pixelPaddingRight;

      if (angle > 90 || angle < -90) {
        if (relativeRotation == -90) {
          relativeRotation = 90;
          pixelWidth = 0;
        }
      } else {
        if (relativeRotation == -90) {
          pixelHeight = -pixelHeight;
        }

        if (relativeRotation == 90) {
          relativeRotation = -90;
          pixelWidth = -pixelPaddingLeft - pixelPaddingRight;
          pixelHeight = -pixelHeight - pixelPaddingTop - pixelPaddingBottom;
        }
      }

      this.rotation = relativeRotation + angle + 90;
      var dH = _core_utils_Math__WEBPACK_IMPORTED_MODULE_3__["sin"](relativeRotation) / 2;
      var dW = _core_utils_Math__WEBPACK_IMPORTED_MODULE_3__["cos"](relativeRotation) / 2;
      var rotation = this.rotation;
      this.dx = pixelHeight * dH * _core_utils_Math__WEBPACK_IMPORTED_MODULE_3__["sin"](rotation) - pixelWidth * dW * _core_utils_Math__WEBPACK_IMPORTED_MODULE_3__["cos"](rotation);
      this.dy = -pixelHeight * dH * _core_utils_Math__WEBPACK_IMPORTED_MODULE_3__["cos"](rotation) - pixelWidth * dW * _core_utils_Math__WEBPACK_IMPORTED_MODULE_3__["sin"](rotation);

      if (!this.inside) {
        labelRadius += (pixelHeight + pixelPaddingBottom + pixelPaddingTop) * _core_utils_Math__WEBPACK_IMPORTED_MODULE_3__["cos"](relativeRotation) + (pixelWidth + pixelPaddingLeft + pixelPaddingRight) * _core_utils_Math__WEBPACK_IMPORTED_MODULE_3__["sin"](relativeRotation);
      } else {
        if (angle > 90 || angle < -90) {
          labelRadius -= (pixelPaddingBottom + pixelPaddingTop) * _core_utils_Math__WEBPACK_IMPORTED_MODULE_3__["cos"](relativeRotation) + (pixelPaddingLeft + pixelPaddingRight) * _core_utils_Math__WEBPACK_IMPORTED_MODULE_3__["sin"](relativeRotation);
        } else {
          labelRadius += (pixelPaddingBottom + this.bbox.height + pixelPaddingTop) * _core_utils_Math__WEBPACK_IMPORTED_MODULE_3__["cos"](relativeRotation) + (pixelPaddingLeft + pixelPaddingRight + this.bbox.width) * _core_utils_Math__WEBPACK_IMPORTED_MODULE_3__["sin"](relativeRotation);
        }
      }

      point.x += _core_utils_Math__WEBPACK_IMPORTED_MODULE_3__["cos"](angle) * labelRadius;
      point.y += _core_utils_Math__WEBPACK_IMPORTED_MODULE_3__["sin"](angle) * labelRadius * axisRadiusY / axisRadius;
    } else {
      // END OF ROTATED
      this.horizontalCenter = "middle";
      this.verticalCenter = "middle";

      if (isNegative) {
        this.dx = 0;
        this.dy = 0;
        point.x = (axisRadius + labelRadius) * _core_utils_Math__WEBPACK_IMPORTED_MODULE_3__["cos"](angle);
        point.y = (axisRadiusY + labelRadius * axisRadiusY / axisRadius) * _core_utils_Math__WEBPACK_IMPORTED_MODULE_3__["sin"](angle);
      } else {
        // we don't use valign for labels because then they would jump while animating. instead we modify dy depending on a y position
        // this math makes dy to be 1 at the top of the circle, 0.5 at the middle and 1 at the bottom
        // @todo with this math doesn't work well with inside = true
        this.dy = this._measuredHeight / 2 * _core_utils_Math__WEBPACK_IMPORTED_MODULE_3__["sin"](angle); //(1 - (point.y + axisRadiusY) / (2 * axisRadiusY));
        // simmilar with dx

        this.dx = this._measuredWidth / 2 * _core_utils_Math__WEBPACK_IMPORTED_MODULE_3__["cos"](angle); //(1 - (point.x + axisRadius) / (2 * axisRadius));

        point.x += _core_utils_Math__WEBPACK_IMPORTED_MODULE_3__["cos"](angle) * labelRadius;
        point.y += _core_utils_Math__WEBPACK_IMPORTED_MODULE_3__["sin"](angle) * labelRadius * axisRadiusY / axisRadius;
      }
    }

    point.x += dx;
    point.y += dy;
    this.fdx = this.dx;
    this.fdy = this.dy;
    this.moveTo(point);
  };

  return AxisLabelCircular;
}(_AxisLabel__WEBPACK_IMPORTED_MODULE_1__["AxisLabel"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_2__["registry"].registeredClasses["AxisLabelCircular"] = AxisLabelCircular;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisLine.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisLine.js ***!
  \****************************************************************************/
/*! exports provided: AxisLine */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AxisLine", function() { return AxisLine; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _core_Sprite__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core/Sprite */ "./node_modules/@amcharts/amcharts4/.internal/core/Sprite.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_utils_Color__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/utils/Color */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Color.js");
/* harmony import */ var _core_utils_InterfaceColorSet__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/utils/InterfaceColorSet */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/InterfaceColorSet.js");
/**
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */





/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Used to draw Axis line.
 *
 * @see {@link IAxisLineEvents} for a list of available events
 * @see {@link IAxisLineAdapters} for a list of available Adapters
 */

var AxisLine =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(AxisLine, _super);
  /**
   * Constructor
   */


  function AxisLine() {
    var _this = _super.call(this) || this;

    _this.className = "AxisLine";
    _this.element = _this.paper.add("path");
    var interfaceColors = new _core_utils_InterfaceColorSet__WEBPACK_IMPORTED_MODULE_4__["InterfaceColorSet"]();
    _this.stroke = interfaceColors.getFor("grid");
    _this.strokeOpacity = 0.15;
    _this.pixelPerfect = true;
    _this.fill = Object(_core_utils_Color__WEBPACK_IMPORTED_MODULE_3__["color"])();

    _this.applyTheme();

    _this.interactionsEnabled = false;
    return _this; //this.element.moveTo({ x: 0, y: 0 });
  }

  return AxisLine;
}(_core_Sprite__WEBPACK_IMPORTED_MODULE_1__["Sprite"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_2__["registry"].registeredClasses["AxisLine"] = AxisLine;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisRenderer.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisRenderer.js ***!
  \********************************************************************************/
/*! exports provided: AxisRenderer */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AxisRenderer", function() { return AxisRenderer; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _core_Container__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core/Container */ "./node_modules/@amcharts/amcharts4/.internal/core/Container.js");
/* harmony import */ var _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/utils/Disposer */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Disposer.js");
/* harmony import */ var _Axis__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Axis */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/Axis.js");
/* harmony import */ var _AxisLine__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./AxisLine */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisLine.js");
/* harmony import */ var _AxisFill__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./AxisFill */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisFill.js");
/* harmony import */ var _Grid__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Grid */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/Grid.js");
/* harmony import */ var _AxisLabel__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./AxisLabel */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisLabel.js");
/* harmony import */ var _AxisTick__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./AxisTick */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisTick.js");
/* harmony import */ var _core_utils_List__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../core/utils/List */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/List.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_utils_Percent__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../core/utils/Percent */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Percent.js");
/* harmony import */ var _core_utils_Math__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../core/utils/Math */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Math.js");
/* harmony import */ var _core_utils_Type__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../core/utils/Type */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Type.js");
/**
 * Module, defining base Axis Renderer.
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */














/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * A base class for all axis renderers.
 *
 * @see {@link IAxisRendererEvents} for a list of available events
 * @see {@link IAxisRendererAdapters} for a list of available Adapters
 */

var AxisRenderer =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(AxisRenderer, _super);
  /**
   * Constructor.
   *
   * @param axis Related axis
   */


  function AxisRenderer() {
    var _this = // Init
    _super.call(this) || this;
    /**
     * A related chart.
     */


    _this._chart = new _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_2__["MutableValueDisposer"]();
    _this.className = "AxisRenderer"; // Set defaults

    _this.minGridDistance = 50;
    _this.inside = false;
    _this.inversed = false;
    _this.tooltipLocation = 0.5;
    _this.fullWidthTooltip = false;
    _this.cellStartLocation = 0;
    _this.cellEndLocation = 1;
    _this.minLabelPosition = 0;
    _this.maxLabelPosition = 1;
    _this.shouldClone = false;

    var gridContainer = _this.createChild(_core_Container__WEBPACK_IMPORTED_MODULE_1__["Container"]);

    gridContainer.shouldClone = false;
    gridContainer.layout = "none"; //	gridContainer.isMeasured = false;

    gridContainer.virtualParent = _this;
    gridContainer.width = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_11__["percent"])(100);
    gridContainer.height = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_11__["percent"])(100);
    _this.gridContainer = gridContainer; // not good without this

    gridContainer.events.on("maxsizechanged", function () {
      if (_this.inited) {
        _this.invalidateAxisItems();
      }
    }, _this, false);

    var breakContainer = _this.createChild(_core_Container__WEBPACK_IMPORTED_MODULE_1__["Container"]);

    breakContainer.shouldClone = false;
    breakContainer.isMeasured = false;
    breakContainer.layout = "none";
    breakContainer.width = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_11__["percent"])(100);
    breakContainer.height = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_11__["percent"])(100);
    _this.breakContainer = breakContainer;

    var bulletsContainer = _this.createChild(_core_Container__WEBPACK_IMPORTED_MODULE_1__["Container"]);

    bulletsContainer.shouldClone = false;
    bulletsContainer.isMeasured = false;
    bulletsContainer.layout = "none";
    bulletsContainer.width = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_11__["percent"])(100);
    bulletsContainer.height = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_11__["percent"])(100);
    _this.bulletsContainer = bulletsContainer;
    _this.line = _this.createChild(_AxisLine__WEBPACK_IMPORTED_MODULE_4__["AxisLine"]);
    _this.line.shouldClone = false;
    _this.line.strokeOpacity = 0;

    var baseGrid = _this.createChild(_Grid__WEBPACK_IMPORTED_MODULE_6__["Grid"]);

    baseGrid.shouldClone = false;
    _this.baseGrid = baseGrid; // Make elements disposable

    var disposers = _this._disposers;
    disposers.push(baseGrid);
    disposers.push(_this.line);
    disposers.push(gridContainer);
    disposers.push(breakContainer);
    disposers.push(bulletsContainer);
    disposers.push(_this._chart);
    _this.ticks.template.disabled = true;
    _this.axisFills.template.disabled = true;
    _this.axisFills.template.interactionsEnabled = false; // Apply theme

    _this.applyTheme();

    return _this;
  }

  Object.defineProperty(AxisRenderer.prototype, "axis", {
    /**
     * Axis of a renderer
     * @return axis Axis
     */
    get: function get() {
      return this._axis;
    },

    /**
     * Axis of a renderer
     * @param axis Axis
     */
    set: function set(axis) {
      this.setAxis(axis);
    },
    enumerable: true,
    configurable: true
  });
  /**
  * @ignore
  */

  AxisRenderer.prototype.setAxis = function (axis) {
    this._axis = axis;
    this.baseGrid.parent = axis;
    this.line.parent = axis;
    this.gridContainer.bind("opacity", axis);
  };
  /**
   * Called when rendered is attached to an Axis, as well as a property of
   * Axis that might affect the appearance is updated.
   *
   * E.g. `axis.opposite`, `axis.inside`, etc.
   *
   * This method is called **before** draw, so that any related setting
   * changed in this method can be changed.
   *
   * @todo Description (review)
   * @ignore Exclude from docs
   */


  AxisRenderer.prototype.processRenderer = function () {
    this.events.on("sizechanged", this.updateTooltip, this, false);
    this.events.on("positionchanged", this.updateTooltip, this, false);
    this.labels.template.inside = this.inside;
    this.ticks.template.inside = this.inside;
  };
  /**
   * Updates Axis' tooltip.
   *
   * @todo Description (review)
   * @ignore Exclude from docs
   */


  AxisRenderer.prototype.updateTooltip = function () {// This is a placeholder method for extending classes to override.
  };

  Object.defineProperty(AxisRenderer.prototype, "axisLength", {
    /**
     * Returns actual length of the Axis, in pixels.
     *
     * @return Length (px)
     */
    get: function get() {
      // This is a placeholder method for extending classes to override.
      return 0;
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Re-positions an element to new coordinates.
   *
   * @ignore Exclude from docs
   * @param item   A target element
   * @param point  New coordinates
   */

  AxisRenderer.prototype.positionItem = function (item, point) {
    if (item) {
      item.moveTo(point);
    }
  };
  /**
   * Converts relative position on axis to point coordinates.
   *
   * @param position  Position (0-1)
   * @return Point
   */


  AxisRenderer.prototype.positionToPoint = function (position, position2) {
    // This is a placeholder method for extending classes to override.
    return {
      x: 0,
      y: 0
    };
  };
  /**
   * Converts relative position on axis to angle.
   *
   * @ignore Exclude from docs
   * @todo Description (review / units)
   * @param position  Position (0-1)
   * @return Angle
   */


  AxisRenderer.prototype.positionToAngle = function (position) {
    // This is a placeholder method for extending classes to override.
    return 0;
  };
  /**
   * Converts relative position (0-1) on axis to a pixel coordinate.
   *
   * @param position  Position (0-1)
   * @return Coordinate (px)
   */


  AxisRenderer.prototype.positionToCoordinate = function (position) {
    var coordinate;
    var axis = this.axis;
    var axisFullLength = axis.axisFullLength;

    if (axis.renderer.inversed) {
      coordinate = (axis.end - position) * axisFullLength;
    } else {
      coordinate = (position - axis.start) * axisFullLength;
    }

    return coordinate;
  };

  AxisRenderer.prototype.updateGridContainer = function () {};

  AxisRenderer.prototype.getHeight = function () {
    var gridContainer = this.gridContainer;

    if (gridContainer.parent) {
      return gridContainer.parent.pixelHeight;
    }

    return this.gridContainer.pixelHeight || 0;
  };

  AxisRenderer.prototype.getWidth = function () {
    var gridContainer = this.gridContainer;

    if (gridContainer.parent) {
      return gridContainer.parent.pixelWidth;
    }

    return this.gridContainer.pixelWidth || 0;
  };
  /**
   * Converts a coordinate in pixels to a relative position. (0-1)
   *
   * @param coordinate  Coordinate (px)
   * @param coordinate2  Coordinate of a second axis, only needed for complex axes systems, like timeline (px)
   * @return Position (0-1)
   */


  AxisRenderer.prototype.coordinateToPosition = function (coordinate, coordinate2) {
    var position;
    var axis = this.axis;
    var axisFullLength = axis.axisFullLength;

    if (axis.renderer.inversed) {
      position = axis.end - coordinate / axisFullLength;
    } else {
      position = coordinate / axisFullLength + axis.start;
    }

    return _core_utils_Math__WEBPACK_IMPORTED_MODULE_12__["round"](position, 5);
  };
  /**
   * Converts a point at specific coordinates to a relative position (0-1)
   * on the axis.
   *
   * @ignore Exclude from docs
   * @param point  Point
   * @return Position (0-1)
   */


  AxisRenderer.prototype.pointToPosition = function (point) {
    // This is a placeholder method for extending classes to override.
    return 0;
  };
  /**
   * [getPositionRangePath description]
   *
   * @ignore Exclude from docs
   * @todo Description
   * @param startPosition  Starting position
   * @param endPosition    End position
   * @return SVG path
   */


  AxisRenderer.prototype.getPositionRangePath = function (startPosition, endPosition) {
    return "";
  };
  /**
   * Invalidates all axis data items, effectively causing them re-evaluated.
   *
   * @ignore Exclude from docs
   * @todo Description (review)
   */


  AxisRenderer.prototype.invalidateAxisItems = function () {
    var axis = this.axis;

    if (axis) {
      axis.invalidateDataItems();
    }
  };
  /**
   * Updates and positions a grid element.
   *
   * @ignore Exclude from docs
   * @param grid         Grid element
   * @param position     Starting position
   * @param endPosition  End position
   */


  AxisRenderer.prototype.updateGridElement = function (grid, position, endPosition) {// This is a placeholder method for extending classes to override.
  };
  /**
   * Updates and positions a tick element.
   *
   * @ignore Exclude from docs
   * @param tick         Tick element
   * @param position     Starting position
   * @param endPosition  End position
   */


  AxisRenderer.prototype.updateTickElement = function (tick, position, endPosition) {// This is a placeholder method for extending classes to override.
  };
  /**
   * Updates and positions axis bullet.
   *
   * @ignore Exclude from docs
   * @param bullet       AxisBullet element
   * @param position     Starting position
   * @param endPosition  End position
   */


  AxisRenderer.prototype.updateBullet = function (bullet, position, endPosition) {// This is a placeholder method for extending classes to override.
  };
  /**
   * Updates and positions a label element.
   *
   * @ignore Exclude from docs
   * @param label        Label element
   * @param position     Starting position
   * @param endPosition  Ending position
   */


  AxisRenderer.prototype.updateLabelElement = function (label, position, endPosition, location) {// This is a placeholder method for extending classes to override.
  };
  /**
   * Updates and positions the axis fill element.
   *
   * @ignore Exclude from docs
   * @param fill         Fill element
   * @param position     Starting position
   * @param endPosition  Ending position
   */


  AxisRenderer.prototype.updateFillElement = function (fill, position, endPosition) {
    fill.startPosition = position;
    fill.endPosition = endPosition;
  };
  /**
   * Updates and positions the axis line element.
   *
   * @ignore Exclude from docs
   */


  AxisRenderer.prototype.updateAxisLine = function () {// This is a placeholder method for extending classes to override.
  };
  /**
   * Updates and positions the base grid element.
   *
   * @ignore Exclude from docs
   */


  AxisRenderer.prototype.updateBaseGridElement = function () {// This is a placeholder method for extending classes to override.
  };
  /**
   * Updates and positions an axis break element.
   *
   * @ignore Exclude from docs
   * @param axisBreak Break element
   */


  AxisRenderer.prototype.updateBreakElement = function (axisBreak) {
    this.positionItem(axisBreak.startLine, axisBreak.startPoint);
    this.toggleVisibility(axisBreak.startLine, axisBreak.startPosition, 0, 1);
    this.positionItem(axisBreak.endLine, axisBreak.endPoint);
    this.toggleVisibility(axisBreak.endLine, axisBreak.endPosition, 0, 1);
  };

  Object.defineProperty(AxisRenderer.prototype, "minGridDistance", {
    /**
     * @return Min distance (px)
     */
    get: function get() {
      return this.getPropertyValue("minGridDistance");
    },

    /**
     * Minimum distance in pixels between grid elements.
     *
     * Use it to control density of the grid/labels on the axis.element.
     *
     * @see {@link https://www.amcharts.com/docs/v4/concepts/axes/positioning-axis-elements/#Setting_the_density_of_the_the_grid_labels} for more info
     * @param value  Min distance (px)
     */
    set: function set(value) {
      if (this.setPropertyValue("minGridDistance", value)) {
        if (this.axis) {
          this.axis.invalidateDataItems();
        }
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisRenderer.prototype, "chart", {
    /**
     * @ignore Exclude from docs
     * @return Chart
     */
    get: function get() {
      return this._chart.get();
    },

    /**
     * A chart, associated with the Axis.
     *
     * @ignore Exclude from docs
     * @param value  Chart
     */
    set: function set(value) {
      this._chart.set(value, null);
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Toggles visibility of an element, based on its current position and
   * min/max position settings.
   *
   * E.g. labels based on `minLabelPosition` and `maxLabelPosition`.
   *
   * @ignore Exclude from docs
   * @param sprite       An element to toggle
   * @param position     Elements current position
   * @param minPosition  Min position setting
   * @param maxPosition  Max position setting
   */

  AxisRenderer.prototype.toggleVisibility = function (sprite, position, minPosition, maxPosition) {
    var axis = this.axis;
    var dataItem = sprite.dataItem;

    if (dataItem && dataItem instanceof _Axis__WEBPACK_IMPORTED_MODULE_3__["AxisDataItem"]) {
      if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_13__["isNumber"](dataItem.minPosition)) {
        minPosition = dataItem.minPosition;
      }

      if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_13__["isNumber"](dataItem.maxPosition)) {
        maxPosition = dataItem.maxPosition;
      }
    }

    var updatedStart = axis.start + (axis.end - axis.start) * (minPosition - 0.0001);
    var updatedEnd = axis.start + (axis.end - axis.start) * (maxPosition + 0.0001);

    if (!sprite.disabled) {
      if (position < updatedStart || position > updatedEnd) {
        sprite.__disabled = true;
      } else {
        sprite.__disabled = false;
      }
    }
  };
  /**
   * Creates visual elements for and axis break.
   *
   * @ignore Exclude from docs
   * @param axisBreak Axis break
   */


  AxisRenderer.prototype.createBreakSprites = function (axisBreak) {// This is a placeholder method for extending classes to override.
  };

  Object.defineProperty(AxisRenderer.prototype, "axisFills", {
    /**
     * A list of Axis' Fill elements.
     *
     * Those are fill elements that cover the space between every second set
     * of grid lines, and can be configured to create striped charts.
     *
     * Please note that these are disabled by default. To enable them, set
     * template to true.
     *
     * ```TypeScript
     * categoryAxis.renderer.axisFills.template.disabled = false;
     * ```
     * ```JavaScript
     * categoryAxis.renderer.axisFills.template.disabled = false;
     * ```
     * ```JSON
     * {
     *   // ...
     *   "xAxes": [{
     *     // ...
     *     "renderer": {
     *       "axisFills": {
     *         "disabled": false
     *       }
     *     }
     *   }]
     * }
     * ```
     *
     * @see {@link https://www.amcharts.com/docs/v4/tutorials/alternated-axis-fills/} this tutorial for more info.
     * @return Fill elements
     */
    get: function get() {
      if (!this._axisFills) {
        var fill = this.createFill(this.axis);
        this._axisFills = new _core_utils_List__WEBPACK_IMPORTED_MODULE_9__["ListTemplate"](fill);
        fill.applyOnClones = true;
        fill.events.on("enabled", this.invalidateAxisItems, this, false);

        this._disposers.push(new _core_utils_List__WEBPACK_IMPORTED_MODULE_9__["ListDisposer"](this._axisFills));

        this._disposers.push(this._axisFills.template);
      }

      return this._axisFills;
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Returns a new fill element, suitable for this Axis Renderer type.
   *
   * @return Fill element
   */

  AxisRenderer.prototype.createFill = function (axis) {
    return new _AxisFill__WEBPACK_IMPORTED_MODULE_5__["AxisFill"](axis);
  };

  Object.defineProperty(AxisRenderer.prototype, "grid", {
    /**
     * A list of Axis' Grid elements.
     *
     * @return Grid elements
     */
    get: function get() {
      if (!this._grid) {
        var grid = this.createGrid();
        this._grid = new _core_utils_List__WEBPACK_IMPORTED_MODULE_9__["ListTemplate"](grid);
        grid.applyOnClones = true;
        grid.events.on("enabled", this.invalidateAxisItems, this, false);

        this._disposers.push(new _core_utils_List__WEBPACK_IMPORTED_MODULE_9__["ListDisposer"](this._grid));

        this._disposers.push(this._grid.template);
      }

      return this._grid;
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Returns a new grid element, suitable for this Axis Renderer type.
   *
   * @return Grid element
   */

  AxisRenderer.prototype.createGrid = function () {
    return new _Grid__WEBPACK_IMPORTED_MODULE_6__["Grid"]();
  };

  Object.defineProperty(AxisRenderer.prototype, "ticks", {
    /**
     * A list of Axis' Tick elements.
     *
     * Please note that these are disabled by default. To enable ticks, you'll
     * need to set `disabled` and `strokeOpacity` properties of the tick template.
     *
     * ```TypeScript
     * categoryAxis.renderer.ticks.template.disabled = false;
     * categoryAxis.renderer.ticks.template.strokeOpacity = 0.5;
     * ```
     * ```JavaScript
     * categoryAxis.renderer.ticks.template.disabled = false;
     * categoryAxis.renderer.ticks.template.strokeOpacity = 0.5;
     * ```
     * ```JSON
     * {
     *   // ...
     *   "xAxes": [{
     *     // ...
     *     "renderer": {
     *       "ticks": {
     *         "disabled": false,
     *         "strokeOpacity": 0.5
     *       }
     *     }
     *   }]
     * }
     * ```
     *
     * @return Tick elements
     */
    get: function get() {
      if (!this._ticks) {
        var tick = this.createTick();
        tick.applyOnClones = true;
        tick.isMeasured = false;
        tick.events.on("enabled", this.invalidateAxisItems, this, false);
        this._ticks = new _core_utils_List__WEBPACK_IMPORTED_MODULE_9__["ListTemplate"](tick);

        this._disposers.push(new _core_utils_List__WEBPACK_IMPORTED_MODULE_9__["ListDisposer"](this._ticks));

        this._disposers.push(this._ticks.template);
      }

      return this._ticks;
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Returns a new tick element, suitable for this Axis Renderer type.
   *
   * @return Tick element
   */

  AxisRenderer.prototype.createTick = function () {
    return new _AxisTick__WEBPACK_IMPORTED_MODULE_8__["AxisTick"]();
  };

  Object.defineProperty(AxisRenderer.prototype, "labels", {
    /**
     * A list of Axis' Label elements.
     *
     * @return Label elements
     */
    get: function get() {
      if (!this._labels) {
        var label = this.createLabel();
        this._labels = new _core_utils_List__WEBPACK_IMPORTED_MODULE_9__["ListTemplate"](label);
        label.applyOnClones = true;
        label.events.on("enabled", this.invalidateAxisItems, this, false);

        this._disposers.push(new _core_utils_List__WEBPACK_IMPORTED_MODULE_9__["ListDisposer"](this._labels));

        this._disposers.push(this._labels.template);
      }

      return this._labels;
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Returns a new label element, suitable for this Axis Renderer type.
   *
   * @return Label element
   */

  AxisRenderer.prototype.createLabel = function () {
    return new _AxisLabel__WEBPACK_IMPORTED_MODULE_7__["AxisLabel"]();
  };

  Object.defineProperty(AxisRenderer.prototype, "inside", {
    /**
     * @return Labels inside?
     */
    get: function get() {
      return this.getPropertyValue("inside");
    },

    /**
     * Indicates whether Axis' labels and ticks should be drawn inside Plot area.
     *
     * Does not work with all renderers, like AxisRendererRadial.
     *
     * @param value  Labels inside?
     */
    set: function set(value) {
      if (this.setPropertyValue("inside", value)) {
        if (this.axis) {
          this.axis.invalidate();
        }
      }

      if (value) {
        this.width = 0;
        this.height = 0;
      } else {
        this.width = undefined;
        this.height = undefined;
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisRenderer.prototype, "opposite", {
    /**
     * @return Draw axis on opposite side?
     */
    get: function get() {
      return this.getPropertyValue("opposite");
    },

    /**
     * Indicates whether Axis should be drawn on the opposite side of the plot
     * area than it would normally be drawn based on chart's settings.
     *
     * Does not work with all renderers, like [[AxisRendererRadial]] and
     * [[AxisRenderer Circular].
     *
     * @param value  Draw axis on opposite side?
     */
    set: function set(value) {
      this.setPropertyValue("opposite", value);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisRenderer.prototype, "fullWidthTooltip", {
    /**
     * @return Full width tooltip?
     */
    get: function get() {
      return this.getPropertyValue("fullWidthTooltip");
    },

    /**
     * Indicates if Axis tooltip should take the whole width of the axis cell.
     * (between two grid lines)
     *
     * NOTE: this setting is ignored on circular axis types.
     *
     * @param value Full width tooltip?
     */
    set: function set(value) {
      this.setPropertyValue("fullWidthTooltip", value);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisRenderer.prototype, "tooltipLocation", {
    /**
     * @return Tooltip location
     */
    get: function get() {
      return this.getPropertyValue("tooltipLocation");
    },

    /**
     * Location within axis cell to show tooltip on. (0-1)
     *
     * 0 - show at the start
     * 0.5 - show right in the middle
     * 1 - show at the end
     *
     * @param value Tooltip location
     */
    set: function set(value) {
      this.setPropertyValue("tooltipLocation", value);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisRenderer.prototype, "tooltipLocation2", {
    /**
     * @return Tooltip location
     */
    get: function get() {
      return this.getPropertyValue("tooltipLocation2");
    },

    /**
     * Location within secondary axis cell to show tooltip on. (0-1)
     *
     * 0 - show at the start
     * 0.5 - show right in the middle
     * 1 - show at the end
     *
     * @param value Tooltip location
     */
    set: function set(value) {
      this.setPropertyValue("tooltipLocation2", value);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisRenderer.prototype, "cellStartLocation", {
    /**
     * @return Cell start (0-1)
     */
    get: function get() {
      return this.getPropertyValue("cellStartLocation");
    },

    /**
     * Location for the cell start.
     *
     * Normally a "cell" is the whole available width in a category.
     *
     * If there are several clustered column-like series available, the whole
     * space is divided between each clustered column, or column stacks.
     *
     * `cellStartLocation` identifies where, within available space, the actual
     * cell starts.
     *
     * This, together with column series' `width` will affect actual width of
     * columns, and thus gaps between them.
     *
     * This will affect category-like axes only, like [[DateAxis]], or
     * [[CategoryAxis]].
     *
     * This is used to limit a space occupied by series like column.
     *
     * @see {@link https://www.amcharts.com/docs/v4/concepts/axes/positioning-axis-elements/} for more info.
     * @param value Cell start (0-1)
     */
    set: function set(value) {
      if (this.setPropertyValue("cellStartLocation", value)) {
        if (this.axis) {
          this.axis.invalidateSeries();
        }
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisRenderer.prototype, "cellEndLocation", {
    /**
     * @return Cell end (0-1)
     */
    get: function get() {
      return this.getPropertyValue("cellEndLocation");
    },

    /**
     * Location for the cell end.
     *
     * Normally a "cell" is the whole available width in a category.
     *
     * If there are several clustered column-like series available, the whole
     * space is divided between each clustered column, or column stacks.
     *
     * `cellEndLocation` identifies where, within available space, the actual
     * cell ends.
     *
     * This, together with column series' `width` will affect actual width of
     * columns, and thus gaps between them.
     *
     * This will affect category-like axes only, like [[DateAxis]], or
     * [[CategoryAxis]].
     *
     * This is used to limit a space occupied by series like column.
     *
     * @see {@link https://www.amcharts.com/docs/v4/concepts/axes/positioning-axis-elements/} for more info.
     * @param value Cell end (0-1)
     */
    set: function set(value) {
      if (this.setPropertyValue("cellEndLocation", value)) {
        if (this.axis) {
          this.axis.invalidateSeries();
        }
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisRenderer.prototype, "inversed", {
    /**
     * @return Flip axis?
     */
    get: function get() {
      return this.getPropertyValue("inversed");
    },

    /**
     * Indicates if the scale of the axis should be flipped.
     *
     * @param value Flip axis?
     */
    set: function set(value) {
      this.setPropertyValue("inversed", value);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisRenderer.prototype, "minLabelPosition", {
    /**
     * @return Min label position (0-1)
     */
    get: function get() {
      return this.getPropertyValue("minLabelPosition");
    },

    /**
     * Minimum position along the Axis, for labels.
     *
     * Labels, which have their position closer to the start of the Axis, will be
     * automatically hidden.
     *
     * E.g., setting this to 0.05 (5% of total axis length) would hide labels,
     * that would otherwise be drawn very near start of the Axis.
     *
     * This is especially usefull with `inside = true`, or if the chart hasn't
     * got any extra margins.
     *
     * @see {@link https://www.amcharts.com/docs/v4/concepts/axes/positioning-axis-elements/} for more info.
     * @param value  Min label position (0-1)
     */
    set: function set(value) {
      this.setPropertyValue("minLabelPosition", value, true);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisRenderer.prototype, "maxLabelPosition", {
    /**
     * @return Max label position (0-1)
     */
    get: function get() {
      return this.getPropertyValue("maxLabelPosition");
    },

    /**
     * Maximum position along the Axis, for labels.
     *
     * Labels, which have their position closer to the and of the Axis, will be
     * automatically hidden.
     *
     * E.g., setting this to 0.95 (95% of total axis length) would hide labels,
     * that would otherwise be drawn very near end of the Axis.
     *
     * This is especially usefull with `inside = true`, or if the chart hasn't
     * got any extra margins.
     *
     * @see {@link https://www.amcharts.com/docs/v4/concepts/axes/positioning-axis-elements/} for more info.
     * @param value  Max label position (0-1)
     */
    set: function set(value) {
      this.setPropertyValue("maxLabelPosition", value, true);
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Copies all settings and related items from another object of the same
   * type.
   *
   * @param source  Source object
   */

  AxisRenderer.prototype.copyFrom = function (source) {
    _super.prototype.copyFrom.call(this, source);

    this.grid.template.copyFrom(source.grid.template);
    this.ticks.template.copyFrom(source.ticks.template);
    this.labels.template.copyFrom(source.labels.template);
    this.axisFills.template.copyFrom(source.axisFills.template);
    this.line.copyFrom(source.line);
    this.baseGrid.copyFrom(source.baseGrid);
  };
  /**
   * @ignore
   */


  AxisRenderer.prototype.toAxisPosition = function (value) {
    return value;
  };
  /**
   * Sets `visibility` property:
   *
   * * `true` - visible
   * * `false` - hidden
   *
   * @param value  true - visible, false - hidden
   * @return Current visibility
   */


  AxisRenderer.prototype.setVisibility = function (value) {
    _super.prototype.setVisibility.call(this, value);

    this.bulletsContainer.visible = value;
  };

  return AxisRenderer;
}(_core_Container__WEBPACK_IMPORTED_MODULE_1__["Container"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_10__["registry"].registeredClasses["AxisRenderer"] = AxisRenderer;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisRendererCircular.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisRendererCircular.js ***!
  \****************************************************************************************/
/*! exports provided: AxisRendererCircular */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AxisRendererCircular", function() { return AxisRendererCircular; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _AxisRenderer__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AxisRenderer */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisRenderer.js");
/* harmony import */ var _AxisFillCircular__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./AxisFillCircular */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisFillCircular.js");
/* harmony import */ var _GridCircular__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./GridCircular */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/GridCircular.js");
/* harmony import */ var _AxisLabelCircular__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./AxisLabelCircular */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisLabelCircular.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_utils_Percent__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core/utils/Percent */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Percent.js");
/* harmony import */ var _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../core/utils/Math */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Math.js");
/* harmony import */ var _core_rendering_Path__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../core/rendering/Path */ "./node_modules/@amcharts/amcharts4/.internal/core/rendering/Path.js");
/* harmony import */ var _core_utils_Utils__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../core/utils/Utils */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Utils.js");
/* harmony import */ var _core_utils_Type__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../core/utils/Type */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Type.js");
/* harmony import */ var _AxisBullet__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./AxisBullet */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisBullet.js");
/**
 * Module, defining Axis Renderer for circular axes.
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */












/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * A renderer for circular axis.
 */

var AxisRendererCircular =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(AxisRendererCircular, _super);
  /**
   * Constructor.
   *
   * @param axis Related axis
   */


  function AxisRendererCircular() {
    var _this = // Init
    _super.call(this) || this;
    /**
     * @ignore
     */


    _this.pixelRadiusReal = 0; // axis.layout = "none"; // does not trigger redraw when size changes

    _this.layout = "none";
    _this.className = "AxisRendererCircular";
    _this.isMeasured = false;
    _this.startAngle = -90;
    _this.endAngle = 270;
    _this.useChartAngles = true;
    _this.radius = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_6__["percent"])(100);
    _this.isMeasured = false;
    _this.grid.template.location = 0;
    _this.labels.template.location = 0;
    _this.labels.template.radius = 15;
    _this.ticks.template.location = 0;
    _this.ticks.template.pixelPerfect = false;
    _this.tooltipLocation = 0;
    _this.line.strokeOpacity = 0;

    _this.applyTheme();

    return _this;
  }
  /**
  * @ignore
  */


  AxisRendererCircular.prototype.setAxis = function (axis) {
    var _this = this;

    _super.prototype.setAxis.call(this, axis);

    axis.isMeasured = false; // modify x and y so that tooltip would always be on circle

    var tooltip = axis.tooltip;
    tooltip.adapter.add("dx", function (x, target) {
      var point = _core_utils_Utils__WEBPACK_IMPORTED_MODULE_9__["svgPointToSprite"]({
        x: target.pixelX,
        y: target.pixelY
      }, _this);
      return _this.pixelRadius * Math.cos(Math.atan2(point.y, point.x)) - point.x;
    });
    tooltip.adapter.add("dy", function (y, target) {
      var point = _core_utils_Utils__WEBPACK_IMPORTED_MODULE_9__["svgPointToSprite"]({
        x: target.pixelX,
        y: target.pixelY
      }, _this);
      return _this.pixelRadius * Math.sin(Math.atan2(point.y, point.x)) - point.y;
    });
  };
  /**
   * Validates Axis renderer.
   *
   * @ignore Exclude from docs
   */


  AxisRendererCircular.prototype.validate = function () {
    // so that radius would be updated
    if (this.chart && this.chart.invalid) {
      this.chart.validate();
    }

    _super.prototype.validate.call(this);
  };

  Object.defineProperty(AxisRendererCircular.prototype, "axisLength", {
    /**
     * Returns actual length of the Axis, in pixels.
     *
     * @return Length (px)
     */
    get: function get() {
      return 2 * Math.PI * this.pixelRadius;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisRendererCircular.prototype, "radius", {
    /**
     * @return Outer radius
     */
    get: function get() {
      return this.getPropertyValue("radius");
    },

    /**
     * Outer radius of the axis.
     *
     * Can be absolute (px) or relative ([[Percent]]).
     *
     * @param value  Outer radius
     */
    set: function set(value) {
      if (this.setPercentProperty("radius", value, false, false, 10, false)) {
        if (this.axis) {
          this.axis.invalidate();
        }
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisRendererCircular.prototype, "pixelRadius", {
    /**
     * Outer radius in pixels.
     *
     * @return Outer radius (px)
     */
    get: function get() {
      return _core_utils_Utils__WEBPACK_IMPORTED_MODULE_9__["relativeRadiusToValue"](this.radius, this.pixelRadiusReal) || 0;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisRendererCircular.prototype, "innerRadius", {
    /**
     * @return Inner radius
     */
    get: function get() {
      var chart = this.chart;
      var innerRadius = this.getPropertyValue("innerRadius");

      if (chart) {
        if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_10__["hasValue"](innerRadius)) {
          innerRadius = chart.innerRadius;

          if (innerRadius instanceof _core_utils_Percent__WEBPACK_IMPORTED_MODULE_6__["Percent"] && chart) {
            innerRadius = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_6__["percent"])(innerRadius.value * chart.innerRadiusModifyer * 100);
          }
        } else {
          if (innerRadius instanceof _core_utils_Percent__WEBPACK_IMPORTED_MODULE_6__["Percent"] && chart) {
            var mr = chart.mr;
            var value = innerRadius.value;
            value = Math.max(mr * value, mr - Math.min(chart.plotContainer.innerHeight, chart.plotContainer.innerWidth)) / mr;
            innerRadius = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_6__["percent"])(value * 100);
          }
        }

        return innerRadius;
      }
    },

    /**
     * Inner radius of the axis.
     *
     * Can be absolute (px) or relative ([[Percent]]).
     *
     * @param value  Inner radius
     */
    set: function set(value) {
      if (this.setPercentProperty("innerRadius", value, false, false, 10, false)) {
        if (this.axis) {
          this.axis.invalidate();
        }
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisRendererCircular.prototype, "useChartAngles", {
    /**
     * @return Use chart angles
     */
    get: function get() {
      return this.getPropertyValue("useChartAngles");
    },

    /**
     * Specifies if axis should use its own `startAngle` and `endAngle` or
     * inherit them from relative properties from chart.
     *
     * @default false
     * @param value  Use chart's angles
     */
    set: function set(value) {
      this.setPropertyValue("useChartAngles", value);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisRendererCircular.prototype, "pixelInnerRadius", {
    /**
     * Inner radius in pixels.
     *
     * @return Inner radius (px)
     */
    get: function get() {
      return _core_utils_Utils__WEBPACK_IMPORTED_MODULE_9__["relativeRadiusToValue"](this.innerRadius, this.pixelRadiusReal) || 0;
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Converts relative position on axis to point coordinates.
   *
   * @param position  Position (0-1)
   * @param position2  Position (0-1) Position on the second axis
   * @return Point
   */

  AxisRendererCircular.prototype.positionToPoint = function (position, position2) {
    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_10__["isNumber"](position2)) {
      position2 = 1;
    }

    var coordinate = this.positionToCoordinate(position);
    var angle = this.startAngle + (this.endAngle - this.startAngle) * coordinate / this.axisLength;
    var radius = this.pixelRadius;
    var innerRadius = this.pixelInnerRadius;

    if (this.axisRendererY) {
      var realRadius = _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["fitToRange"](this.axisRendererY.positionToCoordinate(position2), 0, Infinity);
      var point = {
        x: realRadius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["cos"](angle),
        y: realRadius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["sin"](angle)
      };
      return point;
    }

    return {
      x: _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["cos"](angle) * innerRadius + (radius - innerRadius) * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["cos"](angle) * position2,
      y: _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["sin"](angle) * innerRadius + (radius - innerRadius) * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["sin"](angle) * position2
    };
  };
  /**
   * Converts relative position (0-1) on axis to angle in degrees (0-360).
   *
   * @param position  Position (0-1)
   * @return Angle (0-360)
   */


  AxisRendererCircular.prototype.positionToAngle = function (position) {
    var axis = this.axis;
    var arc = (this.endAngle - this.startAngle) / (axis.end - axis.start);
    var angle;

    if (axis.renderer.inversed) {
      angle = this.startAngle + (axis.end - position) * arc;
    } else {
      angle = this.startAngle + (position - axis.start) * arc;
    }

    return _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["round"](angle, 3);
  };
  /**
   * Converts angle on axis to relative position(0-1).
   *
   * @param angle Angle in degrees
   * @return Position (0-1)
   */


  AxisRendererCircular.prototype.angleToPosition = function (angle) {
    var axis = this.axis;
    var arc = (this.endAngle - this.startAngle) / (axis.end - axis.start);
    var position;

    if (axis.renderer.inversed) {
      position = axis.end - (angle - this.startAngle) / arc;
    } else {
      position = (angle - this.startAngle) / arc + axis.start;
    }

    return _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["round"](position, 5);
  };
  /**
   * Updates and positions the axis line element.
   *
   * @ignore Exclude from docs
   */


  AxisRendererCircular.prototype.updateAxisLine = function () {
    var radius = this.pixelRadius;
    var startAngle = this.startAngle;
    var endAngle = this.endAngle;
    var arc = _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["min"](360, endAngle - startAngle);
    this.line.path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_8__["moveTo"]({
      x: radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["cos"](startAngle),
      y: radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["sin"](startAngle)
    }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_8__["arcTo"](startAngle, arc, radius, radius);
  };
  /**
   * Updates and positions a grid element.
   *
   * @ignore Exclude from docs
   * @param grid         Grid element
   * @param position     Starting position
   * @param endPosition  End position
   */


  AxisRendererCircular.prototype.updateGridElement = function (grid, position, endPosition) {
    position = position + (endPosition - position) * grid.location;
    var point = this.positionToPoint(position);

    if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_10__["isNumber"](point.x) && _core_utils_Type__WEBPACK_IMPORTED_MODULE_10__["isNumber"](point.y) && grid.element) {
      var angle = _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["DEGREES"] * Math.atan2(point.y, point.x);
      var radius = _core_utils_Utils__WEBPACK_IMPORTED_MODULE_9__["relativeRadiusToValue"](_core_utils_Type__WEBPACK_IMPORTED_MODULE_10__["hasValue"](grid.radius) ? grid.radius : Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_6__["percent"])(100), this.pixelRadius);
      var gridInnerRadius = _core_utils_Utils__WEBPACK_IMPORTED_MODULE_9__["relativeRadiusToValue"](grid.innerRadius, this.pixelRadius);
      grid.zIndex = 0;
      var innerRadius = _core_utils_Utils__WEBPACK_IMPORTED_MODULE_9__["relativeRadiusToValue"](_core_utils_Type__WEBPACK_IMPORTED_MODULE_10__["isNumber"](gridInnerRadius) ? gridInnerRadius : this.innerRadius, this.pixelRadiusReal, true);

      if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_10__["isNumber"](innerRadius)) {
        innerRadius = 0;
      }

      grid.path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_8__["moveTo"]({
        x: innerRadius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["cos"](angle),
        y: innerRadius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["sin"](angle)
      }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_8__["lineTo"]({
        x: radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["cos"](angle),
        y: radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["sin"](angle)
      });
    }

    this.toggleVisibility(grid, position, 0, 1);
  };
  /**
   * Updates and positions a tick element.
   *
   * @ignore Exclude from docs
   * @param tick         Tick element
   * @param position     Starting position
   * @param endPosition  End position
   */


  AxisRendererCircular.prototype.updateTickElement = function (tick, position, endPosition) {
    position = position + (endPosition - position) * tick.location;
    var point = this.positionToPoint(position);

    if (tick.element) {
      var radius = this.pixelRadius;
      var angle = _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["DEGREES"] * Math.atan2(point.y, point.x);
      var tickLength = tick.length;

      if (tick.inside) {
        tickLength = -tickLength;
      }

      tick.zIndex = 1;
      tick.path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_8__["moveTo"]({
        x: radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["cos"](angle),
        y: radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["sin"](angle)
      }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_8__["lineTo"]({
        x: (radius + tickLength) * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["cos"](angle),
        y: (radius + tickLength) * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["sin"](angle)
      });
    }

    this.toggleVisibility(tick, position, 0, 1);
  };
  /**
   * Updates and positions axis bullet.
   *
   * @ignore Exclude from docs
   * @param bullet       AxisBullet element
   * @param position     Starting position
   * @param endPosition  End position
   */


  AxisRendererCircular.prototype.updateBullet = function (bullet, position, endPosition) {
    var location = 0.5;

    if (bullet instanceof _AxisBullet__WEBPACK_IMPORTED_MODULE_11__["AxisBullet"]) {
      location = bullet.location;
    }

    position = position + (endPosition - position) * location;
    var point = this.positionToPoint(position);
    var radius = this.pixelRadius;
    var angle = _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["DEGREES"] * Math.atan2(point.y, point.x);
    point = {
      x: radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["cos"](angle),
      y: radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["sin"](angle)
    };
    this.positionItem(bullet, point);
    this.toggleVisibility(bullet, position, 0, 1);
  };
  /**
   * Updates and positions a label element.
   *
   * @ignore Exclude from docs
   * @param label        Label element
   * @param position     Starting position
   * @param endPosition  Ending position
   */


  AxisRendererCircular.prototype.updateLabelElement = function (label, position, endPosition, location) {
    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_10__["hasValue"](location)) {
      location = label.location;
    }

    position = position + (endPosition - position) * location;
    label.fixPosition(this.positionToAngle(position), this.pixelRadius);
    label.zIndex = 2;
    this.toggleVisibility(label, position, this.minLabelPosition, this.maxLabelPosition);
  };
  /**
   * Checks if point is within bounds of a container.
   *
   * @ignore Exclude from docs
   * @param point Point coordinates
   * @return Fits?
   */


  AxisRendererCircular.prototype.fitsToBounds = function (point) {
    return true;
  };

  Object.defineProperty(AxisRendererCircular.prototype, "startAngle", {
    /**
     * @return Start angle
     */
    get: function get() {
      return this.getPropertyValue("startAngle");
    },

    /**
     * Start angle of the axis in degrees (0-360).
     *
     * @param value  Start angle
     */
    set: function set(value) {
      // do not normalize angel here!
      if (this.setPropertyValue("startAngle", value)) {
        this.invalidateAxisItems();

        if (this.axis) {
          this.axis.invalidateSeries();
        }
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisRendererCircular.prototype, "endAngle", {
    /**
     * @return End angle
     */
    get: function get() {
      return this.getPropertyValue("endAngle");
    },

    /**
     * End angle of the axis in degrees (0-360).
     *
     * @param value  End angle
     */
    set: function set(value) {
      // do not normalize angel here!
      if (this.setPropertyValue("endAngle", value)) {
        this.invalidateAxisItems();

        if (this.axis) {
          this.axis.invalidateSeries();
        }
      }
    },
    enumerable: true,
    configurable: true
  });
  /**
   * [getPositionRangePath description]
   *
   * @ignore Exclude from docs
   * @todo Description
   * @param startPosition  Starting position
   * @param endPosition    End position
   * @return SVG path
   */

  AxisRendererCircular.prototype.getPositionRangePath = function (startPosition, endPosition, radius, innerRadius, cornerRadius) {
    var path = "";

    if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_10__["isNumber"](startPosition) && _core_utils_Type__WEBPACK_IMPORTED_MODULE_10__["isNumber"](endPosition)) {
      if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_10__["hasValue"](radius)) {
        radius = this.radius;
      }

      startPosition = _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["max"](startPosition, this.axis.start);
      endPosition = _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["min"](endPosition, this.axis.end);

      if (endPosition < startPosition) {
        endPosition = startPosition;
      }

      var pixelRadius = _core_utils_Utils__WEBPACK_IMPORTED_MODULE_9__["relativeRadiusToValue"](radius, this.pixelRadius);
      var pixelInnerRadius = _core_utils_Utils__WEBPACK_IMPORTED_MODULE_9__["relativeRadiusToValue"](innerRadius, this.pixelRadius, true);
      var startAngle = this.positionToAngle(startPosition);
      var endAngle = this.positionToAngle(endPosition);
      var arc = endAngle - startAngle;
      path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_8__["arc"](startAngle, arc, pixelRadius, pixelInnerRadius, pixelRadius, cornerRadius);
    }

    return path;
  };
  /**
   * Returns a new grid element, suitable for this Axis Renderer type.
   *
   * @return Grid element
   */


  AxisRendererCircular.prototype.createGrid = function () {
    return new _GridCircular__WEBPACK_IMPORTED_MODULE_3__["GridCircular"]();
  };
  /**
   * Returns a new fill element, suitable for this Axis Renderer type.
   *
   * @return Fill element
   */


  AxisRendererCircular.prototype.createFill = function (axis) {
    return new _AxisFillCircular__WEBPACK_IMPORTED_MODULE_2__["AxisFillCircular"](axis);
  };
  /**
   * Returns a new label element, suitable for this Axis Renderer type.
   *
   * @return Label element
   */


  AxisRendererCircular.prototype.createLabel = function () {
    return new _AxisLabelCircular__WEBPACK_IMPORTED_MODULE_4__["AxisLabelCircular"]();
  };
  /**
   * Converts a point at specific coordinates to a relative position (0-1)
   * on the axis.
   *
   * @param point  Point
   * @return Position (0-1)
   */


  AxisRendererCircular.prototype.pointToPosition = function (point) {
    var angle = _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["fitAngleToRange"](_core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["getAngle"](point), this.startAngle, this.endAngle);
    return this.coordinateToPosition((angle - this.startAngle) / 360 * this.axisLength);
  };

  return AxisRendererCircular;
}(_AxisRenderer__WEBPACK_IMPORTED_MODULE_1__["AxisRenderer"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_5__["registry"].registeredClasses["AxisRendererCircular"] = AxisRendererCircular;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisRendererRadial.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisRendererRadial.js ***!
  \**************************************************************************************/
/*! exports provided: AxisRendererRadial */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AxisRendererRadial", function() { return AxisRendererRadial; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _AxisRendererY__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AxisRendererY */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisRendererY.js");
/* harmony import */ var _CategoryAxis__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./CategoryAxis */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/CategoryAxis.js");
/* harmony import */ var _core_elements_WavedCircle__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/elements/WavedCircle */ "./node_modules/@amcharts/amcharts4/.internal/core/elements/WavedCircle.js");
/* harmony import */ var _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/utils/Disposer */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Disposer.js");
/* harmony import */ var _core_utils_Percent__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core/utils/Percent */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Percent.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../core/utils/Math */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Math.js");
/* harmony import */ var _core_rendering_Path__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../core/rendering/Path */ "./node_modules/@amcharts/amcharts4/.internal/core/rendering/Path.js");
/* harmony import */ var _core_utils_Utils__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../core/utils/Utils */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Utils.js");
/* harmony import */ var _core_utils_Type__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../core/utils/Type */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Type.js");
/* harmony import */ var _AxisBullet__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./AxisBullet */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisBullet.js");
/**
 * Module, defining Axis Renderer for radial axes.
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */












/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * A renderer for radial axis.
 */

var AxisRendererRadial =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(AxisRendererRadial, _super);
  /**
   * Constructor.
   *
   * @param axis Related axis
   */


  function AxisRendererRadial() {
    var _this = // Init
    _super.call(this) || this;
    /**
     * A related chart.
     */


    _this._chart = new _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_4__["MutableValueDisposer"]();
    /**
     * @ignore
     */

    _this.pixelRadiusReal = 0;
    _this.className = "AxisRendererRadial";
    _this.isMeasured = false;
    _this.startAngle = -90;
    _this.endAngle = 270;
    _this.minGridDistance = 30;
    _this.gridType = "circles";
    _this.axisAngle = -90;
    _this.isMeasured = false;
    _this.layout = "none";
    _this.radius = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_5__["percent"])(100);
    _this.line.strokeOpacity = 0;
    _this.labels.template.horizontalCenter = "middle";

    _this._disposers.push(_this._chart);

    _this.applyTheme();

    return _this;
  }
  /**
   * Validates Axis renderer.
   *
   * @ignore Exclude from docs
   */


  AxisRendererRadial.prototype.validate = function () {
    // so that radius would be updated
    if (this.chart && this.chart.invalid) {
      this.chart.validate();
    }

    _super.prototype.validate.call(this);
  };

  Object.defineProperty(AxisRendererRadial.prototype, "axisLength", {
    /**
     * Returns actual length of the Axis, in pixels.
     *
     * @return Length (px)
     */
    get: function get() {
      return this.pixelRadius - this.pixelInnerRadius;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisRendererRadial.prototype, "radius", {
    /**
     * @return Outer radius
     */
    get: function get() {
      return this.getPropertyValue("radius");
    },

    /**
     * Outer radius of the axis.
     *
     * Can be absolute (px) or relative ([[Percent]]).
     *
     * @param value  Outer radius
     */
    set: function set(value) {
      this.setPercentProperty("radius", value, false, false, 10, false);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisRendererRadial.prototype, "pixelRadius", {
    /**
     * Outer radius in pixels.
     *
     * @return Outer radius (px)
     */
    get: function get() {
      return _core_utils_Utils__WEBPACK_IMPORTED_MODULE_9__["relativeRadiusToValue"](this.radius, this.pixelRadiusReal) || 0;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisRendererRadial.prototype, "innerRadius", {
    /**
     * @return Inner radius
     */
    get: function get() {
      var chart = this.chart;
      var innerRadius = this.getPropertyValue("innerRadius");

      if (chart) {
        if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_10__["hasValue"](innerRadius)) {
          innerRadius = chart.innerRadius;

          if (innerRadius instanceof _core_utils_Percent__WEBPACK_IMPORTED_MODULE_5__["Percent"] && chart) {
            innerRadius = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_5__["percent"])(innerRadius.value * chart.innerRadiusModifyer * 100);
          }
        } else {
          if (innerRadius instanceof _core_utils_Percent__WEBPACK_IMPORTED_MODULE_5__["Percent"] && chart) {
            var mr = chart.mr;
            var value = innerRadius.value;
            value = Math.max(mr * value, mr - Math.min(chart.plotContainer.innerHeight, chart.plotContainer.innerWidth)) / mr;
            innerRadius = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_5__["percent"])(value * 100);
          }
        }
      }

      return innerRadius;
    },

    /**
     * Inner radius of the axis.
     *
     * Can be absolute (px) or relative ([[Percent]]).
     *
     * @param value  Outer radius
     */
    set: function set(value) {
      this.setPercentProperty("innerRadius", value, false, false, 10, false);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisRendererRadial.prototype, "pixelInnerRadius", {
    /**
     * Inner radius in pixels.
     *
     * @return Inner radius (px)
     */
    get: function get() {
      return _core_utils_Utils__WEBPACK_IMPORTED_MODULE_9__["relativeRadiusToValue"](this.innerRadius, this.pixelRadiusReal) || 0;
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Converts relative position on axis to point coordinates.
   *
   * @param position  Position (0-1)
   * @param position2  Position (0-1) Position on the second axis
   * @return Point
   */

  AxisRendererRadial.prototype.positionToPoint = function (position, position2) {
    var radius = _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["fitToRange"](this.positionToCoordinate(position), 0, Infinity);
    return {
      x: radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["cos"](this.axisAngle),
      y: radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["sin"](this.axisAngle)
    };
  };
  /**
   * Updates and positions the axis line element.
   *
   * @ignore Exclude from docs
   */


  AxisRendererRadial.prototype.updateAxisLine = function () {
    this.line.path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_8__["moveTo"]({
      x: this.pixelInnerRadius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["cos"](this.axisAngle),
      y: this.pixelInnerRadius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["sin"](this.axisAngle)
    }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_8__["lineTo"]({
      x: this.pixelRadius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["cos"](this.axisAngle),
      y: this.pixelRadius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["sin"](this.axisAngle)
    });
    var title = this.axis.title;
    title.valign = "none";
    title.horizontalCenter = "middle";
    title.verticalCenter = "bottom";
    title.y = -this.axisLength / 2;
    var rotation = 90;

    if (this.opposite) {
      if (!this.inside) {
        rotation = -90;
      }
    } else {
      if (this.inside) {
        rotation = -90;
      }
    }

    title.rotation = rotation;
  };
  /**
   * Updates and positions a grid element.
   *
   * @ignore Exclude from docs
   * @param grid         Grid element
   * @param position     Starting position
   * @param endPosition  End position
   */


  AxisRendererRadial.prototype.updateGridElement = function (grid, position, endPosition) {
    position = position + (endPosition - position) * grid.location;
    var point = this.positionToPoint(position);
    var path;
    var radius = _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["getDistance"](point);
    var startAngle = this.startAngle;
    var endAngle = this.endAngle;
    var chart = this.chart;

    if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_10__["isNumber"](radius) && grid.element && chart) {
      var xAxis = chart.xAxes.getIndex(0);
      var count = 0;
      var series = chart.series.getIndex(0);

      if (series) {
        count = series.dataItems.length;
      } // polygons are only possible if x axis is present
      // @todo: review this


      if (this.gridType == "polygons" && count > 0 && series && xAxis && xAxis instanceof _CategoryAxis__WEBPACK_IMPORTED_MODULE_2__["CategoryAxis"]) {
        var gridLocation = xAxis.renderer.grid.template.location;
        var angle = xAxis.getAngle(series.dataItems.getIndex(0), "categoryX", gridLocation);
        path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_8__["moveTo"]({
          x: radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["cos"](angle),
          y: radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["sin"](angle)
        });

        for (var i = 1; i < count; i++) {
          angle = xAxis.getAngle(series.dataItems.getIndex(i), "categoryX", gridLocation);
          path += _core_rendering_Path__WEBPACK_IMPORTED_MODULE_8__["lineTo"]({
            x: radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["cos"](angle),
            y: radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["sin"](angle)
          });
        }

        angle = xAxis.getAngle(series.dataItems.getIndex(count - 1), "categoryX", xAxis.renderer.cellEndLocation);
        path += _core_rendering_Path__WEBPACK_IMPORTED_MODULE_8__["lineTo"]({
          x: radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["cos"](angle),
          y: radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["sin"](angle)
        });
      } else {
        path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_8__["moveTo"]({
          x: radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["cos"](startAngle),
          y: radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["sin"](startAngle)
        }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_8__["arcTo"](startAngle, endAngle - startAngle, radius, radius);
      }

      grid.path = path;
    }

    this.toggleVisibility(grid, position, 0, 1);
  };
  /**
   * Updates and positions a label element.
   *
   * @ignore Exclude from docs
   * @param label        Label element
   * @param position     Starting position
   * @param endPosition  Ending position
   */


  AxisRendererRadial.prototype.updateLabelElement = function (label, position, endPosition, location) {
    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_10__["hasValue"](location)) {
      location = label.location;
    }

    position = position + (endPosition - position) * location;
    var point = this.positionToPoint(position);
    this.positionItem(label, point);
    this.toggleVisibility(label, position, this.minLabelPosition, this.maxLabelPosition);
  };
  /**
   * Updates and positions the base grid element.
   *
   * @ignore Exclude from docs
   */


  AxisRendererRadial.prototype.updateBaseGridElement = function () {// @todo? zero grid for radar chart, is it needed?
  };
  /**
   * Checks if point is within bounds of a container.
   *
   * @ignore Exclude from docs
   * @param point Point coordinates
   * @return Fits?
   */


  AxisRendererRadial.prototype.fitsToBounds = function (point) {
    return true;
  };

  Object.defineProperty(AxisRendererRadial.prototype, "startAngle", {
    /**
     * @return Start angle
     */
    get: function get() {
      return this.getPropertyValue("startAngle");
    },

    /**
     * Start angle of the axis in degrees. (0-360)
     *
     * @param value  Start angle
     */
    set: function set(value) {
      // do not normalize angle here!
      if (this.setPropertyValue("startAngle", value)) {
        this.invalidateAxisItems();
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisRendererRadial.prototype, "endAngle", {
    /**
     * @return End angle
     */
    get: function get() {
      return this.getPropertyValue("endAngle");
    },

    /**
     * End angle of the axis in degrees. (0-360)
     *
     * @param value  End angle
     */
    set: function set(value) {
      // do not normalize angel here!
      if (this.setPropertyValue("endAngle", value)) {
        this.invalidateAxisItems();
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisRendererRadial.prototype, "axisAngle", {
    /**
     * @return Axis angle
     */
    get: function get() {
      return this.getPropertyValue("axisAngle"); //return $math.fitToRange(this.getPropertyValue("axisAngle"), this.startAngle, this.endAngle); // no good, as less flexible
    },

    /**
     * Angle of the radial axis in degrees. (0-360)
     *
     * @param value  Axis angle
     */
    set: function set(value) {
      this.setPropertyValue("axisAngle", _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["normalizeAngle"](value));
      this.invalidateAxisItems();
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisRendererRadial.prototype, "gridType", {
    /**
     * Grid type
     */
    get: function get() {
      var axis = this.chart.xAxes.getIndex(0);

      if (axis instanceof _CategoryAxis__WEBPACK_IMPORTED_MODULE_2__["CategoryAxis"]) {
        return this.getPropertyValue("gridType");
      } else {
        return "circles";
      }
    },
    // polygons grid type is only possible under these conditions: xAxis is available and it is CategoryAxis, also at least one series should be added to a chart

    /**
     * Grid type for radial axis.
     *
     * A grid on radia axis can either be perfect circles ("circles"), or
     * straight lines ("polygons").
     *
     * @default "circles"
     * @param value  Grid type
     */
    set: function set(value) {
      this.setPropertyValue("gridType", value, true);
    },
    enumerable: true,
    configurable: true
  });
  /**
   * [getPositionRangePath description]
   *
   * @ignore Exclude from docs
   * @todo Description
   * @param startPosition  Starting position
   * @param endPosition    End position
   * @return SVG path
   */

  AxisRendererRadial.prototype.getPositionRangePath = function (startPosition, endPosition) {
    var pixelInnerRadius = this.pixelInnerRadius;
    var pixelRadius = this.axisLength + pixelInnerRadius;
    var innerRadius = _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["fitToRange"](this.positionToCoordinate(startPosition), pixelInnerRadius, pixelRadius);
    var radius = _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["fitToRange"](this.positionToCoordinate(endPosition), pixelInnerRadius, pixelRadius); //let angleCount: number = this.angleCount;

    var startAngle = this.startAngle;
    var endAngle = this.endAngle;
    var arc = endAngle - startAngle;
    var path;
    var chart = this.chart;
    var xAxis = chart.xAxes.getIndex(0);
    var series = chart.series.getIndex(0);
    var count = 0;

    if (series) {
      count = series.dataItems.length;
    } // polygons are only possible if x axis is present
    // @todo: review this


    if (this.gridType == "polygons" && count > 0 && series && xAxis && xAxis instanceof _CategoryAxis__WEBPACK_IMPORTED_MODULE_2__["CategoryAxis"]) {
      var gridLocation = xAxis.renderer.grid.template.location;
      var angle = xAxis.getAngle(series.dataItems.getIndex(0), "categoryX", gridLocation);
      path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_8__["moveTo"]({
        x: radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["cos"](angle),
        y: radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["sin"](angle)
      });

      for (var i = 1; i < count; i++) {
        angle = xAxis.getAngle(series.dataItems.getIndex(i), "categoryX", gridLocation);
        path += _core_rendering_Path__WEBPACK_IMPORTED_MODULE_8__["lineTo"]({
          x: radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["cos"](angle),
          y: radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["sin"](angle)
        });
      }

      angle = xAxis.getAngle(series.dataItems.getIndex(count - 1), "categoryX", xAxis.renderer.cellEndLocation);
      path += _core_rendering_Path__WEBPACK_IMPORTED_MODULE_8__["lineTo"]({
        x: radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["cos"](angle),
        y: radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["sin"](angle)
      });
      path += _core_rendering_Path__WEBPACK_IMPORTED_MODULE_8__["moveTo"]({
        x: innerRadius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["cos"](angle),
        y: innerRadius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["sin"](angle)
      });

      for (var i = count - 1; i >= 0; i--) {
        angle = xAxis.getAngle(series.dataItems.getIndex(i), "categoryX", gridLocation);
        path += _core_rendering_Path__WEBPACK_IMPORTED_MODULE_8__["lineTo"]({
          x: innerRadius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["cos"](angle),
          y: innerRadius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["sin"](angle)
        });
      }
    } else {
      path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_8__["arc"](startAngle, arc, radius, innerRadius);
    }

    return path;
  };
  /**
   * Updates and positions an axis break element.
   *
   * @ignore Exclude from docs
   * @param axisBreak Break element
   */


  AxisRendererRadial.prototype.updateBreakElement = function (axisBreak) {
    // @todo: someday we might need axis break when gridType is polygons
    var startLine = axisBreak.startLine;
    var endLine = axisBreak.endLine;
    var fillShape = axisBreak.fillShape;
    var startPoint = axisBreak.startPoint;
    var endPoint = axisBreak.endPoint;
    startLine.radius = Math.abs(startPoint.y);
    endLine.radius = Math.abs(endPoint.y);
    fillShape.radius = Math.abs(endPoint.y);
    fillShape.innerRadius = Math.abs(startPoint.y);
  };
  /**
   * Creates visual elements for and axis break.
   *
   * @ignore Exclude from docs
   * @param axisBreak Axis break
   */


  AxisRendererRadial.prototype.createBreakSprites = function (axisBreak) {
    axisBreak.startLine = new _core_elements_WavedCircle__WEBPACK_IMPORTED_MODULE_3__["WavedCircle"]();
    axisBreak.endLine = new _core_elements_WavedCircle__WEBPACK_IMPORTED_MODULE_3__["WavedCircle"]();
    axisBreak.fillShape = new _core_elements_WavedCircle__WEBPACK_IMPORTED_MODULE_3__["WavedCircle"]();
  };
  /**
   * Updates some of the Axis tooltip's visual properties, related to
   * rendering of the Axis.
   *
   * @todo Description (review)
   * @ignore Exclude from docs
   */


  AxisRendererRadial.prototype.updateTooltip = function () {
    var axis = this.axis;

    if (axis) {
      var bigNum = 4000;
      var bbx = -4000;
      var bby = -4000;
      var bbw = bigNum * 2;
      var bbh = bigNum * 2;
      var axisAngle = this.axisAngle;

      if (axisAngle < 0) {
        axisAngle += 360;
      }

      var tooltipOrientation = "vertical";

      if (axisAngle > 45 && axisAngle < 135 || axisAngle > 225 && axisAngle < 315) {
        tooltipOrientation = "horizontal";
      }

      this.axis.updateTooltip(tooltipOrientation, {
        x: bbx,
        y: bby,
        width: bbw,
        height: bbh
      });
    }
  };
  /**
   * Updates and positions a tick element.
   *
   * @ignore Exclude from docs
   * @param tick      Tick element
   * @param position  Position
   */


  AxisRendererRadial.prototype.updateTickElement = function (tick, position, endPosition) {
    position = position + (endPosition - position) * tick.location;
    var point = this.positionToPoint(position);

    if (tick.element) {
      var angle = _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["normalizeAngle"](this.axisAngle + 90);

      if (angle / 90 != Math.round(angle / 90)) {
        tick.pixelPerfect = false;
      } else {
        tick.pixelPerfect = true;
      }

      var tickLength = -tick.length;

      if (tick.inside) {
        tickLength *= -1;
      }

      tick.path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_8__["moveTo"]({
        x: 0,
        y: 0
      }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_8__["lineTo"]({
        x: tickLength * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["cos"](angle),
        y: tickLength * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["sin"](angle)
      });
    }

    this.positionItem(tick, point);
    this.toggleVisibility(tick, position, 0, 1);
  };
  /**
   * Updates and positions axis bullet.
   *
   * @ignore Exclude from docs
   * @param bullet       AxisBullet element
   * @param position     Starting position
   * @param endPosition  End position
   */


  AxisRendererRadial.prototype.updateBullet = function (bullet, position, endPosition) {
    var location = 0.5;

    if (bullet instanceof _AxisBullet__WEBPACK_IMPORTED_MODULE_11__["AxisBullet"]) {
      location = bullet.location;
    }

    position = position + (endPosition - position) * location;
    var point = this.positionToPoint(position);
    this.positionItem(bullet, point);
    this.toggleVisibility(bullet, position, 0, 1);
  };
  /**
   * Converts a position on the axis to a coordinate in pixels.
   *
   * @ignore Exclude from docs
   * @param position  Position (0-1)
   * @return Coordinate (px)
   */


  AxisRendererRadial.prototype.positionToCoordinate = function (position) {
    var coordinate;
    var axis = this.axis;
    var axisFullLength = axis.axisFullLength;
    var innerRadius = this.pixelInnerRadius;

    if (axis.renderer.inversed) {
      coordinate = (axis.end - position) * axisFullLength + innerRadius;
    } else {
      coordinate = (position - axis.start) * axisFullLength + innerRadius;
    }

    return _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["round"](coordinate, 1);
  };
  /**
   * Converts a point at specific coordinates to a relative position (0-1)
   * on the axis.
   *
   * @param point  Point
   * @return Position (0-1)
   */


  AxisRendererRadial.prototype.pointToPosition = function (point) {
    var coordinate = _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["getDistance"](point) - this.pixelInnerRadius;
    return this.coordinateToPosition(coordinate);
  };

  Object.defineProperty(AxisRendererRadial.prototype, "chart", {
    /**
     * @ignore Exclude from docs
     * @return Chart
     */
    get: function get() {
      return this._chart.get();
    },

    /**
     * A chart, associated with the Axis.
     *
     * @ignore Exclude from docs
     * @param value  Chart
     */
    set: function set(value) {
      this._chart.set(value, null);
    },
    enumerable: true,
    configurable: true
  });
  return AxisRendererRadial;
}(_AxisRendererY__WEBPACK_IMPORTED_MODULE_1__["AxisRendererY"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_6__["registry"].registeredClasses["AxisRendererRadial"] = AxisRendererRadial;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisRendererX.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisRendererX.js ***!
  \*********************************************************************************/
/*! exports provided: AxisRendererX */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AxisRendererX", function() { return AxisRendererX; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _AxisRenderer__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AxisRenderer */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisRenderer.js");
/* harmony import */ var _AxisBullet__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./AxisBullet */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisBullet.js");
/* harmony import */ var _core_elements_WavedLine__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/elements/WavedLine */ "./node_modules/@amcharts/amcharts4/.internal/core/elements/WavedLine.js");
/* harmony import */ var _core_elements_WavedRectangle__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/elements/WavedRectangle */ "./node_modules/@amcharts/amcharts4/.internal/core/elements/WavedRectangle.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_utils_Percent__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core/utils/Percent */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Percent.js");
/* harmony import */ var _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../core/utils/Math */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Math.js");
/* harmony import */ var _core_rendering_Path__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../core/rendering/Path */ "./node_modules/@amcharts/amcharts4/.internal/core/rendering/Path.js");
/* harmony import */ var _core_utils_Utils__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../core/utils/Utils */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Utils.js");
/* harmony import */ var _core_utils_Type__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../core/utils/Type */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Type.js");
/* harmony import */ var _core_utils_Responsive__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../core/utils/Responsive */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Responsive.js");
/**
 * Module, defining Axis Renderer for vertical axes.
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */












/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * A renderer for horizontal axis.
 *
 * @see {@link IAxisRendererEvents} for a list of available events
 * @see {@link IAxisRendererAdapters} for a list of available Adapters
 */

var AxisRendererX =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(AxisRendererX, _super);
  /**
   * Constructor.
   *
   * @param axis Related axis
   */


  function AxisRendererX() {
    var _this = _super.call(this) || this;

    _this.className = "AxisRendererX";
    _this.minGridDistance = 120;
    _this.opposite = false;
    _this.rotation = 0;
    _this.width = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_6__["percent"])(100);
    _this.labels.template.horizontalCenter = "middle";

    _this.applyTheme();

    return _this;
  }
  /**
  * @ignore
  */


  AxisRendererX.prototype.setAxis = function (axis) {
    _super.prototype.setAxis.call(this, axis);

    axis.layout = "vertical";
  };
  /**
   * @ignore
   */


  AxisRendererX.prototype.updateGridContainer = function () {
    var axis = this.axis;

    if (axis) {
      var gridContainer = this.gridContainer;
      gridContainer.x = axis.pixelX;
      gridContainer.width = axis.axisLength;
    }
  };
  /**
   * Called when rendered is attached to an Axis, as well as a property of
   * Axis that might affect the appearance is updated.
   *
   * E.g. `axis.opposite`, `axis.inside`, etc.
   *
   * This method is called **before** draw, so that any related setting
   * changed in this method can be changed.
   *
   * @todo Description (review)
   * @ignore Exclude from docs
   */


  AxisRendererX.prototype.processRenderer = function () {
    _super.prototype.processRenderer.call(this); // can not do this in init, as axis is set later


    var axis = this.axis;

    if (axis) {
      if (!(axis.width instanceof _core_utils_Percent__WEBPACK_IMPORTED_MODULE_6__["Percent"])) {
        axis.width = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_6__["percent"])(100);
      } // @todo Is thi sneeded?


      _core_utils_Utils__WEBPACK_IMPORTED_MODULE_9__["used"](this.line);
      var title = axis.title;
      title.rotation = 0;
      title.align = "center";

      if (this.opposite) {
        this.line.toFront();
        title.toBack();
      } else {
        title.toFront();
        this.toBack();
        this.line.toBack();
      }
    }
  };
  /**
   * Updates some of the Axis tooltip's visual properties, related to
   * rendering of the Axis.
   *
   * @todo Description (review)
   * @ignore Exclude from docs
   */


  AxisRendererX.prototype.updateTooltip = function () {
    var axis = this.axis;

    if (axis) {
      var bigNum = 1000;
      var bbx = this.line.pixelX;
      var bby = this.line.pixelY;
      var bbw = this.axisLength;
      var bbh = bigNum; // top

      if (this.opposite) {
        if (!this.inside) {
          bby = -bigNum;
          bbh = bigNum;
        }
      } // bottom
      else {
          if (this.inside) {
            bby = -bigNum;
            bbh = bigNum;
          }
        }

      this.axis.updateTooltip("vertical", {
        x: bbx,
        y: bby,
        width: bbw,
        height: bbh
      });
    }
  };
  /**
   * Updates and positions a label element.
   *
   * @ignore Exclude from docs
   * @param label        Label element
   * @param position     Starting position
   * @param endPosition  Ending position
   */


  AxisRendererX.prototype.updateLabelElement = function (label, position, endPosition, location) {
    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_10__["hasValue"](location)) {
      location = label.location;
    }

    position = position + (endPosition - position) * location;
    var point = this.positionToPoint(position);
    label.isMeasured = !label.inside;
    var deltaY = 0;
    var verticalCenter;
    var maxHeight = this.gridContainer.maxHeight;

    if (this.opposite) {
      if (label.inside) {
        verticalCenter = "top";

        if (label.valign == "bottom") {
          deltaY = maxHeight;
          verticalCenter = "bottom";
        }

        if (label.valign == "middle") {
          deltaY = maxHeight / 2;
          verticalCenter = "middle";
        }
      } else {
        verticalCenter = "bottom";
      }

      point.y = deltaY;
    } else {
      if (label.inside) {
        verticalCenter = "bottom";

        if (label.valign == "top") {
          deltaY = -maxHeight;
          verticalCenter = "top";
        }

        if (label.valign == "middle") {
          deltaY = -maxHeight / 2;
          verticalCenter = "middle";
        }
      } else {
        verticalCenter = "top";
      }

      point.y += deltaY;
    }

    if (label.rotation == 0) {
      // Apply fuzzy logic to verticalCenter only if labels are not rotated
      label.verticalCenter = verticalCenter;
    }

    this.positionItem(label, point);
    this.toggleVisibility(label, position, this.minLabelPosition, this.maxLabelPosition);
  };

  Object.defineProperty(AxisRendererX.prototype, "axisLength", {
    /**
     * Returns actual length of the Axis, in pixels.
     *
     * @return Length (px)
     */
    get: function get() {
      var axis = this.axis;
      return axis.measuredWidth - axis.pixelPaddingRight - axis.pixelPaddingLeft || 0;
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Converts relative position on axis to point coordinates.
   *
   * @param position  Position (0-1)
   * @param position2  Position (0-1) Position on the second axis
   * @return Point
   */

  AxisRendererX.prototype.positionToPoint = function (position, position2) {
    return {
      x: this.positionToCoordinate(position),
      y: 0
    };
  };
  /**
   * Converts a point at specific coordinates to a relative position (0-1)
   * on the axis.
   *
   * @param point  Point
   * @return Position (0-1)
   */


  AxisRendererX.prototype.pointToPosition = function (point) {
    return this.coordinateToPosition(point.x, point.y);
  };
  /**
   * [getPositionRangePath description]
   *
   * @ignore Exclude from docs
   * @todo Description
   * @param startPosition  Starting position
   * @param endPosition    End position
   * @return SVG path
   */


  AxisRendererX.prototype.getPositionRangePath = function (startPosition, endPosition) {
    var x1 = _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["fitToRange"](this.positionToCoordinate(startPosition), 0, this.axisLength);
    var x2 = _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["fitToRange"](this.positionToCoordinate(endPosition), 0, this.axisLength);
    var w = Math.abs(x2 - x1);
    var h = this.getHeight();
    var x = Math.min(x1, x2);
    var y = 0;
    return _core_rendering_Path__WEBPACK_IMPORTED_MODULE_8__["rectToPath"]({
      x: x,
      y: y,
      width: w,
      height: h
    }, true);
  };
  /**
   * Updates and positions an axis break element.
   *
   * @ignore Exclude from docs
   * @param axisBreak Break element
   */


  AxisRendererX.prototype.updateBreakElement = function (axisBreak) {
    _super.prototype.updateBreakElement.call(this, axisBreak);

    var startLine = axisBreak.startLine;
    var endLine = axisBreak.endLine;
    var fillShape = axisBreak.fillShape;
    var startPoint = axisBreak.startPoint;
    var endPoint = axisBreak.endPoint;
    var y1 = axisBreak.pixelMarginLeft;
    var y2 = this.getHeight() - axisBreak.pixelMarginTop - axisBreak.pixelMarginBottom;
    startPoint.x = _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["fitToRange"](startPoint.x, -1, this.axisLength + 1);
    endPoint.x = _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["fitToRange"](endPoint.x, -1, this.axisLength + 1);

    if (startPoint.x == endPoint.x && (startPoint.x < 0 || startPoint.x > this.axisLength)) {
      axisBreak.fillShape.__disabled = true;
    } else {
      axisBreak.fillShape.__disabled = false;
    }

    startLine.y = y1;
    startLine.width = 0;
    startLine.height = y2;
    endLine.y = y1;
    endLine.width = 0;
    endLine.height = y2;
    fillShape.height = y2;
    fillShape.width = Math.abs(endPoint.x - startPoint.x);
    fillShape.y = y1;
    fillShape.x = startPoint.x;
  };
  /**
   * Updates and positions a grid element.
   *
   * @ignore Exclude from docs
   * @param grid         Grid element
   * @param position     Starting position
   * @param endPosition  End position
   */


  AxisRendererX.prototype.updateGridElement = function (grid, position, endPosition) {
    position = position + (endPosition - position) * grid.location;
    var point = this.positionToPoint(position); //point.x = $utils.spritePointToSprite({x:point.x, y:0}, this, this.gridContainer).x;

    grid.path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_8__["moveTo"]({
      x: 0,
      y: 0
    }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_8__["lineTo"]({
      x: 0,
      y: this.getHeight()
    });
    this.positionItem(grid, point);
    this.toggleVisibility(grid, position, 0, 1);
  };
  /**
   * Updates and positions a tick element.
   *
   * @ignore Exclude from docs
   * @param tick         Tick element
   * @param position     Starting position
   * @param endPosition  End position
   */


  AxisRendererX.prototype.updateTickElement = function (tick, position, endPosition) {
    position = position + (endPosition - position) * tick.location;
    var point = this.positionToPoint(position);
    var tickLength = tick.length;
    point.y = _core_utils_Utils__WEBPACK_IMPORTED_MODULE_9__["spritePointToSprite"]({
      x: 0,
      y: this.line.pixelY
    }, this.line.parent, this.gridContainer).y;

    if (this.opposite) {
      tickLength *= tick.inside ? 1 : -1;
    } else {
      tickLength *= tick.inside ? -1 : 1;
    }

    tick.path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_8__["moveTo"]({
      x: 0,
      y: 0
    }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_8__["lineTo"]({
      x: 0,
      y: tickLength
    });
    this.positionItem(tick, point);
    this.toggleVisibility(tick, position, 0, 1);
  };
  /**
   * Updates and positions the axis line element.
   *
   * @ignore Exclude from docs
   */


  AxisRendererX.prototype.updateAxisLine = function () {
    this.line.path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_8__["moveTo"]({
      x: 0,
      y: 0
    }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_8__["lineTo"]({
      x: this.axisLength,
      y: 0
    });
  };
  /**
   * Updates and positions the base grid element.
   *
   * @ignore Exclude from docs
   */


  AxisRendererX.prototype.updateBaseGridElement = function () {
    _super.prototype.updateBaseGridElement.call(this);

    var axis = this.axis;
    var h = this.getHeight();
    var w = this.axisLength;
    var baseGrid = this.baseGrid;
    var x = axis.basePoint.x;

    if (x < -0.2 || x > w + 0.2) {
      baseGrid.hide(0);
    } else {
      var y = _core_utils_Utils__WEBPACK_IMPORTED_MODULE_9__["spritePointToSprite"]({
        x: 0,
        y: 0
      }, this.gridContainer, baseGrid.parent).y;
      baseGrid.path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_8__["moveTo"]({
        x: 0,
        y: 0
      }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_8__["lineTo"]({
        x: 0,
        y: h
      });
      baseGrid.moveTo({
        x: x,
        y: y
      });
      baseGrid.show(0);
    }
  };
  /**
   * Creates visual elements for and axis break.
   *
   * @ignore Exclude from docs
   * @param axisBreak Axis break
   */


  AxisRendererX.prototype.createBreakSprites = function (axisBreak) {
    axisBreak.startLine = new _core_elements_WavedLine__WEBPACK_IMPORTED_MODULE_3__["WavedLine"]();
    axisBreak.endLine = new _core_elements_WavedLine__WEBPACK_IMPORTED_MODULE_3__["WavedLine"]();
    var wavedRectangle = new _core_elements_WavedRectangle__WEBPACK_IMPORTED_MODULE_4__["WavedRectangle"]();
    wavedRectangle.setWavedSides(false, true, false, true);
    axisBreak.fillShape = wavedRectangle;
  };
  /**
   * @ignore
   */


  AxisRendererX.prototype.toAxisPosition = function (value) {
    var inversedPosition = value;
    var axis = this.axis;

    if (axis) {
      var relativePositionSprite = axis.relativePositionSprite;
      var x = axis.pixelX;

      if (relativePositionSprite) {
        x = _core_utils_Utils__WEBPACK_IMPORTED_MODULE_9__["spritePointToSprite"]({
          x: this.pixelX,
          y: 0
        }, this.parent, relativePositionSprite).x;
      } else {
        relativePositionSprite = axis.parent;
      }

      if (relativePositionSprite) {
        var relativeX = x / relativePositionSprite.innerWidth;
        var relativeWidth = axis.axisLength / relativePositionSprite.innerWidth;
        return (inversedPosition - relativeX) / relativeWidth;
      }
    }

    return value;
  };
  /**
   * Updates and positions axis bullets.
   *
   * @ignore Exclude from docs
   * @param bullet       AxisBullet element
   * @param position     Starting position
   * @param endPosition  End position
   */


  AxisRendererX.prototype.updateBullet = function (bullet, position, endPosition) {
    var location = 0.5;

    if (bullet instanceof _AxisBullet__WEBPACK_IMPORTED_MODULE_2__["AxisBullet"]) {
      location = bullet.location;
    }

    position = position + (endPosition - position) * location;
    var point = this.positionToPoint(position);
    point.y = _core_utils_Utils__WEBPACK_IMPORTED_MODULE_9__["spritePointToSprite"]({
      x: 0,
      y: this.line.pixelY
    }, this.line.parent, this.gridContainer).y;
    this.positionItem(bullet, point);
    this.toggleVisibility(bullet, position, 0, 1);
  };

  return AxisRendererX;
}(_AxisRenderer__WEBPACK_IMPORTED_MODULE_1__["AxisRenderer"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_5__["registry"].registeredClasses["AxisRendererX"] = AxisRendererX;
/**
 * Add default responsive rules
 */

/**
 * Put labels inside plot area.
 * Disable first and last labels.
 */

_core_utils_Responsive__WEBPACK_IMPORTED_MODULE_11__["defaultRules"].push({
  relevant: _core_utils_Responsive__WEBPACK_IMPORTED_MODULE_11__["ResponsiveBreakpoints"].heightXS,
  state: function state(target, stateId) {
    if (target instanceof AxisRendererX) {
      var state = target.states.create(stateId);
      state.properties.inside = true;
      state.properties.maxLabelPosition = 0.9;
      state.properties.minLabelPosition = 0.1;
      return state;
    }

    return null;
  }
});
/**
 * Disable labels altogather on very small charts
 */

_core_utils_Responsive__WEBPACK_IMPORTED_MODULE_11__["defaultRules"].push({
  relevant: _core_utils_Responsive__WEBPACK_IMPORTED_MODULE_11__["ResponsiveBreakpoints"].heightXXS,
  state: function state(target, stateId) {
    if (target instanceof AxisRendererX) {
      var state = target.states.create(stateId);
      state.properties.disabled = true;
      return state;
    }

    return null;
  }
});

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisRendererX3D.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisRendererX3D.js ***!
  \***********************************************************************************/
/*! exports provided: AxisRendererX3D */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AxisRendererX3D", function() { return AxisRendererX3D; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _axes_AxisRendererX__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../axes/AxisRendererX */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisRendererX.js");
/* harmony import */ var _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/utils/Disposer */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Disposer.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/rendering/Path */ "./node_modules/@amcharts/amcharts4/.internal/core/rendering/Path.js");
/**
 * Module, defining Axis Renderer for horizontal 3D axes.
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */





/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Renderer for horizontal 3D axis.
 *
 * @see {@link IAxisRendererX3DEvents} for a list of available events
 * @see {@link IAxisRendererX3DAdapters} for a list of available Adapters
 */

var AxisRendererX3D =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(AxisRendererX3D, _super);
  /**
   * Constructor.
   *
   * @param axis Related axis
   */


  function AxisRendererX3D() {
    var _this = _super.call(this) || this;
    /**
     * A related chart.
     *
     * @todo Description
     */


    _this._chart = new _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_2__["MutableValueDisposer"]();
    _this.className = "AxisRendererX3D";

    _this._disposers.push(_this._chart);

    _this.applyTheme();

    return _this;
  }
  /**
   * Updates and positions a grid element.
   *
   * @ignore Exclude from docs
   * @param grid         Grid element
   * @param position     Starting position
   * @param endPosition  End position
   */


  AxisRendererX3D.prototype.updateGridElement = function (grid, position, endPosition) {
    position = position + (endPosition - position) * grid.location;
    var point = this.positionToPoint(position);

    if (grid.element) {
      var dx = this.chart.dx3D || 0;
      var dy = this.chart.dy3D || 0;
      var h = this.getHeight();
      grid.path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["moveTo"]({
        x: dx,
        y: dy
      }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["lineTo"]({
        x: dx,
        y: h + dy
      }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["lineTo"]({
        x: 0,
        y: h
      });
    }

    this.positionItem(grid, point);
    this.toggleVisibility(grid, position, 0, 1);
  };
  /**
   * Updates and positions the base grid element.
   *
   * @ignore Exclude from docs
   */


  AxisRendererX3D.prototype.updateBaseGridElement = function () {
    _super.prototype.updateBaseGridElement.call(this);

    var h = this.getHeight();
    var dx = this.chart.dx3D || 0;
    var dy = this.chart.dy3D || 0;
    this.baseGrid.path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["moveTo"]({
      x: dx,
      y: dy
    }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["lineTo"]({
      x: 0,
      y: 0
    }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["lineTo"]({
      x: 0,
      y: h
    });
  };

  Object.defineProperty(AxisRendererX3D.prototype, "chart", {
    /**
     * @ignore Exclude from docs
     * @return Chart
     */
    get: function get() {
      return this._chart.get();
    },

    /**
     * Chart, associated with the Axis.
     *
     * @ignore Exclude from docs
     * @param value Chart
     */
    set: function set(chart) {
      if (chart) {
        this._chart.set(chart, chart.events.on("propertychanged", this.handle3DChanged, this, false));
      }
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Invoked when 3D-related settings change, like depth or angle.
   *
   * @param event Event
   */

  AxisRendererX3D.prototype.handle3DChanged = function (event) {
    if (event.property == "depth" || event.property == "angle") {
      this.invalidate();
    }
  };

  return AxisRendererX3D;
}(_axes_AxisRendererX__WEBPACK_IMPORTED_MODULE_1__["AxisRendererX"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_3__["registry"].registeredClasses["AxisRendererX3D"] = AxisRendererX3D;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisRendererY.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisRendererY.js ***!
  \*********************************************************************************/
/*! exports provided: AxisRendererY */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AxisRendererY", function() { return AxisRendererY; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _AxisRenderer__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AxisRenderer */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisRenderer.js");
/* harmony import */ var _core_elements_WavedLine__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/elements/WavedLine */ "./node_modules/@amcharts/amcharts4/.internal/core/elements/WavedLine.js");
/* harmony import */ var _core_elements_WavedRectangle__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/elements/WavedRectangle */ "./node_modules/@amcharts/amcharts4/.internal/core/elements/WavedRectangle.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_utils_Percent__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core/utils/Percent */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Percent.js");
/* harmony import */ var _core_utils_Math__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core/utils/Math */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Math.js");
/* harmony import */ var _core_rendering_Path__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../core/rendering/Path */ "./node_modules/@amcharts/amcharts4/.internal/core/rendering/Path.js");
/* harmony import */ var _core_utils_Utils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../core/utils/Utils */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Utils.js");
/* harmony import */ var _core_utils_Type__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../core/utils/Type */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Type.js");
/* harmony import */ var _core_utils_Responsive__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../core/utils/Responsive */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Responsive.js");
/* harmony import */ var _AxisBullet__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./AxisBullet */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisBullet.js");
/**
 * Module, defining Axis Renderer for vertical axes.
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */












/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * A renderer for vertical axis.
 *
 * @see {@link IAxisRendererYEvents} for a list of available events
 * @see {@link IAxisRendererYAdapters} for a list of available Adapters
 */

var AxisRendererY =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(AxisRendererY, _super);
  /**
   * Constructor.
   *
   * @param axis Related axis
   */


  function AxisRendererY() {
    var _this = _super.call(this) || this;

    _this.className = "AxisRendererY";
    _this.minGridDistance = 40;
    _this.opposite = false;
    _this.height = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_5__["percent"])(100);
    _this.labels.template.verticalCenter = "middle";

    _this.applyTheme();

    return _this;
  }
  /**
  * @ignore
  */


  AxisRendererY.prototype.setAxis = function (axis) {
    _super.prototype.setAxis.call(this, axis);

    axis.layout = "horizontal";
  };
  /**
   * @ignore
   */


  AxisRendererY.prototype.updateGridContainer = function () {
    var axis = this.axis;

    if (axis) {
      var gridContainer = this.gridContainer;
      gridContainer.y = axis.pixelY;
      gridContainer.height = axis.axisLength;
    }
  };
  /**
   * @ignore
   */


  AxisRendererY.prototype.toAxisPosition = function (value) {
    var axis = this.axis;

    if (axis) {
      var inversedPosition = 1 - value;
      var relativePositionSprite = axis.relativePositionSprite;
      var y = axis.pixelY;

      if (relativePositionSprite) {
        y = _core_utils_Utils__WEBPACK_IMPORTED_MODULE_8__["spritePointToSprite"]({
          x: 0,
          y: this.pixelY
        }, this.parent, relativePositionSprite).y;
      } else {
        relativePositionSprite = axis.parent;
      }

      if (relativePositionSprite) {
        var relativeY = y / relativePositionSprite.innerHeight;
        var relativeHeight = axis.axisLength / relativePositionSprite.innerHeight;
        return 1 - (inversedPosition - relativeY) / relativeHeight;
      }
    }

    return value;
  };
  /**
   * Called when rendered is attached to an Axis, as well as a property of
   * Axis that might affect the appearance is updated.
   *
   * E.g. `axis.opposite`, `axis.inside`, etc.
   *
   * This method is called **before** draw, so that any related setting
   * changed in this method can be changed.
   *
   * @todo Description (review)
   * @ignore Exclude from docs
   */


  AxisRendererY.prototype.processRenderer = function () {
    _super.prototype.processRenderer.call(this);

    var axis = this.axis;

    if (axis) {
      var title = axis.title;
      title.valign = "middle";

      if (!(axis.height instanceof _core_utils_Percent__WEBPACK_IMPORTED_MODULE_5__["Percent"])) {
        axis.height = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_5__["percent"])(100);
      }

      if (this.opposite) {
        title.rotation = 90;
        this.line.toBack();
        title.toFront();
      } else {
        title.rotation = -90;
        title.toBack();
        this.line.toFront();
      }
    }
  };
  /**
   * Updates some of the Axis tooltip's visual properties, related to
   * rendering of the Axis.
   *
   * @todo Description (review)
   * @ignore Exclude from docs
   */


  AxisRendererY.prototype.updateTooltip = function () {
    var axis = this.axis;

    if (axis) {
      var bigNum = 2000;
      var bbx = 0;
      var bby = 0;
      var bbw = bigNum;
      var bbh = this.axisLength; // right

      if (this.opposite) {
        if (this.inside) {
          bbx = -bigNum;
          bbw = bigNum;
        }
      } // left
      else {
          if (!this.inside) {
            bbx = -bigNum;
            bbw = bigNum;
          }
        }

      this.axis.updateTooltip("horizontal", {
        x: bbx,
        y: bby,
        width: bbw,
        height: bbh
      });
    }
  };

  Object.defineProperty(AxisRendererY.prototype, "axisLength", {
    /**
     * Returns actual length of the Axis, in pixels.
     *
     * @return Length (px)
     */
    get: function get() {
      var axis = this.axis;
      return axis.measuredHeight - axis.pixelPaddingTop - axis.pixelPaddingBottom || 0;
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Converts relative position on axis to point coordinates.
   *
   * @param position  Position (0-1)
   * @param position2  Position (0-1) Position on the second axis
   * @return Point
   */

  AxisRendererY.prototype.positionToPoint = function (position, position2) {
    return {
      x: 0,
      y: this.positionToCoordinate(position)
    };
  };
  /**
   * Converts a point at specific coordinates to a relative position (0-1)
   * on the axis.
   *
   * @param point  Point
   * @return Position (0-1)
   */


  AxisRendererY.prototype.pointToPosition = function (point) {
    return this.coordinateToPosition(point.y, point.x);
  };
  /**
   * Converts a coordinate in pixels to a relative position. (0-1)
   *
   * @param coordinate  Coordinate (px)
   * @param coordinate2  Coordinate of a second axis, only needed for complex axes systems, like timeline (px)
   * @return Position (0-1)
   */


  AxisRendererY.prototype.coordinateToPosition = function (coordinate, coordinate2) {
    var position;
    var axis = this.axis;
    var axisFullLength = axis.axisFullLength;

    if (axis.renderer.inversed) {
      position = 1 - axis.start - coordinate / axisFullLength;
    } else {
      position = coordinate / axisFullLength + (1 - axis.end);
    }

    return _core_utils_Math__WEBPACK_IMPORTED_MODULE_6__["round"](position, 5);
  };
  /**
   * [getPositionRangePath description]
   *
   * @ignore Exclude from docs
   * @todo Description
   * @param startPosition  Starting position
   * @param endPosition    End position
   * @return SVG path
   */


  AxisRendererY.prototype.getPositionRangePath = function (startPosition, endPosition) {
    var y1 = _core_utils_Math__WEBPACK_IMPORTED_MODULE_6__["fitToRange"](this.positionToCoordinate(startPosition), 0, this.axisLength);
    var y2 = _core_utils_Math__WEBPACK_IMPORTED_MODULE_6__["fitToRange"](this.positionToCoordinate(endPosition), 0, this.axisLength);
    var h = Math.abs(y2 - y1);
    var w = this.getWidth();
    var y = Math.min(y1, y2);
    var x = 0;
    return _core_rendering_Path__WEBPACK_IMPORTED_MODULE_7__["rectToPath"]({
      x: x,
      y: y,
      width: w,
      height: h
    }, true);
  };
  /**
   * Updates and positions a grid element.
   *
   * @ignore Exclude from docs
   * @param grid         Grid element
   * @param position     Starting position
   * @param endPosition  End position
   */


  AxisRendererY.prototype.updateGridElement = function (grid, position, endPosition) {
    position = position + (endPosition - position) * grid.location;
    var point = this.positionToPoint(position); //	point.y = $utils.spritePointToSprite({ x: 0, y: point.y }, this, this.gridContainer).y;

    grid.path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_7__["moveTo"]({
      x: 0,
      y: 0
    }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_7__["lineTo"]({
      x: this.getWidth(),
      y: 0
    });
    this.positionItem(grid, point);
    this.toggleVisibility(grid, position, 0, 1);
  };
  /**
   * Updates and positions a tick element.
   *
   * @ignore Exclude from docs
   * @param tick         Tick element
   * @param position     Starting position
   * @param endPosition  End position
   */


  AxisRendererY.prototype.updateTickElement = function (tick, position, endPosition) {
    position = position + (endPosition - position) * tick.location;
    var point = this.positionToPoint(position);
    var tickLength = tick.length;

    try {
      _core_utils_Utils__WEBPACK_IMPORTED_MODULE_8__["used"](this.axis.title.measuredWidth);
    } catch (_a) {// void
    }

    point.x = _core_utils_Utils__WEBPACK_IMPORTED_MODULE_8__["spritePointToSprite"]({
      x: this.line.pixelX,
      y: 0
    }, this.line.parent, this.gridContainer).x;

    if (!this.opposite) {
      tickLength *= tick.inside ? 1 : -1;
    } else {
      tickLength *= tick.inside ? -1 : 1;
    }

    tick.path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_7__["moveTo"]({
      x: 0,
      y: 0
    }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_7__["lineTo"]({
      x: tickLength,
      y: 0
    });
    this.positionItem(tick, point);
    this.toggleVisibility(tick, position, 0, 1);
  };
  /**
   * Updates and positions the axis line element.
   *
   * @ignore Exclude from docs
   */


  AxisRendererY.prototype.updateAxisLine = function () {
    this.line.path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_7__["moveTo"]({
      x: 0,
      y: 0
    }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_7__["lineTo"]({
      x: 0,
      y: this.axisLength
    });
  };
  /**
   * Updates and positions the base grid element.
   *
   * @ignore Exclude from docs
   */


  AxisRendererY.prototype.updateBaseGridElement = function () {
    _super.prototype.updateBaseGridElement.call(this);

    var axis = this.axis;
    var w = this.getWidth();
    var h = this.axisLength;
    var y = axis.basePoint.y;
    var baseGrid = this.baseGrid;

    if (y < -0.2 || y > h + 0.2) {
      baseGrid.hide(0);
    } else {
      var x = _core_utils_Utils__WEBPACK_IMPORTED_MODULE_8__["spritePointToSprite"]({
        x: 0,
        y: 0
      }, this.gridContainer, baseGrid.parent).x;
      baseGrid.path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_7__["moveTo"]({
        x: 0,
        y: 0
      }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_7__["lineTo"]({
        x: w,
        y: 0
      });
      baseGrid.moveTo({
        x: x,
        y: y
      });
      baseGrid.show(0);
    }
  };
  /**
   * Updates and positions a label element.
   *
   * @ignore Exclude from docs
   * @param label        Label element
   * @param position     Starting position
   * @param endPosition  Ending position
   */


  AxisRendererY.prototype.updateLabelElement = function (label, position, endPosition, location) {
    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["hasValue"](location)) {
      location = label.location;
    }

    position = position + (endPosition - position) * location;
    label.isMeasured = !label.inside;
    var point = this.positionToPoint(position);
    var horizontalCenter;
    var deltaX = 0;
    var maxWidth = this.gridContainer.maxWidth;

    if (this.opposite) {
      if (label.inside) {
        horizontalCenter = "right";

        if (label.align == "left") {
          deltaX = -maxWidth;
          horizontalCenter = "left";
        }

        if (label.align == "center") {
          deltaX = -maxWidth / 2;
          horizontalCenter = "middle";
        }
      } else {
        horizontalCenter = "left";
      }

      point.x = 0 + deltaX;
    } else {
      if (label.inside) {
        horizontalCenter = "left";

        if (label.align == "right") {
          deltaX = maxWidth;
          horizontalCenter = "right";
        }

        if (label.align == "center") {
          deltaX = maxWidth / 2;
          horizontalCenter = "middle";
        }
      } else {
        horizontalCenter = "right";
      }

      point.x = this.measuredWidth + deltaX;
    }

    if (label.rotation == 0) {
      // Apply fuzzy logic to verticalCenter only if labels are not rotated
      label.horizontalCenter = horizontalCenter;
    }

    this.positionItem(label, point);
    this.toggleVisibility(label, position, this.minLabelPosition, this.maxLabelPosition);
  };
  /**
   * Updates and positions an axis break element.
   *
   * @ignore Exclude from docs
   * @param axisBreak Break element
   */


  AxisRendererY.prototype.updateBreakElement = function (axisBreak) {
    _super.prototype.updateBreakElement.call(this, axisBreak);

    var startLine = axisBreak.startLine;
    var endLine = axisBreak.endLine;
    var fillShape = axisBreak.fillShape;
    var startPoint = axisBreak.startPoint;
    var endPoint = axisBreak.endPoint;
    var x1 = axisBreak.pixelMarginLeft;
    var x2 = this.getWidth() - axisBreak.pixelMarginLeft - axisBreak.pixelMarginRight;
    startPoint.y = _core_utils_Math__WEBPACK_IMPORTED_MODULE_6__["fitToRange"](startPoint.y, -1, this.axisLength + 1);
    endPoint.y = _core_utils_Math__WEBPACK_IMPORTED_MODULE_6__["fitToRange"](endPoint.y, -1, this.axisLength + 1);

    if (startPoint.y == endPoint.y && (startPoint.y < 0 || startPoint.y > this.axisLength)) {
      axisBreak.fillShape.__disabled = true;
    } else {
      axisBreak.fillShape.__disabled = false;
    }

    var w = Math.abs(x2 - x1);
    startLine.x = x1;
    startLine.height = 0;
    startLine.width = w;
    endLine.x = x1;
    endLine.height = 0;
    endLine.width = w;
    fillShape.width = w;
    fillShape.height = Math.abs(endPoint.y - startPoint.y);
    fillShape.x = x1;
    fillShape.y = endPoint.y;
  };
  /**
   * Creates visual elements for and axis break.
   *
   * @ignore Exclude from docs
   * @param axisBreak Axis break
   */


  AxisRendererY.prototype.createBreakSprites = function (axisBreak) {
    axisBreak.startLine = new _core_elements_WavedLine__WEBPACK_IMPORTED_MODULE_2__["WavedLine"]();
    axisBreak.endLine = new _core_elements_WavedLine__WEBPACK_IMPORTED_MODULE_2__["WavedLine"]();
    var wavedRectangle = new _core_elements_WavedRectangle__WEBPACK_IMPORTED_MODULE_3__["WavedRectangle"]();
    wavedRectangle.setWavedSides(true, false, true, false);
    axisBreak.fillShape = wavedRectangle;
  };
  /**
   * Converts a position on the axis to a coordinate in pixels.
   *
   * @ignore Exclude from docs
   * @param position  Position (0-1)
   * @return Coordinate (px)
   */


  AxisRendererY.prototype.positionToCoordinate = function (position) {
    var coordinate;
    var axis = this.axis;
    var axisFullLength = axis.axisFullLength;

    if (!axis.renderer.inversed) {
      coordinate = (axis.end - position) * axisFullLength;
    } else {
      coordinate = (position - axis.start) * axisFullLength;
    }

    return coordinate;
  };
  /**
   * Updates and positions axis bullets.
   *
   * @ignore Exclude from docs
   * @param bullet       AxisBullet element
   * @param position     Starting position
   * @param endPosition  End position
   */


  AxisRendererY.prototype.updateBullet = function (bullet, position, endPosition) {
    var location = 0.5;

    if (bullet instanceof _AxisBullet__WEBPACK_IMPORTED_MODULE_11__["AxisBullet"]) {
      location = bullet.location;
    }

    position = position + (endPosition - position) * location;
    var point = this.positionToPoint(position);
    point.x = _core_utils_Utils__WEBPACK_IMPORTED_MODULE_8__["spritePointToSprite"]({
      x: this.line.pixelX,
      y: 0
    }, this.line.parent, this.gridContainer).x;
    this.positionItem(bullet, point);
    this.toggleVisibility(bullet, position, 0, 1);
  };

  return AxisRendererY;
}(_AxisRenderer__WEBPACK_IMPORTED_MODULE_1__["AxisRenderer"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_4__["registry"].registeredClasses["AxisRendererY"] = AxisRendererY;
/**
 * Add default responsive rules
 */

/**
 * Put labels inside plot area.
 * Disable first and last labels.
 */

_core_utils_Responsive__WEBPACK_IMPORTED_MODULE_10__["defaultRules"].push({
  relevant: _core_utils_Responsive__WEBPACK_IMPORTED_MODULE_10__["ResponsiveBreakpoints"].widthS,
  state: function state(target, stateId) {
    if (target instanceof AxisRendererY) {
      var state = target.states.create(stateId);
      state.properties.inside = true;
      state.properties.maxLabelPosition = 0.9;
      state.properties.minLabelPosition = 0.1;
      return state;
    }

    return null;
  }
});
/**
 * Disable labels altogather on very small charts
 */

_core_utils_Responsive__WEBPACK_IMPORTED_MODULE_10__["defaultRules"].push({
  relevant: _core_utils_Responsive__WEBPACK_IMPORTED_MODULE_10__["ResponsiveBreakpoints"].widthXS,
  state: function state(target, stateId) {
    if (target instanceof AxisRendererY) {
      var state = target.states.create(stateId);
      state.properties.disabled = true;
      return state;
    }

    return null;
  }
});

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisRendererY3D.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisRendererY3D.js ***!
  \***********************************************************************************/
/*! exports provided: AxisRendererY3D */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AxisRendererY3D", function() { return AxisRendererY3D; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _axes_AxisRendererY__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../axes/AxisRendererY */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisRendererY.js");
/* harmony import */ var _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/utils/Disposer */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Disposer.js");
/* harmony import */ var _core_rendering_Path__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/rendering/Path */ "./node_modules/@amcharts/amcharts4/.internal/core/rendering/Path.js");
/**
 * Module, defining Axis Renderer for vertical 3D axes.
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */




/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Renderer for vertical 3D axis.
 *
 * @see {@link IAxisRendererY3DEvents} for a list of available events
 * @see {@link IAxisRendererY3DAdapters} for a list of available Adapters
 */

var AxisRendererY3D =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(AxisRendererY3D, _super);
  /**
   * Constructor.
   *
   * @param axis Related axis
   */


  function AxisRendererY3D() {
    var _this = _super.call(this) || this;
    /**
     * A related chart.
     *
     * @todo Description
     */


    _this._chart = new _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_2__["MutableValueDisposer"]();
    _this.className = "AxisRendererY3D";

    _this._disposers.push(_this._chart);

    _this.applyTheme();

    return _this;
  }
  /**
   * Updates and positions a grid element.
   *
   * @ignore Exclude from docs
   * @param grid         Grid element
   * @param position     Starting position
   * @param endPosition  End position
   */


  AxisRendererY3D.prototype.updateGridElement = function (grid, position, endPosition) {
    position = position + (endPosition - position) * grid.location;
    var point = this.positionToPoint(position);

    if (grid.element) {
      var dx = this.chart.dx3D || 0;
      var dy = this.chart.dy3D || 0;
      var w = this.getWidth();
      grid.path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_3__["moveTo"]({
        x: 0,
        y: 0
      }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_3__["lineTo"]({
        x: dx,
        y: dy
      }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_3__["lineTo"]({
        x: w + dx,
        y: dy
      });
    }

    this.positionItem(grid, point);
    this.toggleVisibility(grid, position, 0, 1);
  };
  /**
   * Updates and positions the base grid element.
   *
   * @ignore Exclude from docs
   */


  AxisRendererY3D.prototype.updateBaseGridElement = function () {
    _super.prototype.updateBaseGridElement.call(this);

    var dx = this.chart.dx3D || 0;
    var dy = this.chart.dy3D || 0;
    var w = this.getWidth();
    this.baseGrid.path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_3__["moveTo"]({
      x: 0,
      y: 0
    }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_3__["lineTo"]({
      x: w,
      y: 0
    }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_3__["lineTo"]({
      x: w + dx,
      y: dy
    });
  };

  Object.defineProperty(AxisRendererY3D.prototype, "chart", {
    /**
     * @ignore Exclude from docs
     * @return Chart
     */
    get: function get() {
      return this._chart.get();
    },

    /**
     * Chart, associated with the Axis.
     *
     * @ignore Exclude from docs
     * @param value  Chart
     */
    set: function set(chart) {
      if (chart) {
        this._chart.set(chart, chart.events.on("propertychanged", this.handle3DChanged, this, false));
      }
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Invoked when 3D-related settings change, like depth or angle.
   *
   * @param event Event
   */

  AxisRendererY3D.prototype.handle3DChanged = function (event) {
    if (event.property == "depth" || event.property == "angle") {
      this.invalidate();
    }
  };

  return AxisRendererY3D;
}(_axes_AxisRendererY__WEBPACK_IMPORTED_MODULE_1__["AxisRendererY"]);



/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisTick.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisTick.js ***!
  \****************************************************************************/
/*! exports provided: AxisTick */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AxisTick", function() { return AxisTick; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _elements_Tick__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../elements/Tick */ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/Tick.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/**
 * Axis Tick module
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */



/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Draws an axis tick
 * @see {@link IAxisTickEvents} for a list of available events
 * @see {@link IAxisTickAdapters} for a list of available Adapters
 */

var AxisTick =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(AxisTick, _super);

  function AxisTick() {
    var _this = _super.call(this) || this;

    _this.className = "AxisTick";
    _this.element = _this.paper.add("path");
    _this.location = 0.5;
    _this.above = false;
    _this.isMeasured = false;
    _this.pixelPerfect = true;
    _this.strokeOpacity = 0;
    _this.length = 5;

    _this.applyTheme();

    return _this;
  }

  Object.defineProperty(AxisTick.prototype, "location", {
    /**
     * @return Location (0-1)
     */
    get: function get() {
      return this.getPropertyValue("location");
    },

    /**
     * Relative location of the tick. (0-1)
     *
     * @param value  Location (0-1)
     */
    set: function set(value) {
      this.setPropertyValue("location", value, true);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisTick.prototype, "inside", {
    /**
     * Returns if label is set to be drawn inside axis.
     *
     * @return Inside?
     */
    get: function get() {
      return this.getPropertyValue("inside");
    },

    /**
     * Sets if tick should be drawn inside axis.
     *
     * @param value  Inside?
     */
    set: function set(value) {
      this.setPropertyValue("inside", value, true);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(AxisTick.prototype, "above", {
    /**
     * @return Draw above series?
     */
    get: function get() {
      return this.getPropertyValue("above");
    },

    /**
     * Normally tick goes below series. Set this to `true` to go above.
     *
     * @default false
     * @since 4.5.9
     * @param  value  Draw above series?
     */
    set: function set(value) {
      this.setPropertyValue("above", value, true);
    },
    enumerable: true,
    configurable: true
  });
  /**
   * @ignore
   */

  AxisTick.prototype.setDisabled = function (value) {
    var changed = _super.prototype.setDisabled.call(this, value);

    if (this.axis) {
      this.axis.invalidateDataItems();
    }

    return changed;
  };

  return AxisTick;
}(_elements_Tick__WEBPACK_IMPORTED_MODULE_1__["Tick"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_2__["registry"].registeredClasses["AxisTick"] = AxisTick;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/CategoryAxis.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/axes/CategoryAxis.js ***!
  \********************************************************************************/
/*! exports provided: CategoryAxisDataItem, CategoryAxis */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CategoryAxisDataItem", function() { return CategoryAxisDataItem; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CategoryAxis", function() { return CategoryAxis; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Axis__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Axis */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/Axis.js");
/* harmony import */ var _AxisRendererX__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./AxisRendererX */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisRendererX.js");
/* harmony import */ var _AxisRendererY__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./AxisRendererY */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisRendererY.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_utils_Dictionary__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core/utils/Dictionary */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Dictionary.js");
/* harmony import */ var _CategoryAxisBreak__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./CategoryAxisBreak */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/CategoryAxisBreak.js");
/* harmony import */ var _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../core/utils/Math */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Math.js");
/* harmony import */ var _core_utils_Type__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../core/utils/Type */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Type.js");
/* harmony import */ var _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../core/utils/Iterator */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Iterator.js");
/**
 * Category axis module
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */










/**
 * ============================================================================
 * DATA ITEM
 * ============================================================================
 * @hidden
 */

/**
 * Defines a [[DataItem]] for [[CategoryAxis]].
 *
 * @see {@link DataItem}
 */

var CategoryAxisDataItem =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(CategoryAxisDataItem, _super);
  /**
   * Constructor
   */


  function CategoryAxisDataItem() {
    var _this = _super.call(this) || this;

    _this.seriesDataItems = {};
    _this.className = "CategoryAxisDataItem";
    _this.text = "{category}";
    _this.locations.category = 0;
    _this.locations.endCategory = 1;
    _this.deltaPosition = 0;

    _this.applyTheme();

    return _this;
  }

  Object.defineProperty(CategoryAxisDataItem.prototype, "category", {
    /**
     * @return Category
     */
    get: function get() {
      if (this._adapterO) {
        if (this._adapterO.isEnabled("category")) {
          return this._adapterO.apply("category", this.properties.category);
        }
      }

      return this.properties.category;
    },

    /**
     * Category.
     *
     * @param value  Category
     */
    set: function set(value) {
      var oldCategory = this.properties.category;
      this.setProperty("category", value);

      if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_8__["hasValue"](oldCategory) && oldCategory != value) {
        if (this.component) {
          this.component.validateDataElement(this);
        }
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(CategoryAxisDataItem.prototype, "endCategory", {
    /**
     * @return End category
     */
    get: function get() {
      return this.properties.endCategory;
    },

    /**
     * End category.
     *
     * Used for items that span several categories, like [[CategoryAxisBreak]].
     *
     * @param value  End category
     */
    set: function set(value) {
      this.setProperty("endCategory", value);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(CategoryAxisDataItem.prototype, "deltaPosition", {
    get: function get() {
      return this.properties.deltaCoordinate;
    },
    set: function set(value) {
      if (value != this.properties.deltaCoordinate) {
        this.setProperty("deltaCoordinate", value);

        if (this.component) {
          this.component.invalidateDataItems();
          this.component.invalidateSeries();
        }
      }
    },
    enumerable: true,
    configurable: true
  });
  return CategoryAxisDataItem;
}(_Axis__WEBPACK_IMPORTED_MODULE_1__["AxisDataItem"]);


/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Used to create a category-based axis for the chart.
 *
 * ```TypeScript
 * // Create the axis
 * let xAxis = chart.xAxes.push(new am4charts.CategoryAxis());
 *
 * // Set settings
 * xAxis.title.text = "Clients";
 * ```
 * ```JavaScript
 * // Create the axis
 * var valueAxis = chart.xAxes.push(new am4charts.CategoryAxis());
 *
 * // Set settings
 * valueAxis.title.text = "Clients";
 * ```
 * ```JSON
 * "xAxes": [{
 *   "type": "CategoryAxis",
 *   "title": {
 *     "text": "Clients"
 *   }
 * }]
 * ```
 *
 * @see {@link ICategoryAxisEvents} for a list of available Events
 * @see {@link ICategoryAxisAdapters} for a list of available Adapters
 * @important
 */

var CategoryAxis =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(CategoryAxis, _super);
  /**
   * Constructor
   */


  function CategoryAxis() {
    var _this = // Init
    _super.call(this) || this;
    /**
     * A collection that holds Axis' data items sorted by each category.
     */


    _this.dataItemsByCategory = new _core_utils_Dictionary__WEBPACK_IMPORTED_MODULE_5__["Dictionary"]();
    _this.className = "CategoryAxis"; // Set field name

    _this.axisFieldName = "category";
    _this._lastDataItem = _this.createDataItem();
    _this._lastDataItem.component = _this;

    _this._disposers.push(_this._lastDataItem); // Apply theme


    _this.applyTheme();

    var dataItemsByCategory = _this.dataItemsByCategory;

    _this.addDisposer(_this.mainDataSet.events.on("removed", function (event) {
      dataItemsByCategory.removeKey(event.oldValue.category);
    }));

    return _this;
  }
  /**
   * Returns a new/empty [[DataItem]] of the type appropriate for this object.
   *
   * @see {@link DataItem}
   * @return Data Item
   */


  CategoryAxis.prototype.createDataItem = function () {
    return new CategoryAxisDataItem();
  };
  /**
   * Returns a new/empty [[AxisBreak]] of the appropriate type.
   *
   * @return Axis break
   */


  CategoryAxis.prototype.createAxisBreak = function () {
    return new _CategoryAxisBreak__WEBPACK_IMPORTED_MODULE_6__["CategoryAxisBreak"]();
  };
  /**
   * Processes a related series' data item.
   *
   * @ignore Exclude from docs
   * @todo Description
   * @param dataItem  Data item
   */


  CategoryAxis.prototype.processSeriesDataItem = function (dataItem, axisLetter) {
    _super.prototype.processSeriesDataItem.call(this, dataItem, axisLetter);

    var category = dataItem["category" + this.axisLetter];

    if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_8__["hasValue"](category)) {
      var categoryAxisDataItem = this.dataItemsByCategory.getKey(category);

      if (categoryAxisDataItem) {
        var seriesId = dataItem.component.uid;
        var seriesDataItems = categoryAxisDataItem.seriesDataItems[seriesId];

        if (!seriesDataItems) {
          seriesDataItems = [];
          categoryAxisDataItem.seriesDataItems[seriesId] = seriesDataItems;
        }

        seriesDataItems.push(dataItem);
      }
    } else {
      dataItem.component.dataItems.remove(dataItem);
    }
  };
  /**
   * Validates the data range.
   *
   * @ignore Exclude from docs
   * @todo Description (review)
   */


  CategoryAxis.prototype.validateDataRange = function () {
    var _this = this;

    _super.prototype.validateDataRange.call(this);

    _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_9__["each"](this._series.iterator(), function (series) {
      if (series.xAxis instanceof CategoryAxis && series.yAxis instanceof CategoryAxis) {
        series.invalidateDataRange();
      } else {
        var startIndex = _this.positionToIndex(_this.start);

        var endIndex = _this.positionToIndex(_this.end);

        if (endIndex >= _this.dataItems.length) {
          endIndex--;
        }

        var seriesId = series.uid;
        var minIndex = void 0;
        var maxIndex = void 0;

        for (var i = startIndex; i <= endIndex; i++) {
          var axisDataItem = _this.dataItems.getIndex(i);

          if (axisDataItem) {
            var seriesDataItems = axisDataItem.seriesDataItems[seriesId];

            if (seriesDataItems) {
              for (var i_1 = 0; i_1 < seriesDataItems.length; i_1++) {
                var seriesDataItem = seriesDataItems[i_1];

                if (seriesDataItem) {
                  var index = seriesDataItem.index;

                  if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_8__["isNumber"](minIndex) || index < minIndex) {
                    minIndex = index;
                  }

                  if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_8__["isNumber"](maxIndex) || index > maxIndex) {
                    maxIndex = index;
                  }
                }
              }
            }
          }
        }

        if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_8__["isNumber"](minIndex)) {
          series.startIndex = minIndex;
        } else {
          series.start = _this.start;
        }

        if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_8__["isNumber"](maxIndex)) {
          series.endIndex = maxIndex + 1;
        } else {
          series.end = _this.end;
        } // range might not change, but axis breaks might.


        if (_this._axisBreaks && _this._axisBreaks.length > 0) {
          series.invalidateDataRange();
        }
      }
    });
  };
  /**
   * Validates the whole axis. Causes it to redraw.
   *
   * @ignore Exclude from docs
   * @todo Description (review)
   */


  CategoryAxis.prototype.validate = function () {
    var _this = this;

    _super.prototype.validate.call(this);

    var dataCount = this.dataItems.length;
    var startIndex = _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["fitToRange"](Math.floor(this.start * dataCount - 1), 0, dataCount);
    var endIndex = _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["fitToRange"](Math.ceil(this.end * dataCount), 0, dataCount);

    if (this.renderer.invalid) {
      this.renderer.validate();
    } // find frequency at which we'll show items


    var maxCount = this.renderer.axisLength / Math.max(this.renderer.minGridDistance, 1 / Number.MAX_SAFE_INTEGER);
    var frequency = Math.min(this.dataItems.length, Math.ceil((endIndex - startIndex) / maxCount));
    this._startIndex = Math.floor(startIndex / frequency) * frequency;
    this._endIndex = Math.ceil(this.end * dataCount);
    this.fixAxisBreaks();

    if (this._startIndex == this._endIndex) {
      this._endIndex++;
    }

    this._frequency = frequency;

    if (this.axisLength <= 0) {
      return;
    }

    this.maxZoomFactor = this.dataItems.length;

    if (this.dataItems.length <= 0) {
      this.maxZoomFactor = 1;
    }

    this.resetIterators(); // it's important to use protected variables here, as getters will return 0 - length
    // TODO use iterator instead
    // @ todo: not solved cat axis item fading

    startIndex = _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["max"](0, this._startIndex - this._frequency);
    endIndex = _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["min"](this.dataItems.length, this._endIndex + this._frequency);
    var itemIndex = 0;

    for (var i = 0; i < startIndex; i++) {
      var dataItem = this.dataItems.getIndex(i);
      dataItem.__disabled = true;
    }

    for (var i = endIndex, len = this.dataItems.length; i < len; i++) {
      var dataItem = this.dataItems.getIndex(i);
      dataItem.__disabled = true;
    }

    for (var i = startIndex; i < endIndex; i++) {
      if (i < this.dataItems.length) {
        var dataItem = this.dataItems.getIndex(i);

        if (i / this._frequency == Math.round(i / this._frequency)) {
          var axisBreak = this.isInBreak(i);

          if (!axisBreak) {
            this.appendDataItem(dataItem);
            this.validateDataElement(dataItem, itemIndex);
          }

          itemIndex++;
        } else {
          //previously we disabled all before, but this is better for cpu
          //this.validateDataElement(dataItem, itemIndex); // helps to solve shrinking // not good - creates all items
          dataItem.__disabled = true;
        }
      }
    }

    this.appendDataItem(this._lastDataItem);
    this.validateDataElement(this._lastDataItem, itemIndex + 1, this.dataItems.length);

    if (this._axisBreaks) {
      var axisBreaks = this._axisBreaks;
      axisBreaks.each(function (axisBreak) {
        var adjustedStartValue = axisBreak.adjustedStartValue;
        var adjustedEndValue = axisBreak.adjustedEndValue;

        if (_core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["intersect"]({
          start: adjustedStartValue,
          end: adjustedEndValue
        }, {
          start: _this._startIndex,
          end: _this._endIndex
        })) {
          for (var b = adjustedStartValue; b <= adjustedEndValue; b++) {
            var dataItem = _this.dataItems.getIndex(b);

            dataItem.__disabled = true;
          }

          var frequency_1 = _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["fitToRange"](Math.ceil(_this._frequency / axisBreak.breakSize), 1, adjustedEndValue - adjustedStartValue);
          var itemIndex_1 = 0;

          if (axisBreak.breakSize > 0) {
            // TODO use iterator instead
            for (var b = adjustedStartValue; b <= adjustedEndValue; b = b + frequency_1) {
              var dataItem = _this.dataItems.getIndex(b);

              dataItem.__disabled = false;

              _this.appendDataItem(dataItem);

              _this.validateDataElement(dataItem, itemIndex_1);

              itemIndex_1++;
            }
          }
        }
      });
    }

    this.validateBreaks();
    this.validateAxisRanges();
    this.ghostLabel.invalidate(); // solves font issue

    this.renderer.invalidateLayout();
  };
  /**
   * [validateDataElement description]
   *
   * @ignore Exclude from docs
   * @todo Description
   * @param dataItem   [description]
   * @param itemIndex  [description]
   */


  CategoryAxis.prototype.validateDataElement = function (dataItem, itemIndex, index) {
    _super.prototype.validateDataElement.call(this, dataItem);

    dataItem.itemIndex = this._axisItemCount;
    this._axisItemCount++; //dataItem.__disabled = false;

    var renderer = this.renderer;

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_8__["isNumber"](index)) {
      index = this.categoryToIndex(dataItem.category);
    }

    var endIndex = this.categoryToIndex(dataItem.endCategory);

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_8__["isNumber"](endIndex)) {
      endIndex = index;
    }

    var position = this.indexToPosition(index, dataItem.locations.category);
    var endPosition = this.indexToPosition(endIndex, dataItem.locations.endCategory);
    dataItem.position = position;
    var fillEndIndex;
    var fillPosition;
    var fillEndPosition;

    if (dataItem.isRange) {
      fillEndIndex = endIndex;
      fillPosition = this.indexToPosition(index, dataItem.locations.category);
      fillEndPosition = this.indexToPosition(fillEndIndex, dataItem.locations.endCategory);
    }

    dataItem.point = renderer.positionToPoint(position);
    var tick = dataItem.tick;

    if (tick && !tick.disabled) {
      renderer.updateTickElement(tick, position, endPosition);
    }

    var grid = dataItem.grid;

    if (grid && !grid.disabled) {
      renderer.updateGridElement(grid, position, endPosition);
    }

    var label = dataItem.label;

    if (label && !label.disabled) {
      // theorethically this might result problems if category text changes, the range text won't change. But otherwise range.label.text = "custom text" won't work, which is not intuitive.
      if (!dataItem.isRange || label.text == undefined) {
        dataItem.text = dataItem.text;
      }

      renderer.updateLabelElement(label, position, endPosition);

      if (renderer instanceof _AxisRendererY__WEBPACK_IMPORTED_MODULE_3__["AxisRendererY"] && dataItem.label.measuredWidth > this.ghostLabel.measuredWidth || renderer instanceof _AxisRendererX__WEBPACK_IMPORTED_MODULE_2__["AxisRendererX"] && dataItem.label.measuredHeight > this.ghostLabel.measuredHeight) {
        if (dataItem.label.html) {
          this.ghostLabel.html = dataItem.label.currentText;
        } else {
          this.ghostLabel.text = dataItem.label.currentText;
        }
      }
    }

    var fill = dataItem.axisFill;

    if (fill && !fill.disabled) {
      if (!dataItem.isRange) {
        fillEndIndex = index + this._frequency;
        fillPosition = this.indexToPosition(index, fill.location);
        fillEndPosition = this.indexToPosition(fillEndIndex, fill.location);
      }

      renderer.updateFillElement(fill, fillPosition, fillEndPosition);

      if (!dataItem.isRange) {
        this.fillRule(dataItem, itemIndex);
      }
    }

    if (dataItem.bullet) {
      renderer.updateBullet(dataItem.bullet, position, endPosition);
    }

    var mask = dataItem.mask;

    if (mask) {
      renderer.updateFillElement(mask, fillPosition, fillEndPosition);
    }
  };
  /**
   * @ignore
   */


  CategoryAxis.prototype.disposeData = function () {
    this.dataItemsByCategory.clear();

    _super.prototype.disposeData.call(this);
  };
  /**
   * Processes the axis data item.
   *
   * @ignore Exclude from docs
   * @param dataItem     Data item
   * @param dataContext  The raw data that corresponds to this data item
   */


  CategoryAxis.prototype.processDataItem = function (dataItem, dataContext) {
    if (dataItem) {
      // creat a collection for fast access
      _super.prototype.processDataItem.call(this, dataItem, dataContext); // check if such category already exists
      //let existingDataItem: CategoryAxisDataItem = this.dataItemsByCategory.getKey(dataItem.category);
      //if (existingDataItem && existingDataItem != dataItem) {
      //	this.dataItems.remove(existingDataItem);
      //}


      if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_8__["hasValue"](dataItem.category)) {
        this.dataItemsByCategory.setKey(dataItem.category, dataItem);
      }
    }
  };

  CategoryAxis.prototype.getDataItem = function (dataContext) {
    var category = dataContext[this.dataFields.category];

    if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_8__["hasValue"](category)) {
      var dataItem = this.dataItemsByCategory.getKey(category);

      if (dataItem) {
        return dataItem;
      } else {
        return this.dataItems.create();
      }
    }
  };
  /**
   * Converts a category index to an actual screen coordinate on the axis.
   *
   * `location` identifies relative location within category. 0 - beginning,
   * 0.5 - middle, 1 - end, and anything inbetween.
   *
   * @param index     Index
   * @param location  Location (0-1)
   * @return Position (px)
   */


  CategoryAxis.prototype.indexToPosition = function (index, location) {
    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_8__["isNumber"](location)) {
      location = 0.5;
    }

    var startIndex = this.startIndex;
    var endIndex = this.endIndex;
    var difference = this.adjustDifference(startIndex, endIndex);
    var startLocation = this.startLocation;
    var endLocation = this.endLocation;
    difference -= startLocation;
    difference -= 1 - endLocation;

    if (this._axisBreaks) {
      var axisBreaks = this._axisBreaks;
      _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_9__["eachContinue"](axisBreaks.iterator(), function (axisBreak) {
        var breakStartIndex = axisBreak.adjustedStartValue;
        var breakEndIndex = axisBreak.adjustedEndValue;

        if (index < startIndex || !_core_utils_Type__WEBPACK_IMPORTED_MODULE_8__["isNumber"](breakStartIndex) || !_core_utils_Type__WEBPACK_IMPORTED_MODULE_8__["isNumber"](breakEndIndex)) {
          return false;
        }

        if (_core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["intersect"]({
          start: breakStartIndex,
          end: breakEndIndex
        }, {
          start: startIndex,
          end: endIndex
        })) {
          breakStartIndex = Math.max(startIndex, breakStartIndex);
          breakEndIndex = Math.min(endIndex, breakEndIndex);
          var breakSize = axisBreak.breakSize; // value to the right of break end

          if (index > breakEndIndex) {
            startIndex += (breakEndIndex - breakStartIndex) * (1 - breakSize);
          } // value to the left of break start
          else if (index < breakStartIndex) {} // value within break
            else {
                index = breakStartIndex + (index - breakStartIndex) * breakSize;
              }
        }

        return true;
      });
    }

    var deltaPosition = 0;
    var dataItem = this.dataItems.getIndex(index);

    if (dataItem) {
      deltaPosition = dataItem.deltaPosition;
    }

    return _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["round"](deltaPosition + (index + location - startLocation - startIndex) / difference, 5);
  };
  /**
   * Converts a string category name to relative position on axis.
   *
   * `location` identifies relative location within category. 0 - beginning,
   * 0.5 - middle, 1 - end, and anything inbetween.
   *
   * @param category  Category name
   * @param location  Location (0-1)
   * @return Position
   */


  CategoryAxis.prototype.categoryToPosition = function (category, location) {
    var index = this.categoryToIndex(category);
    return this.indexToPosition(index, location);
  };
  /**
   * Converts a string category name to a orientation point (x, y, angle) on axis
   *
   * `location` identifies relative location within category. 0 - beginning,
   * 0.5 - middle, 1 - end, and anything inbetween.
   * @param category  Category name
   * @param location  Location (0-1)
   * @return Orientation point
   */


  CategoryAxis.prototype.categoryToPoint = function (category, location) {
    var position = this.categoryToPosition(category, location);
    var point = this.renderer.positionToPoint(position);
    var angle = this.renderer.positionToAngle(position);
    return {
      x: point.x,
      y: point.y,
      angle: angle
    };
  };
  /**
   * Converts a string category name to a orientation point (x, y, angle) on axis
   *
   * `location` identifies relative location within category. 0 - beginning,
   * 0.5 - middle, 1 - end, and anything inbetween.
   * @param category  Category name
   * @param location  Location (0-1)
   * @return Orientation point
   */


  CategoryAxis.prototype.anyToPoint = function (category, location) {
    return this.categoryToPoint(category, location);
  };
  /**
   * Converts a string category name to relative position on axis.
   *
   * An alias to `categoryToPosition()`.
   *
   * @param category  Category name
   * @param location  Location (0-1)
   * @return Relative position
   */


  CategoryAxis.prototype.anyToPosition = function (category, location) {
    return this.categoryToPosition(category, location);
  };
  /**
   * Converts named category to an index of data item it corresponds to.
   *
   * @param category  Category
   * @return Data item index
   */


  CategoryAxis.prototype.categoryToIndex = function (category) {
    if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_8__["hasValue"](category)) {
      var dataItem = this.dataItemsByCategory.getKey(category);

      if (dataItem) {
        return dataItem.index;
      }
    }
  };
  /**
   * Zooms the axis to specific named ctaegories.
   *
   * @param startCategory  Start category
   * @param endCategory    End category
   */


  CategoryAxis.prototype.zoomToCategories = function (startCategory, endCategory) {
    this.zoomToIndexes(this.categoryToIndex(startCategory), this.categoryToIndex(endCategory) + 1);
  };
  /**
   * [getAnyRangePath description]
   *
   * @ignore Exclude from docs
   * @todo Description
   * @param start         [description]
   * @param end           [description]
   * @param startLocation [description]
   * @param endLocation   [description]
   * @return [description]
   */


  CategoryAxis.prototype.getAnyRangePath = function (start, end, startLocation, endLocation) {
    var startPos = this.categoryToPosition(start, startLocation);
    var endPos = this.categoryToPosition(end, endLocation);
    return this.getPositionRangePath(startPos, endPos); // Base class (Axis) gets range shape from AxisRenderer
  };
  /**
   * Takes an absolute position (px) within axis and adjust it to a specific
   * `location` within category it corresponds to.
   *
   * @param position  Source position (px)
   * @param location  Location within category (0-1)
   * @return Adjusted position (px)
   */


  CategoryAxis.prototype.roundPosition = function (position, location) {
    var index = this.positionToIndex(position);
    return this.indexToPosition(index, location);
  };
  /**
   * Finds and returns first series data item with specific category
   * @param series    Target series
   * @param category  Category
   * @return XYSeriesDataItem data item
   */


  CategoryAxis.prototype.getFirstSeriesDataItem = function (series, category) {
    for (var i = 0; i < series.dataItems.length; i++) {
      var dataItem = series.dataItems.getIndex(i);

      if (series.xAxis == this) {
        if (dataItem.categoryX == category) {
          return dataItem;
        }
      }

      if (series.yAxis == this) {
        if (dataItem.categoryY == category) {
          return dataItem;
        }
      }
    }
  };
  /**
   * Finds and returns last series data item with specific category.
   * @param series    Target series
   * @param category  Category
   * @return XYSeriesDataItem data item
   */


  CategoryAxis.prototype.getLastSeriesDataItem = function (series, category) {
    for (var i = series.dataItems.length - 1; i >= 0; i--) {
      var dataItem = series.dataItems.getIndex(i);

      if (series.xAxis == this) {
        if (dataItem.categoryX == category) {
          return dataItem;
        }
      }

      if (series.yAxis == this) {
        if (dataItem.categoryY == category) {
          return dataItem;
        }
      }
    }
  }; // todo: optimize


  CategoryAxis.prototype.getSeriesDataItemByCategory = function (category, series) {
    var _this = this;

    var seriesDataItem;
    series.dataItems.each(function (dataItem) {
      if (series.xAxis == _this) {
        if (dataItem.categoryX == category) {
          seriesDataItem = dataItem;
        }
      } else if (series.yAxis == _this) {
        if (dataItem.categoryY == category) {
          seriesDataItem = dataItem;
        }
      }
    });
    return seriesDataItem;
  };
  /**
   * Returns a data item from Series that corresponds to a specific absolute
   * position on the Axis.
   *
   * @param series    Target series
   * @param position  Position (px)
   * @return XYSeriesDataItem data item
   */


  CategoryAxis.prototype.getSeriesDataItem = function (series, position, findNearest) {
    var _this = this;

    if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_8__["isNumber"](position)) {
      var index_1 = this.positionToIndex(position);

      if (index_1 >= this.dataItems.length) {
        index_1--;
      }

      var dataItem = this.dataItems.getIndex(index_1);

      if (dataItem) {
        var category_1 = dataItem.category;
        var sdi_1;
        var seriesDataItem = series.dataItems.getIndex(index_1);

        if (seriesDataItem) {
          if (series.xAxis == this) {
            if (seriesDataItem.categoryX == category_1) {
              return seriesDataItem;
            }
          }

          if (series.yAxis == this) {
            if (seriesDataItem.categoryY == category_1) {
              return seriesDataItem;
            }
          }
        }

        series.dataItems.each(function (dataItem) {
          if (series.xAxis == _this) {
            if (dataItem.categoryX == category_1) {
              if (!sdi_1) {
                sdi_1 = dataItem;
              }

              if (Math.abs(index_1 - sdi_1.index) > Math.abs(index_1 - dataItem.index)) {
                sdi_1 = dataItem;
              }
            }
          }

          if (series.yAxis == _this) {
            if (dataItem.categoryY == category_1) {
              if (!sdi_1) {
                sdi_1 = dataItem;
              }

              if (Math.abs(index_1 - sdi_1.index) > Math.abs(index_1 - dataItem.index)) {
                sdi_1 = dataItem;
              }
            }
          }
        }); //@todo

        if (findNearest) {}

        return sdi_1;
      }
    }
  };
  /**
   * Returns the X coordinate for series' data item.
   *
   * @ignore Exclude from docs
   * @todo Description (review)
   * @param dataItem  Data item
   * @param key       Category
   * @param location  Location (0-1)
   * @return X coordinate (px)
   */


  CategoryAxis.prototype.getX = function (dataItem, key, location, stackKey, range) {
    var position = this.getPositionX(dataItem, key, location, stackKey, range);

    if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_8__["isNaN"](position)) {
      return this.basePoint.x;
    } else {
      return this.renderer.positionToPoint(position).x;
    }
  };
  /**
   * Returns relative position on axis for series' data item.
   *
   * @since 4.5.14
   * @param  dataItem  Data item
   * @param  key       Category
   * @param  location  Location (0-1)
   * @return           Relative position
   */


  CategoryAxis.prototype.getPositionX = function (dataItem, key, location, stackKey, range) {
    var position;

    if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_8__["hasValue"](key)) {
      position = this.categoryToPosition(dataItem.categories[key], location);
    }

    if (range) {
      position = _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["fitToRange"](position, range.start, range.end);
    }

    return position;
  };
  /**
   * Returns the Y coordinate for series' data item.
   *
   * @ignore Exclude from docs
   * @todo Description (review)
   * @param dataItem  Data item
   * @param key       Category
   * @param location  Location (0-1)
   * @return Y coordinate (px)
   */


  CategoryAxis.prototype.getY = function (dataItem, key, location, stackKey, range) {
    var position = this.getPositionY(dataItem, key, location, stackKey, range);

    if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_8__["isNaN"](position)) {
      return this.basePoint.y;
    } else {
      return this.renderer.positionToPoint(position).y;
    }
  };
  /**
   * Returns relative position on axis for series' data item.
   *
   * @since 4.5.14
   * @param  dataItem  Data item
   * @param  key       Category
   * @param  location  Location (0-1)
   * @return           Relative position
   */


  CategoryAxis.prototype.getPositionY = function (dataItem, key, location, stackKey, range) {
    var position;

    if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_8__["hasValue"](key)) {
      position = this.categoryToPosition(dataItem.categories[key], location);
    }

    if (range) {
      position = _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["fitToRange"](position, range.start, range.end);
    }

    return position;
  };
  /**
   * Returns an angle for series data item.
   *
   * @ignore Exclude from docs
   * @todo Description (review)
   * @param dataItem  Data item
   * @param key       Category
   * @param location  Location (0-1)
   * @param stackKey  Stack key (?)
   * @param range Range to fit in
   * @return Angle
   */


  CategoryAxis.prototype.getAngle = function (dataItem, key, location, stackKey, range) {
    var position = this.categoryToPosition(dataItem.categories[key], location);

    if (range) {
      position = _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["fitToRange"](position, range.start, range.end);
    }

    return this.positionToAngle(position);
  };
  /**
   * Returns an absolute pixel coordinate of the start of the cell (category),
   * that specific position value falls into.
   *
   * @ignore Exclude from docs
   * @todo Description (review)
   * @param position  Position (px)
   * @return Cell start position (px)
   */


  CategoryAxis.prototype.getCellStartPosition = function (position) {
    return this.roundPosition(position, 0);
  };
  /**
   * Returns an absolute pixel coordinate of the end of the cell (category),
   * that specific position value falls into.
   *
   * @ignore Exclude from docs
   * @todo Description (review)
   * @param position  Position (px)
   * @return Cell end position (px)
   */


  CategoryAxis.prototype.getCellEndPosition = function (position) {
    return this.roundPosition(position, 1);
  };
  /**
   * Returns text to show in a category tooltip, based on specific position
   * within axis.
   *
   * @ignore Exclude from docs
   * @param position  Position (px)
   * @return Label (category)
   */


  CategoryAxis.prototype.getTooltipText = function (position) {
    var dataItem = this.dataItems.getIndex(this.positionToIndex(position));

    if (dataItem) {
      this.tooltipDataItem = dataItem;
      this.tooltip.dataItem = dataItem;

      if (this.tooltipText) {
        return this.tooltipText;
      }

      if (!this._adapterO) {
        return dataItem.category;
      } else {
        return this._adapterO.apply("getTooltipText", dataItem.category);
      }
    }
  };
  /**
   * Returns an index of the category that corresponds to specific pixel
   * position within axis.
   *
   * @param position  Position (px)
   * @return Category index
   */


  CategoryAxis.prototype.positionToIndex = function (position) {
    position = _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["round"](position, 10);

    if (position < 0) {
      position = 0;
    }

    if (position > 1) {
      position = 1;
    }

    var startIndex = this.startIndex;
    var endIndex = this.endIndex;
    var difference = endIndex - startIndex - this.startLocation - (1 - this.endLocation);
    position += 1 / difference * this.startLocation;
    var index = null;

    if (this._axisBreaks) {
      var axisBreaks = this._axisBreaks; // in case we have some axis breaks

      _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_9__["eachContinue"](axisBreaks.iterator(), function (axisBreak) {
        var breakStartPosition = axisBreak.startPosition;
        var breakEndPosition = axisBreak.endPosition;
        var breakStartIndex = axisBreak.adjustedStartValue;
        var breakEndIndex = axisBreak.adjustedEndValue;
        breakStartIndex = _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["max"](breakStartIndex, startIndex);
        breakEndIndex = _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["min"](breakEndIndex, endIndex);
        var breakSize = axisBreak.breakSize;
        difference -= (breakEndIndex - breakStartIndex) * (1 - breakSize); // position to the right of break end

        if (position > breakEndPosition) {
          startIndex += (breakEndIndex - breakStartIndex) * (1 - breakSize);
        } // position to the left of break start
        else if (position < breakStartPosition) {} // value within break
          else {
              var breakPosition = (position - breakStartPosition) / (breakEndPosition - breakStartPosition);
              index = breakStartIndex + Math.round(breakPosition * (breakEndIndex - breakStartIndex));
              return false;
            }

        return true;
      });
    }

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_8__["isNumber"](index)) {
      index = Math.floor(position * difference + startIndex);
    }

    if (index >= this.dataItems.length) {
      index = this.dataItems.length - 1;
    } // not good, when panning out of bounds, each time one less item gets selected
    //if (index >= endIndex) {
    //	index--;
    //}


    return index;
  };
  /**
   * Returns category based on position.
   *
   * Please note that `position` represents position within axis which may be
   * zoomed and not correspond to Cursor's `position`.
   *
   * To convert Cursor's `position` to Axis' `position` use `toAxisPosition()` method.
   *
   * This is a synonim of `getPositionLabel()` implemented here for consistentcy.
   *
   * @since 4.3.8
   * @see {@link https://www.amcharts.com/docs/v4/tutorials/tracking-cursors-position-via-api/#Tracking_Cursor_s_position} For more information about cursor tracking.
   * @param position  Relative position on axis (0-1)
   * @return Position label
   */


  CategoryAxis.prototype.positionToCategory = function (position) {
    return this.getPositionLabel(position);
  };
  /**
   * Returns category based on position.
   *
   * Please note that `position` represents position within axis which may be
   * zoomed and not correspond to Cursor's `position`.
   *
   * To convert Cursor's `position` to Axis' `position` use `toAxisPosition()` method.
   *
   * @see {@link https://www.amcharts.com/docs/v4/tutorials/tracking-cursors-position-via-api/#Tracking_Cursor_s_position} For more information about cursor tracking.
   * @param position  Relative position on axis (0-1)
   * @return Position label
   */


  CategoryAxis.prototype.getPositionLabel = function (position) {
    var dataItem = this.dataItems.getIndex(this.positionToIndex(position));

    if (dataItem) {
      return dataItem.category;
    }
  };

  Object.defineProperty(CategoryAxis.prototype, "basePoint", {
    /**
     * Coordinates of the actual axis start.
     *
     * @ignore Exclude from docs
     * @return Base point
     */
    get: function get() {
      // This makes base grid to be drawn at the end of the axis and adds extra
      // grid which we need to nicely close the chart.
      return this.renderer.positionToPoint(1);
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Initializes Axis' renderer.
   *
   * @ignore Exclude from docs
   */

  CategoryAxis.prototype.initRenderer = function () {
    _super.prototype.initRenderer.call(this);

    var renderer = this.renderer;
    renderer.baseGrid.disabled = true;
  };

  Object.defineProperty(CategoryAxis.prototype, "frequency", {
    /**
     * Current frequency of labels of the axis.
     *
     * Normally it would be 1, but when labels start to be hidden due
     * to `minGridDistance` this read-only property will increase.
     *
     * @readonly
     * @since 4.2.0
     * @return Label frequency
     */
    get: function get() {
      return this._frequency;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(CategoryAxis.prototype, "sortBySeries", {
    /**
     * @return Sort categories?
     */
    get: function get() {
      return this.getPropertyValue("sortBySeries");
    },

    /**
     * If set to a reference of [[ColumnSeries]] the categories will be sorted
     * by actual values.
     *
     * The categories are ordered in descending order (from highest values to
     * lowest). To reverse the order, use axis renderer's `inversed` setting.
     * E.g.:
     *
     * ```TypeScript
     * categoryAxis.sortBySeries = series;
     * categoryAxis.renderer.inversed = true;
     * ```
     * ```JavaScript
     * categoryAxis.sortBySeries = series;
     * categoryAxis.renderer.inversed = true;
     * ```
     * ```JSON
     * {
     *   // ...
     *   "xAxes": [{
     *     // ...
     *     "sortBySeries": "s1",
     *     "renderer": {
     *       // ...
     *       "inversed": true
     *     }
     *   }]
     * }
     * ```
     *
     * @since 4.8.7
     * @param  value  Sort categories?
     */
    set: function set(value) {
      this.setPropertyValue("sortBySeries", value, true);
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Processes JSON-based config before it is applied to the object.
   *
   * @ignore Exclude from docs
   * @param config  Config
   */

  CategoryAxis.prototype.processConfig = function (config) {
    if (config) {
      if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_8__["hasValue"](config.sortBySeries) && _core_utils_Type__WEBPACK_IMPORTED_MODULE_8__["isString"](config.sortBySeries)) {
        if (this.map.hasKey(config.sortBySeries)) {
          config.sortBySeries = this.map.getKey(config.sortBySeries);
        } else {
          this.addDelayedMap("sortBySeries", config.sortBySeries);
          delete config.sortBySeries;
        }
      }
    }

    _super.prototype.processConfig.call(this, config);
  };

  return CategoryAxis;
}(_Axis__WEBPACK_IMPORTED_MODULE_1__["Axis"]);


/**
 * Register class, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_4__["registry"].registeredClasses["CategoryAxis"] = CategoryAxis;
_core_Registry__WEBPACK_IMPORTED_MODULE_4__["registry"].registeredClasses["CategoryAxisDataItem"] = CategoryAxisDataItem;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/CategoryAxisBreak.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/axes/CategoryAxisBreak.js ***!
  \*************************************************************************************/
/*! exports provided: CategoryAxisBreak */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CategoryAxisBreak", function() { return CategoryAxisBreak; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _AxisBreak__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AxisBreak */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisBreak.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/**
 * A module which defines functionality related to Category Axis Break.
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */



/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Base class to define "breaks" in axes
 * @see {@link ICategoryAxisBreakEvents} for a list of available events
 * @see {@link ICategoryAxisBreakAdapters} for a list of available Adapters
 */

var CategoryAxisBreak =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(CategoryAxisBreak, _super);
  /**
   * Constructor
   */


  function CategoryAxisBreak() {
    var _this = _super.call(this) || this;

    _this.className = "CategoryAxisBreak";
    _this.properties.startLocation = 0.5;
    _this.properties.endLocation = 0.5;

    _this.applyTheme();

    return _this;
  }

  Object.defineProperty(CategoryAxisBreak.prototype, "startPosition", {
    /**
     * Pixel position of the break's start.
     *
     * @return Position (px)
     * @readonly
     */
    get: function get() {
      if (this.axis) {
        return this.axis.indexToPosition(this.adjustedStartValue, this.startLocation);
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(CategoryAxisBreak.prototype, "endPosition", {
    /**
     * Pixel position of the break's end.
     *
     * @return Position (px)
     * @readonly
     */
    get: function get() {
      if (this.axis) {
        return this.axis.indexToPosition(this.adjustedEndValue, this.endLocation);
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(CategoryAxisBreak.prototype, "startCategory", {
    /**
     * @return Start category
     */
    get: function get() {
      return this.getPropertyValue("startCategory");
    },

    /**
     * A category break starts on.
     *
     * @param value Start category
     */
    set: function set(value) {
      if (this.setPropertyValue("startCategory", value)) {
        if (this.axis) {
          this.axis.invalidateDataItems();
          this.axis.invalidateSeries();
        }
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(CategoryAxisBreak.prototype, "endCategory", {
    /**
     * @return End category
     */
    get: function get() {
      return this.getPropertyValue("endCategory");
    },

    /**
     * A category break ends on.
     *
     * @param value  End category
     */
    set: function set(value) {
      if (this.setPropertyValue("endCategory", value)) {
        if (this.axis) {
          this.axis.invalidateDataItems();
          this.axis.invalidateSeries();
        }
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(CategoryAxisBreak.prototype, "startValue", {
    /**
     * @return Value
     */
    get: function get() {
      var category = this.getPropertyValue("startCategory");

      if (category) {
        return this.axis.categoryToIndex(category);
      } else {
        return this.getPropertyValue("startValue");
      }
    },

    /**
     * An index of start category.
     *
     * @param value  Value
     */
    set: function set(value) {
      if (this.setPropertyValue("startValue", value)) {
        if (this.axis) {
          this.axis.invalidateDataItems();
          this.axis.invalidateSeries();
        }
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(CategoryAxisBreak.prototype, "endValue", {
    /**
     * @return Value
     */
    get: function get() {
      var category = this.getPropertyValue("endCategory");

      if (category) {
        return this.axis.categoryToIndex(category);
      } else {
        return this.getPropertyValue("endValue");
      }
    },

    /**
     * An index of end category or a end value.
     *
     * @param value  Value
     */
    set: function set(value) {
      if (this.setPropertyValue("endValue", value)) {
        if (this.axis) {
          this.axis.invalidateDataItems();
          this.axis.invalidateSeries();
        }
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(CategoryAxisBreak.prototype, "startLocation", {
    /**
     * @return Break start location
     */
    get: function get() {
      return this.getPropertyValue("startLocation");
    },

    /**
     * Indicates where within starting category break should begin.
     *
     * Values range from `0` (start) to `1` (end), with default being `0.5` (middle).
     *
     * E.g. if you want to a break to fully encompass start and end categories,
     * you should set `startLocation = 0` and `endLocation = 1`.
     *
     * @since 4.9.17
     * @default 0.5
     * @param  value  Break start location
     */
    set: function set(value) {
      if (this.setPropertyValue("startLocation", value)) {
        if (this.axis) {
          this.axis.invalidateDataItems();
          this.axis.invalidateSeries();
        }
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(CategoryAxisBreak.prototype, "endLocation", {
    /**
     * @return Break end location
     */
    get: function get() {
      return this.getPropertyValue("endLocation");
    },

    /**
     * Indicates where within ending category break should end.
     *
     * Values range from `0` (start) to `1` (end), with default being `0.5` (middle).
     *
     * E.g. if you want to a break to fully encompass start and end categories,
     * you should set `startLocation = 0` and `endLocation = 1`.
     *
     * @since 4.9.17
     * @default 0.5
     * @param  value  Break end location
     */
    set: function set(value) {
      if (this.setPropertyValue("endLocation", value)) {
        if (this.axis) {
          this.axis.invalidateDataItems();
          this.axis.invalidateSeries();
        }
      }
    },
    enumerable: true,
    configurable: true
  });
  return CategoryAxisBreak;
}(_AxisBreak__WEBPACK_IMPORTED_MODULE_1__["AxisBreak"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_2__["registry"].registeredClasses["CategoryAxisBreak"] = CategoryAxisBreak;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/DateAxis.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/axes/DateAxis.js ***!
  \****************************************************************************/
/*! exports provided: DateAxisDataItem, DateAxis */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DateAxisDataItem", function() { return DateAxisDataItem; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DateAxis", function() { return DateAxis; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _ValueAxis__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ValueAxis */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/ValueAxis.js");
/* harmony import */ var _core_utils_List__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/utils/List */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/List.js");
/* harmony import */ var _core_utils_Dictionary__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/utils/Dictionary */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Dictionary.js");
/* harmony import */ var _DateAxisBreak__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./DateAxisBreak */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/DateAxisBreak.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core/utils/Time */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Time.js");
/* harmony import */ var _core_utils_Type__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../core/utils/Type */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Type.js");
/* harmony import */ var _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../core/utils/Iterator */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Iterator.js");
/* harmony import */ var _core_utils_Math__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../core/utils/Math */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Math.js");
/* harmony import */ var _core_utils_Array__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../core/utils/Array */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Array.js");
/* harmony import */ var _core_utils_Object__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../core/utils/Object */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Object.js");
/* harmony import */ var _core_utils_Utils__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../core/utils/Utils */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Utils.js");
/* harmony import */ var _core_utils_SortedList__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../core/utils/SortedList */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/SortedList.js");
/**
 * DateAxis module
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */














/**
 * ============================================================================
 * DATA ITEM
 * ============================================================================
 * @hidden
 */

/**
 * Defines data item for [[DateAxis]].
 *
 * @see {@link DataItem}
 */

var DateAxisDataItem =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(DateAxisDataItem, _super);
  /**
   * Constructor
   */


  function DateAxisDataItem() {
    var _this = _super.call(this) || this;

    _this.className = "DateAxisDataItem";

    _this.applyTheme();

    _this.values.date = {};
    _this.values.endDate = {};
    return _this;
  }

  Object.defineProperty(DateAxisDataItem.prototype, "date", {
    /**
     * @return Date
     */
    get: function get() {
      return this.dates["date"];
    },

    /**
     * Date position of the data item.
     *
     * @param date  Date
     */
    set: function set(date) {
      this.setDate("date", date);
      this.value = date.getTime();
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(DateAxisDataItem.prototype, "endDate", {
    /**
     * @return End date
     */
    get: function get() {
      return this.dates["endDate"];
    },

    /**
     * End date for data item.
     *
     * @param date End date
     */
    set: function set(date) {
      this.setDate("endDate", date);
      this.endValue = date.getTime();
    },
    enumerable: true,
    configurable: true
  });
  return DateAxisDataItem;
}(_ValueAxis__WEBPACK_IMPORTED_MODULE_1__["ValueAxisDataItem"]);


/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Used to create a date/time-based axis for the chart.
 *
 * ```TypeScript
 * // Create the axis
 * let xAxis = chart.xAxes.push(new am4charts.DateAxis());
 *
 * // Set settings
 * xAxis.title.text = "Time";
 * ```
 * ```JavaScript
 * // Create the axis
 * var valueAxis = chart.xAxes.push(new am4charts.DateAxis());
 *
 * // Set settings
 * valueAxis.title.text = "Time";
 * ```
 * ```JSON
 * "xAxes": [{
 *   "type": "DateAxis",
 *   "title": {
 *     "text": "Time"
 *   }
 * }]
 * ```
 *
 * @see {@link IDateAxisEvents} for a list of available Events
 * @see {@link IDateAxisAdapters} for a list of available Adapters
 * @see {@link https://www.amcharts.com/docs/v4/concepts/axes/date-axis/} got `DateAxis` documention
 * @important
 */

var DateAxis =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(DateAxis, _super);
  /**
   * Constructor
   */


  function DateAxis() {
    var _this = // Init
    _super.call(this) || this;

    _this._gapBreaks = false;
    /**
     * A list of date/time intervals for Date axis.
     *
     * This define various granularities available for the axis. For example
     * if you have an axis spanning an hour, and space for 6 grid lines / labels
     * the axis will choose the granularity of 10 minutes, displaying a label
     * every 10 minutes.
     *
     * Default intervals:
     *
     * ```JSON
     * [
     *  { timeUnit: "millisecond", count: 1 },
     *  { timeUnit: "millisecond", count: 5 },
     *  { timeUnit: "millisecond", count: 10 },
     *  { timeUnit: "millisecond", count: 50 },
     *  { timeUnit: "millisecond", count: 100 },
     *  { timeUnit: "millisecond", count: 500 },
     *  { timeUnit: "second", count: 1 },
     *  { timeUnit: "second", count: 5 },
     *  { timeUnit: "second", count: 10 },
     *  { timeUnit: "second", count: 30 },
     *  { timeUnit: "minute", count: 1 },
     *  { timeUnit: "minute", count: 5 },
     *  { timeUnit: "minute", count: 10 },
     *  { timeUnit: "minute", count: 30 },
     *  { timeUnit: "hour", count: 1 },
     *  { timeUnit: "hour", count: 3 },
     *  { timeUnit: "hour", count: 6 },
     *  { timeUnit: "hour", count: 12 },
     *  { timeUnit: "day", count: 1 },
     *  { timeUnit: "day", count: 2 },
     *  { timeUnit: "day", count: 3 },
     *  { timeUnit: "day", count: 4 },
     *  { timeUnit: "day", count: 5 },
     *  { timeUnit: "week", count: 1 },
     *  { timeUnit: "month", count: 1 },
     *  { timeUnit: "month", count: 2 },
     *  { timeUnit: "month", count: 3 },
     *  { timeUnit: "month", count: 6 },
     *  { timeUnit: "year", count: 1 },
     *  { timeUnit: "year", count: 2 },
     *  { timeUnit: "year", count: 5 },
     *  { timeUnit: "year", count: 10 },
     *  { timeUnit: "year", count: 50 },
     *  { timeUnit: "year", count: 100 }
     * ]
     * ```
     */

    _this.gridIntervals = new _core_utils_List__WEBPACK_IMPORTED_MODULE_2__["List"]();
    /**
     * If data aggregation is enabled by setting Axis' `groupData = true`, the
     * chart will try to aggregate data items into grouped data items.
     *
     * If there are more data items in selected period than `groupCount`, it will
     * group data items into bigger period.
     *
     * For example seconds might be grouped into 10-second aggregate data items.
     *
     * This setting indicates what group intervals can the chart group to.
     *
     * Default intervals:
     *
     * ```JSON
     * [
     *   { timeUnit: "millisecond", count: 1},
     *   { timeUnit: "millisecond", count: 10 },
     *   { timeUnit: "millisecond", count: 100 },
     *   { timeUnit: "second", count: 1 },
     *   { timeUnit: "second", count: 10 },
     *   { timeUnit: "minute", count: 1 },
     *   { timeUnit: "minute", count: 10 },
     *   { timeUnit: "hour", count: 1 },
     *   { timeUnit: "day", count: 1 },
     *   { timeUnit: "week", count: 1 },
     *   { timeUnit: "month", count: 1 },
     *   { timeUnit: "year", count: 1 }
     * ]
     * ```
     * `groupData = true` does not work in combination with `skipEmptyPeriods = true`.
     *
     * @since 4.7.0
     * @see {@link https://www.amcharts.com/docs/v4/concepts/axes/date-axis/#Dynamic_data_item_grouping} for more information about dynamic data item grouping.
     */

    _this.groupIntervals = new _core_utils_List__WEBPACK_IMPORTED_MODULE_2__["List"]();
    /**
     * A collection of date formats to use when formatting different time units
     * on Date/time axis.
     *
     * Actual defaults will depend on the language locale set for the chart.
     *
     * To override format for a specific time unit, say days, you need to set
     * the appropriate key to a format string. E.g.:
     *
     * ```TypeScript
     * axis.dateFormats.setKey("day", "MMMM d, yyyy");
     * ```
     * ```JavaScript
     * axis.dateFormats.setKey("day", "MMMM d, yyyy");
     * ```
     * ```JSON
     * "xAxes": [{
     *   "type": "DateAxis",
     *   "dateFormats": {
     *     "day": "MMMM d, yyyy"
     *   }
     * }]
     * ```
     *
     * @see {@link DateFormatter}
     */

    _this.dateFormats = new _core_utils_Dictionary__WEBPACK_IMPORTED_MODULE_3__["Dictionary"]();
    /**
     * These formats are applied to labels that are first in a larger unit.
     *
     * For example, if we have a DateAxis with days on it, the first day of month
     * indicates a break in month - a start of the bigger period.
     *
     * For those labels, `periodChangeDateFormats` are applied instead of
     * `dateFormats`.
     *
     * This allows us implement convenient structures, like instead of:
     *
     * `Jan 1 - Jan 2 - Jan 3 - ...`
     *
     * We can have:
     *
     * `Jan - 1 - 2 - 3 - ...`
     *
     * This can be disabled by setting `markUnitChange = false`.
     */

    _this.periodChangeDateFormats = new _core_utils_Dictionary__WEBPACK_IMPORTED_MODULE_3__["Dictionary"]();
    /**
     * Actual interval (granularity) derived from the actual data.
     */

    _this._baseIntervalReal = {
      timeUnit: "day",
      count: 1
    };
    /**
     */

    _this._prevSeriesTime = {};
    /**
     * [_minDifference description]
     *
     * @todo Description
     */

    _this._minDifference = {};
    /**
     * @ignore
     */

    _this._firstWeekDay = 1;
    /**
     * A collection of start timestamps to use as axis' min timestamp for
     * particular data item item periods.
     *
     * @since 4.7.0
     * @readonly
     */

    _this.groupMin = {};
    /**
     * A collection of start timestamps to use as axis' max timestamp for
     * particular data item item periods.
     *
     * @since 4.7.0
     * @readonly
     */

    _this.groupMax = {};
    _this.className = "DateAxis";

    _this.setPropertyValue("markUnitChange", true);

    _this.snapTooltip = true;
    _this.tooltipPosition = "pointer";

    _this.setPropertyValue("groupData", false);

    _this.groupCount = 200;

    _this.events.on("parentset", _this.getDFFormatter, _this, false); // Translatable defaults are applied in `applyInternalDefaults()`
    // ...
    // Define default intervals


    _this.gridIntervals.pushAll([{
      timeUnit: "millisecond",
      count: 1
    }, {
      timeUnit: "millisecond",
      count: 5
    }, {
      timeUnit: "millisecond",
      count: 10
    }, {
      timeUnit: "millisecond",
      count: 50
    }, {
      timeUnit: "millisecond",
      count: 100
    }, {
      timeUnit: "millisecond",
      count: 500
    }, {
      timeUnit: "second",
      count: 1
    }, {
      timeUnit: "second",
      count: 5
    }, {
      timeUnit: "second",
      count: 10
    }, {
      timeUnit: "second",
      count: 30
    }, {
      timeUnit: "minute",
      count: 1
    }, {
      timeUnit: "minute",
      count: 5
    }, {
      timeUnit: "minute",
      count: 10
    }, {
      timeUnit: "minute",
      count: 15
    }, {
      timeUnit: "minute",
      count: 30
    }, {
      timeUnit: "hour",
      count: 1
    }, {
      timeUnit: "hour",
      count: 3
    }, {
      timeUnit: "hour",
      count: 6
    }, {
      timeUnit: "hour",
      count: 12
    }, {
      timeUnit: "day",
      count: 1
    }, {
      timeUnit: "day",
      count: 2
    }, {
      timeUnit: "day",
      count: 3
    }, {
      timeUnit: "day",
      count: 4
    }, {
      timeUnit: "day",
      count: 5
    }, {
      timeUnit: "week",
      count: 1
    }, {
      timeUnit: "month",
      count: 1
    }, {
      timeUnit: "month",
      count: 2
    }, {
      timeUnit: "month",
      count: 3
    }, {
      timeUnit: "month",
      count: 6
    }, {
      timeUnit: "year",
      count: 1
    }, {
      timeUnit: "year",
      count: 2
    }, {
      timeUnit: "year",
      count: 5
    }, {
      timeUnit: "year",
      count: 10
    }, {
      timeUnit: "year",
      count: 50
    }, {
      timeUnit: "year",
      count: 100
    }, {
      timeUnit: "year",
      count: 200
    }, {
      timeUnit: "year",
      count: 500
    }, {
      timeUnit: "year",
      count: 1000
    }, {
      timeUnit: "year",
      count: 2000
    }, {
      timeUnit: "year",
      count: 5000
    }, {
      timeUnit: "year",
      count: 10000
    }, {
      timeUnit: "year",
      count: 100000
    }]);

    _this.groupIntervals.pushAll([{
      timeUnit: "millisecond",
      count: 1
    }, {
      timeUnit: "millisecond",
      count: 10
    }, {
      timeUnit: "millisecond",
      count: 100
    }, {
      timeUnit: "second",
      count: 1
    }, {
      timeUnit: "second",
      count: 10
    }, {
      timeUnit: "minute",
      count: 1
    }, {
      timeUnit: "minute",
      count: 10
    }, {
      timeUnit: "hour",
      count: 1
    }, {
      timeUnit: "day",
      count: 1
    }, {
      timeUnit: "week",
      count: 1
    }, {
      timeUnit: "month",
      count: 1
    }, {
      timeUnit: "year",
      count: 1
    }]); // Set field name


    _this.axisFieldName = "date"; // Apply theme

    _this.applyTheme();

    return _this;
  }
  /**
   * A function which applies fills to axis cells.
   *
   * Default function fills every second fill. You can set this to a function
   * that follows some other logic.
   *
   * Function should accept a [[DateAxisDataItem]] and modify its `axisFill`
   * property accordingly.
   */


  DateAxis.prototype.fillRule = function (dataItem) {
    var value = dataItem.value;
    var axis = dataItem.component;
    var gridInterval = axis._gridInterval;
    var gridDuration = _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["getDuration"](gridInterval.timeUnit, gridInterval.count);

    if (Math.round((value - axis.min) / gridDuration) / 2 == Math.round(Math.round((value - axis.min) / gridDuration) / 2)) {
      dataItem.axisFill.__disabled = true;
    } else {
      dataItem.axisFill.__disabled = false;
    }
  };
  /**
   * Sets defaults that instantiate some objects that rely on parent, so they
   * cannot be set in constructor.
   */


  DateAxis.prototype.applyInternalDefaults = function () {
    _super.prototype.applyInternalDefaults.call(this); // Set default date formats


    if (!this.dateFormats.hasKey("millisecond")) {
      this.dateFormats.setKey("millisecond", this.language.translate("_date_millisecond"));
    }

    if (!this.dateFormats.hasKey("second")) {
      this.dateFormats.setKey("second", this.language.translate("_date_second"));
    }

    if (!this.dateFormats.hasKey("minute")) {
      this.dateFormats.setKey("minute", this.language.translate("_date_minute"));
    }

    if (!this.dateFormats.hasKey("hour")) {
      this.dateFormats.setKey("hour", this.language.translate("_date_hour"));
    }

    if (!this.dateFormats.hasKey("day")) {
      this.dateFormats.setKey("day", this.language.translate("_date_day"));
    }

    if (!this.dateFormats.hasKey("week")) {
      this.dateFormats.setKey("week", this.language.translate("_date_day")); // not a mistake
    }

    if (!this.dateFormats.hasKey("month")) {
      this.dateFormats.setKey("month", this.language.translate("_date_month"));
    }

    if (!this.dateFormats.hasKey("year")) {
      this.dateFormats.setKey("year", this.language.translate("_date_year"));
    }

    if (!this.periodChangeDateFormats.hasKey("millisecond")) {
      this.periodChangeDateFormats.setKey("millisecond", this.language.translate("_date_millisecond"));
    }

    if (!this.periodChangeDateFormats.hasKey("second")) {
      this.periodChangeDateFormats.setKey("second", this.language.translate("_date_second"));
    }

    if (!this.periodChangeDateFormats.hasKey("minute")) {
      this.periodChangeDateFormats.setKey("minute", this.language.translate("_date_minute"));
    }

    if (!this.periodChangeDateFormats.hasKey("hour")) {
      this.periodChangeDateFormats.setKey("hour", this.language.translate("_date_day"));
    }

    if (!this.periodChangeDateFormats.hasKey("day")) {
      this.periodChangeDateFormats.setKey("day", this.language.translate("_date_day"));
    }

    if (!this.periodChangeDateFormats.hasKey("week")) {
      this.periodChangeDateFormats.setKey("week", this.language.translate("_date_day"));
    }

    if (!this.periodChangeDateFormats.hasKey("month")) {
      this.periodChangeDateFormats.setKey("month", this.language.translate("_date_month") + " " + this.language.translate("_date_year"));
    }
  };
  /**
   * Returns a new/empty [[DataItem]] of the type appropriate for this object.
   *
   * @see {@link DataItem}
   * @return Data Item
   */


  DateAxis.prototype.createDataItem = function () {
    return new DateAxisDataItem();
  };
  /**
   * Returns a new/empty [[AxisBreak]] of the appropriate type.
   *
   * @return Axis break
   */


  DateAxis.prototype.createAxisBreak = function () {
    return new _DateAxisBreak__WEBPACK_IMPORTED_MODULE_4__["DateAxisBreak"]();
  };
  /**
   * Validates Axis' data items.
   *
   * @ignore Exclude from docs
   */


  DateAxis.prototype.validateDataItems = function () {
    // allows to keep selection of the same size
    var start = this.start;
    var end = this.end;
    var baseDuration = this.baseDuration;
    var periodCount = (this.max - this.min) / baseDuration;
    this._firstWeekDay = this.getFirstWeekDay();
    this.getDFFormatter();

    _super.prototype.validateDataItems.call(this);

    var mainBaseDuration = _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["getDuration"](this.mainBaseInterval.timeUnit, this.mainBaseInterval.count);
    this.maxZoomFactor = Math.max(1, (this.max - this.min) / mainBaseDuration);
    this._deltaMinMax = this.baseDuration / 2; // allows to keep selection of the same size

    var newPeriodCount = (this.max - this.min) / baseDuration;
    start = start + (end - start) * (1 - periodCount / newPeriodCount);
    this.zoom({
      start: start,
      end: end
    }, false, true); // added instantlyto solve zoomout problem when we have axes gaps. @todo: check how this affects maxZoomFactor
  };
  /**
   * Handles process after zoom.
   *
   * @ignore Exclude from docs
   * @todo Does nothing?
   */


  DateAxis.prototype.handleSelectionExtremesChange = function () {};
  /**
   * Calculates all positions, related to axis as per current zoom.
   *
   * @ignore Exclude from docs
   */


  DateAxis.prototype.calculateZoom = function () {
    var _this = this;

    _super.prototype.calculateZoom.call(this);

    var difference = this.adjustDifference(this._minZoomed, this._maxZoomed);
    var dataSetChanged = false; // if data has to be grouped, choose interval and set dataset

    if (this.groupData && _core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["hasValue"](difference)) {
      var mainBaseInterval = this.mainBaseInterval;
      var modifiedDifference = difference + (this.startLocation + (1 - this.endLocation)) * this.baseDuration;
      var groupInterval = void 0;

      if (this.groupInterval) {
        groupInterval = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, this.groupInterval);
      } else {
        groupInterval = this.chooseInterval(0, modifiedDifference, this.groupCount, this.groupIntervals);

        if (_core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["getDuration"](groupInterval.timeUnit, groupInterval.count) < _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["getDuration"](mainBaseInterval.timeUnit, mainBaseInterval.count)) {
          groupInterval = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, mainBaseInterval);
        }
      }

      this._groupInterval = groupInterval;
      var newId = groupInterval.timeUnit + groupInterval.count;

      if (this._currentDataSetId != newId) {
        this._currentDataSetId = newId;
        this.dispatch("groupperiodchanged");
      }

      this.series.each(function (series) {
        if (series.baseAxis == _this) {
          if (series.setDataSet(_this._currentDataSetId)) {
            dataSetChanged = true;
          }
        }
      });
    }

    var gridInterval = this.chooseInterval(0, difference, this._gridCount);

    if (_core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["getDuration"](gridInterval.timeUnit, gridInterval.count) < this.baseDuration) {
      gridInterval = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, this.baseInterval);
    }

    this._gridInterval = gridInterval;
    this._nextGridUnit = _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["getNextUnit"](gridInterval.timeUnit); // the following is needed to avoid grid flickering while scrolling

    this._intervalDuration = _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["getDuration"](gridInterval.timeUnit, gridInterval.count);
    this._gridDate = _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["round"](new Date(this.minZoomed - _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["getDuration"](gridInterval.timeUnit, gridInterval.count)), gridInterval.timeUnit, gridInterval.count, this._firstWeekDay, this._df.utc, new Date(this.min), this._df.timezoneMinutes, this._df.timezone); // tell series start/end

    _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_8__["each"](this.series.iterator(), function (series) {
      if (series.baseAxis == _this) {
        var field_1 = series.getAxisField(_this);
        var minZoomed = _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["round"](new Date(_this._minZoomed + _this.baseDuration * 0.05), _this.baseInterval.timeUnit, _this.baseInterval.count, _this._firstWeekDay, _this._df.utc, undefined, _this._df.timezoneMinutes, _this._df.timezone).getTime();
        var minZoomedStr = minZoomed.toString();
        var startDataItem = series.dataItemsByAxis.getKey(_this.uid).getKey(minZoomedStr + series.currentDataSetId);
        var startIndex = 0;

        if (_this.start != 0) {
          if (startDataItem) {
            startDataItem = _this.findFirst(startDataItem, minZoomed, field_1);
            startIndex = startDataItem.index;
          } else {
            startIndex = series.dataItems.findClosestIndex(_this._minZoomed, function (x) {
              return x[field_1];
            }, "left");
          }
        } // 1 millisecond is removed so that if only first item is selected, it would not count in the second.


        var baseInterval = _this.baseInterval;
        var maxZoomed = _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["add"](_core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["round"](new Date(_this._maxZoomed), baseInterval.timeUnit, baseInterval.count, _this._firstWeekDay, _this._df.utc, undefined, _this._df.timezoneMinutes, _this._df.timezone), baseInterval.timeUnit, baseInterval.count, _this._df.utc).getTime();
        var maxZoomedStr = maxZoomed.toString();
        var endDataItem = series.dataItemsByAxis.getKey(_this.uid).getKey(maxZoomedStr + series.currentDataSetId);
        var endIndex = series.dataItems.length;

        if (_this.end != 1) {
          if (endDataItem) {
            endIndex = endDataItem.index;
          } else {
            maxZoomed -= 1;
            endIndex = series.dataItems.findClosestIndex(maxZoomed, function (x) {
              return x[field_1];
            }, "right"); // not good - if end is in the gap, indexes go like 5,4,3,4,2,1
            //if (endIndex < series.dataItems.length) {

            endIndex++; //}
          }
        }

        if (series.max(_this) < minZoomed) {
          series.startIndex = series.dataItems.length;
          series.endIndex = series.dataItems.length;
          series.outOfRange = true;
        } else if (series.min(_this) > maxZoomed) {
          series.startIndex = 0;
          series.endIndex = 0;
          series.outOfRange = true;
        } else {
          series.outOfRange = false;
          series.startIndex = startIndex;
          series.endIndex = endIndex;
        } //	console.log(series.name, startIndex, endIndex);


        if (!dataSetChanged && series.dataRangeInvalid) {
          series.validateDataRange();
        }
      }
    });
  };

  DateAxis.prototype.findFirst = function (dataItem, time, key) {
    var index = dataItem.index;

    if (index > 0) {
      var series = dataItem.component;
      var previousDataItem = series.dataItems.getIndex(index - 1);
      var previousDate = previousDataItem[key];

      if (!previousDate || previousDate.getTime() < time) {
        return dataItem;
      } else {
        return this.findFirst(previousDataItem, time, key);
      }
    } else {
      return dataItem;
    }
  };
  /**
   * (Re)validates data.
   *
   * @ignore Exclude from docs
   */


  DateAxis.prototype.validateData = function () {
    _super.prototype.validateData.call(this);

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["isNumber"](this.baseInterval.count)) {
      this.baseInterval.count = 1;
    }
  };

  Object.defineProperty(DateAxis.prototype, "minDifference", {
    /**
     * @ignore
     */
    get: function get() {
      var _this = this;

      var minDifference = Number.MAX_VALUE;
      this.series.each(function (series) {
        if (minDifference > _this._minDifference[series.uid]) {
          minDifference = _this._minDifference[series.uid];
        }
      });

      if (minDifference == Number.MAX_VALUE || minDifference == 0) {
        minDifference = _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["getDuration"]("day");
      }

      return minDifference;
    },
    enumerable: true,
    configurable: true
  });
  /**
   * [dataChangeUpdate description]
   *
   *
   * @ignore Exclude from docs
   * @todo Description
   */

  DateAxis.prototype.seriesDataChangeUpdate = function (series) {
    this._minDifference[series.uid] = Number.MAX_VALUE;
  };
  /**
   * [postProcessSeriesDataItems description]
   *
   * @ignore Exclude from docs
   * @todo Description
   */


  DateAxis.prototype.postProcessSeriesDataItems = function (series) {
    var _this = this;

    this._firstWeekDay = this.getFirstWeekDay();

    if (series) {
      this.seriesGroupUpdate(series);
    } else {
      this.series.each(function (series) {
        _this.seriesGroupUpdate(series);
      });
    }

    this.addEmptyUnitsBreaks();
  };

  DateAxis.prototype.seriesGroupUpdate = function (series) {
    var _this = this;

    if (JSON.stringify(series._baseInterval[this.uid]) != JSON.stringify(this.mainBaseInterval)) {
      series._baseInterval[this.uid] = this.mainBaseInterval;
      series.mainDataSet.each(function (dataItem) {
        _this.postProcessSeriesDataItem(dataItem);
      });

      if (this.groupData) {
        this.groupSeriesData(series);
      }
    }
  };
  /**
   * Calculates series group data.
   *
   * @param  series  Series
   * @ignore
   */


  DateAxis.prototype.groupSeriesData = function (series) {
    var _this = this;

    if (series.baseAxis == this && series.dataItems.length > 0 && !series.dataGrouped) {
      series.bulletsContainer.removeChildren(); // make array of intervals which will be used;

      var intervals_1 = [];
      var mainBaseInterval = this.mainBaseInterval;
      var mainIntervalDuration_1 = _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["getDuration"](mainBaseInterval.timeUnit, mainBaseInterval.count);
      this.groupIntervals.each(function (interval) {
        var intervalDuration = _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["getDuration"](interval.timeUnit, interval.count);

        if (intervalDuration > mainIntervalDuration_1 && intervalDuration < _this.max - _this.min || _this.groupInterval) {
          intervals_1.push(interval);
        }
      });

      if (series._dataSets) {
        series._dataSets.each(function (key, dataItems) {
          dataItems.each(function (dataItem) {
            dataItem.dispose();
          });
          dataItems.clear();
        });

        series._dataSets.clear();
      }

      series.dataGrouped = true;
      _core_utils_Array__WEBPACK_IMPORTED_MODULE_10__["each"](intervals_1, function (interval) {
        //let mainBaseInterval = this._mainBaseInterval;
        var key = "date" + _this.axisLetter; // create data set

        var dataSetId = interval.timeUnit + interval.count; // todo: check where this clone goes

        var dataSet = new _core_utils_SortedList__WEBPACK_IMPORTED_MODULE_13__["OrderedListTemplate"](series.mainDataSet.template.clone());
        series.dataSets.setKey(dataSetId, dataSet);
        var dataItems = series.mainDataSet;
        var previousTime = Number.NEGATIVE_INFINITY;
        var i = 0;
        var newDataItem;
        var dataFields = [];
        _core_utils_Object__WEBPACK_IMPORTED_MODULE_11__["each"](series.dataFields, function (dfkey, df) {
          var dfk = dfkey;

          if (dfk != key && dfk.indexOf("Show") == -1) {
            dataFields.push(dfk);
          }
        });
        var roundedDate;
        dataItems.each(function (dataItem) {
          var date = dataItem.getDate(key);

          if (date) {
            var time = date.getTime();
            roundedDate = _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["round"](new Date(time), interval.timeUnit, interval.count, _this._df.firstDayOfWeek, _this._df.utc, undefined, _this._df.timezoneMinutes, _this._df.timezone);
            var currentTime = roundedDate.getTime(); // changed period								

            if (previousTime < currentTime) {
              if (newDataItem && series._adapterO) {
                _core_utils_Array__WEBPACK_IMPORTED_MODULE_10__["each"](dataFields, function (vkey) {
                  newDataItem.values[vkey].value = series._adapterO.apply("groupDataItem", {
                    dataItem: newDataItem,
                    interval: interval,
                    dataField: vkey,
                    date: roundedDate,
                    value: newDataItem.values[vkey].value
                  }).value;
                  newDataItem.values[vkey].workingValue = newDataItem.values[vkey].value;
                });
              }

              newDataItem = dataSet.create();
              newDataItem.dataContext = {};
              newDataItem.setWorkingLocation("dateX", series.dataItems.template.locations.dateX, 0);
              newDataItem.setWorkingLocation("openDateX", series.dataItems.template.locations.openDateX, 0);
              newDataItem.setWorkingLocation("dateY", series.dataItems.template.locations.dateY, 0);
              newDataItem.setWorkingLocation("openDateY", series.dataItems.template.locations.openDateY, 0);
              newDataItem.component = series; // other Dates?

              newDataItem.setDate(key, roundedDate);
              newDataItem._index = i;
              i++;
              _core_utils_Array__WEBPACK_IMPORTED_MODULE_10__["each"](dataFields, function (vkey) {
                //let groupFieldName = vkey + "Group";
                var dvalues = dataItem.values[vkey];

                if (dvalues) {
                  var value = dvalues.value;

                  if (series._adapterO) {
                    value = series._adapterO.apply("groupValue", {
                      dataItem: dataItem,
                      interval: interval,
                      dataField: vkey,
                      date: roundedDate,
                      value: value
                    }).value;
                  }

                  var values = newDataItem.values[vkey];

                  if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["isNumber"](value)) {
                    values.value = value;
                    values.workingValue = value;
                    values.open = value;
                    values.close = value;
                    values.low = value;
                    values.high = value;
                    values.sum = value;
                    values.average = value;
                    values.count = 1;
                  } else {
                    values.count = 0;
                  }
                }
              });

              _this.postProcessSeriesDataItem(newDataItem, interval);

              _core_utils_Object__WEBPACK_IMPORTED_MODULE_11__["each"](series.propertyFields, function (key, fieldValue) {
                var f = key;
                var value = dataItem.properties[key];

                if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["hasValue"](value)) {
                  newDataItem.hasProperties = true;
                  newDataItem.setProperty(f, value);
                }
              });
              newDataItem.groupDataItems = [dataItem];
              previousTime = currentTime;
            } else {
              if (newDataItem) {
                _core_utils_Array__WEBPACK_IMPORTED_MODULE_10__["each"](dataFields, function (vkey) {
                  var groupFieldName = series.groupFields[vkey];
                  var dvalues = dataItem.values[vkey];

                  if (dvalues) {
                    var value = dvalues.value;

                    if (series._adapterO) {
                      value = series._adapterO.apply("groupValue", {
                        dataItem: dataItem,
                        interval: interval,
                        dataField: vkey,
                        date: roundedDate,
                        value: value
                      }).value;
                    }

                    if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["isNumber"](value)) {
                      var values = newDataItem.values[vkey];

                      if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["isNumber"](values.open)) {
                        values.open = value;
                      }

                      values.close = value;

                      if (values.low > value || !_core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["isNumber"](values.low)) {
                        values.low = value;
                      }

                      if (values.high < value || !_core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["isNumber"](values.high)) {
                        values.high = value;
                      }

                      if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["isNumber"](values.sum)) {
                        values.sum += value;
                      } else {
                        values.sum = value;
                      }

                      values.count++;
                      values.average = values.sum / values.count;

                      if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["isNumber"](values[groupFieldName])) {
                        values.value = values[groupFieldName];
                        values.workingValue = values.value;
                      }
                    }
                  }
                });
                _core_utils_Utils__WEBPACK_IMPORTED_MODULE_12__["copyProperties"](dataItem.properties, newDataItem.properties);
                _core_utils_Object__WEBPACK_IMPORTED_MODULE_11__["each"](series.propertyFields, function (key, fieldValue) {
                  var f = key;
                  var value = dataItem.properties[key];

                  if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["hasValue"](value)) {
                    newDataItem.hasProperties = true;
                    newDataItem.setProperty(f, value);
                  }
                });
                newDataItem.groupDataItems.push(dataItem);
              }
            }
          }

          if (newDataItem) {
            _core_utils_Utils__WEBPACK_IMPORTED_MODULE_12__["copyProperties"](dataItem.dataContext, newDataItem.dataContext);
          }
        });

        if (newDataItem && series._adapterO) {
          _core_utils_Array__WEBPACK_IMPORTED_MODULE_10__["each"](dataFields, function (vkey) {
            newDataItem.values[vkey].value = series._adapterO.apply("groupDataItem", {
              dataItem: newDataItem,
              interval: interval,
              dataField: vkey,
              date: roundedDate,
              value: newDataItem.values[vkey].value
            }).value;
            newDataItem.values[vkey].workingValue = newDataItem.values[vkey].value;
          });
        }
      });
      this.calculateZoom();
    }
  };
  /**
   * @ignore
   */


  DateAxis.prototype.getDFFormatter = function () {
    this._df = this.dateFormatter;
  };
  /**
   * [postProcessSeriesDataItem description]
   *
   * @ignore Exclude from docs
   * @todo Description
   * @param dataItem Data item
   */


  DateAxis.prototype.postProcessSeriesDataItem = function (dataItem, interval) {
    var _this = this; // we need to do this for all series data items not only added recently, as baseInterval might change


    var intervalID = "";

    if (interval) {
      intervalID = interval.timeUnit + interval.count;
    } else {
      interval = this.mainBaseInterval;
    }

    var series = dataItem.component;
    var dataItemsByAxis = series.dataItemsByAxis.getKey(this.uid);
    _core_utils_Object__WEBPACK_IMPORTED_MODULE_11__["each"](dataItem.dates, function (key) {
      var date = dataItem.getDate(key);
      var time = date.getTime();
      var startDate = _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["round"](new Date(time), interval.timeUnit, interval.count, _this._firstWeekDay, _this._df.utc, undefined, _this._df.timezoneMinutes, _this._df.timezone);
      var startTime = startDate.getTime();
      var endDate = _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["add"](new Date(startTime), interval.timeUnit, interval.count, _this._df.utc);
      dataItem.setCalculatedValue(key, startTime, "open");
      dataItem.setCalculatedValue(key, endDate.getTime(), "close");
      dataItemsByAxis.setKey(startTime + intervalID, dataItem);
    });
  };
  /**
   * Collapses empty stretches of date/time scale by creating [[AxisBreak]]
   * elements for them.
   *
   * Can be used to automatically remove strethes without data, like weekends.
   *
   * No, need to call this manually. It will automatically be done if
   * `skipEmptyPeriods = true`.
   *
   * @ignore Exclude from docs
   */


  DateAxis.prototype.addEmptyUnitsBreaks = function () {
    var _this = this;

    if (this.skipEmptyPeriods && _core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["isNumber"](this.min) && _core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["isNumber"](this.max)) {
      var timeUnit = this.baseInterval.timeUnit;
      var count = this.baseInterval.count;

      if (this._axisBreaks) {
        this._axisBreaks.clear(); // TODO: what about breaks added by user?

      }

      var date = _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["round"](new Date(this.min), timeUnit, count, this._firstWeekDay, this._df.utc, undefined, this._df.timezoneMinutes, this._df.timezone);
      var axisBreak = void 0;

      var _loop_1 = function _loop_1() {
        _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["add"](date, timeUnit, count, this_1._df.utc);
        var startTime = date.getTime();
        var startTimeStr = startTime.toString();
        var hasData = _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_8__["contains"](this_1.series.iterator(), function (series) {
          return !!series.dataItemsByAxis.getKey(_this.uid).getKey(startTimeStr + series.currentDataSetId);
        }); // open break if not yet opened

        if (!hasData) {
          if (!axisBreak) {
            axisBreak = this_1.axisBreaks.create();
            axisBreak.startDate = new Date(startTime);
            this_1._gapBreaks = true;
          }
        } else {
          // close if already opened
          if (axisBreak) {
            // close at end time minus one millisecond
            axisBreak.endDate = new Date(startTime - 1);
            axisBreak = undefined;
          }
        }
      };

      var this_1 = this;

      while (date.getTime() < this.max - this.baseDuration) {
        _loop_1();
      }
    }
  };
  /**
   * Updates positioning of Axis breaks after something changes.
   *
   * @ignore Exclude from docs
   */


  DateAxis.prototype.fixAxisBreaks = function () {
    var _this = this;

    _super.prototype.fixAxisBreaks.call(this);

    var axisBreaks = this._axisBreaks;

    if (axisBreaks) {
      if (axisBreaks.length > 0) {
        // process breaks
        axisBreaks.each(function (axisBreak) {
          var breakGridCount = Math.ceil(_this._gridCount * (Math.min(_this.end, axisBreak.endPosition) - Math.max(_this.start, axisBreak.startPosition)) / (_this.end - _this.start));
          axisBreak.gridInterval = _this.chooseInterval(0, axisBreak.adjustedEndValue - axisBreak.adjustedStartValue, breakGridCount);
          var gridDate = _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["round"](new Date(axisBreak.adjustedStartValue), axisBreak.gridInterval.timeUnit, axisBreak.gridInterval.count, _this._firstWeekDay, _this._df.utc, undefined, _this._df.timezoneMinutes, _this._df.timezone);

          if (gridDate.getTime() > axisBreak.startDate.getTime()) {
            _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["add"](gridDate, axisBreak.gridInterval.timeUnit, axisBreak.gridInterval.count, _this._df.utc);
          }

          axisBreak.gridDate = gridDate;
        });
      }
    }
  };
  /**
   * @ignore
   */


  DateAxis.prototype.getFirstWeekDay = function () {
    if (this._df) {
      return this._df.firstDayOfWeek;
    }

    return 1;
  };
  /**
   * [getGridDate description]
   *
   * @ignore Exclude from docs
   * @todo Description
   * @param date           [description]
   * @param intervalCount  [description]
   * @return [description]
   */


  DateAxis.prototype.getGridDate = function (date, intervalCount) {
    var timeUnit = this._gridInterval.timeUnit;
    var realIntervalCount = this._gridInterval.count; // round date

    _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["round"](date, timeUnit, 1, this._firstWeekDay, this._df.utc, undefined, this._df.timezoneMinutes, this._df.timezone);
    var prevTimestamp = date.getTime();
    var newDate = _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["copy"](date); // modify date by adding intervalcount

    var timestamp = _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["add"](newDate, timeUnit, intervalCount, this._df.utc).getTime(); // if it's axis break, get first rounded date which is not in a break

    var axisBreak = this.isInBreak(timestamp);

    if (axisBreak && axisBreak.endDate) {
      newDate = new Date(axisBreak.endDate.getTime());
      _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["round"](newDate, timeUnit, realIntervalCount, this._firstWeekDay, this._df.utc, undefined, this._df.timezoneMinutes, this._df.timezone);

      if (newDate.getTime() < axisBreak.endDate.getTime()) {
        _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["add"](newDate, timeUnit, realIntervalCount, this._df.utc);
      }

      timestamp = newDate.getTime();
    } // get duration between grid lines with break duration removed


    var durationBreaksRemoved = this.adjustDifference(prevTimestamp, timestamp); // calculate how many time units fit to this duration

    var countBreaksRemoved = Math.round(durationBreaksRemoved / _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["getDuration"](timeUnit)); // if less units fit, add one and repeat

    if (countBreaksRemoved < realIntervalCount) {
      return this.getGridDate(date, intervalCount + realIntervalCount);
    }

    return newDate;
  };
  /**
   * [getBreaklessDate description]
   *
   * @ignore Exclude from docs
   * @todo Description
   * @param axisBreak  [description]
   * @param timeUnit   [description]
   * @param count      [description]
   * @return [description]
   */


  DateAxis.prototype.getBreaklessDate = function (axisBreak, timeUnit, count) {
    var date = new Date(axisBreak.endValue);
    _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["round"](date, timeUnit, count, this._firstWeekDay, this._df.utc, undefined, this._df.timezoneMinutes, this._df.timezone);
    _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["add"](date, timeUnit, count, this._df.utc);
    var timestamp = date.getTime();
    axisBreak = this.isInBreak(timestamp);

    if (axisBreak) {
      return this.getBreaklessDate(axisBreak, timeUnit, count);
    }

    return date;
  };
  /**
   * (Re)validates all Axis elements.
   *
   * @ignore Exclude from docs
   * @todo Description (review)
   */


  DateAxis.prototype.validateAxisElements = function () {
    var _this = this;

    if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["isNumber"](this.max) && _core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["isNumber"](this.min)) {
      this.calculateZoom(); // first regular items

      var timestamp = this._gridDate.getTime();

      var timeUnit = this._gridInterval.timeUnit;
      var intervalCount = this._gridInterval.count;
      var prevGridDate = _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["copy"](this._gridDate);
      var dataItemsIterator_1 = this._dataItemsIterator;
      this.resetIterators();

      var _loop_2 = function _loop_2() {
        var date = this_2.getGridDate(_core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["copy"](prevGridDate), intervalCount);
        timestamp = date.getTime();
        var endDate = _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["copy"](date); // you might think it's easier to add intervalduration to timestamp, however it won't work for months or years which are not of the same length

        endDate = _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["add"](endDate, timeUnit, intervalCount, this_2._df.utc);
        var format = this_2.dateFormats.getKey(timeUnit);

        if (this_2.markUnitChange && prevGridDate) {
          if (_core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["checkChange"](date, prevGridDate, this_2._nextGridUnit, this_2._df.utc)) {
            if (timeUnit !== "year") {
              format = this_2.periodChangeDateFormats.getKey(timeUnit);
            }
          }
        }

        var text = this_2._df.format(date, format);

        var dataItem = dataItemsIterator_1.find(function (x) {
          return x.text === text;
        });

        if (dataItem.__disabled) {
          dataItem.__disabled = false;
        }

        this_2.appendDataItem(dataItem);
        dataItem.axisBreak = undefined;
        dataItem.date = date;
        dataItem.endDate = endDate;
        dataItem.text = text;
        this_2.validateDataElement(dataItem);
        prevGridDate = date;
      };

      var this_2 = this;

      while (timestamp <= this._maxZoomed) {
        _loop_2();
      } // breaks later


      var renderer_1 = this.renderer;

      if (this._axisBreaks) {
        _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_8__["each"](this._axisBreaks.iterator(), function (axisBreak) {
          if (axisBreak.breakSize > 0) {
            var timeUnit_1 = axisBreak.gridInterval.timeUnit;
            var intervalCount_1 = axisBreak.gridInterval.count; // only add grid if gap is bigger then minGridDistance

            if (_core_utils_Math__WEBPACK_IMPORTED_MODULE_9__["getDistance"](axisBreak.startPoint, axisBreak.endPoint) > renderer_1.minGridDistance * 4) {
              var timestamp_1 = axisBreak.gridDate.getTime();
              var prevGridDate_1;
              var count = 0;

              var _loop_3 = function _loop_3() {
                var date = _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["copy"](axisBreak.gridDate);
                timestamp_1 = _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["add"](date, timeUnit_1, intervalCount_1 * count, _this._df.utc).getTime();
                count++;

                if (timestamp_1 > axisBreak.adjustedStartValue && timestamp_1 < axisBreak.adjustedEndValue) {
                  var endDate = _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["copy"](date); // you might think it's easier to add intervalduration to timestamp, however it won't work for months or years which are not of the same length

                  endDate = _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["add"](endDate, timeUnit_1, intervalCount_1, _this._df.utc);

                  var format = _this.dateFormats.getKey(timeUnit_1);

                  if (_this.markUnitChange && prevGridDate_1) {
                    if (_core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["checkChange"](date, prevGridDate_1, _this._nextGridUnit, _this._df.utc)) {
                      if (timeUnit_1 !== "year") {
                        format = _this.periodChangeDateFormats.getKey(timeUnit_1);
                      }
                    }
                  }

                  var text_1 = _this._df.format(date, format);

                  var dataItem = dataItemsIterator_1.find(function (x) {
                    return x.text === text_1;
                  });

                  if (dataItem.__disabled) {
                    dataItem.__disabled = false;
                  } //this.processDataItem(dataItem);


                  _this.appendDataItem(dataItem);

                  dataItem.axisBreak = axisBreak;
                  axisBreak.dataItems.moveValue(dataItem);
                  dataItem.date = date;
                  dataItem.endDate = endDate;
                  dataItem.text = text_1;
                  prevGridDate_1 = date;

                  _this.validateDataElement(dataItem);
                }
              };

              while (timestamp_1 <= axisBreak.adjustedMax) {
                _loop_3();
              }
            }
          }
        });
      }
    }
  };
  /**
   * Validates Axis data item.
   *
   * @ignore Exclude from docs
   * @param dataItem Data item
   */


  DateAxis.prototype.validateDataElement = function (dataItem) {
    dataItem.itemIndex = this._axisItemCount;
    this._axisItemCount++;

    if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["isNumber"](this.max) && _core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["isNumber"](this.min)) {
      var renderer = this.renderer;
      var timestamp = dataItem.value;
      var endTimestamp = dataItem.endValue;

      if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["isNumber"](endTimestamp)) {
        endTimestamp = timestamp;
      }

      var position = this.valueToPosition(timestamp);
      var endPosition = this.valueToPosition(endTimestamp);
      var fillEndPosition = endPosition;

      if (!dataItem.isRange && this._gridInterval.count > this.baseInterval.count) {
        endPosition = position + (endPosition - position) / (this._gridInterval.count / this.baseInterval.count);
      }

      dataItem.position = position;
      var tick = dataItem.tick;

      if (tick && !tick.disabled) {
        renderer.updateTickElement(tick, position, endPosition);
      }

      var grid = dataItem.grid;

      if (grid && !grid.disabled) {
        renderer.updateGridElement(grid, position, endPosition);
      }

      var fill = dataItem.axisFill;

      if (fill && !fill.disabled) {
        renderer.updateFillElement(fill, position, fillEndPosition);

        if (!dataItem.isRange) {
          this.fillRule(dataItem);
        }
      }

      var mask = dataItem.mask;

      if (mask) {
        renderer.updateFillElement(mask, position, endPosition);
      }

      if (dataItem.bullet) {
        renderer.updateBullet(dataItem.bullet, position, endPosition);
      }

      var label = dataItem.label;

      if (label && !label.disabled) {
        var location_1 = label.location;

        if (location_1 == 0) {
          if (this._gridInterval.count == 1 && this._gridInterval.timeUnit != "week" && !dataItem.isRange) {
            location_1 = 0.5;
          } else {
            location_1 = 0;
          }
        }

        renderer.updateLabelElement(label, position, endPosition, location_1);
      }
    }
  };

  Object.defineProperty(DateAxis.prototype, "baseDuration", {
    /**
     * A duration in milliseconds of the `baseInterval`.
     *
     * @return Duration (ms)
     */
    get: function get() {
      return _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["getDuration"](this.baseInterval.timeUnit, this.baseInterval.count);
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Adjusts min/max values.
   *
   * @ignore Exclude from docs.
   * @todo Description (review)
   * @param min  Min timestamp
   * @param max  Max timestamp
   * @return Adjusted min/max step
   */

  DateAxis.prototype.adjustMinMax = function (min, max) {
    return {
      min: min,
      max: max,
      step: this.baseDuration
    };
  };
  /**
   * Adjusts the minimum timestamp as per cell start location.
   *
   * @param value  Value
   * @return Adjusted value
   */


  DateAxis.prototype.fixMin = function (value) {
    // like this because months are not equal
    var interval = this.baseInterval;
    var startTime = _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["round"](new Date(value), interval.timeUnit, interval.count, this._firstWeekDay, this._df.utc, undefined, this._df.timezoneMinutes, this._df.timezone).getTime();
    var endTime = _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["add"](new Date(startTime), interval.timeUnit, interval.count, this._df.utc).getTime();
    return startTime + (endTime - startTime) * this.startLocation;
  };
  /**
   * Adjusts the maximum timestamp as per cell start location.
   *
   * @param value  Value
   * @return Adjusted value
   */


  DateAxis.prototype.fixMax = function (value) {
    // like this because months are not equal
    var interval = this.baseInterval;
    var startTime = _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["round"](new Date(value), interval.timeUnit, interval.count, this._firstWeekDay, this._df.utc, undefined, this._df.timezoneMinutes, this._df.timezone).getTime();
    var endTime = _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["add"](new Date(startTime), interval.timeUnit, interval.count, this._df.utc).getTime();
    return startTime + (endTime - startTime) * this.endLocation;
  };
  /**
   * [chooseInterval description]
   *
   * @ignore Exclude from docs.
   * @todo Description
   * @param index      [description]
   * @param duration   [description]
   * @param gridCount  [description]
   * @return [description]
   */


  DateAxis.prototype.chooseInterval = function (index, duration, gridCount, intervals) {
    if (!intervals) {
      intervals = this.gridIntervals;
    }

    var gridInterval = intervals.getIndex(index);
    var intervalDuration = _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["getDuration"](gridInterval.timeUnit, gridInterval.count);
    var lastIndex = intervals.length - 1;

    if (index >= lastIndex) {
      return Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, intervals.getIndex(lastIndex));
    }

    var count = Math.ceil(duration / intervalDuration);

    if (duration < intervalDuration && index > 0) {
      return Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, intervals.getIndex(index - 1));
    }

    if (count <= gridCount) {
      return Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, intervals.getIndex(index));
    } else {
      if (index + 1 < intervals.length) {
        return this.chooseInterval(index + 1, duration, gridCount, intervals);
      } else {
        return Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, intervals.getIndex(index));
      }
    }
  };
  /**
   * Formats the value according to axis' own [[DateFormatter]].
   *
   * @param value  Source value
   * @return Formatted value
   */


  DateAxis.prototype.formatLabel = function (value) {
    return this._df.format(value);
  };
  /**
   * Converts a Date to an asbolute pixel position within Axis.
   *
   * @param date  Date
   * @return Position (px)
   */


  DateAxis.prototype.dateToPosition = function (date) {
    return this.valueToPosition(date.getTime());
  };
  /**
   * Converts a numeric timestamp or a `Date` to a relative position on axis.
   *
   * @param date  Date or a timestamp
   * @return Relative position
   */


  DateAxis.prototype.anyToPosition = function (date) {
    if (date instanceof Date) {
      return this.dateToPosition(date);
    } else {
      return this.valueToPosition(date);
    }
  };
  /**
   * Converts date to orientation point (x, y, angle) on axis
   *
   * @param date Date
   * @return IOrientationPoint
   */


  DateAxis.prototype.dateToPoint = function (date) {
    var position = this.dateToPosition(date);
    var point = this.renderer.positionToPoint(position);
    var angle = this.renderer.positionToAngle(position);
    return {
      x: point.x,
      y: point.y,
      angle: angle
    };
  };
  /**
   * Converts a numeric value to orientation (x, y, angle) point on axis
   *
   * @param value  Value
   * @return Orientation point
   */


  DateAxis.prototype.anyToPoint = function (date) {
    if (date instanceof Date) {
      return this.dateToPoint(date);
    } else {
      return this.valueToPoint(date);
    }
  };
  /**
   * Converts pixel position within Axis to a corresponding Date.
   *
   * @param position  Position (px)
   * @return Date
   */


  DateAxis.prototype.positionToDate = function (position) {
    return new Date(this.positionToValue(position));
  };
  /**
   * Returns the relative position on axis for series' data item's value.
   *
   * @since 4.5.14
   * @param  dataItem  Data item
   * @param  key       Data field to get value from
   * @param  location  Location (0-1)
   * @return           Relative position
   */


  DateAxis.prototype.getPositionX = function (dataItem, key, location, stackKey, range) {
    var value = this.getTimeByLocation(dataItem, key, location); //let stack: number = dataItem.getValue("valueX", "stack");

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["isNumber"](value)) {
      value = this.baseValue;
    }

    var position = this.valueToPosition(value);

    if (range) {
      position = _core_utils_Math__WEBPACK_IMPORTED_MODULE_9__["fitToRange"](position, range.start, range.end);
    }

    return position;
  };
  /**
   * Returns relative position on axis for series' data item's value.
   *
   * @since 4.5.14
   * @param  dataItem  Data item
   * @param  key       Data field to get value from
   * @param  location  Location (0-1)
   * @return           Relative position
   */


  DateAxis.prototype.getPositionY = function (dataItem, key, location, stackKey, range) {
    var value = this.getTimeByLocation(dataItem, key, location);
    var stack = dataItem.getValue("valueX", "stack");

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["isNumber"](value)) {
      value = this.baseValue;
    }

    var position = this.valueToPosition(value + stack);

    if (range) {
      position = _core_utils_Math__WEBPACK_IMPORTED_MODULE_9__["fitToRange"](position, range.start, range.end);
    }

    return position;
  };
  /**
   * Returns an angle for series data item.
   *
   * @ignore Exclude from docs
   * @todo Description (review)
   * @param dataItem  Data item
   * @param key       Data field to get value from
   * @param location  Location (0-1)
   * @param stackKey  Stack ID
   * @param range Range to fit in
   * @return Angle
   */


  DateAxis.prototype.getAngle = function (dataItem, key, location, stackKey, range) {
    var value = this.getTimeByLocation(dataItem, key, location);
    var stack = dataItem.getValue(stackKey, "stack");

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["isNumber"](value)) {
      value = this.baseValue;
    }

    var position = this.valueToPosition(value + stack);

    if (range) {
      position = _core_utils_Math__WEBPACK_IMPORTED_MODULE_9__["fitToRange"](position, range.start, range.end);
    }

    return this.positionToAngle(position);
  };
  /**
   * [getTimeByLocation description]
   *
   * @ignore Exclude from docs
   * @todo Description
   * @param dataItem  [description]
   * @param key       [description]
   * @param location  [description]
   * @return [description]
   */


  DateAxis.prototype.getTimeByLocation = function (dataItem, key, location) {
    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["hasValue"](key)) {
      return;
    }

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["isNumber"](location)) {
      location = dataItem.workingLocations[key];

      if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["isNumber"](location)) {
        location = 0;
      }
    }

    var startTime = dataItem.values[key]["open"];
    var endTime = dataItem.values[key]["close"];
    var workingValue = dataItem.values[key].workingValue;
    var value = dataItem.values[key].value;
    var difference = value - workingValue;
    startTime -= difference;
    endTime -= difference;

    if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["isNumber"](startTime) && _core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["isNumber"](endTime)) {
      return startTime + (endTime - startTime) * location;
    }
  };
  /**
   * Processes a related series' data item.
   *
   * @ignore Exclude from docs
   * @todo Description
   * @param dataItem  Data item
   */


  DateAxis.prototype.processSeriesDataItem = function (dataItem, axisLetter) {
    var series = dataItem.component;
    var time;
    var date = dataItem["date" + axisLetter];

    if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["isNumber"](this.timezoneOffset)) {
      date.setTime(date.getTime() + (date.getTimezoneOffset() - this.timezoneOffset) * 60000);
      dataItem.setValue("date" + axisLetter, date.getTime(), 0);
    } else if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["hasValue"](this.timezone)) {
      date = _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["setTimezone"](date, this.timezone);
      dataItem.setValue("date" + axisLetter, date.getTime(), 0);
      dataItem["date" + axisLetter] = date;
    }

    if (date) {
      time = date.getTime();
    } else {
      return;
    }

    var openDate = dataItem["openDate" + axisLetter];
    var prevSeriesTime = this._prevSeriesTime[series.uid];
    var openTime;

    if (openDate) {
      openTime = openDate.getTime();
    }

    if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["isNumber"](openTime)) {
      var difference = Math.abs(time - openTime);

      if (this._minDifference[series.uid] > difference) {
        this._minDifference[series.uid] = difference;
      }
    }

    var differece = time - prevSeriesTime;

    if (differece > 0) {
      if (this._minDifference[series.uid] > differece) {
        this._minDifference[series.uid] = differece;
      }
    }

    this._prevSeriesTime[series.uid] = time;

    if (series._baseInterval[this.uid]) {
      this.postProcessSeriesDataItem(dataItem);
    }
  };
  /**
   * [updateAxisBySeries description]
   *
   * @ignore Exclude from docs
   * @todo Description
   */


  DateAxis.prototype.updateAxisBySeries = function () {
    _super.prototype.updateAxisBySeries.call(this);

    var baseInterval = this.chooseInterval(0, this.minDifference, 1); // handle short months

    if (this.minDifference >= _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["getDuration"]("day", 27) && baseInterval.timeUnit == "week") {
      baseInterval.timeUnit = "month";
      baseInterval.count = 1;
    }

    if (baseInterval.timeUnit == "month") {
      if (this.minDifference >= _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["getDuration"]("day", 29 * 2) && baseInterval.count == 1) {
        baseInterval.count = 2;
      }

      if (this.minDifference >= _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["getDuration"]("day", 29 * 3) && baseInterval.count == 2) {
        baseInterval.count = 3;
      }

      if (this.minDifference >= _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["getDuration"]("day", 29 * 6) && baseInterval.count == 5) {
        baseInterval.count = 6;
      }
    } // handle daylight saving


    if (this.minDifference >= _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["getDuration"]("hour", 23) && baseInterval.timeUnit == "hour") {
      baseInterval.timeUnit = "day";
      baseInterval.count = 1;
    }

    if (this.minDifference >= _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["getDuration"]("week", 1) - _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["getDuration"]("hour", 1) && baseInterval.timeUnit == "day") {
      baseInterval.timeUnit = "week";
      baseInterval.count = 1;
    }

    if (this.minDifference >= _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["getDuration"]("year", 1) - _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["getDuration"]("day", 1.01) && baseInterval.timeUnit == "month") {
      baseInterval.timeUnit = "year";
      baseInterval.count = 1;
    }

    this._baseIntervalReal = baseInterval;
    this._mainBaseInterval = baseInterval; // no need to invalidate
  };

  Object.defineProperty(DateAxis.prototype, "baseInterval", {
    /**
     * @return Base interval
     */
    get: function get() {
      if (this._groupInterval) {
        return this._groupInterval;
      } else if (this._baseInterval) {
        return this._baseInterval;
      } else {
        return this._baseIntervalReal;
      }
    },

    /**
     * A base interval (granularity) of data.
     *
     * Used to indicate what are the base units of your data.
     *
     * For example, if you have a data set that has a data point every 5 minutes,
     * you may want to set this to `{ timeUnit: "minute", count: 5 }`.
     *
     * If not set, the Axis will try to determine the setting by its own, looking
     * at actual data.
     *
     * For best results, try to follow these values for `count`:
     *
     * When unit is "month", use 12 / count = round number
     * When unit is "hour", use 24 / count = round number
     * When unit is "second" and "minute", use 60 / count = round number
     *
     * @param timeInterval base interval
     */
    set: function set(timeInterval) {
      if (JSON.stringify(this._baseInterval) != JSON.stringify(timeInterval)) {
        this._baseInterval = timeInterval;
        this._mainBaseInterval = timeInterval;

        if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["isNumber"](timeInterval.count)) {
          timeInterval.count = 1;
        }

        this.invalidate();
        this.postProcessSeriesDataItems();
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(DateAxis.prototype, "mainBaseInterval", {
    /**
     * Indicates granularity of the data of source (unaggregated) data.
     *
     * @since 4.7.0
     * @return Granularity of the main data set
     */
    get: function get() {
      if (this._baseInterval) {
        return this._baseInterval;
      } else if (this._mainBaseInterval) {
        return this._mainBaseInterval;
      } else {
        return this._baseIntervalReal;
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(DateAxis.prototype, "skipEmptyPeriods", {
    /**
     * @return Remove empty stretches of time?
     */
    get: function get() {
      return this.getPropertyValue("skipEmptyPeriods");
    },

    /**
     * If enabled, axis will automatically collapse empty (without data points)
     * periods of time, i.e. weekends.
     *
     * An "empty" period is considered a stretch of time in the length of current
     * `baseInterval` without a single data point in it.
     *
     * For each such empty period, axis will automatically create an
     * [[AxisBreak]]. By default they will be invisible. You can still configure
     * them by accessing `axis.breaks.template`.
     *
     * [More info about breaks](https://www.amcharts.com/docs/v4/concepts/axes/#Breaks).
     *
     * Important notes:
     * * If you set this property to `true`, you can not add your custom axis breaks to this axis anymore.
     * * Using this feature affects performance. Use only if you need it.
     * * Setting this to `true` will reset appearance of breaks. If you want to modify appearance, do it *after* you set `skipEmptyPeriods`.
     * * Some axis label overlapping might happen.
     * * This setting is not compatible with `groupData = true`.
     *
     * @default false
     * @param value  Remove empty stretches of time?
     */
    set: function set(value) {
      if (value) {
        var breakTemplate = this.axisBreaks.template;
        breakTemplate.startLine.disabled = true;
        breakTemplate.endLine.disabled = true;
        breakTemplate.fillShape.disabled = true;
        breakTemplate.breakSize = 0;
      } else {
        if (this._gapBreaks) {
          this.axisBreaks.clear();
          this._gapBreaks = false;
        }
      }

      if (this.setPropertyValue("skipEmptyPeriods", value)) {
        this.invalidate();
        this.postProcessSeriesDataItems();
        this.invalidateSeries();
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(DateAxis.prototype, "tooltipDateFormat", {
    /**
     * @return Date format
     */
    get: function get() {
      return this.getPropertyValue("tooltipDateFormat");
    },

    /**
     * A special date format to apply axis tooltips.
     *
     * Will use same format as for labels, if not set.
     *
     * @param value  Date format
     */
    set: function set(value) {
      this.setPropertyValue("tooltipDateFormat", value);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(DateAxis.prototype, "markUnitChange", {
    /**
     * @return Use different format for period beginning?
     */
    get: function get() {
      return this.getPropertyValue("markUnitChange");
    },

    /**
     * Use `periodChangeDateFormats` to apply different formats to the first
     * label in bigger time unit.
     *
     * @default true
     * @param value  Use different format for period beginning?
     */
    set: function set(value) {
      if (this.setPropertyValue("markUnitChange", value)) {
        this.invalidateData();
      }
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Returns text to show in a tooltip, based on specific relative position
   * within axis.
   *
   * The label will be formatted as per [[DateFormatter]] set for the whole
   * chart, or explicitly for this Axis.
   *
   * @ignore Exclude from docs
   * @param position  Position
   * @return Label (formatted date)
   */

  DateAxis.prototype.getTooltipText = function (position) {
    var text;
    var date = this.positionToDate(position);
    date = _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["round"](date, this.baseInterval.timeUnit, this.baseInterval.count, this._firstWeekDay, this._df.utc, new Date(this.min), this._df.timezoneMinutes, this._df.timezone);
    this.tooltipDate = date;

    if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["hasValue"](this.tooltipDateFormat)) {
      text = this._df.format(date, this.tooltipDateFormat);
    } else {
      var dateFormat = this.dateFormats.getKey(this.baseInterval.timeUnit);

      if (dateFormat) {
        text = this._df.format(date, dateFormat);
      } else {
        text = this.getPositionLabel(position);
      }
    }

    if (!this._adapterO) {
      return text;
    } else {
      return this._adapterO.apply("getTooltipText", text);
    }
  };
  /**
   * Takes an absolute position within axis and adjust it to a specific position within base interval. (cell)
   *
   * @ignore Exclude from docs
   * @param position Source position
   * @param location  Location in the cell
   * @return Adjusted position
   */


  DateAxis.prototype.roundPosition = function (position, location, axisLocation) {
    var baseInterval = this.baseInterval;
    var timeUnit = baseInterval.timeUnit;
    var count = baseInterval.count;
    var date = this.positionToDate(position);
    _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["round"](date, timeUnit, count, this._firstWeekDay, this._df.utc, undefined, this._df.timezoneMinutes, this._df.timezone);

    if (location > 0) {
      _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["add"](date, timeUnit, location * count, this._df.utc);
    }

    if (axisLocation > 0 && axisLocation < 1) {
      date.setTime(date.getTime() + this.baseDuration * axisLocation);
    }

    if (this.isInBreak(date.getTime())) {
      while (date.getTime() < this.max) {
        _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["add"](date, timeUnit, count, this._df.utc);

        if (!this.isInBreak(date.getTime())) {
          break;
        }
      }
    }

    return this.dateToPosition(date);
  };
  /**
   * Returns an relative position of the start of the cell (period), that specific position value falls into.
   *
   * @ignore Exclude from docs
   * @todo Description (review)
   * @param position  Relative position
   * @return Cell start relative position
   */


  DateAxis.prototype.getCellStartPosition = function (position) {
    return this.roundPosition(position, 0);
  };
  /**
   * Returns an relative position of the end of the cell (period), that specific position value falls into.
   *
   * @ignore Exclude from docs
   * @todo Description (review)
   * @param position  Relative position
   * @return Cell end relative position
   */


  DateAxis.prototype.getCellEndPosition = function (position) {
    return this.roundPosition(position, 1); //return this.dateToPosition($time.add(this.positionToDate(this.roundPosition(position, 1)), this.baseInterval.timeUnit, this.baseInterval.count));
  };
  /**
   * Returns a Series data item that corresponds to the specific pixel position
   * of the Axis.
   *
   * If `findNearest` (third parameter) is set to `true`, the method will try
   * to locate nearest available data item if none is found directly under
   * `position`.
   *
   * @param series       Series
   * @param position     Position (px)
   * @param findNearest  Should axis try to find nearest tooltip if there is no data item at exact position
   * @return Data item
   */


  DateAxis.prototype.getSeriesDataItem = function (series, position, findNearest) {
    var value = this.positionToValue(position);
    var location = 0.5;

    if (this.axisLetter == "Y") {
      location = series.dataItems.template.locations.dateY;
    } else {
      location = series.dataItems.template.locations.dateX;
    }

    var deltaValue = value - location * this.baseDuration;
    var date = _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["round"](new Date(value), this.baseInterval.timeUnit, this.baseInterval.count, this._firstWeekDay, this._df.utc, undefined, this._df.timezoneMinutes, this._df.timezone);
    var nextDate = _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["round"](new Date(value + this.baseDuration), this.baseInterval.timeUnit, this.baseInterval.count, this._firstWeekDay, this._df.utc, undefined, this._df.timezoneMinutes, this._df.timezone);

    if (nextDate.getTime() > date.getTime()) {
      if (Math.abs(nextDate.getTime() - deltaValue) < Math.abs(deltaValue - date.getTime())) {
        date = nextDate;
      }
    }

    var dataItemsByAxis = series.dataItemsByAxis.getKey(this.uid);
    var dataItem = dataItemsByAxis.getKey(date.getTime() + series.currentDataSetId); // todo:  alternatively we can find closiest here

    if (!dataItem && findNearest) {
      var key_1;

      if (this.axisLetter == "Y") {
        key_1 = "dateY";
      } else {
        key_1 = "dateX";
      }

      dataItem = series.dataItems.getIndex(series.dataItems.findClosestIndex(date.getTime(), function (x) {
        if (x[key_1]) {
          return x[key_1].getTime();
        } else {
          return -Infinity;
        }
      }, "any"));
    }

    return dataItem;
  };
  /**
   * Returns a formatted date based on position in axis scale.
   *
   * Please note that `position` represents position within axis which may be
   * zoomed and not correspond to Cursor's `position`.
   *
   * To convert Cursor's `position` to Axis' `position` use `toAxisPosition()` method.
   *
   * @see {@link https://www.amcharts.com/docs/v4/tutorials/tracking-cursors-position-via-api/#Tracking_Cursor_s_position} For more information about cursor tracking.
   * @param position  Relative position on axis (0-1)
   * @return Position label
   */


  DateAxis.prototype.getPositionLabel = function (position) {
    // @todo Better format recognition
    var date = this.positionToDate(position);
    return this._df.format(date, this.getCurrentLabelFormat());
  };
  /**
   * Returns label date format based on currently used time units
   *
   * @return Format
   */


  DateAxis.prototype.getCurrentLabelFormat = function () {
    return this.dateFormats.getKey(this._gridInterval ? this._gridInterval.timeUnit : "day");
  };
  /**
   * Initializes an Axis renderer.
   *
   * @ignore Exclude from docs
   */


  DateAxis.prototype.initRenderer = function () {
    _super.prototype.initRenderer.call(this);

    var renderer = this.renderer;

    if (renderer) {
      // Set defaults
      renderer.ticks.template.location = 0;
      renderer.grid.template.location = 0;
      renderer.labels.template.location = 0;
      renderer.baseGrid.disabled = true;
    }
  };

  Object.defineProperty(DateAxis.prototype, "basePoint", {
    /**
     * Coordinates of the actual axis start.
     *
     * @ignore Exclude from docs
     * @return Base point
     */
    get: function get() {
      return {
        x: 0,
        y: 0
      };
    },
    enumerable: true,
    configurable: true
  });
  /**
   * @ignore
   */

  DateAxis.prototype.animateMinMax = function (min, max) {
    var _this = this;

    var animation = this.animate([{
      property: "_minAdjusted",
      from: this._minAdjusted,
      to: min
    }, {
      property: "_maxAdjusted",
      from: this._maxAdjusted,
      to: max
    }], this.rangeChangeDuration, this.rangeChangeEasing);
    animation.events.on("animationprogress", function () {
      _this.dispatch("extremeschanged");
    });
    return animation;
  };
  /**
   * Invalidates axis data items when series extremes change
   */


  DateAxis.prototype.handleExtremesChange = function () {
    _super.prototype.handleExtremesChange.call(this);

    if (this.groupData) {
      var id = this.baseInterval.timeUnit + this.baseInterval.count;
      this.groupMin[id] = this._finalMin;
      this.groupMax[id] = this._finalMax;
    }
  };
  /**
   * Zooms axis to specific Dates.
   *
   * @param startDate       Start date
   * @param endValue        End date
   * @param skipRangeEvent  Do not invoke events
   * @param instantly       Do not play zoom animations
   */


  DateAxis.prototype.zoomToDates = function (startDate, endDate, skipRangeEvent, instantly, adjust) {
    startDate = this._df.parse(startDate);
    endDate = this._df.parse(endDate);
    this.zoomToValues(startDate.getTime(), endDate.getTime(), skipRangeEvent, instantly, adjust);
  };
  /**
   * Zooms axis to specific values.
   *
   * @param startValue      Start value
   * @param endValue        End value
   * @param skipRangeEvent  Do not invoke events
   * @param instantly       Do not play zoom animations
   */


  DateAxis.prototype.zoomToValues = function (startValue, endValue, skipRangeEvent, instantly, adjust) {
    var _this = this;

    if (!this.groupData) {
      var start = (startValue - this.min) / (this.max - this.min);
      var end = (endValue - this.min) / (this.max - this.min);
      this.zoom({
        start: start,
        end: end
      }, skipRangeEvent, instantly);
    } else {
      var difference = this.adjustDifference(startValue, endValue);
      var isEnd = false;

      if (endValue == this.max) {
        isEnd = true;
      }

      var isStart = false;

      if (startValue == this.min) {
        isStart = true;
      }

      if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["hasValue"](difference)) {
        var mainBaseInterval = this.mainBaseInterval;
        var groupInterval_1 = this.chooseInterval(0, difference, this.groupCount, this.groupIntervals);

        if (groupInterval_1.timeUnit == mainBaseInterval.timeUnit && groupInterval_1.count < mainBaseInterval.count || _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["getDuration"](groupInterval_1.timeUnit, 1) < _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["getDuration"](mainBaseInterval.timeUnit, 1)) {
          groupInterval_1 = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, mainBaseInterval);
        }

        var id = groupInterval_1.timeUnit + groupInterval_1.count;
        var min_1 = this.groupMin[id];
        var max_1 = this.groupMax[id];

        if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["isNumber"](min_1) || !_core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["isNumber"](max_1)) {
          min_1 = Number.POSITIVE_INFINITY;
          max_1 = Number.NEGATIVE_INFINITY;
          this.series.each(function (series) {
            var seriesMin = series.min(_this);
            var seriesMax = series.max(_this);

            if (series._dataSets) {
              var ds = series._dataSets.getKey(groupInterval_1.timeUnit + groupInterval_1.count);

              if (ds) {
                var mindi = ds.getIndex(0);
                var maxdi = ds.getIndex(ds.length - 1);

                if (mindi) {
                  if (series.xAxis == _this) {
                    seriesMin = mindi.dateX.getTime();
                  } else if (series.yAxis == _this) {
                    seriesMin = mindi.dateY.getTime();
                  }
                }

                if (maxdi) {
                  if (series.xAxis == _this) {
                    seriesMax = maxdi.dateX.getTime();
                  } else if (series.yAxis == _this) {
                    seriesMax = maxdi.dateY.getTime();
                  }
                }
              }
            }

            seriesMax = _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["round"](_core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["add"](new Date(seriesMax), groupInterval_1.timeUnit, 1, _this._df.utc), groupInterval_1.timeUnit, 1, _this._df.firstDayOfWeek, _this._df.utc, undefined, _this._df.timezoneMinutes, _this._df.timezone).getTime();

            if (seriesMin < min_1) {
              min_1 = seriesMin;
            }

            if (seriesMax > max_1) {
              max_1 = seriesMax;
            }
          });
          this.groupMin[id] = min_1;
          this.groupMax[id] = max_1;
        }

        startValue = _core_utils_Math__WEBPACK_IMPORTED_MODULE_9__["fitToRange"](startValue, min_1, max_1);
        endValue = _core_utils_Math__WEBPACK_IMPORTED_MODULE_9__["fitToRange"](endValue, min_1, max_1);

        if (adjust) {
          if (isEnd) {
            startValue = endValue - difference;
            startValue = _core_utils_Math__WEBPACK_IMPORTED_MODULE_9__["fitToRange"](startValue, min_1, max_1);
          }

          if (isStart) {
            endValue = startValue + difference;
            endValue = _core_utils_Math__WEBPACK_IMPORTED_MODULE_9__["fitToRange"](endValue, min_1, max_1);
          }
        }

        var start = (startValue - min_1) / (max_1 - min_1);
        var end = (endValue - min_1) / (max_1 - min_1);
        this.zoom({
          start: start,
          end: end
        }, skipRangeEvent, instantly);
      }
    }
  };
  /**
   * Adds `baseInterval` to "as is" fields.
   *
   * @param field  Field name
   * @return Assign as is?
   */


  DateAxis.prototype.asIs = function (field) {
    return field == "baseInterval" || _super.prototype.asIs.call(this, field);
  };
  /**
   * Copies all properties and related data from a different instance of Axis.
   *
   * @param source Source Axis
   */


  DateAxis.prototype.copyFrom = function (source) {
    var _this = this;

    _super.prototype.copyFrom.call(this, source);

    this.dateFormats = source.dateFormats;
    this.periodChangeDateFormats = source.periodChangeDateFormats;
    this.groupIntervals.clear();
    source.groupIntervals.each(function (interval) {
      _this.groupIntervals.push(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, interval));
    });
    this.gridIntervals.clear();
    source.gridIntervals.each(function (interval) {
      _this.gridIntervals.push(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, interval));
    });

    if (source._baseInterval) {
      this.baseInterval = source._baseInterval;
    }
  };
  /**
   * Shows Axis tooltip at specific relative position within Axis. (0-1)
   *
   * @param position Position (0-1)
   * @param local or global position
   */


  DateAxis.prototype.showTooltipAtPosition = function (position, local) {
    var _this = this;

    if (!local) {
      position = this.toAxisPosition(position);
    }

    if (this.snapTooltip) {
      // rounding is not good, pen/aac4e7f66f019d36b2447f050c600c13 (no last tootltip shown)
      var actualDate = this.positionToDate(position); //$time.round(this.positionToDate(position), this.baseInterval.timeUnit, 1, this.getFirstWeekDay(), this.dateFormatter.utc, undefined, this._df.timezoneMinutes, this._df.timezone);

      var actualTime_1 = actualDate.getTime();
      var closestDate_1;
      this.series.each(function (series) {
        if (series.baseAxis == _this) {
          var dataItem = _this.getSeriesDataItem(series, position, true);

          if (dataItem) {
            var date = void 0;

            if (series.xAxis == _this) {
              date = dataItem.dateX;
            }

            if (series.yAxis == _this) {
              date = dataItem.dateY;
            }

            if (!closestDate_1) {
              closestDate_1 = date;
            } else {
              if (Math.abs(closestDate_1.getTime() - actualTime_1) > Math.abs(date.getTime() - actualTime_1)) {
                closestDate_1 = date;
              }
            }
          }
        }
      });

      if (closestDate_1) {
        var closestTime_1 = closestDate_1.getTime();
        closestDate_1 = _core_utils_Time__WEBPACK_IMPORTED_MODULE_6__["round"](new Date(closestTime_1), this.baseInterval.timeUnit, this.baseInterval.count, this._firstWeekDay, this._df.utc, undefined, this._df.timezoneMinutes, this._df.timezone);
        closestTime_1 = closestDate_1.getTime();
        var tooltipLocation = this.renderer.tooltipLocation;

        if (tooltipLocation == 0) {
          tooltipLocation = 0.0001;
        }

        closestDate_1 = new Date(closestDate_1.getTime() + this.baseDuration * tooltipLocation);
        position = this.dateToPosition(closestDate_1);

        if (this.chart.cursor && this.chart.cursor.snapToSeries) {//void
        } else {
          this.series.each(function (series) {
            var dataItem = series.dataItemsByAxis.getKey(_this.uid).getKey(closestTime_1 + series.currentDataSetId);
            var point = series.showTooltipAtDataItem(dataItem);

            if (point) {
              _this.chart._seriesPoints.push({
                series: series,
                point: point
              });
            } else {
              // check, otherwise column tooltip will be hidden
              if (series.tooltipText || series.tooltipHTML) {
                series.hideTooltip();
              }
            }
          });
        } //this.chart.sortSeriesTooltips(seriesPoints);

      }
    }

    _super.prototype.showTooltipAtPosition.call(this, position, true);
  };

  Object.defineProperty(DateAxis.prototype, "snapTooltip", {
    /**
     * @return Should snap?
     */
    get: function get() {
      return this.getPropertyValue("snapTooltip");
    },

    /**
     * Should the nearest tooltip be shown if no data item is found on the
     * current cursor position.
     *
     * @default true
     * @param value  Should snap?
     */
    set: function set(value) {
      this.setPropertyValue("snapTooltip", value);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(DateAxis.prototype, "groupData", {
    /**
     * @return Group data points?
     */
    get: function get() {
      return this.getPropertyValue("groupData");
    },

    /**
     * Indicates if data should be aggregated to composide data items if there
     * are more data items in selected range than `groupCount`.
     *
     * Grouping will occur automatically, based on current selection range, and
     * will change dynamically when user zooms in/out the chart.
     *
     * NOTE: This works only if [[DateAxis]] is base axis of an [[XYSeries]].
     *
     * The related [[XYSeries]] also needs to be set up to take advantage of, by
     * setting its [`groupFields`](https://www.amcharts.com/docs/v4/reference/xyseries/#groupFields_property).
     *
     * The group intervals to aggregate data to is defined by `groupIntervals`
     * property.
     *
     * ```TypeScript
     * let dateAxis = chart.xAxes.push(new am4charts.DateAxis());
     * dateAxis.groupData = true;
     *
     * let valueAxis = chart.xAxes.push(new am4charts.valueAxis());
     *
     * let series = chart.series.push(new am4charts.LineSeries());
     * series.dataFields.dateX = "date";
     * series.dataFields.valueY = "value";
     * series.groupFields.valueY = "average";
     * ```
     * ```JavaScript
     * var dateAxis = chart.xAxes.push(new am4charts.DateAxis());
     * dateAxis.groupData = true;
     *
     * var valueAxis = chart.xAxes.push(new am4charts.valueAxis());
     *
     * var series = chart.series.push(new am4charts.LineSeries());
     * series.dataFields.dateX = "date";
     * series.dataFields.valueY = "value";
     * series.groupFields.valueY = "average";
     * ```
     * ```JSON
     * {
     *   // ...
     *   "xAxes": [{
     *     "type": "DateAxis",
     *     "groupData": true
     *   }],
     *   "yAxes": [{
     *     "type": "ValueAxis"
     *   }],
     *   "series": [{
     *     "type": "LineSeries",
     *     "dataFields": {
     *       "dateX": "date",
     *       "valueY": "value"
     *     },
     *     "groupFields": {
     *       "valueY": "average"
     *     }
     *   }]
     * }
     * ```
     *
     * @default false
     * @see {@link https://www.amcharts.com/docs/v4/concepts/axes/date-axis/#Dynamic_data_item_grouping} for more information about dynamic data item grouping.
     * @since 4.7.0
     * @param  value  Group data points?
     */
    set: function set(value) {
      var _this = this;

      if (this.setPropertyValue("groupData", value)) {
        this.series.each(function (series) {
          series.setDataSet("");

          if (value && !series.dataGrouped && series.inited) {
            series._baseInterval[_this.uid] = _this.mainBaseInterval;

            _this.groupSeriesData(series);
          }
        });
        this._currentDataSetId = "";
        this._groupInterval = undefined;
        this.invalidate();
        this.invalidateSeries();
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(DateAxis.prototype, "groupInterval", {
    /**
     * @return Interval
     */
    get: function get() {
      return this.getPropertyValue("groupInterval");
    },

    /**
     * Disables automatic selection of data grouping intervals and always uses
     * `groupInterval` if set. Works only if `groupData = true`.
     *
     * @since 4.9.24
     * @param  value  Interval
     */
    set: function set(value) {
      if (this.setPropertyValue("groupInterval", value)) {
        this.invalidate();
        this.invalidateSeries();
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(DateAxis.prototype, "groupCount", {
    /**
     * @return Number of data items
     */
    get: function get() {
      return this.getPropertyValue("groupCount");
    },

    /**
     * Indicates threshold of data items in selected range at which to start
     * aggregating data items if `groupData = true`.
     *
     * @default 200
     * @since 4.7.0
     * @param  value  Number of data items
     */
    set: function set(value) {
      this.setPropertyValue("groupCount", value);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(DateAxis.prototype, "timezoneOffset", {
    /**
     * @todo Timezone offset in minutes
     */
    get: function get() {
      return this.getPropertyValue("timezoneOffset");
    },

    /**
     * If set will recalculate all timestamps in data by applying specific offset
     * in minutes.
     *
     * IMPORTANT: do not set `timezoneOffset` on both `DateAxis` and `dateFormatter`. It
     * will skew your results by applying offset twice.
     *
     * @since 4.8.5
     * @param  value Time zone offset in minutes
     */
    set: function set(value) {
      this.setPropertyValue("timezoneOffset", value);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(DateAxis.prototype, "timezone", {
    /**
     * @return Timezone
     */
    get: function get() {
      return this.getPropertyValue("timezone");
    },

    /**
     * If set will recalculate all timestamps in data to specific named timezone,
     * e.g. `"America/Vancouver"`, `"Australia/Sydney"`, `"UTC"`, etc.
     *
     * IMPORTANT: it is no longer recommended to use this setting. Please
     * set`timezone` on `dateFormatter`.
     *
     * @deprecated
     * @since 4.10.1
     * @param  value Time zone
     */
    set: function set(value) {
      this.setPropertyValue("timezone", value);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(DateAxis.prototype, "gridInterval", {
    /**
     * Current grid interval.
     *
     * @return Grid interval
     */
    get: function get() {
      return this._gridInterval;
    },
    enumerable: true,
    configurable: true
  });
  /**
   * @ignore
   */

  DateAxis.prototype.makeGap = function (dataItem, previous) {
    var series = dataItem.component;

    if (dataItem && previous) {
      if (!series.connect && _core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["isNumber"](series.autoGapCount)) {
        if (series.baseAxis == this) {
          var date = dataItem.dates["date" + this.axisLetter];
          var prevDate = previous.dates["date" + this.axisLetter];

          if (date && prevDate) {
            var time = date.getTime();
            var prevTime = prevDate.getTime();

            if (time - prevTime > series.autoGapCount * this.baseDuration) {
              return true;
            }
          }
        }
      }
    }

    return false;
  };

  Object.defineProperty(DateAxis.prototype, "baseValue", {
    /**
     * @return base value
     */
    get: function get() {
      return this.min;
    },
    enumerable: true,
    configurable: true
  });
  return DateAxis;
}(_ValueAxis__WEBPACK_IMPORTED_MODULE_1__["ValueAxis"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_5__["registry"].registeredClasses["DateAxis"] = DateAxis;
_core_Registry__WEBPACK_IMPORTED_MODULE_5__["registry"].registeredClasses["DateAxisDataItem"] = DateAxisDataItem;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/DateAxisBreak.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/axes/DateAxisBreak.js ***!
  \*********************************************************************************/
/*! exports provided: DateAxisBreak */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DateAxisBreak", function() { return DateAxisBreak; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _ValueAxisBreak__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ValueAxisBreak */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/ValueAxisBreak.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/**
 * DateAxisBreak includes functionality to add breaks on a [[DateAxis]].
 *
 * A "break" can be used to "cut out" specific ranges of the axis scale, e.g.
 * weekends and holidays out of the Date-based axis.
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */



/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Class used to define breaks for [[DateAxis]].
 *
 * A "break" can be used to "cut out" specific ranges of the axis scale, e.g.
 * weekends and holidays out of the Date-based axis.
 *
 * @see {@link IDateAxisBreakEvents} for a list of available events
 * @see {@link IDateAxisBreakAdapters} for a list of available Adapters
 * @important
 */

var DateAxisBreak =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(DateAxisBreak, _super);
  /**
   * Constructor
   */


  function DateAxisBreak() {
    var _this = _super.call(this) || this;

    _this.className = "DateAxisBreak";

    _this.applyTheme();

    return _this;
  }

  Object.defineProperty(DateAxisBreak.prototype, "startDate", {
    /**
     * @return Start date
     */
    get: function get() {
      return this.getPropertyValue("startDate");
    },

    /**
     * Starting date for the break.
     *
     * @param value Start date
     */
    set: function set(value) {
      if (this.setPropertyValue("startDate", value)) {
        this.startValue = value.getTime();

        if (this.axis) {
          this.axis.invalidate();
          this.axis.invalidateSeries();
        }
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(DateAxisBreak.prototype, "endDate", {
    /**
     * @return End date
     */
    get: function get() {
      return this.getPropertyValue("endDate");
    },

    /**
     * Ending date for the break.
     *
     * @param value End date
     */
    set: function set(value) {
      if (this.setPropertyValue("endDate", value)) {
        this.endValue = value.getTime();

        if (this.axis) {
          this.axis.invalidate();
          this.axis.invalidateSeries();
        }
      }
    },
    enumerable: true,
    configurable: true
  });
  return DateAxisBreak;
}(_ValueAxisBreak__WEBPACK_IMPORTED_MODULE_1__["ValueAxisBreak"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_2__["registry"].registeredClasses["DateAxisBreak"] = DateAxisBreak;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/DurationAxis.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/axes/DurationAxis.js ***!
  \********************************************************************************/
/*! exports provided: DurationAxisDataItem, DurationAxis */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DurationAxisDataItem", function() { return DurationAxisDataItem; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DurationAxis", function() { return DurationAxis; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _ValueAxis__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ValueAxis */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/ValueAxis.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_utils_Math__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/utils/Math */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Math.js");
/**
 * DurationAxis module
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */




/**
 * ============================================================================
 * DATA ITEM
 * ============================================================================
 * @hidden
 */

/**
 * Defines data item for [[DurationAxis]].
 *
 * @see {@link DataItem}
 */

var DurationAxisDataItem =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(DurationAxisDataItem, _super);
  /**
   * Constructor
   */


  function DurationAxisDataItem() {
    var _this = _super.call(this) || this;

    _this.className = "DurationAxisDataItem";

    _this.applyTheme();

    return _this;
  }

  return DurationAxisDataItem;
}(_ValueAxis__WEBPACK_IMPORTED_MODULE_1__["ValueAxisDataItem"]);


/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Used to create an axis that shows time durations.
 *
 * ```TypeScript
 * // Create the axis
 * let xAxis = chart.xAxes.push(new am4charts.DurationAxis());
 *
 * // Set settings
 * xAxis.title.text = "Time";
 * ```
 * ```JavaScript
 * // Create the axis
 * var valueAxis = chart.xAxes.push(new am4charts.DurationAxis());
 *
 * // Set settings
 * valueAxis.title.text = "Time";
 * ```
 * ```JSON
 * "xAxes": [{
 *   "type": "DurationAxis",
 *   "title": {
 *     "text": "Time"
 *   }
 * }]
 * ```
 *
 * @see {@link https://www.amcharts.com/docs/v4/concepts/formatters/formatting-duration/} for mor information about duration formatters.
 * @see {@link IDurationAxisEvents} for a list of available Events
 * @see {@link IDurationAxisAdapters} for a list of available Adapters
 * @important
 */

var DurationAxis =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(DurationAxis, _super);
  /**
   * Constructor
   */


  function DurationAxis() {
    var _this = // Init
    _super.call(this) || this;
    /**
     * A base unit (granularity) of data.
     *
     * Used to indicate what are the base units of your data.
     */


    _this._baseUnit = "second";
    _this.className = "DurationAxis";

    _this.setPropertyValue("maxZoomFactor", 1000000); // Apply theme


    _this.applyTheme();

    return _this;
  }
  /**
   * Formats the value according to axis' own [[DurationFormatter]].
   *
   * @param value  Source value
   * @return Formatted value
   */


  DurationAxis.prototype.formatLabel = function (value, format) {
    return this.durationFormatter.format(value, format || this.axisDurationFormat);
  };
  /**
   * Adjusts actual min and max scale values so that the axis starts and ends
   * at "nice" values, unless `strictMinMax` is set.
   *
   * The `difference` can be something else than `max - min`, because of the
   * axis breaks.
   *
   * @ignore Exclude from docs
   * @todo Description
   * @param min        [description]
   * @param max        [description]
   * @param difference [description]
   * @param gridCount  [description]
   * @param strictMode [description]
   * @return [description]
   */


  DurationAxis.prototype.adjustMinMax = function (min, max, difference, gridCount, strictMode) {
    var e_1, _a;

    var minMaxStep;
    var timeUnit = this.baseUnit; // we don't allow to go to smaller units, setting so to avoid invalidation

    this.setPropertyValue("maxPrecision", 0);

    if (timeUnit == "millisecond" || timeUnit == "second" || timeUnit == "minute" || timeUnit == "hour") {
      // will fail if 0
      if (gridCount <= 1) {
        gridCount = 1;
      }

      gridCount = Math.round(gridCount);
      var initialMin = min;
      var initialMax = max; // in case min and max is the same, use max

      if (difference === 0) {
        difference = Math.abs(max);
      }

      var step = difference / gridCount;
      var divisors = [60, 30, 20, 15, 10, 2, 1];
      var realDivisor = 1;

      if (timeUnit == "hour") {
        divisors = [24, 12, 6, 4, 2, 1];
      }

      try {
        for (var divisors_1 = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__values"])(divisors), divisors_1_1 = divisors_1.next(); !divisors_1_1.done; divisors_1_1 = divisors_1.next()) {
          var divisor = divisors_1_1.value;

          if (difference / divisor > gridCount) {
            realDivisor = divisor;
            break;
          }
        }
      } catch (e_1_1) {
        e_1 = {
          error: e_1_1
        };
      } finally {
        try {
          if (divisors_1_1 && !divisors_1_1.done && (_a = divisors_1.return)) _a.call(divisors_1);
        } finally {
          if (e_1) throw e_1.error;
        }
      }

      var count = Math.ceil((max - min) / realDivisor / gridCount);
      var exponent = Math.log(Math.abs(count)) * Math.LOG10E;
      var power = Math.pow(10, Math.floor(exponent)) / 10;
      var reducedCount = count / power; // find closest to divisor

      var closest = _core_utils_Math__WEBPACK_IMPORTED_MODULE_3__["closest"](divisors, reducedCount);
      count = closest * power;
      step = realDivisor * count; // TODO can this be removed ?

      this.durationFormatter.getValueUnit(step, this.baseUnit);
      min = Math.floor(min / step) * step;
      max = Math.ceil(max / step) * step;

      if (strictMode) {
        min -= step;

        if (min < 0 && initialMin >= 0) {
          min = 0;
        }

        max += step;

        if (max > 0 && initialMax <= 0) {
          max = 0;
        }
      }

      minMaxStep = {
        min: min,
        max: max,
        step: step
      };
    } else {
      minMaxStep = _super.prototype.adjustMinMax.call(this, min, max, difference, gridCount, strictMode);
    } // choose duration formatter based on step


    this.axisDurationFormat = this.durationFormatter.getFormat(minMaxStep.step, minMaxStep.max, this.baseUnit);
    return minMaxStep;
  };

  Object.defineProperty(DurationAxis.prototype, "tooltipDurationFormat", {
    /**
     * @return Duration format for axis labels
     */
    get: function get() {
      return this._tooltipDurationFormat;
    },

    /**
     * A special duration format to apply axis tooltips.
     *
     * Will use same format as for labels, if not set.
     *
     * @see {@link https://www.amcharts.com/docs/v4/concepts/formatters/formatting-duration/} for mor information.
     * @param value  Duration format for axis labels
     */
    set: function set(value) {
      this._tooltipDurationFormat = value;
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Returns text to show in a axis tooltip, based on specific position within
   * axis.
   *
   * The label will be formatted as per [[NumberFormatter]] set for the whole
   * chart, or explicitly for this Axis.
   *
   * @ignore Exclude from docs
   * @param position  Position (px)
   * @return Label (numeric value)
   */

  DurationAxis.prototype.getTooltipText = function (position) {
    var value = _core_utils_Math__WEBPACK_IMPORTED_MODULE_3__["round"](this.positionToValue(position), this._stepDecimalPlaces);
    var valueStr = this.formatLabel(value, this.tooltipDurationFormat);

    if (!this._adapterO) {
      return valueStr;
    } else {
      return this._adapterO.apply("getTooltipText", valueStr);
    }
  };

  Object.defineProperty(DurationAxis.prototype, "baseUnit", {
    /**
     * @return Base unit
     */
    get: function get() {
      return this._baseUnit;
    },

    /**
     * A base unit (granularity) of data.
     *
     * Used to indicate what are the base units of your data.
     *
     * Available options: "millisecond", "second" (default), "minute", "hour",
     * "day", "week", "month", "year".
     *
     * @default "second"
     * @param timeUnit
     */
    set: function set(timeUnit) {
      if (this._baseUnit != timeUnit) {
        this._baseUnit = timeUnit;
        this.durationFormatter.baseUnit = timeUnit;
        this.invalidate();
      }
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Copies all properties and related data from a different instance of Axis.
   *
   * @param source Source Axis
   */

  DurationAxis.prototype.copyFrom = function (source) {
    _super.prototype.copyFrom.call(this, source);

    this.baseUnit = source.baseUnit;
  };

  return DurationAxis;
}(_ValueAxis__WEBPACK_IMPORTED_MODULE_1__["ValueAxis"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_2__["registry"].registeredClasses["DurationAxis"] = DurationAxis;
_core_Registry__WEBPACK_IMPORTED_MODULE_2__["registry"].registeredClasses["DurationAxisDataItem"] = DurationAxisDataItem;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/Grid.js":
/*!************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/axes/Grid.js ***!
  \************************************************************************/
/*! exports provided: Grid */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Grid", function() { return Grid; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _core_Sprite__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core/Sprite */ "./node_modules/@amcharts/amcharts4/.internal/core/Sprite.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_utils_Color__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/utils/Color */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Color.js");
/* harmony import */ var _core_utils_InterfaceColorSet__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/utils/InterfaceColorSet */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/InterfaceColorSet.js");
/* harmony import */ var _core_utils_Responsive__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core/utils/Responsive */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Responsive.js");
/**
 * A module defining functionality for axis grid elements.
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */






/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Displays an axis grid line.
 *
 * @see {@link IGridEvents} for a list of available events
 * @see {@link IGridAdapters} for a list of available Adapters
 * @todo Review: container is better, as we'll be able to attach something to the grid, also with 3d charts we might need some additional elements
 * @important
 */

var Grid =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(Grid, _super);
  /**
   * Constructor
   */


  function Grid() {
    var _this = _super.call(this) || this;

    _this.className = "Grid";
    _this.element = _this.paper.add("path");
    _this.location = 0.5;
    _this.isMeasured = false;
    _this.above = false;
    var interfaceColors = new _core_utils_InterfaceColorSet__WEBPACK_IMPORTED_MODULE_4__["InterfaceColorSet"]();
    _this.stroke = interfaceColors.getFor("grid");
    _this.pixelPerfect = true;
    _this.strokeOpacity = 0.15;
    _this.fill = Object(_core_utils_Color__WEBPACK_IMPORTED_MODULE_3__["color"])(); // "none";

    _this.applyTheme();

    return _this;
  }

  Object.defineProperty(Grid.prototype, "location", {
    /**
     * @return Location (0-1)
     */
    get: function get() {
      return this.getPropertyValue("location");
    },

    /**
     * Location within axis cell to place grid line on.
     *
     * * 0 - start
     * * 0.5 - middle
     * * 1 - end
     *
     * @param value  Location (0-1)
     */
    set: function set(value) {
      this.setPropertyValue("location", value, true);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(Grid.prototype, "above", {
    /**
     * @return Draw above series?
     */
    get: function get() {
      return this.getPropertyValue("above");
    },

    /**
     * Normally fill goes below series. Set this to `true` to go above.
     *
     * @default false
     * @since 4.5.9
     * @param  value  Draw above series?
     */
    set: function set(value) {
      this.setPropertyValue("above", value, true);
    },
    enumerable: true,
    configurable: true
  });
  /**
   * @ignore
   */

  Grid.prototype.setDisabled = function (value) {
    var changed = _super.prototype.setDisabled.call(this, value);

    if (this.axis) {
      this.axis.invalidateDataItems();
    }

    return changed;
  };

  return Grid;
}(_core_Sprite__WEBPACK_IMPORTED_MODULE_1__["Sprite"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_2__["registry"].registeredClasses["Grid"] = Grid;
/**
 * Add default responsive rules
 */

/**
 * Disable grid on smaller charts
 */

_core_utils_Responsive__WEBPACK_IMPORTED_MODULE_5__["defaultRules"].push({
  relevant: _core_utils_Responsive__WEBPACK_IMPORTED_MODULE_5__["ResponsiveBreakpoints"].maybeXS,
  state: function state(target, stateId) {
    if (target instanceof Grid) {
      var state = target.states.create(stateId);
      state.properties.disabled = true;
      return state;
    }

    return null;
  }
});

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/GridCircular.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/axes/GridCircular.js ***!
  \********************************************************************************/
/*! exports provided: GridCircular */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "GridCircular", function() { return GridCircular; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Grid__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Grid */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/Grid.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/**
 * A module defining functionality for circular axis grid elements.
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */



/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Creates a circular grid element for circular-type axis.
 *
 * @see {@link IGridCircularEvents} for a list of available events
 * @see {@link IGridCircularAdapters} for a list of available Adapters
 * @todo Review: container is better, as we'll be able to attach something to the GridCircular, also with 3d charts we might need some additional elements
 */

var GridCircular =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(GridCircular, _super);
  /**
   * Constructor
   */


  function GridCircular() {
    var _this = _super.call(this) || this;

    _this.className = "GridCircular";
    _this.pixelPerfect = false;

    _this.applyTheme();

    return _this;
  }

  Object.defineProperty(GridCircular.prototype, "innerRadius", {
    /**
     * @return Inner radius
     */
    get: function get() {
      return this.getPropertyValue("innerRadius");
    },

    /**
     * Inner radius of the circular grid. (absolute or relative)
     *
     * @param value Inner radius
     */
    set: function set(value) {
      this.setPercentProperty("innerRadius", value, true, false, 10, false);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(GridCircular.prototype, "radius", {
    /**
     * @return Outer radius
     */
    get: function get() {
      return this.getPropertyValue("radius");
    },

    /**
     * Outer radius of the circular grid. (absolute or relative)
     *
     * @param value Outer radius
     */
    set: function set(value) {
      this.setPercentProperty("radius", value, true, false, 10, false);
    },
    enumerable: true,
    configurable: true
  });
  return GridCircular;
}(_Grid__WEBPACK_IMPORTED_MODULE_1__["Grid"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_2__["registry"].registeredClasses["GridCircular"] = GridCircular;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/ValueAxis.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/axes/ValueAxis.js ***!
  \*****************************************************************************/
/*! exports provided: ValueAxisDataItem, ValueAxis */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ValueAxisDataItem", function() { return ValueAxisDataItem; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ValueAxis", function() { return ValueAxis; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Axis__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Axis */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/Axis.js");
/* harmony import */ var _AxisRendererY__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./AxisRendererY */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisRendererY.js");
/* harmony import */ var _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/utils/Disposer */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Disposer.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _ValueAxisBreak__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./ValueAxisBreak */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/ValueAxisBreak.js");
/* harmony import */ var _core_utils_Math__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core/utils/Math */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Math.js");
/* harmony import */ var _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../core/utils/Iterator */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Iterator.js");
/* harmony import */ var _core_utils_Object__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../core/utils/Object */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Object.js");
/* harmony import */ var _core_utils_Type__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../core/utils/Type */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Type.js");
/* harmony import */ var _core_utils_Utils__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../core/utils/Utils */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Utils.js");
/**
 * Value Axis module
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */











/**
 * ============================================================================
 * DATA ITEM
 * ============================================================================
 * @hidden
 */

/**
 * Defines a [[DataItem]] for [[ValueAxis]].
 *
 * @see {@link DataItem}
 */

var ValueAxisDataItem =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(ValueAxisDataItem, _super);
  /**
   * Constructor
   */


  function ValueAxisDataItem() {
    var _this = _super.call(this) || this;

    _this.className = "ValueAxisDataItem";
    _this.values.value = {};
    _this.values.endValue = {};

    _this.applyTheme();

    return _this;
  }

  Object.defineProperty(ValueAxisDataItem.prototype, "value", {
    /**
     * @return Value
     */
    get: function get() {
      return this.values["value"].value;
    },

    /**
     * A data point's numeric value.
     *
     * @param value  Value
     */
    set: function set(value) {
      this.setValue("value", value);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ValueAxisDataItem.prototype, "endValue", {
    /**
     * @return Value
     */
    get: function get() {
      return this.values["endValue"].value;
    },

    /**
     * Data point's numeric end value.
     *
     * @param value  End value
     */
    set: function set(value) {
      this.setValue("endValue", value);
    },
    enumerable: true,
    configurable: true
  });
  return ValueAxisDataItem;
}(_Axis__WEBPACK_IMPORTED_MODULE_1__["AxisDataItem"]);


/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Used to create a value axis for the chart.
 *
 * ```TypeScript
 * // Create the axis
 * let valueAxis = chart.yAxes.push(new am4charts.ValueAxis());
 *
 * // Set settings
 * valueAxis.title.text = "Monthly Sales";
 * ```
 * ```JavaScript
 * // Create the axis
 * var valueAxis = chart.yAxes.push(new am4charts.ValueAxis());
 *
 * // Set settings
 * valueAxis.title.text = "Monthly Sales";
 * ```
 * ```JSON
 * "yAxes": [{
 *   "type": "ValueAxis",
 *   "title": {
 *     "text": "Monthly Sales"
 *   }
 * }]
 * ```
 *
 * @see {@link IValueAxisEvents} for a list of available Events
 * @see {@link IValueAxisAdapters} for a list of available Adapters
 * @important
 */

var ValueAxis =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(ValueAxis, _super);
  /**
   * Constructor
   */


  function ValueAxis() {
    var _this = // Init
    _super.call(this) || this;
    /**
     * [_stepDecimalPlaces description]
     *
     * @todo Description
     */


    _this._stepDecimalPlaces = 0;
    _this._prevStepDecimalPlaces = 0;
    _this._adjustLabelPrecision = true;
    /**
     * Base value for the axis.
     */

    _this._baseValue = 0;
    /**
     * Adjusted start in case we have breaks.
     *
     * @todo Description
     */

    _this._adjustedStart = 0;
    /**
     * Adjusted end in case we have breaks.
     *
     * @todo Description
     */

    _this._adjustedEnd = 1;
    _this._extremesChanged = false;
    _this._deltaMinMax = 1;
    _this._dsc = false;
    /**
     * As calculating totals is expensive operation and not often needed, we
     * don't do it by default.
     *
     * In case you use `totalPercent` or `total` in your charts, this must be set
     * to `true`.
     *
     * @default false
     * @see {@link https://www.amcharts.com/docs/v4/chart-types/xy-chart/#100_stacks} For using `calculateTotals` for 100% stacked series.
     * @see {@link https://www.amcharts.com/docs/v4/concepts/formatters/formatting-strings/#Placeholders_for_numeric_values} For using `calculateTotals` in labels.
     */

    _this.calculateTotals = false;
    _this.className = "ValueAxis"; // Set field name

    _this.axisFieldName = "value"; // Set defaults

    _this.setPropertyValue("maxZoomFactor", 1000);

    _this.setPropertyValue("extraMin", 0);

    _this.setPropertyValue("extraMax", 0);

    _this.setPropertyValue("strictMinMax", false);

    _this.setPropertyValue("maxPrecision", Number.MAX_VALUE);

    _this.setPropertyValue("adjustLabelPrecision", true);

    _this.setPropertyValue("extraTooltipPrecision", 0);

    _this.keepSelection = false;
    _this.includeRangesInMinMax = false; // Apply theme

    _this.applyTheme();

    return _this;
  }
  /**
   * Holds reference to a function that accepts a DataItem as parameter.
   *
   * It can either return a fill opacity for a fill, or manipulate data item
   * directly, to create various highlighting scenarios.
   */


  ValueAxis.prototype.fillRule = function (dataItem) {
    var value = dataItem.value;
    var axis = dataItem.component;

    if (!dataItem.axisFill.disabled) {
      // rounding in left to solve floating point number
      if (_core_utils_Math__WEBPACK_IMPORTED_MODULE_6__["round"](value / axis.step / 2, 5) == Math.round(value / axis.step / 2)) {
        dataItem.axisFill.__disabled = true;
      } else {
        dataItem.axisFill.__disabled = false;
      }
    }
  };
  /**
   * Returns a new/empty [[DataItem]] of the type appropriate for this object.
   *
   * @see {@link DataItem}
   * @return Data Item
   */


  ValueAxis.prototype.createDataItem = function () {
    return new ValueAxisDataItem();
  };
  /**
   * Returns a new/empty [[AxisBreak]] of the appropriate type.
   *
   * @return Axis break
   */


  ValueAxis.prototype.createAxisBreak = function () {
    return new _ValueAxisBreak__WEBPACK_IMPORTED_MODULE_5__["ValueAxisBreak"]();
  };
  /**
   * [dataChangeUpdate description]
   *
   * This is a placeholder to override for extending classes.
   *
   * @ignore Exclude from docs
   * @todo Description
   */


  ValueAxis.prototype.dataChangeUpdate = function () {
    this.clearCache();

    if (!this.keepSelection) {
      if (this._start != 0 || this._end != 1) {
        this._start = 0;
        this._end = 1;
        this.dispatchImmediately("startendchanged");
      }
    } else {
      if (this._start != 0) {
        this.dispatchImmediately("startchanged");
      }

      if (this._end != 1) {
        this.dispatchImmediately("endchanged");
      }

      if (this._start != 0 || this._end != 1) {
        this.dispatchImmediately("startendchanged");
      }
    }

    this._maxZoomed = this._maxDefined;
    this._minZoomed = this._minDefined;
    this._maxAdjusted = this._maxDefined;
    this._minAdjusted = this._minDefined;
  };
  /**
   * Processes data items of the related Series.
   *
   * @ignore Exclude from docs
   */


  ValueAxis.prototype.processSeriesDataItems = function () {
    // @todo: add some boolean (maybe autodedect) if we need these calculations or not. this place uses a lot of cpu
    if (this.calculateTotals) {
      var series = this.series.getIndex(0);
      var startIndex = series.startIndex;

      if (series.dataItems.length > 0) {
        if (startIndex > 0) {
          startIndex--;
        }

        var endIndex = series.endIndex;

        if (endIndex < series.dataItems.length) {
          endIndex++;
        }

        var _loop_1 = function _loop_1(i) {
          // This has to be `var` in order to avoid garbage collection
          var total = {};
          var sum = {};
          this_1.series.each(function (series) {
            if (!series.excludeFromTotal) {
              var dataItem_1 = series.dataItems.getIndex(i);

              if (dataItem_1) {
                _core_utils_Object__WEBPACK_IMPORTED_MODULE_8__["each"](dataItem_1.values, function (key) {
                  var value = dataItem_1.values[key].workingValue; // can not use getWorkingValue here!

                  if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](value)) {
                    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](total[key])) {
                      total[key] = Math.abs(value);
                    } else {
                      total[key] += Math.abs(value);
                    }

                    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](sum[key])) {
                      sum[key] = value;
                    } else {
                      sum[key] += value;
                    }
                  }
                });
              }
            }
          });
          this_1.series.each(function (series) {
            if (!series.excludeFromTotal) {
              var dataItem_2 = series.dataItems.getIndex(i);

              if (dataItem_2) {
                _core_utils_Object__WEBPACK_IMPORTED_MODULE_8__["each"](dataItem_2.values, function (key) {
                  var value = dataItem_2.values[key].workingValue; // can not use getWorkingValue here!

                  if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](value)) {
                    dataItem_2.setCalculatedValue(key, total[key], "total");
                    dataItem_2.setCalculatedValue(key, 100 * value / total[key], "totalPercent");
                    dataItem_2.setCalculatedValue(key, sum[key], "sum");
                  }
                });
              }
            }
          });
        };

        var this_1 = this; // This has to be `var` in order to avoid garbage collection

        for (var i = startIndex; i < endIndex; ++i) {
          _loop_1(i);
        }
      }
    }
  };
  /**
   * Validates the whole axis. Causes it to redraw.
   *
   * @ignore Exclude from docs
   * @todo Description (review)
   */


  ValueAxis.prototype.validate = function () {
    if (this.axisLength <= 0) {
      return;
    }

    _super.prototype.validate.call(this);

    this.getMinMax();
    this.fixAxisBreaks();
    this.calculateZoom();
    this.validateAxisElements();
    this.validateAxisRanges();
    this.validateBreaks();
    this.hideUnusedDataItems();
    this.renderer.invalidateLayout(); // hide too close
    //this.hideTooCloseDataItems();
  };
  /**
   * Calculates all positions, related to axis as per current zoom.
   *
   * @ignore Exclude from docs
   */


  ValueAxis.prototype.calculateZoom = function () {
    if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](this.min) && _core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](this.max)) {
      var min = this.positionToValue(this.start);
      var max = this.positionToValue(this.end);
      var differece = this.adjustDifference(min, max);
      var minMaxStep = this.adjustMinMax(min, max, differece, this._gridCount, true);
      var stepDecimalPlaces = _core_utils_Utils__WEBPACK_IMPORTED_MODULE_10__["decimalPlaces"](minMaxStep.step);
      this._stepDecimalPlaces = stepDecimalPlaces;
      min = _core_utils_Math__WEBPACK_IMPORTED_MODULE_6__["round"](min, stepDecimalPlaces);
      max = _core_utils_Math__WEBPACK_IMPORTED_MODULE_6__["round"](max, stepDecimalPlaces);
      minMaxStep = this.adjustMinMax(min, max, differece, this._gridCount, true);
      var step = minMaxStep.step;

      if (this.syncWithAxis) {
        var calculated = this.getCache(min + "-" + max);

        if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](calculated)) {
          step = calculated;
        }
      } else {
        min = minMaxStep.min;
        max = minMaxStep.max;
      }

      if (this._minZoomed != min || this._maxZoomed != max || this._step != step || this._dsc) {
        this._dsc = false;
        this._minZoomed = min;
        this._maxZoomed = max;
        this._step = step;
        this.dispatchImmediately("selectionextremeschanged");
      }
    }
  };

  ValueAxis.prototype.fixSmallStep = function (step) {
    if (1 + step == 1) {
      step *= 2;
      return this.fixSmallStep(step);
    }

    return step;
  };
  /**
   * Validates Axis elements.
   *
   * @ignore Exclude from docs
   * @todo Description
   */


  ValueAxis.prototype.validateAxisElements = function () {
    var _this = this;

    if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](this.max) && _core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](this.min)) {
      // first regular items
      var value_1 = this.minZoomed - this._step * 2;

      if (!this.logarithmic) {
        value_1 = Math.floor(value_1 / this._step) * this._step;
      } else {
        var differencePower = Math.log(this.max) * Math.LOG10E - Math.log(this.min) * Math.LOG10E;

        if (differencePower > 1) {
          value_1 = Math.pow(10, Math.log(this.min) * Math.LOG10E);
        } else {
          value_1 = Math.floor(this.minZoomed / this._step) * this._step;

          if (value_1 == 0) {
            value_1 = this.minZoomed;
          }
        }
      }

      var maxZoomed = this._maxZoomed + this._step;
      this.resetIterators();
      var dataItemsIterator_1 = this._dataItemsIterator;

      if (this._step == 0) {
        return;
      }

      this._step = this.fixSmallStep(this._step);
      var i = 0;
      var precisionChanged = this._prevStepDecimalPlaces != this._stepDecimalPlaces;
      this._prevStepDecimalPlaces = this._stepDecimalPlaces;

      while (value_1 <= maxZoomed) {
        var axisBreak = this.isInBreak(value_1);

        if (!axisBreak) {
          var dataItem = dataItemsIterator_1.find(function (x) {
            return x.value === value_1;
          });

          if (dataItem.__disabled) {
            dataItem.__disabled = false;
          } //this.processDataItem(dataItem);


          this.appendDataItem(dataItem);
          dataItem.axisBreak = undefined;

          if (dataItem.value != value_1 || precisionChanged) {
            dataItem.value = value_1;
            dataItem.text = this.formatLabel(value_1);

            if (dataItem.label && dataItem.label.invalid) {
              dataItem.label.validate();
            }

            if (dataItem.value >= this.min && dataItem.value <= this.max) {
              if (dataItem.label) {
                if (this.axisLetter == "Y" && dataItem.label.measuredWidth > this.ghostLabel.measuredWidth || this.axisLetter == "X" && dataItem.label.measuredHeight > this.ghostLabel.measuredHeight) {
                  this.ghostLabel.text = dataItem.label.currentText;
                  this.ghostLabel.validate();
                }
              }
            }
          }

          this.validateDataElement(dataItem);
        }

        i++;
        var oldValue = value_1;

        if (!this.logarithmic) {
          value_1 += this._step;
        } else {
          var differencePower = Math.log(this.max) * Math.LOG10E - Math.log(this.min) * Math.LOG10E;

          if (differencePower > 1) {
            value_1 = Math.pow(10, Math.log(this.min) * Math.LOG10E + i);
          } else {
            value_1 += this._step;
          }
        }

        var stepPower = Math.pow(10, Math.floor(Math.log(Math.abs(this._step)) * Math.LOG10E));

        if (stepPower < 1) {
          // exponent is less then 1 too. Count decimals of exponent
          var decCount = Math.round(Math.abs(Math.log(Math.abs(stepPower)) * Math.LOG10E)) + 2;
          decCount = Math.min(13, decCount); // round value to avoid floating point issues

          value_1 = _core_utils_Math__WEBPACK_IMPORTED_MODULE_6__["round"](value_1, decCount); // ceil causes problems: https://codepen.io/team/amcharts/pen/XWMjZwy?editors=1010

          if (oldValue == value_1) {
            value_1 = maxZoomed;
            break;
          }
        }
      }

      var axisBreaks = this._axisBreaks;

      if (axisBreaks) {
        // breaks later
        var renderer_1 = this.renderer;
        _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_7__["each"](axisBreaks.iterator(), function (axisBreak) {
          if (axisBreak.breakSize > 0) {
            // only add grid if gap is bigger then minGridDistance
            if (_core_utils_Math__WEBPACK_IMPORTED_MODULE_6__["getDistance"](axisBreak.startPoint, axisBreak.endPoint) > renderer_1.minGridDistance) {
              var breakValue_1 = axisBreak.adjustedMin;

              while (breakValue_1 <= axisBreak.adjustedMax) {
                if (breakValue_1 >= axisBreak.adjustedStartValue && breakValue_1 <= axisBreak.adjustedEndValue) {
                  var dataItem = dataItemsIterator_1.find(function (x) {
                    return x.value === breakValue_1;
                  });

                  if (dataItem.__disabled) {
                    dataItem.__disabled = false;
                  } //this.processDataItem(dataItem);


                  _this.appendDataItem(dataItem);

                  dataItem.axisBreak = axisBreak;

                  if (dataItem.value != breakValue_1) {
                    dataItem.value = breakValue_1;
                    dataItem.text = _this.formatLabel(breakValue_1);

                    if (dataItem.label && dataItem.label.invalid) {
                      dataItem.label.validate();
                    }
                  }

                  _this.validateDataElement(dataItem);
                }

                breakValue_1 += axisBreak.adjustedStep;
              }
            }
          }
        });
      }
    }
  };
  /**
   * Validates axis data item.
   *
   * @ignore Exclude from docs
   * @todo Description
   * @param dataItem  Data item
   */


  ValueAxis.prototype.validateDataElement = function (dataItem) {
    _super.prototype.validateDataElement.call(this, dataItem); //dataItem.__disabled = false;


    dataItem.itemIndex = this._axisItemCount;
    this._axisItemCount++;
    var renderer = this.renderer;
    var value = dataItem.value;
    var endValue = dataItem.endValue;
    var position = this.valueToPosition(value);
    dataItem.position = position;
    var endPosition = position;
    var fillEndPosition = this.valueToPosition(value + this._step);

    if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](endValue)) {
      endPosition = this.valueToPosition(endValue);
      fillEndPosition = endPosition;
    } // this point is needed to calculate distance to satisfy minGridDistance


    dataItem.point = renderer.positionToPoint(position);
    var tick = dataItem.tick;

    if (tick && !tick.disabled) {
      renderer.updateTickElement(tick, position, endPosition);
    }

    var grid = dataItem.grid;

    if (grid && !grid.disabled) {
      renderer.updateGridElement(grid, position, endPosition);
    }

    var label = dataItem.label;

    if (label && !label.disabled) {
      renderer.updateLabelElement(label, position, endPosition);
    }

    var fill = dataItem.axisFill;

    if (fill && !fill.disabled) {
      renderer.updateFillElement(fill, position, fillEndPosition);

      if (!dataItem.isRange) {
        this.fillRule(dataItem);
      }
    }

    if (dataItem.bullet) {
      renderer.updateBullet(dataItem.bullet, position, endPosition);
    }

    var mask = dataItem.mask;

    if (mask) {
      renderer.updateFillElement(mask, position, fillEndPosition);
    }
  };
  /**
   * Formats the value according to axis' own [[NumberFormatter]].
   *
   * @param value  Source value
   * @return Formatted value
   */


  ValueAxis.prototype.formatLabel = function (value) {
    if (this.adjustLabelPrecision && value != 0) {
      return this.numberFormatter.format(value, undefined, this._stepDecimalPlaces);
    } else {
      return this.numberFormatter.format(value);
    }
  };

  Object.defineProperty(ValueAxis.prototype, "basePoint", {
    /**
     * Coordinates of the actual axis start.
     *
     * @ignore Exclude from docs
     * @return Base point
     */
    get: function get() {
      var baseValue = this.baseValue;
      var position = this.valueToPosition(baseValue);
      var basePoint = this.renderer.positionToPoint(position);
      return basePoint;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ValueAxis.prototype, "baseValue", {
    /**
     * @return base value
     */
    get: function get() {
      var baseValue = this._baseValue;

      if (this.logarithmic) {
        baseValue = this.min;
      }

      if (!this._adapterO) {
        return baseValue;
      } else {
        return this._adapterO.apply("baseValue", baseValue);
      }
    },

    /**
     * A base value.
     *
     * This is a threshold value that will divide "positive" and "negative"
     * value ranges.
     *
     * Other scale-related functionality also depend on base value. E.g. stacks,
     * value-dependent coloring, etc.
     *
     * @param value Base value
     */
    set: function set(value) {
      this._baseValue = value;
      this.invalidateLayout();
      this.invalidateSeries();
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Converts a numeric value to relative position on axis
   *
   * An alias to `valueToPosition()`.
   *
   * @param value  Value
   * @return Position
   */

  ValueAxis.prototype.anyToPosition = function (value) {
    return this.valueToPosition(value);
  };
  /**
   * Converts a numeric value to orientation point (x, y, angle) on axis
   *
   * @param value  Value
   * @return Orientation point
   */


  ValueAxis.prototype.valueToPoint = function (value) {
    var position = this.valueToPosition(value);
    var point = this.renderer.positionToPoint(position);
    var angle = this.renderer.positionToAngle(position);
    return {
      x: point.x,
      y: point.y,
      angle: angle
    };
  };
  /**
   * Converts a numeric value to orientation (x, y, angle) point on axis
   *
   * @param value  Value
   * @return Orientation point
   */


  ValueAxis.prototype.anyToPoint = function (value) {
    return this.valueToPoint(value);
  };
  /**
   * Converts a numeric value to relative position on axis.
   *
   * @param value  Value
   * @return relative position
   */


  ValueAxis.prototype.valueToPosition = function (value) {
    if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](value)) {
      // todo: think if possible to take previous value and do not go through all previous breaks
      var min_1 = this.min;
      var max_1 = this.max;

      if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](min_1) && _core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](max_1)) {
        var difference = this._difference;
        var axisBreaks = this._axisBreaks;

        if (axisBreaks && axisBreaks.length > 0) {
          _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_7__["eachContinue"](axisBreaks.iterator(), function (axisBreak) {
            var startValue = axisBreak.adjustedStartValue;
            var endValue = axisBreak.adjustedEndValue;

            if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](startValue) && _core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](endValue)) {
              if (value < startValue) {
                return false;
              }

              if (_core_utils_Math__WEBPACK_IMPORTED_MODULE_6__["intersect"]({
                start: startValue,
                end: endValue
              }, {
                start: min_1,
                end: max_1
              })) {
                // todo: check this once and set some flag in axisBreak
                startValue = Math.max(startValue, min_1);
                endValue = Math.min(endValue, max_1);
                var breakSize = axisBreak.breakSize; // value to the right of break end

                if (value > endValue) {
                  min_1 += (endValue - startValue) * (1 - breakSize); // todo: maybe this can be done differently?
                } // value to the left of break start
                else if (value < startValue) {} // value within break
                  else {
                      value = startValue + (value - startValue) * breakSize;
                    }
              }
            }

            return true;
          });
        }

        var position = void 0;

        if (!this.logarithmic) {
          position = (value - min_1) / difference;
        } else {
          var treatZeroAs = this.treatZeroAs;

          if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](treatZeroAs)) {
            if (value <= treatZeroAs) {
              value = treatZeroAs;
            }
          }

          position = (Math.log(value) * Math.LOG10E - Math.log(this.min) * Math.LOG10E) / (Math.log(this.max) * Math.LOG10E - Math.log(this.min) * Math.LOG10E);
        } //position = $math.round(position, 10);


        return position;
      }
    }

    return 0;
  };
  /**
   * When fontSize of fontFamily changes we need to hard-invalidate all Labels of this container to position them properly.
   */


  ValueAxis.prototype.invalidateLabels = function () {
    _super.prototype.invalidateLabels.call(this);

    if (this.dataItems) {
      this.dataItems.each(function (dataItem) {
        dataItem.value = undefined;
      });
      this.invalidate();
    }
  };
  /**
   * Converts an relative position to a corresponding value within
   * axis' scale.
   *
   * @param position  Position (px)
   * @return Value
   */


  ValueAxis.prototype.positionToValue = function (position) {
    var min = this.min;
    var max = this.max;

    if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](min) && _core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](max)) {
      var difference_1 = max - min; //no need to adjust!

      var value_2 = null;
      var axisBreaks = this._axisBreaks;

      if (axisBreaks) {
        // in case we have some axis breaks
        if (axisBreaks.length > 0) {
          _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_7__["eachContinue"](axisBreaks.iterator(), function (axisBreak) {
            var breakStartPosition = axisBreak.startPosition;
            var breakEndPosition = axisBreak.endPosition;
            var breakStartValue = axisBreak.adjustedStartValue;
            var breakEndValue = axisBreak.adjustedEndValue;

            if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](breakStartValue) && _core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](breakEndValue)) {
              if (breakStartValue > max) {
                return false;
              }

              if (_core_utils_Math__WEBPACK_IMPORTED_MODULE_6__["intersect"]({
                start: breakStartValue,
                end: breakEndValue
              }, {
                start: min,
                end: max
              })) {
                breakStartValue = _core_utils_Math__WEBPACK_IMPORTED_MODULE_6__["max"](breakStartValue, min);
                breakEndValue = _core_utils_Math__WEBPACK_IMPORTED_MODULE_6__["min"](breakEndValue, max);
                var breakSize = axisBreak.breakSize;
                difference_1 -= (breakEndValue - breakStartValue) * (1 - breakSize); // position to the right of break end

                if (position > breakEndPosition) {
                  min += (breakEndValue - breakStartValue) * (1 - breakSize);
                } // position to the left of break start
                else if (position < breakStartPosition) {} // value within break
                  else {
                      var breakPosition = (position - breakStartPosition) / (breakEndPosition - breakStartPosition);
                      value_2 = breakStartValue + breakPosition * (breakEndValue - breakStartValue);
                      return false;
                    }
              }

              return true;
            }
          });
        }
      }

      if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](value_2)) {
        if (this.logarithmic) {
          value_2 = Math.pow(Math.E, (position * (Math.log(this.max) * Math.LOG10E - Math.log(this.min) * Math.LOG10E) + Math.log(this.min) * Math.LOG10E) / Math.LOG10E);
        } else {
          value_2 = position * difference_1 + min;
        }
      }

      return value_2;
    } //}

  };
  /**
   * Converts an X coordinate to a relative value in axis' scale.
   *
   * @param x  X (px)
   * @return Value
   */


  ValueAxis.prototype.xToValue = function (x) {
    return this.positionToValue(this.pointToPosition({
      x: x,
      y: 0
    }));
  };
  /**
   * Converts an Y coordinate to a relative value in axis' scale.
   *
   * @param y  Y (px)
   * @return Value
   */


  ValueAxis.prototype.yToValue = function (y) {
    return this.positionToValue(this.pointToPosition({
      x: 0,
      y: y
    }));
  };
  /**
   * Converts pixel coordinates to a relative position. (0-1)
   *
   * @param point  Coorinates (px)
   * @return Position (0-1)
   */


  ValueAxis.prototype.pointToPosition = function (point) {
    if (this.renderer instanceof _AxisRendererY__WEBPACK_IMPORTED_MODULE_2__["AxisRendererY"]) {
      return 1 - this.renderer.pointToPosition(point);
    } else {
      return this.renderer.pointToPosition(point);
    }
  };
  /**
   * @ignore
   */


  ValueAxis.prototype.animateMinMax = function (min, max) {
    return this.animate([{
      property: "_minAdjusted",
      from: this._minAdjusted,
      to: min
    }, {
      property: "_maxAdjusted",
      from: this._maxAdjusted,
      to: max
    }], this.rangeChangeDuration, this.rangeChangeEasing);
  };
  /**
   * Calculates smallest and biggest value for the axis scale.
   * @ignore
   * @todo Description (review)
   */


  ValueAxis.prototype.getMinMax = function () {
    var _this = this;

    this.updateGridCount();
    var min = Number.POSITIVE_INFINITY;
    var max = Number.NEGATIVE_INFINITY; // only if min and max are not set from outside, we go through min and max influencers

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](this._minDefined) || !_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](this._maxDefined)) {
      this.series.each(function (series) {
        if (!series.ignoreMinMax) {
          // check min
          var seriesMin = series.min(_this);

          if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](seriesMin) && seriesMin < min) {
            min = seriesMin;
          } // check max


          var seriesMax = series.max(_this);

          if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](seriesMax) && seriesMax > max) {
            max = seriesMax;
          }
        }
      });

      if (this.includeRangesInMinMax) {
        this.axisRanges.each(function (range) {
          if (!range.ignoreMinMax) {
            var minValue = _core_utils_Math__WEBPACK_IMPORTED_MODULE_6__["min"](range.value, range.endValue);
            var maxValue = _core_utils_Math__WEBPACK_IMPORTED_MODULE_6__["max"](range.value, range.endValue);

            if (minValue < min || !_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](min)) {
              min = minValue;
            }

            if (maxValue > max || !_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](max)) {
              max = maxValue;
            }
          }
        });
      }
    }

    if (this.logarithmic) {
      var treatZeroAs = this.treatZeroAs;

      if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](treatZeroAs)) {
        if (min <= 0) {
          min = treatZeroAs;
        }
      }

      if (min <= 0) {
        this.raiseCriticalError(new Error("Logarithmic value axis can not have values <= 0."), true);
      }
    }

    if (min == 0 && max == 0) {
      max = 0.9;
      min = -0.9;
    } // if defined from outside


    if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](this._minDefined)) {
      min = this._minDefined;
    }

    if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](this._maxDefined)) {
      max = this._maxDefined;
    }

    if (this._adapterO) {
      min = this._adapterO.apply("min", min);
    }

    if (this._adapterO) {
      max = this._adapterO.apply("max", max);
    }

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](min) || !_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](max)) {
      return;
    }

    this._minReal = min;
    this._maxReal = max;

    if (min == Number.POSITIVE_INFINITY) {
      min = undefined;
    }

    if (max == Number.NEGATIVE_INFINITY) {
      max = undefined;
    }

    var dif = this.adjustDifference(min, max); // previously it was max-min, but not worked well

    min = this.fixMin(min);
    max = this.fixMax(max); // this happens if starLocation and endLocation are 0.5 and DateAxis has only one date

    if (max - min <= 1 / Math.pow(10, 15)) {
      if (max - min != 0) {
        this._deltaMinMax = (max - min) / 2;
      } else {
        // the number by which we need to raise 10 to get difference
        var exponent = Math.log(Math.abs(max)) * Math.LOG10E; // here we find a number which is power of 10 and has the same count of numbers as difference has

        var power = Math.pow(10, Math.floor(exponent)); // reduce this number by 10 times

        power = power / 10;
        this._deltaMinMax = power;
      }

      min -= this._deltaMinMax;
      max += this._deltaMinMax;
    }

    min -= (max - min) * this.extraMin;
    max += (max - min) * this.extraMax;
    var strict = this.strictMinMax;

    if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](this._maxDefined)) {
      strict = true;
    }

    var minMaxStep = this.adjustMinMax(min, max, dif, this._gridCount, strict);
    min = minMaxStep.min;
    max = minMaxStep.max;
    dif = max - min; //new
    // do it for the second time (importat!)

    minMaxStep = this.adjustMinMax(min, max, max - min, this._gridCount, true);
    min = minMaxStep.min;
    max = minMaxStep.max; // return min max if strict

    if (this.strictMinMax) {
      if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](this._minDefined)) {
        min = this._minDefined;
      } else {
        min = this._minReal;
      }

      if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](this._maxDefined)) {
        max = this._maxDefined;
      } else {
        max = this._maxReal;
      }

      if (max - min <= 0.00000001) {
        min -= this._deltaMinMax;
        max += this._deltaMinMax;
      }

      min -= (max - min) * this.extraMin;
      max += (max - min) * this.extraMax;
    }

    if (this._adapterO) {
      min = this._adapterO.apply("min", min);
    }

    if (this._adapterO) {
      max = this._adapterO.apply("max", max);
    }

    this._step = minMaxStep.step;

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](min) && !_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](max)) {
      this.start = 0;
      this.end = 1;
      this.renderer.labels.each(function (label) {
        label.dataItem.text = "";
      });
    } // checking isNumber is good when all series are hidden


    if ((this._minAdjusted != min || this._maxAdjusted != max) && _core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](min) && _core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](max)) {
      var animation = this._minMaxAnimation;

      if (this._extremesChanged && _core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](this._minAdjusted) && _core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](this._maxAdjusted) && this.inited) {
        if (animation && !animation.isFinished() && this._finalMax == max && this._finalMin == min) {
          return;
        } else {
          this._finalMin = min;
          this._finalMax = max;
          animation = this.animateMinMax(min, max);

          if (animation && !animation.isFinished()) {
            animation.events.on("animationprogress", this.validateDataItems, this);
            animation.events.on("animationended", function () {
              //this.validateDataItems();
              _this.series.each(function (series) {
                series.validate();
              });

              _this.validateDataItems();

              _this.handleSelectionExtremesChange();
            });
            this._minMaxAnimation = animation;
          } else {
            this.series.each(function (series) {
              series.invalidate();
            });
          }

          this.validateDataItems();
          this.dispatchImmediately("extremeschanged");
          this.handleSelectionExtremesChange();
        }
      } else {
        if (animation && !animation.isFinished() && this._finalMax == max && this._finalMin == min) {
          return;
        } else {
          this._minAdjusted = min;
          this._maxAdjusted = max;
          this._finalMin = min;
          this._finalMax = max;
          this.invalidateDataItems();
          this.dispatchImmediately("extremeschanged");
        }
      }
    }

    this._extremesChanged = false;
    this._difference = this.adjustDifference(min, max);
  };
  /**
   * Adjusts the minimum value.
   *
   * This is a placeholder method for extending classes to override.
   *
   * For numeric values this does nothing, however for more complex types, like
   * dates, it may be necessary to adjust.
   *
   * @param value  Value
   * @return Adjusted value
   */


  ValueAxis.prototype.fixMin = function (value) {
    return value;
  };
  /**
   * Adjusts the maximum value.
   *
   * This is a placeholder method for extending classes to override.
   *
   * For numeric values this does nothing, however for more complex types, like
   * dates, it may be necessary to adjust.
   *
   * @param value  Value
   * @return Adjusted value
   */


  ValueAxis.prototype.fixMax = function (value) {
    return value;
  };
  /**
   * Adjusts actual min and max scale values so that the axis starts and ends
   * at "nice" values, unless `strictMinMax` is set.
   *
   * The `difference` can be something else than `max - min`, because of the
   * axis breaks.
   *
   * @ignore Exclude from docs
   * @todo Description
   * @param min        [description]
   * @param max        [description]
   * @param difference [description]
   * @param gridCount  [description]
   * @param strictMode [description]
   * @return [description]
   */


  ValueAxis.prototype.adjustMinMax = function (min, max, difference, gridCount, strictMode) {
    // will fail if 0
    if (gridCount <= 1) {
      gridCount = 1;
    }

    gridCount = Math.round(gridCount);
    var initialMin = min;
    var initialMax = max; // in case min and max is the same, use max

    if (difference === 0) {
      difference = Math.abs(max);
    } // the number by which we need to raise 10 to get difference


    var exponent = Math.log(Math.abs(difference)) * Math.LOG10E; // here we find a number which is power of 10 and has the same count of numbers as difference has

    var power = Math.pow(10, Math.floor(exponent)); // reduce this number by 10 times

    power = power / 10;
    var extra = power;

    if (strictMode) {
      extra = 0;
    }

    if (!this.logarithmic) {
      // round down min
      if (strictMode) {
        min = Math.floor(min / power) * power; // round up max

        max = Math.ceil(max / power) * power;
      } else {
        min = Math.ceil(min / power) * power - extra; // round up max

        max = Math.floor(max / power) * power + extra;
      } // don't let min go below 0 if real min is >= 0


      if (min < 0 && initialMin >= 0) {
        min = 0;
      } // don't let max go above 0 if real max is <= 0


      if (max > 0 && initialMax <= 0) {
        max = 0;
      }
    } else {
      if (min <= 0) {
        //throw Error("Logarithmic value axis can not have values <= 0.");
        min = this.baseValue;
      } // @todo: think of a better way or to restrict zooming when no series are selected


      if (min == Infinity) {
        min = 1;
      }

      if (max == -Infinity) {
        max = 10;
      }

      if (this.strictMinMax) {
        if (this._minDefined > 0) {
          min = this._minDefined;
        } else {
          min = min;
        }

        if (this._maxDefined > 0) {
          max = max;
        }
      } else {
        min = Math.pow(10, Math.floor(Math.log(Math.abs(min)) * Math.LOG10E));
        max = Math.pow(10, Math.ceil(Math.log(Math.abs(max)) * Math.LOG10E));
      }
    } // repeat diff, exponent and power again with rounded values
    //difference = this.adjustDifference(min, max);

    /*
              if(min > initialMin){
                min = initialMin;
            }
              if(max < initialMax){
                max = initialMax;
            }
    */


    exponent = Math.log(Math.abs(difference)) * Math.LOG10E;
    power = Math.pow(10, Math.floor(exponent));
    power = power / 10; // approximate difference between two grid lines

    var step = Math.ceil(difference / gridCount / power) * power;
    var stepPower = Math.pow(10, Math.floor(Math.log(Math.abs(step)) * Math.LOG10E)); // TODO: in v3 I had fixStepE here, ommiting it for a while, need to think about other solution
    // the step should divide by  2, 5, and 10.

    var stepDivisor = Math.ceil(step / stepPower); // number 0 - 10

    if (stepDivisor > 5) {
      stepDivisor = 10;
    } else if (stepDivisor <= 5 && stepDivisor > 2) {
      stepDivisor = 5;
    } // now get real step


    step = Math.ceil(step / (stepPower * stepDivisor)) * stepPower * stepDivisor;

    if (this.maxPrecision < Number.MAX_VALUE && step != _core_utils_Math__WEBPACK_IMPORTED_MODULE_6__["ceil"](step, this.maxPrecision)) {
      step = _core_utils_Math__WEBPACK_IMPORTED_MODULE_6__["ceil"](step, this.maxPrecision);
    }

    var decCount = 0; // in case numbers are smaller than 1

    if (stepPower < 1) {
      // exponent is less then 1 too. Count decimals of exponent
      decCount = Math.round(Math.abs(Math.log(Math.abs(stepPower)) * Math.LOG10E)) + 1; // round step

      step = _core_utils_Math__WEBPACK_IMPORTED_MODULE_6__["round"](step, decCount);
    }

    if (!this.logarithmic) {
      // final min and max
      var minCount = Math.floor(min / step);
      min = _core_utils_Math__WEBPACK_IMPORTED_MODULE_6__["round"](step * minCount, decCount);
      var maxCount = void 0;

      if (!strictMode) {
        maxCount = Math.ceil(max / step);
      } else {
        maxCount = Math.floor(max / step);
      }

      if (maxCount == minCount) {
        maxCount++;
      }

      max = _core_utils_Math__WEBPACK_IMPORTED_MODULE_6__["round"](step * maxCount, decCount);

      if (max < initialMax) {
        max = max + step;
      }

      if (min > initialMin) {
        min = min - step;
      }
    }

    return {
      min: min,
      max: max,
      step: step
    };
  };

  Object.defineProperty(ValueAxis.prototype, "min", {
    /**
     * @return Min value
     */
    get: function get() {
      var min = this._minAdjusted;

      if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](min)) {
        min = this._minDefined;
      }

      return min;
    },

    /**
     * A minimum value for the axis scale.
     *
     * This value might be auto-adjusted by the Axis in order to accomodate the
     * grid nicely, i.e. plot area is divided by grid in nice equal cells.
     *
     * The above might be overridden by `strictMinMax` which will force exact
     * user-defined min and max values to be used for scale.
     *
     * @param value  Min value
     */
    set: function set(value) {
      if (this._minDefined != value) {
        this._minDefined = value;
        this.invalidate();
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ValueAxis.prototype, "minDefined", {
    /**
     * Min value as defined by user's code, not auto-calculated.
     *
     * @readonly
     * @return Min value
     */
    get: function get() {
      return this._minDefined;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ValueAxis.prototype, "maxDefined", {
    /**
     * Max value as defined by user's code, not auto-calculated.
     *
     * @readonly
     * @return Man value
     */
    get: function get() {
      return this._maxDefined;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ValueAxis.prototype, "extraMin", {
    /**
     * @return {number}
     */
    get: function get() {
      return this.getPropertyValue("extraMin");
    },

    /**
     * Allows relatively adjusting minimum value of the axis' scale.
     *
     * The value is relative to the actual range of values currently displayed
     * on the axis.
     *
     * E.g.: 0.5 will mean half of the current range. If we have axis displaying
     * from 100 to 200, we will now have axis displaying from 50 to 200 because
     * we asked to expand minimum value by 50% (0.5).
     *
     * NOTE: this setting is not compatible with `strictMinMax`.
     *
     * @param {number}
     */
    set: function set(value) {
      if (this.setPropertyValue("extraMin", value)) {
        this.invalidateDataItems();
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ValueAxis.prototype, "extraMax", {
    /**
     * @return Min multiplier
     */
    get: function get() {
      return this.getPropertyValue("extraMax");
    },

    /**
     * Allows relatively adjusting maximum value of the axis' scale.
     *
     * The value is relative to the actual range of values currently displayed
     * on the axis.
     *
     * E.g.: 0.5 will mean half of the current range. If we have axis displaying
     * from 100 to 200, we will now have axis displaying from 100 to 250 because
     * we asked to expand maximum value by 50% (0.5).
     *
     * NOTE: this setting is not compatible with `strictMinMax`.
     *
     * @param {number}
     */
    set: function set(value) {
      if (this.setPropertyValue("extraMax", value)) {
        this.invalidateDataItems();
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ValueAxis.prototype, "step", {
    /**
     * Current calculated delta in values between two adjacent grid lines (step).
     *
     * This is a read-only value and cannot be used to set actual step.
     *
     * @readonly
     * @see {@link https://www.amcharts.com/docs/v4/concepts/axes/positioning-axis-elements/#Setting_the_density_of_the_the_grid_labels} For more information about modifying density of labels
     * @return [description]
     */
    get: function get() {
      return this._step;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ValueAxis.prototype, "max", {
    /**
     * @return Max value
     */
    get: function get() {
      var max = this._maxAdjusted;

      if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](max)) {
        max = this._maxDefined;
      }

      return max;
    },

    /**
     * A maximum value for the axis scale.
     *
     * This value might be auto-adjusted by the Axis in order to accomodate the
     * grid nicely, i.e. plot area is divided by grid in nice equal cells.
     *
     * The above might be overridden by `strictMinMax` which will force exact
     * user-defined min and max values to be used for scale.
     *
     * @param value  Max value
     */
    set: function set(value) {
      if (this._maxDefined != value) {
        this._maxDefined = value;
        this.invalidate();
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ValueAxis.prototype, "adjustLabelPrecision", {
    /**
     * @return Adjust precision
     */
    get: function get() {
      return this.getPropertyValue("adjustLabelPrecision");
    },

    /**
     * By default the axis will adjust precision of all numbers to match number
     * of decimals in all its labels, e.g.: `1.0`, `1.5`, `2.0`.
     *
     * To disable set `adjustLabelPrecision` to `false`, to use whatever other
     * precision or number format settings are set.
     *
     * IMPORTANT: This setting will be ignored if your number format uses
     * modifiers, e.g. `"#a"`.
     *
     * @default true
     * @since 4.9.14
     * @param  value  Adjust precision
     */
    set: function set(value) {
      if (this.setPropertyValue("adjustLabelPrecision", value)) {
        this.invalidate();
      }
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Used for the Series to register itself as the user of this Axis.
   *
   * This will also decorate both the Series and Axis with event handlers, used
   * to redraw on Axis position/zoom change.
   *
   * A disposer for those events is returned, so that they can be disposed
   * together with Series.
   *
   * @ignore Exclude from docs
   * @param series  Series
   * @return Disposer for events
   */

  ValueAxis.prototype.registerSeries = function (series) {
    return new _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_3__["MultiDisposer"]([_super.prototype.registerSeries.call(this, series), series.events.on("extremeschanged", this.handleExtremesChange, this, false), series.events.on("selectionextremeschanged", this.handleSelectionExtremesChange, this, false), this.events.on("extremeschanged", series.invalidate, series, false)]);
  };
  /**
   * Perform tasks after Axis zoom.
   */


  ValueAxis.prototype.handleSelectionExtremesChange = function () {
    var _this = this;

    var selectionMin;
    var selectionMax;
    var allHidden = true;
    _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_7__["each"](this.series.iterator(), function (series) {
      if (!series.ignoreMinMax && !series.isHidden && !series.outOfRange) {
        if (series.visible && !series.isHiding) {
          allHidden = false;
        }

        var seriesSelectionMin = series.selectionMin(_this);
        var seriesSelectionMax = series.selectionMax(_this);

        if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](seriesSelectionMin)) {
          if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](selectionMin) || seriesSelectionMin < selectionMin) {
            selectionMin = seriesSelectionMin;
          }
        } // check max


        if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](seriesSelectionMax)) {
          if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](selectionMax) || seriesSelectionMax > selectionMax) {
            selectionMax = seriesSelectionMax;
          }
        }
      }
    });

    if (this.includeRangesInMinMax) {
      this.axisRanges.each(function (range) {
        if (!range.ignoreMinMax) {
          var minValue = _core_utils_Math__WEBPACK_IMPORTED_MODULE_6__["min"](range.value, range.endValue);
          var maxValue = _core_utils_Math__WEBPACK_IMPORTED_MODULE_6__["max"](range.value, range.endValue);

          if (minValue < selectionMin) {
            selectionMin = minValue;
          }

          if (maxValue > selectionMax) {
            selectionMax = maxValue;
          }
        }
      });
    } // this is not good, as if date axis is initially zoomed, selection of y axis is reset to 0, 1 at the end of this method
    //$iter.each(this.series.iterator(), (series) => {
    //	if (!series.appeared) {
    //		allHidden = true;
    //	}
    //})


    if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](this._minDefined)) {
      if (this.strictMinMax) {
        selectionMin = this._minDefined;
      } else {
        selectionMin = this.min;
      }
    } else if (this.strictMinMax) {
      selectionMin = this._minReal;
    }

    if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](this._maxDefined)) {
      if (this.strictMinMax) {
        selectionMax = this._maxDefined;
      } else {
        selectionMax = this.max;
      }
    } else if (this.strictMinMax) {
      selectionMax = this._maxReal;
    }

    if (selectionMin == selectionMax) {
      selectionMin -= this._deltaMinMax;
      selectionMax += this._deltaMinMax;
      var minMaxStep2 = this.adjustMinMax(selectionMin, selectionMax, 0, this._gridCount, this.strictMinMax);
      selectionMin = minMaxStep2.min;
      selectionMax = minMaxStep2.max;
    }

    var dif = this.adjustDifference(selectionMin, selectionMax);
    var minMaxStep = this.adjustMinMax(selectionMin, selectionMax, dif, this._gridCount);
    selectionMin = minMaxStep.min;
    selectionMax = minMaxStep.max;
    selectionMin -= (selectionMax - selectionMin) * this.extraMin;
    selectionMax += (selectionMax - selectionMin) * this.extraMax;
    selectionMin = _core_utils_Math__WEBPACK_IMPORTED_MODULE_6__["fitToRange"](selectionMin, this.min, this.max);
    selectionMax = _core_utils_Math__WEBPACK_IMPORTED_MODULE_6__["fitToRange"](selectionMax, this.min, this.max); // do it for the second time !important

    dif = this.adjustDifference(selectionMin, selectionMax);
    minMaxStep = this.adjustMinMax(selectionMin, selectionMax, dif, this._gridCount, true);
    selectionMin = minMaxStep.min;
    selectionMax = minMaxStep.max;

    if (this.strictMinMax) {
      selectionMin = _core_utils_Math__WEBPACK_IMPORTED_MODULE_6__["max"](selectionMin, this._minDefined);
      selectionMax = _core_utils_Math__WEBPACK_IMPORTED_MODULE_6__["min"](selectionMax, this._maxDefined);
    }

    var step = minMaxStep.step;

    if (this.syncWithAxis) {
      minMaxStep = this.syncAxes(selectionMin, selectionMax, step);
      selectionMin = minMaxStep.min;
      selectionMax = minMaxStep.max;
      this.invalidate();
    }

    step = minMaxStep.step; // needed because of grouping

    this._difference = this.adjustDifference(this.min, this.max);
    var start = this.valueToPosition(selectionMin);
    var end = this.valueToPosition(selectionMax); // in case all series are hidden or hiding, full zoomout

    if (allHidden && !this.syncWithAxis) {
      start = 0;
      end = 1;
    }

    var declination = 0;

    if (this.syncWithAxis) {
      declination = 5;
      this.setCache(selectionMin + "-" + selectionMax, step);
    } else {
      if (this._step != step || this._minZoomed != selectionMin || this._maxZoomed != selectionMax) {
        this._dsc = true;
      }

      this._step = step;
      this._minZoomed = selectionMin;
      this._maxZoomed = selectionMax;
    }

    if (!this.keepSelection) {
      this.zoom({
        start: start,
        end: end
      }, false, false, declination);
    }
  };

  Object.defineProperty(ValueAxis.prototype, "strictMinMax", {
    /**
     * @return Use exact values?
     */
    get: function get() {
      return this.getPropertyValue("strictMinMax");
    },

    /**
     * Indicates whether to blindly use exact `min` and `max` values set by user
     * when generating Axis scale.
     *
     * If not set, the Axis might slightly adjust those values to accomodate a
     * better looking grid.
     *
     * NOTE: if `min` and `max` are not set, setting `strictMinMax` to `true`
     * will result in fixing the scale of the axis to actual lowest and highest
     * values in the series within currently selected scope.
     *
     * @default false
     * @param value Use exact values?
     */
    set: function set(value) {
      if (this.setPropertyValue("strictMinMax", value)) {
        this.invalidate();
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ValueAxis.prototype, "logarithmic", {
    /**
     * @return Logarithmic scale?
     */
    get: function get() {
      return this.getPropertyValue("logarithmic");
    },

    /**
     * Indicates if this axis should use a logarithmic scale.
     *
     * Please note that logarithmic axis can **only** accommodate values bigger
     * than zero.
     *
     * Having zero or negative values will result in error and failure of the
     * whole chart.
     *
     * @param value Logarithmic scale?
     */
    set: function set(value) {
      if (this.setPropertyValue("logarithmic", value)) {
        this.invalidate();
        this.series.each(function (series) {
          series.invalidateDataItems();
        });
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ValueAxis.prototype, "keepSelection", {
    /**
     * @return Preseve zoom after data update?
     */
    get: function get() {
      return this.getPropertyValue("keepSelection");
    },

    /**
     * Indicates if a current selection (zoom) should be kept across data updates.
     *
     * If your axis is zoomed while chart's data is updated, the axis will try
     * to retain the same start and end values.
     *
     * You can also use this to initially pre-zoom axis:
     *
     * ```TypeScript
     * axis.keepSelection = true;
     * axis.start = 0.5;
     * axis.end = 0.7;
     * ```
     * ```JavaScript
     * axis.keepSelection = true;
     * axis.start = 0.5;
     * axis.end = 0.7;
     * ```
     * ```JSON
     * {
     *   "xAxes": [{
     *     // ...
     *     "keepSelection": true,
     *     "start": 0.5,
     *     "end": 0.7
     *   }]
     * }
     * ```
     *
     * The above will start the chart zoomed from the middle of the actual scope
     * to 70%.
     *
     * @since 4.1.1
     * @default false
     * @param  value  Preseve zoom after data update?
     */
    set: function set(value) {
      this.setPropertyValue("keepSelection", value);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ValueAxis.prototype, "includeRangesInMinMax", {
    /**
     * @return Include ranges?
     */
    get: function get() {
      return this.getPropertyValue("includeRangesInMinMax");
    },

    /**
     * If set to `true`, values of axis ranges will be included when calculating
     * range of values / scale of the [[ValueAxis]].
     *
     * @default false
     * @since 4.4.9
     * @param  value  Include ranges?
     */
    set: function set(value) {
      this.setPropertyValue("includeRangesInMinMax", value);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ValueAxis.prototype, "maxPrecision", {
    /**
     * @return max precision
     */
    get: function get() {
      return this.getPropertyValue("maxPrecision");
    },

    /**
     * Maximum number of decimals to allow when placing grid lines and labels
     * on axis.
     *
     * Set it to `0` (zero) to force integer-only axis labels.
     *
     * @param {number}
     */
    set: function set(value) {
      if (this.setPropertyValue("maxPrecision", value)) {
        this.invalidate();
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ValueAxis.prototype, "extraTooltipPrecision", {
    /**
     * @return Extra decimals
     */
    get: function get() {
      return this.getPropertyValue("extraTooltipPrecision");
    },

    /**
     * This setting allows using bigger precision for numbers displayed in axis
     * tooltip.
     *
     * Please note that this setting indicates additional decimal places to
     * automatically-calculated axis number precision.
     *
     * So if your axis displays numbers like 0.1, 0.2, etc. (one decimal place),
     * and you set `extraTooltipPrecision = 1`, tooltips will display numbers
     * like 0.12, 0.25, etc. (two decimal places).
     *
     * @default 0
     * @since 4.8.3
     * @param  value  Extra decimals
     */
    set: function set(value) {
      if (this.setPropertyValue("extraTooltipPrecision", value)) {
        this.invalidate();
      }
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Invalidates axis data items when series extremes change
   */

  ValueAxis.prototype.handleExtremesChange = function () {
    var _this = this;

    this._extremesChanged = true;
    this.getMinMax();

    if (this.ghostLabel) {
      var mw_1 = 0;
      this.dataItems.each(function (dataItem) {
        if (dataItem.label && dataItem.label.pixelWidth > mw_1) {
          _this.ghostLabel.text = dataItem.label.currentText;
        }
      });
    }
  };
  /**
   * Returns relative position on axis for series' data item's value.
   *
   * @ignore Exclude from docs
   * @todo Description (review)
   * @param dataItem  Data item
   * @param key       Data field to get value from
   * @param location  Location (0-1)
   * @param stackKey  ?
   * @return X coordinate (px)
   */


  ValueAxis.prototype.getX = function (dataItem, key, location, stackKey, range) {
    return this.renderer.positionToPoint(this.getPositionX(dataItem, key, location, stackKey, range)).x;
  };
  /**
   * Returns the X coordinate for series' data item's value.
   *
   * @since 4.5.14
   * @param  dataItem  Data item
   * @param  key       Data field to get value from
   * @param  location  Location (0-1)
   * @param  stackKey  ?
   * @return           Relative position
   */


  ValueAxis.prototype.getPositionX = function (dataItem, key, location, stackKey, range) {
    var value = dataItem.getWorkingValue(key);

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["hasValue"](stackKey)) {
      stackKey = "valueX";
    }

    var stack = dataItem.getValue(stackKey, "stack");

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](value)) {
      value = this.baseValue;

      if (this.logarithmic) {
        if (stack > 0) {
          value = 0;
        }
      }
    }

    var position = this.valueToPosition(value + stack);

    if (range) {
      position = _core_utils_Math__WEBPACK_IMPORTED_MODULE_6__["fitToRange"](position, range.start, range.end);
    }

    return position;
  };
  /**
   * Returns the Y coordinate for series' data item's value.
   *
   * @ignore Exclude from docs
   * @todo Description (review)
   * @param dataItem  Data item
   * @param key       Data field to get value from
   * @param location  Location (0-1)
   * @param stackKey  Stack ID
   * @return Y coordinate (px)
   */


  ValueAxis.prototype.getY = function (dataItem, key, location, stackKey, range) {
    return this.renderer.positionToPoint(this.getPositionY(dataItem, key, location, stackKey, range)).y;
  };
  /**
   * Returns relative position on axis for series' data item's value.
   *
   * @since 4.5.14
   * @param  dataItem  Data item
   * @param  key       Data field to get value from
   * @param  location  Location (0-1)
   * @param  stackKey  Stack ID
   * @return           Relative position
   */


  ValueAxis.prototype.getPositionY = function (dataItem, key, location, stackKey, range) {
    var value = dataItem.getWorkingValue(key);

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["hasValue"](stackKey)) {
      stackKey = "valueY";
    }

    var stack = dataItem.getValue(stackKey, "stack");

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](value)) {
      value = this.baseValue;

      if (this.logarithmic) {
        if (stack > 0) {
          value = 0;
        }
      }
    }

    var position = this.valueToPosition(value + stack);

    if (range) {
      position = _core_utils_Math__WEBPACK_IMPORTED_MODULE_6__["fitToRange"](position, range.start, range.end);
    }

    return position;
  };
  /**
   * Returns an angle for series data item.
   *
   * @ignore Exclude from docs
   * @todo Description (review)
   * @param dataItem  Data item
   * @param key       Data field to get value from
   * @param location  Location (0-1)
   * @param stackKey  Stack ID
   * @param range Range to fit in
   * @return Angle
   */


  ValueAxis.prototype.getAngle = function (dataItem, key, location, stackKey, range) {
    var value = dataItem.getWorkingValue(key);
    var stack = dataItem.getValue(stackKey, "stack");

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](value)) {
      value = this.baseValue;
    }

    var position = this.valueToPosition(value + stack);

    if (range) {
      position = _core_utils_Math__WEBPACK_IMPORTED_MODULE_6__["fitToRange"](position, range.start, range.end);
    }

    return this.positionToAngle(position);
  };
  /**
   * [getAnyRangePath description]
   *
   * @ignore Exclude from docs
   * @todo Description
   * @param start     [description]
   * @param end       [description]
   * @param location  [description]
   * @return [description]
   */


  ValueAxis.prototype.getAnyRangePath = function (start, end, location) {
    var startPosition = this.valueToPosition(start);
    var endPosition = this.valueToPosition(end);
    return this.getPositionRangePath(startPosition, endPosition); // Base class (Axis) gets range shape from AxisRenderer
  };
  /**
   * Returns text to show in a axis tooltip, based on specific position within
   * axis.
   *
   * The label will be formatted as per [[NumberFormatter]] set for the whole
   * chart, or explicitly for this Axis.
   *
   * @ignore Exclude from docs
   * @param position  Position (px)
   * @return Label (numeric value)
   */


  ValueAxis.prototype.getTooltipText = function (position) {
    var value = _core_utils_Math__WEBPACK_IMPORTED_MODULE_6__["round"](this.positionToValue(position), this._stepDecimalPlaces + this.extraTooltipPrecision);
    var valueStr = this.tooltip.numberFormatter.format(value);

    if (!this._adapterO) {
      return valueStr;
    } else {
      return this._adapterO.apply("getTooltipText", valueStr);
    }
  };
  /**
   * Zooms axis to specific values.
   *
   * @param startValue      Start value
   * @param endValue        End value
   * @param skipRangeEvent  Do not invoke events
   * @param instantly       Do not play zoom animations
   */


  ValueAxis.prototype.zoomToValues = function (startValue, endValue, skipRangeEvent, instantly) {
    var start = (startValue - this.min) / (this.max - this.min);
    var end = (endValue - this.min) / (this.max - this.min);
    this.zoom({
      start: start,
      end: end
    }, skipRangeEvent, instantly);
  };

  Object.defineProperty(ValueAxis.prototype, "minZoomed", {
    /**
     * A smallest value in axis scale within current zoom.
     *
     * @return Min zoom value
     */
    get: function get() {
      if (!this.syncWithAxis) {
        return _core_utils_Math__WEBPACK_IMPORTED_MODULE_6__["max"](this.min, this._minZoomed);
      } else {
        return this._minZoomed;
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ValueAxis.prototype, "maxZoomed", {
    /**
     * A biggest value in axis scale within current zoom.
     * @return [description]
     */
    get: function get() {
      if (!this.syncWithAxis) {
        return _core_utils_Math__WEBPACK_IMPORTED_MODULE_6__["min"](this.max, this._maxZoomed);
      } else {
        return this._maxZoomed;
      }
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Updates positioning of Axis breaks after something changes.
   *
   * @ignore Exclude from docs
   */

  ValueAxis.prototype.fixAxisBreaks = function () {
    var _this = this;

    _super.prototype.fixAxisBreaks.call(this);

    var axisBreaks = this._axisBreaks;

    if (axisBreaks && axisBreaks.length > 0) {
      // process breaks
      axisBreaks.each(function (axisBreak) {
        var startValue = axisBreak.adjustedStartValue;
        var endValue = axisBreak.adjustedEndValue; // break difference

        var axisBreakDif = endValue - startValue;

        var axisBreakGridCount = Math.ceil(axisBreakDif * axisBreak.breakSize) * _this._gridCount / (_this.max - _this.min); // calculate min, max and step for axis break


        var breakMinMaxStep = _this.adjustMinMax(startValue, endValue, axisBreakDif, axisBreakGridCount, true);

        axisBreak.adjustedStep = breakMinMaxStep.step;
        axisBreak.adjustedMin = breakMinMaxStep.min;
        axisBreak.adjustedMax = breakMinMaxStep.max;
      });
    }

    this._difference = this.adjustDifference(this.min, this.max);
  };
  /**
   * Returns value based on position.
   *
   * Please note that `position` represents position within axis which may be
   * zoomed and not correspond to Cursor's `position`.
   *
   * To convert Cursor's `position` to Axis' `position` use `toAxisPosition()` method.
   *
   * @see {@link https://www.amcharts.com/docs/v4/tutorials/tracking-cursors-position-via-api/#Tracking_Cursor_s_position} For more information about cursor tracking.
   * @param position  Relative position on axis (0-1)
   * @return Position label
   */


  ValueAxis.prototype.getPositionLabel = function (position) {
    var value = this.positionToValue(position);
    return this.numberFormatter.format(value);
  };
  /**
   * Shows Axis tooltip at specific value
   *
   * @param value Value
   */


  ValueAxis.prototype.showTooltipAt = function (value) {
    this.showTooltipAtPosition(this.valueToPosition(value));
  };
  /**
   * Copies all properties and related data from a different instance of Axis.
   *
   * @param source Source Axis
   */


  ValueAxis.prototype.copyFrom = function (source) {
    _super.prototype.copyFrom.call(this, source);

    this.min = source.min;
    this.max = source.max;
    this.calculateTotals = source.calculateTotals;
    this._baseValue = source.baseValue;
  };

  Object.defineProperty(ValueAxis.prototype, "syncWithAxis", {
    /**
     * @return Target axis
     */
    get: function get() {
      return this.getPropertyValue("syncWithAxis");
    },

    /**
     * Enables syncing of grid with another axis.
     *
     * To enable, set to a reference of the other `ValueAxis`. This axis will try
     * to maintain its scale in such way that its grid matches target axis grid.
     *
     * IMPORTANT #1: At this stage it's an experimental feature. Use it at your
     * own risk, as it may not work in 100% of the scenarios.
     *
     * IMPORTANT #2: `syncWithAxis` is not compatible with `strictMinMax` and
     * `sequencedInterpolation` settings.
     *
     * IMPORTANT #3: `syncWithAxis` is not compatible with scrollbars. Make sure
     * you do not add a scrollbar in the same direction as synced axes. For
     * example, if you have vertical synced axes, do not add `scrollbarY` on
     * your chart. It will create anomalies when used.
     *
     * IMPORTANT #4: `syncWithAxis` is not compatible with `XYCursor` if it has
     * its `behavior` set to either `zoomY` or `zoomXY`.
     *
     * @since 4.8.1
     * @param  axis  Target axis
     */
    set: function set(axis) {
      var _this = this;

      if (this.setPropertyValue("syncWithAxis", axis, true)) {
        if (axis) {
          this._disposers.push(axis.events.on("extremeschanged", this.handleSelectionExtremesChange, this, false));

          this._disposers.push(axis.events.on("selectionextremeschanged", this.handleSelectionExtremesChange, this, false));

          this._disposers.push(axis.events.on("startendchanged", this.handleSelectionExtremesChange, this, false));

          this.events.on("shown", this.handleSelectionExtremesChange, this, false);
          this.events.on("maxsizechanged", function () {
            _this.clearCache();

            _this._disposers.push(_core_Registry__WEBPACK_IMPORTED_MODULE_4__["registry"].events.once("exitframe", function () {
              _this.handleSelectionExtremesChange();
            }));
          }, this, false);
        }
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ValueAxis.prototype, "treatZeroAs", {
    /**
     * @return Zero replacement value
     */
    get: function get() {
      return this.getPropertyValue("treatZeroAs");
    },

    /**
     * If set, zero values will be treated as this value.
     *
     * It is useful if you need to use data with zero-values on a logarithmic
     * axis scale.
     *
     * @since 4.9.34
     * @param  value  Zero replacement value
     */
    set: function set(value) {
      this.setPropertyValue("treatZeroAs", value, true);
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Syncs with a target axis.
   *
   * @param  min  Min
   * @param  max  Max
   * @param  step Step
   */

  ValueAxis.prototype.syncAxes = function (min, max, step) {
    var axis = this.syncWithAxis;

    if (axis) {
      if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](min)) {
        min = this.min;
      }

      if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](max)) {
        max = this.max;
      }

      if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](step)) {
        step = this._step;
      }

      var count = Math.round((axis.maxZoomed - axis.minZoomed) / axis.step);
      var currentCount = Math.round((max - min) / step);

      if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](count) && _core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](currentCount)) {
        var synced = false;
        var c = 0;
        var diff = (max - min) * 0.01;
        var omin = min;
        var omax = max;
        var ostep = step;

        while (synced != true) {
          synced = this.checkSync(omin, omax, ostep, count);
          c++;

          if (c > 1000) {
            synced = true;
          }

          if (!synced) {
            //omin = min - diff * c;
            if (c / 3 == Math.round(c / 3)) {
              omin = min - diff * c;

              if (min >= 0 && omin < 0) {
                omin = 0;
              }
            } else {
              omax = max + diff * c;

              if (omax <= 0 && omax > 0) {
                omax = 0;
              }
            }

            var minMaxStep = this.adjustMinMax(omin, omax, omax - omin, this._gridCount, true);
            omin = minMaxStep.min;
            omax = minMaxStep.max;
            ostep = minMaxStep.step;
          } else {
            min = omin;
            max = omax;
            step = ostep;
          }
        }
      }
    }

    return {
      min: min,
      max: max,
      step: step
    };
  };
  /**
   * Returns `true` if axis needs to be resunced with some other axis.
   */


  ValueAxis.prototype.checkSync = function (min, max, step, count) {
    var currentCount = (max - min) / step;

    for (var i = 1; i < count; i++) {
      if (_core_utils_Math__WEBPACK_IMPORTED_MODULE_6__["round"](currentCount / i, 1) == count || currentCount * i == count) {
        return true;
      }
    }

    return false;
  };
  /**
   * Processes JSON-based config before it is applied to the object.
   *
   * @ignore Exclude from docs
   * @param config  Config
   */


  ValueAxis.prototype.processConfig = function (config) {
    if (config) {
      // Set up axes
      if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["hasValue"](config.syncWithAxis) && _core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isString"](config.syncWithAxis)) {
        if (this.map.hasKey(config.syncWithAxis)) {
          config.syncWithAxis = this.map.getKey(config.syncWithAxis);
        } else {
          this.processingErrors.push("[ValueAxis] No axis with id \"" + config.syncWithAxis + "\" found for `syncWithAxis`");
          delete config.xAxis;
        }
      }
    }

    _super.prototype.processConfig.call(this, config);
  };

  return ValueAxis;
}(_Axis__WEBPACK_IMPORTED_MODULE_1__["Axis"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_4__["registry"].registeredClasses["ValueAxis"] = ValueAxis;
_core_Registry__WEBPACK_IMPORTED_MODULE_4__["registry"].registeredClasses["ValueAxisDataItem"] = ValueAxisDataItem;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/ValueAxisBreak.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/axes/ValueAxisBreak.js ***!
  \**********************************************************************************/
/*! exports provided: ValueAxisBreak */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ValueAxisBreak", function() { return ValueAxisBreak; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _AxisBreak__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AxisBreak */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisBreak.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/**
 * A module which defines functionality related to Value Axis Break.
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */



/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Base class to define "breaks" on value axis.
 *
 * A "break" can be used to "cut out" specific ranges of the axis scale, e.g.
 * when comparing columns with relatively similar values, it would make sense
 * to cut out their mid section, so that their tip differences are more
 * prominent.
 *
 * @see {@link IValueAxisBreakEvents} for a list of available events
 * @see {@link IValueAxisBreakAdapters} for a list of available Adapters
 * @important
 */

var ValueAxisBreak =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(ValueAxisBreak, _super);
  /**
   * Constructor
   */


  function ValueAxisBreak() {
    var _this = _super.call(this) || this;

    _this.className = "ValueAxisBreak";

    _this.applyTheme();

    return _this;
  }

  Object.defineProperty(ValueAxisBreak.prototype, "startPosition", {
    /**
     * Pixel position of the break's start.
     *
     * @return Position (px)
     * @readonly
     */
    get: function get() {
      if (this.axis) {
        return this.axis.valueToPosition(this.adjustedStartValue);
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ValueAxisBreak.prototype, "endPosition", {
    /**
     * Pixel position of the break's end.
     *
     * @return Position (px)
     * @readonly
     */
    get: function get() {
      if (this.axis) {
        return this.axis.valueToPosition(this.adjustedEndValue);
      }
    },
    enumerable: true,
    configurable: true
  });
  return ValueAxisBreak;
}(_AxisBreak__WEBPACK_IMPORTED_MODULE_1__["AxisBreak"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_2__["registry"].registeredClasses["ValueAxisBreak"] = ValueAxisBreak;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/cursors/Cursor.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/cursors/Cursor.js ***!
  \*****************************************************************************/
/*! exports provided: Cursor */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Cursor", function() { return Cursor; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _core_Container__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core/Container */ "./node_modules/@amcharts/amcharts4/.internal/core/Container.js");
/* harmony import */ var _core_interaction_Interaction__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/interaction/Interaction */ "./node_modules/@amcharts/amcharts4/.internal/core/interaction/Interaction.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_utils_Percent__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/utils/Percent */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Percent.js");
/* harmony import */ var _core_interaction_Mouse__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core/interaction/Mouse */ "./node_modules/@amcharts/amcharts4/.internal/core/interaction/Mouse.js");
/* harmony import */ var _core_utils_Math__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core/utils/Math */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Math.js");
/* harmony import */ var _core_utils_Utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../core/utils/Utils */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Utils.js");
/* harmony import */ var _core_utils_Type__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../core/utils/Type */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Type.js");
/* harmony import */ var _core_utils_DOM__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../core/utils/DOM */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/DOM.js");
/* harmony import */ var _core_System__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../core/System */ "./node_modules/@amcharts/amcharts4/.internal/core/System.js");
/**
 * Cursor module
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */











/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Main Cursor class with common cursor functionality.
 *
 * Chart-specific cursors must extend this class.
 *
 * @see {@link ICursorEvents} for a list of available events
 * @see {@link ICursorAdapters} for a list of available Adapters
 * @todo Add description, examples
 * @todo Should we allow changing `_generalBehavior`?
 */

var Cursor =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(Cursor, _super);
  /**
   * Constructor
   */


  function Cursor() {
    var _this = // Init
    _super.call(this) || this;
    /**
     * Current cursor position during selection.
     *
     * @todo Better description
     */


    _this.point = {
      x: 0,
      y: 0
    };
    /**
     * Specifies the rules when cursor needs to be moved or hidden.
     */

    _this._stick = "none";
    _this.className = "Cursor"; // Set defaults

    _this.width = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_4__["percent"])(100);
    _this.height = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_4__["percent"])(100);
    _this.shouldClone = false;

    _this.hide(0);

    _this.trackable = true;
    _this.clickable = true;
    _this.isMeasured = false; // Add events on body to trigger down and up events (to start zooming or
    // selection)

    var interaction = Object(_core_interaction_Interaction__WEBPACK_IMPORTED_MODULE_2__["getInteraction"])();

    _this._disposers.push(interaction.body.events.on("down", _this.handleCursorDown, _this));

    _this._disposers.push(interaction.body.events.on("up", _this.handleCursorUp, _this));

    _this._disposers.push(interaction.body.events.on("track", _this.handleCursorMove, _this)); // Apply theme


    _this.applyTheme();

    return _this;
  }
  /**
   * Handle pointer movement in document and update cursor position as needed.
   *
   * @ignore Exclude from docs
   * @param event Event
   */


  Cursor.prototype.handleCursorMove = function (event) {
    if (!this.interactionsEnabled || this.interactions.isTouchProtected && event.touch) {
      return;
    }

    if ((this._generalBehavior != "zoom" && this._generalBehavior != "pan" || !this.downPoint) && !Object(_core_interaction_Interaction__WEBPACK_IMPORTED_MODULE_2__["getInteraction"])().isLocalElement(event.pointer, this.paper.svg, this.uid)) {
      // We want to let zoom/pan continue even if cursor is outside chart area
      if (!this.isHidden || !this.isHiding) {
        this.hide();
      }

      return;
    }

    var local = _core_utils_Utils__WEBPACK_IMPORTED_MODULE_7__["documentPointToSprite"](event.pointer.point, this);

    if (this._stick == "hard" && this._stickPoint) {
      local = this._stickPoint;
    }

    if (this._stick == "soft" && this._stickPoint) {
      if (!this.fitsToBounds(local)) {
        local = this._stickPoint;
      }
    }

    if (this._adapterO) {
      this._adapterO.apply("cursorPoint", local);
    }

    this.triggerMove(local);
    return local;
  };
  /**
   * Hides actual SVG elements and handles hiding animations.
   *
   * @param duration  Fade out duration (ms)
   * @return Fade out duration (ms)
   * @ignore
   */


  Cursor.prototype.hideReal = function (duration) {
    if ((this._stick == "hard" || this._stick == "soft") && this._stickPoint) {
      return;
    }

    return _super.prototype.hideReal.call(this, duration);
  };
  /**
   * Places the cursor at specific point.
   *
   * The second parameter has following options:
   *
   * `"none"` - placed cursor will only be there until mouse/touch moves, then
   * it either moves to a new place (if pointer over plot area) or is hidden.
   *
   * `"soft"` - cursor will stay in the place if mouse/touch is happening
   * outside chart, but will move to a new place whe plot area is hovered or
   * touched.
   *
   * `"hard"` - cursor will stay in place no matter what, until it is moved by
   * another `triggerMove()` call.
   *
   * The third parameter - `force` (since `4.9.5`) - if set to `true` will
   * make cursor execute all of the actions associated with cursor move,
   * including line redraws, tooltip updates, etc. Useful when underlying
   * chart data is dynamically being updated.
   *
   * @param point  Point to place cursor at
   * @param stick  Level of cursor stickiness to the place
   * @param force  Force cursor move
   */


  Cursor.prototype.triggerMove = function (point, stick, force) {
    point.x = _core_utils_Math__WEBPACK_IMPORTED_MODULE_6__["round"](point.x, 1);
    point.y = _core_utils_Math__WEBPACK_IMPORTED_MODULE_6__["round"](point.y, 1);

    if (stick) {
      this._stick = stick;
    }

    if (stick == "hard" || stick == "soft") {
      this._stickPoint = point;
    }

    this.triggerMoveReal(point, force);
  };
  /**
   * Places the cursor at specific point.
   *
   * @param point Point to place cursor at
   */


  Cursor.prototype.triggerMoveReal = function (point, force) {
    if (this.point.x != point.x || this.point.y != point.y || force) {
      this.point = point;
      this.invalidatePosition(); // hide cursor if it's out of bounds

      if (this.fitsToBounds(point)) {
        this.show(0);
      } else {
        // unless we are selecting (mouse is down)
        if (!this.downPoint) {
          this.hide(0);
        }
      }

      if (this.visible) {
        this.getPositions();
        this.dispatch("cursorpositionchanged"); // not good to dispatch later (check step count example)
      }
    }
  };
  /**
   * Simulates pressing down (click/touch) action by a cursor.
   *
   * @param point               Point of action
   */


  Cursor.prototype.triggerDown = function (point) {
    this.triggerDownReal(point);
  };
  /**
   * Simulates pressing down (click/touch) action by a cursor.
   *
   * @param point               Point of action
   */


  Cursor.prototype.triggerDownReal = function (point) {
    switch (this._generalBehavior) {
      case "zoom":
        this.dispatchImmediately("zoomstarted");
        break;

      case "select":
        this.dispatchImmediately("selectstarted");
        break;

      case "pan":
        this.dispatchImmediately("panstarted");
        Object(_core_interaction_Interaction__WEBPACK_IMPORTED_MODULE_2__["getInteraction"])().setGlobalStyle(_core_interaction_Mouse__WEBPACK_IMPORTED_MODULE_5__["MouseCursorStyle"].grabbing);
        break;
    }
  };
  /**
   * Simulates the action of release of the mouse down / touch.
   *
   * @param point               Point of action
   */


  Cursor.prototype.triggerUp = function (point) {
    this.triggerUpReal(point);
  };
  /**
   * Simulates the action of release of the mouse down / touch.
   *
   * @param point               Point of action
   */


  Cursor.prototype.triggerUpReal = function (point) {
    _core_System__WEBPACK_IMPORTED_MODULE_10__["system"].requestFrame();
    this.updatePoint(this.upPoint);
    var interaction = Object(_core_interaction_Interaction__WEBPACK_IMPORTED_MODULE_2__["getInteraction"])();

    if (_core_utils_Math__WEBPACK_IMPORTED_MODULE_6__["getDistance"](this._upPointOrig, this._downPointOrig) > interaction.getHitOption(this.interactions, "hitTolerance")) {
      switch (this._generalBehavior) {
        case "zoom":
          this.dispatch("zoomended");
          break;

        case "select":
          this.dispatch("selectended");
          break;

        case "pan":
          this.dispatch("panended");
          interaction.setGlobalStyle(_core_interaction_Mouse__WEBPACK_IMPORTED_MODULE_5__["MouseCursorStyle"].default);
          break;
      }

      this.downPoint = undefined;
      this.updateSelection();
    }
    /*
    else {
        
        if(this._generalBehavior == "select"){
            this.dispatchImmediately("selectended");
        }
        this.dispatchImmediately("behaviorcanceled");
        interaction.setGlobalStyle(MouseCursorStyle.default);
        this.downPoint = undefined;
    }*/

  };
  /**
   * Updates selection dimensions on size change.
   *
   * @ignore Exclude from docs
   */


  Cursor.prototype.updateSelection = function () {};
  /**
   * Updates cursors current positions.
   */


  Cursor.prototype.getPositions = function () {
    // positions are used by axes or series
    this.xPosition = this.point.x / this.innerWidth;
    this.yPosition = 1 - this.point.y / this.innerHeight;
  };
  /**
   * Handles pointer down event so we can start zoom or selection.
   *
   * @ignore Exclude from docs
   * @param event Original event
   */


  Cursor.prototype.handleCursorDown = function (event) {
    if (!this.interactionsEnabled || this.interactions.isTouchProtected && event.touch || !Object(_core_interaction_Interaction__WEBPACK_IMPORTED_MODULE_2__["getInteraction"])().isLocalElement(event.pointer, this.paper.svg, this.uid)) {
      return;
    } // Initiate blur so that whatever focused element on the page is unselected


    _core_utils_DOM__WEBPACK_IMPORTED_MODULE_9__["blur"](); // Get local point

    var local = _core_utils_Utils__WEBPACK_IMPORTED_MODULE_7__["documentPointToSprite"](event.pointer.point, this);

    if (this._stick == "hard" && this._stickPoint) {
      local = this._stickPoint;
    }

    if (this._adapterO) {
      this._adapterO.apply("cursorPoint", local);
    }

    if (!this.fitsToBounds(local)) {
      return;
    }

    this._downPointOrig = {
      x: local.x,
      y: local.y
    }; // We need to cancel the event to prevent gestures on touch devices

    if (event.event.cancelable && this.shouldPreventGestures(event.touch) && this.fitsToBounds(local)) {
      event.event.preventDefault();
    } // Make this happen


    this.triggerMove(local);
    this.triggerDown(local);
  };
  /**
   * Determines whether Cursor should prevent default action on move.
   *
   * Child classes should override this as necessary.
   *
   * @return Prevent default?
   */


  Cursor.prototype.shouldPreventGestures = function (touch) {
    return true;
  };
  /**
   * Updates the coordinates of where pointer down event occurred
   * (was pressed).
   */


  Cursor.prototype.updatePoint = function (point) {};
  /**
   * Handles pointer up event - finishes zoom or selection action.
   *
   * @ignore Exclude from docs
   * @param event Original event
   */


  Cursor.prototype.handleCursorUp = function (event) {
    if (!this.interactionsEnabled) {
      return;
    }

    if (!this.downPoint && !Object(_core_interaction_Interaction__WEBPACK_IMPORTED_MODULE_2__["getInteraction"])().isLocalElement(event.pointer, this.paper.svg, this.uid)) {
      return;
    }

    var local = _core_utils_Utils__WEBPACK_IMPORTED_MODULE_7__["documentPointToSprite"](event.pointer.point, this);

    if (this._adapterO) {
      this._adapterO.apply("cursorPoint", local);
    }

    if (!this.downPoint || !this.fitsToBounds(this.downPoint)) {
      return;
    }

    if (this._stick == "hard" && this._stickPoint) {
      local = this._stickPoint;
    }

    this._upPointOrig = {
      x: local.x,
      y: local.y
    };
    this.triggerMove(local);
    this.triggerUp(local);
  };

  Object.defineProperty(Cursor.prototype, "chart", {
    /**
     * @return Chart
     */
    get: function get() {
      return this._chart;
    },

    /**
     * A reference to a [[Chart]] the cursor belongs to.
     *
     * @param value  Chart
     */
    set: function set(value) {
      this._chart = value;

      if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_8__["hasValue"](this._chart.plotContainer)) {
        Object(_core_interaction_Interaction__WEBPACK_IMPORTED_MODULE_2__["getInteraction"])().lockElement(this._chart.plotContainer.interactions);
      }
    },
    enumerable: true,
    configurable: true
  });
  return Cursor;
}(_core_Container__WEBPACK_IMPORTED_MODULE_1__["Container"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_3__["registry"].registeredClasses["Cursor"] = Cursor;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/cursors/RadarCursor.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/cursors/RadarCursor.js ***!
  \**********************************************************************************/
/*! exports provided: RadarCursor */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "RadarCursor", function() { return RadarCursor; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _XYCursor__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./XYCursor */ "./node_modules/@amcharts/amcharts4/.internal/charts/cursors/XYCursor.js");
/* harmony import */ var _core_utils_Percent__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/utils/Percent */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Percent.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/rendering/Path */ "./node_modules/@amcharts/amcharts4/.internal/core/rendering/Path.js");
/* harmony import */ var _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core/utils/Math */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Math.js");
/* harmony import */ var _core_utils_Utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core/utils/Utils */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Utils.js");
/* harmony import */ var _core_utils_Type__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../core/utils/Type */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Type.js");








/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Cursor for [[RadarChart]].
 *
 * @see {@link IRadarCursorEvents} for a list of available events
 * @see {@link IRadarCursorAdapters} for a list of available Adapters
 */

var RadarCursor =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(RadarCursor, _super);
  /**
   * Constructor
   */


  function RadarCursor() {
    var _this = // Init
    _super.call(this) || this;

    _this.className = "RadarCursor";
    _this.radius = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_2__["percent"])(100);
    _this.innerRadius = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_2__["percent"])(0); // Apply theme

    _this.applyTheme();

    _this.mask = undefined;
    return _this;
  }
  /**
   * Checks if point is within bounds of a container.
   *
   * @ignore Exclude from docs
   * @param point  Point to check
   * @return Fits within container?
   */


  RadarCursor.prototype.fitsToBounds = function (point) {
    var radius = _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["getDistance"](point); //if(!$math.isAngleInRange(angle, this.startAngle, this.endAngle)){
    //return false;
    //}

    if (radius < this.truePixelRadius + 1 && radius > this.pixelInnerRadius - 1) {
      // ok to add/remove some
      return true;
    }

    return false;
  };

  Object.defineProperty(RadarCursor.prototype, "startAngle", {
    /**
     * @return Start angle
     */
    get: function get() {
      return this.getPropertyValue("startAngle");
    },

    /**
     * Starting angle of the cursor's radial line.
     *
     * @param value Start angle
     */
    set: function set(value) {
      this.setPropertyValue("startAngle", value, true);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(RadarCursor.prototype, "endAngle", {
    /**
     * @return End angle
     */
    get: function get() {
      return this.getPropertyValue("endAngle");
    },

    /**
     * End angle of the cursor's radial line.
     *
     * @param value End angle
     */
    set: function set(value) {
      this.setPropertyValue("endAngle", value, true);
    },
    enumerable: true,
    configurable: true
  });

  RadarCursor.prototype.triggerMoveReal = function (point, force) {
    if (!this.xAxis || this.xAxis && (!this.xAxis.cursorTooltipEnabled || this.xAxis.tooltip.disabled)) {
      this.updateLineX(this.point);
    }

    if (!this.yAxis || this.yAxis && (!this.yAxis.cursorTooltipEnabled || this.yAxis.tooltip.disabled)) {
      this.updateLineY(this.point);
    }

    this.updateSelection();

    _super.prototype.triggerMoveReal.call(this, point, force);
  };
  /**
   * (Re)draws the horizontal (circular) cursor's line.
   *
   * @param point New target point
   */


  RadarCursor.prototype.updateLineX = function (point) {
    var radius = this.pixelRadius;
    var startAngle = this.startAngle;
    var endAngle = this.endAngle;
    var innerRadius = this.pixelInnerRadius;

    if (radius > 0 && _core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["isNumber"](startAngle) && _core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["isNumber"](endAngle) && _core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["isNumber"](innerRadius)) {
      var angle = _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["fitAngleToRange"](_core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["getAngle"](point), startAngle, endAngle);
      var path = void 0;

      if (this.lineX && this.lineX.visible) {
        this.lineX.moveTo({
          x: 0,
          y: 0
        }); // fill

        if (this.xAxis && this.fullWidthLineX) {
          var startPoint = this.xAxis.currentItemStartPoint;
          var endPoint = this.xAxis.currentItemEndPoint;

          if (startPoint && endPoint) {
            var fillStartAngle = _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["fitAngleToRange"](_core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["getAngle"](startPoint), startAngle, endAngle);
            var fillEndAngle = _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["fitAngleToRange"](_core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["getAngle"](endPoint), startAngle, endAngle);
            var arc = fillEndAngle - fillStartAngle; // clockwise
            // this is needed, normalizeAngle doesn't solve it

            if (startAngle < endAngle) {
              if (arc < 0) {
                arc += 360;
              }
            } // ccw
            else {
                if (arc > 0) {
                  arc -= 360;
                }
              }

            angle -= arc / 2;
            path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["moveTo"]({
              x: innerRadius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["cos"](angle),
              y: innerRadius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["sin"](angle)
            }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["lineTo"]({
              x: radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["cos"](angle),
              y: radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["sin"](angle)
            }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["arcTo"](angle, arc, radius) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["lineTo"]({
              x: innerRadius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["cos"](angle + arc),
              y: innerRadius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["sin"](angle + arc)
            }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["arcTo"](angle + arc, -arc, innerRadius);
          }
        } // line


        if (!path) {
          path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["moveTo"]({
            x: innerRadius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["cos"](angle),
            y: innerRadius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["sin"](angle)
          }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["lineTo"]({
            x: radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["cos"](angle),
            y: radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["sin"](angle)
          });
        }

        this.lineX.path = path;
      }
    }
  };
  /**
   * (Re)draws the vertical (radial) cursor's line.
   *
   * @param point New target point
   */


  RadarCursor.prototype.updateLineY = function (point) {
    if (this.lineY && this.lineY.visible) {
      var startAngle = this.startAngle;
      var endAngle = this.endAngle;
      var truePixelRadius = this.truePixelRadius;
      var radius = _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["fitToRange"](_core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["getDistance"](point), 0, this.truePixelRadius);

      if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["isNumber"](radius) && _core_utils_Type__WEBPACK_IMPORTED_MODULE_7__["isNumber"](startAngle)) {
        this.lineY.moveTo({
          x: 0,
          y: 0
        });
        var path = void 0;
        var arc = endAngle - startAngle;

        if (this.yAxis && this.fullWidthLineY) {
          // fill
          var startPoint = this.yAxis.currentItemStartPoint;
          var endPoint = this.yAxis.currentItemEndPoint;

          if (startPoint && endPoint) {
            var innerRadius = _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["fitToRange"](_core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["getDistance"](startPoint), 0, truePixelRadius);
            radius = _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["fitToRange"](_core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["getDistance"](endPoint), 0, truePixelRadius);
            path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["moveTo"]({
              x: radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["cos"](startAngle),
              y: radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["sin"](startAngle)
            }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["arcTo"](startAngle, arc, radius);
            path += _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["moveTo"]({
              x: innerRadius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["cos"](endAngle),
              y: innerRadius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["sin"](endAngle)
            }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["arcTo"](endAngle, -arc, innerRadius);
          }
        }

        if (!path) {
          path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["moveTo"]({
            x: radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["cos"](startAngle),
            y: radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["sin"](startAngle)
          }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["arcTo"](startAngle, endAngle - startAngle, radius);
        }

        this.lineY.path = path;
      }
    }
  };
  /**
   * Updates selection dimensions on size change.
   *
   * @ignore Exclude from docs
   */


  RadarCursor.prototype.updateSelection = function () {
    if (this._usesSelection) {
      var downPoint = this.downPoint;

      if (downPoint) {
        var point = this.point;
        var radius = this.pixelRadius;
        var truePixelRadius = this.truePixelRadius;
        var innerRadius = this.pixelInnerRadius;
        var startAngle = Math.min(this.startAngle, this.endAngle);
        var endAngle = Math.max(this.startAngle, this.endAngle);
        var downAngle = _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["fitAngleToRange"](_core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["getAngle"](downPoint), startAngle, endAngle);
        var angle = _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["fitAngleToRange"](_core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["getAngle"](point), startAngle, endAngle);
        var downRadius = _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["getDistance"](downPoint);

        if (downRadius < truePixelRadius) {
          var currentRadius = _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["fitToRange"](_core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["getDistance"](point), 0, truePixelRadius);
          this._prevAngle = angle;
          var path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["moveTo"]({
            x: 0,
            y: 0
          });
          var downSin = _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["sin"](downAngle);
          var downCos = _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["cos"](downAngle);
          var sin = _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["sin"](angle);
          var cos = _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["cos"](angle);
          var behavior = this.behavior;

          if (behavior == "zoomX" || behavior == "selectX") {
            path += _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["lineTo"]({
              x: radius * downCos,
              y: radius * downSin
            }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["arcTo"](downAngle, angle - downAngle, radius) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["lineTo"]({
              x: innerRadius * cos,
              y: innerRadius * sin
            }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["arcTo"](angle, downAngle - angle, innerRadius);
          } else if (behavior == "zoomY" || behavior == "selectY") {
            path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["moveTo"]({
              x: currentRadius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["cos"](startAngle),
              y: currentRadius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["sin"](startAngle)
            }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["arcTo"](startAngle, endAngle - startAngle, currentRadius) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["lineTo"]({
              x: downRadius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["cos"](endAngle),
              y: downRadius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["sin"](endAngle)
            }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["arcTo"](endAngle, startAngle - endAngle, downRadius) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["closePath"]();
          } else if (behavior == "zoomXY") {
            path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["moveTo"]({
              x: currentRadius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["cos"](downAngle),
              y: currentRadius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["sin"](downAngle)
            }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["arcTo"](downAngle, angle - downAngle, currentRadius) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["lineTo"]({
              x: downRadius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["cos"](angle),
              y: downRadius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["sin"](angle)
            }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["arcTo"](angle, downAngle - angle, downRadius) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["closePath"]();
          }

          this.selection.path = path;
        }

        this.selection.moveTo({
          x: 0,
          y: 0
        });
      }
    }
  };
  /**
   * Updates cursors current positions.
   */


  RadarCursor.prototype.getPositions = function () {
    // positions are used by axes or series
    var chart = this.chart;

    if (chart) {
      var innerRadius = this.pixelInnerRadius;
      var radius = this.truePixelRadius - innerRadius;
      var startAngle = this.startAngle;
      var endAngle = this.endAngle;
      var angle = _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["fitAngleToRange"](_core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["getAngle"](this.point), startAngle, endAngle);
      var xPosition = (angle - startAngle) / (endAngle - startAngle);
      this.xPosition = xPosition;
      this.yPosition = _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["fitToRange"]((_core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["getDistance"](this.point) - innerRadius) / radius, 0, 1);
    }
  };
  /**
   * Overriding inherited method, so that nothing happens when it's triggered.
   *
   * @ignore Exclude from docs
   */


  RadarCursor.prototype.updatePoint = function (point) {};
  /**
   * Updates Cursor's position when axis tooltip changes horizontal position.
   *
   * @param event Axis event
   */


  RadarCursor.prototype.handleXTooltipPosition = function (event) {
    if (this.xAxis.cursorTooltipEnabled) {
      var tooltip = this.xAxis.tooltip;
      this.updateLineX(_core_utils_Utils__WEBPACK_IMPORTED_MODULE_6__["svgPointToSprite"]({
        x: tooltip.pixelX,
        y: tooltip.pixelY
      }, this));
    }
  };
  /**
   * Updates Cursor's position when axis tooltip changes vertical position.
   *
   * @todo Description
   * @param event Axis event
   */


  RadarCursor.prototype.handleYTooltipPosition = function (event) {
    if (this.yAxis.cursorTooltipEnabled) {
      var tooltip = this.yAxis.tooltip;
      this.updateLineY(_core_utils_Utils__WEBPACK_IMPORTED_MODULE_6__["svgPointToSprite"]({
        x: tooltip.pixelX,
        y: tooltip.pixelY
      }, this));
    }
  };
  /**
   * needs to be overriden
   * @ignore
   */


  RadarCursor.prototype.updateLinePositions = function (point) {};
  /**
   * [getRanges description]
   *
   * @todo Description
   */


  RadarCursor.prototype.getRanges = function () {
    var downPoint = this.downPoint;

    if (downPoint) {
      var upPoint = this.upPoint;
      var chart = this.chart;

      if (chart) {
        var radius = this.pixelRadius;
        var startAngle = this.startAngle;
        var endAngle = this.endAngle;
        var downAngle = _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["fitAngleToRange"](_core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["getAngle"](downPoint), this.startAngle, this.endAngle);
        var upAngle = _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["fitAngleToRange"](_core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["getAngle"](upPoint), this.startAngle, this.endAngle);
        var downRadius = _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["fitToRange"](_core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["getDistance"](downPoint), 0, radius);
        var upRadius = _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["fitToRange"](_core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["getDistance"](upPoint), 0, radius);
        var startX = 0;
        var endX = 1;
        var startY = 0;
        var endY = 1;
        var behavior = this.behavior;

        if (behavior == "zoomX" || behavior == "selectX" || behavior == "zoomXY" || behavior == "selectXY") {
          var arc = endAngle - startAngle;
          startX = _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["round"]((downAngle - startAngle) / arc, 5);
          endX = _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["round"]((upAngle - startAngle) / arc, 5);
        }

        if (behavior == "zoomY" || behavior == "selectY" || behavior == "zoomXY" || behavior == "selectXY") {
          startY = _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["round"](downRadius / radius, 5);
          endY = _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["round"](upRadius / radius, 5);
        }

        this.xRange = {
          start: Math.min(startX, endX),
          end: Math.max(startX, endX)
        };
        this.yRange = {
          start: Math.min(startY, endY),
          end: Math.max(startY, endY)
        };

        if (this.behavior == "selectX" || this.behavior == "selectY" || this.behavior == "selectXY") {// void
        } else {
          this.selection.hide();
        }
      }
    }
  };
  /**
   * Overriding inherited method, so that nothing happens when `updateSize`
   * is triggered.
   *
   * RadarCursor is quite complicated and needs own sizing logic.
   *
   * @ignore Exclude from docs
   */


  RadarCursor.prototype.updateSize = function () {};

  Object.defineProperty(RadarCursor.prototype, "radius", {
    /**
     * @return Outer radius
     */
    get: function get() {
      return this.getPropertyValue("radius");
    },

    /**
     * Outer radius of the cursor's circular line.
     * Absolute (px) or relative ([[Percent]]).
     *
     * @param value  Outer radius
     */
    set: function set(value) {
      this.setPercentProperty("radius", value, false, false, 10, false);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(RadarCursor.prototype, "pixelRadius", {
    /**
     * Outer radius of the circular line in pixels.
     *
     * @return Outer radius (px)
     * @readonly
     */
    get: function get() {
      return _core_utils_Utils__WEBPACK_IMPORTED_MODULE_6__["relativeRadiusToValue"](this.radius, this.truePixelRadius);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(RadarCursor.prototype, "truePixelRadius", {
    /**
     * [truePixelRadius description]
     *
     * @todo Description
     * @return Outer radius (px)
     * @readonly
     */
    get: function get() {
      return _core_utils_Utils__WEBPACK_IMPORTED_MODULE_6__["relativeToValue"](Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_2__["percent"])(100), _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["min"](this.innerWidth / 2, this.innerHeight / 2));
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(RadarCursor.prototype, "innerRadius", {
    /**
     * @return Inner radius
     */
    get: function get() {
      return this.getPropertyValue("innerRadius");
    },

    /**
     * Inner radius of the cursor's circular line.
     * Absolute (px) or relative ([[Percent]]).
     *
     * @param value  Inner radius
     */
    set: function set(value) {
      this.setPercentProperty("innerRadius", value, false, false, 10, false);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(RadarCursor.prototype, "pixelInnerRadius", {
    /**
     * Inner radius of the circular line in pixels.
     *
     * @return Inner radius (px)
     * @readonly
     */
    get: function get() {
      var innerRadius = this.innerRadius;

      if (innerRadius instanceof _core_utils_Percent__WEBPACK_IMPORTED_MODULE_2__["Percent"]) {
        innerRadius = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_2__["percent"])(100 * innerRadius.value * this.chart.innerRadiusModifyer);
      }

      return _core_utils_Utils__WEBPACK_IMPORTED_MODULE_6__["relativeRadiusToValue"](innerRadius, this.truePixelRadius) || 0;
    },
    enumerable: true,
    configurable: true
  });
  /**
   *
   * @ignore Exclude from docs
   */

  RadarCursor.prototype.fixPoint = function (point) {
    // overriding xy method
    return point;
  };

  return RadarCursor;
}(_XYCursor__WEBPACK_IMPORTED_MODULE_1__["XYCursor"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_3__["registry"].registeredClasses["RadarCursor"] = RadarCursor;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/cursors/XYCursor.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/cursors/XYCursor.js ***!
  \*******************************************************************************/
/*! exports provided: XYCursor */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "XYCursor", function() { return XYCursor; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Cursor__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Cursor */ "./node_modules/@amcharts/amcharts4/.internal/charts/cursors/Cursor.js");
/* harmony import */ var _core_Sprite__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/Sprite */ "./node_modules/@amcharts/amcharts4/.internal/core/Sprite.js");
/* harmony import */ var _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/utils/Disposer */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Disposer.js");
/* harmony import */ var _axes_ValueAxis__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../axes/ValueAxis */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/ValueAxis.js");
/* harmony import */ var _axes_DateAxis__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../axes/DateAxis */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/DateAxis.js");
/* harmony import */ var _series_XYSeries__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../series/XYSeries */ "./node_modules/@amcharts/amcharts4/.internal/charts/series/XYSeries.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_utils_Color__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../core/utils/Color */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Color.js");
/* harmony import */ var _core_utils_InterfaceColorSet__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../core/utils/InterfaceColorSet */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/InterfaceColorSet.js");
/* harmony import */ var _core_interaction_Interaction__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../core/interaction/Interaction */ "./node_modules/@amcharts/amcharts4/.internal/core/interaction/Interaction.js");
/* harmony import */ var _core_interaction_Mouse__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../core/interaction/Mouse */ "./node_modules/@amcharts/amcharts4/.internal/core/interaction/Mouse.js");
/* harmony import */ var _core_utils_Math__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../core/utils/Math */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Math.js");
/* harmony import */ var _core_utils_Utils__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../core/utils/Utils */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Utils.js");
/* harmony import */ var _core_utils_Type__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../core/utils/Type */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Type.js");
/* harmony import */ var _core_utils_Array__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../core/utils/Array */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Array.js");
/* harmony import */ var _core_rendering_Path__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../core/rendering/Path */ "./node_modules/@amcharts/amcharts4/.internal/core/rendering/Path.js");
/**
 * Cursor for XY chart
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */

















/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * A cursor used on [[XYChart]].
 *
 * @see {@link IXYCursorEvents} for a list of available events
 * @see {@link IXYCursorAdapters} for a list of available Adapters
 * @todo Add description, examples
 */

var XYCursor =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(XYCursor, _super);
  /**
   * Constructor
   */


  function XYCursor() {
    var _this = // Init
    _super.call(this) || this;
    /**
     * Vertical cursor line element.
     */


    _this._lineX = new _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_3__["MutableValueDisposer"]();
    /**
     * Horizontal cursor line element.
     */

    _this._lineY = new _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_3__["MutableValueDisposer"]();
    /**
     * Horizontal [[Axis]].
     */

    _this._xAxis = new _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_3__["MutableValueDisposer"]();
    /**
     * Vertical [[Axis]].
     */

    _this._yAxis = new _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_3__["MutableValueDisposer"]();
    _this._snapToDisposers = [];
    _this.className = "XYCursor"; // Defaults

    _this.behavior = "zoomX";
    _this.maxPanOut = 0.1;
    var interfaceColors = new _core_utils_InterfaceColorSet__WEBPACK_IMPORTED_MODULE_9__["InterfaceColorSet"]();
    _this.snapOnPan = true; // Create selection element

    var selection = _this.createChild(_core_Sprite__WEBPACK_IMPORTED_MODULE_2__["Sprite"]);

    selection.shouldClone = false;
    selection.fillOpacity = 0.2;
    selection.fill = interfaceColors.getFor("alternativeBackground");
    selection.isMeasured = false;
    selection.visible = false;
    selection.interactionsEnabled = false;
    _this.selection = selection;

    _this._disposers.push(_this.selection); // Create cursor's vertical line


    var lineX = _this.createChild(_core_Sprite__WEBPACK_IMPORTED_MODULE_2__["Sprite"]);

    lineX.shouldClone = false;
    lineX.stroke = interfaceColors.getFor("grid");
    lineX.fill = Object(_core_utils_Color__WEBPACK_IMPORTED_MODULE_8__["color"])();
    lineX.strokeDasharray = "3,3";
    lineX.isMeasured = false;
    lineX.strokeOpacity = 0.4;
    lineX.interactionsEnabled = false;
    lineX.y = 0; // important

    _this.lineX = lineX;

    _this._disposers.push(_this.lineX); // Create cursor's horizontal line


    var lineY = _this.createChild(_core_Sprite__WEBPACK_IMPORTED_MODULE_2__["Sprite"]);

    lineY.shouldClone = false;
    lineY.stroke = interfaceColors.getFor("grid");
    lineY.fill = Object(_core_utils_Color__WEBPACK_IMPORTED_MODULE_8__["color"])();
    lineY.strokeDasharray = "3,3";
    lineY.isMeasured = false;
    lineY.strokeOpacity = 0.4;
    lineY.interactionsEnabled = false;
    lineY.x = 0; // important

    _this.lineY = lineY;

    _this._disposers.push(_this.lineY); // Add handler for size changes


    _this.events.on("sizechanged", _this.updateSize, _this, false);

    _this._disposers.push(_this._lineX);

    _this._disposers.push(_this._lineY);

    _this._disposers.push(_this._xAxis);

    _this._disposers.push(_this._yAxis);

    _this.mask = _this;
    _this.hideSeriesTooltipsOnSelection = true; // Apply theme

    _this.applyTheme();

    return _this;
  }
  /**
   * Updates cursor element dimensions on size change.
   *
   * @ignore Exclude from docs
   */


  XYCursor.prototype.updateSize = function () {
    if (this.lineX) {
      this.lineX.path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_16__["moveTo"]({
        x: 0,
        y: 0
      }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_16__["lineTo"]({
        x: 0,
        y: this.innerHeight
      });
    }

    if (this.lineY) {
      this.lineY.path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_16__["moveTo"]({
        x: 0,
        y: 0
      }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_16__["lineTo"]({
        x: this.innerWidth,
        y: 0
      });
    }
  };
  /**
   * Updates selection dimensions on size change.
   *
   * @ignore Exclude from docs
   */


  XYCursor.prototype.updateSelection = function () {
    if (this._usesSelection) {
      var downPoint = this.downPoint;
      var behavior = this.behavior;

      if (downPoint) {
        var point = this.point;

        if (this.lineX) {
          point.x = this.lineX.pixelX;
        }

        if (this.lineY) {
          point.y = this.lineY.pixelY;
        }

        var selection = this.selection;
        var x = Math.min(point.x, downPoint.x);
        var y = Math.min(point.y, downPoint.y);
        var w = _core_utils_Math__WEBPACK_IMPORTED_MODULE_12__["round"](Math.abs(downPoint.x - point.x), this._positionPrecision);
        var h = _core_utils_Math__WEBPACK_IMPORTED_MODULE_12__["round"](Math.abs(downPoint.y - point.y), this._positionPrecision);

        switch (behavior) {
          case "zoomX":
            y = 0;
            h = this.pixelHeight;
            break;

          case "zoomY":
            x = 0;
            w = this.pixelWidth;
            break;

          case "selectX":
            y = 0;
            h = this.pixelHeight;
            break;

          case "selectY":
            x = 0;
            w = this.pixelWidth;
            break;
        }

        selection.x = x;
        selection.y = y;
        selection.path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_16__["rectangle"](w, h);
        selection.validatePosition(); // otherwise Edge shoes some incorrect size rectangle
      } else {
        if (this._generalBehavior != "select") {
          this.selection.hide();
        }
      }
    }
  };
  /**
   *
   * @ignore Exclude from docs
   */


  XYCursor.prototype.fixPoint = function (point) {
    point.x = Math.max(0, point.x);
    point.y = Math.max(0, point.y);
    point.x = Math.min(this.pixelWidth, point.x);
    point.y = Math.min(this.pixelHeight, point.y);
    return point;
  };
  /**
   * Places the cursor at specific point.
   *
   * @param point Point to place cursor at
   */


  XYCursor.prototype.triggerMoveReal = function (point, force) {
    _super.prototype.triggerMoveReal.call(this, point, force);

    var snapToSeries = this.snapToSeries;

    if (snapToSeries && !this.downPoint) {
      if (snapToSeries instanceof _series_XYSeries__WEBPACK_IMPORTED_MODULE_6__["XYSeries"]) {
        if (snapToSeries.isHidden) {
          this.updateLinePositions(point);
        }
      } else {
        var allHidden_1 = true;
        _core_utils_Array__WEBPACK_IMPORTED_MODULE_15__["each"](snapToSeries, function (s) {
          if (!s.isHidden) {
            allHidden_1 = false;
          }
        });

        if (allHidden_1) {
          this.updateLinePositions(point);
        }
      }
    } else {
      this.updateLinePositions(point);
    }

    if (this.downPoint && _core_utils_Math__WEBPACK_IMPORTED_MODULE_12__["getDistance"](this.downPoint, point) > 3) {
      if (this._generalBehavior == "pan") {
        this.getPanningRanges();
        this.dispatch("panning");
      }
    }
  };
  /**
   *
   * @ignore Exclude from docs
   */


  XYCursor.prototype.updateLinePositions = function (point) {
    point = this.fixPoint(this.point);

    if (this.lineX && this.lineX.visible && !this.xAxis) {
      this.lineX.x = point.x;
    }

    if (this.lineY && this.lineY.visible && !this.yAxis) {
      this.lineY.y = point.y;
    }

    this.updateSelection();
  };

  XYCursor.prototype.triggerDownReal = function (point) {
    if (this.visible && !this.isHiding) {
      if (this._generalBehavior == "select") {
        this.selection.parent = this.parent;
      }

      if (this.fitsToBounds(point)) {
        this.downPoint = {
          x: point.x,
          y: point.y
        };
        this.updatePoint(point); //this.updateLinePositions(point); // otherwise lines won't be in correct position and touch won't work fine

        this.point.x = this.downPoint.x;
        this.point.y = this.downPoint.y;
        var selection = this.selection;
        var selectionX = this.downPoint.x;
        var selectionY = this.downPoint.y;

        if (this._usesSelection) {
          selection.x = selectionX;
          selection.y = selectionY;
          selection.path = "";
          selection.show();
        }

        _super.prototype.triggerDownReal.call(this, point);
      } else {
        this.downPoint = undefined;
      }
    } else {
      this.downPoint = undefined;
    }
  };
  /**
   * Updates the coordinates of where pointer down event occurred
   * (was pressed).
   */


  XYCursor.prototype.updatePoint = function (point) {
    if (this.lineX) {
      point.x = this.lineX.pixelX;
    }

    if (this.lineY) {
      point.y = this.lineY.pixelY;
    }
  };
  /**
   * Handle action when cursor is released, which should perform an operation
   * based on its `behavior`, like zoom.
   *
   * @param  point  Release point
   */


  XYCursor.prototype.triggerUpReal = function (point) {
    if (this.hasMoved()) {
      if (this.downPoint) {
        this.upPoint = point;
        this.updatePoint(this.upPoint);

        if (this._generalBehavior != "pan") {
          this.getRanges();
        }

        if (this._generalBehavior != "select") {
          this.selection.hide();
        }

        _super.prototype.triggerUpReal.call(this, point);
      }
    } else {
      if (this._generalBehavior != "select") {
        this.selection.hide(0);
      } else {
        this.xRange = undefined;
        this.yRange = undefined;
        this.dispatchImmediately("selectended");
      } // reset cursor style, just in case


      if (this._generalBehavior == "pan") {
        var interaction = Object(_core_interaction_Interaction__WEBPACK_IMPORTED_MODULE_10__["getInteraction"])();
        interaction.setGlobalStyle(_core_interaction_Mouse__WEBPACK_IMPORTED_MODULE_11__["MouseCursorStyle"].default);
      }

      this.dispatchImmediately("behaviorcanceled");
    }

    this.downPoint = undefined;
    this.dispatch("cursorpositionchanged");
  };
  /**
   * Calculates if the cursor has moved enough based on its `behavior`.
   *
   * @return Moved?
   */


  XYCursor.prototype.hasMoved = function () {
    var distance;

    if (this.behavior == "zoomX" || this.behavior == "panX") {
      distance = _core_utils_Math__WEBPACK_IMPORTED_MODULE_12__["getHorizontalDistance"](this._upPointOrig, this._downPointOrig);
    } else if (this.behavior == "zoomY" || this.behavior == "panY") {
      distance = _core_utils_Math__WEBPACK_IMPORTED_MODULE_12__["getVerticalDistance"](this._upPointOrig, this._downPointOrig);
    } else {
      distance = _core_utils_Math__WEBPACK_IMPORTED_MODULE_12__["getDistance"](this._upPointOrig, this._downPointOrig);
    }

    return distance > Object(_core_interaction_Interaction__WEBPACK_IMPORTED_MODULE_10__["getInteraction"])().getHitOption(this.interactions, "hitTolerance");
  };
  /**
   * [getRanges description]
   *
   * @todo Description
   */


  XYCursor.prototype.getPanningRanges = function () {
    var startX = _core_utils_Math__WEBPACK_IMPORTED_MODULE_12__["round"](this.downPoint.x / this.innerWidth, 5);
    var startY = 1 - _core_utils_Math__WEBPACK_IMPORTED_MODULE_12__["round"](this.downPoint.y / this.innerHeight, 5);
    var currentX = _core_utils_Math__WEBPACK_IMPORTED_MODULE_12__["round"](this.point.x / this.innerWidth, 5);
    var currentY = 1 - _core_utils_Math__WEBPACK_IMPORTED_MODULE_12__["round"](this.point.y / this.innerHeight, 5);
    var deltaX = startX - currentX;
    var deltaY = startY - currentY;
    this.xRange = {
      start: deltaX,
      end: 1 + deltaX
    };
    this.yRange = {
      start: deltaY,
      end: 1 + deltaY
    };

    if (this.behavior == "panX") {
      this.yRange.start = 0;
      this.yRange.end = 1;
    }

    if (this.behavior == "panY") {
      this.xRange.start = 0;
      this.xRange.end = 1;
    }
  };
  /**
   * [getRanges description]
   *
   * @todo Description
   */


  XYCursor.prototype.getRanges = function () {
    if (this.lineX) {
      this.upPoint.x = this.lineX.pixelX;
    }

    if (this.lineY) {
      this.upPoint.y = this.lineY.pixelY;
    } // @todo Is this needed?


    _core_utils_Utils__WEBPACK_IMPORTED_MODULE_13__["used"](this.selection);
    var startX = _core_utils_Math__WEBPACK_IMPORTED_MODULE_12__["round"](this.downPoint.x / this.innerWidth, 5);
    var endX = _core_utils_Math__WEBPACK_IMPORTED_MODULE_12__["round"](this.upPoint.x / this.innerWidth, 5);
    var startY = 1 - _core_utils_Math__WEBPACK_IMPORTED_MODULE_12__["round"](this.downPoint.y / this.innerHeight, 5);
    var endY = 1 - _core_utils_Math__WEBPACK_IMPORTED_MODULE_12__["round"](this.upPoint.y / this.innerHeight, 5);
    this.xRange = {
      start: _core_utils_Math__WEBPACK_IMPORTED_MODULE_12__["min"](startX, endX),
      end: _core_utils_Math__WEBPACK_IMPORTED_MODULE_12__["max"](startX, endX)
    };
    this.yRange = {
      start: _core_utils_Math__WEBPACK_IMPORTED_MODULE_12__["min"](startY, endY),
      end: _core_utils_Math__WEBPACK_IMPORTED_MODULE_12__["max"](startY, endY)
    };
  };

  Object.defineProperty(XYCursor.prototype, "behavior", {
    /**
     * Behavior
     */
    get: function get() {
      return this.getPropertyValue("behavior");
    },

    /**
     * Cursor's behavior when it's moved with pointer down:
     *
     * * `"zoomX"` - zooms horizontally.
     * * `"zoomY"` - zooms vertically.
     * * `"zoomXY"` - zooms both horizontally and vertically.
     * * `"selectX"` - selects a range horizontally.
     * * `"selectY"` - selects a range vertically.
     * * `"selectXY"` - selects a range both horizontally and vertically.
     * * `"panX"` - moves (pans) current selection horizontally.
     * * `"panY"` - moves (pans) current selection vertically.
     * * `"panXY"` - moves (pans) current selection both horizontally and vertically.
     * * `"none"` - does nothing with pointer down.
     *
     * E.g. "zoomXY" will mean that pressing a mouse (or touching) over plot area
     * and dragging it will start zooming the chart.
     *
     * NOTE: `"zoomXY"` acts differently when used on a `DateAxis`.
     * See [this note](https://www.amcharts.com/docs/v4/concepts/chart-cursor/#zoomXY_behavior_and_DateAxis).
     *
     * @param value Bheavior
     */
    set: function set(value) {
      this.setPropertyValue("behavior", value, true);
      this._usesSelection = false;

      if (value.indexOf("zoom") != -1) {
        this._generalBehavior = "zoom";
        this._usesSelection = true;
      }

      if (value.indexOf("select") != -1) {
        this._generalBehavior = "select";
        this._usesSelection = true;
      }

      if (value.indexOf("pan") != -1) {
        this._generalBehavior = "pan";
        this._usesSelection = false;
      }
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Determines whether Cursor should prevent default action on move.
   *
   * If cursor's behavior is "none", it should not obstruct the page scrolling.
   *
   * @return Prevent default?
   */

  XYCursor.prototype.shouldPreventGestures = function (touch) {
    return (!this.interactions.isTouchProtected || !touch) && this.behavior != "none";
  };

  Object.defineProperty(XYCursor.prototype, "fullWidthLineX", {
    /**
     * @return Full width?
     */
    get: function get() {
      return this.getPropertyValue("fullWidthLineX");
    },

    /**
     * Cursor's horizontal line is expanded to take full width of the related
     * Axis' cell/category.
     *
     * NOTE: this setting will work properly if `xAxis` is set and only in case
     * `xAxis` is [[CategoryAxis]] or [[DateAxis]].
     *
     * @param value Full width?
     */
    set: function set(value) {
      this.setPropertyValue("fullWidthLineX", value);

      if (!value) {
        this.updateSize();
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(XYCursor.prototype, "fullWidthLineY", {
    /**
     * @return Full width?
     */
    get: function get() {
      return this.getPropertyValue("fullWidthLineY");
    },

    /**
     * Cursor's vertical line is expanded to take full width of the related
     * Axis' cell/category.
     *
     * NOTE: this setting will work properly if `yAxis` is set and only in case
     * `yAxis` is [[CategoryAxis]] or [[DateAxis]].
     *
     * @param value Full width?
     */
    set: function set(value) {
      this.setPropertyValue("fullWidthLineY", value);

      if (!value) {
        this.updateSize();
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(XYCursor.prototype, "hideSeriesTooltipsOnSelection", {
    /**
     * @return hide tooltip?
     */
    get: function get() {
      return this.getPropertyValue("hideSeriesTooltipsOnSelection");
    },

    /**
     * If set to `true` this will hide series tooltips when selecting with cursor.
     *
     * @since 4.5.15
     * @param  value  hide tooltips?
     */
    set: function set(value) {
      this.setPropertyValue("hideSeriesTooltipsOnSelection", value);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(XYCursor.prototype, "maxTooltipDistance", {
    /**
     * @return Distance
     */
    get: function get() {
      return this.getPropertyValue("maxTooltipDistance");
    },

    /**
     * If set to a numeric value, cursor will display closest series' tooltips
     * plus tooltips from series that are closer to than `maxTooltipDistance` to
     * it.
     *
     * Set it to `-1` to always force one tooltip, even if there are multiple
     * data items in exactly same place.
     *
     * @since 4.7.18
     * @param  value  Distance
     */
    set: function set(value) {
      this.setPropertyValue("maxTooltipDistance", value);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(XYCursor.prototype, "maxPanOut", {
    /**
     * @return Full width?
     */
    get: function get() {
      return this.getPropertyValue("maxPanOut");
    },

    /**
     * If cursor behavior is panX or panY, we allow to pan plot out of it's max bounds for a better user experience.
     * This setting specifies relative value by how much we can pan out the plot
     *
     * @param value
     */
    set: function set(value) {
      this.setPropertyValue("maxPanOut", value);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(XYCursor.prototype, "xAxis", {
    /**
     * @return X axis
     */
    get: function get() {
      return this._xAxis.get();
    },

    /**
     * A reference to X [[Axis]].
     *
     * An XY cursor can live without `xAxis` set. You set xAxis for cursor when
     * you have axis tooltip enabled and you want cursor line to be at the same
     * position as tooltip.
     *
     * This works with [[CategoryAxis]] and [[DateAxis]] but not with
     * [[ValueAxis]].
     *
     * @todo Description (review)
     * @param axis X axis
     */
    set: function set(axis) {
      var _this = this;

      if (this._xAxis.get() != axis) {
        this._xAxis.set(axis, new _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_3__["MultiDisposer"]([axis.tooltip.events.on("positionchanged", this.handleXTooltipPosition, this, false), axis.events.on("rangechangestarted", function (event) {
          _this.hide(0);

          _this.preventShow = true;
        }, undefined, false), axis.events.on("rangechangeended", function (event) {
          _this.preventShow = false;

          _this.hide(0);

          _this.dispatch("cursorpositionchanged");
        }, undefined, false)]));
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(XYCursor.prototype, "yAxis", {
    /**
     * @return Y Axis
     */
    get: function get() {
      return this._yAxis.get();
    },

    /**
     * A reference to Y [[Axis]].
     *
     * An XY cursor can live without `yAxis` set. You set xAxis for cursor when
     * you have axis tooltip enabled and you want cursor line to be at the same
     * position as tooltip.
     *
     * This works with [[CategoryAxis]] and [[DateAxis]] but not with
     * [[ValueAxis]].
     *
     * @todo Description (review)
     * @param axis Y axis
     */
    set: function set(axis) {
      var _this = this;

      if (this._yAxis.get() != axis) {
        this._yAxis.set(axis, new _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_3__["MultiDisposer"]([axis.tooltip.events.on("positionchanged", this.handleYTooltipPosition, this, false), axis.events.on("rangechangestarted", function (event) {
          _this.hide(0);

          _this.__disabled = true;
        }, undefined, false), axis.events.on("rangechangeended", function (event) {
          _this.__disabled = false;

          _this.hide(0);

          _this.dispatch("cursorpositionchanged");
        }, undefined, false)]));
      }
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Updates Cursor's position when axis tooltip changes position.
   *
   * @ignore Exclude from docs
   * @param event Original Axis event
   */

  XYCursor.prototype.handleXTooltipPosition = function (event) {
    var tooltip = this.xAxis.tooltip;
    var point = _core_utils_Utils__WEBPACK_IMPORTED_MODULE_13__["svgPointToSprite"]({
      x: tooltip.pixelX,
      y: tooltip.pixelY
    }, this);
    var x = point.x;
    point.y = 1;

    if (this.lineX) {
      this.lineX.x = x;

      if (!this.fitsToBounds(point)) {
        this.hide();
      }
    }

    if (this.xAxis && this.fullWidthLineX) {
      var startPoint = this.xAxis.currentItemStartPoint;
      var endPoint = this.xAxis.currentItemEndPoint;

      if (startPoint && endPoint) {
        this.lineX.x = x;
        var width = endPoint.x - startPoint.x;
        this.lineX.path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_16__["rectangle"](width, this.innerHeight, -width / 2);
      }
    }
  };
  /**
   * Updates Cursor's position when Y axis changes position or scale.
   *
   * @ignore Exclude from docs
   * @param event Original Axis event
   */


  XYCursor.prototype.handleYTooltipPosition = function (event) {
    var tooltip = this.yAxis.tooltip;
    var point = _core_utils_Utils__WEBPACK_IMPORTED_MODULE_13__["svgPointToSprite"]({
      x: tooltip.pixelX,
      y: tooltip.pixelY
    }, this);
    var y = point.y;
    point.x = 1;

    if (this.lineY) {
      this.lineY.y = y;

      if (!this.fitsToBounds(point)) {
        this.hide();
      }
    }

    if (this.yAxis && this.fullWidthLineY) {
      var startPoint = this.yAxis.currentItemStartPoint;
      var endPoint = this.yAxis.currentItemEndPoint;

      if (startPoint && endPoint) {
        this.lineY.y = y;
        var height = endPoint.y - startPoint.y;
        this.lineY.path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_16__["rectangle"](this.innerWidth, height, 0, -height / 2);
      }
    }
  };

  Object.defineProperty(XYCursor.prototype, "lineX", {
    /**
     * @return Line element
     */
    get: function get() {
      return this._lineX.get();
    },

    /**
     * A Line element to use for X axis.
     *
     * @param lineX Line
     */
    set: function set(lineX) {
      if (lineX) {
        lineX.setElement(this.paper.add("path"));

        this._lineX.set(lineX, lineX.events.on("positionchanged", this.updateSelection, this, false));

        lineX.interactionsEnabled = false;
        lineX.parent = this;
      } else {
        this._lineX.reset();
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(XYCursor.prototype, "lineY", {
    /**
     * @return Line element
     */
    get: function get() {
      return this._lineY.get();
    },

    /**
     * A Line element to use Y axis.
     *
     * @param lineY Line
     */
    set: function set(lineY) {
      if (lineY) {
        lineY.setElement(this.paper.add("path"));

        this._lineY.set(lineY, lineY.events.on("positionchanged", this.updateSelection, this, false));

        lineY.parent = this;
        lineY.interactionsEnabled = false;
      } else {
        this._lineY.reset();
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(XYCursor.prototype, "selection", {
    /**
     * @return Selection rectangle
     */
    get: function get() {
      return this._selection;
    },

    /**
     * A selection element ([[Sprite]]).
     *
     * @param selection Selection rectangle
     */
    set: function set(selection) {
      this._selection = selection;

      if (selection) {
        selection.element = this.paper.add("path");
        selection.parent = this;
      }
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Processes JSON-based config before it is applied to the object.
   *
   * Looks if `xAxis` and `yAxis` is set via ID in JSON config, and replaces
   * with real references.
   *
   * @ignore Exclude from docs
   * @param config  Config
   */

  XYCursor.prototype.processConfig = function (config) {
    var _this = this;

    if (config) {
      // Set up axes
      if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_14__["hasValue"](config.xAxis) && _core_utils_Type__WEBPACK_IMPORTED_MODULE_14__["isString"](config.xAxis)) {
        if (this.map.hasKey(config.xAxis)) {
          config.xAxis = this.map.getKey(config.xAxis);
        } else {
          this.processingErrors.push("[XYCursor] No axis with id \"" + config.xAxis + "\" found for `xAxis`");
          delete config.xAxis;
        }
      }

      if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_14__["hasValue"](config.yAxis) && _core_utils_Type__WEBPACK_IMPORTED_MODULE_14__["isString"](config.yAxis)) {
        if (this.map.hasKey(config.yAxis)) {
          config.yAxis = this.map.getKey(config.yAxis);
        } else {
          this.processingErrors.push("[XYCursor] No axis with id \"" + config.yAxis + "\" found for `yAxis`");
          delete config.yAxis;
        }
      }

      if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_14__["hasValue"](config.snapToSeries)) {
        var snapTo_1 = _core_utils_Type__WEBPACK_IMPORTED_MODULE_14__["isArray"](config.snapToSeries) ? config.snapToSeries : [config.snapToSeries];
        var snapError_1 = false;
        _core_utils_Array__WEBPACK_IMPORTED_MODULE_15__["each"](snapTo_1, function (snap, index) {
          if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_14__["isString"](snap)) {
            if (_this.map.hasKey(snap)) {
              snapTo_1[index] = _this.map.getKey(snap);
            } else {
              _this.processingErrors.push("[XYCursor] No series with id \"" + snap + "\" found for `series`");

              snapError_1 = true;
            }
          }
        });

        if (snapError_1) {
          delete config.snapToSeries;
        } else {
          config.snapToSeries = snapTo_1;
        }
      }
    }

    _super.prototype.processConfig.call(this, config);
  };

  Object.defineProperty(XYCursor.prototype, "snapToSeries", {
    /**
     * @return {XYSeries | XYSeries[]}
     */
    get: function get() {
      return this.getPropertyValue("snapToSeries");
    },

    /**
     * Specifies to which series cursor lines should be snapped.
     *
     * Can be a single series instance or an array of series.
     *
     * @param {XYSeries | XYSeries[]}
     */
    set: function set(series) {
      var _this = this;

      if (this.setPropertyValue("snapToSeries", series)) {
        if (series instanceof _series_XYSeries__WEBPACK_IMPORTED_MODULE_6__["XYSeries"]) {
          series = [series];
        }

        if (this._snapToDisposers) {
          _core_utils_Array__WEBPACK_IMPORTED_MODULE_15__["each"](this._snapToDisposers, function (disposer) {
            disposer.dispose();
          });
        }

        this._snapToDisposers = [];

        if (series) {
          _core_utils_Array__WEBPACK_IMPORTED_MODULE_15__["each"](series, function (s) {
            _this._snapToDisposers.push(s.events.on("tooltipshownat", function () {
              _this.handleSnap(s);
            }, undefined, false));
          });
        }
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(XYCursor.prototype, "snapOnPan", {
    /**
     * Should zoom selection "snap" into equal categories/intervals after panning
     * the chart? (when `behavior == "panX"`)
     *
     * @default true
     * @since 4.10.17
     * @return Snap on pan?
     */
    get: function get() {
      return this.getPropertyValue("snapOnPan");
    },

    /**
     * @param value Snap on pan?
     */
    set: function set(value) {
      this.setPropertyValue("snapOnPan", value);
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Snaps the zoom selection after chart is panned.
   *
   * @ignore
   */

  XYCursor.prototype.handleSnap = function (series) {
    if (!this.downPoint) {
      var x = series.getTooltipX() + series.xAxis.pixelX;
      var y = series.getTooltipY() + series.yAxis.pixelY;

      if (this.xAxis) {
        if (this.xAxis.renderer.opposite) {
          y -= this.pixelHeight;
        }
      }

      this.point = {
        x: x,
        y: y
      };
      this.getPositions();
      var xx = x;
      var yy = y;
      x -= this.pixelWidth;

      if (this.yAxis) {
        if (this.yAxis.renderer.opposite) {
          x += this.pixelWidth;
        }
      }

      var tooltip = series.tooltip;
      var duration = tooltip.animationDuration;
      var easing = tooltip.animationEasing;
      var xAxis = series.xAxis;
      var yAxis = series.yAxis;

      if (xAxis instanceof _axes_ValueAxis__WEBPACK_IMPORTED_MODULE_4__["ValueAxis"] && !(xAxis instanceof _axes_DateAxis__WEBPACK_IMPORTED_MODULE_5__["DateAxis"]) && yAxis instanceof _axes_ValueAxis__WEBPACK_IMPORTED_MODULE_4__["ValueAxis"] && !(yAxis instanceof _axes_DateAxis__WEBPACK_IMPORTED_MODULE_5__["DateAxis"])) {
        series.yAxis.showTooltipAtPosition(this.yPosition);
        series.xAxis.showTooltipAtPosition(this.xPosition);
      } else {
        if (series.baseAxis == series.xAxis) {
          series.yAxis.showTooltipAtPosition(this.yPosition);
        }

        if (series.baseAxis == series.yAxis) {
          series.xAxis.showTooltipAtPosition(this.xPosition);
        }
      }

      this.lineX.animate([{
        property: "y",
        to: y
      }], duration, easing);
      this.lineY.animate([{
        property: "x",
        to: x
      }], duration, easing);

      if (!this.xAxis) {
        this.lineX.animate([{
          property: "x",
          to: xx
        }], duration, easing);
      }

      if (!this.yAxis) {
        this.lineY.animate([{
          property: "y",
          to: yy
        }], duration, easing);
      }
    }
  };
  /**
   * Destroys this object and all related data.
   */


  XYCursor.prototype.dispose = function () {
    this.hide(0);

    _super.prototype.dispose.call(this);
  };

  return XYCursor;
}(_Cursor__WEBPACK_IMPORTED_MODULE_1__["Cursor"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_7__["registry"].registeredClasses["XYCursor"] = XYCursor;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/Bullet.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/elements/Bullet.js ***!
  \******************************************************************************/
/*! exports provided: Bullet */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Bullet", function() { return Bullet; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _core_Container__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core/Container */ "./node_modules/@amcharts/amcharts4/.internal/core/Container.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_utils_Responsive__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/utils/Responsive */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Responsive.js");
/**
 * Module that defines everything related to building bullets.
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */




/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Class used to creates bullets.
 *
 * @see {@link IBulletEvents} for a list of available events
 * @see {@link IBulletAdapters} for a list of available Adapters
 * @todo Usage example
 * @important
 */

var Bullet =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(Bullet, _super);
  /**
   * Constructor
   */


  function Bullet() {
    var _this = _super.call(this) || this;

    _this.className = "Bullet";
    _this.isMeasured = false;
    _this.tooltipX = 0;
    _this.tooltipY = 0;
    _this.layout = "none";
    _this.applyOnClones = true;
    _this.copyToLegendMarker = true;

    _this.applyTheme();

    return _this;
  }

  Object.defineProperty(Bullet.prototype, "locationX", {
    /**
     * @return Location (0-1)
     */
    get: function get() {
      return this.getPropertyValue("locationX");
    },

    /**
     * Relative horizontal location within cell. (0-1)
     *
     * @param value  Location (0-1)
     */
    set: function set(value) {
      if (this.setPropertyValue("locationX", value)) {
        var dataItem = this.dataItem;

        if (dataItem && dataItem.component) {
          dataItem.component.invalidate();
        }
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(Bullet.prototype, "locationY", {
    /**
     * @return Location (0-1)
     */
    get: function get() {
      return this.getPropertyValue("locationY");
    },

    /**
     * Relative vertical location within cell. (0-1)
     *
     * @param value  Location (0-1)
     */
    set: function set(value) {
      if (this.setPropertyValue("locationY", value)) {
        var dataItem = this.dataItem;

        if (dataItem && dataItem.component) {
          dataItem.component.invalidate();
        }
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(Bullet.prototype, "xField", {
    /**
     * @return [description]
     */
    get: function get() {
      return this.getPropertyValue("xField");
    },

    /**
     * [xField description]
     *
     * @todo Description
     * @param value  [description]
     */
    set: function set(value) {
      this.setPropertyValue("xField", value, true);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(Bullet.prototype, "yField", {
    /**
     * @return [description]
     */
    get: function get() {
      return this.getPropertyValue("yField");
    },

    /**
     * [yField description]
     *
     * Description
     * @param value  [description]
     */
    set: function set(value) {
      this.setPropertyValue("yField", value, true);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(Bullet.prototype, "isDynamic", {
    /**
     * @return Redraw on data change?
     */
    get: function get() {
      return this.getPropertyValue("isDynamic");
    },

    /**
     * Indicates if the bullet is "dynamic".
     *
     * In most cases the bullets remain the same, even if the underlying data
     * changes.
     *
     * However, in cases where bullet also displays a label, or its size depends
     * on data, it also needs to be redrawn when the underlying data changes.
     *
     * Only those bullets that have set `isDynamic = true` will be redrawn each
     * time data changes. Regular bullets will be reused as they are.
     *
     * @default false
     * @param value  Redraw on data change?
     */
    set: function set(value) {
      this.setPropertyValue("isDynamic", value, true);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(Bullet.prototype, "copyToLegendMarker", {
    /**
     * @return Redraw on data change?
     */
    get: function get() {
      return this.getPropertyValue("copyToLegendMarker");
    },

    /**
     * Indicates if the bullet should be copied to legend marker
     *
     * @default false
     * @param value  Redraw on data change?
     */
    set: function set(value) {
      this.setPropertyValue("copyToLegendMarker", value);
    },
    enumerable: true,
    configurable: true
  });
  return Bullet;
}(_core_Container__WEBPACK_IMPORTED_MODULE_1__["Container"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_2__["registry"].registeredClasses["Bullet"] = Bullet;
/**
 * Add default responsive rules
 */

/**
 * Hide bullets
 */

_core_utils_Responsive__WEBPACK_IMPORTED_MODULE_3__["defaultRules"].push({
  relevant: _core_utils_Responsive__WEBPACK_IMPORTED_MODULE_3__["ResponsiveBreakpoints"].isXS,
  state: function state(target, stateId) {
    if (target instanceof Bullet) {
      var state = target.states.create(stateId);
      state.properties.disabled = true;
      return state;
    }

    return null;
  }
});

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/Candlestick.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/elements/Candlestick.js ***!
  \***********************************************************************************/
/*! exports provided: Candlestick */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Candlestick", function() { return Candlestick; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Column__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Column */ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/Column.js");
/* harmony import */ var _core_elements_Line__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/elements/Line */ "./node_modules/@amcharts/amcharts4/.internal/core/elements/Line.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/**
 * Module that defines everything related to building Candlesticks.
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */




/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Class used to creates Candlesticks.
 *
 * @see {@link ICandlestickEvents} for a list of available events
 * @see {@link ICandlestickAdapters} for a list of available Adapters
 * @todo Usage example
 * @important
 */

var Candlestick =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(Candlestick, _super);
  /**
   * Constructor
   */


  function Candlestick() {
    var _this = _super.call(this) || this;

    _this.className = "Candlestick";
    _this.layout = "none";
    return _this;
  }
  /**
   * @ignore
   */


  Candlestick.prototype.createAssets = function () {
    _super.prototype.createAssets.call(this);

    this.lowLine = this.createChild(_core_elements_Line__WEBPACK_IMPORTED_MODULE_2__["Line"]);
    this.lowLine.shouldClone = false;
    this.highLine = this.createChild(_core_elements_Line__WEBPACK_IMPORTED_MODULE_2__["Line"]);
    this.highLine.shouldClone = false;
  };
  /**
   * Copies all parameters from another [[Candlestick]].
   *
   * @param source Source Candlestick
   */


  Candlestick.prototype.copyFrom = function (source) {
    _super.prototype.copyFrom.call(this, source);

    if (this.lowLine) {
      this.lowLine.copyFrom(source.lowLine);
    }

    if (this.highLine) {
      this.highLine.copyFrom(source.highLine);
    }
  };

  return Candlestick;
}(_Column__WEBPACK_IMPORTED_MODULE_1__["Column"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_3__["registry"].registeredClasses["Candlestick"] = Candlestick;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/ChordLink.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/elements/ChordLink.js ***!
  \*********************************************************************************/
/*! exports provided: ChordLink */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ChordLink", function() { return ChordLink; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _FlowDiagramLink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./FlowDiagramLink */ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/FlowDiagramLink.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_elements_QuadraticCurve__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/elements/QuadraticCurve */ "./node_modules/@amcharts/amcharts4/.internal/core/elements/QuadraticCurve.js");
/* harmony import */ var _core_utils_Math__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/utils/Math */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Math.js");
/* harmony import */ var _core_rendering_Path__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core/rendering/Path */ "./node_modules/@amcharts/amcharts4/.internal/core/rendering/Path.js");
/**
 * ChordLink module
 */






/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * This class creates a link (waved color-filled line) between two nodes in a
 * Chord Diagram.
 *
 * @see {@link IChordLinkEvents} for a list of available events
 * @see {@link IChordLinkAdapters} for a list of available Adapters
 * @important
 */

var ChordLink =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(ChordLink, _super);
  /**
   * Constructor
   */


  function ChordLink() {
    var _this = _super.call(this) || this;

    _this.className = "ChordLink";
    _this.middleLine = _this.createChild(_core_elements_QuadraticCurve__WEBPACK_IMPORTED_MODULE_3__["QuadraticCurve"]);
    _this.middleLine.shouldClone = false;
    _this.middleLine.strokeOpacity = 0;

    _this.applyTheme();

    return _this;
  }
  /**
   * (Re)validates (redraws) the link.
   *
   * @ignore Exclude from docs
   */


  ChordLink.prototype.validate = function () {
    _super.prototype.validate.call(this);

    if (!this.isTemplate) {
      var startAngle = this.startAngle;
      var endAngle = this.endAngle;
      var arc = this.arc;
      var radius = this.radius;
      var fromNode = this.dataItem.fromNode;
      var toNode = this.dataItem.toNode;
      var fromX = 0;
      var fromY = 0;

      if (fromNode) {
        fromX = fromNode.pixelX + fromNode.dx;
        fromY = fromNode.pixelY + fromNode.dy;
      }

      var toX = 0;
      var toY = 0;

      if (toNode) {
        toX = toNode.pixelX + toNode.dx;
        toY = toNode.pixelY + toNode.dy;
      }

      if (radius > 0) {
        var x1 = radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_4__["cos"](startAngle) + fromX;
        var y1 = radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_4__["sin"](startAngle) + fromY;
        var x2 = radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_4__["cos"](endAngle) + toX;
        var y2 = radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_4__["sin"](endAngle) + toY; //let cpAngle = startAngle + arc + (endAngle - startAngle - arc) / 2;
        //let arcWidth = $math.getDistance({x:x1, y:y1}, {x:x4, y:y4});
        //let cpx = (arcWidth) * $math.cos(cpAngle);
        //let cpy = (arcWidth) * $math.sin(cpAngle);

        var cp = {
          x: 0,
          y: 0
        };
        var path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_5__["moveTo"]({
          x: x1,
          y: y1
        });
        path += _core_rendering_Path__WEBPACK_IMPORTED_MODULE_5__["arcTo"](startAngle, arc, radius);
        path += _core_rendering_Path__WEBPACK_IMPORTED_MODULE_5__["quadraticCurveTo"]({
          x: x2,
          y: y2
        }, cp);
        path += _core_rendering_Path__WEBPACK_IMPORTED_MODULE_5__["arcTo"](endAngle, arc, radius);
        path += _core_rendering_Path__WEBPACK_IMPORTED_MODULE_5__["quadraticCurveTo"]({
          x: x1,
          y: y1
        }, cp);

        if (arc > 0) {
          this.link.path = path;
        } else {
          this.link.path = "";
        }

        if (this.maskBullets) {
          this.bulletsMask.path = path;
          this.bulletsContainer.mask = this.bulletsMask;
        }

        var mAngle1 = startAngle + arc / 2;
        var mAngle2 = endAngle + arc / 2;
        var middleLine = this.middleLine;
        middleLine.x1 = radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_4__["cos"](mAngle1) + fromX;
        middleLine.y1 = radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_4__["sin"](mAngle1) + fromY;
        middleLine.x2 = radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_4__["cos"](mAngle2) + toX;
        middleLine.y2 = radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_4__["sin"](mAngle2) + toY;
        middleLine.cpx = 0;
        middleLine.cpy = 0;
        middleLine.stroke = this.fill;
        this.positionBullets();
      }
    }
  };

  Object.defineProperty(ChordLink.prototype, "radius", {
    /**
     * @return End Y
     */
    get: function get() {
      return this.getPropertyValue("radius");
    },

    /**
     * [radius description]
     *
     * @todo Description
     * @param value End Y
     */
    set: function set(value) {
      this.setPropertyValue("radius", value, true);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ChordLink.prototype, "arc", {
    /**
     * @return [description]
     */
    get: function get() {
      return this.getPropertyValue("arc");
    },

    /**
     * [arc description]
     *
     * @todo Description
     * @param value [description]
     */
    set: function set(value) {
      this.setPropertyValue("arc", value, true);
    },
    enumerable: true,
    configurable: true
  });
  return ChordLink;
}(_FlowDiagramLink__WEBPACK_IMPORTED_MODULE_1__["FlowDiagramLink"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_2__["registry"].registeredClasses["ChordLink"] = ChordLink;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/ChordNode.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/elements/ChordNode.js ***!
  \*********************************************************************************/
/*! exports provided: ChordNode */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ChordNode", function() { return ChordNode; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _FlowDiagramNode__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./FlowDiagramNode */ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/FlowDiagramNode.js");
/* harmony import */ var _axes_AxisLabelCircular__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../axes/AxisLabelCircular */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisLabelCircular.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_elements_Slice__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/elements/Slice */ "./node_modules/@amcharts/amcharts4/.internal/core/elements/Slice.js");
/* harmony import */ var _core_utils_InterfaceColorSet__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core/utils/InterfaceColorSet */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/InterfaceColorSet.js");
/* harmony import */ var _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core/utils/Iterator */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Iterator.js");
/* harmony import */ var _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../core/utils/Math */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Math.js");
/* harmony import */ var _core_utils_Type__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../core/utils/Type */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Type.js");
/* harmony import */ var _elements_Bullet__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../elements/Bullet */ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/Bullet.js");
/**
 * ChordNode module
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */










/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Creates a node in a Chord Diagram.
 *
 * A Chord node is a block with a value, which represents its size on the
 * diagram.
 *
 * Nodes are connected via [[ChordLink]] elements.
 *
 * @see {@link IChordNodeEvents} for a list of available events
 * @see {@link IChordNodeAdapters} for a list of available Adapters
 * @important
 */

var ChordNode =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(ChordNode, _super);
  /**
   * Constructor
   */


  function ChordNode() {
    var _this = _super.call(this) || this;

    _this.className = "ChordNode";

    var label = _this.createChild(_axes_AxisLabelCircular__WEBPACK_IMPORTED_MODULE_2__["AxisLabelCircular"]);

    label.location = 0.5;
    label.radius = 5;
    label.text = "{name}";
    label.zIndex = 1;
    label.shouldClone = false;
    _this.label = label;
    _this.layout = "none";

    _this.events.on("positionchanged", _this.updateRotation, _this, false);

    _this.isMeasured = false;
    _this.slice = _this.createChild(_core_elements_Slice__WEBPACK_IMPORTED_MODULE_4__["Slice"]);
    _this.slice.isMeasured = false;
    var hiddenState = _this.hiddenState;
    hiddenState.properties.fill = new _core_utils_InterfaceColorSet__WEBPACK_IMPORTED_MODULE_5__["InterfaceColorSet"]().getFor("disabledBackground");
    hiddenState.properties.opacity = 0.5;
    hiddenState.properties.visible = true;
    _this.setStateOnChildren = false;
    _this.slice.hiddenState.properties.visible = true;

    _this.adapter.add("tooltipX", function (tooltipX, target) {
      return target.slice.ix * (target.slice.radius - (target.slice.radius - target.slice.pixelInnerRadius) / 2);
    });

    _this.adapter.add("tooltipY", function (tooltipY, target) {
      return target.slice.iy * (target.slice.radius - (target.slice.radius - target.slice.pixelInnerRadius) / 2);
    });

    return _this;
  }
  /**
   * Invalidates all links, attached to this node.
   *
   * @ignore Exclude from docs
   */


  ChordNode.prototype.invalidateLinks = function () {
    var _this = this;

    _super.prototype.invalidateLinks.call(this);

    var label = this.label;
    var slice = this.slice;
    var chart = this.chart;

    if (chart && slice) {
      var sum = this.total;
      var arc_1 = slice.arc;
      var sliceStartAngle_1 = slice.startAngle;
      this.children.each(function (child) {
        if (child instanceof _elements_Bullet__WEBPACK_IMPORTED_MODULE_9__["Bullet"]) {
          var locationX = child.locationX;

          if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_8__["isNumber"](locationX)) {
            locationX = 0.5;
          }

          var locationY = child.locationY;

          if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_8__["isNumber"](locationY)) {
            locationY = 1;
          }

          var childAngle = sliceStartAngle_1 + arc_1 * locationX;
          var childRadius = locationY * slice.radius;
          child.x = childRadius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["cos"](childAngle);
          child.y = childRadius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["sin"](childAngle);
        }
      });
      var labelAngle = sliceStartAngle_1 + arc_1 * label.location;
      var startAngle = sliceStartAngle_1 + (1 - sum / this.adjustedTotal) * arc_1 * 0.5; // if value of a node is > then sum of the links, add to center link

      if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_8__["isNaN"](startAngle)) {
        startAngle = sliceStartAngle_1;
      }

      label.fixPosition(labelAngle, slice.radius);
      this.nextAngle = startAngle;

      if (this._outgoingSorted) {
        _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_6__["each"](this._outgoingSorted, function (dataItem) {
          var link = dataItem.link;
          link.parent = _this.chart.linksContainer;
          var value = dataItem.getWorkingValue("value");

          if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_8__["isNumber"](value)) {
            if (chart.nonRibbon) {
              var percentWidth = link.percentWidth;

              if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_8__["isNumber"](percentWidth)) {
                percentWidth = 5;
              }

              percentWidth = percentWidth / 100;
              link.startAngle = sliceStartAngle_1 + arc_1 / 2 - arc_1 / 2 * percentWidth;
              link.arc = arc_1 * percentWidth;
            } else {
              link.arc = value * chart.valueAngle;
              link.startAngle = _this.nextAngle;
              _this.nextAngle += link.arc;
            }

            if (!dataItem.toNode) {
              link.endAngle = link.startAngle;
            }

            link.radius = slice.pixelInnerRadius;
          } //link.validate();

        });
      }

      if (this._incomingSorted) {
        _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_6__["each"](this._incomingSorted, function (dataItem) {
          var link = dataItem.link;
          link.radius = slice.pixelInnerRadius;

          if (chart.nonRibbon) {
            var percentWidth = link.percentWidth;

            if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_8__["isNumber"](percentWidth)) {
              percentWidth = 5;
            }

            percentWidth = percentWidth / 100;
            link.endAngle = sliceStartAngle_1 + arc_1 / 2 - arc_1 / 2 * percentWidth;
            link.arc = arc_1 * percentWidth;
          } else {
            link.endAngle = _this.nextAngle;
            var value = dataItem.getWorkingValue("value");

            if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_8__["isNumber"](value)) {
              link.arc = value * chart.valueAngle; // yes, this is needed

              _this.nextAngle += link.arc;
            }
          }

          if (!dataItem.fromNode) {
            link.startAngle = link.endAngle;
          } //link.validate();

        });
      }
    }
  };
  /**
   * @ignore
   * updates slice start angle so that when we drag a node it would face the center
   */


  ChordNode.prototype.updateRotation = function () {
    var slice = this.slice;
    var mAngle = this.trueStartAngle + slice.arc / 2;
    var radius = slice.radius;
    var tx = radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["cos"](mAngle);
    var ty = radius * _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["sin"](mAngle);
    var angle = _core_utils_Math__WEBPACK_IMPORTED_MODULE_7__["getAngle"]({
      x: tx + this.pixelX,
      y: ty + this.pixelY
    });
    slice.startAngle = this.trueStartAngle + (angle - mAngle);
    this.dx = -this.pixelX;
    this.dy = -this.pixelY;
  };
  /**
   * Copies properties and labels from another [[ChordNode]].
   *
   * @param source  Source node
   */


  ChordNode.prototype.copyFrom = function (source) {
    _super.prototype.copyFrom.call(this, source);

    this.label.copyFrom(source.label);
    this.slice.copyFrom(source.slice);
  };

  return ChordNode;
}(_FlowDiagramNode__WEBPACK_IMPORTED_MODULE_1__["FlowDiagramNode"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_3__["registry"].registeredClasses["ChordNode"] = ChordNode;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/CircleBullet.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/elements/CircleBullet.js ***!
  \************************************************************************************/
/*! exports provided: CircleBullet */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CircleBullet", function() { return CircleBullet; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Bullet__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Bullet */ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/Bullet.js");
/* harmony import */ var _core_elements_Circle__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/elements/Circle */ "./node_modules/@amcharts/amcharts4/.internal/core/elements/Circle.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/**
 * Bullet module
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */




/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Creates a bullet with a textual label.
 *
 * Uses [[Label]] instance to draw the label, so the label itself is
 * configurable.
 *
 * @see {@link IBulletEvents} for a list of available events
 * @see {@link IBulletAdapters} for a list of available Adapters
 * @todo Usage example
 * @important
 */

var CircleBullet =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(CircleBullet, _super);
  /**
   * Constructor
   */


  function CircleBullet() {
    var _this = _super.call(this) || this;

    _this.className = "CircleBullet";

    var circle = _this.createChild(_core_elements_Circle__WEBPACK_IMPORTED_MODULE_2__["Circle"]);

    circle.shouldClone = false;
    circle.radius = 5;
    circle.isMeasured = false;
    _this.circle = circle;

    _this.applyTheme();

    return _this;
  }
  /**
   * Copies all proprities and related stuff from another instance of
   * [[CircleBullet]].
   *
   * @param source  Source element
   */


  CircleBullet.prototype.copyFrom = function (source) {
    _super.prototype.copyFrom.call(this, source);

    this.circle.copyFrom(source.circle);
  };

  return CircleBullet;
}(_Bullet__WEBPACK_IMPORTED_MODULE_1__["Bullet"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_3__["registry"].registeredClasses["CircleBullet"] = CircleBullet;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/ClockHand.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/elements/ClockHand.js ***!
  \*********************************************************************************/
/*! exports provided: ClockHand */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ClockHand", function() { return ClockHand; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _core_Container__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core/Container */ "./node_modules/@amcharts/amcharts4/.internal/core/Container.js");
/* harmony import */ var _core_elements_Circle__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/elements/Circle */ "./node_modules/@amcharts/amcharts4/.internal/core/elements/Circle.js");
/* harmony import */ var _core_elements_Trapezoid__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/elements/Trapezoid */ "./node_modules/@amcharts/amcharts4/.internal/core/elements/Trapezoid.js");
/* harmony import */ var _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/utils/Disposer */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Disposer.js");
/* harmony import */ var _core_utils_Percent__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core/utils/Percent */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Percent.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_utils_InterfaceColorSet__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../core/utils/InterfaceColorSet */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/InterfaceColorSet.js");
/* harmony import */ var _core_utils_Utils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../core/utils/Utils */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Utils.js");
/* harmony import */ var _core_utils_Type__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../core/utils/Type */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Type.js");
/**
 * Functionality for drawing simple ClockHands
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */










/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * ClockHand class is capable of drawing a simple pointy shape with optionally
 * rounderd corners and an icon.
 *
 * @see {@link IClockHandEvents} for a list of available events
 * @see {@link IClockHandAdapters} for a list of available Adapters
 * @todo Improve
 * @important
 */

var ClockHand =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(ClockHand, _super);
  /**
   * Constructor
   */


  function ClockHand() {
    var _this = // Init
    _super.call(this) || this;
    /**
     * An Axis hand is related to.
     */


    _this._axis = new _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_4__["MutableValueDisposer"]();
    _this.className = "ClockHand";
    var interfaceColors = new _core_utils_InterfaceColorSet__WEBPACK_IMPORTED_MODULE_7__["InterfaceColorSet"]();
    _this.fill = interfaceColors.getFor("alternativeBackground");
    _this.stroke = _this.fill;
    var pin = new _core_elements_Circle__WEBPACK_IMPORTED_MODULE_2__["Circle"]();
    pin.radius = 5;
    _this.pin = pin;
    _this.isMeasured = false;
    _this.startWidth = 5;
    _this.endWidth = 1;
    _this.width = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_5__["percent"])(100);
    _this.height = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_5__["percent"])(100);
    _this.radius = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_5__["percent"])(100);
    _this.innerRadius = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_5__["percent"])(0);
    var hand = new _core_elements_Trapezoid__WEBPACK_IMPORTED_MODULE_3__["Trapezoid"]();
    _this.hand = hand;

    _this._disposers.push(_this._axis); // Apply theme


    _this.applyTheme();

    return _this;
  }
  /**
   * Re(validates) the clock hand, effectively redrawing it.
   *
   * @ignore Exclude from docs
   */


  ClockHand.prototype.validate = function () {
    _super.prototype.validate.call(this);

    var hand = this.hand;
    hand.width = this.pixelWidth;
    var h = Math.max(this.startWidth, this.endWidth);
    hand.height = h;
    hand.leftSide = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_5__["percent"])(this.startWidth / h * 100);
    hand.rightSide = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_5__["percent"])(this.endWidth / h * 100);

    if (this.axis) {
      var renderer = this.axis.renderer;
      var x0 = _core_utils_Utils__WEBPACK_IMPORTED_MODULE_8__["relativeRadiusToValue"](this.innerRadius, renderer.pixelRadius);
      var x1 = _core_utils_Utils__WEBPACK_IMPORTED_MODULE_8__["relativeRadiusToValue"](this.radius, renderer.pixelRadius);
      hand.x = x0;
      hand.y = -h / 2;
      hand.width = x1 - x0;
    }
  };

  Object.defineProperty(ClockHand.prototype, "pin", {
    /**
     * @return Pin element
     */
    get: function get() {
      return this._pin;
    },

    /**
     * A circle element used as hand's base. (pin)
     *
     * @param pin  Pin element
     */
    set: function set(pin) {
      if (this._pin) {
        this.removeDispose(this._pin);
      }

      if (pin) {
        this._pin = pin;
        pin.parent = this;

        this._disposers.push(pin);
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ClockHand.prototype, "hand", {
    /**
     * @return Hand element
     */
    get: function get() {
      return this._hand;
    },

    /**
     * A trapezoid shape used for hand itself.
     *
     * The shape of the trapezoid is controlled by ClockHand's `startWidth` and
     * `endWidth` properties.
     *
     * Set `endWidth` to 1 (px) to make it pointy.
     *
     * @param hand  Hand element
     */
    set: function set(hand) {
      if (this._hand) {
        this.removeDispose(this._hand);
      }

      if (hand) {
        this._hand = hand;
        hand.parent = this;

        this._disposers.push(hand);
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ClockHand.prototype, "radius", {
    /**
     * @return Radius
     */
    get: function get() {
      return this.getPropertyValue("radius");
    },

    /**
     * Radius of the hand's outer end. (tip)
     *
     * Absolute (px) or relative ([[Percent]]).
     *
     * @default Percent(0)
     * @param value  Radius
     */
    set: function set(value) {
      this.setPercentProperty("radius", value, true, false, 10, false);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ClockHand.prototype, "innerRadius", {
    /**
     * @return Radius
     */
    get: function get() {
      return this.getPropertyValue("innerRadius");
    },

    /**
     * Radius of the hand's inner end. (base)
     *
     * Absolute (px) or relative ([[Percent]]).
     *
     * @default Percent(0)
     * @param value  Radius
     */
    set: function set(value) {
      this.setPercentProperty("innerRadius", value, true, false, 10, false);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ClockHand.prototype, "startWidth", {
    /**
     * @return Width (px)
     */
    get: function get() {
      return this.getPropertyValue("startWidth");
    },

    /**
     * Width, in pixels, of the clock hand's inner end. (base)
     *
     * @default 5
     * @param value  Width (px)
     */
    set: function set(value) {
      this.setPropertyValue("startWidth", value, true);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ClockHand.prototype, "endWidth", {
    /**
     * @return Width (px)
     */
    get: function get() {
      return this.getPropertyValue("endWidth");
    },

    /**
     * Width, in pixels, of the clock hand's outer end. (tip)
     *
     * @default 1
     * @param value  Width (px)
     */
    set: function set(value) {
      this.setPropertyValue("endWidth", value, true);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ClockHand.prototype, "rotationDirection", {
    /**
     * @return rotationDirection
     */
    get: function get() {
      return this.getPropertyValue("rotationDirection");
    },

    /**
     * Rotation direction
     *
     * @default any
     * @param value
     */
    set: function set(value) {
      this.setPropertyValue("rotationDirection", value);
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Moves clock hand to particular value.
   *
   * If `duration` is set to a number in milliseconds, the hand will move
   * to the new position gracefully, rather than jumping rigth to it.
   *
   * Alternatively, you can also set `value` directly.
   *
   * @param value     New value
   * @param duration  Animation duration (ms)
   * @param easing  Animation easing function
   */

  ClockHand.prototype.showValue = function (value, duration, easing) {
    this._value = value;

    if (value != undefined) {
      if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isNumber"](duration)) {
        duration = 0;
      }

      if (this.axis) {
        var renderer = this.axis.renderer;
        var newAngle = renderer.positionToAngle(this.axis.anyToPosition(value));
        var currentAngle = this.rotation;

        if (this.rotationDirection == "clockWise") {
          if (newAngle < currentAngle) {
            this.rotation = currentAngle - 360;
          }
        }

        if (this.rotationDirection == "counterClockWise") {
          if (newAngle > currentAngle) {
            this.rotation = currentAngle + 360;
          }
        }

        this.animate({
          property: "rotation",
          to: newAngle
        }, duration, easing);
      }
    }
  };

  Object.defineProperty(ClockHand.prototype, "currentPosition", {
    /**
     * Returns hand's relative position on axis
     */
    get: function get() {
      if (this.axis) {
        var renderer = this.axis.renderer;
        return renderer.angleToPosition(this.rotation);
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ClockHand.prototype, "value", {
    /**
     * @return Value
     */
    get: function get() {
      return this._value;
    },

    /**
     * A current value clock hand is pointing to.
     *
     * @param value  Value
     */
    set: function set(value) {
      this.showValue(value);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ClockHand.prototype, "axis", {
    /**
     * @return Axis
     */
    get: function get() {
      return this._axis.get();
    },

    /**
     * An Axis clock hand is associated with.
     *
     * Hand's `value` relates to values on the Axis.
     *
     * @param axis  Axis
     */
    set: function set(axis) {
      if (this.axis != axis) {
        this._axis.set(axis, new _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_4__["MultiDisposer"]([axis.events.on("datavalidated", this.updateValue, this, false), axis.events.on("datarangechanged", this.updateValue, this, false), axis.events.on("dataitemsvalidated", this.updateValue, this, false), axis.events.on("propertychanged", this.invalidate, this, false)]));
      }

      if (axis) {
        var chart = axis.chart;

        if (chart) {
          this.rotation = chart.startAngle;
        }
      }

      this.parent = axis.renderer;
      this.zIndex = 5;
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Triggers `value` accessor, so that Hand animates to new position, in case
   * value has changed.
   *
   * @ignore Exclude from docs
   */

  ClockHand.prototype.updateValue = function () {
    this.value = this.value;
  };
  /**
  * Processes JSON-based config before it is applied to the object.
  *
  * @ignore Exclude from docs
  * @param config  Config
  */


  ClockHand.prototype.processConfig = function (config) {
    if (config) {
      // Connect clock hands with axes
      if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["hasValue"](config.axis) && _core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["isString"](config.axis) && this.map.hasKey(config.axis)) {
        config.axis = this.map.getKey(config.axis);
      }
    }

    _super.prototype.processConfig.call(this, config);
  };

  return ClockHand;
}(_core_Container__WEBPACK_IMPORTED_MODULE_1__["Container"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_6__["registry"].registeredClasses["ClockHand"] = ClockHand;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/Column.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/elements/Column.js ***!
  \******************************************************************************/
/*! exports provided: Column */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Column", function() { return Column; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _core_Container__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core/Container */ "./node_modules/@amcharts/amcharts4/.internal/core/Container.js");
/* harmony import */ var _core_elements_RoundedRectangle__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/elements/RoundedRectangle */ "./node_modules/@amcharts/amcharts4/.internal/core/elements/RoundedRectangle.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_utils_Percent__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/utils/Percent */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Percent.js");
/* harmony import */ var _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core/utils/Math */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Math.js");
/**
 * Module that defines everything related to building Columns.
 * It is a container which has column element which is a RoundedRectangle.
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */






/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Class used to creates Columns.
 *
 * @see {@link IColumnEvents} for a list of available events
 * @see {@link IColumnAdapters} for a list of available Adapters
 * @todo Usage example
 * @important
 */

var Column =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(Column, _super);
  /**
   * Constructor
   */


  function Column() {
    var _this = _super.call(this) || this;

    _this.className = "Column";
    _this.width = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_4__["percent"])(80);
    _this.height = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_4__["percent"])(80); //this.isMeasured = true; // for correct position of the tooltip

    _this.events.disableType("transformed"); // not to bug parent


    _this.applyOnClones = true;
    _this.strokeOpacity = 1;
    _this.layout = "none";

    _this.createAssets(); // otherwise users will have to set layout themselves if they'll want to align, scale etc children


    _this.events.on("childadded", _this.handleKidAdded, _this, false);

    return _this;
  }
  /**
   * @ignore
   */


  Column.prototype.handleKidAdded = function () {
    if (this.layout == "none") {
      this.layout = "absolute";
    }
  };
  /**
   * @ignore
   */


  Column.prototype.createAssets = function () {
    this.column = this.createChild(_core_elements_RoundedRectangle__WEBPACK_IMPORTED_MODULE_2__["RoundedRectangle"]);
    this.column.shouldClone = false;
    this.column.isMeasured = false;
    this.column.cornerRadius(0, 0, 0, 0);

    this._disposers.push(this.column);
  };
  /**
   * @ignore Exclude from docs
   */


  Column.prototype.validate = function () {
    _super.prototype.validate.call(this);

    var column = this.column;

    if (column) {
      column.width = _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["min"](this.pixelWidth, this.maxWidth);
      column.height = _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["min"](this.pixelHeight, this.maxHeight);

      if (column.invalid) {
        column.validate(); // important!
      }
    }
  };
  /**
   * Copies all parameters from another [[Column]].
   *
   * @param source Source Column
   */


  Column.prototype.copyFrom = function (source) {
    _super.prototype.copyFrom.call(this, source);

    if (this.column) {
      this.column.copyFrom(source.column);
    }
  };

  Object.defineProperty(Column.prototype, "bbox", {
    /**
     * Returns bounding box (square) for this element.
     *
     * @ignore Exclude from docs
     */
    get: function get() {
      if (this.definedBBox) {
        return this.definedBBox;
      }

      if (this.column) {
        return {
          x: 0,
          y: 0,
          width: this.column.measuredWidth,
          height: this.column.measuredHeight
        };
      } else {
        return {
          x: 0,
          y: 0,
          width: _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["min"](this.pixelWidth, this.maxWidth),
          height: _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["min"](this.pixelHeight, this.maxHeight)
        };
      }
    },
    enumerable: true,
    configurable: true
  });
  return Column;
}(_core_Container__WEBPACK_IMPORTED_MODULE_1__["Container"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_3__["registry"].registeredClasses["Column"] = Column;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/Column3D.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/elements/Column3D.js ***!
  \********************************************************************************/
/*! exports provided: Column3D */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Column3D", function() { return Column3D; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Column__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Column */ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/Column.js");
/* harmony import */ var _core_elements_3d_Rectangle3D__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/elements/3d/Rectangle3D */ "./node_modules/@amcharts/amcharts4/.internal/core/elements/3d/Rectangle3D.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/**
 * Module that defines everything related to building 3D Columns.
 * It is a container which has column3D element which is a Rectangle3D.
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */




/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Class used to creates Column3Ds.
 *
 * @see {@link IColumn3DEvents} for a list of available events
 * @see {@link IColumn3DAdapters} for a list of available Adapters
 * @todo Usage example
 * @important
 */

var Column3D =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(Column3D, _super);
  /**
   * Constructor
   */


  function Column3D() {
    var _this = _super.call(this) || this;

    _this.className = "Column3D";
    return _this;
  }
  /**
   * @ignore
   */


  Column3D.prototype.createAssets = function () {
    this.column3D = this.createChild(_core_elements_3d_Rectangle3D__WEBPACK_IMPORTED_MODULE_2__["Rectangle3D"]);
    this.column3D.shouldClone = false;
    this.column3D.strokeOpacity = 0; // some dirty hack so that if user access column, it won't get error

    this.column = this.column3D;
  };
  /**
   * @ignore Exclude from docs
   */


  Column3D.prototype.validate = function () {
    _super.prototype.validate.call(this);

    if (this.column3D) {
      this.column3D.width = this.pixelWidth;
      this.column3D.height = this.pixelHeight;

      if (this.column3D.invalid) {
        this.column3D.validate();
      }
    }
  };
  /**
   * Copies all parameters from another [[Column3D]].
   *
   * @param source Source Column3D
   */


  Column3D.prototype.copyFrom = function (source) {
    _super.prototype.copyFrom.call(this, source);

    if (this.column3D) {
      this.column3D.copyFrom(source.column3D);
    }
  };
  /**
   * Sets actual `fill` property on the SVG element, including applicable color
   * modifiers.
   *
   * @ignore Exclude from docs
   * @param value  Fill
   */


  Column3D.prototype.setFill = function (value) {
    _super.prototype.setFill.call(this, value);

    this.column.fill = value;
  };

  return Column3D;
}(_Column__WEBPACK_IMPORTED_MODULE_1__["Column"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_3__["registry"].registeredClasses["Column3D"] = Column3D;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/ConeColumn.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/elements/ConeColumn.js ***!
  \**********************************************************************************/
/*! exports provided: ConeColumn */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ConeColumn", function() { return ConeColumn; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Column__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Column */ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/Column.js");
/* harmony import */ var _core_elements_3d_Cone__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/elements/3d/Cone */ "./node_modules/@amcharts/amcharts4/.internal/core/elements/3d/Cone.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/**
 * Module that defines everything related to building Cone Columns.
 * It is a container which has coneColumn element which is a Cone.
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */




/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Class used to creates ConeColumns.
 *
 * @see {@link IConeColumnEvents} for a list of available events
 * @see {@link IConeColumnAdapters} for a list of available Adapters
 * @todo Usage example
 * @important
 */

var ConeColumn =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(ConeColumn, _super);
  /**
   * Constructor
   */


  function ConeColumn() {
    var _this = _super.call(this) || this;

    _this.className = "ConeColumn";
    return _this;
  }
  /**
   * @ignore
   */


  ConeColumn.prototype.createAssets = function () {
    this.coneColumn = this.createChild(_core_elements_3d_Cone__WEBPACK_IMPORTED_MODULE_2__["Cone"]);
    this.coneColumn.shouldClone = false; // some dirty hack so that if user access column, it won't get error

    this.column = this.coneColumn;
  };
  /**
   * Copies all parameters from another [[ConeColumn]].
   *
   * @param source Source ConeColumn
   */


  ConeColumn.prototype.copyFrom = function (source) {
    _super.prototype.copyFrom.call(this, source);

    if (this.coneColumn) {
      this.coneColumn.copyFrom(source.coneColumn);
    }
  };

  return ConeColumn;
}(_Column__WEBPACK_IMPORTED_MODULE_1__["Column"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_3__["registry"].registeredClasses["ConeColumn"] = ConeColumn;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/CurvedColumn.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/elements/CurvedColumn.js ***!
  \************************************************************************************/
/*! exports provided: CurvedColumn */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CurvedColumn", function() { return CurvedColumn; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Column__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Column */ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/Column.js");
/* harmony import */ var _core_Sprite__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/Sprite */ "./node_modules/@amcharts/amcharts4/.internal/core/Sprite.js");
/* harmony import */ var _core_rendering_Path__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/rendering/Path */ "./node_modules/@amcharts/amcharts4/.internal/core/rendering/Path.js");
/* harmony import */ var _core_utils_Utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/utils/Utils */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Utils.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_rendering_Smoothing__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core/rendering/Smoothing */ "./node_modules/@amcharts/amcharts4/.internal/core/rendering/Smoothing.js");
/* harmony import */ var _core_utils_Percent__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../core/utils/Percent */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Percent.js");
/**
 * Module that defines everything related to building Curved Columns.
 * It is a container which has CurvedColumn element which is a Sprite.
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */








/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Class used to creates CurvedColumns.
 *
 * @see {@link ICurvedColumnEvents} for a list of available events
 * @see {@link ICurvedColumnAdapters} for a list of available Adapters
 * @important
 */

var CurvedColumn =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(CurvedColumn, _super);
  /**
   * Constructor
   */


  function CurvedColumn() {
    var _this = _super.call(this) || this;

    _this.className = "CurvedColumn";
    return _this;
  }
  /**
   * [createAssets description]
   *
   * @todo Description
   * @ignore Exclude from docs
   */


  CurvedColumn.prototype.createAssets = function () {
    this.curvedColumn = this.createChild(_core_Sprite__WEBPACK_IMPORTED_MODULE_2__["Sprite"]);
    this.curvedColumn.shouldClone = false;
    this.setPropertyValue("tension", 0.7);
    this.width = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_7__["percent"])(120);
    this.height = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_7__["percent"])(120); // some dirty hack so that if user access column, it won't get error

    this.column = this.curvedColumn;
  };
  /**
   * Draws the element.
   *
   * @ignore Exclude from docs
   */


  CurvedColumn.prototype.draw = function () {
    _super.prototype.draw.call(this);

    var w = this.realWidth;
    var h = this.realHeight;
    var x = this.realX - this.pixelX;
    var y = this.realY - this.pixelY;
    var points; // TODO can this be removed ?

    _core_utils_Utils__WEBPACK_IMPORTED_MODULE_4__["used"](this.width);
    var tensionX = 1;
    var tensionY = 1;

    if (this.orientation == "vertical") {
      tensionX = this.tension;
      points = [{
        x: 0,
        y: h + y
      }, {
        x: w / 2,
        y: y
      }, {
        x: w,
        y: h + y
      }];
    } else {
      tensionY = this.tension;
      h = Math.abs(h);
      points = [{
        x: x,
        y: h
      }, {
        x: x + w,
        y: h / 2
      }, {
        x: x,
        y: 0
      }];
    }

    var path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_3__["moveTo"](points[0]) + new _core_rendering_Smoothing__WEBPACK_IMPORTED_MODULE_6__["Tension"](tensionX, tensionY).smooth(points);
    this.column.path = path;
  };
  /**
   * Copies all parameters from another [[CurvedColumn]].
   *
   * @param source  Source CurvedColumn
   */


  CurvedColumn.prototype.copyFrom = function (source) {
    _super.prototype.copyFrom.call(this, source);

    if (this.curvedColumn) {
      this.curvedColumn.copyFrom(source.curvedColumn);
    }
  };

  Object.defineProperty(CurvedColumn.prototype, "tension", {
    /**
     * @return Tension (0-1)
     */
    get: function get() {
      return this.getPropertyValue("tension");
    },

    /**
     * Horizontal tension of the curve.
     *
     * Tension defines how "lose" the line will be.
     *
     * 1 is the maximum tension which would result in pointy columns with
     * straight edges.
     *
     * The smaller the tension th wider the column will be.
     *
     * @default 0.7
     * @param value tension (0-1)
     */
    set: function set(value) {
      this.setPropertyValue("tension", value, true);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(CurvedColumn.prototype, "orientation", {
    /**
     * Orientation
     */
    get: function get() {
      return this.getPropertyValue("orientation");
    },

    /**
     * Orientation of the column.
     *
     * Available options: "vertical" (default) and "horizontal".
     *
     * @default "vertical"
     * @param value  Orientation
     */
    set: function set(value) {
      this.setPropertyValue("orientation", value, true);
    },
    enumerable: true,
    configurable: true
  });
  return CurvedColumn;
}(_Column__WEBPACK_IMPORTED_MODULE_1__["Column"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_5__["registry"].registeredClasses["CurvedColumn"] = CurvedColumn;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/ErrorBullet.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/elements/ErrorBullet.js ***!
  \***********************************************************************************/
/*! exports provided: ErrorBullet */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ErrorBullet", function() { return ErrorBullet; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Bullet__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Bullet */ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/Bullet.js");
/* harmony import */ var _core_Sprite__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/Sprite */ "./node_modules/@amcharts/amcharts4/.internal/core/Sprite.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/rendering/Path */ "./node_modules/@amcharts/amcharts4/.internal/core/rendering/Path.js");
/**
 * Bullet module
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */





/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Creates a bullet with a textual label.
 *
 * Uses [[Label]] instance to draw the label, so the label itself is
 * configurable.
 *
 * @see {@link IBulletEvents} for a list of available events
 * @see {@link IBulletAdapters} for a list of available Adapters
 * @todo Usage example
 * @important
 */

var ErrorBullet =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(ErrorBullet, _super);
  /**
   * Constructor
   */


  function ErrorBullet() {
    var _this = _super.call(this) || this;

    _this.className = "ErrorBullet";
    _this.errorLine = _this.createChild(_core_Sprite__WEBPACK_IMPORTED_MODULE_2__["Sprite"]);
    _this.errorLine.shouldClone = false;
    _this.width = 20;
    _this.height = 20;
    _this.strokeOpacity = 1;
    _this.isDynamic = true;
    return _this;
  }

  ErrorBullet.prototype.validatePosition = function () {
    _super.prototype.validatePosition.call(this);

    var w = this.pixelWidth / 2;
    var h = this.pixelHeight / 2;
    this.errorLine.path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["moveTo"]({
      x: -w,
      y: -h
    }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["lineTo"]({
      x: w,
      y: -h
    }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["moveTo"]({
      x: 0,
      y: -h
    }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["lineTo"]({
      x: 0,
      y: h
    }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["moveTo"]({
      x: -w,
      y: h
    }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["lineTo"]({
      x: w,
      y: h
    });
  };
  /**
   * Copies all proprities and related stuff from another instance of
   * [[ErrorBullet]].
   *
   * @param source  Source element
   */


  ErrorBullet.prototype.copyFrom = function (source) {
    _super.prototype.copyFrom.call(this, source);

    this.errorLine.copyFrom(source.errorLine);
  };

  return ErrorBullet;
}(_Bullet__WEBPACK_IMPORTED_MODULE_1__["Bullet"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_3__["registry"].registeredClasses["ErrorBullet"] = ErrorBullet;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/FlowDiagramLink.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/elements/FlowDiagramLink.js ***!
  \***************************************************************************************/
/*! exports provided: FlowDiagramLink */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FlowDiagramLink", function() { return FlowDiagramLink; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _core_Sprite__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core/Sprite */ "./node_modules/@amcharts/amcharts4/.internal/core/Sprite.js");
/* harmony import */ var _core_Container__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/Container */ "./node_modules/@amcharts/amcharts4/.internal/core/Container.js");
/* harmony import */ var _core_rendering_fills_LinearGradient__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/rendering/fills/LinearGradient */ "./node_modules/@amcharts/amcharts4/.internal/core/rendering/fills/LinearGradient.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _elements_Bullet__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../elements/Bullet */ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/Bullet.js");
/* harmony import */ var _core_utils_Color__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core/utils/Color */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Color.js");
/* harmony import */ var _core_utils_List__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../core/utils/List */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/List.js");
/* harmony import */ var _core_elements_Polyline__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../core/elements/Polyline */ "./node_modules/@amcharts/amcharts4/.internal/core/elements/Polyline.js");
/* harmony import */ var _core_elements_Line__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../core/elements/Line */ "./node_modules/@amcharts/amcharts4/.internal/core/elements/Line.js");
/* harmony import */ var _core_utils_InterfaceColorSet__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../core/utils/InterfaceColorSet */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/InterfaceColorSet.js");
/* harmony import */ var _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../core/utils/Iterator */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Iterator.js");
/* harmony import */ var _core_utils_Type__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../core/utils/Type */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Type.js");
/**
 * FlowDiagramLink module
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */













/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * This class creates a link (waved color-filled line) between two nodes in a
 * Flow Diagram.
 *
 * @see {@link IFlowDiagramLinkEvents} for a list of available events
 * @see {@link IFlowDiagramLinkAdapters} for a list of available Adapters
 * @important
 */

var FlowDiagramLink =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(FlowDiagramLink, _super);
  /**
   * Constructor
   */


  function FlowDiagramLink() {
    var _this = _super.call(this) || this;

    _this.className = "FlowDiagramLink";
    var interfaceColors = new _core_utils_InterfaceColorSet__WEBPACK_IMPORTED_MODULE_10__["InterfaceColorSet"]();
    _this.maskBullets = false;
    _this.colorMode = "fromNode";
    _this.layout = "none";
    _this.isMeasured = false;
    _this.startAngle = 0;
    _this.endAngle = 0;
    _this.strokeOpacity = 0; // this is very important, otherwise the container will be shifted

    _this.verticalCenter = "none";
    _this.horizontalCenter = "none";
    _this.tooltipText = "{fromName}→{toName}:{value.value}";
    _this.tooltipLocation = 0.5;
    _this.link = _this.createChild(_core_Sprite__WEBPACK_IMPORTED_MODULE_1__["Sprite"]);
    _this.link.shouldClone = false;

    _this.link.setElement(_this.paper.add("path"));

    _this.link.isMeasured = false;
    _this.fillOpacity = 0.2;
    _this.fill = interfaceColors.getFor("alternativeBackground");

    _this.applyTheme();

    return _this;
  }
  /**
   * Positions bullets
   * @ignore
   */


  FlowDiagramLink.prototype.positionBullets = function () {
    var _this = this;

    _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_11__["each"](this.bullets.iterator(), function (bullet) {
      bullet.parent = _this.bulletsContainer;
      bullet.maxWidth = _this.maxWidth;
      bullet.maxHeight = _this.maxHeight;

      _this.positionBullet(bullet);
    });
  };

  Object.defineProperty(FlowDiagramLink.prototype, "bulletsContainer", {
    /**
     * Bullets container
     */
    get: function get() {
      if (!this._bulletsContainer) {
        var bulletsContainer = this.createChild(_core_Container__WEBPACK_IMPORTED_MODULE_2__["Container"]);
        bulletsContainer.shouldClone = false;
        bulletsContainer.layout = "none";
        this._bulletsContainer = bulletsContainer;
      }

      return this._bulletsContainer;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(FlowDiagramLink.prototype, "bulletsMask", {
    /**
     * Bullets mask sprite
     */
    get: function get() {
      if (!this._bulletsMask) {
        var bulletsMask = this.createChild(_core_Sprite__WEBPACK_IMPORTED_MODULE_1__["Sprite"]);
        bulletsMask.shouldClone = false;
        bulletsMask.setElement(this.paper.add("path"));
        bulletsMask.isMeasured = false;
        this._bulletsMask = bulletsMask;
      }

      return this._bulletsMask;
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Positions bullets at relative bullet.locationX position on the link.
   * @ignore
   */

  FlowDiagramLink.prototype.positionBullet = function (bullet) {
    var location = bullet.locationX;

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_12__["isNumber"](location)) {
      location = bullet.locationY;
    }

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_12__["isNumber"](location)) {
      location = 0.5;
    }

    var point = this.middleLine.positionToPoint(location);
    bullet.moveTo(point);
    var rotationField = bullet.propertyFields.rotation;
    var angle;

    if (bullet.dataItem) {
      var dataContext = bullet.dataItem.dataContext;
      angle = dataContext[rotationField];
    }

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_12__["isNumber"](angle)) {
      angle = point.angle;
    }

    bullet.rotation = angle;
  };

  Object.defineProperty(FlowDiagramLink.prototype, "startAngle", {
    /**
     * @return Start angle
     */
    get: function get() {
      return this.getPropertyValue("startAngle");
    },

    /**
     * [startAngle description]
     *
     * @todo Description
     * @param value  Start angle
     */
    set: function set(value) {
      this.setPropertyValue("startAngle", value, true);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(FlowDiagramLink.prototype, "endAngle", {
    /**
     * @return End angle
     */
    get: function get() {
      return this.getPropertyValue("endAngle");
    },

    /**
     * [endAngle description]
     *
     * @todo Description
     * @param value  End angle
     */
    set: function set(value) {
      this.setPropertyValue("endAngle", value, true);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(FlowDiagramLink.prototype, "colorMode", {
    /**
     * Fill mode
     */
    get: function get() {
      return this.getPropertyValue("colorMode");
    },

    /**
     * Should link be filled with a solid color, color of from node, color of toNode or gradient between node colors.
     * Some of the links, like ChordLink does not support gradiens well.
     *
     * @param value  Fill mode
     */
    set: function set(value) {
      if (value == "gradient") {
        var color = this.fill;
        this.gradient.stops.clear();

        if (color instanceof _core_utils_Color__WEBPACK_IMPORTED_MODULE_6__["Color"]) {
          this.gradient.addColor(color);
          this.gradient.addColor(color);
        }

        this.fill = this.gradient;
        this.stroke = this.gradient;
      }

      this.setPropertyValue("colorMode", value, true);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(FlowDiagramLink.prototype, "maskBullets", {
    /**
     * @return mask bullets value
     */
    get: function get() {
      return this.getPropertyValue("maskBullets");
    },

    /**
     * Should link bullets be masked or not
     *
     * @param value
     * @default false
     */
    set: function set(value) {
      this.setPropertyValue("maskBullets", value, true);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(FlowDiagramLink.prototype, "tooltipLocation", {
    /**
     * Tooltip location value
     */
    get: function get() {
      return this.getPropertyValue("tooltipLocation");
    },

    /**
     * Relative location of a tooltip.
     * @default 0.5
     *
     * @param value
     */
    set: function set(value) {
      this.setPropertyValue("tooltipLocation", value, true);
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Adds color steps in the link gradient.
   *
   * @param value  Fill option
   */

  FlowDiagramLink.prototype.setFill = function (value) {
    _super.prototype.setFill.call(this, value);

    var gradient = this._gradient;

    if (gradient && value instanceof _core_utils_Color__WEBPACK_IMPORTED_MODULE_6__["Color"]) {
      gradient.stops.clear();
      gradient.addColor(value);
      gradient.addColor(value);
    }
  };
  /**
   * Updates bounding box based on element dimension settings.
   *
   * @ignore Exclude from docs
   */


  FlowDiagramLink.prototype.measureElement = function () {};

  Object.defineProperty(FlowDiagramLink.prototype, "bullets", {
    /**
     * List of bullets
     *
     * @return [description]
     */
    get: function get() {
      var _this = this;

      if (!this._bullets) {
        this._bullets = new _core_utils_List__WEBPACK_IMPORTED_MODULE_7__["ListTemplate"](new _elements_Bullet__WEBPACK_IMPORTED_MODULE_5__["Bullet"]());

        this._disposers.push(new _core_utils_List__WEBPACK_IMPORTED_MODULE_7__["ListDisposer"](this._bullets));

        this._disposers.push(this._bullets.template);

        this._bullets.events.on("inserted", function (event) {
          event.newValue.events.on("propertychanged", function (event) {
            if (event.property == "locationX" || event.property == "locationY") {
              _this.positionBullet(event.target);
            }
          }, undefined, false);
        }, undefined, false);
      }

      return this._bullets;
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Copies properties from another [[FlowDiagramLink]].
   *
   * @param source  Source link
   */

  FlowDiagramLink.prototype.copyFrom = function (source) {
    _super.prototype.copyFrom.call(this, source);

    this.bullets.copyFrom(source.bullets);
    var middleLine = this.middleLine;

    if (middleLine) {
      if (middleLine instanceof _core_elements_Line__WEBPACK_IMPORTED_MODULE_9__["Line"] && source.middleLine instanceof _core_elements_Line__WEBPACK_IMPORTED_MODULE_9__["Line"]) {
        middleLine.copyFrom(source.middleLine);
      }

      if (middleLine instanceof _core_elements_Polyline__WEBPACK_IMPORTED_MODULE_8__["Polyline"] && source.middleLine instanceof _core_elements_Polyline__WEBPACK_IMPORTED_MODULE_8__["Polyline"]) {
        middleLine.copyFrom(source.middleLine);
      }
    }

    this.link.copyFrom(source.link);
  };
  /**
   * @ignore Exclude from docs
   * @return Tooltip X (px)
   */


  FlowDiagramLink.prototype.getTooltipX = function () {
    if (this.middleLine) {
      return this.middleLine.positionToPoint(this.tooltipLocation).x;
    }
  };
  /**
   * @ignore Exclude from docs
   * @return Tooltip Y (px)
   */


  FlowDiagramLink.prototype.getTooltipY = function () {
    if (this.middleLine) {
      return this.middleLine.positionToPoint(this.tooltipLocation).y;
    }
  };

  Object.defineProperty(FlowDiagramLink.prototype, "gradient", {
    /**
     * A gradiend instance that is used to provided colored gradient fills for
     * the Flow link.
     */
    get: function get() {
      if (!this._gradient) {
        this._gradient = new _core_rendering_fills_LinearGradient__WEBPACK_IMPORTED_MODULE_3__["LinearGradient"]();
      }

      return this._gradient;
    },
    enumerable: true,
    configurable: true
  });
  return FlowDiagramLink;
}(_core_Container__WEBPACK_IMPORTED_MODULE_2__["Container"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_4__["registry"].registeredClasses["FlowDiagramLink"] = FlowDiagramLink;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/FlowDiagramNode.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/elements/FlowDiagramNode.js ***!
  \***************************************************************************************/
/*! exports provided: FlowDiagramNode */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FlowDiagramNode", function() { return FlowDiagramNode; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _core_Container__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core/Container */ "./node_modules/@amcharts/amcharts4/.internal/core/Container.js");
/* harmony import */ var _core_Sprite__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/Sprite */ "./node_modules/@amcharts/amcharts4/.internal/core/Sprite.js");
/* harmony import */ var _core_utils_List__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/utils/List */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/List.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_utils_InterfaceColorSet__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core/utils/InterfaceColorSet */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/InterfaceColorSet.js");
/* harmony import */ var _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core/utils/Iterator */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Iterator.js");
/* harmony import */ var _core_utils_String__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../core/utils/String */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/String.js");
/* harmony import */ var _core_utils_Order__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../core/utils/Order */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Order.js");
/* harmony import */ var _core_utils_Number__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../core/utils/Number */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Number.js");
/* harmony import */ var _core_elements_RoundedRectangle__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../core/elements/RoundedRectangle */ "./node_modules/@amcharts/amcharts4/.internal/core/elements/RoundedRectangle.js");
/* harmony import */ var _core_utils_Object__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../core/utils/Object */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Object.js");
/* harmony import */ var _Legend__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../Legend */ "./node_modules/@amcharts/amcharts4/.internal/charts/Legend.js");
/**
 * FlowDiagramNode module
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */













/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Creates a node in a Flow Diagram.
 *
 * A Flow node is a block with a value, which represents its size on the
 * diagram.
 *
 * Nodes are connected via [[FlowLink]] elements.
 *
 * @see {@link IFlowDiagramNodeEvents} for a list of available events
 * @see {@link IFlowDiagramNodeAdapters} for a list of available Adapters
 * @important
 */

var FlowDiagramNode =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(FlowDiagramNode, _super);
  /**
   * Constructor
   */


  function FlowDiagramNode() {
    var _this = _super.call(this) || this;
    /**
     * Settings for the appearance of the related legend items.
     */


    _this.legendSettings = new _Legend__WEBPACK_IMPORTED_MODULE_12__["LegendSettings"]();
    _this.className = "FlowDiagramNode";
    _this.isMeasured = false; // TODO can this be removed ?

    new _core_utils_InterfaceColorSet__WEBPACK_IMPORTED_MODULE_5__["InterfaceColorSet"]();
    _this.draggable = true;
    _this.inert = true;
    _this.setStateOnChildren = true;

    _this.events.on("positionchanged", _this.invalidateLinks, _this, false);

    _this.events.on("sizechanged", _this.invalidateLinks, _this, false);

    return _this; //this.events.on("hit", this.handleHit, this, false);
  }
  /**
   * @ignore
   */


  FlowDiagramNode.prototype.handleHit = function (event) {
    if (this.isHidden || this.isHiding) {
      this.show();
    } else {
      this.hide();
    }
  };
  /**
   * Shows hidden node.
   *
   * @param duration  Duration of reveal animation (ms)
   * @return Animation
   */


  FlowDiagramNode.prototype.show = function (duration) {
    var animation = _super.prototype.show.call(this, duration);

    this.outgoingDataItems.each(function (dataItem) {
      if (!dataItem.toNode || dataItem.toNode && !dataItem.toNode.isHidden) {
        dataItem.setWorkingValue("value", dataItem.getValue("value"), duration);
        dataItem.link.show();
      }
    });
    this.incomingDataItems.each(function (dataItem) {
      if (!dataItem.fromNode || dataItem.fromNode && !dataItem.fromNode.isHidden) {
        dataItem.setWorkingValue("value", dataItem.getValue("value"), duration);
        dataItem.link.show();
      }
    });
    return animation;
  };
  /**
   * Hides node.
   *
   * @param duration  Duration of hiding animation (ms)
   * @return Animation
   */


  FlowDiagramNode.prototype.hide = function (duration) {
    var animation = _super.prototype.hide.call(this, duration);

    this.outgoingDataItems.each(function (dataItem) {
      dataItem.setWorkingValue("value", 0, duration);
      dataItem.link.hide();
    });
    this.incomingDataItems.each(function (dataItem) {
      dataItem.setWorkingValue("value", 0, duration);
      dataItem.link.hide();
    });
    return animation;
  };
  /**
   * Marks node as invalid, for redrawal in the next update cycle.
   *
   * @ignore Exclude from docs
   */


  FlowDiagramNode.prototype.validate = function () {
    if (!this.isDisposed()) {
      _super.prototype.validate.call(this);

      this.invalidateLinks();
    }
  };
  /**
   * Invalidates all links, attached to this node.
   *
   * @ignore Exclude from docs
   */


  FlowDiagramNode.prototype.invalidateLinks = function () {
    var _this = this;

    this.outgoingDataItems.each(function (dataItem) {
      var link = dataItem.link;

      if (link.colorMode == "fromNode") {
        link.fill = link.dataItem.fromNode.color;
      }

      if (link.colorMode == "gradient") {
        link.fill = link.gradient;
        link.stroke = link.gradient;
        var stop_1 = link.gradient.stops.getIndex(0);

        if (stop_1) {
          stop_1.color = _this.color;
          link.gradient.validate();
        }
      }
    });
    this.incomingDataItems.each(function (dataItem) {
      var link = dataItem.link;

      if (link.colorMode == "toNode") {
        link.fill = link.dataItem.toNode.color;
      }

      if (link.colorMode == "gradient") {
        link.fill = link.gradient;
        link.stroke = link.gradient;
        var stop_2 = link.gradient.stops.getIndex(1);

        if (stop_2) {
          stop_2.color = _this.color;
          link.gradient.validate();
        }
      }
    });
  };

  Object.defineProperty(FlowDiagramNode.prototype, "incomingDataItems", {
    /**
     * List of incoming items (links).
     *
     * @readonly
     * @return Incoming items
     */
    get: function get() {
      var _this = this;

      if (!this._incomingDataItems) {
        var incomingDataItems = new _core_utils_List__WEBPACK_IMPORTED_MODULE_3__["List"]();
        incomingDataItems.events.on("inserted", function () {
          if (_this.chart.sortBy == "name") {
            _this._incomingSorted = _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_6__["sort"](_this._incomingDataItems.iterator(), function (x, y) {
              return _core_utils_String__WEBPACK_IMPORTED_MODULE_7__["order"](x.fromName, y.fromName);
            });
          } else if (_this.chart.sortBy == "value") {
            _this._incomingSorted = _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_6__["sort"](_this._incomingDataItems.iterator(), function (x, y) {
              return _core_utils_Order__WEBPACK_IMPORTED_MODULE_8__["reverse"](_core_utils_Number__WEBPACK_IMPORTED_MODULE_9__["order"](x.value, y.value));
            });
          } else {
            _this._incomingSorted = _this._incomingDataItems.iterator();
          }
        }, undefined, false);
        this._incomingDataItems = incomingDataItems;
      }

      return this._incomingDataItems;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(FlowDiagramNode.prototype, "outgoingDataItems", {
    /**
     * List of outgoing items (links).
     *
     * @readonly
     * @return Outgoing items
     */
    get: function get() {
      var _this = this;

      if (!this._outgoingDataItems) {
        var outgoingDataItems = new _core_utils_List__WEBPACK_IMPORTED_MODULE_3__["List"]();
        outgoingDataItems.events.on("inserted", function () {
          if (_this.chart.sortBy == "name") {
            _this._outgoingSorted = _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_6__["sort"](_this._outgoingDataItems.iterator(), function (x, y) {
              return _core_utils_String__WEBPACK_IMPORTED_MODULE_7__["order"](x.fromName, y.fromName);
            });
          } else if (_this.chart.sortBy == "value") {
            _this._outgoingSorted = _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_6__["sort"](_this._outgoingDataItems.iterator(), function (x, y) {
              return _core_utils_Order__WEBPACK_IMPORTED_MODULE_8__["reverse"](_core_utils_Number__WEBPACK_IMPORTED_MODULE_9__["order"](x.value, y.value));
            });
          } else {
            _this._outgoingSorted = _this._outgoingDataItems.iterator();
          }
        }, undefined, false);
        this._outgoingDataItems = outgoingDataItems;
      }

      return this._outgoingDataItems;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(FlowDiagramNode.prototype, "name", {
    /**
     * @return Name
     */
    get: function get() {
      return this.getPropertyValue("name");
    },

    /**
     * A name of the node.
     *
     * @param value  Name
     */
    set: function set(value) {
      this.setPropertyValue("name", value, true);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(FlowDiagramNode.prototype, "total", {
    /**
     * @return Value
     */
    get: function get() {
      return this.getPropertyValue("total");
    },

    /**
     * Sum of all incoming+outgoing link values
     *
     * @param value  Value
     */
    set: function set(value) {
      this.setPropertyValue("total", value, true);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(FlowDiagramNode.prototype, "totalIncoming", {
    /**
     * @return Value
     */
    get: function get() {
      return this.getPropertyValue("totalIncoming");
    },

    /**
     * Sum of all incomming link values.
     *
     * @param value  Value
     */
    set: function set(value) {
      this.setPropertyValue("totalIncoming", value, true);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(FlowDiagramNode.prototype, "totalOutgoing", {
    /**
     * @return Value
     */
    get: function get() {
      return this.getPropertyValue("totalOutgoing");
    },

    /**
     * Sum of all outgoing link values.
     *
     * @param value  Value
     */
    set: function set(value) {
      this.setPropertyValue("totalOutgoing", value, true);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(FlowDiagramNode.prototype, "color", {
    /**
     * @return Color
     */
    get: function get() {
      return this.getPropertyValue("color");
    },

    /**
     * Node's color.
     *
     * @param value  Color
     */
    set: function set(value) {
      this.setColorProperty("color", value);

      if (this._background) {
        this._background.fill = value;
      }

      this.fill = value;
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Creates elements in related legend container, that mimics the look of this
   * Series.
   *
   * @ignore Exclude from docs
   * @param marker  Legend item container
   */

  FlowDiagramNode.prototype.createLegendMarker = function (marker) {
    var w = marker.pixelWidth;
    var h = marker.pixelHeight;
    marker.removeChildren();
    var column = marker.createChild(_core_elements_RoundedRectangle__WEBPACK_IMPORTED_MODULE_10__["RoundedRectangle"]);
    column.shouldClone = false;
    _core_utils_Object__WEBPACK_IMPORTED_MODULE_11__["copyProperties"](this, column, _core_Sprite__WEBPACK_IMPORTED_MODULE_2__["visualProperties"]);
    column.stroke = this.fill;
    column.copyFrom(this);
    column.padding(0, 0, 0, 0); // if columns will have padding (which is often), legend marker will be very narrow

    column.width = w;
    column.height = h;
    var legendDataItem = marker.dataItem;
    legendDataItem.color = column.fill;
    legendDataItem.colorOrig = column.fill;
  };

  Object.defineProperty(FlowDiagramNode.prototype, "legendDataItem", {
    /**
     * @return Data item
     */
    get: function get() {
      return this._legendDataItem;
    },

    /**
     * Legend data item that corresponds to this series.
     *
     * @param value  Data item
     */
    set: function set(value) {
      this._legendDataItem = value;

      this._legendDataItem.itemContainer.deepInvalidate();
    },
    enumerable: true,
    configurable: true
  });
  return FlowDiagramNode;
}(_core_Container__WEBPACK_IMPORTED_MODULE_1__["Container"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_4__["registry"].registeredClasses["FlowDiagramNode"] = FlowDiagramNode;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/FunnelSlice.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/elements/FunnelSlice.js ***!
  \***********************************************************************************/
/*! exports provided: FunnelSlice */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FunnelSlice", function() { return FunnelSlice; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _core_Container__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core/Container */ "./node_modules/@amcharts/amcharts4/.internal/core/Container.js");
/* harmony import */ var _core_Sprite__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/Sprite */ "./node_modules/@amcharts/amcharts4/.internal/core/Sprite.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_utils_Percent__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/utils/Percent */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Percent.js");
/* harmony import */ var _core_utils_Utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core/utils/Utils */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Utils.js");
/* harmony import */ var _core_rendering_Path__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core/rendering/Path */ "./node_modules/@amcharts/amcharts4/.internal/core/rendering/Path.js");
/**
 * Module that defines everything related to building Funnel slices.
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */







/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Class used to create [[FunnelSlice]] elements.
 *
 * @see {@link IFunnelSliceEvents} for a list of available events
 * @see {@link IFunnelSliceAdapters} for a list of available adapters
 * @see {@link https://www.amcharts.com/docs/v4/chart-types/sliced-chart/} for documentation
 * @important
 */

var FunnelSlice =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(FunnelSlice, _super);
  /**
   * Constructor
   */


  function FunnelSlice() {
    var _this = _super.call(this) || this;

    _this.slice = _this.createChild(_core_Sprite__WEBPACK_IMPORTED_MODULE_2__["Sprite"]);
    _this.slice.shouldClone = false;

    _this.slice.setElement(_this.paper.add("path"));

    _this.slice.isMeasured = false;
    _this.orientation = "vertical";
    _this.bottomWidth = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_4__["percent"])(100);
    _this.topWidth = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_4__["percent"])(100);
    _this.isMeasured = false;
    _this.width = 10;
    _this.height = 10;
    _this.expandDistance = 0;
    _this.className = "FunnelSlice";

    _this.applyTheme();

    return _this;
  }
  /**
   * Draws the element.
   */


  FunnelSlice.prototype.draw = function () {
    _super.prototype.draw.call(this);

    var pt = this.pixelPaddingTop;
    var pb = this.pixelPaddingBottom;
    var pr = this.pixelPaddingRight;
    var pl = this.pixelPaddingLeft;
    var w = this.pixelWidth - pr - pl;
    var h = this.pixelHeight - pt - pb;
    var ed = this.expandDistance;
    var path = "";

    if (this.orientation == "vertical") {
      var tw = _core_utils_Utils__WEBPACK_IMPORTED_MODULE_5__["relativeToValue"](this.topWidth, w);
      var bw = _core_utils_Utils__WEBPACK_IMPORTED_MODULE_5__["relativeToValue"](this.bottomWidth, w);
      var tl = {
        x: (w - tw) / 2 + pl,
        y: pt
      };
      var tr = {
        x: (w + tw) / 2 + pl,
        y: pt
      };
      var br = {
        x: (w + bw) / 2 + pl,
        y: pt + h
      };
      var bl = {
        x: (w - bw) / 2 + pl,
        y: pt + h
      };
      var cpr = {
        x: tr.x + (br.x - tr.x) / 2 + ed * h,
        y: tr.y + 0.5 * h
      };
      var cpl = {
        x: tl.x + (bl.x - tl.x) / 2 - ed * h,
        y: tl.y + 0.5 * h
      };
      var qp1 = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_6__["lineTo"](br);
      var qp2 = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_6__["lineTo"](tl);

      if (ed != 0) {
        qp1 = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_6__["quadraticCurveTo"](br, cpr);
        qp2 = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_6__["quadraticCurveTo"](tl, cpl);
      }

      path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_6__["moveTo"](tl) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_6__["lineTo"](tr) + qp1 + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_6__["lineTo"](bl) + qp2;
      this.tickPoint = {
        x: tr.x + (br.x - tr.x) / 2,
        y: tr.y + (br.y - tr.y) / 2
      };
    } else {
      var tw = _core_utils_Utils__WEBPACK_IMPORTED_MODULE_5__["relativeToValue"](this.topWidth, h);
      var bw = _core_utils_Utils__WEBPACK_IMPORTED_MODULE_5__["relativeToValue"](this.bottomWidth, h);
      var tt = {
        x: pl,
        y: (h - tw) / 2 + pt
      };
      var tb = {
        x: pl,
        y: (h + tw) / 2 + pt
      };
      var bt = {
        x: pl + w,
        y: (h - bw) / 2 + pt
      };
      var bb = {
        x: pl + w,
        y: (h + bw) / 2 + pt
      };
      var cpr = {
        y: tt.y + (bt.y - tt.y) / 2 - ed * w,
        x: tt.x + 0.5 * w
      };
      var cpl = {
        y: tb.y + (bb.y - tb.y) / 2 + ed * w,
        x: tb.x + 0.5 * w
      };
      var qp1 = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_6__["lineTo"](bt);
      var qp2 = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_6__["lineTo"](tb);

      if (ed != 0) {
        qp1 = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_6__["quadraticCurveTo"](bt, cpr);
        qp2 = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_6__["quadraticCurveTo"](tb, cpl);
      }

      path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_6__["moveTo"](tb) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_6__["lineTo"](tt) + qp1 + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_6__["lineTo"](bb) + qp2;
      this.tickPoint = {
        y: tb.y + (bb.y - tb.y) / 2,
        x: tb.x + (bb.x - tb.x) / 2
      };
    }

    this.slice.path = path;
    this.invalidateLayout();
  };

  FunnelSlice.prototype.getPoint = function (locationX, locationY) {
    var pt = this.pixelPaddingTop;
    var pb = this.pixelPaddingBottom;
    var pr = this.pixelPaddingRight;
    var pl = this.pixelPaddingLeft;
    var w = this.pixelWidth - pr - pl;
    var h = this.pixelHeight - pt - pb;

    if (this.orientation == "vertical") {
      var tw = _core_utils_Utils__WEBPACK_IMPORTED_MODULE_5__["relativeToValue"](this.topWidth, w);
      var bw = _core_utils_Utils__WEBPACK_IMPORTED_MODULE_5__["relativeToValue"](this.bottomWidth, w);
      var tl = {
        x: (w - tw) / 2 + pl,
        y: pt
      };
      var tr = {
        x: (w + tw) / 2 + pl,
        y: pt
      };
      var br = {
        x: (w + bw) / 2 + pl,
        y: pt + h
      };
      var bl = {
        x: (w - bw) / 2 + pl,
        y: pt + h
      };
      var mlx = tl.x + (bl.x - tl.x) * locationY;
      var mrx = tr.x + (br.x - tr.x) * locationY;
      return {
        x: mlx + (mrx - mlx) * locationX,
        y: tr.y + (br.y - tr.y) * locationY
      };
    } else {
      var tw = _core_utils_Utils__WEBPACK_IMPORTED_MODULE_5__["relativeToValue"](this.topWidth, h);
      var bw = _core_utils_Utils__WEBPACK_IMPORTED_MODULE_5__["relativeToValue"](this.bottomWidth, h);
      var tt = {
        x: pl,
        y: (h - tw) / 2 + pt
      };
      var tb = {
        x: pl,
        y: (h + tw) / 2 + pt
      };
      var bt = {
        x: pl + w,
        y: (h - bw) / 2 + pt
      };
      var bb = {
        x: pl + w,
        y: (h + bw) / 2 + pt
      };
      var mty = tt.y + (bt.y - tt.y) * locationX;
      var mby = tb.y + (bb.y - tb.y) * locationX;
      return {
        y: mty + (mby - mty) * locationY,
        x: tt.x + (bt.x - tt.x) * locationX
      };
    }
  };

  Object.defineProperty(FunnelSlice.prototype, "bottomWidth", {
    /**
     * @return bottom width
     */
    get: function get() {
      return this.getPropertyValue("bottomWidth");
    },

    /**
     * Bottom width in pixels or percent.
     *
     * IMPORTANT: this setting might be used to set dimensions if you use slice
     * as a standalone element. If it's a part of [[FunnelSeries]] this setting
     * becomes read-only as it will be automatically reset by series.
     *
     * @param value  Bottom width
     */
    set: function set(value) {
      this.setPercentProperty("bottomWidth", value, true, false, 10, false);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(FunnelSlice.prototype, "topWidth", {
    /**
     * @return Top width
     */
    get: function get() {
      return this.getPropertyValue("topWidth");
    },

    /**
     * Top width in pixels or percent.
     *
     * IMPORTANT: this setting might be used to set dimensions if you use slice
     * as a standalone element. If it's a part of [[FunnelSeries]] this setting
     * becomes read-only as it will be automatically reset by series.
     *
     * @param value  Top width
     */
    set: function set(value) {
      this.setPercentProperty("topWidth", value, true, false, 10, false);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(FunnelSlice.prototype, "orientation", {
    /**
     * @return Orientation
     */
    get: function get() {
      return this.getPropertyValue("orientation");
    },

    /**
     * Orientation of the funnel slice: "horizontal" or "vertical".
     *
     * IMPORTANT: this setting might be used to set orintation if you use slice
     * as a standalone element. If it's a part of [[FunnelSeries]] this setting
     * becomes read-only as it will be automatically reset by series.
     *
     * @param value  Orientation
     */
    set: function set(value) {
      this.setPropertyValue("orientation", value, true);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(FunnelSlice.prototype, "expandDistance", {
    /**
     * @return expandDistance
     */
    get: function get() {
      return this.getPropertyValue("expandDistance");
    },

    /**
     * A relative distance slice's sides should be bent to. It's relative to the
     * height of the slice.
     *
     * Zero (default) will mean the sides will be perfectly straight.
     *
     * Positive value will make them bend outwards, resulting in "puffed" slices.
     *
     * Negative values will make them bend inwards.
     *
     * @default 0
     * @param {number}
     */
    set: function set(value) {
      this.setPropertyValue("expandDistance", value, true);
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Copies all parameters from another [[Sprite]].
   *
   * @param source Source Sprite
   */

  FunnelSlice.prototype.copyFrom = function (source) {
    _super.prototype.copyFrom.call(this, source);

    if (this.slice) {
      this.slice.copyFrom(source.slice);
    }
  };

  return FunnelSlice;
}(_core_Container__WEBPACK_IMPORTED_MODULE_1__["Container"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_3__["registry"].registeredClasses["FunnelSlice"] = FunnelSlice;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/FunnelTick.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/elements/FunnelTick.js ***!
  \**********************************************************************************/
/*! exports provided: FunnelTick */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FunnelTick", function() { return FunnelTick; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _elements_Tick__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../elements/Tick */ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/Tick.js");
/* harmony import */ var _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/utils/Disposer */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Disposer.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_utils_Utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/utils/Utils */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Utils.js");
/* harmony import */ var _core_rendering_Path__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core/rendering/Path */ "./node_modules/@amcharts/amcharts4/.internal/core/rendering/Path.js");
/**
 * Funnel tick module.
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */






/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Draws an tick line for a funnel slice connecting it to a related label.
 *
 * @see {@link IFunnelTickEvents} for a list of available events
 * @see {@link IFunnelTickAdapters} for a list of available Adapters
 */

var FunnelTick =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(FunnelTick, _super);
  /**
   * Constructor
   */


  function FunnelTick() {
    var _this = _super.call(this) || this;
    /**
     * A label element this tick is attached to.
     */


    _this._label = new _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_2__["MutableValueDisposer"]();
    /**
     * A slice element this tick is attached to.
     */

    _this._slice = new _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_2__["MutableValueDisposer"]();
    _this.className = "FunnelTick";
    _this.element = _this.paper.add("path");

    _this._disposers.push(_this._label);

    _this._disposers.push(_this._slice);

    _this.setPropertyValue("locationX", 0);

    _this.setPropertyValue("locationY", 0);

    _this.applyTheme();

    return _this;
  }
  /**
   * Draws the tick element.
   *
   * @ignore Exclude from docs
   */


  FunnelTick.prototype.draw = function () {
    _super.prototype.draw.call(this);

    var slice = this.slice;
    var point = slice.getPoint(this.locationX, this.locationY);

    if (point) {
      var label = this.label;
      var series = slice.dataItem.component;
      var p0 = void 0;
      var p1 = void 0;
      var p2 = void 0;

      if (series.orientation == "vertical") {
        var x1 = label.pixelX;
        var y1 = label.pixelY;

        if (!series.labelsOpposite) {
          x1 += label.maxRight;
        }

        p0 = _core_utils_Utils__WEBPACK_IMPORTED_MODULE_4__["spritePointToSprite"](point, slice, this.parent);
        p2 = _core_utils_Utils__WEBPACK_IMPORTED_MODULE_4__["spritePointToSprite"]({
          x: x1,
          y: y1
        }, label.parent, this.parent);
        p1 = {
          x: label.parent.pixelX - this.length,
          y: p2.y
        };

        if (!series.labelsOpposite) {
          p1.x = label.parent.measuredWidth + this.length;
        }
      } else {
        var x1 = label.pixelX;
        var y1 = label.pixelY;

        if (!series.labelsOpposite) {
          y1 += label.maxBottom;
        }

        p0 = _core_utils_Utils__WEBPACK_IMPORTED_MODULE_4__["spritePointToSprite"](point, slice, this.parent);
        p2 = _core_utils_Utils__WEBPACK_IMPORTED_MODULE_4__["spritePointToSprite"]({
          x: x1,
          y: y1
        }, label.parent, this.parent);
        p1 = {
          x: p2.x,
          y: label.parent.pixelY - this.length
        };

        if (!series.labelsOpposite) {
          p1.y = label.parent.measuredHeight + this.length;
        }
      }

      this.path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_5__["moveTo"](p0) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_5__["lineTo"](p1) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_5__["lineTo"](p2);
    }
  };

  Object.defineProperty(FunnelTick.prototype, "slice", {
    /**
     * @return FunnelSlice
     */
    get: function get() {
      return this._slice.get();
    },

    /**
     * [[FunnelSlice]] element tick is attached to.
     *
     * @param slice  Slice
     */
    set: function set(slice) {
      this._slice.set(slice, new _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_2__["MultiDisposer"]([slice.events.on("transformed", this.invalidate, this, false), slice.events.on("validated", this.invalidate, this, false)]));
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(FunnelTick.prototype, "label", {
    /**
     * @return Label
     */
    get: function get() {
      return this._label.get();
    },

    /**
     * [[Label]] element tick is attached to.
     *
     * @param label  Label
     */
    set: function set(label) {
      this._label.set(label, label.events.on("transformed", this.invalidate, this, false));
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(FunnelTick.prototype, "locationX", {
    /**
     * @return Location (0-1)
     */
    get: function get() {
      return this.getPropertyValue("locationX");
    },

    /**
     * A relative horizontal position within target element a tick is pointing
     * to.
     *
     * A scale is from 0 to 1, where 0 means left edge, and 1 right edge.
     *
     * You can also set any value in-between (e.g. 0.5 will point to the middle
     * of the slice), or outside 0-1 range, which will put tick anchor position
     * outside target element.
     *
     * @param value  Location (0-1)
     */
    set: function set(value) {
      this.setPropertyValue("locationX", value, false, true);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(FunnelTick.prototype, "locationY", {
    /**
     * @return Location (0-1)
     */
    get: function get() {
      return this.getPropertyValue("locationY");
    },

    /**
     * A relative vertical position within target element a tick is pointing
     * to.
     *
     * A scale is from 0 to 1, where 0 means top edge, and 1 bottom edge.
     *
     * You can also set any value in-between (e.g. 0.5 will point to the middle
     * of the slice), or outside 0-1 range, which will put tick anchor position
     * outside target element.
     *
     * @param value  Location (0-1)
     */
    set: function set(value) {
      this.setPropertyValue("locationY", value, false, true);
    },
    enumerable: true,
    configurable: true
  });
  return FunnelTick;
}(_elements_Tick__WEBPACK_IMPORTED_MODULE_1__["Tick"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_3__["registry"].registeredClasses["FunnelTick"] = FunnelTick;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/HeatLegend.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/elements/HeatLegend.js ***!
  \**********************************************************************************/
/*! exports provided: HeatLegend */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HeatLegend", function() { return HeatLegend; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _core_Container__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core/Container */ "./node_modules/@amcharts/amcharts4/.internal/core/Container.js");
/* harmony import */ var _core_rendering_fills_LinearGradient__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/rendering/fills/LinearGradient */ "./node_modules/@amcharts/amcharts4/.internal/core/rendering/fills/LinearGradient.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_utils_Color__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/utils/Color */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Color.js");
/* harmony import */ var _core_utils_List__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core/utils/List */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/List.js");
/* harmony import */ var _core_utils_Percent__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core/utils/Percent */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Percent.js");
/* harmony import */ var _charts_axes_ValueAxis__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../charts/axes/ValueAxis */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/ValueAxis.js");
/* harmony import */ var _charts_axes_AxisRendererX__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../charts/axes/AxisRendererX */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisRendererX.js");
/* harmony import */ var _charts_axes_AxisRendererY__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../charts/axes/AxisRendererY */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/AxisRendererY.js");
/* harmony import */ var _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../core/utils/Iterator */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Iterator.js");
/* harmony import */ var _core_utils_Type__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../core/utils/Type */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Type.js");
/* harmony import */ var _core_utils_Colors__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../core/utils/Colors */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Colors.js");
/* harmony import */ var _core_elements_RoundedRectangle__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../core/elements/RoundedRectangle */ "./node_modules/@amcharts/amcharts4/.internal/core/elements/RoundedRectangle.js");
/**
 * HeatLegend module
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */














/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * This class creates a link (waved color-filled line) between two nodes in a
 * Sankey Diagram.
 *
 * @see {@link IHeatLegendEvents} for a list of available events
 * @see {@link IHeatLegendAdapters} for a list of available Adapters
 * @important
 */

var HeatLegend =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(HeatLegend, _super);
  /**
   * Constructor
   */


  function HeatLegend() {
    var _this = _super.call(this) || this;

    _this.className = "HeatLegend";
    _this.markerContainer = _this.createChild(_core_Container__WEBPACK_IMPORTED_MODULE_1__["Container"]);
    _this.markerContainer.shouldClone = false;
    _this.markerCount = 1; // Create a template container and list for the a marker

    var marker = new _core_elements_RoundedRectangle__WEBPACK_IMPORTED_MODULE_13__["RoundedRectangle"]();
    marker.minHeight = 20;
    marker.minWidth = 20;
    marker.interactionsEnabled = false;
    marker.fillOpacity = 1;
    marker.cornerRadius(0, 0, 0, 0);
    _this.markerContainer.minHeight = 20;
    _this.markerContainer.minWidth = 20;
    _this.orientation = "horizontal";
    _this.markers = new _core_utils_List__WEBPACK_IMPORTED_MODULE_5__["ListTemplate"](marker);

    _this._disposers.push(new _core_utils_List__WEBPACK_IMPORTED_MODULE_5__["ListDisposer"](_this.markers));

    _this._disposers.push(_this.markers.template);

    _this.applyTheme();

    return _this;
  }

  HeatLegend.prototype.getMinFromRules = function (property) {
    var series = this.series;

    if (series) {
      var minValue_1;
      _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_10__["eachContinue"](series.heatRules.iterator(), function (heatRule) {
        if (heatRule.property == property) {
          minValue_1 = heatRule.min;
          return false;
        }

        return true;
      });
      return minValue_1;
    }
  };

  HeatLegend.prototype.getMaxFromRules = function (property) {
    var series = this.series;

    if (series) {
      var maxValue_1;
      _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_10__["each"](series.heatRules.iterator(), function (heatRule) {
        if (heatRule.property == property) {
          maxValue_1 = heatRule.max;
          return false;
        }

        return true;
      });
      return maxValue_1;
    }
  };
  /**
   *
   * @ignore Exclude from docs
   */


  HeatLegend.prototype.validate = function () {
    _super.prototype.validate.call(this);

    this.valueAxis.renderer.inversed = this.reverseOrder;
    var series = this.series;
    var minColor = this.minColor;
    var maxColor = this.maxColor;

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_11__["hasValue"](minColor)) {
      minColor = Object(_core_utils_Color__WEBPACK_IMPORTED_MODULE_4__["toColor"])(this.getMinFromRules("fill"));
    }

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_11__["hasValue"](maxColor)) {
      maxColor = Object(_core_utils_Color__WEBPACK_IMPORTED_MODULE_4__["toColor"])(this.getMaxFromRules("fill"));
    }

    if (series) {
      var seriesFill = series.fill;

      if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_11__["hasValue"](minColor) && seriesFill instanceof _core_utils_Color__WEBPACK_IMPORTED_MODULE_4__["Color"]) {
        minColor = seriesFill;
      }

      if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_11__["hasValue"](maxColor) && seriesFill instanceof _core_utils_Color__WEBPACK_IMPORTED_MODULE_4__["Color"]) {
        maxColor = seriesFill;
      }
    }

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_11__["hasValue"](maxColor)) {
      maxColor = Object(_core_utils_Color__WEBPACK_IMPORTED_MODULE_4__["toColor"])(this.getMaxFromRules("fill"));
    }

    var minOpacity = _core_utils_Type__WEBPACK_IMPORTED_MODULE_11__["toNumber"](this.getMinFromRules("fillOpacity"));

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_11__["isNumber"](minOpacity)) {
      minOpacity = 1;
    }

    var maxOpacity = _core_utils_Type__WEBPACK_IMPORTED_MODULE_11__["toNumber"](this.getMaxFromRules("fillOpacity"));

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_11__["isNumber"](maxOpacity)) {
      maxOpacity = 1;
    }

    var minStrokeOpacity = _core_utils_Type__WEBPACK_IMPORTED_MODULE_11__["toNumber"](this.getMinFromRules("strokeOpacity"));

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_11__["isNumber"](minStrokeOpacity)) {
      minStrokeOpacity = 1;
    }

    var maxStrokeOpacity = _core_utils_Type__WEBPACK_IMPORTED_MODULE_11__["toNumber"](this.getMaxFromRules("strokeOpacity"));

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_11__["isNumber"](maxStrokeOpacity)) {
      maxStrokeOpacity = 1;
    }

    var minStroke = Object(_core_utils_Color__WEBPACK_IMPORTED_MODULE_4__["toColor"])(this.getMinFromRules("stroke"));
    var maxStroke = Object(_core_utils_Color__WEBPACK_IMPORTED_MODULE_4__["toColor"])(this.getMaxFromRules("stroke")); //if (series) {

    for (var i = 0; i < this.markerCount; i++) {
      var marker = this.markers.getIndex(i);

      if (!marker) {
        marker = this.markers.create();
        marker.parent = this.markerContainer;
        marker.height = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_6__["percent"])(100);
        marker.width = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_6__["percent"])(100);
      }

      if (this.markerCount == 1) {
        var gradient = new _core_rendering_fills_LinearGradient__WEBPACK_IMPORTED_MODULE_2__["LinearGradient"]();

        if (this.reverseOrder) {
          gradient.addColor(maxColor, maxOpacity);
          gradient.addColor(minColor, minOpacity);
        } else {
          gradient.addColor(minColor, minOpacity);
          gradient.addColor(maxColor, maxOpacity);
        }

        if (this.orientation == "vertical") {
          gradient.rotation = -90;
        }

        marker.fill = gradient;

        if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_11__["hasValue"](minStroke) && _core_utils_Type__WEBPACK_IMPORTED_MODULE_11__["hasValue"](maxStroke)) {
          var strokeGradient = new _core_rendering_fills_LinearGradient__WEBPACK_IMPORTED_MODULE_2__["LinearGradient"]();

          if (this.reverseOrder) {
            strokeGradient.addColor(maxStroke, maxStrokeOpacity);
            strokeGradient.addColor(minStroke, minStrokeOpacity);
          } else {
            strokeGradient.addColor(minStroke, minStrokeOpacity);
            strokeGradient.addColor(maxStroke, maxStrokeOpacity);
          }

          if (this.orientation == "vertical") {
            strokeGradient.rotation = -90;
          }

          marker.stroke = strokeGradient;
        }
      } else {
        var c = i;

        if (this.reverseOrder) {
          c = this.markerCount - i - 1;
        }

        var color = new _core_utils_Color__WEBPACK_IMPORTED_MODULE_4__["Color"](_core_utils_Colors__WEBPACK_IMPORTED_MODULE_12__["interpolate"](minColor.rgb, maxColor.rgb, c / this.markerCount));
        marker.fill = color;
        var opacity = minOpacity + (maxOpacity - minOpacity) * c / this.markerCount;
        marker.fillOpacity = opacity;

        if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_11__["hasValue"](minStroke) && _core_utils_Type__WEBPACK_IMPORTED_MODULE_11__["hasValue"](maxStroke)) {
          var color_1 = new _core_utils_Color__WEBPACK_IMPORTED_MODULE_4__["Color"](_core_utils_Colors__WEBPACK_IMPORTED_MODULE_12__["interpolate"](minStroke.rgb, maxStroke.rgb, c / this.markerCount));
          marker.stroke = color_1;
          var opacity_1 = minStrokeOpacity + (maxStrokeOpacity - minStrokeOpacity) * c / this.markerCount;
          marker.strokeOpacity = opacity_1;
        }
      }
    }

    var renderer = this.valueAxis.renderer;

    if (this.markerCount > 1) {
      if (this.orientation == "horizontal") {
        renderer.minGridDistance = this.measuredWidth / this.markerCount;
      } else {
        renderer.minGridDistance = this.measuredHeight / this.markerCount;
      }
    }

    this.valueAxis.invalidate();

    for (var i = this.markerCount, len = this.markers.length; i < len; i++) {
      this.markers.getIndex(i).parent = undefined;
    }
  };

  Object.defineProperty(HeatLegend.prototype, "minColor", {
    /**
     * Returns minColor value
     * @return {Color}
     */
    get: function get() {
      return this.getPropertyValue("minColor");
    },

    /**
     * Min color of a heat legend. If a series is set for the legend, minColor is taken from series.
     *
     * @param {Color}
     */
    set: function set(value) {
      if (!(value instanceof _core_utils_Color__WEBPACK_IMPORTED_MODULE_4__["Color"])) {
        value = Object(_core_utils_Color__WEBPACK_IMPORTED_MODULE_4__["toColor"])(value);
      }

      this.setColorProperty("minColor", value, true);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(HeatLegend.prototype, "maxColor", {
    /**
     * Returns maxColor value
     * @return {Color}
     */
    get: function get() {
      return this.getPropertyValue("maxColor");
    },

    /**
     * Max color of a heat legend. If a series is set for the legend, maxColor is taken from series.
     *
     * @param {Color}
     */
    set: function set(value) {
      if (!(value instanceof _core_utils_Color__WEBPACK_IMPORTED_MODULE_4__["Color"])) {
        value = Object(_core_utils_Color__WEBPACK_IMPORTED_MODULE_4__["toColor"])(value);
      }

      this.setColorProperty("maxColor", value, true);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(HeatLegend.prototype, "markerCount", {
    /**
     * Returns number of color squares (markers).
     * @return {number}
     */
    get: function get() {
      return this.getPropertyValue("markerCount");
    },

    /**
     * Number of color squares (markers) in the heat legend. If only 1 marker is used, it will be filled with gradient.
     *
     * @param {number}
     */
    set: function set(value) {
      this.setPropertyValue("markerCount", value, true);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(HeatLegend.prototype, "minValue", {
    /**
     * Returns minimum value of heat legend.
     * @return {number}
     */
    get: function get() {
      return this.getPropertyValue("minValue");
    },

    /**
     * Minimum value of heat legend's value axis. If a series is set for the legend, min is taken from series.
     *
     * @param {number}
     */
    set: function set(value) {
      this.setPropertyValue("minValue", value);
      this.valueAxis.min = value;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(HeatLegend.prototype, "maxValue", {
    /**
     * Returns maximum value of heat legend.
     * @return {number}
     */
    get: function get() {
      return this.getPropertyValue("maxValue");
    },

    /**
     * Maximum value of heat legend's value axis. If a series is set for the legend, max is taken from series.
     *
     * @param {number}
     */
    set: function set(value) {
      this.setPropertyValue("maxValue", value);
      this.valueAxis.max = value;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(HeatLegend.prototype, "orientation", {
    /**
     * Returns orientation value.
     *
     * @return {"horizontal" | "vertical"}
     */
    get: function get() {
      return this.getPropertyValue("orientation");
    },

    /**
    * Heat legend orientation. Note, if you change orientation of a heat legend, you must set value axis renderer properties after that, as with orientation renderer changes.
    *
    * @param {"horizontal" | "vertical"}
    */
    set: function set(value) {
      this.setPropertyValue("orientation", value, true);
      var markerContainer = this.markerContainer;
      var valueAxis = this.valueAxis; // HORIZONTAL

      if (value == "horizontal") {
        if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_11__["hasValue"](this.width)) {
          this.width = 200;
        }

        this.height = undefined;
        valueAxis.width = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_6__["percent"])(100);
        valueAxis.height = undefined;
        valueAxis.tooltip.pointerOrientation = "vertical";
        this.layout = "vertical";
        markerContainer.width = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_6__["percent"])(100);
        markerContainer.height = undefined;

        if (!(valueAxis.renderer instanceof _charts_axes_AxisRendererX__WEBPACK_IMPORTED_MODULE_8__["AxisRendererX"])) {
          valueAxis.renderer = new _charts_axes_AxisRendererX__WEBPACK_IMPORTED_MODULE_8__["AxisRendererX"]();
        }
      } // VERTICAL
      else {
          if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_11__["hasValue"](this.height)) {
            this.height = 200;
          }

          this.width = undefined;
          this.layout = "horizontal";
          markerContainer.width = undefined;
          markerContainer.height = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_6__["percent"])(100);
          valueAxis.height = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_6__["percent"])(100);
          valueAxis.width = undefined;
          valueAxis.tooltip.pointerOrientation = "horizontal";

          if (!(valueAxis.renderer instanceof _charts_axes_AxisRendererY__WEBPACK_IMPORTED_MODULE_9__["AxisRendererY"])) {
            valueAxis.renderer = new _charts_axes_AxisRendererY__WEBPACK_IMPORTED_MODULE_9__["AxisRendererY"]();
          }

          valueAxis.renderer.inside = true;
          valueAxis.renderer.labels.template.inside = true;
          this.markerContainer.reverseOrder = true;
        }

      var renderer = valueAxis.renderer;
      renderer.grid.template.disabled = true;
      renderer.axisFills.template.disabled = true;
      renderer.baseGrid.disabled = true;
      renderer.labels.template.padding(2, 3, 2, 3);
      renderer.minHeight = undefined;
      renderer.minWidth = undefined;
      this.markerContainer.layout = value;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(HeatLegend.prototype, "valueAxis", {
    /**
     * Returns valueAxis value.
     * @return {ValueAxis}
     */
    get: function get() {
      if (!this._valueAxis) {
        this.valueAxis = this.createChild(_charts_axes_ValueAxis__WEBPACK_IMPORTED_MODULE_7__["ValueAxis"]);
        this.valueAxis.shouldClone = false;
      }

      return this._valueAxis;
    },

    /**
     * Sets a value axis of heat legend. Value axis for heat legend is created automatically.
     * @param {ValueAxis}
     */
    set: function set(valueAxis) {
      this._valueAxis = valueAxis;
      valueAxis.parent = this;
      valueAxis.strictMinMax = true;
      this.orientation = this.orientation;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(HeatLegend.prototype, "series", {
    /**
     * Returns series value.
     * @return {Series}
     */
    get: function get() {
      return this._series;
    },

    /**
     * You can set series for heat legend. It will take min, max, minColor and maxColor values from this series.
     * @param series
     */
    set: function set(series) {
      var _this = this;

      this._series = series;
      var dataField = "value";

      try {
        var dataFieldDefined = series.heatRules.getIndex(0).dataField;

        if (dataFieldDefined) {
          dataField = dataFieldDefined;
        }
      } catch (err) {}

      this.updateMinMax(series.dataItem.values[dataField].low, series.dataItem.values[dataField].high);
      series.dataItem.events.on("calculatedvaluechanged", function (event) {
        _this.updateMinMax(series.dataItem.values[dataField].low, series.dataItem.values[dataField].high);
      }, undefined, false);
      series.heatRules.events.on("inserted", this.invalidate, this, false);
      series.heatRules.events.on("removed", this.invalidate, this, false);
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Updates min/max of value axis.
   * @ignore
   */

  HeatLegend.prototype.updateMinMax = function (min, max) {
    var valueAxis = this.valueAxis;

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_11__["isNumber"](this.minValue)) {
      valueAxis.min = min;
      valueAxis.invalidate();
    }

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_11__["isNumber"](this.maxValue)) {
      valueAxis.max = max;
      valueAxis.invalidate();
    }
  };
  /**
   * Processes JSON-based config before it is applied to the object.
   *
   * @ignore Exclude from docs
   * @param config  Config
   */


  HeatLegend.prototype.processConfig = function (config) {
    if (config) {
      // Set up series
      if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_11__["hasValue"](config.series) && _core_utils_Type__WEBPACK_IMPORTED_MODULE_11__["isString"](config.series)) {
        if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_11__["isString"](config.series)) {
          if (this.map.hasKey(config.series)) {
            config.series = this.map.getKey(config.series);
          } else {
            var seriesId_1 = config.series;
            var disposer_1 = this.map.events.on("insertKey", function (ev) {
              if (ev.key == seriesId_1) {
                this.series = ev.newValue;
                disposer_1.dispose();
              }
            }, this);

            this._disposers.push(disposer_1);

            delete config.series;
          }
        }
      }
    }

    _super.prototype.processConfig.call(this, config);
  };

  return HeatLegend;
}(_core_Container__WEBPACK_IMPORTED_MODULE_1__["Container"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_3__["registry"].registeredClasses["HeatLegend"] = HeatLegend;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/LabelBullet.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/elements/LabelBullet.js ***!
  \***********************************************************************************/
/*! exports provided: LabelBullet */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LabelBullet", function() { return LabelBullet; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Bullet__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Bullet */ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/Bullet.js");
/* harmony import */ var _core_elements_Label__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/elements/Label */ "./node_modules/@amcharts/amcharts4/.internal/core/elements/Label.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_utils_Color__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/utils/Color */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Color.js");
/* harmony import */ var _core_utils_InterfaceColorSet__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core/utils/InterfaceColorSet */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/InterfaceColorSet.js");
/**
 * Bullet module
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */






/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Creates a bullet with a textual label.
 *
 * Uses [[Label]] instance to draw the label, so the label itself is
 * configurable.
 *
 * @see {@link IBulletEvents} for a list of available events
 * @see {@link IBulletAdapters} for a list of available Adapters
 * @todo Usage example
 * @important
 */

var LabelBullet =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(LabelBullet, _super);
  /**
   * Constructor
   */


  function LabelBullet() {
    var _this = _super.call(this) || this;

    _this.className = "LabelBullet";

    var label = _this.createChild(_core_elements_Label__WEBPACK_IMPORTED_MODULE_2__["Label"]);

    label.shouldClone = false;
    label.verticalCenter = "middle";
    label.horizontalCenter = "middle";
    label.truncate = true;
    label.hideOversized = false;
    label.maxWidth = 500;
    label.maxHeight = 500;
    label.stroke = Object(_core_utils_Color__WEBPACK_IMPORTED_MODULE_4__["color"])();
    label.strokeOpacity = 0;
    label.fill = new _core_utils_InterfaceColorSet__WEBPACK_IMPORTED_MODULE_5__["InterfaceColorSet"]().getFor("text");

    _this.events.on("maxsizechanged", _this.handleMaxSize, _this, false);

    _this.label = label; // not good, as lineSeries will have labels somewhere in the middle.
    //this.locationX = 0.5;
    //this.locationY = 0.5;

    _this.applyTheme();

    return _this;
  }

  LabelBullet.prototype.handleMaxSize = function () {
    this.label.maxWidth = this.maxWidth;
    this.label.maxHeight = this.maxHeight;
  };
  /**
   * Copies all proprities and related stuff from another instance of
   * [[LabelBullet]].
   *
   * @param source  Source element
   */


  LabelBullet.prototype.copyFrom = function (source) {
    _super.prototype.copyFrom.call(this, source);

    this.label.copyFrom(source.label);
  };

  return LabelBullet;
}(_Bullet__WEBPACK_IMPORTED_MODULE_1__["Bullet"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_3__["registry"].registeredClasses["LabelBullet"] = LabelBullet;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/NavigationBar.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/elements/NavigationBar.js ***!
  \*************************************************************************************/
/*! exports provided: NavigationBarDataItem, NavigationBar */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "NavigationBarDataItem", function() { return NavigationBarDataItem; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "NavigationBar", function() { return NavigationBar; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _core_Component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core/Component */ "./node_modules/@amcharts/amcharts4/.internal/core/Component.js");
/* harmony import */ var _core_DataItem__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/DataItem */ "./node_modules/@amcharts/amcharts4/.internal/core/DataItem.js");
/* harmony import */ var _core_utils_List__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/utils/List */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/List.js");
/* harmony import */ var _core_elements_TextLink__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/elements/TextLink */ "./node_modules/@amcharts/amcharts4/.internal/core/elements/TextLink.js");
/* harmony import */ var _core_elements_Triangle__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core/elements/Triangle */ "./node_modules/@amcharts/amcharts4/.internal/core/elements/Triangle.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_utils_InterfaceColorSet__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../core/utils/InterfaceColorSet */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/InterfaceColorSet.js");
/* harmony import */ var _core_utils_Percent__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../core/utils/Percent */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Percent.js");
/* harmony import */ var _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../core/utils/Iterator */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Iterator.js");
/**
 * Functionality for drawing simple NavigationBar.
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */










/**
 * ============================================================================
 * DATA ITEM
 * ============================================================================
 * @hidden
 */

/**
 * Defines a [[DataItem]] for [[NavigationBar]].
 *
 * @see {@link DataItem}
 */

var NavigationBarDataItem =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(NavigationBarDataItem, _super);
  /**
   * Constructor
   */


  function NavigationBarDataItem() {
    var _this = _super.call(this) || this;

    _this.className = "NavigationBarDataItem";

    _this.applyTheme();

    return _this;
  }

  Object.defineProperty(NavigationBarDataItem.prototype, "name", {
    /**
     * @return Name
     */
    get: function get() {
      return this.properties["name"];
    },

    /**
     * Name of the navigation bar item.
     *
     * @param value  Name
     */
    set: function set(value) {
      this.setProperty("name", value);
    },
    enumerable: true,
    configurable: true
  });
  return NavigationBarDataItem;
}(_core_DataItem__WEBPACK_IMPORTED_MODULE_2__["DataItem"]);


/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * NavigationBar class can be used to create a multi-level breadcrumb-style
 * navigation control.
 *
 * @see {@link INavigationBarEvents} for a list of available events
 * @see {@link INavigationBarAdapters} for a list of available Adapters
 * @todo Implement better
 * @important
 */

var NavigationBar =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(NavigationBar, _super);
  /**
   * Constructor
   */


  function NavigationBar() {
    var _this = // Init
    _super.call(this) || this;

    _this.className = "NavigationBar";
    var interfaceColors = new _core_utils_InterfaceColorSet__WEBPACK_IMPORTED_MODULE_7__["InterfaceColorSet"]();
    var textLink = new _core_elements_TextLink__WEBPACK_IMPORTED_MODULE_4__["TextLink"]();
    textLink.valign = "middle";
    textLink.paddingTop = 8;
    textLink.paddingBottom = 8;
    _this.paddingBottom = 2;
    _this.links = new _core_utils_List__WEBPACK_IMPORTED_MODULE_3__["ListTemplate"](textLink);

    _this._disposers.push(new _core_utils_List__WEBPACK_IMPORTED_MODULE_3__["ListDisposer"](_this.links));

    _this._disposers.push(textLink);

    _this._linksIterator = new _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_9__["ListIterator"](_this.links, function () {
      return _this.links.create();
    });
    _this._linksIterator.createNewItems = true;
    var triangle = new _core_elements_Triangle__WEBPACK_IMPORTED_MODULE_5__["Triangle"]();
    triangle.direction = "right";
    triangle.width = 8;
    triangle.height = 12;
    triangle.fill = interfaceColors.getFor("alternativeBackground");
    triangle.fillOpacity = 0.5;
    triangle.valign = "middle";
    triangle.marginLeft = 10;
    triangle.marginRight = 10;
    _this.separators = new _core_utils_List__WEBPACK_IMPORTED_MODULE_3__["ListTemplate"](triangle);

    _this._disposers.push(new _core_utils_List__WEBPACK_IMPORTED_MODULE_3__["ListDisposer"](_this.separators));

    _this._disposers.push(triangle);

    var activeLink = new _core_elements_TextLink__WEBPACK_IMPORTED_MODULE_4__["TextLink"]();
    _this.activeLink = activeLink;
    activeLink.copyFrom(textLink);
    activeLink.valign = "middle";
    activeLink.fontWeight = "bold";
    _this.width = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_8__["percent"])(100);
    _this.layout = "grid";
    _this.dataFields.name = "name"; // Apply theme

    _this.applyTheme();

    return _this;
  }
  /**
   * Completely redraws the navigation bar.
   *
   * @ignore Exclude from docs
   */


  NavigationBar.prototype.validateDataElements = function () {
    this.removeChildren();

    this._linksIterator.reset();

    _super.prototype.validateDataElements.call(this); //@todo: dispose

  };
  /**
   * Creates a visual element for a data item (nav item).
   *
   * @ignore Exclude from docs
   * @param dataItem  Data item
   */


  NavigationBar.prototype.validateDataElement = function (dataItem) {
    _super.prototype.validateDataElement.call(this, dataItem);

    var textLink;

    if (dataItem.index < this.dataItems.length - 1) {
      textLink = this._linksIterator.getLast();
      textLink.parent = this;
      var separator = this.separators.create();
      separator.parent = this;
      separator.valign = "middle";
    } else {
      textLink = this.activeLink;
      textLink.events.copyFrom(this.links.template.events);
      textLink.hide(0);
      textLink.show();
      textLink.parent = this;
    }

    textLink.dataItem = dataItem;
    textLink.text = dataItem.name;
    textLink.validate();
  };

  return NavigationBar;
}(_core_Component__WEBPACK_IMPORTED_MODULE_1__["Component"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_6__["registry"].registeredClasses["NavigationBar"] = NavigationBar;
_core_Registry__WEBPACK_IMPORTED_MODULE_6__["registry"].registeredClasses["NavigationBarDataItem"] = NavigationBarDataItem;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/OHLC.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/elements/OHLC.js ***!
  \****************************************************************************/
/*! exports provided: OHLC */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "OHLC", function() { return OHLC; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Candlestick__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Candlestick */ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/Candlestick.js");
/* harmony import */ var _core_elements_Line__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/elements/Line */ "./node_modules/@amcharts/amcharts4/.internal/core/elements/Line.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/**
 * Module that defines everything related to building OHLCs.
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */




/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Class used to creates OHLCs.
 *
 * @see {@link IOHLCEvents} for a list of available events
 * @see {@link IOHLCAdapters} for a list of available Adapters
 * @todo Usage example
 * @important
 */

var OHLC =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(OHLC, _super);
  /**
   * Constructor
   */


  function OHLC() {
    var _this = _super.call(this) || this;

    _this.className = "OHLC";
    _this.layout = "none";
    return _this;
  }
  /**
   * @ignore
   */


  OHLC.prototype.createAssets = function () {
    //super.createAssets();
    this.openLine = this.createChild(_core_elements_Line__WEBPACK_IMPORTED_MODULE_2__["Line"]);
    this.openLine.shouldClone = false;
    this.highLowLine = this.createChild(_core_elements_Line__WEBPACK_IMPORTED_MODULE_2__["Line"]);
    this.highLowLine.shouldClone = false;
    this.closeLine = this.createChild(_core_elements_Line__WEBPACK_IMPORTED_MODULE_2__["Line"]);
    this.closeLine.shouldClone = false;
  };
  /**
   * Copies all parameters from another [[OHLC]].
   *
   * @param source Source OHLC
   */


  OHLC.prototype.copyFrom = function (source) {
    _super.prototype.copyFrom.call(this, source);

    if (this.openLine) {
      this.openLine.copyFrom(source.openLine);
    }

    if (this.highLowLine) {
      this.highLowLine.copyFrom(source.highLowLine);
    }

    if (this.closeLine) {
      this.closeLine.copyFrom(source.closeLine);
    }
  };

  return OHLC;
}(_Candlestick__WEBPACK_IMPORTED_MODULE_1__["Candlestick"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_3__["registry"].registeredClasses["OHLC"] = OHLC;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/PieTick.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/elements/PieTick.js ***!
  \*******************************************************************************/
/*! exports provided: PieTick */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PieTick", function() { return PieTick; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _elements_Tick__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../elements/Tick */ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/Tick.js");
/* harmony import */ var _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/utils/Disposer */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Disposer.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/**
 * Pie tick module.
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */




/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Draws an tick line for a pie slice connecting it to a related label.
 *
 * @see {@link IPieTickEvents} for a list of available events
 * @see {@link IPieTickAdapters} for a list of available Adapters
 */

var PieTick =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(PieTick, _super);
  /**
   * Constructor
   */


  function PieTick() {
    var _this = _super.call(this) || this;
    /**
     * A label element this tick is attached to.
     */


    _this._label = new _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_2__["MutableValueDisposer"]();
    /**
     * A slice element this tick is attached to.
     */

    _this._slice = new _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_2__["MutableValueDisposer"]();
    _this.className = "PieTick";
    _this.element = _this.paper.add("polyline");

    _this._disposers.push(_this._label);

    _this._disposers.push(_this._slice);

    _this.applyTheme();

    return _this;
  }
  /**
   * Draws the tick element.
   *
   * @ignore Exclude from docs
   */


  PieTick.prototype.draw = function () {
    _super.prototype.draw.call(this);

    var slice = this.slice;
    var label = this.label;
    var series = slice.dataItem.component;

    if (slice && slice.radius > 0 && label && label.text) {
      var x0 = slice.dx + slice.slice.dx + slice.pixelX + slice.ix * slice.radius * slice.scale;
      var y0 = slice.dy + slice.slice.dy + slice.pixelY + slice.iy * slice.radiusY * slice.scale;
      var x1 = void 0;
      var y1 = void 0;
      var x2 = void 0;
      var y2 = void 0;

      if (series.alignLabels) {
        x1 = label.pixelX - this.length;
        y1 = label.pixelY;
        x2 = label.pixelX;
        y2 = y1;

        if (label.horizontalCenter == "right") {
          x1 += 2 * this.length;
          x2 = x1 - this.length;
        }
      } else {
        var r = label.pixelRadius(slice.radius);
        x1 = x0 + r * slice.ix;
        y1 = y0 + r * slice.iy;
        x2 = x1;
        y2 = y1;
      }

      this.element.attr({
        "points": [x0, y0, x1, y1, x2, y2]
      });
    }
  };

  Object.defineProperty(PieTick.prototype, "slice", {
    /**
     * @return Slice
     */
    get: function get() {
      return this._slice.get();
    },

    /**
     * Slice element tick is attached to.
     *
     * @param slice  Slice
     */
    set: function set(slice) {
      this._slice.set(slice, new _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_2__["MultiDisposer"]([slice.events.on("transformed", this.invalidate, this), slice.events.on("validated", this.invalidate, this)]));
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(PieTick.prototype, "label", {
    /**
     * @return Label
     */
    get: function get() {
      return this._label.get();
    },

    /**
     * Label element tick is attached to.
     *
     * @param label  Label
     */
    set: function set(label) {
      this._label.set(label, label.events.on("transformed", this.invalidate, this, false));
    },
    enumerable: true,
    configurable: true
  });
  return PieTick;
}(_elements_Tick__WEBPACK_IMPORTED_MODULE_1__["Tick"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_3__["registry"].registeredClasses["PieTick"] = PieTick;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/RadarColumn.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/elements/RadarColumn.js ***!
  \***********************************************************************************/
/*! exports provided: RadarColumn */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "RadarColumn", function() { return RadarColumn; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Column__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Column */ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/Column.js");
/* harmony import */ var _core_elements_Slice__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/elements/Slice */ "./node_modules/@amcharts/amcharts4/.internal/core/elements/Slice.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_utils_Type__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/utils/Type */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Type.js");
/**
 * Module that defines everything related to building RadarColumns.
 * It is a container which has radarColumn element which is a Slice.
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */





/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Class used to creates RadarColumns.
 *
 * @see {@link IRadarColumnEvents} for a list of available events
 * @see {@link IRadarColumnAdapters} for a list of available Adapters
 * @todo Usage example
 * @important
 */

var RadarColumn =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(RadarColumn, _super);
  /**
   * Constructor
   */


  function RadarColumn() {
    var _this = _super.call(this) || this;

    _this.className = "RadarColumn";
    return _this;
  }
  /**
   * @ignore
   */


  RadarColumn.prototype.createAssets = function () {
    this.radarColumn = this.createChild(_core_elements_Slice__WEBPACK_IMPORTED_MODULE_2__["Slice"]);
    this.radarColumn.shouldClone = false;
    this.radarColumn.strokeOpacity = undefined; // some dirty hack so that if user access column, it won't get error

    this.column = this.radarColumn;
  };
  /**
   * Copies all parameters from another [[RadarColumn]].
   *
   * @param source Source RadarColumn
   */


  RadarColumn.prototype.copyFrom = function (source) {
    _super.prototype.copyFrom.call(this, source);

    if (this.radarColumn) {
      this.radarColumn.copyFrom(source.radarColumn);
    }
  };
  /**
   * X coordinate for the slice tooltip.
   *
   * @return X
   * @ignore
   */


  RadarColumn.prototype.getTooltipX = function () {
    var value = this.getPropertyValue("tooltipX");

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_4__["isNumber"](value)) {
      return this.radarColumn.getTooltipX();
    }

    return value;
  };
  /**
   * Y coordinate for the slice tooltip.
   *
   * @return Y
   * @ignore
   */


  RadarColumn.prototype.getTooltipY = function () {
    var value = this.getPropertyValue("tooltipX");

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_4__["isNumber"](value)) {
      return this.radarColumn.getTooltipY();
    }

    return value;
  };

  return RadarColumn;
}(_Column__WEBPACK_IMPORTED_MODULE_1__["Column"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_3__["registry"].registeredClasses["RadarColumn"] = RadarColumn;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/SankeyLink.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/elements/SankeyLink.js ***!
  \**********************************************************************************/
/*! exports provided: SankeyLink */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SankeyLink", function() { return SankeyLink; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _FlowDiagramLink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./FlowDiagramLink */ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/FlowDiagramLink.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_elements_Polyspline__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/elements/Polyspline */ "./node_modules/@amcharts/amcharts4/.internal/core/elements/Polyspline.js");
/* harmony import */ var _core_utils_InterfaceColorSet__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/utils/InterfaceColorSet */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/InterfaceColorSet.js");
/* harmony import */ var _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core/utils/Math */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Math.js");
/* harmony import */ var _core_utils_Type__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core/utils/Type */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Type.js");
/* harmony import */ var _core_rendering_Smoothing__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../core/rendering/Smoothing */ "./node_modules/@amcharts/amcharts4/.internal/core/rendering/Smoothing.js");
/* harmony import */ var _core_rendering_Path__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../core/rendering/Path */ "./node_modules/@amcharts/amcharts4/.internal/core/rendering/Path.js");
/**
 * SankeyLink module
 */









/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * This class creates a link (waved color-filled line) between two nodes in a
 * Sankey Diagram.
 *
 * @see {@link ISankeyLinkEvents} for a list of available events
 * @see {@link ISankeyLinkAdapters} for a list of available Adapters
 * @important
 */

var SankeyLink =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(SankeyLink, _super);
  /**
   * Constructor
   */


  function SankeyLink() {
    var _this = _super.call(this) || this;

    _this.className = "SankeyLink"; // TODO can this be removed ?

    new _core_utils_InterfaceColorSet__WEBPACK_IMPORTED_MODULE_4__["InterfaceColorSet"]();
    _this.tension = 0.8;
    _this.controlPointDistance = 0.2;
    _this.startAngle = 0;
    _this.endAngle = 0;
    _this.linkWidth = 0;
    _this.startX = 0;
    _this.endX = 0;
    _this.startY = 0;
    _this.endY = 0;
    _this.middleLine = _this.createChild(_core_elements_Polyspline__WEBPACK_IMPORTED_MODULE_3__["Polyspline"]);
    _this.middleLine.shouldClone = false;
    _this.middleLine.strokeOpacity = 0;

    _this.applyTheme();

    return _this;
  }

  SankeyLink.prototype.makeBackwards = function () {
    if (this.states.getKey("backwards") != undefined) {
      this.setState("backwards");
    }
  };
  /**
   * (Re)validates (redraws) the link.
   *
   * @ignore Exclude from docs
   */


  SankeyLink.prototype.validate = function () {
    var _a, _b, _c, _d;

    _super.prototype.validate.call(this);

    if (!this.isTemplate) {
      var x0 = this.startX;
      var y0 = this.startY;
      var x1 = this.endX;
      var y1 = this.endY;

      if (this.states.getKey("backwards")) {
        this.setState("default");
      }

      if (this.dataItem) {
        var chart = this.dataItem.component;

        if (chart) {
          if (chart.orientation == "horizontal") {
            if (x1 < x0) {
              _a = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__read"])([x1, x0], 2), x0 = _a[0], x1 = _a[1];
              _b = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__read"])([y1, y0], 2), y0 = _b[0], y1 = _b[1];
              this.makeBackwards();
            }
          } else {
            if (y1 < y0) {
              _c = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__read"])([y1, y0], 2), y0 = _c[0], y1 = _c[1];
              _d = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__read"])([x1, x0], 2), x0 = _d[0], x1 = _d[1];
              this.makeBackwards();
            }
          }
        }
      }

      if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_6__["isNumber"](x1)) {
        x1 = x0;
      }

      if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_6__["isNumber"](y1)) {
        y1 = y0;
      }

      var startAngle = this.startAngle;
      var endAngle = this.endAngle;
      var w = this.linkWidth;
      var path = "";
      var xt0 = x0;
      var yt0 = y0;
      var xt1 = x1;
      var yt1 = y1;
      var xb0 = x0 + w * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["sin"](startAngle);
      var xb1 = x1 + w * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["sin"](endAngle);
      var yb0 = y0 + w * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["cos"](startAngle);
      var yb1 = y1 + w * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["cos"](endAngle);
      var xm0 = x0 + w / 2 * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["sin"](startAngle);
      var xm1 = x1 + w / 2 * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["sin"](endAngle);
      var ym0 = y0 + w / 2 * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["cos"](startAngle);
      var ym1 = y1 + w / 2 * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["cos"](endAngle);
      this.zIndex = this.zIndex || this.dataItem.index;
      var tensionX = this.tension + (1 - this.tension) * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["sin"](startAngle);
      var tensionY = this.tension + (1 - this.tension) * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["cos"](startAngle);
      this.middleLine.tensionX = tensionX;
      this.middleLine.tensionY = tensionY;

      if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_6__["isNumber"](w) && _core_utils_Type__WEBPACK_IMPORTED_MODULE_6__["isNumber"](x0) && _core_utils_Type__WEBPACK_IMPORTED_MODULE_6__["isNumber"](x1) && _core_utils_Type__WEBPACK_IMPORTED_MODULE_6__["isNumber"](y0) && _core_utils_Type__WEBPACK_IMPORTED_MODULE_6__["isNumber"](y1)) {
        // solves issues with gradient fill of straight lines
        if (_core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["round"](xt0, 3) == _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["round"](xt1, 3)) {
          xt1 += 0.01;
        }

        if (_core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["round"](yt0, 3) == _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["round"](yt1, 3)) {
          yt1 += 0.01;
        }

        if (_core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["round"](xb0, 3) == _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["round"](xb1, 3)) {
          xb1 += 0.01;
        }

        if (_core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["round"](yb0, 3) == _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["round"](yb1, 3)) {
          yb1 += 0.01;
        }

        var minX = Math.min(xb0, xb1, xt0, xt1);
        var minY = Math.min(yb0, yb1, yt0, yt1);
        var maxX = Math.max(xb0, xb1, xt0, xt1);
        var maxY = Math.max(yb0, yb1, yt0, yt1);
        this._bbox = {
          x: minX,
          y: minY,
          width: maxX - minX,
          height: maxY - minY
        };
        var cpd = this.controlPointDistance;
        var kxt0 = xt0 + (xt1 - xt0) * cpd * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["cos"](startAngle);
        var kyt0 = yt0 + (yt1 - yt0) * cpd * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["sin"](startAngle);
        var kxt1 = xt1 - (xt1 - xt0) * cpd * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["cos"](endAngle);
        var kyt1 = yt1 - (yt1 - yt0) * cpd * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["sin"](endAngle);
        var kxm0 = xm0 + (xm1 - xm0) * cpd * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["cos"](startAngle);
        var kym0 = ym0 + (ym1 - ym0) * cpd * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["sin"](startAngle);
        var kxm1 = xm1 - (xm1 - xm0) * cpd * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["cos"](endAngle);
        var kym1 = ym1 - (ym1 - ym0) * cpd * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["sin"](endAngle);
        var angle = _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["getAngle"]({
          x: kxt0,
          y: kyt0
        }, {
          x: kxt1,
          y: kyt1
        });
        var dx = (w / _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["cos"](angle) - w) / _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["tan"](angle) * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["cos"](startAngle);
        var dy = (w / _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["sin"](angle) - w) * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["tan"](angle) * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["sin"](startAngle);
        var kxb0 = -dx / 2 + xb0 + (xb1 - xb0) * cpd * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["cos"](startAngle);
        var kyb0 = -dy / 2 + yb0 + (yb1 - yb0) * cpd * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["sin"](startAngle);
        var kxb1 = -dx / 2 + xb1 - (xb1 - xb0) * cpd * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["cos"](endAngle);
        var kyb1 = -dy / 2 + yb1 - (yb1 - yb0) * cpd * _core_utils_Math__WEBPACK_IMPORTED_MODULE_5__["sin"](endAngle);
        this.middleLine.segments = [[{
          x: xm0,
          y: ym0
        }, {
          x: kxm0,
          y: kym0
        }, {
          x: kxm1,
          y: kym1
        }, {
          x: xm1,
          y: ym1
        }]];
        kxt0 += dx / 2;
        kyt0 += dy / 2;
        kxt1 += dx / 2;
        kyt1 += dy / 2;
        path += _core_rendering_Path__WEBPACK_IMPORTED_MODULE_8__["moveTo"]({
          x: xt0,
          y: yt0
        });
        path += new _core_rendering_Smoothing__WEBPACK_IMPORTED_MODULE_7__["Tension"](tensionX, tensionY).smooth([{
          x: xt0,
          y: yt0
        }, {
          x: kxt0,
          y: kyt0
        }, {
          x: kxt1,
          y: kyt1
        }, {
          x: xt1,
          y: yt1
        }]);
        path += _core_rendering_Path__WEBPACK_IMPORTED_MODULE_8__["lineTo"]({
          x: xb1,
          y: yb1
        });
        path += new _core_rendering_Smoothing__WEBPACK_IMPORTED_MODULE_7__["Tension"](tensionX, tensionY).smooth([{
          x: xb1,
          y: yb1
        }, {
          x: kxb1,
          y: kyb1
        }, {
          x: kxb0,
          y: kyb0
        }, {
          x: xb0,
          y: yb0
        }]);
        path += _core_rendering_Path__WEBPACK_IMPORTED_MODULE_8__["closePath"]();
      }

      this.link.path = path;

      if (this.maskBullets) {
        this.bulletsMask.path = path;
        this.bulletsContainer.mask = this.bulletsMask;
      }

      this.positionBullets();
    }
  };

  Object.defineProperty(SankeyLink.prototype, "startX", {
    /**
     * @return Start X
     */
    get: function get() {
      return this.getPropertyValue("startX");
    },

    /**
     * [startX description]
     *
     * @todo Description
     * @param value  Start X
     */
    set: function set(value) {
      this.setPropertyValue("startX", value, true);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(SankeyLink.prototype, "endX", {
    /**
     * @return End X
     */
    get: function get() {
      return this.getPropertyValue("endX");
    },

    /**
     * [endX description]
     *
     * @todo Description
     * @param value  End X
     */
    set: function set(value) {
      this.setPropertyValue("endX", value, true);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(SankeyLink.prototype, "startY", {
    /**
     * @return Start Y
     */
    get: function get() {
      return this.getPropertyValue("startY");
    },

    /**
     * [startY description]
     *
     * @todo Description
     * @param value  Start Y
     */
    set: function set(value) {
      this.setPropertyValue("startY", value, true);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(SankeyLink.prototype, "endY", {
    /**
     * @return End Y
     */
    get: function get() {
      return this.getPropertyValue("endY");
    },

    /**
     * [endY description]
     *
     * @todo Description
     * @param value End Y
     */
    set: function set(value) {
      this.setPropertyValue("endY", value, true);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(SankeyLink.prototype, "linkWidth", {
    /**
     * @return [description]
     */
    get: function get() {
      return this.getPropertyValue("linkWidth");
    },

    /**
     * [linkWidth description]
     *
     * @todo Description
     * @param value [description]
     */
    set: function set(value) {
      this.setPropertyValue("linkWidth", value, true);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(SankeyLink.prototype, "controlPointDistance", {
    /**
     * @return relative control point distance
     */
    get: function get() {
      return this.getPropertyValue("controlPointDistance");
    },

    /**
     * Distance of control point of a link, defines relative distance from a node at which linke should bend
     * @default 0.2
     * @param value
     */
    set: function set(value) {
      this.setPropertyValue("controlPointDistance", value, true);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(SankeyLink.prototype, "tension", {
    /**
     * @return tension value
     */
    get: function get() {
      return this.getPropertyValue("tension");
    },

    /**
     * Tension of a spline, 1 would make the link to have sharp edges
     * @default 0.8
     * @param value
     */
    set: function set(value) {
      this.setPropertyValue("tension", value, true);
    },
    enumerable: true,
    configurable: true
  });
  return SankeyLink;
}(_FlowDiagramLink__WEBPACK_IMPORTED_MODULE_1__["FlowDiagramLink"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_2__["registry"].registeredClasses["SankeyLink"] = SankeyLink;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/SankeyNode.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/elements/SankeyNode.js ***!
  \**********************************************************************************/
/*! exports provided: SankeyNode */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SankeyNode", function() { return SankeyNode; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _FlowDiagramNode__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./FlowDiagramNode */ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/FlowDiagramNode.js");
/* harmony import */ var _LabelBullet__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./LabelBullet */ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/LabelBullet.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_utils_InterfaceColorSet__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/utils/InterfaceColorSet */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/InterfaceColorSet.js");
/* harmony import */ var _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core/utils/Iterator */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Iterator.js");
/* harmony import */ var _core_utils_Type__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core/utils/Type */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Type.js");
/* harmony import */ var _core_utils_Utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../core/utils/Utils */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Utils.js");
/**
 * SankeyNode module
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */








/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Creates a node in a Sankey Diagram.
 *
 * A Sankey node is a block with a value, which represents its size on the
 * diagram.
 *
 * Nodes are connected via [[SankeyLink]] elements.
 *
 * @see {@link ISankeyNodeEvents} for a list of available events
 * @see {@link ISankeyNodeAdapters} for a list of available Adapters
 * @important
 */

var SankeyNode =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(SankeyNode, _super);
  /**
   * Constructor
   */


  function SankeyNode() {
    var _this = _super.call(this) || this;
    /**
     * [nextInCoord description]
     *
     * @ignore Exclude from docs
     * @todo Description
     */


    _this.nextInCoord = 0;
    /**
     * [nextOutCoord description]
     *
     * @ignore Exclude from docs
     * @todo Description
     */

    _this.nextOutCoord = 0;
    _this.className = "SankeyNode";
    _this.width = 10;
    _this.height = 10;

    var nameLabel = _this.createChild(_LabelBullet__WEBPACK_IMPORTED_MODULE_2__["LabelBullet"]);

    nameLabel.shouldClone = false; //@should we auto update these locations if position is changed?

    nameLabel.locationX = 1;
    nameLabel.locationY = 0.5;
    nameLabel.label.text = "{name}"; //nameLabel.label.textElement.hideOversized = false;

    nameLabel.width = 150;
    nameLabel.height = 150;
    nameLabel.label.horizontalCenter = "left";
    nameLabel.label.padding(0, 5, 0, 5);
    _this.nameLabel = nameLabel;

    var valueLabel = _this.createChild(_LabelBullet__WEBPACK_IMPORTED_MODULE_2__["LabelBullet"]);

    valueLabel.shouldClone = false;
    valueLabel.label.hideOversized = false;
    valueLabel.locationX = 0.5;
    valueLabel.locationY = 0.5;
    valueLabel.width = 150;
    valueLabel.height = 150; //valueLabel.label.text = "{value}";

    valueLabel.label.horizontalCenter = "middle";
    _this.valueLabel = valueLabel;
    var hiddenState = _this.hiddenState;
    hiddenState.properties.fill = new _core_utils_InterfaceColorSet__WEBPACK_IMPORTED_MODULE_4__["InterfaceColorSet"]().getFor("disabledBackground");
    hiddenState.properties.opacity = 0.5;
    hiddenState.properties.visible = true;

    _this.background.hiddenState.copyFrom(hiddenState);

    return _this;
  }
  /**
   * Invalidates all links, attached to this node.
   *
   * @ignore Exclude from docs
   */


  SankeyNode.prototype.invalidateLinks = function () {
    var _this = this;

    _super.prototype.invalidateLinks.call(this);

    this.nextInCoord = 0;
    this.nextOutCoord = 0;
    var chart = this.chart;

    if (chart) {
      var orientation_1 = chart.orientation;

      if (this._incomingSorted) {
        _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_5__["each"](this._incomingSorted, function (dataItem) {
          var link = dataItem.link;
          var value = dataItem.getWorkingValue("value");

          if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_6__["isNumber"](value)) {
            link.parent = _this.chart.linksContainer;
            var x = void 0;
            var y = void 0;
            var angle = void 0;

            if (orientation_1 == "horizontal") {
              x = _this.pixelX + _this.dx;
              y = _this.nextInCoord + _this.pixelY + _this.dy;
              angle = 0;
            } else {
              y = _this.pixelY + _this.dy;
              x = _this.nextInCoord + _this.pixelX + _this.dx;
              angle = 90;
            }

            link.endX = x;
            link.endY = y;
            link.startAngle = angle;
            link.endAngle = angle;
            link.gradient.rotation = angle;
            link.linkWidth = value * chart.valueHeight;

            if (!dataItem.fromNode) {
              if (orientation_1 == "horizontal") {
                link.maxWidth = 200;
                link.startX = _this.pixelX + _this.dx - link.maxWidth;
                link.startY = link.endY;
              } else {
                link.maxHeight = 200;
                link.startX = link.endX;
                link.startY = _this.pixelY + _this.dy - link.maxHeight;
              } // TODO is this needed ?


              _core_utils_Utils__WEBPACK_IMPORTED_MODULE_7__["used"](link.gradient);
              link.fill = dataItem.toNode.color;
              var stop_1 = link.gradient.stops.getIndex(0);

              if (stop_1) {
                if (link.colorMode == "gradient") {
                  stop_1.color = _this.color;
                }

                stop_1.opacity = 0;
                link.fill = link.gradient;
                link.stroke = link.gradient;
                link.gradient.validate();
              }
            } //link.validate();


            _this.nextInCoord += link.linkWidth;
          }
        });
      }

      if (this._outgoingSorted) {
        _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_5__["each"](this._outgoingSorted, function (dataItem) {
          var link = dataItem.link;
          link.parent = _this.chart.linksContainer;
          var value = dataItem.getWorkingValue("value");

          if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_6__["isNumber"](value)) {
            var x = void 0;
            var y = void 0;
            var angle = void 0;

            if (orientation_1 == "horizontal") {
              angle = 0;
              x = _this.pixelX + _this.pixelWidth + _this.dx - 1;
              y = _this.nextOutCoord + _this.pixelY + _this.dy;
            } else {
              angle = 90;
              x = _this.nextOutCoord + _this.pixelX + _this.dx;
              y = _this.pixelY + _this.pixelHeight + _this.dy - 1;
            }

            link.startX = x;
            link.startY = y;
            link.startAngle = angle;
            link.endAngle = angle;
            link.gradient.rotation = angle;
            link.linkWidth = value * _this.chart.valueHeight;

            if (!dataItem.toNode) {
              if (orientation_1 == "horizontal") {
                link.maxWidth = 200;
                link.endX = _this.pixelX + link.maxWidth + _this.dx;
                link.endY = link.startY;
              } else {
                link.maxHeight = 200;
                link.endX = link.startX;
                link.endY = _this.pixelY + link.maxHeight + _this.dy;
              }

              link.opacity = _this.opacity;
              var stop_2 = link.gradient.stops.getIndex(1);

              if (stop_2) {
                if (link.colorMode == "gradient") {
                  stop_2.color = _this.color;
                }

                stop_2.opacity = 0;
                link.fill = link.gradient;
                link.stroke = link.gradient;
                link.gradient.validate();
              }
            } //link.validate();


            _this.nextOutCoord += link.linkWidth;
          }
        });
      }
    }

    this.positionBullet(this.nameLabel);
    this.positionBullet(this.valueLabel);
  };
  /**
   * Positions the bullet so it is centered within the node element.
   *
   * @param bullet  Target bullet
   */


  SankeyNode.prototype.positionBullet = function (bullet) {
    if (bullet) {
      bullet.x = this.measuredWidth * bullet.locationX;
      bullet.y = this.measuredHeight * bullet.locationY;
    }
  };

  Object.defineProperty(SankeyNode.prototype, "level", {
    /**
     * @return Level
     */
    get: function get() {
      return this.getPropertyValue("level");
    },

    /**
     * A level node is displayed at. (0 - ...)
     *
     * Levels are measured from left to right.
     *
     * The nodes in the left-most column will have `level = 0`.
     *
     * Nodes in second column - `level = 1`, etc.
     *
     * @param value  Level
     */
    set: function set(value) {
      this.setPropertyValue("level", value, true);
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Copies properties and labels from another [[SankeyNode]].
   *
   * @param source  Source node
   */

  SankeyNode.prototype.copyFrom = function (source) {
    _super.prototype.copyFrom.call(this, source);

    this.nameLabel.copyFrom(source.nameLabel);
    this.valueLabel.copyFrom(source.valueLabel);
  };

  return SankeyNode;
}(_FlowDiagramNode__WEBPACK_IMPORTED_MODULE_1__["FlowDiagramNode"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_3__["registry"].registeredClasses["SankeyNode"] = SankeyNode;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/Tick.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/elements/Tick.js ***!
  \****************************************************************************/
/*! exports provided: Tick */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Tick", function() { return Tick; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _core_Sprite__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core/Sprite */ "./node_modules/@amcharts/amcharts4/.internal/core/Sprite.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_utils_InterfaceColorSet__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/utils/InterfaceColorSet */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/InterfaceColorSet.js");
/**
 * Tick module
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */




/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * A basic Tick class.
 *
 * A tick is a short dash, mainly connecting an object like axis or slice to
 * it's textual label.
 *
 * @see {@link ITickEvents} for a list of available events
 * @see {@link ITickAdapters} for a list of available Adapters
 * @important
 */

var Tick =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(Tick, _super);
  /**
   * Constructor
   */


  function Tick() {
    var _this = _super.call(this) || this;

    _this.className = "Tick";
    var interfaceColors = new _core_utils_InterfaceColorSet__WEBPACK_IMPORTED_MODULE_3__["InterfaceColorSet"]();
    _this.fillOpacity = 0;
    _this.length = 6;
    _this.strokeOpacity = 0.2;
    _this.stroke = interfaceColors.getFor("grid");
    _this.isMeasured = false;
    _this.nonScalingStroke = true;

    _this.applyTheme();

    return _this;
  }

  Object.defineProperty(Tick.prototype, "length", {
    /**
     * @return Length (px)
     */
    get: function get() {
      if (this.disabled) {
        return 0;
      }

      return this.getPropertyValue("length");
    },

    /**
     * Length of the tick in pixels.
     *
     * @param value  Length (px)
     */
    set: function set(value) {
      this.setPropertyValue("length", value, true);
    },
    enumerable: true,
    configurable: true
  });
  return Tick;
}(_core_Sprite__WEBPACK_IMPORTED_MODULE_1__["Sprite"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_2__["registry"].registeredClasses["Tick"] = Tick;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/XYChartScrollbar.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/elements/XYChartScrollbar.js ***!
  \****************************************************************************************/
/*! exports provided: XYChartScrollbar */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "XYChartScrollbar", function() { return XYChartScrollbar; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _core_elements_Scrollbar__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core/elements/Scrollbar */ "./node_modules/@amcharts/amcharts4/.internal/core/elements/Scrollbar.js");
/* harmony import */ var _core_Sprite__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/Sprite */ "./node_modules/@amcharts/amcharts4/.internal/core/Sprite.js");
/* harmony import */ var _core_utils_List__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/utils/List */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/List.js");
/* harmony import */ var _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/utils/Disposer */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Disposer.js");
/* harmony import */ var _types_XYChart__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../types/XYChart */ "./node_modules/@amcharts/amcharts4/.internal/charts/types/XYChart.js");
/* harmony import */ var _axes_ValueAxis__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../axes/ValueAxis */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/ValueAxis.js");
/* harmony import */ var _axes_DateAxis__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../axes/DateAxis */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/DateAxis.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_utils_InterfaceColorSet__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../core/utils/InterfaceColorSet */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/InterfaceColorSet.js");
/* harmony import */ var _core_rendering_filters_DesaturateFilter__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../core/rendering/filters/DesaturateFilter */ "./node_modules/@amcharts/amcharts4/.internal/core/rendering/filters/DesaturateFilter.js");
/* harmony import */ var _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../core/utils/Iterator */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Iterator.js");
/* harmony import */ var _core_utils_Type__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../core/utils/Type */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Type.js");
/* harmony import */ var _core_rendering_Path__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../core/rendering/Path */ "./node_modules/@amcharts/amcharts4/.internal/core/rendering/Path.js");
/* harmony import */ var _core_utils_Utils__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../core/utils/Utils */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Utils.js");
/* harmony import */ var _core_utils_Percent__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../core/utils/Percent */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Percent.js");
/* harmony import */ var _core_utils_Color__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../core/utils/Color */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Color.js");
/* harmony import */ var _core_Options__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../core/Options */ "./node_modules/@amcharts/amcharts4/.internal/core/Options.js");
/**
 * A module with functionality for buildin a scrollbar with an XY graph in it.
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */


















/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * A special version of the Scrollbar that has an XY chart in it.
 *
 * Used mainly as an advanced scrollbar with a preview for other XY charts.
 *
 * However, can be used as standalone element.
 *
 * @see {@link IXYChartScrollbarEvents} for a list of available events
 * @see {@link IXYChartScrollbarAdapters} for a list of available Adapters
 * @important
 */

var XYChartScrollbar =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(XYChartScrollbar, _super);
  /**
   * Constructor
   */


  function XYChartScrollbar() {
    var _this = _super.call(this) || this;
    /**
     * A chart element Scrollbar is for.
     */


    _this._chart = new _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_4__["MutableValueDisposer"]();
    _this.className = "XYChartScrollbar";
    var interfaceColors = new _core_utils_InterfaceColorSet__WEBPACK_IMPORTED_MODULE_9__["InterfaceColorSet"]();

    _this.padding(0, 0, 0, 0);

    var scrollbarChart = _this.createChild(_types_XYChart__WEBPACK_IMPORTED_MODULE_5__["XYChart"]);

    scrollbarChart.shouldClone = false;
    scrollbarChart.margin(0, 0, 0, 0);
    scrollbarChart.padding(0, 0, 0, 0);
    scrollbarChart.interactionsEnabled = false;
    _this._scrollbarChart = scrollbarChart;

    if (!_core_utils_Utils__WEBPACK_IMPORTED_MODULE_14__["isIE"]()) {
      var filter = new _core_rendering_filters_DesaturateFilter__WEBPACK_IMPORTED_MODULE_10__["DesaturateFilter"]();
      filter.filterUnits = "userSpaceOnUse";
      scrollbarChart.plotContainer.filters.push(filter);
    }

    _this._disposers.push(_this._scrollbarChart);

    _this.minHeight = 60;
    _this.minWidth = 60;

    var unselectedOverlay = _this.createChild(_core_Sprite__WEBPACK_IMPORTED_MODULE_2__["Sprite"]);

    unselectedOverlay.shouldClone = false;
    unselectedOverlay.setElement(_this.paper.add("path"));
    unselectedOverlay.fill = interfaceColors.getFor("background");
    unselectedOverlay.fillOpacity = 0.8;
    unselectedOverlay.interactionsEnabled = false;
    unselectedOverlay.isMeasured = false;
    unselectedOverlay.toBack();
    _this._unselectedOverlay = unselectedOverlay;

    _this._disposers.push(_this._unselectedOverlay);

    scrollbarChart.toBack();

    _this.background.cornerRadius(0, 0, 0, 0);

    var thumbBackground = _this.thumb.background;
    thumbBackground.cornerRadius(0, 0, 0, 0);
    thumbBackground.fillOpacity = 0;
    thumbBackground.fill = interfaceColors.getFor("background");
    var hoverState = thumbBackground.states.getKey("hover");

    if (hoverState) {
      hoverState.properties.fillOpacity = 0.2;
    }

    var downState = thumbBackground.states.getKey("down");

    if (downState) {
      downState.properties.fillOpacity = 0.4;
    }

    _this._disposers.push(_this._chart);

    _this.applyTheme();

    return _this;
  }

  Object.defineProperty(XYChartScrollbar.prototype, "series", {
    /**
     * A list of series that are used to draw graph(s) on the scrollbar.
     *
     * @readonly
     * @return Series
     */
    get: function get() {
      if (!this._series) {
        this._series = new _core_utils_List__WEBPACK_IMPORTED_MODULE_3__["List"]();

        this._disposers.push(this._series.events.on("inserted", this.handleSeriesAdded, this, false));

        this._disposers.push(this._series.events.on("removed", this.handleSeriesRemoved, this, false));
      }

      return this._series;
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Decorates a new series when they are pushed into a `series` list.
   *
   * @param event Event
   */

  XYChartScrollbar.prototype.handleSeriesAdded = function (event) {
    var _this = this;

    var sourceSeries = event.newValue;

    if (!sourceSeries.xAxis || !sourceSeries.yAxis) {
      return;
    }

    var scrollbarChart = this.scrollbarChart;
    scrollbarChart.zoomOutButton.disabled = true;
    this.chart = sourceSeries.chart;
    scrollbarChart.dateFormatter.inputDateFormat = this.chart.dateFormatter.inputDateFormat; // Ensure that scrollbar chart shares the same locale as parent chart

    scrollbarChart.language.locale = this.chart.language.locale;
    var addXAxis = true;
    var addYAxis = true; // check if we haven't added clone of x or y axis before

    _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_11__["each"](this.series.iterator(), function (series) {
      if (series != sourceSeries) {
        if (series.xAxis == sourceSeries.xAxis && _this.scrollbarChart.xAxes.length > 0) {
          addXAxis = false;
        }

        if (series.yAxis == sourceSeries.yAxis && _this.scrollbarChart.yAxes.length > 0) {
          addYAxis = false;
        }
      }
    });
    sourceSeries.events.on("beforedisposed", function () {
      _this.series.removeValue(sourceSeries);
    });
    var interfaceColors = new _core_utils_InterfaceColorSet__WEBPACK_IMPORTED_MODULE_9__["InterfaceColorSet"]();
    var series = sourceSeries.clone();

    if (_core_Options__WEBPACK_IMPORTED_MODULE_17__["options"].onlyShowOnViewport || _core_Options__WEBPACK_IMPORTED_MODULE_17__["options"].queue) {
      this.addDisposer(this.chart.events.on("removedfromqueue", function () {
        scrollbarChart.invalidateData();
      }));
    }

    if (_core_utils_Utils__WEBPACK_IMPORTED_MODULE_14__["isIE"]()) {
      series.stroke = Object(_core_utils_Color__WEBPACK_IMPORTED_MODULE_16__["color"])("#aaaaaa");
      series.fill = series.stroke;
      series.propertyFields.fill = undefined;
      series.propertyFields.stroke = undefined;
    }

    sourceSeries.scrollbarSeries = series;

    if (addXAxis) {
      var xAxis = sourceSeries.xAxis.clone();
      scrollbarChart.xAxes.moveValue(xAxis);
      xAxis.title.disabled = true;
      xAxis.rangeChangeDuration = 0; //xAxis.id = sourceSeries.uid;

      var renderer = xAxis.renderer;
      renderer.ticks.template.disabled = true;
      renderer.inside = true;
      renderer.labels.template.inside = true;
      renderer.line.strokeOpacity = 0;
      renderer.minLabelPosition = 0.02;
      renderer.maxLabelPosition = 0.98;
      renderer.line.disabled = true;
      renderer.axisFills.template.disabled = true;
      renderer.baseGrid.disabled = true;
      renderer.grid.template.strokeOpacity = 0.05;
      renderer.minWidth = undefined;
      renderer.minHeight = undefined;
      renderer.padding(0, 0, 0, 0);
      renderer.chart = scrollbarChart;
      renderer.margin(0, 0, 0, 0);
      xAxis.width = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_15__["percent"])(100);
      var labelsTemplate = renderer.labels.template;
      labelsTemplate.fillOpacity = 0.5;
      xAxis.maxZoomCount = undefined;
      xAxis.minZoomCount = undefined;

      if (xAxis instanceof _axes_DateAxis__WEBPACK_IMPORTED_MODULE_7__["DateAxis"]) {
        var vAxis_1 = xAxis;
        var sourceAxis = sourceSeries.xAxis;
        vAxis_1.groupCount = sourceAxis.groupCount * 5;
        vAxis_1.min = undefined;
        vAxis_1.max = undefined;

        this._disposers.push(vAxis_1.clonedFrom.events.on("extremeschanged", function () {
          if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_12__["isNumber"](vAxis_1.clonedFrom.minDefined)) {
            vAxis_1.min = vAxis_1.clonedFrom.minDefined;
          }

          if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_12__["isNumber"](vAxis_1.clonedFrom.maxDefined)) {
            vAxis_1.max = vAxis_1.clonedFrom.maxDefined;
          }
        }, undefined, false));
      } else if (xAxis instanceof _axes_ValueAxis__WEBPACK_IMPORTED_MODULE_6__["ValueAxis"]) {
        var vAxis_2 = xAxis;
        vAxis_2.min = undefined;
        vAxis_2.max = undefined;

        if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_12__["isNumber"](vAxis_2.clonedFrom.minDefined)) {
          vAxis_2.min = undefined;
        }

        if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_12__["isNumber"](vAxis_2.clonedFrom.maxDefined)) {
          vAxis_2.max = undefined;
        }

        this._disposers.push(vAxis_2.clonedFrom.events.on("extremeschanged", function () {
          if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_12__["isNumber"](vAxis_2.clonedFrom.minDefined)) {
            vAxis_2.min = vAxis_2.clonedFrom.min;
          }

          if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_12__["isNumber"](vAxis_2.clonedFrom.maxDefined)) {
            vAxis_2.max = vAxis_2.clonedFrom.max;
          }
        }, undefined, false));
      }

      series.xAxis = xAxis;
    } else {
      this.scrollbarChart.xAxes.each(function (xAxis) {
        if (xAxis.clonedFrom == sourceSeries.xAxis) {
          series.xAxis = xAxis;
        }
      });
    }

    if (addYAxis) {
      var yAxis = sourceSeries.yAxis.clone();
      scrollbarChart.yAxes.moveValue(yAxis);
      yAxis.title.disabled = true;
      yAxis.rangeChangeDuration = 0;
      var renderer = yAxis.renderer;
      renderer.ticks.template.disabled = true;
      renderer.inside = true;
      renderer.labels.template.inside = true;
      renderer.line.strokeOpacity = 0;
      renderer.minLabelPosition = 0.02;
      renderer.maxLabelPosition = 0.98;
      renderer.line.disabled = true;
      renderer.axisFills.template.disabled = true;
      renderer.grid.template.stroke = interfaceColors.getFor("background");
      renderer.baseGrid.disabled = true;
      renderer.grid.template.strokeOpacity = 0.05;
      renderer.minWidth = undefined;
      renderer.minHeight = undefined;
      renderer.chart = scrollbarChart;
      renderer.padding(0, 0, 0, 0);
      renderer.margin(0, 0, 0, 0);
      yAxis.height = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_15__["percent"])(100);
      var labelsTemplate = renderer.labels.template;
      labelsTemplate.fillOpacity = 0.5;
      series.yAxis = yAxis;
      yAxis.maxZoomCount = undefined;
      yAxis.minZoomCount = undefined;

      if (yAxis instanceof _axes_DateAxis__WEBPACK_IMPORTED_MODULE_7__["DateAxis"]) {
        var vAxis_3 = yAxis;
        vAxis_3.min = undefined;
        vAxis_3.max = undefined;
        var sourceAxis = sourceSeries.yAxis;
        yAxis.groupCount = sourceAxis.groupCount * 5;

        this._disposers.push(vAxis_3.clonedFrom.events.on("extremeschanged", function () {
          if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_12__["isNumber"](vAxis_3.clonedFrom.minDefined)) {
            vAxis_3.min = vAxis_3.clonedFrom.minDefined;
          }

          if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_12__["isNumber"](vAxis_3.clonedFrom.maxDefined)) {
            vAxis_3.max = vAxis_3.clonedFrom.maxDefined;
          }
        }));
      } else if (yAxis instanceof _axes_ValueAxis__WEBPACK_IMPORTED_MODULE_6__["ValueAxis"]) {
        var vAxis_4 = yAxis;
        vAxis_4.min = undefined;
        vAxis_4.max = undefined;

        if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_12__["isNumber"](vAxis_4.clonedFrom.minDefined)) {
          vAxis_4.min = undefined;
        }

        if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_12__["isNumber"](vAxis_4.clonedFrom.maxDefined)) {
          vAxis_4.max = undefined;
        }

        this._disposers.push(vAxis_4.clonedFrom.events.on("extremeschanged", function () {
          if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_12__["isNumber"](vAxis_4.clonedFrom.minDefined)) {
            vAxis_4.min = vAxis_4.clonedFrom.minDefined;
          }

          if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_12__["isNumber"](vAxis_4.clonedFrom.maxDefined)) {
            vAxis_4.max = vAxis_4.clonedFrom.maxDefined;
          }
        }));
      }
    } else {
      this.scrollbarChart.yAxes.each(function (yAxis) {
        if (yAxis.clonedFrom == sourceSeries.yAxis) {
          series.yAxis = yAxis;
        }
      });
    }

    series.rangeChangeDuration = 0;
    series.interpolationDuration = 0;
    series.defaultState.transitionDuration = 0;
    series.showOnInit = false;

    this._disposers.push(series.events.on("validated", this.zoomOutAxes, this, false)); // data might be set drectly on series


    this._disposers.push(sourceSeries.events.on("datavalidated", function () {
      if (series.data != sourceSeries.data) {
        // data setter doesn't check this
        series.data = sourceSeries.data;
      }
    }, undefined, false));

    series.defaultState.properties.visible = true;
    scrollbarChart.series.push(series);
    this.updateByOrientation();
  };
  /**
   * @ignore
   */


  XYChartScrollbar.prototype.updateByOrientation = function () {
    var _this = this;

    if (this._scrollbarChart) {
      _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_11__["each"](this._scrollbarChart.xAxes.iterator(), function (xAxis) {
        var renderer = xAxis.renderer;

        if (_this.orientation == "vertical") {
          renderer.grid.template.disabled = true;
          renderer.labels.template.disabled = true;
          renderer.minGridDistance = 10;
        } else {
          renderer.grid.template.disabled = false;
          renderer.labels.template.disabled = false;
          renderer.minGridDistance = xAxis.clonedFrom.renderer.minGridDistance;
        }
      });
      _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_11__["each"](this._scrollbarChart.yAxes.iterator(), function (yAxis) {
        var renderer = yAxis.renderer;

        if (_this.orientation == "horizontal") {
          renderer.grid.template.disabled = true;
          renderer.labels.template.disabled = true;
          renderer.minGridDistance = 10;
        } else {
          renderer.grid.template.disabled = false;
          renderer.labels.template.disabled = false;
          renderer.minGridDistance = yAxis.clonedFrom.renderer.minGridDistance;
        }
      });
    }
  };
  /**
   * Cleans up after series are removed from Scrollbar.
   *
   * @param event  Event
   */


  XYChartScrollbar.prototype.handleSeriesRemoved = function (event) {
    var sourceSeries = event.oldValue;
    var scrollbarChart = this.scrollbarChart;
    scrollbarChart.series.each(function (series) {
      if (series && series.clonedFrom == sourceSeries) {
        scrollbarChart.series.removeValue(series);
      }
    });

    if (scrollbarChart.series.length == 0) {
      scrollbarChart.xAxes.clear();
      scrollbarChart.yAxes.clear();
    }

    try {
      sourceSeries.events.off("validated", this.zoomOutAxes, this);
    } catch (err) {}
  };

  Object.defineProperty(XYChartScrollbar.prototype, "scrollbarChart", {
    /**
     * A chart element that is used to display graphs in the Scrollbar.
     *
     * This is not the same as `chart`. It's a totally independent instance of
     * [[XYChart]] with separate config, series, etc.
     *
     * It can be configured just like any other [[XYChart]].
     *
     * @readonly
     * @return Scrollbar's internal chart
     */
    get: function get() {
      return this._scrollbarChart;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(XYChartScrollbar.prototype, "chart", {
    /**
     * @return Chart
     */
    get: function get() {
      return this._chart.get();
    },

    /**
     * A chart that Scrollbar belongs to.
     *
     * @param chart  Chart
     */
    set: function set(chart) {
      if (this._chart.get() !== chart) {
        this._chart.set(chart, chart.events.on("datavalidated", this.handleDataChanged, this, false));

        this.handleDataChanged();
        this._scrollbarChart.dataProvider = chart; // this makes scrollbar chart do not validate data untill charts' data is validated
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(XYChartScrollbar.prototype, "unselectedOverlay", {
    /**
     * A [[Sprite]] object representing overlay that is used to dim area of the
     * scrollbar that is currently not selected.
     *
     * Use its `fillOpacity` to set opacity of the fill, with `0` (zero)
     * completely disabling the dimming, and `1` making unselected area completely
     * blank.
     *
     * @since 4.6.1
     * @readonly
     * @return Unselected area curtain element
     */
    get: function get() {
      return this._unselectedOverlay;
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Updates Scrollbar's internal chart's data when the main chart's data
   * changes.
   *
   * @ignore Exclude from docs
   */

  XYChartScrollbar.prototype.handleDataChanged = function () {
    if (this.chart.data != this.scrollbarChart.data) {
      this.scrollbarChart.data = this.chart.data;
    } else {
      // add data is handled in XYChart
      // invalidating all data caused the problem: https://github.com/amcharts/amcharts4/issues/2096
      this.scrollbarChart.invalidateRawData();
    }
  };
  /**
   * Zooms out all axes on the internal chart.
   */


  XYChartScrollbar.prototype.zoomOutAxes = function () {
    var scrollbarChart = this.scrollbarChart;
    _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_11__["each"](scrollbarChart.xAxes.iterator(), function (x) {
      x.zoom({
        start: 0,
        end: 1
      }, true, true);
    });
    _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_11__["each"](scrollbarChart.yAxes.iterator(), function (y) {
      y.zoom({
        start: 0,
        end: 1
      }, true, true);
    });
  };
  /**
   * Updates scrollbar thumb.
   */


  XYChartScrollbar.prototype.updateThumb = function () {
    _super.prototype.updateThumb.call(this);

    if (this._unselectedOverlay) {
      var thumb = this.thumb;
      var x = thumb.pixelX || 0;
      var y = thumb.pixelY || 0;
      var w = thumb.pixelWidth || 0;
      var h = thumb.pixelHeight || 0;
      var path = "";

      if (this.orientation == "horizontal") {
        path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_13__["rectToPath"]({
          x: -1,
          y: 0,
          width: x,
          height: h
        });
        path += _core_rendering_Path__WEBPACK_IMPORTED_MODULE_13__["rectToPath"]({
          x: x + w,
          y: 0,
          width: (this.pixelWidth || 0) - x - w,
          height: h
        });
      } else {
        path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_13__["rectToPath"]({
          x: 0,
          y: 0,
          width: w,
          height: y
        });
        path += _core_rendering_Path__WEBPACK_IMPORTED_MODULE_13__["rectToPath"]({
          x: 0,
          y: y + h,
          width: w,
          height: (this.pixelHeight || 0) - y - h
        });
      }

      this._unselectedOverlay.path = path;
    }
  };
  /**
   * Processes JSON-based config before it is applied to the object.
   *
   * @ignore Exclude from docs
   * @param config  Config
   */


  XYChartScrollbar.prototype.processConfig = function (config) {
    if (config) {
      if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_12__["hasValue"](config.series) && _core_utils_Type__WEBPACK_IMPORTED_MODULE_12__["isArray"](config.series)) {
        for (var i = 0, len = config.series.length; i < len; i++) {
          var series = config.series[i];

          if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_12__["hasValue"](series) && _core_utils_Type__WEBPACK_IMPORTED_MODULE_12__["isString"](series)) {
            if (this.map.hasKey(series)) {
              config.series[i] = this.map.getKey(series);
            } else {
              throw Error("XYChartScrollbar error: Series with id `" + series + "` does not exist.");
            }
          }
        }
      }
    }

    _super.prototype.processConfig.call(this, config);
  };

  return XYChartScrollbar;
}(_core_elements_Scrollbar__WEBPACK_IMPORTED_MODULE_1__["Scrollbar"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_8__["registry"].registeredClasses["XYChartScrollbar"] = XYChartScrollbar;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/series/CandlestickSeries.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/series/CandlestickSeries.js ***!
  \***************************************************************************************/
/*! exports provided: CandlestickSeriesDataItem, CandlestickSeries */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CandlestickSeriesDataItem", function() { return CandlestickSeriesDataItem; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CandlestickSeries", function() { return CandlestickSeries; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _ColumnSeries__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ColumnSeries */ "./node_modules/@amcharts/amcharts4/.internal/charts/series/ColumnSeries.js");
/* harmony import */ var _core_Sprite__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/Sprite */ "./node_modules/@amcharts/amcharts4/.internal/core/Sprite.js");
/* harmony import */ var _elements_Candlestick__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../elements/Candlestick */ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/Candlestick.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_utils_InterfaceColorSet__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core/utils/InterfaceColorSet */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/InterfaceColorSet.js");
/* harmony import */ var _core_utils_Utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core/utils/Utils */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Utils.js");
/* harmony import */ var _core_utils_Object__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../core/utils/Object */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Object.js");
/* harmony import */ var _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../core/utils/Iterator */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Iterator.js");
/* harmony import */ var _core_utils_Type__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../core/utils/Type */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Type.js");
/**
 * Candlestick Series module.
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */










/**
 * ============================================================================
 * DATA ITEM
 * ============================================================================
 * @hidden
 */

/**
 * Defines a [[DataItem]] for [[CandlestickSeries]].
 *
 * @see {@link DataItem}
 */

var CandlestickSeriesDataItem =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(CandlestickSeriesDataItem, _super);
  /**
   * Defines a type of [[Component]] this data item is used for
   * @todo Disabled to work around TS bug (see if we can re-enable it again)
   */
  //public _component!: CandlestickSeries;

  /**
   * Constructor
   */


  function CandlestickSeriesDataItem() {
    var _this = _super.call(this) || this;

    _this.values.lowValueX = {};
    _this.values.lowValueY = {};
    _this.values.highValueX = {};
    _this.values.highValueY = {};
    _this.className = "CandlestickSeriesDataItem";

    _this.applyTheme();

    return _this;
  }

  Object.defineProperty(CandlestickSeriesDataItem.prototype, "lowValueX", {
    /**
     * @return Value
     */
    get: function get() {
      return this.values.lowValueX.value;
    },

    /**
     * Low value for horizontal axis.
     *
     * @param value  Value
     */
    set: function set(value) {
      this.setValue("lowValueX", value);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(CandlestickSeriesDataItem.prototype, "lowValueY", {
    /**
     * @return Value
     */
    get: function get() {
      return this.values.lowValueY.value;
    },

    /**
     * Low value for vertical axis.
     *
     * @param value  Value
     */
    set: function set(value) {
      this.setValue("lowValueY", value);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(CandlestickSeriesDataItem.prototype, "highValueX", {
    /**
     * @return Value
     */
    get: function get() {
      return this.values.highValueX.value;
    },

    /**
     * High value for horizontal axis.
     *
     * @param value  Value
     */
    set: function set(value) {
      this.setValue("highValueX", value);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(CandlestickSeriesDataItem.prototype, "highValueY", {
    /**
     * @return Value
     */
    get: function get() {
      return this.values.highValueY.value;
    },

    /**
     * High value for vertical axis.
     *
     * @param value  Value
     */
    set: function set(value) {
      this.setValue("highValueY", value);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(CandlestickSeriesDataItem.prototype, "closeValueX", {
    /**
     * @return Value
     */
    get: function get() {
      return this.values.valueX.value;
    },

    /**
     * Close value for horizontal axis.
     *
     * This is an alias for `valueX` added for convenience only.
     *
     * @param value  Value
     */
    set: function set(value) {
      this.setValue("valueX", value);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(CandlestickSeriesDataItem.prototype, "closeValueY", {
    /**
     * @return Value
     */
    get: function get() {
      return this.values.valueY.value;
    },

    /**
     * Close value for vertical axis.
     *
     * This is an alias for `valueX` added for convenience only.
     *
     * @param value  Value
     */
    set: function set(value) {
      this.setValue("valueY", value);
    },
    enumerable: true,
    configurable: true
  });
  return CandlestickSeriesDataItem;
}(_ColumnSeries__WEBPACK_IMPORTED_MODULE_1__["ColumnSeriesDataItem"]);


/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Defines [[Series]] for a candlestick graph.
 *
 * @see {@link ICandlestickSeriesEvents} for a list of available Events
 * @see {@link ICandlestickSeriesAdapters} for a list of available Adapters
 * @todo Example
 * @important
 */

var CandlestickSeries =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(CandlestickSeries, _super);
  /**
   * Constructor
   */


  function CandlestickSeries() {
    var _this = _super.call(this) || this;

    _this.className = "CandlestickSeries";
    _this.groupFields.lowValueX = "low";
    _this.groupFields.lowValueY = "low";
    _this.groupFields.highValueX = "high";
    _this.groupFields.highValueY = "high";
    _this.strokeOpacity = 1;
    var interfaceColors = new _core_utils_InterfaceColorSet__WEBPACK_IMPORTED_MODULE_5__["InterfaceColorSet"]();
    var positiveColor = interfaceColors.getFor("positive");
    var negativeColor = interfaceColors.getFor("negative");
    _this.dropFromOpenState.properties.fill = negativeColor;
    _this.dropFromOpenState.properties.stroke = negativeColor;
    _this.riseFromOpenState.properties.fill = positiveColor;
    _this.riseFromOpenState.properties.stroke = positiveColor;

    _this.applyTheme();

    return _this;
  }
  /**
   * Sets defaults that instantiate some objects that rely on parent, so they
   * cannot be set in constructor.
   */


  CandlestickSeries.prototype.applyInternalDefaults = function () {
    _super.prototype.applyInternalDefaults.call(this);

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_9__["hasValue"](this.readerTitle)) {
      this.readerTitle = this.language.translate("Candlestick Series");
    }
  };
  /**
   * Returns a new/empty DataItem of the type appropriate for this object.
   *
   * @see {@link DataItem}
   * @return Data Item
   */


  CandlestickSeries.prototype.createDataItem = function () {
    return new CandlestickSeriesDataItem();
  };
  /**
   * Validates data item's element, effectively redrawing it.
   *
   * @ignore Exclude from docs
   * @param dataItem  Data item
   */


  CandlestickSeries.prototype.validateDataElementReal = function (dataItem) {
    _super.prototype.validateDataElementReal.call(this, dataItem);

    this.validateCandlestick(dataItem);
  };

  CandlestickSeries.prototype.validateCandlestick = function (dataItem) {
    var column = dataItem.column;

    if (column) {
      var lowLine_1 = column.lowLine;
      var highLine_1 = column.highLine;

      if (this.baseAxis == this.xAxis) {
        var x = column.pixelWidth / 2;
        lowLine_1.x = x;
        highLine_1.x = x;
        var open_1 = dataItem.getWorkingValue(this.yOpenField);
        var close_1 = dataItem.getWorkingValue(this.yField);
        var yOpen = this.yAxis.getY(dataItem, this.yOpenField);
        var yClose = this.yAxis.getY(dataItem, this.yField);
        var yLow = this.yAxis.getY(dataItem, this.yLowField);
        var yHigh = this.yAxis.getY(dataItem, this.yHighField);
        var pixelY = column.pixelY;
        lowLine_1.y1 = yLow - pixelY;
        highLine_1.y1 = yHigh - pixelY;

        if (open_1 < close_1) {
          lowLine_1.y2 = yOpen - pixelY;
          highLine_1.y2 = yClose - pixelY;
        } else {
          lowLine_1.y2 = yClose - pixelY;
          highLine_1.y2 = yOpen - pixelY;
        }
      }

      if (this.baseAxis == this.yAxis) {
        var y = column.pixelHeight / 2;
        lowLine_1.y = y;
        highLine_1.y = y;
        var open_2 = dataItem.getWorkingValue(this.xOpenField);
        var close_2 = dataItem.getWorkingValue(this.xField);
        var xOpen = this.xAxis.getX(dataItem, this.xOpenField);
        var xClose = this.xAxis.getX(dataItem, this.xField);
        var xLow = this.xAxis.getX(dataItem, this.xLowField);
        var xHigh = this.xAxis.getX(dataItem, this.xHighField);
        var pixelX = column.pixelX;
        lowLine_1.x1 = xLow - pixelX;
        highLine_1.x1 = xHigh - pixelX;

        if (open_2 < close_2) {
          lowLine_1.x2 = xOpen - pixelX;
          highLine_1.x2 = xClose - pixelX;
        } else {
          lowLine_1.x2 = xClose - pixelX;
          highLine_1.x2 = xOpen - pixelX;
        }
      }

      _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_8__["each"](this.axisRanges.iterator(), function (axisRange) {
        // LOW LINE
        var rangeColumn = dataItem.rangesColumns.getKey(axisRange.uid);

        if (rangeColumn) {
          var rangeLowLine = rangeColumn.lowLine;
          rangeLowLine.x = lowLine_1.x;
          rangeLowLine.y = lowLine_1.y;
          rangeLowLine.x1 = lowLine_1.x1;
          rangeLowLine.x2 = lowLine_1.x2;
          rangeLowLine.y1 = lowLine_1.y1;
          rangeLowLine.y2 = lowLine_1.y2; // HIGH LINE

          var rangehighLine = rangeColumn.highLine;
          rangehighLine.x = highLine_1.x;
          rangehighLine.y = highLine_1.y;
          rangehighLine.x1 = highLine_1.x1;
          rangehighLine.x2 = highLine_1.x2;
          rangehighLine.y1 = highLine_1.y1;
          rangehighLine.y2 = highLine_1.y2;
        }
      });
    }
  };

  Object.defineProperty(CandlestickSeries.prototype, "xLowField", {
    /**
     * A data field to look for "low" value for horizontal axis.
     *
     * @ignore Exclude from docs
     * @return Field name
     */
    get: function get() {
      return this._xLowField;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(CandlestickSeries.prototype, "yLowField", {
    /**
     * A data field to look for "low" value for vertical axis.
     *
     * @ignore Exclude from docs
     * @return Field name
     */
    get: function get() {
      return this._yLowField;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(CandlestickSeries.prototype, "xHighField", {
    /**
     * A data field to look for "high" value for horizontal axis.
     *
     * @ignore Exclude from docs
     * @return Field name
     */
    get: function get() {
      return this._xHighField;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(CandlestickSeries.prototype, "yHighField", {
    /**
     * A data field to look for "high" value for vertical axis.
     *
     * @ignore Exclude from docs
     * @return Field name
     */
    get: function get() {
      return this._yHighField;
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Sets up which data fields to use for data access.
   */

  CandlestickSeries.prototype.defineFields = function () {
    _super.prototype.defineFields.call(this);

    var xAxis = this.xAxis;
    var yAxis = this.yAxis;

    if (xAxis && yAxis) {
      if (this.baseAxis == xAxis) {
        var yAxisFieldName = _core_utils_Utils__WEBPACK_IMPORTED_MODULE_6__["capitalize"](yAxis.axisFieldName);
        this._yLowField = "low" + yAxisFieldName + "Y";
        this._yHighField = "high" + yAxisFieldName + "Y";
      }

      if (this.baseAxis == yAxis) {
        var xAxisFieldName = _core_utils_Utils__WEBPACK_IMPORTED_MODULE_6__["capitalize"](xAxis.axisFieldName);
        this._xLowField = "low" + xAxisFieldName + "X";
        this._xHighField = "high" + xAxisFieldName + "X";
      }

      this.addValueField(xAxis, this._xValueFields, this._xLowField);
      this.addValueField(xAxis, this._xValueFields, this._xHighField);
      this.addValueField(yAxis, this._yValueFields, this._yLowField);
      this.addValueField(yAxis, this._yValueFields, this._yHighField);
    }
  };
  /**
   * Creates elements in related legend container, that mimics the look of this
   * Series.
   *
   * @ignore Exclude from docs
   * @param marker  Legend item container
   */


  CandlestickSeries.prototype.createLegendMarker = function (marker) {
    var w = marker.pixelWidth;
    var h = marker.pixelHeight;
    marker.removeChildren();
    var column = marker.createChild(_elements_Candlestick__WEBPACK_IMPORTED_MODULE_3__["Candlestick"]);
    column.shouldClone = false;
    column.copyFrom(this.columns.template);
    var cw;
    var ch;
    var highLine = column.lowLine;
    var lowLine = column.highLine;

    if (this.baseAxis == this.yAxis) {
      cw = w / 3;
      ch = h;
      highLine.y = h / 2;
      lowLine.y = h / 2;
      highLine.x2 = w / 3;
      lowLine.x2 = w / 3;
      lowLine.x = w / 3 * 2;
      column.column.x = w / 3;
    } else {
      cw = w;
      ch = h / 3;
      highLine.x = w / 2;
      lowLine.x = w / 2;
      highLine.y2 = h / 3;
      lowLine.y2 = h / 3;
      lowLine.y = h / 3 * 2;
      column.column.y = h / 3;
    }

    column.width = cw;
    column.height = ch;
    _core_utils_Object__WEBPACK_IMPORTED_MODULE_7__["copyProperties"](this, marker, _core_Sprite__WEBPACK_IMPORTED_MODULE_2__["visualProperties"]);
    _core_utils_Object__WEBPACK_IMPORTED_MODULE_7__["copyProperties"](this.columns.template, column, _core_Sprite__WEBPACK_IMPORTED_MODULE_2__["visualProperties"]);
    column.stroke = this.riseFromOpenState.properties.stroke;
    column.fill = column.stroke;
    var legendDataItem = marker.dataItem;
    legendDataItem.color = column.fill;
    legendDataItem.colorOrig = column.fill;
  };
  /**
   * Returns an element to use for Candlestick
   * @ignore
   * @return Element.
   */


  CandlestickSeries.prototype.createColumnTemplate = function () {
    return new _elements_Candlestick__WEBPACK_IMPORTED_MODULE_3__["Candlestick"]();
  };

  return CandlestickSeries;
}(_ColumnSeries__WEBPACK_IMPORTED_MODULE_1__["ColumnSeries"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_4__["registry"].registeredClasses["CandlestickSeries"] = CandlestickSeries;
_core_Registry__WEBPACK_IMPORTED_MODULE_4__["registry"].registeredClasses["CandlestickSeriesDataItem"] = CandlestickSeriesDataItem;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/series/ColumnSeries.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/series/ColumnSeries.js ***!
  \**********************************************************************************/
/*! exports provided: ColumnSeriesDataItem, ColumnSeries */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ColumnSeriesDataItem", function() { return ColumnSeriesDataItem; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ColumnSeries", function() { return ColumnSeries; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _XYSeries__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./XYSeries */ "./node_modules/@amcharts/amcharts4/.internal/charts/series/XYSeries.js");
/* harmony import */ var _core_Sprite__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/Sprite */ "./node_modules/@amcharts/amcharts4/.internal/core/Sprite.js");
/* harmony import */ var _core_Container__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/Container */ "./node_modules/@amcharts/amcharts4/.internal/core/Container.js");
/* harmony import */ var _core_utils_List__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/utils/List */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/List.js");
/* harmony import */ var _core_utils_Dictionary__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core/utils/Dictionary */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Dictionary.js");
/* harmony import */ var _axes_ValueAxis__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../axes/ValueAxis */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/ValueAxis.js");
/* harmony import */ var _axes_CategoryAxis__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../axes/CategoryAxis */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/CategoryAxis.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _elements_Column__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../elements/Column */ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/Column.js");
/* harmony import */ var _core_elements_RoundedRectangle__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../core/elements/RoundedRectangle */ "./node_modules/@amcharts/amcharts4/.internal/core/elements/RoundedRectangle.js");
/* harmony import */ var _core_utils_Percent__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../core/utils/Percent */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Percent.js");
/* harmony import */ var _core_utils_Math__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../core/utils/Math */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Math.js");
/* harmony import */ var _core_utils_Object__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../core/utils/Object */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Object.js");
/* harmony import */ var _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../core/utils/Iterator */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Iterator.js");
/* harmony import */ var _core_utils_Array__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../core/utils/Array */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Array.js");
/* harmony import */ var _core_utils_Type__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../core/utils/Type */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Type.js");
/* harmony import */ var _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../core/utils/Disposer */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Disposer.js");
/**
 * Column series module.
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */


















/**
 * ============================================================================
 * DATA ITEM
 * ============================================================================
 * @hidden
 */

/**
 * Defines a [[DataItem]] for [[ColumnSeries]].
 *
 * @see {@link DataItem}
 */

var ColumnSeriesDataItem =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(ColumnSeriesDataItem, _super);
  /**
   * Constructor
   */


  function ColumnSeriesDataItem() {
    var _this = _super.call(this) || this;

    _this.className = "ColumnSeriesDataItem";
    _this.locations["dateX"] = 0.5;
    _this.locations["dateY"] = 0.5;
    _this.locations["categoryX"] = 0.5;
    _this.locations["categoryY"] = 0.5;

    _this.applyTheme();

    return _this;
  }

  Object.defineProperty(ColumnSeriesDataItem.prototype, "column", {
    /**
     * @return Column
     */
    get: function get() {
      return this._column;
    },

    /**
     * A column used to draw a column for this data item.
     *
     * @param column
     */
    set: function set(column) {
      this.setColumn(column);
    },
    enumerable: true,
    configurable: true
  });

  ColumnSeriesDataItem.prototype.setColumn = function (column) {
    var _this = this;

    if (this._column && column != this._column) {
      _core_utils_Array__WEBPACK_IMPORTED_MODULE_15__["remove"](this.sprites, this._column);
    }

    this._column = column;

    if (column) {
      var prevDataItem = column.dataItem;

      if (prevDataItem && prevDataItem != this) {
        prevDataItem.column = undefined;
      }

      this.addSprite(column);

      this._disposers.push(new _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_17__["Disposer"](function () {
        // TODO investigate why component is undefined
        // https://codepen.io/team/amcharts/pen/dac4be245d658233a6d7e5597df2208b?editors=0010
        if (_this.component) {
          _this.component.columns.removeValue(column);
        }
      }));
    }
  };

  Object.defineProperty(ColumnSeriesDataItem.prototype, "width", {
    get: function get() {
      var width = this.properties.width;

      if (this._adapterO) {
        width = this._adapterO.apply("width", width);
      }

      return width;
    },
    set: function set(value) {
      if (this.properties.width != value) {
        this.properties.width = value;

        if (this.component) {
          this.component.validateDataElement(this);
        }
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ColumnSeriesDataItem.prototype, "height", {
    get: function get() {
      var height = this.properties.height;

      if (this._adapterO) {
        height = this._adapterO.apply("height", height);
      }

      return height;
    },
    set: function set(value) {
      if (this.properties.height != value) {
        this.properties.height = value;

        if (this.component) {
          this.component.validateDataElement(this);
        }
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ColumnSeriesDataItem.prototype, "rangesColumns", {
    /**
     * A dictionary storing axes ranges columns by axis uid
     */
    get: function get() {
      if (!this._rangesColumns) {
        this._rangesColumns = new _core_utils_Dictionary__WEBPACK_IMPORTED_MODULE_5__["Dictionary"]();
      }

      return this._rangesColumns;
    },
    enumerable: true,
    configurable: true
  });
  return ColumnSeriesDataItem;
}(_XYSeries__WEBPACK_IMPORTED_MODULE_1__["XYSeriesDataItem"]);


/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Defines [[Series]] for a column graph.
 *
 * @see {@link IColumnSeriesEvents} for a list of available Events
 * @see {@link IColumnSeriesAdapters} for a list of available Adapters
 * @todo Example
 * @important
 */

var ColumnSeries =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(ColumnSeries, _super);
  /**
   * Constructor
   */


  function ColumnSeries() {
    var _this = _super.call(this) || this;
    /**
     * Start location within cell for columns.
     */


    _this._startLocation = 0;
    /**
     * End location within cell for columns.
     */

    _this._endLocation = 1;
    _this.className = "ColumnSeries";
    _this.width = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_11__["percent"])(100);
    _this.height = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_11__["percent"])(100);
    _this.strokeOpacity = 0;
    _this.fillOpacity = 1;
    _this.clustered = true;

    var columnsContainer = _this.mainContainer.createChild(_core_Container__WEBPACK_IMPORTED_MODULE_3__["Container"]);

    columnsContainer.shouldClone = false;
    columnsContainer.isMeasured = false;
    columnsContainer.layout = "none";
    _this._columnsContainer = columnsContainer;
    _this.columns.template.pixelPerfect = false;
    _this.tooltipColorSource = _this.columns.template;

    _this.applyTheme();

    return _this;
  }

  Object.defineProperty(ColumnSeries.prototype, "columnsContainer", {
    /**
     * A container that columns are created in.
     *
     * @ignore Exclude from docs
     */
    get: function get() {
      return this._columnsContainer;
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Sets defaults that instantiate some objects that rely on parent, so they
   * cannot be set in constructor.
   */

  ColumnSeries.prototype.applyInternalDefaults = function () {
    _super.prototype.applyInternalDefaults.call(this);

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_16__["hasValue"](this.readerTitle)) {
      this.readerTitle = this.language.translate("Column Series");
    }
  };
  /**
   * Returns a new/empty DataItem of the type appropriate for this object.
   *
   * @see {@link DataItem}
   * @return Data Item
   */


  ColumnSeries.prototype.createDataItem = function () {
    return new ColumnSeriesDataItem();
  };
  /**
   * (Re)validates the whole series, effectively causing it to redraw.
   *
   * @ignore Exclude from docs
   */


  ColumnSeries.prototype.validate = function () {
    //@todo Check if we can do better than use `instanceof`
    // find start/end locations based on clustered/stacked settings
    // go through chart series instead of base axis series, because axis series doesn't maintain order
    var _this = this;

    this.group.node.removeAttribute("fill");

    if (this.chart && this.xAxis && this.yAxis) {
      var baseAxisSeries = this.chart.series;
      var clusterCount_1 = 0;
      var index_1 = 0;
      var sortedByAxis_1 = [];
      _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_14__["each"](baseAxisSeries.iterator(), function (series) {
        if (series instanceof ColumnSeries) {
          if (_this.baseAxis == series.baseAxis) {
            var index_2;

            if (_this.baseAxis == _this.xAxis) {
              index_2 = _this.chart.yAxes.indexOf(series.yAxis);
            } else {
              index_2 = _this.chart.xAxes.indexOf(series.xAxis);
            }

            sortedByAxis_1.push({
              series: series,
              axis: index_2
            });
          }
        }
      });
      sortedByAxis_1.sort(function (a, b) {
        return a.axis - b.axis;
      });
      var prevAxisIndex_1;
      _core_utils_Array__WEBPACK_IMPORTED_MODULE_15__["each"](sortedByAxis_1, function (sortedItem) {
        var series = sortedItem.series;

        if (series instanceof ColumnSeries) {
          if (!series.stacked && series.clustered || prevAxisIndex_1 != sortedItem.axis && series.clustered) {
            clusterCount_1++;
          }

          if (series == _this) {
            index_1 = clusterCount_1 - 1;
          }
        }

        prevAxisIndex_1 = sortedItem.axis;
      });

      if (!this.clustered) {
        index_1 = 0;
        clusterCount_1 = 1;
      }

      var renderer = this.baseAxis.renderer;
      var cellStartLocation = renderer.cellStartLocation;
      var cellEndLocation = renderer.cellEndLocation;
      this._startLocation = cellStartLocation + index_1 / clusterCount_1 * (cellEndLocation - cellStartLocation);
      this._endLocation = cellStartLocation + (index_1 + 1) / clusterCount_1 * (cellEndLocation - cellStartLocation);
      var xAxis = this.xAxis;
      var yAxis = this.yAxis;

      if (xAxis instanceof _axes_CategoryAxis__WEBPACK_IMPORTED_MODULE_7__["CategoryAxis"] && yAxis instanceof _axes_ValueAxis__WEBPACK_IMPORTED_MODULE_6__["ValueAxis"]) {
        if (xAxis.sortBySeries == this) {
          this.sortCategoryAxis(xAxis, "valueY");
        }
      }

      if (yAxis instanceof _axes_CategoryAxis__WEBPACK_IMPORTED_MODULE_7__["CategoryAxis"] && xAxis instanceof _axes_ValueAxis__WEBPACK_IMPORTED_MODULE_6__["ValueAxis"]) {
        if (yAxis.sortBySeries == this) {
          this.sortCategoryAxis(yAxis, "valueX");
        }
      }
    }

    _super.prototype.validate.call(this);

    for (var i = 0; i < this.startIndex; i++) {
      var dataItem = this.dataItems.getIndex(i);
      this.disableUnusedColumns(dataItem);
    }

    for (var i = this.dataItems.length - 1; i > this.endIndex; i--) {
      var dataItem = this.dataItems.getIndex(i);
      this.disableUnusedColumns(dataItem);
    }

    this._propertiesChanged = false;
  };

  ColumnSeries.prototype.sortCategoryAxis = function (axis, key) {
    var _this = this;

    this.dataItems.values.sort(function (x, y) {
      return y.values[key].workingValue - x.values[key].workingValue;
    });
    var i = 0;
    this.dataItems.each(function (dataItem) {
      dataItem._index = i;
      i++;
    });
    axis.dataItems.each(function (dataItem) {
      var axis = dataItem.component;
      var currentPosition = axis.categoryToPosition(dataItem.category) - dataItem.deltaPosition;
      var seriesDataItem = axis.getSeriesDataItemByCategory(dataItem.category, _this);

      if (seriesDataItem) {
        var index = _this.dataItems.indexOf(seriesDataItem);

        dataItem._index = index;
        var deltaPosition = _core_utils_Math__WEBPACK_IMPORTED_MODULE_12__["round"]((index + 0.5) / _this.dataItems.length - currentPosition, 3);

        if (dataItem.deltaAnimation && !dataItem.deltaAnimation.isDisposed() && dataItem.deltaAnimation.animationOptions[0].to == deltaPosition) {// void
        } else if (deltaPosition != _core_utils_Math__WEBPACK_IMPORTED_MODULE_12__["round"](dataItem.deltaPosition, 3)) {
          if (dataItem.deltaAnimation) {
            dataItem.deltaAnimation.stop();
          }

          dataItem.deltaAnimation = dataItem.animate({
            property: "deltaPosition",
            from: -deltaPosition,
            to: 0
          }, axis.interpolationDuration, axis.interpolationEasing);

          _this._disposers.push(dataItem.deltaAnimation);
        }
      }
    });
    axis.dataItems.values.sort(function (x, y) {
      return x.index - y.index;
    });
  };
  /**
   * Validates data item's element, effectively redrawing it.
   *
   * @ignore Exclude from docs
   * @param dataItem  Data item
   */


  ColumnSeries.prototype.validateDataElement = function (dataItem) {
    // important oder here, first real, then super. we need this to know size
    if (this.chart && this.xAxis && this.yAxis) {
      this.validateDataElementReal(dataItem);

      _super.prototype.validateDataElement.call(this, dataItem);
    }
  };
  /**
   * Returns relative start location for the data item.
   *
   * @param dataItem  Data item
   * @return Location (0-1)
   */


  ColumnSeries.prototype.getStartLocation = function (dataItem) {
    var startLocation = this._startLocation;

    if (this.baseAxis == this.xAxis) {
      startLocation += dataItem.locations[this.xOpenField] - 0.5;
    } else {
      startLocation += dataItem.locations[this.yOpenField] - 0.5;
    }

    return startLocation;
  };
  /**
   * [handleDataItemWorkingValueChange description]
   *
   * @ignore Exclude from docs
   */

  /*
  public handleDataItemWorkingValueChange(dataItem?: this["_dataItem"], name?: string): void {
     if (this.simplifiedProcessing) {
         this.validateDataElement(dataItem);
     }
     else {
         super.handleDataItemWorkingValueChange(dataItem, name);
     }
  }*/

  /**
   * Returns relative end location for the data item.
   *
   * @param dataItem  Data item
   * @return Location (0-1)
   */


  ColumnSeries.prototype.getEndLocation = function (dataItem) {
    var endLocation = this._endLocation;

    if (this.baseAxis == this.xAxis) {
      endLocation += dataItem.locations[this.xField] - 0.5;
    } else {
      endLocation += dataItem.locations[this.yField] - 0.5;
    }

    return endLocation;
  };
  /**
   * Validates data item's elements.
   *
   * @ignore Exclude from docs
   * @param dataItem  Data item
   */


  ColumnSeries.prototype.validateDataElementReal = function (dataItem) {
    var _this = this; //	if (dataItem.hasValue([this.xField, this.yField])) { // todo: this doesn't work with categories, think of a better way


    var l;
    var r;
    var t;
    var b;
    var startLocation = this.getStartLocation(dataItem);
    var endLocation = this.getEndLocation(dataItem);
    var xField = this.xField;
    var xOpenField = this.xOpenField;
    var yField = this.yField;
    var yOpenField = this.yOpenField;
    var template = this.columns.template;
    var percentWidth = template.percentWidth;
    var percentHeight = template.percentHeight;
    var pixelWidth = template.pixelWidth;
    var pixelHeight = template.pixelHeight;
    var maxWidth = template.maxWidth;
    var maxHeight = template.maxHeight;
    var paddingLeft = template.pixelPaddingLeft;
    var paddingRight = template.pixelPaddingRight;
    var paddingTop = template.pixelPaddingTop;
    var paddingBottom = template.pixelPaddingBottom;
    var outOfBounds = false;
    var diw = dataItem.width;

    if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_16__["hasValue"](diw)) {
      if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_16__["isNumber"](diw)) {
        pixelWidth = diw;
      }

      if (diw instanceof _core_utils_Percent__WEBPACK_IMPORTED_MODULE_11__["Percent"]) {
        percentWidth = diw.value * 100;
      }
    }

    var dih = dataItem.height;

    if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_16__["hasValue"](dih)) {
      if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_16__["isNumber"](dih)) {
        pixelHeight = dih;
      }

      if (dih instanceof _core_utils_Percent__WEBPACK_IMPORTED_MODULE_11__["Percent"]) {
        percentHeight = dih.value * 100;
      }
    } // two category axes


    if (this.xAxis instanceof _axes_CategoryAxis__WEBPACK_IMPORTED_MODULE_7__["CategoryAxis"] && this.yAxis instanceof _axes_CategoryAxis__WEBPACK_IMPORTED_MODULE_7__["CategoryAxis"]) {
      if (!dataItem.hasValue(this._xValueFields) || !dataItem.hasValue(this._yValueFields)) {
        return;
      }

      startLocation = 0;
      endLocation = 1;

      if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_16__["isNaN"](percentWidth)) {
        var offset = _core_utils_Math__WEBPACK_IMPORTED_MODULE_12__["round"]((endLocation - startLocation) * (1 - percentWidth / 100) / 2, 5);
        startLocation += offset;
        endLocation -= offset;
      }

      l = this.xAxis.getX(dataItem, xOpenField, startLocation);
      r = this.xAxis.getX(dataItem, xField, endLocation); // in case width is set in pixels

      if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_16__["isNaN"](percentWidth)) {
        var offset = (r - l - pixelWidth) / 2;
        l += offset;
        r -= offset;
      } // in case max width is set in pixels


      if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_16__["isNaN"](maxWidth) && maxWidth < Math.abs(r - l)) {
        var offset = (r - l - maxWidth) / 2;
        l += offset;
        r -= offset;
      }

      startLocation = 0;
      endLocation = 1;

      if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_16__["isNaN"](percentHeight)) {
        var offset = _core_utils_Math__WEBPACK_IMPORTED_MODULE_12__["round"]((1 - percentHeight / 100) / 2, 5);
        startLocation += offset;
        endLocation -= offset;
      }

      t = this.yAxis.getY(dataItem, yOpenField, startLocation);
      b = this.yAxis.getY(dataItem, yField, endLocation); // in case width is set in pixels

      if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_16__["isNaN"](percentHeight)) {
        var offset = (b - t - pixelHeight) / 2;
        b += offset;
        t -= offset;
      } // in case max width is set in pixels


      if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_16__["isNaN"](maxHeight) && maxHeight < Math.abs(b - t)) {
        var offset = (b - t - maxHeight) / 2;
        b += offset;
        t -= offset;
      }

      r = this.fixHorizontalCoordinate(r);
      l = this.fixHorizontalCoordinate(l);
      t = this.fixVerticalCoordinate(t);
      b = this.fixVerticalCoordinate(b);
    } else if (this.baseAxis == this.xAxis) {
      if (!dataItem.hasValue(this._yValueFields)) {
        return;
      } // in case width is set in percent


      if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_16__["isNaN"](percentWidth)) {
        var offset = _core_utils_Math__WEBPACK_IMPORTED_MODULE_12__["round"]((endLocation - startLocation) * (1 - percentWidth / 100) / 2, 5);
        startLocation += offset;
        endLocation -= offset;
      }

      l = this.xAxis.getX(dataItem, xOpenField, startLocation);
      r = this.xAxis.getX(dataItem, xField, endLocation); // in case width is set in pixels

      if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_16__["isNaN"](percentWidth)) {
        var offset = (r - l - pixelWidth) / 2;
        l += offset;
        r -= offset;
      } // in case width is set in pixels


      if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_16__["isNaN"](maxWidth) && maxWidth < Math.abs(r - l)) {
        var offset = (r - l - maxWidth) / 2;
        l += offset;
        r -= offset;
      }

      var bottomLocation = dataItem.locations[yOpenField];
      var topLocation = dataItem.locations[yField]; // otherwise gantt chart will start items in the middle of a cell

      if (this.yAxis instanceof _axes_ValueAxis__WEBPACK_IMPORTED_MODULE_6__["ValueAxis"]) {
        if (this.dataFields[this.yField] != this.dataFields[this.yOpenField]) {
          bottomLocation = 0;
          topLocation = 0;
        }
      }

      b = this.yAxis.getY(dataItem, yOpenField, bottomLocation);
      t = this.yAxis.getY(dataItem, yField, topLocation); // used to save location for bullets, but it's not a good approach
      // dataItem.locations[xField] = startLocation + (endLocation - startLocation) / 2;

      var axisLenght = Math.ceil(this.yAxis.axisLength);

      if (t < 0 && b < 0 || t > axisLenght && b > axisLenght) {
        outOfBounds = true;
      }

      t = this.fixVerticalCoordinate(t);
      b = this.fixVerticalCoordinate(b);

      if (Math.abs(r - l) - paddingLeft - paddingRight == 0) {
        outOfBounds = true;
      }
    } // horizontal bars
    else {
        if (!dataItem.hasValue(this._xValueFields)) {
          return;
        }

        if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_16__["isNaN"](percentHeight)) {
          var offset = _core_utils_Math__WEBPACK_IMPORTED_MODULE_12__["round"]((endLocation - startLocation) * (1 - percentHeight / 100) / 2, 5);
          startLocation += offset;
          endLocation -= offset;
        }

        t = this.yAxis.getY(dataItem, yOpenField, startLocation);
        b = this.yAxis.getY(dataItem, yField, endLocation); // in case height is set in pixels

        if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_16__["isNaN"](percentHeight)) {
          var offset = (b - t - pixelHeight) / 2;
          b -= offset;
          t += offset;
        } // in case height is set in pixels


        if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_16__["isNaN"](maxHeight) && maxHeight < Math.abs(b - t)) {
          var offset = (b - t - maxHeight) / 2;
          b -= offset;
          t += offset;
        }

        var rightLocation = dataItem.locations[xField];
        var leftLocation = dataItem.locations[xOpenField]; // otherwise gantt chart will start items in the middle of a cell

        if (this.xAxis instanceof _axes_ValueAxis__WEBPACK_IMPORTED_MODULE_6__["ValueAxis"]) {
          if (this.dataFields[this.xField] != this.dataFields[this.xOpenField]) {
            rightLocation = 0;
            leftLocation = 0;
          }
        }

        r = this.xAxis.getX(dataItem, xField, rightLocation);
        l = this.xAxis.getX(dataItem, xOpenField, leftLocation); // used to save location for bullets, but it's not a good approach
        // dataItem.locations[yField] = startLocation + (endLocation - startLocation) / 2;

        var axisLenght = Math.ceil(this.xAxis.axisLength);

        if (r < 0 && l < 0 || r > axisLenght && l > axisLenght) {
          outOfBounds = true;
        }

        r = this.fixHorizontalCoordinate(r);
        l = this.fixHorizontalCoordinate(l);

        if (Math.abs(t - b) - paddingTop - paddingBottom == 0) {
          outOfBounds = true;
        }
      }

    var w = Math.abs(r - l);
    var h = Math.abs(b - t);
    var x = Math.min(l, r);
    var y = Math.min(t, b);

    if (!outOfBounds) {
      var column_1;

      if (!dataItem.column) {
        column_1 = this.columns.create(); //$object.forceCopyProperties(this.columns.template, column, visualProperties);

        _core_utils_Object__WEBPACK_IMPORTED_MODULE_13__["copyProperties"](this, column_1, _core_Sprite__WEBPACK_IMPORTED_MODULE_2__["visualProperties"]); // need this because 3d columns are not in the same container

        _core_utils_Object__WEBPACK_IMPORTED_MODULE_13__["copyProperties"](this.columns.template, column_1, _core_Sprite__WEBPACK_IMPORTED_MODULE_2__["visualProperties"]); // second time, no force, so that columns.template would override series properties

        dataItem.addSprite(column_1);
        dataItem.column = column_1;
        column_1.paper = this.paper; // sometimes pattern is not drawn if is set with adapter without this.
        // accessibility

        if (this.itemsFocusable()) {
          if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_16__["hasValue"](this.role)) {
            this.role = "menu";
          }

          if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_16__["hasValue"](column_1.role)) {
            column_1.role = "menuitem";
          }

          column_1.focusable = true;
        } else {
          if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_16__["hasValue"](this.role)) {
            this.role = "list";
          }

          if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_16__["hasValue"](column_1.role)) {
            column_1.role = "listitem";
          }

          column_1.focusable = false;
        }

        if (column_1.focusable) {
          column_1.events.on("focus", function (ev) {
            column_1.readerTitle = _this.populateString(_this.itemReaderText, dataItem);
          }, undefined, false);
          column_1.events.on("blur", function (ev) {
            column_1.readerTitle = "";
          }, undefined, false);
        }

        if (column_1.hoverable) {
          column_1.events.on("over", function (ev) {
            column_1.readerTitle = _this.populateString(_this.itemReaderText, dataItem);
          }, undefined, false);
          column_1.events.on("out", function (ev) {
            column_1.readerTitle = "";
          }, undefined, false);
        }

        column_1.parent = this.columnsContainer;
        column_1.virtualParent = this;
      } else {
        column_1 = dataItem.column;

        if (this._propertiesChanged) {
          _core_utils_Object__WEBPACK_IMPORTED_MODULE_13__["copyProperties"](this, column_1, _core_Sprite__WEBPACK_IMPORTED_MODULE_2__["visualProperties"]);
          _core_utils_Object__WEBPACK_IMPORTED_MODULE_13__["copyProperties"](this.columns.template, column_1, _core_Sprite__WEBPACK_IMPORTED_MODULE_2__["visualProperties"]);
          _core_utils_Array__WEBPACK_IMPORTED_MODULE_15__["each"](_core_Sprite__WEBPACK_IMPORTED_MODULE_2__["visualProperties"], function (property) {
            column_1[property] = column_1[property];
          });
        }
      }

      column_1.width = w;
      column_1.height = h;
      column_1.x = x;
      column_1.y = y;
      column_1.realX = l;
      column_1.realY = t;
      column_1.realWidth = r - l;
      column_1.realHeight = b - t;
      this.setColumnStates(column_1);

      if (column_1.invalid) {
        column_1.validate(); // validate as if it was used previously, it will flicker with previous dimensions
      }

      column_1.__disabled = false; //column.returnAfterTemp();

      _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_14__["each"](this.axisRanges.iterator(), function (axisRange) {
        var rangeColumn = dataItem.rangesColumns.getKey(axisRange.uid);

        if (!rangeColumn) {
          rangeColumn = _this.columns.create(); //$object.forceCopyProperties(this.columns.template, rangeColumn, visualProperties);

          _core_utils_Object__WEBPACK_IMPORTED_MODULE_13__["copyProperties"](axisRange.contents, rangeColumn, _core_Sprite__WEBPACK_IMPORTED_MODULE_2__["visualProperties"]); // need this because 3d columns are not in the same container

          dataItem.addSprite(rangeColumn);
          dataItem.rangesColumns.setKey(axisRange.uid, rangeColumn);
          rangeColumn.paper = _this.paper; // sometimes pattern is not drawn if is set with adapter without this.
        }

        rangeColumn.parent = axisRange.contents;
        rangeColumn.width = w;
        rangeColumn.height = h;
        rangeColumn.x = x;
        rangeColumn.y = y;

        _this.setColumnStates(rangeColumn);

        if (rangeColumn.invalid) {
          rangeColumn.validate(); // validate as if it was used previously, it will flicker with previous dimensions
        }

        rangeColumn.__disabled = false; //rangeColumn.returnAfterTemp();
      });
    } else {
      this.disableUnusedColumns(dataItem);
    }

    dataItem.itemWidth = w;
    dataItem.itemHeight = h;
  };
  /**
   * @ignore
   */


  ColumnSeries.prototype.disableUnusedColumns = function (dataItem) {
    if (dataItem) {
      if (dataItem.column) {
        // otherwise might flicker when enabling
        dataItem.column.width = 0;
        dataItem.column.height = 0;
        dataItem.column.__disabled = true;
      }

      _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_14__["each"](this.axisRanges.iterator(), function (axisRange) {
        var rangeColumn = dataItem.rangesColumns.getKey(axisRange.uid);

        if (rangeColumn) {
          // otherwise might flicker when enabling
          rangeColumn.width = 0;
          rangeColumn.height = 0;
          rangeColumn.__disabled = true;
        }
      });
    }
  };
  /**
   * Apply different state/coloring to columns based on the change value.
   *
   * @param sprite  Sprite to apply state to
   * @todo Do not apply accessibility to wicks of the candlesticks
   */


  ColumnSeries.prototype.setColumnStates = function (sprite) {
    if (this._dropFromOpenState || this._dropFromPreviousState || this._riseFromOpenState || this._riseFromPreviousState) {
      var dataItem = sprite.dataItem;

      if (this.xAxis instanceof _axes_ValueAxis__WEBPACK_IMPORTED_MODULE_6__["ValueAxis"] || this.yAxis instanceof _axes_ValueAxis__WEBPACK_IMPORTED_MODULE_6__["ValueAxis"]) {
        var open_1;
        var value = void 0;
        var change = void 0;

        if (this.baseAxis == this.yAxis) {
          if (this.xOpenField && this.xField && this.xAxis instanceof _axes_ValueAxis__WEBPACK_IMPORTED_MODULE_6__["ValueAxis"]) {
            open_1 = dataItem.getValue(this.xOpenField);
            value = dataItem.getValue(this.xField);
          }

          change = dataItem.getValue(this.xAxis.axisFieldName + "X", "previousChange");
        } else {
          if (this.yOpenField && this.yField && this.yAxis instanceof _axes_ValueAxis__WEBPACK_IMPORTED_MODULE_6__["ValueAxis"]) {
            open_1 = dataItem.getValue(this.yOpenField);
            value = dataItem.getValue(this.yField);
          }

          change = dataItem.getValue(this.yAxis.axisFieldName + "Y", "previousChange");
        }

        if (value < open_1) {
          dataItem.droppedFromOpen = true;
          sprite.defaultState.copyFrom(this._dropFromOpenState);
          sprite.setState(this._dropFromOpenState, 0);
        } else {
          dataItem.droppedFromOpen = false;
          sprite.defaultState.copyFrom(this._riseFromOpenState);
          sprite.setState(this._riseFromOpenState, 0);
        }

        if (change < 0) {
          dataItem.droppedFromPrevious = true;
          sprite.defaultState.copyFrom(this._dropFromPreviousState);
          sprite.setState(this._dropFromPreviousState, 0);
        } else {
          dataItem.droppedFromPrevious = false;
          sprite.defaultState.copyFrom(this._riseFromPreviousState);
          sprite.setState(this._riseFromPreviousState, 0);
        }
      }
    }
  };

  Object.defineProperty(ColumnSeries.prototype, "columns", {
    /**
     * A list of column elements in the series.
     *
     * @return Columns
     */
    get: function get() {
      if (!this._columns) {
        this._columns = new _core_utils_List__WEBPACK_IMPORTED_MODULE_4__["ListTemplate"](this.createColumnTemplate());

        this._disposers.push(new _core_utils_List__WEBPACK_IMPORTED_MODULE_4__["ListDisposer"](this._columns));

        this._disposers.push(this._columns.template);
      }

      return this._columns;
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Creates and returns a column element to use as a template.
   *
   * @return Column template
   */

  ColumnSeries.prototype.createColumnTemplate = function () {
    return new _elements_Column__WEBPACK_IMPORTED_MODULE_9__["Column"]();
  };

  Object.defineProperty(ColumnSeries.prototype, "clustered", {
    /**
     * @return Clustered?
     */
    get: function get() {
      return this.getPropertyValue("clustered");
    },

    /**
     * Cluster this series columns?
     *
     * Setting to `false` will make columns overlap with other series.
     *
     * @default true
     * @param value  Clustered?
     */
    set: function set(value) {
      this.setPropertyValue("clustered", value, true);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ColumnSeries.prototype, "dropFromOpenState", {
    /**
     * @return State
     */
    get: function get() {
      if (!this._dropFromOpenState) {
        this._dropFromOpenState = this.states.create("dropFromOpenState");
      }

      return this._dropFromOpenState;
    },

    /**
     * A state to apply to a column when close value is lower than open value.
     *
     * Can be used to differentiate appearance based on value relations.
     *
     * NOTE: this will work only if at least one axis is [[ValueAxis]].
     *
     * @readonly You can modify state object, but can't overwrite it
     * @param  value  State
     */
    set: function set(value) {
      this._dropFromOpenState = value;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ColumnSeries.prototype, "dropFromPreviousState", {
    /**
     * @return State
     */
    get: function get() {
      if (!this._dropFromPreviousState) {
        this._dropFromPreviousState = this.states.create("dropFromPreviousState");
      }

      return this._dropFromPreviousState;
    },

    /**
     * A state to apply to a column when its value is lower value of a previous
     * column.
     *
     * Can be used to differentiate appearance based on value relations.
     *
     * @readonly You can modify state object, but can't overwrite it
     * @param  value  State
     */
    set: function set(value) {
      this._dropFromPreviousState = value;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ColumnSeries.prototype, "riseFromOpenState", {
    /**
     * @return State
     */
    get: function get() {
      if (!this._riseFromOpenState) {
        this._riseFromOpenState = this.states.create("riseFromOpenState");
      }

      return this._riseFromOpenState;
    },

    /**
     * A state to apply to a column when close value is same or higher than open
     * value.
     *
     * Can be used to differentiate appearance based on value relations.
     *
     * NOTE: this will work only if at least one axis is [[ValueAxis]].
     *
     * @readonly You can modify state object, but can't overwrite it
     * @param  value  State
     */
    set: function set(value) {
      this._riseFromOpenState = value;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ColumnSeries.prototype, "riseFromPreviousState", {
    /**
     * @return State
     */
    get: function get() {
      if (!this._riseFromPreviousState) {
        this._riseFromPreviousState = this.states.create("riseFromPreviousState");
      }

      return this._riseFromPreviousState;
    },

    /**
     * A state to apply to a column when its value is same or higher than value
     * of a previous column.
     *
     * Can be used to differentiate appearance based on value relations.
     *
     * @readonly You can modify state object, but can't overwrite it
     * @param  value  State
     */
    set: function set(value) {
      this._riseFromPreviousState = value;
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Updates value of the related legend item.
   *
   * @ignore Exclude from docs
   * @param dataItem  Data item
   */

  ColumnSeries.prototype.updateLegendValue = function (dataItem, notRange) {
    var _this = this;

    _super.prototype.updateLegendValue.call(this, dataItem, notRange);

    if (this.legendDataItem) {
      var marker = this.legendDataItem.marker;
      var fromOpenState_1;
      var fromPreviousState_1;

      if (dataItem) {
        if (dataItem.droppedFromOpen) {
          fromOpenState_1 = this._dropFromOpenState;
        } else {
          fromOpenState_1 = this._riseFromOpenState;
        }

        if (dataItem.droppedFromPrevious) {
          fromPreviousState_1 = this._dropFromPreviousState;
        } else {
          fromPreviousState_1 = this._riseFromPreviousState;
        }
      }

      _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_14__["each"](marker.children.iterator(), function (child) {
        if (dataItem) {
          child.setState(fromPreviousState_1);
          child.setState(fromOpenState_1);
        } else {
          // todo: think what to do here, maybe apply above states based on totals?
          child.setState(_this._riseFromPreviousState);
          child.setState(_this._riseFromOpenState);
        }
      });
    }
  };
  /**
   * Creates elements in related legend container, that mimics the look of this
   * Series.
   *
   * @ignore Exclude from docs
   * @param marker  Legend item container
   */


  ColumnSeries.prototype.createLegendMarker = function (marker) {
    var w = marker.pixelWidth;
    var h = marker.pixelHeight;
    marker.removeChildren();
    var column = marker.createChild(_core_elements_RoundedRectangle__WEBPACK_IMPORTED_MODULE_10__["RoundedRectangle"]);
    column.shouldClone = false;
    _core_utils_Object__WEBPACK_IMPORTED_MODULE_13__["copyProperties"](this, column, _core_Sprite__WEBPACK_IMPORTED_MODULE_2__["visualProperties"]);
    column.copyFrom(this.columns.template);
    column.padding(0, 0, 0, 0); // if columns will have padding (which is often), legend marker will be very narrow

    column.width = w;
    column.height = h;
    var legendDataItem = marker.dataItem;
    legendDataItem.color = this.fill;
    legendDataItem.colorOrig = this.fill;
  };
  /**
   * Copies all properties from another instance of [[ColumnSeries]].
   *
   * @param source  Source series
   */


  ColumnSeries.prototype.copyFrom = function (source) {
    _super.prototype.copyFrom.call(this, source);

    this.columns.template.copyFrom(source.columns.template);
  };
  /**
  * returns bullet x location
  * @ignore
  */


  ColumnSeries.prototype.getBulletLocationX = function (bullet, field) {
    if (this.baseAxis == this.xAxis) {
      var bulletLocationX = bullet.locationX;

      if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_16__["isNumber"](bulletLocationX)) {
        bulletLocationX = 0.5;
      }

      var endLocation = this.getEndLocation(bullet.dataItem);
      var startLocation = this.getStartLocation(bullet.dataItem);
      return endLocation - (endLocation - startLocation) * bulletLocationX;
    } else {
      return _super.prototype.getBulletLocationX.call(this, bullet, field);
    }
  };
  /**
  * returns bullet y location
  * @ignore
  */


  ColumnSeries.prototype.getBulletLocationY = function (bullet, field) {
    if (this.baseAxis == this.yAxis) {
      var bulletLocationY = bullet.locationY;

      if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_16__["isNumber"](bulletLocationY)) {
        bulletLocationY = 0.5;
      }

      var endLocation = this.getEndLocation(bullet.dataItem);
      var startLocation = this.getStartLocation(bullet.dataItem);
      return endLocation - (endLocation - startLocation) * bulletLocationY;
    } else {
      return _super.prototype.getBulletLocationY.call(this, bullet, field);
    }
  };

  ColumnSeries.prototype.getAdjustedXLocation = function (dataItem, field, bulletLocationX) {
    //if (this.baseAxis == this.xAxis) {
    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_16__["isNumber"](bulletLocationX)) {
      if (dataItem) {
        bulletLocationX = dataItem.locations[field];
      } else {
        bulletLocationX = 0.5;
      }
    }

    return this._endLocation - (this._endLocation - this._startLocation) * (1 - bulletLocationX); //}
    //else {
    //	return super.getAdjustedXLocation(dataItem, field);
    //}
  };

  ColumnSeries.prototype.getAdjustedYLocation = function (dataItem, field, bulletLocationY) {
    //if (this.baseAxis == this.yAxis) {
    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_16__["isNumber"](bulletLocationY)) {
      if (dataItem) {
        bulletLocationY = dataItem.locations[field];
      } else {
        bulletLocationY = 0.5;
      }
    }

    return this._endLocation - (this._endLocation - this._startLocation) * bulletLocationY; //}
    //else {
    //	return super.getAdjustedYLocation(dataItem, field);
    //}
  };
  /**
   * @ignore Exclude from docs
   */


  ColumnSeries.prototype.fixVerticalCoordinate = function (coordinate) {
    var paddingBottom = this.columns.template.pixelPaddingBottom;
    var paddingTop = this.columns.template.pixelPaddingTop;
    var minY = -paddingTop;
    var maxY = this.yAxis.axisLength + paddingBottom;
    return _core_utils_Math__WEBPACK_IMPORTED_MODULE_12__["fitToRange"](coordinate, minY, maxY);
  };
  /**
   * @ignore Exclude from docs
   */


  ColumnSeries.prototype.fixHorizontalCoordinate = function (coordinate) {
    var paddingLeft = this.columns.template.pixelPaddingLeft;
    var paddingRight = this.columns.template.pixelPaddingRight;
    var minX = -paddingLeft;
    var maxX = this.xAxis.axisLength + paddingRight;
    return _core_utils_Math__WEBPACK_IMPORTED_MODULE_12__["fitToRange"](coordinate, minX, maxX);
  };
  /**
   * @ignore
   */


  ColumnSeries.prototype.disposeData = function () {
    _super.prototype.disposeData.call(this);

    this.columns.clear();
  };

  return ColumnSeries;
}(_XYSeries__WEBPACK_IMPORTED_MODULE_1__["XYSeries"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_8__["registry"].registeredClasses["ColumnSeries"] = ColumnSeries;
_core_Registry__WEBPACK_IMPORTED_MODULE_8__["registry"].registeredClasses["ColumnSeriesDataItem"] = ColumnSeriesDataItem;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/series/ColumnSeries3D.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/series/ColumnSeries3D.js ***!
  \************************************************************************************/
/*! exports provided: ColumnSeries3DDataItem, ColumnSeries3D */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ColumnSeries3DDataItem", function() { return ColumnSeries3DDataItem; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ColumnSeries3D", function() { return ColumnSeries3D; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _series_ColumnSeries__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../series/ColumnSeries */ "./node_modules/@amcharts/amcharts4/.internal/charts/series/ColumnSeries.js");
/* harmony import */ var _elements_Column3D__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../elements/Column3D */ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/Column3D.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/**
 * 3D column series module.
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */




/**
 * ============================================================================
 * DATA ITEM
 * ============================================================================
 * @hidden
 */

var ColumnSeries3DDataItem =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(ColumnSeries3DDataItem, _super);
  /**
   * Constructor
   */


  function ColumnSeries3DDataItem() {
    var _this = _super.call(this) || this;

    _this.className = "ColumnSeries3DDataItem";

    _this.applyTheme();

    return _this;
  }

  return ColumnSeries3DDataItem;
}(_series_ColumnSeries__WEBPACK_IMPORTED_MODULE_1__["ColumnSeriesDataItem"]);


/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Defines [[Series]] for a 3D column graph.
 *
 * @see {@link IColumnSeries3DEvents} for a list of available Events
 * @see {@link IColumnSeries3DAdapters} for a list of available Adapters
 * @todo Example
 * @important
 */

var ColumnSeries3D =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(ColumnSeries3D, _super);
  /**
   * Constructor
   */


  function ColumnSeries3D() {
    var _this = _super.call(this) || this;

    _this.className = "ColumnSeries3D";
    _this.columns.template.column3D.applyOnClones = true;
    _this.columns.template.hiddenState.properties.visible = true;

    _this.applyTheme();

    return _this;
  }

  Object.defineProperty(ColumnSeries3D.prototype, "columnsContainer", {
    /**
     * @ignore
     */
    get: function get() {
      var chart = this.chart;

      if (chart && chart.columnsContainer && chart.leftAxesContainer.layout != "vertical" && chart.rightAxesContainer.layout != "vertical" && chart.bottomAxesContainer.layout != "horizontal" && chart.topAxesContainer.layout != "horizontal") {
        return chart.columnsContainer;
      } else {
        return this._columnsContainer;
      }
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Validates data item's elements.
   *
   * @ignore Exclude from docs
   * @param dataItem  Data item
   */

  ColumnSeries3D.prototype.validateDataElementReal = function (dataItem) {
    _super.prototype.validateDataElementReal.call(this, dataItem);

    if (dataItem.column) {
      dataItem.column.dx = this.dx;
      dataItem.column.dy = this.dy;
      dataItem.column.visible = this.visible;
    }
  };
  /**
   * Validates data item's elements.
   *
   * @ignore Exclude from docs
   */


  ColumnSeries3D.prototype.validateDataElements = function () {
    _super.prototype.validateDataElements.call(this);

    if (this.chart) {
      this.chart.invalidateLayout();
    }
  };
  /**
   * Returns an element to use for 3D bar.
   * @ignore
   * @return Element.
   */


  ColumnSeries3D.prototype.createColumnTemplate = function () {
    return new _elements_Column3D__WEBPACK_IMPORTED_MODULE_2__["Column3D"]();
  };

  Object.defineProperty(ColumnSeries3D.prototype, "depth", {
    /**
     * @ignore Exclude from docs
     * @return Depth (px)
     */
    get: function get() {
      return this.getPropertyValue("depth");
    },

    /**
     * Depth (height) of the slices in the series in pixels.
     *
     * @ignore Exclude from docs
     * @param value  Depth (px)
     */
    set: function set(value) {
      this.setPropertyValue("depth", value, true);
      var template = this.columns.template; // todo: Cone is not Rectangle3D, maybe we should do some I3DShape?

      template.column3D.depth = value;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ColumnSeries3D.prototype, "angle", {
    /**
     * @ignore Exclude from docs
     * @return Angle (0-360)
     */
    get: function get() {
      return this.getPropertyValue("angle");
    },

    /**
     * Angle of view for the slices in series. (0-360)
     *
     * @ignore Exclude from docs
     * @param value  Angle (0-360)
     */
    set: function set(value) {
      this.setPropertyValue("angle", value);
      var template = this.columns.template;
      template.column3D.angle = value;
    },
    enumerable: true,
    configurable: true
  });
  return ColumnSeries3D;
}(_series_ColumnSeries__WEBPACK_IMPORTED_MODULE_1__["ColumnSeries"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_3__["registry"].registeredClasses["ColumnSeries3D"] = ColumnSeries3D;
_core_Registry__WEBPACK_IMPORTED_MODULE_3__["registry"].registeredClasses["ColumnSeries3DDataItem"] = ColumnSeries3DDataItem;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/series/ConeSeries.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/series/ConeSeries.js ***!
  \********************************************************************************/
/*! exports provided: ConeSeriesDataItem, ConeSeries */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ConeSeriesDataItem", function() { return ConeSeriesDataItem; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ConeSeries", function() { return ConeSeries; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _ColumnSeries__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ColumnSeries */ "./node_modules/@amcharts/amcharts4/.internal/charts/series/ColumnSeries.js");
/* harmony import */ var _elements_ConeColumn__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../elements/ConeColumn */ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/ConeColumn.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/rendering/Path */ "./node_modules/@amcharts/amcharts4/.internal/core/rendering/Path.js");
/**
 * ConeSeries module
 * Not recommended using if you use scrollbars or your chart is zoomable in some other way.
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */





/**
 * ============================================================================
 * DATA ITEM
 * ============================================================================
 * @hidden
 */

/**
 * Defines a [[DataItem]] for [[ConeSeries]].
 *
 * @see {@link DataItem}
 */

var ConeSeriesDataItem =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(ConeSeriesDataItem, _super);
  /**
   * Constructor
   */


  function ConeSeriesDataItem() {
    var _this = _super.call(this) || this;

    _this.className = "ConeSeriesDataItem";

    _this.applyTheme();

    return _this;
  }

  return ConeSeriesDataItem;
}(_ColumnSeries__WEBPACK_IMPORTED_MODULE_1__["ColumnSeriesDataItem"]);


/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Defines [[Series]] for a cone graph.
 *
 * @see {@link IConeSeriesEvents} for a list of available Events
 * @see {@link IConeSeriesAdapters} for a list of available Adapters
 * @todo Example
 * @important
 */

var ConeSeries =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(ConeSeries, _super);
  /**
   * Constructor
   */


  function ConeSeries() {
    var _this = _super.call(this) || this;

    _this.className = "ConeSeries";

    _this.applyTheme();

    return _this;
  }
  /**
   * Returns an element to use for Candlestick
   * @ignore
   * @return Element.
   */


  ConeSeries.prototype.createColumnTemplate = function () {
    return new _elements_ConeColumn__WEBPACK_IMPORTED_MODULE_2__["ConeColumn"]();
  };
  /**
   * Returns an SVG path to use as series mask.
   *
   * @return SVG path
   */


  ConeSeries.prototype.getMaskPath = function () {
    var dx = 0;
    var dy = 0;
    var column = this.columns.getIndex(0);

    if (column) {
      if (this.baseAxis == this.xAxis) {
        dy = column.coneColumn.innerWidth / 2 + 1;
      } else {
        dx = column.coneColumn.innerHeight / 2 + 1;
      }

      return _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["rectToPath"]({
        x: -dx,
        y: 0,
        width: this.xAxis.axisLength + dx,
        height: this.yAxis.axisLength + dy
      });
    }
  };
  /**
   * Validates data item's elements.
   *
   * @ignore Exclude from docs
   * @param dataItem  Data item
   */


  ConeSeries.prototype.validateDataElementReal = function (dataItem) {
    _super.prototype.validateDataElementReal.call(this, dataItem);

    var column = dataItem.column;

    if (column) {
      var coneColumn = dataItem.column.coneColumn;
      coneColumn.fill = dataItem.column.fill;

      if (this.baseAxis == this.yAxis) {
        coneColumn.orientation = "horizontal";
      } else {
        coneColumn.orientation = "vertical";
      }
    }
  };

  return ConeSeries;
}(_ColumnSeries__WEBPACK_IMPORTED_MODULE_1__["ColumnSeries"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_3__["registry"].registeredClasses["ConeSeries"] = ConeSeries;
_core_Registry__WEBPACK_IMPORTED_MODULE_3__["registry"].registeredClasses["ConeSeriesDataItem"] = ConeSeriesDataItem;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/series/CurvedColumnSeries.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/series/CurvedColumnSeries.js ***!
  \****************************************************************************************/
/*! exports provided: CurvedColumnSeriesDataItem, CurvedColumnSeries */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CurvedColumnSeriesDataItem", function() { return CurvedColumnSeriesDataItem; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CurvedColumnSeries", function() { return CurvedColumnSeries; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _ColumnSeries__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ColumnSeries */ "./node_modules/@amcharts/amcharts4/.internal/charts/series/ColumnSeries.js");
/* harmony import */ var _elements_CurvedColumn__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../elements/CurvedColumn */ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/CurvedColumn.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/**
 * CurvedColumnSeries module.
 *
 * Not recommended using if you use scrollbars or your chart is zoomable in some other way.
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */




/**
 * ============================================================================
 * DATA ITEM
 * ============================================================================
 * @hidden
 */

/**
 * Defines a [[DataItem]] for [[CurvedColumnSeries]].
 *
 * @see {@link DataItem}
 */

var CurvedColumnSeriesDataItem =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(CurvedColumnSeriesDataItem, _super);
  /**
   * Constructor
   */


  function CurvedColumnSeriesDataItem() {
    var _this = _super.call(this) || this;

    _this.className = "CurvedColumnSeriesDataItem";

    _this.applyTheme();

    return _this;
  }

  return CurvedColumnSeriesDataItem;
}(_ColumnSeries__WEBPACK_IMPORTED_MODULE_1__["ColumnSeriesDataItem"]);


/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Defines [[Series]] for a curved columns graph.
 *
 * @see {@link ICurvedColumnSeriesEvents} for a list of available Events
 * @see {@link ICurvedColumnSeriesAdapters} for a list of available Adapters
 * @important
 */

var CurvedColumnSeries =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(CurvedColumnSeries, _super);
  /**
   * Constructor
   */


  function CurvedColumnSeries() {
    var _this = _super.call(this) || this;

    _this.className = "CurvedColumnSeries";

    _this.applyTheme();

    return _this;
  }
  /**
   * Returns an element to use for the curved column.
   *
   * @ignore Exclude from docs
   * @return Element.
   */


  CurvedColumnSeries.prototype.createColumnTemplate = function () {
    return new _elements_CurvedColumn__WEBPACK_IMPORTED_MODULE_2__["CurvedColumn"]();
  };
  /**
   * Validates data item's elements.
   *
   * @ignore Exclude from docs
   * @param dataItem  Data item
   */


  CurvedColumnSeries.prototype.validateDataElementReal = function (dataItem) {
    _super.prototype.validateDataElementReal.call(this, dataItem);

    var column = dataItem.column;
    column = dataItem.column;

    if (column) {
      var curvedColumn = dataItem.column.curvedColumn;
      curvedColumn.fill = dataItem.column.fill;

      if (this.baseAxis == this.yAxis) {
        column.orientation = "horizontal";
      } else {
        column.orientation = "vertical";
      }
    }
  };

  return CurvedColumnSeries;
}(_ColumnSeries__WEBPACK_IMPORTED_MODULE_1__["ColumnSeries"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_3__["registry"].registeredClasses["CurvedColumnSeries"] = CurvedColumnSeries;
_core_Registry__WEBPACK_IMPORTED_MODULE_3__["registry"].registeredClasses["CurvedColumnSeriesDataItem"] = CurvedColumnSeriesDataItem;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/series/FunnelSeries.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/series/FunnelSeries.js ***!
  \**********************************************************************************/
/*! exports provided: FunnelSeriesDataItem, FunnelSeries */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FunnelSeriesDataItem", function() { return FunnelSeriesDataItem; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FunnelSeries", function() { return FunnelSeries; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _PercentSeries__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./PercentSeries */ "./node_modules/@amcharts/amcharts4/.internal/charts/series/PercentSeries.js");
/* harmony import */ var _elements_FunnelSlice__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../elements/FunnelSlice */ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/FunnelSlice.js");
/* harmony import */ var _elements_FunnelTick__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../elements/FunnelTick */ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/FunnelTick.js");
/* harmony import */ var _core_utils_List__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/utils/List */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/List.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_utils_Math__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core/utils/Math */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Math.js");
/* harmony import */ var _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../core/utils/Iterator */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Iterator.js");
/* harmony import */ var _core_utils_Type__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../core/utils/Type */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Type.js");
/* harmony import */ var _core_utils_Array__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../core/utils/Array */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Array.js");
/* harmony import */ var _core_utils_Percent__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../core/utils/Percent */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Percent.js");
/* harmony import */ var _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../core/utils/Disposer */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Disposer.js");
/* harmony import */ var _core_Options__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../core/Options */ "./node_modules/@amcharts/amcharts4/.internal/core/Options.js");
/**
 * Defines Funnel Chart Series.
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */













/**
 * ============================================================================
 * DATA ITEM
 * ============================================================================
 * @hidden
 */
//@todo: sequenced?

/**
 * Defines a [[DataItem]] for [[FunnelSeries]].
 *
 * @see {@link DataItem}
 */

var FunnelSeriesDataItem =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(FunnelSeriesDataItem, _super);
  /**
   * Constructor
   */


  function FunnelSeriesDataItem() {
    var _this = _super.call(this) || this;

    _this.className = "FunnelSeriesDataItem"; // this helps to invalidate series when value is 0 an it is hidden (no other events are triggered then)

    _this.events.on("visibilitychanged", function () {
      if (_this.component) {
        _this.component.invalidateDataItems();
      }
    }, _this, false);

    _this.applyTheme();

    return _this;
  }

  Object.defineProperty(FunnelSeriesDataItem.prototype, "sliceLink", {
    /**
     * A [[FunnelSlice]] element, related to this data item ([[FunnelSlice]]).
     *
     * @readonly
     * @return Slice element
     */
    get: function get() {
      var _this = this;

      if (!this._sliceLink) {
        var sliceLink_1 = this.component.sliceLinks.create();
        this._sliceLink = sliceLink_1;

        this._disposers.push(sliceLink_1);

        sliceLink_1.parent = this.component.slicesContainer;

        this._disposers.push(new _core_utils_Disposer__WEBPACK_IMPORTED_MODULE_11__["Disposer"](function () {
          if (_this.component) {
            _this.component.sliceLinks.removeValue(sliceLink_1);
          }
        }));

        this.addSprite(sliceLink_1);
        sliceLink_1.visible = this.visible;
      }

      return this._sliceLink;
    },
    enumerable: true,
    configurable: true
  });
  return FunnelSeriesDataItem;
}(_PercentSeries__WEBPACK_IMPORTED_MODULE_1__["PercentSeriesDataItem"]);


/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Defines [[Series]] for a FunnelSlice series on a [[SlicedChart]].
 *
 * @see {@link IFunnelSeriesEvents} for a list of available Events
 * @see {@link IFunnelSeriesAdapters} for a list of available Adapters
 * @see {@link https://www.amcharts.com/docs/v4/chart-types/sliced-chart/} for documentation
 * @important
 */

var FunnelSeries =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(FunnelSeries, _super);
  /**
   * Constructor
   */


  function FunnelSeries() {
    var _this = _super.call(this) || this;

    _this._nextY = 0;
    _this.className = "FunnelSeries";
    _this.orientation = "vertical";
    _this.width = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_10__["percent"])(100);
    _this.height = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_10__["percent"])(100);
    _this.slicesContainer.width = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_10__["percent"])(100);
    _this.slicesContainer.height = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_10__["percent"])(100);

    _this._disposers.push(_this.slicesContainer.events.on("maxsizechanged", _this.invalidateDataItems, _this, false));

    _this.labelsOpposite = true;
    _this.labelsContainer.layout = "absolute";
    _this.bottomRatio = 0;

    _this.applyTheme();

    return _this;
  }
  /**
   * Creates a [[FunnelSlice]] element.
   *
   * @return Slice
   */


  FunnelSeries.prototype.createSlice = function () {
    return new _elements_FunnelSlice__WEBPACK_IMPORTED_MODULE_2__["FunnelSlice"]();
  };
  /**
   * Creates a [[FunnelTick]] element.
   *
   * @return Tick
   */


  FunnelSeries.prototype.createTick = function () {
    return new _elements_FunnelTick__WEBPACK_IMPORTED_MODULE_3__["FunnelTick"]();
  };
  /**
   * Sets defaults that instantiate some objects that rely on parent, so they
   * cannot be set in constructor.
   */


  FunnelSeries.prototype.applyInternalDefaults = function () {
    _super.prototype.applyInternalDefaults.call(this);

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_8__["hasValue"](this.readerTitle)) {
      this.readerTitle = this.language.translate("Funnel Series");
    }
  };
  /**
   * Returns a new/empty DataItem of the type appropriate for this object.
   *
   * @see {@link DataItem}
   * @return Data Item
   */


  FunnelSeries.prototype.createDataItem = function () {
    return new FunnelSeriesDataItem();
  };
  /**
   * Inits FunnelSlice.
   *
   * @param slice to init
   */


  FunnelSeries.prototype.initSlice = function (slice) {
    slice.isMeasured = false;
    slice.defaultState.properties.scale = 1;
    slice.observe("scale", this.handleSliceScale, this);
    slice.observe(["dx", "dy", "x", "y"], this.handleSliceMove, this);
    slice.tooltipText = "{category}: {value.percent.formatNumber('#.#')}% ({value.value})";
    var hoverState = slice.states.create("hover");
    hoverState.properties.expandDistance = 0.2;
  };
  /**
   * [initLabel description]
   *
   * @todo Description
   * @param label [description]
   */


  FunnelSeries.prototype.initLabel = function (label) {
    _super.prototype.initLabel.call(this, label);

    label.verticalCenter = "middle";
    label.horizontalCenter = "middle";
    label.isMeasured = true;
    label.padding(5, 5, 5, 5);
  };
  /**
   * (Re)validates the whole series, effectively causing it to redraw.
   *
   * @ignore Exclude from docs
   */


  FunnelSeries.prototype.validate = function () {
    _super.prototype.validate.call(this);

    this._nextY = 0;
  };
  /**
   * [validateDataElements description]
   *
   * @todo Description
   * @ignore Exclude from docs
   */


  FunnelSeries.prototype.validateDataElements = function () {
    var _this = this;

    var slicesContainer = this.slicesContainer;
    var labelsContainer = this.labelsContainer;
    var labelTemplate = this.labels.template;

    if (this.alignLabels) {
      labelTemplate.interactionsEnabled = true;
      slicesContainer.isMeasured = true;
      labelsContainer.isMeasured = true;
    } else {
      labelTemplate.interactionsEnabled = false;
      slicesContainer.isMeasured = false;
      labelsContainer.isMeasured = false;
    }

    var total = 0;
    var count = 0;
    this.dataItems.each(function (dItem) {
      if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_8__["hasValue"](dItem.value)) {
        count++;

        if (dItem.value > 0) {
          total += Math.abs(dItem.getWorkingValue("value") / dItem.value);
        } else {
          if (_this.ignoreZeroValues) {
            count--;
          } else {
            if (!dItem.visible || dItem.__disabled || dItem.isHiding) {
              count--;
            } else {
              total += 1;
            }
          }
        }
      }
    });
    this._total = 1 / count * total;
    this._count = count;

    _super.prototype.validateDataElements.call(this);

    this.arrangeLabels();
  };
  /**
   * [getNextValue description]
   *
   * @todo Description
   * @param dataItem  [description]
   * @return [description]
   */


  FunnelSeries.prototype.getNextValue = function (dataItem) {
    var index = dataItem.index;
    var nextValue = dataItem.getWorkingValue("value");

    if (index < this.dataItems.length - 1) {
      var nextItem = this.dataItems.getIndex(index + 1);
      nextValue = nextItem.getWorkingValue("value");

      if (!nextItem.visible || nextItem.isHiding || nextItem.__disabled || nextItem.value == 0 && this.ignoreZeroValues) {
        return this.getNextValue(nextItem);
      }
    }

    return nextValue;
  };
  /**
   * [formDataElement description]
   *
   * @todo Description
   */


  FunnelSeries.prototype.formDataElement = function () {};
  /**
   * Validates data item's element, effectively redrawing it.
   *
   * @ignore Exclude from docs
   * @param dataItem  Data item
   */


  FunnelSeries.prototype.validateDataElement = function (dataItem) {
    var _this = this; //if ($type.hasValue(dataItem.value)) {
    // FunnelSlice


    var slice = dataItem.slice;
    slice.orientation = this.orientation;
    var sliceLink = dataItem.sliceLink;
    sliceLink.orientation = this.orientation;
    var tick = dataItem.tick;
    var label = dataItem.label;
    tick.slice = slice;
    tick.label = label;

    if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_8__["hasValue"](dataItem.value)) {
      this.decorateSlice(dataItem);
      _core_utils_Array__WEBPACK_IMPORTED_MODULE_9__["each"](dataItem.sprites, function (sprite) {
        if (dataItem.value == 0 && _this.ignoreZeroValues) {
          sprite.__disabled = true;
        } else {
          sprite.__disabled = false;
        }
      });
    } else {
      _core_utils_Array__WEBPACK_IMPORTED_MODULE_9__["each"](dataItem.sprites, function (sprite) {
        sprite.__disabled = true;
      });
    }

    if (dataItem.index == this.dataItems.length - 1) {
      sliceLink.disabled = true;
    } // do this at the end, otherwise bullets won't be positioned properly


    _super.prototype.validateDataElement.call(this, dataItem);

    sliceLink.fill = slice.fill; //}
  };
  /**
   * [decorateSlice description]
   *
   * @todo Description
   * @param dataItem [description]
   */


  FunnelSeries.prototype.decorateSlice = function (dataItem) {
    var slice = dataItem.slice;
    var sliceLink = dataItem.sliceLink;
    var label = dataItem.label;
    var tick = dataItem.tick;
    var maxWidth = this.slicesContainer.innerWidth;
    var maxHeight = this.slicesContainer.innerHeight;
    var nextValue = this.getNextValue(dataItem);
    var workingValue = Math.abs(dataItem.getWorkingValue("value"));
    var bottomRatio = this.bottomRatio;
    var d = 1;

    if (dataItem.value != 0) {
      d = workingValue / Math.abs(dataItem.value);
    } else {
      if (dataItem.__disabled || dataItem.isHiding || !dataItem.visible) {
        d = 0.000001;
      }
    }

    if (this.ignoreZeroValues && dataItem.value == 0) {
      dataItem.__disabled = true;
      return;
    } else {
      dataItem.__disabled = false;
    }

    if (this._nextY == Infinity) {
      this._nextY = 0;
    }

    if (this.orientation == "vertical") {
      var linkHeight = sliceLink.pixelHeight * d;
      maxHeight = maxHeight + linkHeight; // to avoid one link gap in the bottom

      slice.topWidth = workingValue / this.dataItem.values.value.high * maxWidth;
      slice.bottomWidth = (workingValue - (workingValue - nextValue) * bottomRatio) / this.dataItem.values.value.high * maxWidth;
      sliceLink.topWidth = slice.bottomWidth;
      sliceLink.bottomWidth = (workingValue - (workingValue - nextValue)) / this.dataItem.values.value.high * maxWidth;
      slice.y = this._nextY;
      slice.height = Math.min(100000, _core_utils_Math__WEBPACK_IMPORTED_MODULE_6__["max"](0, maxHeight / this._count * d / this._total - linkHeight));
      slice.x = maxWidth / 2;

      if (!this.alignLabels) {
        label.x = slice.x;
      } else {
        label.x = undefined;
      }

      label.y = slice.pixelY + slice.pixelHeight * tick.locationY;
      this._nextY += slice.pixelHeight + linkHeight;
      sliceLink.y = this._nextY - linkHeight;
      sliceLink.x = slice.x;
    } else {
      var linkWidth = sliceLink.pixelWidth * d;
      maxWidth = maxWidth + linkWidth; // to avoid one link gap in the bottom

      slice.topWidth = workingValue / this.dataItem.values.value.high * maxHeight;
      slice.bottomWidth = (workingValue - (workingValue - nextValue) * bottomRatio) / this.dataItem.values.value.high * maxHeight;
      sliceLink.topWidth = slice.bottomWidth;
      sliceLink.bottomWidth = (workingValue - (workingValue - nextValue)) / this.dataItem.values.value.high * maxHeight;
      slice.x = this._nextY;
      slice.width = Math.min(100000, maxWidth / this._count * d * 1 / this._total - linkWidth);
      slice.y = maxHeight / 2;

      if (!this.alignLabels) {
        label.y = slice.y;
      } else {
        label.y = this.labelsContainer.measuredHeight;
      }

      label.x = slice.pixelX + slice.pixelWidth * tick.locationX;
      this._nextY += slice.pixelWidth + linkWidth;
      sliceLink.x = this._nextY - linkWidth;
      sliceLink.y = slice.y;
    }
  };

  FunnelSeries.prototype.getLastLabel = function (index) {
    if (index > 0) {
      var lastLabel = this.labels.getIndex(index);

      if (lastLabel.__disabled || !lastLabel.visible) {
        return this.getLastLabel(index - 1);
      } else {
        return lastLabel;
      }
    }
  };
  /**
   * [arrangeLabels description]
   *
   * @todo Description
   */


  FunnelSeries.prototype.arrangeLabels = function () {
    if (this.alignLabels) {
      var count = this.labels.length;

      if (count > 1) {
        var lastLabel = this.getLastLabel(count - 1);

        if (lastLabel) {
          var lastY = lastLabel.pixelY;
          var lastX = lastLabel.pixelX;

          if (count > 1) {
            for (var i = count - 2; i >= 0; i--) {
              var label = this.labels.getIndex(i);

              if (label.visible && !label.__disabled) {
                if (label.invalid) {
                  label.validate();
                }

                if (this.orientation == "vertical") {
                  if (label.pixelY + label.measuredHeight > lastY) {
                    label.y = Math.min(1000000, lastY - label.measuredHeight);
                  }
                } // horizontal
                else {
                    if (label.pixelX + label.measuredWidth > lastX) {
                      label.x = Math.min(1000000, lastX - label.measuredWidth);
                    }
                  }

                lastY = label.pixelY;
                lastX = label.pixelX;
              }
            }

            lastY = 0;
            lastX = 0;

            for (var i = 0; i < count; i++) {
              var label = this.labels.getIndex(i);

              if (label.visible && !label.__disabled) {
                if (label.invalid) {
                  label.validate();
                }

                if (this.orientation == "vertical") {
                  if (label.pixelY < lastY) {
                    label.y = Math.min(1000000, lastY);
                  }
                } // horizontal
                else {
                    if (label.pixelX < lastX) {
                      label.x = Math.min(1000000, lastX);
                    }
                  }

                lastY += label.measuredHeight;
                lastX += label.measuredWidth;
              }
            }
          }
        }
      }
    }
  };
  /**
   * Positions series bullet.
   *
   * @ignore Exclude from docs
   * @param bullet  Bullet
   */


  FunnelSeries.prototype.positionBullet = function (bullet) {
    _super.prototype.positionBullet.call(this, bullet);

    var dataItem = bullet.dataItem;
    var slice = dataItem.slice;
    var locationX = bullet.locationX;

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_8__["isNumber"](locationX)) {
      locationX = 0.5;
    }

    var locationY = bullet.locationY;

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_8__["isNumber"](locationY)) {
      locationY = 1;
    }

    bullet.x = slice.pixelX + slice.measuredWidth * locationX;
    bullet.y = slice.pixelY + slice.measuredHeight * locationY;
  };

  Object.defineProperty(FunnelSeries.prototype, "orientation", {
    /**
     * @return Orientation
     */
    get: function get() {
      return this.getPropertyValue("orientation");
    },

    /**
     * Orientation of the funnel slices: "horizontal" or "vertical" (default).
     *
     * @default "vertical"
     * @param value Orientation
     */
    set: function set(value) {
      if (this.setPropertyValue("orientation", value)) {
        this.labelsOpposite = this.labelsOpposite;
        this.invalidate();

        if (value == "vertical") {
          this.ticks.template.locationX = 1;
          this.ticks.template.locationY = 0.5;
          this.labels.template.rotation = 0;
          this.layout = "horizontal";
        } else {
          this.ticks.template.locationX = 0.5;
          this.ticks.template.locationY = 1;
          this.labels.template.rotation = -90;
          this.layout = "vertical";
        }
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(FunnelSeries.prototype, "bottomRatio", {
    /**
     * @return {number}
     */
    get: function get() {
      return this.getPropertyValue("bottomRatio");
    },

    /**
     * Indicates how slice's bottom will change in relation to slices top AND
     * next slices top.
     *
     * Basically it's a relative value (0-1) that indicates bottom width
     * position between current slice's top width and the top withd of the next
     * one.
     *
     * The scale goes from 0 (closer to current slice width) to 1 (closer to next
     * slice with).
     *
     * `0` (default) will mean that bottom will be the same as top, resulting in
     * a prefectly square slice.
     *
     * From the data-viz standpoint `0` is a correct setting, since area of the
     * slices will depict their value correctly.
     *
     * `1` will mean that slice will become trapezoid with its bottom matching
     * width of the next slice.
     *
     * `0.5` will make bottom width be in the middle of width of current slice
     * and the next slice.
     *
     * @default 0
     * @param {number}
     */
    set: function set(value) {
      if (this.setPropertyValue("bottomRatio", value)) {
        this.invalidate();
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(FunnelSeries.prototype, "sliceLinks", {
    /**
     * A list of elements linking each actual slice.
     *
     * Please note that links are [[FunnelSlice]] objects, just like real links,
     * so they have all the same configuration options.
     *
     * You can use `template` of this link, to specify how links will look.
     *
     * ```TypeScript
     * series.sliceLinks.template.fillOpacity = 0.5;
     * ```
     * ```JavaScript
     * series.sliceLinks.template.fillOpacity = 0.5;
     * ```
     * ```JSON
     * {
     *   // ...
     *   "series": [{
     *     "type": "FunnelSeries",
     *      // ...
     *      "sliceLinks": {
     *        "fillOpacity": 0.5
     *      }
     *   }]
     * }
     * ```
     *
     * @return Funnel links
     */
    get: function get() {
      if (!this._sliceLinks) {
        var sliceLink = new _elements_FunnelSlice__WEBPACK_IMPORTED_MODULE_2__["FunnelSlice"]();
        sliceLink.applyOnClones = true;
        sliceLink.fillOpacity = 0.5;
        sliceLink.expandDistance = -0.3;
        sliceLink.hiddenState.properties.opacity = 0;

        this._disposers.push(sliceLink);

        this._sliceLinks = new _core_utils_List__WEBPACK_IMPORTED_MODULE_4__["ListTemplate"](sliceLink);

        this._disposers.push(new _core_utils_List__WEBPACK_IMPORTED_MODULE_4__["ListDisposer"](this._sliceLinks));
      }

      return this._sliceLinks;
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Shows hidden series.
   *
   * @param duration  Duration of reveal animation (ms)
   * @return Animation
   */

  FunnelSeries.prototype.show = function (duration) {
    var _this = this;

    var startIndex = this.startIndex;
    var endIndex = this.endIndex;
    var interpolationDuration = this.defaultState.transitionDuration;

    if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_8__["isNumber"](duration)) {
      interpolationDuration = duration;
    }

    if (!_core_Options__WEBPACK_IMPORTED_MODULE_12__["options"].animationsEnabled) {
      interpolationDuration = 0;
    }

    var delay = 0;
    _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_7__["each"](_core_utils_Iterator__WEBPACK_IMPORTED_MODULE_7__["indexed"](this.dataItems.iterator()), function (a) {
      var i = a[0];
      var dataItem = a[1];

      if (_this.sequencedInterpolation) {
        delay = _this.sequencedInterpolationDelay * i + interpolationDuration * (i - startIndex) / (endIndex - startIndex);
      }

      dataItem.show(interpolationDuration, delay, ["value"]);
    });

    var animation = _super.prototype.show.call(this, duration);

    return animation;
  };
  /**
   * Hides series.
   *
   * @param duration  Duration of hiding animation (ms)
   * @return Animation
   */


  FunnelSeries.prototype.hide = function (duration) {
    var _this = this;

    var fields = ["value"];
    var value = 0;
    var startIndex = this.startIndex;
    var endIndex = this.endIndex;
    var delay = 0;
    var interpolationDuration = this.hiddenState.transitionDuration;

    if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_8__["isNumber"](duration)) {
      interpolationDuration = duration;
    }

    if (!_core_Options__WEBPACK_IMPORTED_MODULE_12__["options"].animationsEnabled) {
      interpolationDuration = 0;
    }

    _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_7__["each"](_core_utils_Iterator__WEBPACK_IMPORTED_MODULE_7__["indexed"](this.dataItems.iterator()), function (a) {
      var i = a[0];
      var dataItem = a[1];

      if (_this.sequencedInterpolation) {
        delay = _this.sequencedInterpolationDelay * i + interpolationDuration * (i - startIndex) / (endIndex - startIndex);
      }

      dataItem.hide(interpolationDuration, delay, value, fields);
    });

    var animation = _super.prototype.hide.call(this, duration);

    if (animation && !animation.isFinished()) {
      animation.delay(delay);
    }

    return animation;
  };
  /**
   * @ignore
   */


  FunnelSeries.prototype.setAlignLabels = function (value) {
    _super.prototype.setAlignLabels.call(this, value);

    this.ticks.template.disabled = !value;
    var labelsContainer = this.labelsContainer;

    if (labelsContainer) {
      // do not align
      if (!value) {
        labelsContainer.width = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_10__["percent"])(100);
        labelsContainer.height = Object(_core_utils_Percent__WEBPACK_IMPORTED_MODULE_10__["percent"])(100);
      } //align
      else {
          labelsContainer.height = undefined;
          labelsContainer.width = undefined;
          labelsContainer.margin(10, 10, 10, 10);
        }
    }

    this.labelsOpposite = this.labelsOpposite;
  };

  Object.defineProperty(FunnelSeries.prototype, "labelsOpposite", {
    /**
     * @return Labels on opposite side?
     */
    get: function get() {
      return this.getPropertyValue("labelsOpposite");
    },

    /**
     * Put labels on the oppsite side of the series?
     *
     * This setting is only used if `alignLabels = true`.
     *
     * If set to `true` (default) labels will be drawn to the right (on vertical
     * series), or to the bottom (on horizontal series).
     *
     * If set to `false`, labels will be positioned to the left or top
     * respectively.
     *
     * @default true
     * @since 4.1.13
     * @param  value  Labels on opposite side?
     */
    set: function set(value) {
      this.setPropertyValue("labelsOpposite", value);
      var labelTemplate = this.labels.template;
      var labelAlign = "none";
      var labelValign = "none";

      if (!this.alignLabels) {
        if (this.orientation == "vertical") {
          labelAlign = "center";
        } else {
          labelValign = "middle";
        }
      } else {
        // opposite (left/bottom)
        if (value) {
          this.labelsContainer.toFront(); // left

          if (this.orientation == "vertical") {
            this.ticks.template.locationX = 1;
            labelTemplate.horizontalCenter = "left";
            labelAlign = "right";
          } // bottom
          else {
              this.ticks.template.locationY = 1;
              labelTemplate.horizontalCenter = "right";
              labelValign = "bottom";
            }
        } // non oposite (right/top)
        else {
            this.labelsContainer.toBack(); // right

            if (this.orientation == "vertical") {
              this.ticks.template.locationX = 0;
              labelAlign = "left";
            } // top
            else {
                labelValign = "top";
                this.ticks.template.locationY = 0;
              }
          }
      }

      labelTemplate.align = labelAlign;
      labelTemplate.valign = labelValign;
      this.validateLayout();
      this.ticks.each(function (tick) {
        tick.invalidate();
      });
      this.invalidateDataItems();
    },
    enumerable: true,
    configurable: true
  });
  return FunnelSeries;
}(_PercentSeries__WEBPACK_IMPORTED_MODULE_1__["PercentSeries"]);


/**
 * bboxter class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_5__["registry"].registeredClasses["FunnelSeries"] = FunnelSeries;
_core_Registry__WEBPACK_IMPORTED_MODULE_5__["registry"].registeredClasses["FunnelSeriesDataItem"] = FunnelSeriesDataItem;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/series/LineSeries.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/series/LineSeries.js ***!
  \********************************************************************************/
/*! exports provided: LineSeriesDataItem, LineSeries */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LineSeriesDataItem", function() { return LineSeriesDataItem; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LineSeries", function() { return LineSeries; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _XYSeries__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./XYSeries */ "./node_modules/@amcharts/amcharts4/.internal/charts/series/XYSeries.js");
/* harmony import */ var _core_Sprite__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/Sprite */ "./node_modules/@amcharts/amcharts4/.internal/core/Sprite.js");
/* harmony import */ var _core_Container__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/Container */ "./node_modules/@amcharts/amcharts4/.internal/core/Container.js");
/* harmony import */ var _core_utils_List__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/utils/List */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/List.js");
/* harmony import */ var _LineSeriesSegment__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./LineSeriesSegment */ "./node_modules/@amcharts/amcharts4/.internal/charts/series/LineSeriesSegment.js");
/* harmony import */ var _axes_ValueAxis__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../axes/ValueAxis */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/ValueAxis.js");
/* harmony import */ var _axes_DateAxis__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../axes/DateAxis */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/DateAxis.js");
/* harmony import */ var _axes_DurationAxis__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../axes/DurationAxis */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/DurationAxis.js");
/* harmony import */ var _axes_CategoryAxis__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../axes/CategoryAxis */ "./node_modules/@amcharts/amcharts4/.internal/charts/axes/CategoryAxis.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_elements_Line__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../core/elements/Line */ "./node_modules/@amcharts/amcharts4/.internal/core/elements/Line.js");
/* harmony import */ var _core_elements_Label__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../core/elements/Label */ "./node_modules/@amcharts/amcharts4/.internal/core/elements/Label.js");
/* harmony import */ var _core_elements_Rectangle__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../core/elements/Rectangle */ "./node_modules/@amcharts/amcharts4/.internal/core/elements/Rectangle.js");
/* harmony import */ var _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../core/utils/Iterator */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Iterator.js");
/* harmony import */ var _core_utils_Object__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../core/utils/Object */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Object.js");
/* harmony import */ var _core_utils_Type__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../core/utils/Type */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Type.js");
/* harmony import */ var _core_utils_Array__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../core/utils/Array */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Array.js");
/* harmony import */ var _elements_Bullet__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../elements/Bullet */ "./node_modules/@amcharts/amcharts4/.internal/charts/elements/Bullet.js");
/**
 * Line series module.
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */



















/**
 * ============================================================================
 * DATA ITEM
 * ============================================================================
 * @hidden
 */

/**
 * Defines a [[DataItem]] for [[LineSeries]].
 *
 * @see {@link DataItem}
 */

var LineSeriesDataItem =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(LineSeriesDataItem, _super);
  /**
   * Constructor
   */


  function LineSeriesDataItem() {
    var _this = _super.call(this) || this;

    _this.className = "LineSeriesDataItem";
    return _this;
  }

  return LineSeriesDataItem;
}(_XYSeries__WEBPACK_IMPORTED_MODULE_1__["XYSeriesDataItem"]);


/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Defines [[Series]] for a line graph.
 *
 * @see {@link ILineSeriesEvents} for a list of available Events
 * @see {@link ILineSeriesAdapters} for a list of available Adapters
 * @todo Example
 * @important
 */

var LineSeries =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(LineSeries, _super);
  /**
   * Constructor
   */


  function LineSeries() {
    var _this = _super.call(this) || this;
    /**
     * Minimum distance in pixels between two adjacent points.
     *
     * If the distance is less than this setting, a point is skipped.
     *
     * This allows acceptable performance with huge amounts of data points.
     *
     * @default 0.5
     */


    _this.minDistance = 0.5;
    _this.segments = new _core_utils_List__WEBPACK_IMPORTED_MODULE_4__["ListTemplate"](_this.createSegment());
    _this.segments.template.applyOnClones = true;

    _this._disposers.push(new _core_utils_List__WEBPACK_IMPORTED_MODULE_4__["ListDisposer"](_this.segments));

    _this._disposers.push(_this.segments.template);

    _this._segmentsIterator = new _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_14__["ListIterator"](_this.segments, function () {
      return _this.segments.create();
    });
    _this._segmentsIterator.createNewItems = true;
    _this.className = "LineSeries";
    _this.strokeOpacity = 1;
    _this.fillOpacity = 0;
    _this.connect = true;
    _this.tensionX = 1;
    _this.tensionY = 1;
    _this.autoGapCount = 1.1;
    _this.smoothing = "bezier";
    _this.segmentsContainer = _this.mainContainer.createChild(_core_Container__WEBPACK_IMPORTED_MODULE_3__["Container"]);
    _this.segmentsContainer.isMeasured = false; // line series might have multiple segments and it has a separate sprite for fill and stroke for each segment. So we need to observe all the changes on series and set them on the segments
    // todo: we need list here, otherwise everything will be redrawn event on change of properties like tooltipX or similar.
    // this.addEventListener(SpriteEvent.PROPERTY_CHANGED, this.validateDataElements, false, this);

    _this.bulletsContainer.toFront();

    _this.applyTheme();

    return _this;
  }
  /**
   * Sets defaults that instantiate some objects that rely on parent, so they
   * cannot be set in constructor.
   */


  LineSeries.prototype.applyInternalDefaults = function () {
    _super.prototype.applyInternalDefaults.call(this);

    if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_16__["hasValue"](this.readerTitle)) {
      this.readerTitle = this.language.translate("Line Series");
    }
  };
  /**
   * @ignore
   */


  LineSeries.prototype.createSegment = function () {
    return new _LineSeriesSegment__WEBPACK_IMPORTED_MODULE_5__["LineSeriesSegment"]();
  };
  /**
   * Returns a new/empty DataItem of the type appropriate for this object.
   *
   * @see {@link DataItem}
   * @return Data Item
   */


  LineSeries.prototype.createDataItem = function () {
    return new LineSeriesDataItem();
  };
  /**
   * Inits data item's working values.
   *
   * @param dataItem  Data item
   * @param index     Data item's index
   */


  LineSeries.prototype.setInitialWorkingValues = function (dataItem) {
    // this makes data items animate when added
    var yAxis = this._yAxis.get();

    var xAxis = this._xAxis.get();

    if (this.appeared && this.visible) {
      var previousDataItem = this.dataItems.getIndex(dataItem.index - 1);
      dataItem.component = this; // as these values are set before, we don't know component yet

      if (this.baseAxis == xAxis) {
        if (yAxis instanceof _axes_ValueAxis__WEBPACK_IMPORTED_MODULE_6__["ValueAxis"]) {
          var initialY = yAxis.minZoomed;

          if (previousDataItem) {
            initialY = previousDataItem.values["valueY"].workingValue;
          } // this makes line animate from previous point to newly added point


          dataItem.setWorkingValue("valueY", initialY, 0);
          dataItem.setWorkingValue("valueY", dataItem.values.valueY.value);

          if (xAxis instanceof _axes_DateAxis__WEBPACK_IMPORTED_MODULE_7__["DateAxis"]) {
            dataItem.setWorkingLocation("dateX", dataItem.locations.dateX - 1, 0); // instantly move it to previous

            dataItem.setWorkingLocation("dateX", dataItem.locations.dateX); // animate to it's location
          } else if (xAxis instanceof _axes_DurationAxis__WEBPACK_IMPORTED_MODULE_8__["DurationAxis"]) {
            if (previousDataItem) {
              var value = dataItem.valueX;
              dataItem.setWorkingValue("valueX", previousDataItem.valueX, 0); // instantly move it to previous

              dataItem.setWorkingValue("valueX", value); // animate to new value
            }
          }
        }
      }

      if (this.baseAxis == yAxis) {
        if (xAxis instanceof _axes_ValueAxis__WEBPACK_IMPORTED_MODULE_6__["ValueAxis"]) {
          var initialX = xAxis.minZoomed;

          if (previousDataItem) {
            initialX = previousDataItem.values["valueX"].workingValue;
          }

          dataItem.setWorkingValue("valueX", initialX, 0);
          dataItem.setWorkingValue("valueX", dataItem.values.valueX.value);

          if (yAxis instanceof _axes_DateAxis__WEBPACK_IMPORTED_MODULE_7__["DateAxis"]) {
            dataItem.setWorkingLocation("dateY", dataItem.locations.dateX - 1, 0); // instantly move it to previous

            dataItem.setWorkingLocation("dateY", dataItem.locations.dateY); // animate to it's location
          } else if (yAxis instanceof _axes_DurationAxis__WEBPACK_IMPORTED_MODULE_8__["DurationAxis"]) {
            if (previousDataItem) {
              var value = dataItem.valueY;
              dataItem.setWorkingValue("valueY", previousDataItem.valueY, 0); // instantly move it to previous

              dataItem.setWorkingValue("valueY", value); // animate to new value
            }
          }
        }
      }
    } else {
      if (this.baseAxis == xAxis) {
        if (yAxis instanceof _axes_ValueAxis__WEBPACK_IMPORTED_MODULE_6__["ValueAxis"]) {
          if (xAxis instanceof _axes_DateAxis__WEBPACK_IMPORTED_MODULE_7__["DateAxis"]) {
            dataItem.setWorkingLocation("dateX", dataItem.locations.dateX);
          }

          if (xAxis instanceof _axes_CategoryAxis__WEBPACK_IMPORTED_MODULE_9__["CategoryAxis"]) {
            dataItem.setWorkingLocation("categoryX", dataItem.locations.categoryX);
          }
        }
      }

      if (this.baseAxis == yAxis) {
        if (xAxis instanceof _axes_ValueAxis__WEBPACK_IMPORTED_MODULE_6__["ValueAxis"]) {
          if (yAxis instanceof _axes_DateAxis__WEBPACK_IMPORTED_MODULE_7__["DateAxis"]) {
            dataItem.setWorkingLocation("dateY", dataItem.locations.dateY);
          }

          if (yAxis instanceof _axes_CategoryAxis__WEBPACK_IMPORTED_MODULE_9__["CategoryAxis"]) {
            dataItem.setWorkingLocation("categoryY", dataItem.locations.categoryY);
          }
        }
      }
    }
  };
  /**
   * Updates corresponding legend data item with current values.
   *
   * @ignore Exclude from docs
   * @param dataItem  Data item
   */


  LineSeries.prototype.updateLegendValue = function (dataItem, notRange) {
    _super.prototype.updateLegendValue.call(this, dataItem, notRange); //This is hack to save some methos, used to set tooltip color source only


    if (dataItem && dataItem.segment) {
      this.tooltipColorSource = dataItem.segment;
    }
  };
  /**
   * (Re)validates the whole series, effectively causing it to redraw.
   *
   * @ignore Exclude from docs
   */


  LineSeries.prototype.validate = function () {
    var _this = this;

    _super.prototype.validate.call(this);

    if (this.xAxis && this.yAxis) {
      this._segmentsIterator.reset();

      this.openSegmentWrapper(this._adjustedStartIndex);
      _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_14__["each"](this.axisRanges.iterator(), function (range) {
        _this.openSegmentWrapper(_this._adjustedStartIndex, range);
      });
      _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_14__["each"](this._segmentsIterator.iterator(), function (segment) {
        segment.__disabled = true;
      });
    }
  };
  /**
   * [sliceData description]
   *
   * @todo Description
   */


  LineSeries.prototype.sliceData = function () {
    var startIndex = this.startIndex;
    var endIndex = this.endIndex; // we need extra one item to both sides with values for line series, otherwise the line will not continue out of bounds of the chart while scrolling
    // find first to the left
    // TODO use iterator instead

    for (var i = this.startIndex - 1; i >= 0; i--) {
      var dataItem = this.dataItems.getIndex(i);

      if (dataItem && dataItem.hasValue(this._xValueFields) && dataItem.hasValue(this._yValueFields)) {
        startIndex = i;
        break;
      }
    }

    this._adjustedStartIndex = this.findAdjustedIndex(startIndex, ["stroke", "strokeWidth", "strokeDasharray", "strokeOpacity", "fill", "fillOpacity", "opacity"]); // find first to the right
    // TODO use iterator instead

    for (var i = this.endIndex, len = this.dataItems.length; i < len; i++) {
      var dataItem = this.dataItems.getIndex(i);

      if (dataItem && dataItem.hasValue(this._xValueFields) && dataItem.hasValue(this._yValueFields)) {
        endIndex = i + 1;
        break;
      }
    }

    this._workingStartIndex = startIndex;
    this._workingEndIndex = endIndex;
  };
  /**
   * @ignore
   */


  LineSeries.prototype.findAdjustedIndex = function (adjustedIndex, properties) {
    var _this = this;

    var propertyFields = this.propertyFields;
    var startIndex = adjustedIndex;
    _core_utils_Array__WEBPACK_IMPORTED_MODULE_17__["each"](properties, function (property) {
      if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_16__["hasValue"](propertyFields[property])) {
        for (var i = startIndex; i >= 0; i--) {
          var dataItem = _this.dataItems.getIndex(i);

          if (dataItem) {
            if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_16__["hasValue"](dataItem.properties[property])) {
              if (adjustedIndex > i) {
                adjustedIndex = i;
              }

              break;
            }
          }
        }
      }
    });
    return adjustedIndex;
  };
  /**
   * Wraps openSegment call with iterative solution to prevent stack overflow
   *
   * @param openIndex  Index
   * @param axisRange  Range
   */


  LineSeries.prototype.openSegmentWrapper = function (openIndex, axisRange) {
    var params = {
      "index": openIndex,
      "axisRange": axisRange
    };

    do {
      params = this.openSegment(params.index, params.axisRange);
    } while (params);
  };

  LineSeries.prototype.getSegment = function () {
    var segment = this._segmentsIterator.getFirst();

    segment.series = this;

    if (segment.isDisposed()) {
      this.segments.removeValue(segment);
      return this.getSegment();
    }

    return segment;
  };
  /**
   * [openSegment description]
   *
   * @todo Description
   * @param openIndex  [description]
   * @param axisRange  [description]
   */


  LineSeries.prototype.openSegment = function (openIndex, axisRange) {
    var addToClose = false;
    var points = [];
    openIndex = Math.min(openIndex, this.dataItems.length);
    var endIndex = Math.min(this._workingEndIndex, this.dataItems.length);
    this._workingEndIndex = Math.min(this._workingEndIndex, this.dataItems.length);
    var closeIndex;
    var propertiesChanged = false;
    var segment = this.getSegment();
    segment.strokeDasharray = undefined;
    segment.__disabled = false;

    if (axisRange) {
      segment.parent = axisRange.contents;
      _core_utils_Object__WEBPACK_IMPORTED_MODULE_15__["copyProperties"](axisRange.contents, segment, _core_Sprite__WEBPACK_IMPORTED_MODULE_2__["visualProperties"]);
    } else {
      _core_utils_Object__WEBPACK_IMPORTED_MODULE_15__["copyProperties"](this, segment, _core_Sprite__WEBPACK_IMPORTED_MODULE_2__["visualProperties"]);
      segment.filters.clear();
      segment.parent = this.segmentsContainer;
    }

    this.group.node.removeAttribute("fill");
    var connect = this.connect;
    var valuesFound = false; // some flag to avoid multiple closes if no values found

    for (var i = openIndex; i < endIndex; i++) {
      var dataItem = this.dataItems.getIndex(i);
      dataItem.segment = segment;

      if (dataItem.hasProperties) {
        // if this is first item of segment
        if (i == openIndex) {
          this.updateSegmentProperties(dataItem.properties, segment);
        } else {
          // this time we only need to know if properties changed, so we don't pass segment
          propertiesChanged = this.updateSegmentProperties(dataItem.properties, segment, true);
        }
      }

      if (dataItem.hasValue(this._xValueFields) && dataItem.hasValue(this._yValueFields)) {
        this.addPoints(points, dataItem, this.xField, this.yField);
        valuesFound = true;
      } else {
        // if no values in first data item, go to next
        if (i == openIndex) {
          continue;
        } else {
          // stop cycle
          if (!connect && valuesFound) {
            closeIndex = i;
            break;
          }
        }
      }

      closeIndex = i;

      if (this.baseAxis instanceof _axes_DateAxis__WEBPACK_IMPORTED_MODULE_7__["DateAxis"]) {
        var next = this.dataItems.getIndex(i + 1);

        if (next && this.baseAxis.makeGap(next, dataItem)) {
          addToClose = true;
          break;
        }
      }

      if (propertiesChanged) {
        break;
      }
    }

    return this.closeSegment(segment, points, openIndex, closeIndex, axisRange, addToClose);
  };
  /**
   * [addPoints description]
   *
   * @todo Description
   * @param points    [description]
   * @param dataItem  [description]
   * @param xField    [description]
   * @param yField    [description]
   * @param backwards [description]
   */


  LineSeries.prototype.addPoints = function (points, dataItem, xField, yField, backwards) {
    var point = this.getPoint(dataItem, xField, yField, dataItem.workingLocations[xField], dataItem.workingLocations[yField]);

    if (!backwards) {
      dataItem.point = point;
    }

    points.push(point);
  };
  /**
   * [closeSegment description]
   *
   * @todo Description
   * @param segment    [description]
   * @param points     [description]
   * @param openIndex  [description]
   * @param closeIndex [description]
   * @param axisRange  [description]
   */


  LineSeries.prototype.closeSegment = function (segment, points, openIndex, closeIndex, axisRange, add) {
    var closePoints = [];

    if (this.dataFields[this._xOpenField] || this.dataFields[this._yOpenField] || this.stacked) {
      for (var i = closeIndex; i >= openIndex; i--) {
        var dataItem = this.dataItems.getIndex(i);

        if (dataItem.hasValue(this._xValueFields) && dataItem.hasValue(this._yValueFields)) {
          // not sure, this means that open point will only be added if value is also set for this point, but maybe it's ok.
          this.addPoints(closePoints, dataItem, this.xOpenField, this.yOpenField, true);
        }
      }
    } else {
      var baseAxis = this.baseAxis;
      var count = points.length;
      var xAxis = this.xAxis;
      var yAxis = this.yAxis;

      if (count > 0) {
        if (baseAxis == xAxis) {
          closePoints.push({
            x: points[count - 1].x,
            y: yAxis.basePoint.y
          }); // last x

          closePoints.push({
            x: points[0].x,
            y: yAxis.basePoint.y
          }); // first x
        } else {
          closePoints.push({
            x: xAxis.basePoint.x,
            y: points[count - 1].y
          }); // last y

          closePoints.push({
            x: xAxis.basePoint.x,
            y: points[0].y
          }); // first y
        }
      }
    }

    this.drawSegment(segment, points, closePoints);

    if (add) {
      closeIndex++;
    }

    if (closeIndex < this._workingEndIndex - 1) {
      return {
        "index": closeIndex,
        "axisRange": axisRange
      };
    } else {
      return null;
    }
  };
  /**
   * Draws the line segment.
   *
   * @param segment     Segment
   * @param points      Segment points
   * @param closePoints Segment close points
   */


  LineSeries.prototype.drawSegment = function (segment, points, closePoints) {
    segment.drawSegment(points, closePoints, this.tensionX, this.tensionY);
  };
  /**
   * Segement will get its colors from `this.dataItem`, as thats how
   * `getPropertyValue()` method works.
   *
   * We pass `lineSeriesDataItem.properties` as item here each time when a flag
   * `hasProperties` is set to `true` on data item (this means it can contain
   * some properties set).
   *
   * @param itemProperties  Item properties
   * @param segment         Segment
   * @return Properties changed?
   */


  LineSeries.prototype.updateSegmentProperties = function (itemProperties, segment, checkOnly) {
    var changed = false;
    _core_utils_Object__WEBPACK_IMPORTED_MODULE_15__["each"](itemProperties, function (propertyName, value) {
      // some value must be defined
      if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_16__["hasValue"](value)) {
        var currentValue = segment[propertyName];
        var currentValueStr = void 0; // current value can be Color, number, anything. So we check if it has toString, otherwise just do String().
        // toString() will return hex if it's color. The only problem is that it will return lowercased hex and if we have uppercase in data, it will think that it changed

        if (currentValue) {
          if (currentValue.toString) {
            currentValueStr = currentValue.toString();
          } else {
            currentValueStr = currentValue; // not doing String(currentValue) as this will make all Objects the same
          }
        }

        var valueStr = void 0;

        if (value) {
          if (value.toString) {
            valueStr = value.toString();
          } else {
            valueStr = value; // not doing String(currentValue) as this will make all Objects the same
          }
        }

        if (currentValue == value || currentValueStr != undefined && valueStr != undefined && currentValueStr == valueStr) {// void
        } else {
          if (!checkOnly) {
            segment[propertyName] = value;
          }

          changed = true;
        }
      }
    });
    return changed;
  };

  Object.defineProperty(LineSeries.prototype, "connect", {
    /**
     * @return Connect?
     */
    get: function get() {
      return this.getPropertyValue("connect");
    },

    /**
     * Connect the lines over empty data points?
     *
     * If set to `true` the line will connect two adjacent data points by a
     * straight line. Even if there are data points with missing values
     * in-between.
     *
     * If you set this to `false`, the line will break when there are missing
     * values.
     *
     * @see {@link https://www.amcharts.com/docs/v4/chart-types/xy-chart/#Line_series_with_gaps} for more information about this feature
     * @default true
     * @param value  Connect?
     */
    set: function set(value) {
      if (this.setPropertyValue("connect", value)) {
        this.invalidate();
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(LineSeries.prototype, "tensionX", {
    /**
     * @return Horizontal tension (0-1)
     */
    get: function get() {
      return this.getPropertyValue("tensionX");
    },

    /**
     * Horizontal tension setting of the line (0-1).
     *
     * Can be used to create smoothed lines. It works like this:
     *
     * Accepted values are in the range between 0 and 1. The biggest value (1)
     * will mean that the "tension" is very high, so the line is maximally
     * attracted to the points it connects, hence the straight line.
     *
     * Using smaller numbers will "relax" the tension, creating some curving.
     *
     * The smaller the tension setting, the more relaxed the line and the more
     * wide the curve.
     *
     * This setting is for horizontal tension, meaning the curve will bend in
     * such way that it never goes below or above connecting points. To enable
     * vertical bending as well, use `tensionY`.
     *
     * IMPORTANT: line smoothing works best when data items are placed at regular
     * intervals. For setups where data items are spaced erratically, enabling
     * smoothing might result in awkwardly looking lines.
     *
     * @default 1
     * @param value  Horizontal tension (0-1)
     */
    set: function set(value) {
      this.setPropertyValue("tensionX", value, true);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(LineSeries.prototype, "tensionY", {
    /**
     * @return Vertical tension (0-1)
     */
    get: function get() {
      return this.getPropertyValue("tensionY");
    },

    /**
     * Can be used to create smoothed lines. It works like this:
     *
     * Accepted values are in the range between 0 and 1. The biggest value (1)
     * will mean that the "tension" is very high, so the line is maximally
     * attracted to the points it connects, hence the straight line.
     *
     * Using smaller numbers will "relax" the tension, creating some curving.
     *
     * The smaller the tension setting, the more relaxed the line and the more
     * wide the curve.
     *
     * This setting is for vertical tension, meaning the curve might bend in
     * such way that it will go below or above connected points.
     *
     * Combine this setting with `tensionX` to create beautifully looking
     * smoothed line series.
     *
     * @default 1
     * @param value  Vertical tension (0-1)
     */
    set: function set(value) {
      this.setPropertyValue("tensionY", value, true);
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Creates elements in related legend container, that mimics the look of this
   * Series.
   *
   * @ignore Exclude from docs
   * @param marker  Legend item container
   */

  LineSeries.prototype.createLegendMarker = function (marker) {
    var _this = this;

    var w = marker.pixelWidth;
    var h = marker.pixelHeight;
    marker.disposeChildren();
    var line = marker.createChild(_core_elements_Line__WEBPACK_IMPORTED_MODULE_11__["Line"]);
    line.shouldClone = false; //line.copyFrom(<any>this); coppies events which is not good

    _core_utils_Object__WEBPACK_IMPORTED_MODULE_15__["copyProperties"](this, line, _core_Sprite__WEBPACK_IMPORTED_MODULE_2__["visualProperties"]);
    line.x2 = w;
    line.y = h / 2;
    line.y2 = 0.00001;
    line.visible = true;

    if (this.fillOpacity > 0) {
      var fill = marker.createChild(_core_elements_Rectangle__WEBPACK_IMPORTED_MODULE_13__["Rectangle"]); //fill.copyFrom(<any>this); coppies events which is not good

      _core_utils_Object__WEBPACK_IMPORTED_MODULE_15__["copyProperties"](this, fill, _core_Sprite__WEBPACK_IMPORTED_MODULE_2__["visualProperties"]);
      fill.width = w;
      fill.height = h;
      fill.y = 0;
      fill.strokeOpacity = 0;
      fill.visible = true;
      line.y = 0;
    }

    var legendDataItem = marker.dataItem;
    legendDataItem.color = this.stroke;
    legendDataItem.colorOrig = this.fill;
    _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_14__["eachContinue"](this.bullets.iterator(), function (bullet) {
      if (bullet instanceof _elements_Bullet__WEBPACK_IMPORTED_MODULE_18__["Bullet"] && !bullet.copyToLegendMarker) {
        return false;
      }

      var hasLabels = false;

      if (bullet instanceof _core_Container__WEBPACK_IMPORTED_MODULE_3__["Container"]) {
        // do not copy bullets with labels
        _core_utils_Iterator__WEBPACK_IMPORTED_MODULE_14__["each"](bullet.children.iterator(), function (child) {
          if (child instanceof _core_elements_Label__WEBPACK_IMPORTED_MODULE_12__["Label"]) {
            hasLabels = true;
            return true;
          }
        });
      }

      if (!hasLabels) {
        var clone = bullet.clone();
        clone.parent = marker;
        clone.isMeasured = true;
        clone.tooltipText = undefined;
        clone.x = w / 2;

        if (_this.fillOpacity > 0) {
          clone.y = 0;
        } else {
          clone.y = h / 2;
        }

        clone.visible = true; // otherwise will not transit to color after hiding

        if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_16__["hasValue"](clone.fill)) {
          clone.fill = _this.fill;
        }

        if (!_core_utils_Type__WEBPACK_IMPORTED_MODULE_16__["hasValue"](clone.stroke)) {
          clone.stroke = _this.stroke;
        }

        return false;
      }
    });
  };
  /**
   * @ignore
   */


  LineSeries.prototype.disposeData = function () {
    _super.prototype.disposeData.call(this);

    this.segments.clear();
  };

  Object.defineProperty(LineSeries.prototype, "autoGapCount", {
    /**
     * @return Gap count
     */
    get: function get() {
      return this.getPropertyValue("autoGapCount");
    },

    /**
     * If `connect = false` and distance between two data points is bigger
     * than `baseInterval * autoGapCount`, a line will break automatically.
     *
     * @since 4.2.4
     * @param  value  Gap count
     */
    set: function set(value) {
      this.setPropertyValue("autoGapCount", value, true);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(LineSeries.prototype, "smoothing", {
    /**
     * @return Smoothing algorithm
     */
    get: function get() {
      return this.getPropertyValue("smoothing");
    },

    /**
     * Smoothing algorithm to be used for lines.
     *
     * Available options: `"bezier"` (default), `"monotoneX"`, and `"monotoneY"`.
     *
     * Monotone options are best suited for data with irregular intervals. Use `"monotoneX"` for
     * horizontal lines, and `"monotoneY"` vertical ones.
     *
     * NOTE: Both "monotone" algorithms will ignore `tensionX` and `tensionY` settings.
     *
     * @since 4.10.0
     * @param  value  Smoothing algorithm
     */
    set: function set(value) {
      this.setPropertyValue("smoothing", value, true);
    },
    enumerable: true,
    configurable: true
  });
  return LineSeries;
}(_XYSeries__WEBPACK_IMPORTED_MODULE_1__["XYSeries"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_10__["registry"].registeredClasses["LineSeries"] = LineSeries;
_core_Registry__WEBPACK_IMPORTED_MODULE_10__["registry"].registeredClasses["LineSeriesDataItem"] = LineSeriesDataItem;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/series/LineSeriesSegment.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/series/LineSeriesSegment.js ***!
  \***************************************************************************************/
/*! exports provided: LineSeriesSegment */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LineSeriesSegment", function() { return LineSeriesSegment; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _core_Container__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core/Container */ "./node_modules/@amcharts/amcharts4/.internal/core/Container.js");
/* harmony import */ var _core_Sprite__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/Sprite */ "./node_modules/@amcharts/amcharts4/.internal/core/Sprite.js");
/* harmony import */ var _core_Registry__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/Registry */ "./node_modules/@amcharts/amcharts4/.internal/core/Registry.js");
/* harmony import */ var _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/rendering/Path */ "./node_modules/@amcharts/amcharts4/.internal/core/rendering/Path.js");
/* harmony import */ var _core_utils_Object__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core/utils/Object */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Object.js");
/* harmony import */ var _core_utils_Type__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core/utils/Type */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Type.js");
/* harmony import */ var _core_utils_Color__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../core/utils/Color */ "./node_modules/@amcharts/amcharts4/.internal/core/utils/Color.js");
/* harmony import */ var _core_rendering_Smoothing__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../core/rendering/Smoothing */ "./node_modules/@amcharts/amcharts4/.internal/core/rendering/Smoothing.js");
/**
 * Line series segment module.
 * @todo Add description about what this is
 */

/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */









/**
 * ============================================================================
 * MAIN CLASS
 * ============================================================================
 * @hidden
 */

/**
 * Represents a line series segment.
 *
 * A line segment can be used to apply different properties to a part of the
 * line series, between two data points.
 *
 * @see {@link ILineSeriesSegmentEvents} for a list of available events
 * @see {@link ILineSeriesSegmentAdapters} for a list of available Adapters
 * @todo Example
 */

var LineSeriesSegment =
/** @class */
function (_super) {
  Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(LineSeriesSegment, _super);
  /**
   * Constructor
   */


  function LineSeriesSegment() {
    var _this = // Init
    _super.call(this) || this;

    _this.className = "LineSeriesSegment"; // Set defaults

    _this.isMeasured = false;
    _this.interactionsEnabled = false;
    _this.layout = "none"; // Create fill element

    var fillSprite = _this.createChild(_core_Sprite__WEBPACK_IMPORTED_MODULE_2__["Sprite"]);

    _this.fillSprite = fillSprite;
    fillSprite.shouldClone = false;
    fillSprite.setElement(_this.paper.add("path"));
    fillSprite.isMeasured = false;

    _this._disposers.push(fillSprite); // Create line element


    var strokeSprite = _this.createChild(_core_Sprite__WEBPACK_IMPORTED_MODULE_2__["Sprite"]);

    _this.strokeSprite = strokeSprite;
    strokeSprite.shouldClone = false;
    strokeSprite.fill = Object(_core_utils_Color__WEBPACK_IMPORTED_MODULE_7__["color"])();
    strokeSprite.setElement(_this.paper.add("path"));
    strokeSprite.isMeasured = false;

    _this._disposers.push(strokeSprite);

    return _this;
  }
  /**
   * Draws the series segment.
   *
   * @ignore Exclude from docs
   * @param points       Points to connect
   * @param closePoints  ?
   * @param smoothnessX  Horizontal bezier setting (?)
   * @param smoothnessY  Vertical bezier setting (?)
   */


  LineSeriesSegment.prototype.drawSegment = function (points, closePoints, smoothnessX, smoothnessY) {
    if (!this.disabled) {
      if (points.length > 0 && closePoints.length > 0 && _core_utils_Type__WEBPACK_IMPORTED_MODULE_6__["isNumber"](points[0].x) && _core_utils_Type__WEBPACK_IMPORTED_MODULE_6__["isNumber"](points[0].y)) {
        // first moveTo helps to avoid Chrome straight line in the mask bug.
        var path = _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["moveTo"]({
          x: points[0].x - 0.2,
          y: points[0].y - 0.2
        }) + _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["moveTo"](points[0]);
        var series = this.series;

        if (series.smoothing == "bezier") {
          path += new _core_rendering_Smoothing__WEBPACK_IMPORTED_MODULE_8__["Tension"](smoothnessX, smoothnessY).smooth(points);
        } else if (series.smoothing == "monotoneX") {
          path += new _core_rendering_Smoothing__WEBPACK_IMPORTED_MODULE_8__["MonotoneX"]({
            closed: false
          }).smooth(points);
        } else if (series.smoothing == "monotoneY") {
          path += new _core_rendering_Smoothing__WEBPACK_IMPORTED_MODULE_8__["MonotoneY"]({
            closed: false
          }).smooth(points);
        }

        if (this.strokeOpacity == 0 || this.strokeSprite.strokeOpacity == 0) {// like this and not if != 0, otherwise ranges stroke won't be drawn.
        } else {
          this.strokeSprite.path = path;
        }

        if (this.fillOpacity > 0 || this.fillSprite.fillOpacity > 0) {
          // helps to avoid drawing fill object if fill is not visible
          if (_core_utils_Type__WEBPACK_IMPORTED_MODULE_6__["isNumber"](closePoints[0].x) && _core_utils_Type__WEBPACK_IMPORTED_MODULE_6__["isNumber"](closePoints[0].y)) {
            path += _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["lineTo"](closePoints[0]);

            if (series.smoothing == "bezier") {
              path += new _core_rendering_Smoothing__WEBPACK_IMPORTED_MODULE_8__["Tension"](smoothnessX, smoothnessY).smooth(closePoints);
            } else if (series.smoothing == "monotoneX") {
              path += new _core_rendering_Smoothing__WEBPACK_IMPORTED_MODULE_8__["MonotoneX"]({
                closed: false
              }).smooth(closePoints);
            } else if (series.smoothing == "monotoneY") {
              path += new _core_rendering_Smoothing__WEBPACK_IMPORTED_MODULE_8__["MonotoneY"]({
                closed: false
              }).smooth(closePoints);
            }

            path += _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["lineTo"](points[0]);
            path += _core_rendering_Path__WEBPACK_IMPORTED_MODULE_4__["closePath"]();
            this.fillSprite.path = path;
          }
        }
      } else {
        this.fillSprite.path = "";
        this.strokeSprite.path = "";
      }
    }
  };
  /**
   * Copies properties from a [[Sprite]] to both line and fill elements.
   *
   * @param source Source [[Sprite]] to copy properties from
   */


  LineSeriesSegment.prototype.copyFrom = function (source) {
    _super.prototype.copyFrom.call(this, source);

    var lineElement = this.strokeSprite;
    _core_utils_Object__WEBPACK_IMPORTED_MODULE_5__["copyProperties"](source, lineElement.properties, _core_Sprite__WEBPACK_IMPORTED_MODULE_2__["visualProperties"]);
    lineElement.events.copyFrom(source.strokeSprite.events);
    lineElement.fillOpacity = 0;
    var fillElement = this.fillSprite;
    _core_utils_Object__WEBPACK_IMPORTED_MODULE_5__["copyProperties"](source, fillElement.properties, _core_Sprite__WEBPACK_IMPORTED_MODULE_2__["visualProperties"]);
    fillElement.events.copyFrom(source.fillSprite.events);
    fillElement.strokeOpacity = 0;
  };

  return LineSeriesSegment;
}(_core_Container__WEBPACK_IMPORTED_MODULE_1__["Container"]);


/**
 * Register class in system, so that it can be instantiated using its name from
 * anywhere.
 *
 * @ignore
 */

_core_Registry__WEBPACK_IMPORTED_MODULE_3__["registry"].registeredClasses["LineSeriesSegment"] = LineSeriesSegment;

/***/ }),

/***/ "./node_modules/@amcharts/amcharts4/.internal/charts/series/OHLCSeries.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@amcharts/amcharts4/.internal/charts/series/OHLCSeries.js ***!
  \********************************************************************************/
/*! exports provided: OHLCSeriesDataItem, OHLCSeries */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "OHLCSeriesDataItem", function() { return OHLCSeriesDataItem; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "OHLCSeries", function() { return OHLCSeries; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _CandlestickSeries__WEBPACK_IMPORTED_MODULE