% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup_r5.R
\name{setup_r5}
\alias{setup_r5}
\title{Create a transport network used for routing in R5}
\usage{
setup_r5(
  data_path,
  verbose = FALSE,
  temp_dir = FALSE,
  elevation = "TOBLER",
  overwrite = FALSE
)
}
\arguments{
\item{data_path}{A string pointing to the directory where data inputs are
stored and where the built \code{network.dat} will be saved.}

\item{verbose}{A logical. Whether to show \code{R5} informative messages when
running the function. Defaults to \code{FALSE} (please note that in such case
\code{R5} error messages are still shown). Setting \code{verbose} to \code{TRUE} shows
detailed output, which can be useful for debugging issues not caught by
\code{r5r}.}

\item{temp_dir}{A logical. Whether the \code{R5} Jar file should be saved to a
temporary directory. Defaults to \code{FALSE}.}

\item{elevation}{A string. The name of the impedance function to be used to
calculate impedance for walking and cycling based on street slopes.
Available options include \code{TOBLER} (Default) and \code{MINETTI}, or \code{NONE} to
ignore elevation. R5 loads elevation data from \code{.tif} files saved inside the
\code{data_path} directory. See more info in the Details below.}

\item{overwrite}{A logical. Whether to overwrite an existing \code{network.dat}
or to use a cached file. Defaults to \code{FALSE} (i.e. use a cached network).}
}
\value{
An \code{rJava} object to connect with \code{R5} routing engine.
}
\description{
Builds a multimodal transport network used for routing in \code{R5}, combining
multiple data inputs present in the directory where the network should be
saved to. The directory must contain at least one street network file (in
\code{.osm.pbf} format). It may optionally contain one or more public transport
GTFS feeds (in \code{GTFS.zip} format, where \code{GTFS} is the name of your feed),
when used for public transport routing, and a \code{.tif} file describing the
elevation profile of the study area. If there is more than one GTFS feed in
the directory, all feeds are merged. If there is already a 'network.dat'
file in the directory, the function will simply read it and load it to
memory (unless specified not to do so).
}
\section{Details}{

More information about the \code{TOBLER} and \code{MINETTI} options to calculate the
effects of elevation on travel times can be found in the references below:
\itemize{
\item Campbell, M. J., et al (2019). Using crowdsourced fitness tracker data to
model the relationship between slope and travel rates. Applied geography, 106,
93-107. \doi{10.1016/j.apgeog.2019.03.008}.
\item Minetti, A. E., et al (2002). Energy cost of walking and running at extreme
uphill and downhill slopes. Journal of applied physiology. \doi{10.1152/japplphysiol.01177.2001}.
\item Tobler, W. (1993). Three presentations on geographical analysis and modeling:
Non-isotropic geographic modeling speculations on the geometry of geography
global spatial analysis. Technical Report. National center for geographic
information and analysis. 93 (1). \url{https://escholarship.org/uc/item/05r820mz}.
}
}

\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(r5r)

# directory with street network and gtfs files
data_path <- system.file("extdata/poa", package = "r5r")

r5r_core <- setup_r5(data_path)
\dontshow{\}) # examplesIf}
}
\seealso{
Other setup: 
\code{\link{download_r5}()}
}
\concept{setup}
