% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_r5.R
\name{download_r5}
\alias{download_r5}
\title{Download \code{R5.jar}}
\usage{
download_r5(
  version = "6.8.0",
  quiet = FALSE,
  force_update = FALSE,
  temp_dir = FALSE
)
}
\arguments{
\item{version}{A string. The version of R5 to be downloaded. Defaults to the
latest version.}

\item{quiet}{A logical. Whether to show informative messages when downloading
the file. Defaults to \code{FALSE}.}

\item{force_update}{A logical. Whether to overwrite a previously downloaded
\code{R5.jar} in the local directory. Defaults to \code{FALSE}.}

\item{temp_dir}{A logical. Whether the file should be saved in a temporary
directory. Defaults to \code{FALSE}.}
}
\value{
The path to the downloaded file.
}
\description{
Downloads \code{R5.jar} and saves it locally, inside the package directory.
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(r5r)

download_r5(version = "6.8.0", temp_dir = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
Other setup: 
\code{\link{setup_r5}()}
}
\concept{setup}
