% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{m_center}
\alias{m_center}
\title{Re-center the viewer around the provided selection}
\usage{
m_center(id, sel, animationDuration, fixedPath)
}
\arguments{
\item{id}{R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})}

\item{sel}{Selection specification specifying model and atom
properties to select. Default: all atoms in viewer}

\item{animationDuration}{an optional parameter of milliseconds \code{numeric}
that
denotes the duration of a zoom animation}

\item{fixedPath}{if \code{true} animation is constrained to
requested motion, overriding updates that happen during the animation}
}
\value{
R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})
}
\description{
Re-center the viewer around the provided selection (unlike zoomTo, does not
zoom).
}
\examples{
library(r3dmol)

r3dmol() \%>\%
  m_add_model(data = pdb_6zsl, format = "pdb") \%>\%
  m_set_style(style = list(cartoon = list())) \%>\%
  m_center(animationDuration = 1000)
}
