/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.visitors.ActiveFieldFinder;
import org.jpmml.rexp.Token;

public class FunctionExpression
extends Expression {
    private String namespace = null;
    private String function = null;
    private List<Argument> arguments = null;

    public FunctionExpression(String function, List<Argument> arguments) {
        this(null, function, arguments);
    }

    public FunctionExpression(String namespace, String function, List<Argument> arguments) {
        this.namespace = namespace;
        this.function = function;
        this.arguments = arguments;
    }

    public boolean hasId(String namespace, String function) {
        return (Objects.equals(this.namespace, namespace) || Objects.equals(this.namespace, null)) && Objects.equals(this.function, function);
    }

    public Argument getArgument(String tag, int index) {
        if (tag != null) {
            try {
                return this.getArgument(tag);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this.getArgument(index);
    }

    public Argument getArgument(String tag) {
        if (tag == null) {
            throw new NullPointerException();
        }
        if (this.arguments == null) {
            throw new IllegalArgumentException(tag);
        }
        List<Argument> arguments = this.arguments;
        for (Argument argument : arguments) {
            if (!tag.equals(argument.getTag())) continue;
            return argument;
        }
        throw new IllegalArgumentException(tag);
    }

    public Argument getArgument(int index) {
        if (this.arguments == null) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.arguments.get(index);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public FunctionExpression setNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public String getFunction() {
        return this.function;
    }

    public FunctionExpression setFunction(String function) {
        this.function = function;
        return this;
    }

    public List<Argument> getArguments() {
        if (this.arguments == null) {
            this.arguments = new ArrayList<Argument>();
        }
        return this.arguments;
    }

    public boolean hasArguments() {
        return this.arguments != null && this.arguments.size() > 0;
    }

    public FunctionExpression addArguments(Argument ... arguments) {
        this.getArguments().addAll(Arrays.asList(arguments));
        return this;
    }

    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit((Expression)this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent((PMMLObject)this);
            if (this.hasArguments()) {
                Argument argument;
                List<Argument> arguments = this.getArguments();
                Iterator<Argument> iterator = arguments.iterator();
                while (iterator.hasNext() && (status = PMMLObject.traverse((Visitor)visitor, (Visitable)(argument = iterator.next()).getExpression())) == VisitorAction.CONTINUE) {
                }
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    public static class Argument {
        private Token begin = null;
        private Token end = null;
        private String tag = null;
        private Expression expression = null;

        public Argument(Expression expression) {
            this(null, expression);
        }

        public Argument(String tag, Expression expression) {
            this.setTag(tag);
            this.setExpression(expression);
        }

        public String format() {
            Token begin = this.getBegin();
            Token end = this.getEnd();
            if (begin == null || end == null) {
                throw new IllegalStateException();
            }
            return Argument.format(begin, end);
        }

        public String formatExpression() {
            Token begin = this.getBegin();
            Token end = this.getEnd();
            if (begin == null || end == null) {
                throw new IllegalStateException();
            }
            block0 : switch (begin.next.kind) {
                case 48: 
                case 49: {
                    switch (begin.next.next.kind) {
                        case 23: {
                            begin = begin.next.next;
                            break block0;
                        }
                    }
                    break;
                }
            }
            return Argument.format(begin, end);
        }

        public Set<FieldName> getFieldNames() {
            Expression expression = this.getExpression();
            ActiveFieldFinder activeFieldFinder = new ActiveFieldFinder();
            activeFieldFinder.applyTo((Visitable)expression);
            return activeFieldFinder.getFieldNames();
        }

        Token getBegin() {
            return this.begin;
        }

        void setBegin(Token begin) {
            this.begin = begin;
        }

        Token getEnd() {
            return this.end;
        }

        void setEnd(Token end) {
            this.end = end;
        }

        public String getTag() {
            return this.tag;
        }

        private void setTag(String tag) {
            this.tag = tag;
        }

        public boolean hasTag() {
            return this.tag != null;
        }

        public Expression getExpression() {
            return this.expression;
        }

        private void setExpression(Expression expression) {
            this.expression = expression;
        }

        private static String format(Token begin, Token end) {
            StringBuilder sb = new StringBuilder();
            Token token = begin.next;
            while (token != end) {
                int pos = sb.length();
                if (token != begin.next) {
                    Token specialToken = token.specialToken;
                    while (specialToken != null) {
                        sb.insert(pos, specialToken.image);
                        specialToken = specialToken.specialToken;
                    }
                }
                sb.append(token.image);
                token = token.next;
            }
            return sb.toString();
        }
    }
}

