/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost;

import com.google.common.io.ByteStreams;
import com.google.common.io.LittleEndianDataInputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class XGBoostDataInput
implements Closeable {
    private InputStream is = null;
    private String charset = null;

    public XGBoostDataInput(InputStream is, ByteOrder byteOrder, String charset) {
        if (ByteOrder.BIG_ENDIAN.equals(byteOrder)) {
            this.is = new DataInputStream(is);
        } else if (ByteOrder.LITTLE_ENDIAN.equals(byteOrder)) {
            this.is = new LittleEndianDataInputStream(is);
        } else {
            throw new IllegalArgumentException();
        }
        this.charset = charset;
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    public int readInt() throws IOException {
        return this.asDataInput().readInt();
    }

    public long readLong() throws IOException {
        return this.asDataInput().readLong();
    }

    public float readFloat() throws IOException {
        return this.asDataInput().readFloat();
    }

    public String readString() throws IOException {
        int length = (int)this.readLong();
        byte[] buffer = new byte[length];
        ByteStreams.readFully((InputStream)this.is, (byte[])buffer);
        if (this.charset != null) {
            return new String(buffer, this.charset);
        }
        return new String(buffer);
    }

    public Map<String, String> readStringMap() throws IOException {
        int length = (int)this.readLong();
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (int i = 0; i < length; ++i) {
            result.put(this.readString(), this.readString());
        }
        return result;
    }

    public List<String> readStringList() throws IOException {
        int length = (int)this.readLong();
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < length; ++i) {
            result.add(this.readString());
        }
        return result;
    }

    public void readReserved(int length) throws IOException {
        int[] buffer = new int[length];
        boolean empty = true;
        for (int i = 0; i < length; ++i) {
            int value;
            buffer[i] = value = this.readInt();
            empty &= value == 0;
        }
        if (!empty) {
            throw new IOException("Expected " + length + "-element array of zeroes, got " + Arrays.toString(buffer));
        }
    }

    private DataInput asDataInput() {
        return (DataInput)((Object)this.is);
    }
}

