#' Mathematical constants
#'
#' List of mathematical functions
#'
#' @details
#' const list contains a list of mathematical constants below\cr\cr
#' - pi\cr
#' - e: Euler's number\cr
#' - golden_ratio\cr
#' - euler_mascheroni: Euler-Mascheroni constant\cr
#' - feigenbaum: Feigenbaum constant\cr
#' - champernowne: Champernowne constant\cr
#' - apery: Roger Apery's constant\cr
#' - gelfond_schneider: Gelfond-Schneider constant\cr
#' - khinchin: Aleksandr Khinchin constant\cr
#' - ramanujan_soldner: Ramanujan-Soldner constant\cr
#'
#' @examples
#' # definition of pi
#' const$defs$pi
#'
#' # value of pi
#' const$values$pi
#'
#'
#' @export

const <- list(
  values = list(
    pi = pi,
    e = exp(1),
    golden_ratio = (1 + sqrt(5)) / 2,
    euler_mascheroni = 0.57721566540153546, # sum(1/seq(1,1000000000)) - log(1000000000),
    feigenbaum = 4.6692016091,
    champernowne = strsplit("0.1234567891011121314151617181920212223242526272829303132333435363738394041424344454647484950515253545556575859606162636465666768697071727374757677787980818283848586878889909192939495969798991001011021031041051061071081091101111121131141151161171181191201211221231241251261271281291301311321331341351361371381391401411421431441451461471481491501511521531541551561571581591601611621631641651661671681691701711721731741751761771781791801811821831841851861871881891901911921931941951961971981992002012022032042052062072082092102112122132142152162172182192202212222232242252262272282292302312322332342352362372382392402412422432442452462472482492502512522532542552562572582592602612622632642652662672682692702712722732742752762772782792802812822832842852862872882892902912922932942952962972982993003013023033043053063073083093103113123133143153163173183193203213223233243253263273283293303313323333343353363373383393403413423433443453463473483493503513523533543553563573583593603613623633643653663673683693703713723733743753763773783793803813823833843853863873883893903913923933943953963973983994004014024034044054064074084094104114124134144154164174184194204214224234244254264274284294304314324334344354364374384394404414424434444454464474484494504514524534544554564574584594604614624634644654664674684694704714724734744754764774784794804814824834844854864874884894904914924934944954964974984995005015025035045055065075085095105115125135145155165175185195205215225235245255265275285295305315325335345355365375385395405415425435445455465475485495505515525535545555565575585595605615625635645655665675685695705715725735745755765775785795805815825835845855865875885895905915925935945955965975985996006016026036046056066076086096106116126136146156166176186196206216226236246256266276286296306316326336346356366376386396406416426436446456466476486496506516526536546556566576586596606616626636646656666676686696706716726736746756766776786796806816826836846856866876886896906916926936946956966976986997007017027037047057067077087097107117127137147157167177187197207217227237247257267277287297307317327337347357367377387397407417427437447457467477487497507517527537547557567577587597607617627637647657667677687697707717727737747757767777787797807817827837847857867877887897907917927937947957967977987998008018028038048058068078088098108118128138148158168178188198208218228238248258268278288298308318328338348358368378388398408418428438448458468478488498508518528538548558568578588598608618628638648658668678688698708718728738748758768778788798808818828838848858868878888898908918928938948958968978988999009019029039049059069079089099109119129139149159169179189199209219229239249259269279289299309319329339349359369379389399409419429439449459469479489499509519529539549559569579589599609619629639649659669679689699709719729739749759769779789799809819829839849859869879889899909919929939949959969979989991000", "")[[1]], # Champernowne Constant as a character vector
    apery = 1.2020569032,
    gelfond_schneider = exp(pi),
    khinchin = 2.685452001,
    ramanujan_soldner = 1.4513692348
  ),
  defs = list(
    pi = "Pi is the ratio of a circle's circumference to its diameter and is approximately 3.14159. It is one of the most important mathematical constants and is used in various mathematical and scientific calculations.",
    e = "Euler's number is an irrational number approximately equal to 2.71828. It is the base of the natural logarithm and appears in various mathematical and scientific contexts, such as exponential growth and decay.",
    golden_ratio = "The golden ratio is an irrational number approximately equal to 1.61803. It is often represented by the Greek letter phi (f) and is known for its aesthetically pleasing proportions. It has applications in art, architecture, design, and mathematics.",
    euler_mascheroni = "The Euler-Mascheroni constant is a mathematical constant approximately equal to 0.5772. It is denoted by the symbol <U+03B3> and appears in various mathematical and statistical contexts, such as the harmonic series and the asymptotic behavior of certain functions.",
    feigenbaum = "The Feigenbaum constant is a mathematical constant approximately equal to 4.6692. It appears in the study of chaos theory and describes the universal scaling behavior of certain mathematical sequences.",
    champernowne = "The Champernowne constant is an irrational number obtained by concatenating the positive integers in decimal form. It is often denoted by the symbol C and has applications in number theory and algorithmic randomness.",
    apery = "Apery's constant is an irrational number approximately equal to 1.20206. It was first discovered by the mathematician Roger Apery and appears in the study of number theory, specifically in the context of the Riemann zeta function.",
    gelfond_schneider = "The Gelfond-Schneider constant is a transcendental number approximately equal to 23.14069. It is denoted by the symbol G and is a key constant in number theory and the theory of transcendental numbers.",
    khinchin = "The Khinchin constant is a mathematical constant approximately equal to 2.68545. It appears in the study of continued fractions and provides information about the distribution of the coefficients of these fractions.",
    ramanujan_soldner = "The Ramanujan-Soldner constant is a mathematical constant approximately equal to 1.45137. It is named after the mathematician Srinivasa Ramanujan and appears in various mathematical formulas and series."
  )
)
