% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_by_column.R
\name{sample_by_column}
\alias{sample_by_column}
\title{Re-sample a dataset by column and return number of entry needed}
\usage{
sample_by_column(.dt, col, n, seed = NULL, replace = FALSE)
}
\arguments{
\item{.dt}{data frame to re-sample}

\item{col}{column to uniquely re-sample}

\item{n}{number of rows to return}

\item{seed}{unique numeric value for reproducibility}

\item{replace}{should sampling be with replacement}
}
\value{
data frame containing re-sampled rows from an original data frame
}
\description{
Shorthand to return a re-sample number of rows in a data frame by unique column
}
\examples{
data1 <- data.frame(ID=1:10,MOT=11:20)
sample_by_column(data1,MOT,3)
sample_by_column(data1,ID,7)
}
