% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_queuefunctions.R
\name{lag_step}
\alias{lag_step}
\title{Add lag to vector of arrival times.}
\usage{
lag_step(arrival_df, service)
}
\arguments{
\item{arrival_df}{A dataframe with column names ID and times . The ID column is a key
for the customers. The times column is of class \code{numeric} and represents the
arrival times of the customers.}

\item{service}{A vector of service times with the same ordering as arrival_df.}
}
\value{
A vector of response times for the input of arrival times and service times.
}
\description{
Add lag to vector of arrival times.
}
\examples{
# Create arrival times
arrival_df <- data.frame(ID = c(1:100), times = rlnorm(100, meanlog = 3))

# Create service times
service <- rlnorm(100)
lag_step(arrival_df = arrival_df, service = service)

# lag_step is equivalent to queue_step with a large number of queues, but it's faster to compute.

cbind(queue_step(arrival_df = arrival_df, service = service, servers = 100),
lag_step(arrival_df = arrival_df, service = service))
}
\seealso{
\code{\link{wait_step}}, \code{\link{queue_step}}.
}

