% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{make.fun_if}
\alias{make.fun_if}
\title{Make a Function Conditional on Frequency of Observed Values}
\usage{
make.fun_if(
  fun,
  ...,
  ov.min.default = 1,
  prop.default = TRUE,
  inclusive.default = TRUE,
  false = NA
)
}
\arguments{
\item{fun}{function that takes an atomic vector as its first argument. The
first argument does not have to be named "x" within \code{fun}, but it will
be named "x" in the returned function.}

\item{...}{additional arguments with parameters to \code{fun}. This would be
similar to \code{impute} in \code{sum_if}. However in the current version
of \code{make.fun_if}, the parameters you provide will always be used
within the returned function and cannot be specified by the user of the
returned function. Unfortunately, I cannot figure out how to include
user-specified arguments (with defaults) within the returned function other
than \code{ov.min.default}, \code{prop.default}, and
\code{inclusive.default}.}

\item{ov.min.default}{numeric vector of length 1 specifying what the default
should be for the argument \code{ov.min} within the returned function,
which specifies the minimum frequency of observed values required. If
\code{prop} = TRUE, then this is a decimal between 0 and 1. If \code{prop}
= FALSE, then this is a integer between 0 and \code{length(x)}.}

\item{prop.default}{logical vector of length 1 specifying what the default
should be for the argument \code{prop} within the returned function, which
specifies whether \code{ov.min} should refer to the proportion of observed
values (TRUE) or the count of observed values (FALSE).}

\item{inclusive.default}{logical vector of length 1 speicfying what the
default should be for the argument \code{inclusive} within the returned
function, which specifies whether the function should be evaluated if the
frequency of observed values is exactly equal to \code{ov.min}.}

\item{false}{vector of length 1 specifying what should be returned if the
observed values condition is not met within the returned function. The
default is NA. Whatever the value is, it will be coerced to the same mode
as \code{x} within the returned function.}
}
\value{
function that takes an atomic vector \code{x} as its first argument,
  \code{...} as other arguments, ending with \code{ov.min}, \code{prop}, and
  \code{inclusive} as final arguments with defaults specified by
  \code{ov.min.default}, \code{prop.default}, and \code{inclusive.default},
  respectively.
}
\description{
\code{make.fun_if} makes a function that evaluates conditional on a specified
minimum frequency of observed values. Within the function, if the frequency
of observed values is less than (or equal to) \code{ov.min}, then
\code{false} is returned rather than the return value.
}
\examples{

# SD
sd_if <- make.fun_if(fun = sd, na.rm = TRUE) # always have na.rm = TRUE
sd_if(x = airquality[[1]], ov.min = .75) # proportion of observed values
sd_if(x = airquality[[1]], ov.min = 116,
   prop = FALSE) # count of observed values
sd_if(x = airquality[[1]], ov.min = 116, prop = FALSE,
   inclusive = FALSE) # not include ov.min values itself

# skewness
skew_if <- make.fun_if(fun = psych::skew, type = 1) # always have type = 1
skew_if(x = airquality[[1]], ov.min = .75) # proportion of observed values
skew_if(x = airquality[[1]], ov.min = 116,
   prop = FALSE) # count of observed values
skew_if(x = airquality[[1]], ov.min = 116, prop = FALSE,
   inclusive = FALSE) # not include ov.min values itself

# mode
popular <- function(x) names(sort(table(x), decreasing = TRUE))[1]
popular_if <- make.fun_if(fun = popular) # works with character vectors too
popular_if(x = c(unlist(dimnames(HairEyeColor)), rep.int(x = NA, times = 10)),
   ov.min = .50)
popular_if(x = c(unlist(dimnames(HairEyeColor)), rep.int(x = NA, times = 10)),
   ov.min = .60)
}
\seealso{
\code{\link{sum_if}}
   \code{\link{mean_if}}
}
