% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rollcast.R
\name{rollcast}
\alias{rollcast}
\title{Rolling one-step forecasts of Value at Risk and Expected Shortfall}
\usage{
rollcast(
  x,
  p = 0.95,
  method = c("plain", "age", "vwhs"),
  lambda = c(0.94, 0.98),
  nout = NULL,
  nwin = NULL
)
}
\arguments{
\item{x}{a numeric vector of asset returns}

\item{p}{confidence level for VaR calculation; default is 0.95\%}

\item{method}{method to be used for calculation; default is 'plain'}

\item{lambda}{decay factor for the calculation of weights; default is 0.94
for \emph{method = 'age'} and 0.98 for \emph{method = 'vwhs'}}

\item{nout}{number of out-of-sample observations; default is NULL}

\item{nwin}{window size for rolling one-step forecasting; default is NULL}
}
\value{
Returns a list with the following elements:
\describe{
\item{VaR}{numerical vector containing out-of-sample forecasts of Value at
Risk}
\item{ES}{numerical vector containing out-of-sample forecasts of Expected
Shortfall (Conditional Value at Risk)}
\item{xout}{numerical vector containing out-of-sample returns}
}
}
\description{
Computes rolling one-step forecasts of Value at Risk and Expected Shortfall
(also called Conditional Value at Risk) by means of plain historical
simulation as well as age- and volatility-weighted historical simulation.
}
\examples{

prices <- DAX30$price.close
returns <- diff(log(prices))
n <- length(returns)
nout <- 250 # number of obs. for out-of-sample forecasting
nwin <- 500 # window size for rolling forecasts


### Example 1 - plain historical simulation
results1 <- rollcast(x = returns, p = 0.99, method = 'plain', nout = nout,
                     nwin = nwin)
matplot(1:nout, cbind(-results1$xout, results1$VaR, results1$ES),
  type = 'hll',
  xlab = 'number of out-of-sample obs.', ylab = 'losses, VaR and ES',
  main = 'Plain HS - 99\% VaR and ES for the DAX30 return series'
)

### Example 2 - age weighted historical simulation
results2 <- rollcast(x = returns, p = 0.99, method = 'age', nout = nout,
                     nwin = nwin)
matplot(1:nout, cbind(-results2$xout, results2$VaR, results2$ES),
  type = 'hll',
  xlab = 'number of out-of-sample obs.', ylab = 'losses, VaR and ES',
  main = 'Age weighted HS - 99\% VaR and ES for the DAX30 return series'
)

### Example 3 - volatility weighted historical simulation
results3 <- rollcast(x = returns, p = 0.99, method = 'vwhs', nout = nout,
                     nwin = nwin)
matplot(1:nout, cbind(-results3$xout, results3$VaR, results3$ES),
  type = 'hll',
  xlab = 'number of out-of-sample obs.', ylab = 'losses, VaR and ES',
  main = 'Vol. weighted HS - 99\% VaR and ES for the DAX30 return series'
)
}
