"use strict";

// Generated by CoffeeScript 2.3.2
// iplotMScanone_eff: image of lod curves linked to plot of lod curves, with QTL effects
// Karl W Broman
var iplotMScanone_eff;

iplotMScanone_eff = function iplotMScanone_eff(widgetdiv, lod_data, eff_data, times, chartOpts) {
  var altrectcolor, axispos, c, chartdivid, chrGap, chrlinecolor, chrlinewidth, colors, eff_linecolor, eff_linewidth, eff_nlines, eff_pointcolor, eff_pointsize, eff_pointstroke, eff_ylab, eff_ylim, effect_text, g_heatmap, g_horpanel, g_verpanel, hbot, height, horpanel, horslice, htop, i, j, k, len, len1, linecolor, linewidth, lod_labels, margin, mylodheatmap, nullcolor, nxticks, plotHorSlice, plotVerSlice, rectcolor, ref, ref1, ref10, ref11, ref12, ref13, ref14, ref15, ref16, ref17, ref18, ref19, ref2, ref20, ref21, ref22, ref23, ref24, ref25, ref26, ref27, ref28, ref29, ref3, ref30, ref31, ref32, ref33, ref34, ref4, ref5, ref6, ref7, ref8, ref9, svg, these_pos, title, titlepos, verpanel, verpanel_axis_text, verpanel_xscale, verslice, widgetdivid, width, wleft, wright, x, xlab, xlim, xticks, ylab, zlab, zlim, zmax, zthresh; // chartOpts start

  height = (ref = chartOpts != null ? chartOpts.height : void 0) != null ? ref : 700; // height of chart in pixels

  width = (ref1 = chartOpts != null ? chartOpts.width : void 0) != null ? ref1 : 1000; // width of chart in pixels

  wleft = (ref2 = chartOpts != null ? chartOpts.wleft : void 0) != null ? ref2 : width * 0.65; // width of left panels in pixels

  htop = (ref3 = chartOpts != null ? chartOpts.htop : void 0) != null ? ref3 : height / 2; // height of top panels in pixels

  margin = (ref4 = chartOpts != null ? chartOpts.margin : void 0) != null ? ref4 : {
    left: 60,
    top: 40,
    right: 40,
    bottom: 40,
    inner: 5 // margins in pixels (left, top, right, bottom, inner)

  };
  axispos = (ref5 = chartOpts != null ? chartOpts.axispos : void 0) != null ? ref5 : {
    xtitle: 25,
    ytitle: 30,
    xlabel: 5,
    ylabel: 5 // position of axis labels in pixels (xtitle, ytitle, xlabel, ylabel)

  };
  titlepos = (ref6 = chartOpts != null ? chartOpts.titlepos : void 0) != null ? ref6 : 20; // position of chart title in pixels

  title = (ref7 = chartOpts != null ? chartOpts.title : void 0) != null ? ref7 : ""; // title for chart

  chrGap = (ref8 = chartOpts != null ? chartOpts.chrGap : void 0) != null ? ref8 : 6; // gap between chromosomes in pixels

  rectcolor = (ref9 = chartOpts != null ? chartOpts.rectcolor : void 0) != null ? ref9 : "#e6e6e6"; // color of background rectangle

  altrectcolor = (ref10 = chartOpts != null ? chartOpts.altrectcolor : void 0) != null ? ref10 : "#c8c8c8"; // color of alternate background rectangle

  nullcolor = (ref11 = chartOpts != null ? chartOpts.nullcolor : void 0) != null ? ref11 : "#e6e6e6"; // color for pixels with null values

  chrlinecolor = (ref12 = chartOpts != null ? chartOpts.chrlinecolor : void 0) != null ? ref12 : ""; // color of lines between chromosomes (if "", leave off)

  chrlinewidth = (ref13 = chartOpts != null ? chartOpts.chrlinewidth : void 0) != null ? ref13 : 2; // width of lines between chromosomes

  colors = (ref14 = chartOpts != null ? chartOpts.colors : void 0) != null ? ref14 : ["slateblue", "white", "crimson" // heat map colors
  ];
  zlim = (ref15 = chartOpts != null ? chartOpts.zlim : void 0) != null ? ref15 : null; // z-axis limits

  zthresh = (ref16 = chartOpts != null ? chartOpts.zthresh : void 0) != null ? ref16 : null; // lower z-axis threshold for display in heat map

  xlab = (ref17 = chartOpts != null ? chartOpts.xlab : void 0) != null ? ref17 : null; // x-axis label for LOD heatmap (also used in lower panel)

  ylab = (ref18 = chartOpts != null ? chartOpts.ylab : void 0) != null ? ref18 : ""; // y-axis label for LOD heatmap (also used as x-axis label on effect plot)

  zlab = (ref19 = chartOpts != null ? chartOpts.zlab : void 0) != null ? ref19 : "LOD score"; // z-axis label for LOD heatmap (really the y-axis label in the lower panel)

  eff_ylim = (ref20 = chartOpts != null ? chartOpts.eff_ylim : void 0) != null ? ref20 : null; // y-axis limits for effect plot (right panel)

  eff_ylab = (ref21 = chartOpts != null ? chartOpts.eff_ylab : void 0) != null ? ref21 : ""; // y-axis label for effect plot (right panel)

  linecolor = (ref22 = chartOpts != null ? chartOpts.linecolor : void 0) != null ? ref22 : "darkslateblue"; // line color for LOD curves (lower panel)

  linewidth = (ref23 = chartOpts != null ? chartOpts.linewidth : void 0) != null ? ref23 : 2; // line width for LOD curves (lower panel)

  eff_linecolor = (ref24 = chartOpts != null ? chartOpts.eff_linecolor : void 0) != null ? ref24 : null; // line color for effect plot (right panel)

  eff_linewidth = (ref25 = chartOpts != null ? chartOpts.eff_linewidth : void 0) != null ? ref25 : 2; // width of line for effect plot (right panel)

  eff_pointcolor = (ref26 = chartOpts != null ? chartOpts.eff_pointcolor : void 0) != null ? ref26 : null; // point color for effect plot (right panel)

  eff_pointsize = (ref27 = chartOpts != null ? chartOpts.eff_pointsize : void 0) != null ? ref27 : 0; // point size for effect plot (right panel); 0 means no points

  eff_pointstroke = (ref28 = chartOpts != null ? chartOpts.eff_pointstroke : void 0) != null ? ref28 : "black"; // stroke color for points in effect plot (right panel)

  nxticks = (ref29 = chartOpts != null ? chartOpts.nxticks : void 0) != null ? ref29 : 5; // no. ticks in x-axis for effect plot (right panel), if quantitative scale

  xticks = (ref30 = chartOpts != null ? chartOpts.xticks : void 0) != null ? ref30 : null; // tick positions in x-axis for effect plot (right panel), if quantitative scale

  lod_labels = (ref31 = chartOpts != null ? chartOpts.lod_labels : void 0) != null ? ref31 : null; // labels on the LOD score columns
  // chartOpts end

  chartdivid = (ref32 = chartOpts != null ? chartOpts.chartdivid : void 0) != null ? ref32 : 'chart';
  widgetdivid = d3.select(widgetdiv).attr('id'); // make sure list args have all necessary bits

  margin = d3panels.check_listarg_v_default(margin, {
    left: 60,
    top: 40,
    right: 40,
    bottom: 40,
    inner: 5
  });
  axispos = d3panels.check_listarg_v_default(axispos, {
    xtitle: 25,
    ytitle: 30,
    xlabel: 5,
    ylabel: 5
  });
  wright = width - wleft;
  hbot = height - htop; // fill in zlim

  zmax = d3panels.matrixMaxAbs(lod_data.lod);
  zlim = zlim != null ? zlim : [-zmax, 0, zmax]; // a bit more data set up

  if (times != null) {
    lod_data.y = times;
  } else {
    lod_data.ycat = lod_data.lodname;
  } // hash for [chr][pos] -> posindex


  lod_data.posIndexByChr = d3panels.reorgByChr(lod_data.chrname, lod_data.chr, function () {
    var results;
    results = [];

    for (i in lod_data.pos) {
      results.push(i);
    }

    return results;
  }());

  if (lod_labels != null) {
    // use the lod labels for the lod names
    lod_data.lodname = lod_labels;
  }

  if (lod_data.chrname == null) {
    // create chrname, chrstart, chrend if missing
    lod_data.chrname = d3panels.unique(lod_data.chr);
  }

  if (lod_data.chrstart == null) {
    lod_data.chrstart = [];
    ref33 = lod_data.chrname;

    for (j = 0, len = ref33.length; j < len; j++) {
      c = ref33[j];

      these_pos = function () {
        var results;
        results = [];

        for (i in lod_data.chr) {
          if (lod_data.chr[i] === c) {
            results.push(lod_data.pos[i]);
          }
        }

        return results;
      }();

      lod_data.chrstart.push(d3.min(these_pos));
    }
  }

  if (lod_data.chrend == null) {
    lod_data.chrend = [];
    ref34 = lod_data.chrname;

    for (k = 0, len1 = ref34.length; k < len1; k++) {
      c = ref34[k];

      these_pos = function () {
        var results;
        results = [];

        for (i in lod_data.chr) {
          if (lod_data.chr[i] === c) {
            results.push(lod_data.pos[i]);
          }
        }

        return results;
      }();

      lod_data.chrend.push(d3.max(these_pos));
    }
  } // phenotype x-axis


  x = times != null ? times : function () {
    var results;
    results = [];

    for (i in lod_data.lod[0]) {
      results.push(i);
    }

    return results;
  }();
  xlim = times != null ? d3.extent(times) : [-0.5, x.length - 0.5];
  nxticks = times != null ? nxticks : 0;
  xticks = times != null ? xticks : null; // set up heatmap

  mylodheatmap = d3panels.lodheatmap({
    height: htop,
    width: wleft,
    margin: margin,
    axispos: axispos,
    titlepos: titlepos,
    chrGap: chrGap,
    rectcolor: rectcolor,
    altrectcolor: altrectcolor,
    chrlinecolor: chrlinecolor,
    chrlinewidth: chrlinewidth,
    colors: colors,
    title: title,
    zlim: zlim,
    zthresh: zthresh,
    ylab: ylab,
    yticks: xticks,
    nyticks: nxticks,
    nullcolor: nullcolor,
    tipclass: widgetdivid
  }); // add the heatmap

  svg = d3.select(widgetdiv).select("svg");
  g_heatmap = svg.append("g").attr("id", "heatmap");
  mylodheatmap(g_heatmap, lod_data); // lod vs position (horizontal) panel

  horpanel = d3panels.chrpanelframe({
    height: hbot,
    width: wleft,
    margin: margin,
    axispos: axispos,
    titlepos: titlepos,
    chrGap: chrGap,
    rectcolor: rectcolor,
    altrectcolor: altrectcolor,
    chrlinecolor: chrlinecolor,
    chrlinewidth: chrlinewidth,
    xlab: xlab,
    ylab: zlab,
    ylim: [0, zlim[2] * 1.05],
    tipclass: widgetdivid
  }); // create empty panel

  g_horpanel = svg.append("g").attr("transform", "translate(0," + htop + ")").attr("id", "lodchart");
  horpanel(g_horpanel, {
    chr: lod_data.chrname,
    start: lod_data.chrstart,
    end: lod_data.chrend
  }); // plot lod curves for selected lod column

  horslice = null;

  plotHorSlice = function plotHorSlice(lodcolumn) {
    horslice = d3panels.add_lodcurve({
      linecolor: linecolor,
      linewidth: linewidth,
      pointsize: 0,
      pointcolor: "",
      pointstroke: ""
    });
    return horslice(horpanel, {
      chr: lod_data.chr,
      pos: lod_data.pos,
      marker: lod_data.marker,
      lod: function () {
        var results;
        results = [];

        for (i in lod_data.pos) {
          results.push(d3panels.abs(lod_data.lod[i][lodcolumn]));
        }

        return results;
      }(),
      chrname: lod_data.chrname
    });
  }; // dealing with the possibly multiple QTL effects (like add've and dominance)


  eff_ylim = eff_ylim != null ? eff_ylim : d3panels.matrixExtent(eff_data.map(function (d) {
    return d3panels.matrixExtent(d.data);
  }));
  eff_nlines = eff_data[0].data.length;
  eff_linecolor = eff_linecolor != null ? eff_linecolor : d3panels.selectGroupColors(eff_nlines, "dark");
  eff_pointcolor = eff_pointcolor != null ? eff_pointcolor : d3panels.selectGroupColors(eff_nlines, "dark");
  eff_linecolor = d3panels.forceAsArray(eff_linecolor); // force to be arrays

  eff_pointcolor = d3panels.forceAsArray(eff_pointcolor); // force to be an array
  // lod versus phenotype (vertical) panel

  verpanel = d3panels.panelframe({
    height: htop,
    width: wright,
    margin: margin,
    axispos: axispos,
    titlepos: titlepos,
    xlab: ylab,
    ylab: eff_ylab,
    rectcolor: rectcolor,
    xlim: xlim,
    ylim: eff_ylim,
    nxticks: nxticks,
    xticks: xticks,
    tipclass: widgetdivid
  });
  g_verpanel = svg.append("g").attr("transform", "translate(" + wleft + ",0)").attr("id", "curvechart");
  verpanel(g_verpanel); // add x-axis test if qualitative x-axis scale

  if (times == null) {
    verpanel_axis_text = g_verpanel.append("g").attr("class", "x axis").append("text").text("").attr("y", htop - margin.bottom + axispos.xlabel);
    verpanel_xscale = verpanel.xscale();
  } // plot effect curves for a given position


  verslice = [];
  effect_text = null;

  plotVerSlice = function plotVerSlice(posindex) {
    var this_slice;
    this_slice = d3panels.add_curves({
      linecolor: eff_linecolor,
      linewidth: eff_linewidth
    });
    this_slice(verpanel, {
      x: [x],
      y: eff_data[posindex].data,
      group: function () {
        var results;
        results = [];

        for (i in eff_data[posindex].names) {
          results.push(+i + 1);
        }

        return results;
      }()
    });
    verslice.push(this_slice); // label on each curve

    if (eff_data[posindex].names.length > 1) {
      // label the curves only if there's >1
      return effect_text = g_verpanel.append("g").attr("id", "effect_text").selectAll("empty").data(eff_data[posindex].names).enter().append("text").text(function (d) {
        return d;
      }).attr("x", function (d, i) {
        return wright - margin.right + axispos.ylabel;
      }).attr("y", function (d, i) {
        var z;
        z = eff_data[posindex].data[i];
        return verpanel.yscale()(z[z.length - 1]);
      }).attr("fill", function (d, i) {
        return eff_linecolor[i];
      }).style("dominant-baseline", "middle").style("text-anchor", "start");
    }
  };

  mylodheatmap.cells().on("mouseover", function (d) {
    var p;
    plotHorSlice(d.lodindex);
    g_horpanel.select("g.title text").text("" + lod_data.lodname[d.lodindex]);
    plotVerSlice(lod_data.posIndexByChr[d.chr][d.posindex]);
    p = d3.format(".1f")(d.pos);
    g_verpanel.select("g.title text").text(d.chr + "@" + p);

    if (times == null) {
      return verpanel_axis_text.text("" + lod_data.lodname[d.lodindex]).attr("x", verpanel_xscale(d.lodindex));
    }
  }).on("mouseout", function (d) {
    if (horslice != null) {
      horslice.remove();
    }

    g_horpanel.select("g.title text").text("");

    if (verslice.length > 0) {
      verslice.forEach(function (p) {
        return p.remove();
      });
    }

    g_verpanel.select("g.title text").text("");

    if (times == null) {
      verpanel_axis_text.text("");
    }

    if (effect_text != null) {
      return effect_text.remove();
    }
  });

  if (chartOpts.heading != null) {
    d3.select("div#htmlwidget_container").insert("h2", ":first-child").html(chartOpts.heading).style("font-family", "sans-serif");
  }

  if (chartOpts.caption != null) {
    d3.select("body").append("p").attr("class", "caption").html(chartOpts.caption);
  }

  if (chartOpts.footer != null) {
    return d3.select("body").append("div").html(chartOpts.footer).style("font-family", "sans-serif");
  }
};