% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_onegeno.R
\name{ggplot_onegeno}
\alias{ggplot_onegeno}
\title{Plot one individual's genome-wide genotypes}
\usage{
ggplot_onegeno(
  geno,
  map,
  ind = 1,
  chr = NULL,
  col = NULL,
  shift = FALSE,
  chrwidth = 0.5,
  ...
)
}
\arguments{
\item{geno}{Imputed phase-known genotypes, as a list of matrices
(as produced by \code{\link[qtl2]{maxmarg}}) or a list of
three-dimensional arrays (as produced by \code{\link[qtl2]{guess_phase}}).}

\item{map}{Marker map (a list of vectors of marker positions).}

\item{ind}{Individual to plot, either a numeric index or an ID (can be a vector).}

\item{chr}{Selected chromosomes to plot; a vector of character strings.}

\item{col}{Vector of colors for the different genotypes.}

\item{shift}{If TRUE, shift the chromosomes so they all start at 0.}

\item{chrwidth}{Total width of rectangles for each chromosome, as a
fraction of the distance between them.}

\item{...}{Additional graphics parameters}
}
\value{
object of class \code{\link[ggplot2]{ggplot}}.
}
\description{
Plot one individual's genome-wide genotypes
}
\examples{
# load qtl2 package for data and genoprob calculation
library(qtl2)

# read data
iron <- read_cross2(system.file("extdata", "iron.zip", package="qtl2"))

# insert pseudomarkers into map
map <- insert_pseudomarkers(iron$gmap, step=1)

# calculate genotype probabilities
probs <- calc_genoprob(iron, map, error_prob=0.002)

# inferred genotypes
geno <- maxmarg(probs)

# plot the inferred genotypes for the first individual
ggplot_onegeno(geno, map, shift = TRUE)

# plot the inferred genotypes for the first four individuals
ggplot_onegeno(geno, map, ind=1:4)
}
