% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbind_fst_genoprob.R
\name{cbind.fst_genoprob}
\alias{cbind.fst_genoprob}
\title{Join genotype probabilities for different chromosomes}
\usage{
\method{cbind}{fst_genoprob}(..., fbase = NULL, fdir = NULL, overwrite = FALSE, quiet = FALSE)
}
\arguments{
\item{...}{Genotype probability objects as produced by
\code{\link[=fst_genoprob]{fst_genoprob()}}. Must have the same set of individuals.}

\item{fbase}{Base of fileame for fst database.
Needed if objects have different fst databases.}

\item{fdir}{Directory for fst database.}

\item{overwrite}{If FALSE (the default), refuse to overwrite existing \code{.fst} files.}

\item{quiet}{If TRUE, don't show any messages. Passed to \code{\link[=fst_genoprob]{fst_genoprob()}}.}
}
\value{
A single genotype probability object.
}
\description{
Join multiple genotype probability objects, as produced by
\code{\link[=fst_genoprob]{fst_genoprob()}} for different individuals.
}
\examples{
library(qtl2)
grav2 <- read_cross2(system.file("extdata", "grav2.zip", package="qtl2"))
map <- insert_pseudomarkers(grav2$gmap, step=1)
probsA <- calc_genoprob(grav2[1:5,1:2], map, error_prob=0.002)
probsB <- calc_genoprob(grav2[1:5,3:4], map, error_prob=0.002)
dir <- tempdir()
fprobsA <- fst_genoprob(probsA, "exampleAc", dir, overwrite=TRUE)
fprobsB <- fst_genoprob(probsB, "exampleBc", dir, overwrite=TRUE)

# use cbind to combine probabilities for same individuals but different chromosomes
fprobs <- cbind(fprobsA, fprobsB, fbase = "exampleABc", overwrite=TRUE)

# clean up: remove all the files we created
unlink(fst_files(fprobsA))
unlink(fst_files(fprobsB))
unlink(fst_files(fprobs))

}
\seealso{
\code{\link[=rbind.fst_genoprob]{rbind.fst_genoprob()}}
}
