% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_dup_markers.R
\name{find_dup_markers}
\alias{find_dup_markers}
\title{Find markers with identical genotype data}
\usage{
find_dup_markers(cross, chr, exact_only = TRUE, adjacent_only = FALSE)
}
\arguments{
\item{cross}{Object of class \code{"cross2"}. For details, see the
\href{https://kbroman.org/qtl2/assets/vignettes/developer_guide.html}{R/qtl2 developer guide}.}

\item{chr}{Optional vector specifying which chromosomes to consider.
This may be a logical, numeric, or character string vector.}

\item{exact_only}{If TRUE, look only for markers that have matching
genotypes and the same pattern of missing data; if FALSE, also look for
cases where the observed genotypes at one marker match those at
another, and where the first marker has missing genotype whenever the
genotype for the second marker is missing.}

\item{adjacent_only}{If TRUE, look only for sets of markers that are
adjacent to each other.}
}
\value{
A list of marker names; each component is a set of markers whose
genotypes match one other marker, and the name of the component is the
name of the marker that they match.
}
\description{
Identify sets of markers with identical genotype data.
}
\details{
If \code{exact.only=TRUE}, we look only for groups of markers whose
pattern of missing data and observed genotypes match exactly.  One
marker (chosen at random) is selected as the name of the group (in the
output of the function).

If \code{exact.only=FALSE}, we look also for markers whose observed genotypes
are contained in the observed genotypes of another marker.  We use a
pair of nested loops, working from the markers with the most observed
genotypes to the markers with the fewest observed genotypes.
}
\examples{
grav2 <- read_cross2(system.file("extdata", "grav2.zip", package="qtl2"))
dup <- find_dup_markers(grav2)
grav2_nodup <- drop_markers(grav2, unlist(dup))
}
\seealso{
\code{\link[=drop_markers]{drop_markers()}}, \code{\link[=drop_nullmarkers]{drop_nullmarkers()}}, \code{\link[=reduce_markers]{reduce_markers()}}
}
\keyword{utilities}
