### [R/qtl2](https://kbroman.org/qtl2/)

[![R build status](https://github.com/rqtl/qtl2/workflows/R-CMD-check/badge.svg)](https://github.com/rqtl/qtl2/actions)
[![CRAN_Status_Badge](https://www.r-pkg.org/badges/version/qtl2)](https://cran.r-project.org/package=qtl2)

[Karl Broman](https://kbroman.org)

[R/qtl2](https://kbroman.org/qtl2/) (aka qtl2) is a reimplementation of
the QTL analysis software [R/qtl](https://rqtl.org), to better handle
high-dimensional data and complex cross designs.

Also see the related package,
[qtl2convert](https://github.com/rqtl/qtl2convert), for converting
data among the R/qtl2,
[DOQTL](https://www.bioconductor.org/packages/3.9/bioc/html/DOQTL.html),
and [R/qtl](https://rqtl.org) formats.

---

### Installation

Install R/qtl2 from [CRAN](https://cran.r-project.org):

    install.packages("qtl2")

---

### Vignettes

- [user guide](https://kbroman.org/qtl2/assets/vignettes/user_guide.html)
- [input file formats](https://kbroman.org/qtl2/assets/vignettes/input_files.html)
  (see also the
  [sample data files](https://kbroman.org/qtl2/pages/sampledata.html)
  and the [qtl2data repository](https://github.com/rqtl/qtl2data))
- [preparing DO mouse data for R/qtl2](https://kbroman.org/qtl2/pages/prep_do_data.html)
- [differences between R/qtl and R/qtl2](https://kbroman.org/qtl2/assets/vignettes/rqtl_diff.html)
- [developer guide](https://kbroman.org/qtl2/assets/vignettes/developer_guide.html)
- [HMM benchmarks](https://kbroman.org/qtl2/assets/vignettes/hmm_benchmarks.html)

---

### Citation

To cite R/qtl2 in publications, use:

> Broman KW, Gatti DM, Simecek P, Furlotte NA, Prins P, Sen &#346;,
> Yandell BS, Churchill GA (2018)
> R/qtl2: software for mapping quantitative trait loci with
> high-dimensional data and multi-parent populations.
> [Genetics](https://www.genetics.org) 211:495-502
> [doi:10.1534/genetics.118.301595](https://doi.org/10.1534/genetics.118.301595)

---

### License

Licensed under [GPL-3](https://www.r-project.org/Licenses/GPL-3).
