% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qspray.R
\name{derivQspray}
\alias{derivQspray}
\title{Partial derivative}
\usage{
derivQspray(qspray, i, derivative = 1)
}
\arguments{
\item{qspray}{object of class \code{qspray}}

\item{i}{integer, the dimension to differentiate with respect to}

\item{derivative}{integer, how many times to differentiate}
}
\value{
A \code{qspray} object.
}
\description{
Partial derivative of a qspray polynomial.
}
\examples{
library(qspray)
x <- qlone(1)
y <- qlone(2)
qspray <- 2*x  + 3*x*y
derivQspray(qspray, 1)
}
