% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ratio_fun.R
\name{qfpm}
\alias{qfpm}
\alias{qfm_Ap_int}
\alias{qfpm_ABpq_int}
\alias{qfpm_ABDpqr_int}
\title{Moment of (product of) quadratic forms in normal variables}
\usage{
qfm_Ap_int(
  A,
  p = 1,
  mu = rep.int(0, n),
  Sigma = diag(n),
  use_cpp = TRUE,
  cpp_method = "double",
  tol_zero = .Machine$double.eps * 100,
  tol_sing = .Machine$double.eps * 100
)

qfpm_ABpq_int(
  A,
  B,
  p = 1,
  q = 1,
  mu = rep.int(0, n),
  Sigma = diag(n),
  use_cpp = TRUE,
  cpp_method = "double",
  tol_zero = .Machine$double.eps * 100,
  tol_sing = .Machine$double.eps * 100
)

qfpm_ABDpqr_int(
  A,
  B,
  D,
  p = 1,
  q = 1,
  r = 1,
  mu = rep.int(0, n),
  Sigma = diag(n),
  use_cpp = TRUE,
  cpp_method = "double",
  tol_zero = .Machine$double.eps * 100,
  tol_sing = .Machine$double.eps * 100
)
}
\arguments{
\item{A, B, D}{Argument matrices. Should be square. Will be automatically symmetrized.}

\item{p, q, r}{Exponents for \eqn{\mathbf{A}}, \eqn{\mathbf{B}}, and \eqn{\mathbf{D}},
respectively. By default, these are set to the same value.
If unsure, specify all explicitly.}

\item{mu}{Mean vector \eqn{\bm{\mu}} for \eqn{\mathbf{x}}}

\item{Sigma}{Covariance matrix \eqn{\mathbf{\Sigma}} for \eqn{\mathbf{x}}}

\item{use_cpp}{Logical to specify whether the calculation is done with \code{C++}
functions via \code{Rcpp}. \code{TRUE} by default.}

\item{cpp_method}{Variable type used in \code{C++} calculations.
In these functions this is ignored.}

\item{tol_zero}{Tolerance against which numerical zero is determined.  Used to determine,
e.g., whether \code{mu} is a zero vector, \code{A} or \code{B} equals
the identity matrix, etc.}

\item{tol_sing}{Tolerance against which matrix singularity and rank are determined.
The eigenvalues smaller than this are considered zero.}
}
\value{
A \code{\link[=new_qfrm]{qfpm}} object which has the same elements as those
returned by the \code{\link{qfrm}} functions.
Use \code{$statistic} to access the value of the moment.
}
\description{
Functions to obtain (compound) moments
of a product of quadratic forms in normal variables, i.e.,
\eqn{ \mathrm{E} \left(
  (\mathbf{x^\mathit{T} A x})^p (\mathbf{x^\mathit{T} B x})^q
  (\mathbf{x^\mathit{T} D x})^r \right) },
where \eqn{\mathbf{x} \sim N_n(\bm{\mu}, \mathbf{\Sigma})}.

\code{qfm_Ap_int()} is for \eqn{q = r = 0} (simple moment)

\code{qfpm_ABpq_int()} is for \eqn{r = 0}

\code{qfpm_ABDpqr_int()} is for the product of all three powers
}
\details{
These functions implement the super-short recursion algorithms described in
Hillier et al. (2014: sec. 3.1--3.2 and 4).
At present, only positive integers are accepted as exponents
(negative exponents yield ratios, of course). All these yield exact results.
}
\examples{
## Some symmetric matrices and parameters
nv <- 4
A <- diag(nv:1)
B <- diag(sqrt(1:nv))
D <- diag((1:nv)^2 / nv)
mu <- nv:1 / nv
Sigma <- matrix(0.5, nv, nv)
diag(Sigma) <- 1

## Expectation of (x^T A x)^2 where x ~ N(0, I)
qfm_Ap_int(A, 2)

## This is the same but obviously less efficient
qfpm_ABpq_int(A, p = 2, q = 0)

## Expectation of (x^T A x) (x^T B x) (x^T D x) where x ~ N(0, I)
qfpm_ABDpqr_int(A, B, D, 1, 1, 1)

## Expectation of (x^T A x) (x^T B x) (x^T D x) where x ~ N(mu, Sigma)
qfpm_ABDpqr_int(A, B, D, 1, 1, 1, mu = mu, Sigma = Sigma)

## Expectations of (x^T x)^2 where x ~ N(0, I) and x ~ N(mu, I)
## i.e., roundabout way to obtain moments of
## central and noncentral chi-square variables
qfm_Ap_int(diag(nv), 2)
qfm_Ap_int(diag(nv), 2, mu = mu)

}
\seealso{
\code{\link{qfrm}} and \code{\link{qfmrm}} for moments of ratios
}
