% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synonyms.R
\name{synonyms}
\alias{synonyms}
\alias{syn}
\alias{synonyms_frame}
\alias{syn_frame}
\title{Search For Synonyms}
\usage{
synonyms(terms, return.list = TRUE, multiwords = TRUE,
  report.null = TRUE, synonym.frame = qdapDictionaries::key.syn)

syn(terms, return.list = TRUE, multiwords = TRUE, report.null = TRUE,
  synonym.frame = qdapDictionaries::key.syn)

synonyms_frame(synonym.list, prior.frame)

syn_frame(synonym.list, prior.frame)
}
\arguments{
\item{terms}{The terms to find synonyms for.}

\item{return.list}{logical.  If \code{TRUE} returns the output for multiple 
synonyms as a list by search term rather than a vector.}

\item{multiwords}{logical.  IF \code{TRUE} retains vector elements that 
contain phrases (defined as having one or more spaces) rather than a single 
word.}

\item{report.null}{logical.  If \code{TRUE} reports the words that no match 
was found at the head of the output.}

\item{synonym.frame}{A dataframe or hash key of positive/negative words and weights.}

\item{synonym.list}{A named list of lists (or vectors) of synonyms.}

\item{prior.frame}{A prior synonyms data.frame in the format produced by 
\code{synonyms_frame}.}
}
\value{
Returns a list of vectors or vector of possible words that match 
term(s).
}
\description{
\code{synonyms} - Search for synonyms that match term(s).

\code{synonyms_frame} - Generate a synonym lookup hash key 
for use with the \code{synonym.frame} argument in the \code{synonym} 
function.
}
\examples{
\dontrun{
synonyms(c("the", "cat", "job", "environment", "read", "teach"))
head(syn(c("the", "cat", "job", "environment", "read", "teach"), 
    return.list = FALSE), 30)
syn(c("the", "cat", "job", "environment", "read", "teach"), multiwords = FALSE)

## User defined synonym lookup
syn_dat <- list(
    like = list(c("want", "desire"), c("love", "care")),
    show = list(c("reveal"), c("movie", "opera")),
    R = c("old friend", "statistics language")
)

synonyms_frame(syn_dat)
syn(c("R", "show"), synonym.frame = syn_frame(syn_dat))

syns.hash <- syn_frame(syn_dat, prior.frame = qdapDictionaries::key.syn)
syn(c("R", "show", "like", "robot"), synonym.frame = syns.hash)
}
}
\references{
The synonyms dictionary (see \code{\link[qdapDictionaries]{key.syn}}) was 
generated by web scraping the 
\href{http://dictionary.reverso.net/english-synonyms/}{Reverso Online Dictionary}.
The word list fed to \href{http://dictionary.reverso.net/english-synonyms/}{Reverso} 
is the unique words from the combination of \code{\link[qdapDictionaries]{DICTIONARY}} 
and \code{\link[qdapDictionaries]{labMT}}.
}
