\name{cm_time2long}
\alias{cm_time2long}
\title{Transform Codes to Start-End Times}
\usage{
  cm_time2long(..., v.name = "variable", list.var = TRUE,
    start.end = FALSE, debug = TRUE)
}
\arguments{
  \item{\ldots}{List object(s) in the form generated by
  \code{\link[qdap]{cm_time.temp}}.}

  \item{v.name}{An optional name for the column created for
  the list.var argument}

  \item{list.var}{logical.  If TRUE creates a column for
  the data frame created by each time.list passed to
  \code{cm_t2l}.}

  \item{start.end}{logical. If TRUE outputs stop and end
  times for each \code{\link[qdap]{cm_time.temp}} list
  object.}

  \item{debug}{logical. If TRUE debugging mode is on.
  \code{\link[qdap]{cm_time2long}} will return possible
  errors in time span inputs.}
}
\value{
  Generates a dataframe of start and end times for each
  code.
}
\description{
  Transforms the range coding structure(s) from
  cm_time.temp (in list format) into a data frame of start
  and end times in long format.
}
\examples{
\dontrun{
x <- list(
    transcript_time_span = qcv(00:00 - 1:12:00),
    A = qcv(terms = "2.40:3.00, 5.01, 6.02:7.00, 9.00"),
    B = qcv(terms = "2.40, 3.01:3.02, 5.01, 6.02:7.00,
        9.00, 1.12.00:1.19.01"),
    C = qcv(terms = "2.40:3.00, 5.01, 6.02:7.00, 9.00, 17.01")
)
(dat <- cm_time2long(x))
gantt_wrap(dat, "code", border.color = "black", border.size = 5)
}
}
\references{
  Miles, M. B. & Huberman, A. M. (1994). An expanded
  sourcebook: Qualitative data analysis. 2nd ed. Thousand
  Oaks, CA: SAGE Publications.
}
\seealso{
  \code{\link{cm_df2long}}, \code{\link{cm_time.temp}}
}
\keyword{coding,}
\keyword{time-span}

