% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npqcd.R
\name{npqcd}
\alias{npqcd}
\title{It creates a data object for Non Parametric Quality Control}
\usage{
npqcd(x, G = NULL, data.name = NULL)
}
\arguments{
\item{x}{a matrix or data-frame or array which it should contain data. Dimension has to be the same as that of the observations.}

\item{G}{The x as a matrix, data frame or list. If it is a matrix or data frame, then each row is viewed as one multivariate observation.}

\item{data.name}{a string that specifies the title displayed on the plots. 
If not provided it is taken from the name of the object x.}
}
\description{
It creates an object of class 'npqcd' to perform statistical quality control.
This object is used to plot Non Parametric Multivariate Control Charts.
}
\examples{

library(qcr)

set.seed(356)
data <- matrix(rnorm(999), nc = 3)
x <-rexp(999,0.5) 
x <-matrix(x,ncol=3) 
data.npqcd <- npqcd(data,x)
str(data.npqcd)
}
