% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify.R
\name{modify_in}
\alias{modify_in}
\alias{assign_in}
\title{Modify a pluck location}
\usage{
modify_in(.x, .where, .f, ...)

assign_in(x, where, value)
}
\arguments{
\item{.x, x}{A vector or environment}

\item{.where, where}{A pluck location, as a numeric vector of
positions, a character vector of names, or a list combining both.
The location must exist in the data structure.}

\item{.f}{A function to apply at the pluck location given by \code{.where}.}

\item{...}{Arguments passed to \code{.f}.}

\item{value}{A value to replace in \code{.x} at the pluck location.}
}
\description{
\itemize{
\item \code{assign_in()} takes a data structure and a \link{pluck} location,
assigns a value there, and returns the modified data structure.
\item \code{modify_in()} applies a function to a pluck location, assigns the
result back to that location with \code{\link[=assign_in]{assign_in()}}, and returns the
modified data structure.
}

The pluck location must exist.
}
\examples{
# Recall that pluck() returns a component of a data structure that
# might be arbitrarily deep
x <- list(list(bar = 1, foo = 2))
pluck(x, 1, "foo")

# Use assign_in() to modify the pluck location:
assign_in(x, list(1, "foo"), 100)

# modify_in() applies a function to that location and update the
# element in place:
modify_in(x, list(1, "foo"), ~ .x * 200)

# Additional arguments are passed to the function in the ordinary way:
modify_in(x, list(1, "foo"), `+`, 100)
}
\seealso{
\code{\link[=pluck]{pluck()}}
}
