% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stops.R
\name{stop_information}
\alias{stop_information}
\title{Information for a given stop (metropolitan and V/Line stations only)}
\usage{
stop_information(
  stop_id,
  route_type,
  user_id = determine_user_id(),
  api_key = determine_api_key()
)
}
\arguments{
\item{stop_id}{Integer stop ID.}

\item{route_type}{A route type which can be provided either as a non-negative
integer code, or as a character: "Tram", "Train", "Bus", "Vline" or "Night
Bus". Character inputs are not case-sensitive. Use the \code{route_types}
function to extract a vector of all route types.}

\item{user_id}{Integer or character. A user ID or devid provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}

\item{api_key}{Character. An API key, with dashes, provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}
}
\value{
A single-row tibble with the following columns: \itemize{
\item{\code{stop_id}}
\item{\code{stop_name}}
\item{\code{route_type}}
\item{\code{station_details_id}}
\item{\code{station_type}}
\item{\code{station_description}}
\item{\code{point_id}}
\item{\code{mode_id}}
\item{\code{operating_hours}}
\item{\code{flexible_stop_opening_hours}}
\item{\code{stop_contact}}
\item{\code{stop_ticket}}
\item{\code{stop_location}}
\item{\code{stop_amenities}}
\item{\code{stop_accessibility}}
\item{\code{stop_staffing}}
\item{\code{disruption_ids}}
}
}
\description{
This function can be used when integer stop ID is already known. This can be
searched for with either the \code{stops_on_route} or \code{stops_nearby} functions.
}
