% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route-types.R
\name{route_types}
\alias{route_types}
\title{Retrieve a translation from route type number to name}
\usage{
route_types(user_id = determine_user_id(), api_key = determine_api_key())
}
\arguments{
\item{user_id}{Integer or character. A user ID or devid provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}

\item{api_key}{Character. An API key, with dashes, provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}
}
\value{
A named integer vector in which the values are the route type
descriptions, and the names of the vector are the route type numbers.
}
\description{
Route types (tram, train, etc.) are provided to the PTV API as an integer
code. This function retrieves a named vector in which the values are the
route type descriptions, and the names of the vector are the route type
numbers. Note that "Night Bus" is a separate route type.
}
\examples{
\dontrun{
route_types()
}

}
