% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychrolib.R
\name{GetSpecificHumFromHumRatio}
\alias{GetSpecificHumFromHumRatio}
\title{Return the specific humidity from humidity ratio (aka mixing ratio).}
\usage{
GetSpecificHumFromHumRatio(HumRatio)
}
\arguments{
\item{HumRatio}{A numeric vector of humidity ratio in lb_H2O lb_Dry_Air-1 [IP] or kg_H2O kg_Dry_Air-1 [SI]}
}
\value{
A numeric vector of specific humidity in lb_H2O lb_Air-1 [IP] or kg_H2O kg_Air-1 [SI]
}
\description{
Return the specific humidity from humidity ratio (aka mixing ratio).
}
\examples{
SetUnitSystem("IP")
GetSpecificHumFromHumRatio(seq(0.006, 0.016, 0.001))

SetUnitSystem("SI")
GetSpecificHumFromHumRatio(seq(0.006, 0.016, 0.001))

}
\references{
ASHRAE Handbook - Fundamentals (2017) ch. 1 eqn 9b
}
