% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/composites.R
\name{estimate_length_sb}
\alias{estimate_length_sb}
\title{Inverse Spearman-Brown formula to estimate the amount by which a measure would have to be lengthened or shorted to achieve a desired level of reliability}
\usage{
estimate_length_sb(rel_initial, rel_desired)
}
\arguments{
\item{rel_initial}{Initial reliability of a measure.}

\item{rel_desired}{Desired reliability of a lengthened or shortened measure.}
}
\value{
The estimated number of times by which the number of items in the initial measure would have to be multiplied to achieve the desired reliability.
}
\description{
This function implements the inverse of the Spearman-Brown prophecy formula and answers the question: "How much would I have to increase (do decrease) the length of this measure
to obtain a desired reliability level given the current reliability of the measure?" The result of the function is the multiplier by which the length of the original measure should be adjusted.
The formula implemented here assumes that all items added to (or subtracted from) the measure will be parallel forms of the original items.
}
\details{
This is computed as:

\deqn{k^{*}=\frac{\rho_{XX}^{*}(\rho_{XX}-1)}{(\rho_{XX}^{*}-1)\rho_{XX}}}{k_predicted = (rel_desired * (rel_initial - 1)) / ((rel_desired - 1) * rel_initial)}

where \eqn{\rho_{XX}}{rel_initial} is the inital reliability, \eqn{\rho_{XX}^{*}}{rel_desired} is the predicted reliability of a measure with a different length, and \eqn{k^{*}}{k_predicted} is the number of times the measure would have to be lengthened to obtain a reliability equal to \eqn{\rho_{XX}^{*}}{rel_desired}.
}
\examples{
## Estimated k to achieve a reliability of .8 from a measure with an initial reliability of .7
estimate_length_sb(rel_initial = .7, rel_desired = .8)

## Estimated k to achieve a reliability of .8 from a measure with an initial reliability of .9
estimate_length_sb(rel_initial = .9, rel_desired = .8)
}
\references{
Ghiselli, E. E., Campbell, J. P., & Zedeck, S. (1981).
\emph{Measurement theory for the behavioral sciences}.
San Francisco, CA: Freeman. p. 236.
}
