% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lme_model_summary.R
\name{lme_multilevel_model_summary}
\alias{lme_multilevel_model_summary}
\title{Model Summary for Mixed Effect Model}
\usage{
lme_multilevel_model_summary(
  data,
  model = NULL,
  response_variable = NULL,
  random_effect_factors = NULL,
  non_random_effect_factors = NULL,
  two_way_interaction_factor = NULL,
  three_way_interaction_factor = NULL,
  family = NULL,
  cateogrical_var = NULL,
  id = NULL,
  graph_label_name = NULL,
  estimation_method = "REML",
  opt_control = "bobyqa",
  na.action = stats::na.omit,
  model_summary = TRUE,
  interaction_plot = TRUE,
  y_lim = NULL,
  plot_color = FALSE,
  digits = 3,
  use_package = "lmerTest",
  simple_slope = FALSE,
  assumption_plot = FALSE,
  quite = FALSE,
  streamline = FALSE,
  return_result = FALSE
)
}
\arguments{
\item{data}{\code{data.frame}}

\item{model}{\code{lme4} model syntax. Support more complicated model structure from \code{lme4}. It is not well-tested to ensure accuracy \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}}

\item{response_variable}{DV (i.e., outcome variable / response variable). Length of 1. Support \code{dplyr::select()} syntax.}

\item{random_effect_factors}{random effect factors (level-1 variable for HLM from a HLM perspective) Factors that need to estimate fixed effect and random effect (i.e., random slope / varying slope based on the id). Support \code{dplyr::select()} syntax.}

\item{non_random_effect_factors}{non-random effect factors (level-2 variable from a HLM perspective). Factors only need to estimate fixed effect. Support \code{dplyr::select()} syntax.}

\item{two_way_interaction_factor}{two-way interaction factors. You need to pass 2+ factor. Support \code{dplyr::select()} syntax.}

\item{three_way_interaction_factor}{three-way interaction factor. You need to pass exactly 3 factors. Specifying three-way interaction factors automatically included all two-way interactions, so please do not specify the two_way_interaction_factor argument. Support \code{dplyr::select()} syntax.}

\item{family}{a GLM family. It will passed to the family argument in glmer. See \code{?glmer} for possible options. \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}}

\item{cateogrical_var}{list. Specify the upper bound and lower bound directly instead of using ± 1 SD from the mean. Passed in the form of \code{list(var_name1 = c(upper_bound1, lower_bound1),var_name2 = c(upper_bound2, lower_bound2))}}

\item{id}{the nesting variable (e.g. group, time). Length of 1. Support \code{dplyr::select()} syntax.}

\item{graph_label_name}{optional vector or function. vector of length 2 for two-way interaction graph. vector of length 3 for three-way interaction graph. Vector should be passed in the form of c(response_var, predict_var1, predict_var2, ...). Function should be passed as a switch function (see ?two_way_interaction_plot for an example)}

\item{estimation_method}{character. \code{ML} or \code{REML} default is \code{REML}.}

\item{opt_control}{default is \code{optim} for \code{lme} and \code{bobyqa} for \code{lmerTest}.}

\item{na.action}{default is \code{stats::na.omit}. Another common option is \code{na.exclude}}

\item{model_summary}{print model summary.  Required to be \code{TRUE} if you want \code{assumption_plot}.}

\item{interaction_plot}{generate interaction plot. Default is \code{TRUE}}

\item{y_lim}{the plot's upper and lower limit for the y-axis. Length of 2. Example: \code{c(lower_limit, upper_limit)}}

\item{plot_color}{If it is set to \code{TRUE} (default is \code{FALSE}), the interaction plot will plot with color.}

\item{digits}{number of digits to round to}

\item{use_package}{Default is \code{lmerTest}. Only available for linear mixed effect model. Options are \code{nlme}, \code{lmerTest}, or \code{lme4}(\verb{'lme4} return similar result as \code{lmerTest} except the return model)}

\item{simple_slope}{Slope estimate at ± 1 SD and the mean of the moderator. Uses \code{interactions::sim_slope()} in the background.}

\item{assumption_plot}{Generate an panel of plots that check major assumptions. It is usually recommended to inspect model assumption violation visually. In the background, it calls \code{performance::check_model()}.}

\item{quite}{suppress printing output}

\item{streamline}{print streamlined output.}

\item{return_result}{If it is set to \code{TRUE} (default is \code{FALSE}), it will return the \code{model}, \code{model_summary}, and \code{plot} (\code{plot} if the interaction term is included)}
}
\value{
a list of all requested items in the order of model, model_summary, interaction_plot, simple_slope
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} \cr
An integrated function for fitting a multilevel linear regression (also known as hierarchical linear regression).
}
\examples{
fit <- lme_multilevel_model_summary(
  data = popular,
  response_variable = popular,
  random_effect_factors = NULL, # you can add random effect predictors here 
  non_random_effect_factors = c(extrav,texp),
  two_way_interaction_factor = NULL, # you can add two-way interaction plot here 
  graph_label_name = NULL, #you can also change graph lable name here
  id = class,
  simple_slope = FALSE, # you can also request simple slope estimate 
  assumption_plot = FALSE, # you can also request assumption plot
  plot_color = FALSE, # you can also request the plot in color
  streamline = FALSE # you can change this to get the least amount of info
)

}
