% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pspl_functions.R
\name{pspl_terms}
\alias{pspl_terms}
\alias{pspl}
\alias{pspt}
\title{Functions to include non-parametric continous covariates 
  and spatial or spatio-temporal trends in semiparametric
  regression models.}
\usage{
pspl(
  x,
  xl = min(x) - 0.01,
  xr = max(x) + 0.01,
  nknots = 10,
  bdeg = 3,
  pord = 2,
  decom = 2
)

pspt(
  sp1,
  sp2,
  time = NULL,
  scale = TRUE,
  ntime = NULL,
  xl_sp1 = min(sp1) - 0.01,
  xr_sp1 = max(sp1) + 0.01,
  xl_sp2 = min(sp2) - 0.01,
  xr_sp2 = max(sp2) + 0.01,
  xl_time = min(time) - 0.01,
  xr_time = max(time) + 0.01,
  nknots = c(10, 10, 5),
  bdeg = c(3, 3, 3),
  pord = c(2, 2, 2),
  decom = 1,
  psanova = FALSE,
  nest_sp1 = 1,
  nest_sp2 = 1,
  nest_time = 1,
  f1_main = TRUE,
  f2_main = TRUE,
  ft_main = TRUE,
  f12_int = TRUE,
  f1t_int = TRUE,
  f2t_int = TRUE,
  f12t_int = TRUE
)
}
\arguments{
\item{x}{Name of the covariate.}

\item{xl}{Minimum of the interval for the continuous covariate.
Default = min(x) - 0.01.}

\item{xr}{Maximum of the interval for the continuous covariate.
Default = max(x) - 0.01.}

\item{nknots}{Vector including the number of knots of each 
coordinate for spline bases. Default = c(10,10,5). The order of the knots
in the vector follows the order of the specified spatio-temporal parameters 
so the first value of the vector is the number of knots for \code{sp1}, the second
value is for \code{sp2} and the third for \code{time}. See \code{Examples}.}

\item{bdeg}{Order of the B-spline bases. Default = c(3,3,3).}

\item{pord}{Order of the penalty for the difference matrices 
in P-spline. Default = c(2,2,2).}

\item{decom}{Type of decomposition of fixed part when P-spline
term is expressed as a mixed model. If \code{decom = 1} the 
fixed part is given by \eqn{X = B*U_n} where \emph{B} is the
B-spline basis matrix and \emph{U_n} is the nullspace basis of the 
penalty matrix. If \code{decom = 2} the fixed part is given by
\eqn{X = [1|x|...|x^(pord-1)] }. Default = 2.}

\item{sp1}{Name of the first spatial coordinate.}

\item{sp2}{Name of the second spatial coordinate.}

\item{time}{Name of the temporal coordinate. It must be 
specified only for spatio-temporal trends when using panel data. 
Default = `NULL`.}

\item{scale}{Logical value to scale the spatial and temporal 
coordinates before the estimation of semiparametric model. 
Default = `TRUE`}

\item{ntime}{Number of temporal periods in panel data.}

\item{xl_sp1}{Minimum of the interval for the first spatial coordinate.
Default = min(sp1) - 0.01.}

\item{xr_sp1}{Maximum of the interval for the first spatial coordinate.
Default = max(sp1) + 0.01.}

\item{xl_sp2}{Minimum of the interval for the second spatial coordinate.
Default = min(sp2) - 0.01.}

\item{xr_sp2}{Maximum of the interval for the second spatial coordinate.
Default = max(sp2) + 0.01.}

\item{xl_time}{Minimum of the interval for the temporal coordinate.
Default = min(time) - 0.01.}

\item{xr_time}{Maximum of the interval for the temporal coordinate.
Default = max(time) + 0.01.}

\item{psanova}{Logical value to choose an ANOVA decomposition
of the spatial or spatio-temporal trend. Default = `FALSE`.
If `TRUE`, you must specify the divisors for
main, and interaction effects. More in \code{Examples}.}

\item{nest_sp1}{Vector including the divisor of the knots for main 
and interaction effects for the first spatial coordinate. It
is used for ANOVA decomposition models including nested bases.
Default = 1 (no nested bases). The values must be divisors and the resulting
value of the division should not be smaller than 4.}

\item{nest_sp2}{Vector including the divisor of the knots for main 
and interaction effects for the second spatial coordinate. It
is used for ANOVA decomposition models including nested bases.
Default = 1 (no nested bases). The values must be divisors and the resulting
value of the division should not be smaller than 4.}

\item{nest_time}{Vector including the divisor of the knots for main 
and interaction effects for the temporal coordinate. It
is used for ANOVA decomposition models including nested bases.
Default = 1 (no nested bases). The values must be divisors and the resulting
value of the division should not be smaller than 4.}

\item{f1_main}{Logical value to include main effect for the first spatial
coordinate in ANOVA models. Default = `TRUE`.}

\item{f2_main}{Logical value to include main effect for the second spatial
coordinate in ANOVA models. Default = `TRUE`.}

\item{ft_main}{Logical value to include main effect for the temporal
coordinate in ANOVA models. Default = `TRUE`.}

\item{f12_int}{Logical value to include second-order interaction effect 
between first and second spatial coordinates in ANOVA models. 
Default = `TRUE`.}

\item{f1t_int}{Logical value to include second-order interaction effect 
between first spatial and temporal coordinates in ANOVA 
models. Default = `TRUE`.}

\item{f2t_int}{Logical value to include second-order interaction effect 
between second spatial and temporal coordinates in ANOVA 
models. Default = `TRUE`.}

\item{f12t_int}{Logical value to include third-order interaction effect 
between first and second spatial coordinates and temporal 
coordinates in ANOVA models. Default = `TRUE`.}
}
\value{
\code{pspl()}: An object of class \emph{bs} including.
  \tabular{ll}{
    \code{B} \tab Matrix including B-spline basis for the covariate \cr
    \code{a} \tab List including \emph{nknots}, \emph{knots}, \emph{bdeg},
        \emph{pord} and \emph{decom}.  \cr
 }

\code{pspt()}: An object of class \emph{bs} including.
  \tabular{ll}{
     \code{B} \tab Matrix including B-spline basis for the covariate \cr
     \code{a} \tab List including \emph{sp1}, \emph{sp2}, \emph{time},
       \emph{nknots}, \emph{bdeg}, \emph{pord}, \emph{decom},
       \emph{psanova}, \emph{nest_sp1}, \emph{nest_sp2},
       \emph{nest_time}, \emph{f1_main}, \emph{f2_main}, \emph{ft_main},
       \emph{f12_int}, \emph{f1t_int}, \emph{f2t_int}, and 
       \emph{f12t_int}. \cr 
   }
}
\description{
The \code{pspl()} and \code{pspt()} functions 
  allow the inclusion of non-parametric continuous covariates
  and spatial or spatio-temporal trends in semiparametric 
  regression models. Both type of terms are modelled using P-splines.

\code{pspl()}: This function allows the inclusion of terms for
  non-parametric covariates in semiparametric models. 
  Each non-parametric covariate must be included with its own \code{pspl} 
  term in a formula.

\code{pspt()}: This function allows the inclusion of a spatial or
  spatio-temporal trend in the formula of the
  semiparametric spatial or spatio-temporal models. 
  The trend can be decomposed in an ANOVA
  functional way including main and interaction effects.
}
\examples{
library(pspatreg)
data(unemp_it)
## short sample for spatial pure case (2d)
unemp_it_short <- unemp_it[unemp_it$year == 2019, ]
 ######################  GAM pure
form1 <- unrate ~ partrate + agri + cons +
                 pspl(serv, nknots = 15) +
                 pspl(empgrowth, nknots = 20)
gampure <- pspatfit(form1, data = unemp_it_short)
summary(gampure)
#########  GAM pure with spatial non-parametric term
 \donttest{
 geosp1 <- pspatfit(form1, data = unemp_it_short)
 summary(geosp1)

 ###############################################
 ### Spatio-temporal semiparametric ANOVA model 
 ### Interaction terms f12,f1t,f2t and f12t with nested basis
 ### Remark: nest_sp1, nest_sp2 and nest_time must be divisors of nknots
 
 form2 <- unrate ~ partrate + agri + cons +
                   pspl(serv, nknots = 15) + 
                   pspl(empgrowth, nknots = 20) +
                   pspt(long, lat, year, 
                        nknots = c(18, 18, 8), 
                        psanova = TRUE, 
                        nest_sp1 = c(1, 2, 2), 
                        nest_sp2 = c(1, 2, 2),
                        nest_time = c(1, 2, 2))
 sptanova <- pspatfit(form2, data = unemp_it)
 summary(sptanova)
 

 ################################################  
 ### Interaction terms f1t not included in ANOVA decomposition
 form3 <- unrate ~ partrate + agri + cons +
                   pspl(serv, nknots = 15) + 
                   pspl(empgrowth, nknots=20) +
                   pspt(long, lat, year, 
                        nknots = c(18, 18, 8),
                        psanova = TRUE, 
                        nest_sp1 = c(1, 2, 3), 
                        nest_sp2 = c(1, 2, 3),
                        nest_time = c(1, 2, 2), 
                        f1t_int = FALSE)
 sptanova2 <- pspatfit(form3, data = unemp_it)
 summary(sptanova2)
 }
}
\references{
\itemize{ 
    \item Eilers, P. and Marx, B. (1996). Flexible Smoothing with 
      B-Splines and Penalties. \emph{Statistical Science}, (11), 89-121.
    
    \item Eilers, P. and Marx, B. (2021). \emph{Practical Smoothing. 
      The Joys of P-Splines}. Cambridge University Press.
    
    \item Fahrmeir, L.; Kneib, T.;  Lang, S.; and Marx, B. (2021). 
      \emph{Regression. Models, Methods and Applications (2nd Ed.)}.
      Springer.

    \item Lee, D. and Durban, M. (2011). P-Spline ANOVA Type Interaction 
      Models for Spatio-Temporal Smoothing. \emph{Statistical Modelling}, 
      (11), 49-69. <doi:10.1177/1471082X1001100104>

    \item Lee, D. J., Durban, M., and Eilers, P. (2013). Efficient
      two-dimensional smoothing with P-spline ANOVA mixed models 
      and nested bases. \emph{Computational Statistics & Data Analysis}, 
      (61), 22-37. <doi:10.1016/j.csda.2012.11.013>

    \item Minguez, R.; Basile, R. and Durban, M. (2020). An Alternative 
      Semiparametric Model for Spatial Panel Data. \emph{Statistical Methods and Applications},
      (29), 669-708. <doi:	10.1007/s10260-019-00492-8>
    
    \item Wood, S.N. (2017). \emph{Generalized Additive Models. 
      An Introduction with \code{R}} (second edition). CRC Press, Boca Raton.
}
}
\seealso{
\code{\link{pspatfit}} estimate semiparametric spatial or
   spatio-temporal regression models.
}
